/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import kafka.utils.MockTime;
import kafka.utils.timer.MockTimer$;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u0013\tIQj\\2l)&lWM\u001d\u0006\u0003\u0007\u0011\tQ\u0001^5nKJT!!\u0002\u0004\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0015A\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005\u0015!\u0016.\\3s\u0011!)\u0002A!b\u0001\n\u00031\u0012\u0001\u0002;j[\u0016,\u0012a\u0006\t\u00031ei\u0011\u0001B\u0005\u00035\u0011\u0011\u0001\"T8dWRKW.\u001a\u0005\t9\u0001\u0011\t\u0011)A\u0005/\u0005)A/[7fA!)a\u0004\u0001C\u0001?\u00051A(\u001b8jiz\"\"\u0001I\u0011\u0011\u0005E\u0001\u0001bB\u000b\u001e!\u0003\u0005\ra\u0006\u0005\bG\u0001\u0011\r\u0011\"\u0003%\u0003%!\u0018m]6Rk\u0016,X-F\u0001&!\r13&L\u0007\u0002O)\u0011\u0001&K\u0001\b[V$\u0018M\u00197f\u0015\tQC\"\u0001\u0006d_2dWm\u0019;j_:L!\u0001L\u0014\u0003\u001bA\u0013\u0018n\u001c:jif\fV/Z;f!\t\tb&\u0003\u00020\u0005\tqA+[7feR\u000b7o[#oiJL\bBB\u0019\u0001A\u0003%Q%\u0001\u0006uCN\\\u0017+^3vK\u0002BQa\r\u0001\u0005\u0002Q\n1!\u00193e)\t)\u0004\b\u0005\u0002\fm%\u0011q\u0007\u0004\u0002\u0005+:LG\u000fC\u0003:e\u0001\u0007!(A\u0005uS6,'\u000fV1tWB\u0011\u0011cO\u0005\u0003y\t\u0011\u0011\u0002V5nKJ$\u0016m]6\t\u000by\u0002A\u0011A \u0002\u0019\u0005$g/\u00198dK\u000ecwnY6\u0015\u0005\u0001\u001b\u0005CA\u0006B\u0013\t\u0011EBA\u0004C_>dW-\u00198\t\u000b\u0011k\u0004\u0019A#\u0002\u0013QLW.Z8vi6\u001b\bCA\u0006G\u0013\t9EB\u0001\u0003M_:<\u0007\"B%\u0001\t\u0003Q\u0015\u0001B:ju\u0016,\u0012a\u0013\t\u0003\u00171K!!\u0014\u0007\u0003\u0007%sG\u000fC\u0003P\u0001\u0011\u0005\u0003+\u0001\u0005tQV$Hm\\<o)\u0005)ta\u0002*\u0003\u0003\u0003E\taU\u0001\n\u001b>\u001c7\u000eV5nKJ\u0004\"!\u0005+\u0007\u000f\u0005\u0011\u0011\u0011!E\u0001+N\u0011AK\u0003\u0005\u0006=Q#\ta\u0016\u000b\u0002'\"9\u0011\fVI\u0001\n\u0003Q\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'F\u0001\\U\t9BlK\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-A\u0005v]\u000eDWmY6fI*\u0011!\rD\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00013`\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class MockTimer
implements Timer {
    private final MockTime time;
    private final PriorityQueue<TimerTaskEntry> taskQueue;

    public static MockTime $lessinit$greater$default$1() {
        return MockTimer$.MODULE$.$lessinit$greater$default$1();
    }

    public MockTime time() {
        return this.time;
    }

    private PriorityQueue<TimerTaskEntry> taskQueue() {
        return this.taskQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(TimerTask timerTask) {
        if (timerTask.delayMs() <= 0L) {
            timerTask.run();
            return;
        }
        PriorityQueue<TimerTaskEntry> priorityQueue = this.taskQueue();
        synchronized (priorityQueue) {
            this.taskQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimerTaskEntry[]{new TimerTaskEntry(timerTask, timerTask.delayMs() + this.time().milliseconds())}));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean advanceClock(long timeoutMs) {
        this.time().sleep(timeoutMs);
        BooleanRef executed = BooleanRef.create((boolean)false);
        long now = this.time().milliseconds();
        boolean hasMore = true;
        while (hasMore) {
            None$ none$;
            hasMore = false;
            PriorityQueue<TimerTaskEntry> priorityQueue = this.taskQueue();
            synchronized (priorityQueue) {
                None$ none$2;
                if (this.taskQueue().nonEmpty() && now > ((TimerTaskEntry)this.taskQueue().head()).expirationMs()) {
                    Some entry = new Some(this.taskQueue().dequeue());
                    hasMore = this.taskQueue().nonEmpty();
                    none$2 = entry;
                } else {
                    none$2 = None$.MODULE$;
                }
                none$ = none$2;
            }
            Option head = (Option)none$;
            head.foreach((Function1)new Serializable(this, executed){
                public static final long serialVersionUID = 0L;
                private final BooleanRef executed$1;

                public final void apply(TimerTaskEntry taskEntry) {
                    if (!taskEntry.cancelled()) {
                        TimerTask task = taskEntry.timerTask();
                        task.run();
                        this.executed$1.elem = true;
                    }
                }
                {
                    this.executed$1 = executed$1;
                }
            });
        }
        return executed.elem;
    }

    public int size() {
        return this.taskQueue().size();
    }

    public void shutdown() {
    }

    public MockTimer(MockTime time) {
        this.time = time;
        this.taskQueue = (PriorityQueue)PriorityQueue$.MODULE$.apply((Seq)Nil$.MODULE$, package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).reverse());
    }
}

