/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.zk.AclChangeNode;
import kafka.zk.ExtendedAclStore;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u000f\t!R\t\u001f;f]\u0012,G-Q2m'R|'/\u001a+fgRT!a\u0001\u0003\u0002\u0005i\\'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0010Y&$XM]1m%\u0016\u001cx.\u001e:dKV\ta\u0003\u0005\u0002\u0018C5\t\u0001D\u0003\u0002\u001a5\u0005A!/Z:pkJ\u001cWM\u0003\u0002\u001c9\u000511m\\7n_:T!!B\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ea\u0011qBU3t_V\u00148-\u001a)biR,'O\u001c\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\f\u0002!1LG/\u001a:bYJ+7o\\;sG\u0016\u0004\u0003b\u0002\u0014\u0001\u0005\u0004%I!F\u0001\u0011aJ,g-\u001b=fIJ+7o\\;sG\u0016Da\u0001\u000b\u0001!\u0002\u00131\u0012!\u00059sK\u001aL\u00070\u001a3SKN|WO]2fA!9!\u0006\u0001b\u0001\n\u0013Y\u0013!B:u_J,W#\u0001\u0017\u0011\u0005Ii\u0013B\u0001\u0018\u0003\u0005A)\u0005\u0010^3oI\u0016$\u0017i\u00197Ti>\u0014X\r\u0003\u00041\u0001\u0001\u0006I\u0001L\u0001\u0007gR|'/\u001a\u0011\t\u000bI\u0002A\u0011A\u001a\u0002-MDw.\u001e7e\u0011\u00064XmQ8se\u0016\u001cG\u000fU1uQN$\u0012\u0001\u000e\t\u0003\u0013UJ!A\u000e\u0006\u0003\tUs\u0017\u000e\u001e\u0015\u0003ca\u0002\"!\u000f\u001f\u000e\u0003iR!aO\u0010\u0002\u000b),h.\u001b;\n\u0005uR$\u0001\u0002+fgRDQa\u0010\u0001\u0005\u0002M\nAd\u001d5pk2$\u0007*\u0019<f\u0007>\u0014(/Z2u!\u0006$H/\u001a:o)f\u0004X\r\u000b\u0002?q!)!\t\u0001C\u0001g\u0005\u00193\u000f[8vY\u0012$\u0006N]8x\u0013\u001a\u001cuN\\:ueV\u001cG/\u001a3XSRDG*\u001b;fe\u0006d\u0007\u0006B!9\t\u0016\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002\rB\u0011qi\u0014\b\u0003\u00116s!!\u0013'\u000e\u0003)S!a\u0013\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011B\u0001(\u000b\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001U)\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gN\u0003\u0002O\u0015!)1\u000b\u0001C\u0001g\u0005q2\u000f[8vY\u0012$\u0006N]8x\rJ|W.\u00128d_\u0012,wJ\u001c'ji\u0016\u0014\u0018\r\u001c\u0015\u0005%b\"U\tC\u0003W\u0001\u0011\u00051'\u0001\u0011tQ>,H\u000eZ,sSR,7\t[1oO\u0016\u001cHk\u001c+iK^\u0013\u0018\u000e^3QCRD\u0007FA+9\u0011\u0015I\u0006\u0001\"\u00014\u0003e\u0019\bn\\;mIJ{WO\u001c3Ue&\u00048\t[1oO\u0016tu\u000eZ3)\u0005aC\u0004")
public class ExtendedAclStoreTest {
    private final ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, "some-topic", PatternType.LITERAL);
    private final ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "some-topic", PatternType.PREFIXED);
    private final ExtendedAclStore store = new ExtendedAclStore(PatternType.PREFIXED);

    private ResourcePattern literalResource() {
        return this.literalResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ExtendedAclStore store() {
        return this.store;
    }

    @Test
    public void shouldHaveCorrectPaths() {
        Assert.assertEquals((Object)"/kafka-acl-extended/prefixed", (Object)this.store().aclPath());
        Assert.assertEquals((Object)"/kafka-acl-extended/prefixed/Topic", (Object)this.store().path(ResourceType.TOPIC));
        Assert.assertEquals((Object)"/kafka-acl-extended-changes", (Object)this.store().changeStore().aclChangePath());
    }

    @Test
    public void shouldHaveCorrectPatternType() {
        Assert.assertEquals((Object)PatternType.PREFIXED, (Object)this.store().patternType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfConstructedWithLiteral() {
        new ExtendedAclStore(PatternType.LITERAL);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowFromEncodeOnLiteral() {
        this.store().changeStore().createChangeNode(this.literalResource());
    }

    @Test
    public void shouldWriteChangesToTheWritePath() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.prefixedResource());
        Assert.assertEquals((Object)"/kafka-acl-extended-changes/acl_changes_", (Object)changeNode.path());
    }

    @Test
    public void shouldRoundTripChangeNode() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.prefixedResource());
        ResourcePattern actual = this.store().changeStore().decode(changeNode.bytes());
        Assert.assertEquals((Object)this.prefixedResource(), (Object)actual);
    }
}

