/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.nio.charset.StandardCharsets;
import kafka.security.authorizer.AclEntry$;
import kafka.zk.AclChangeNode;
import kafka.zk.LiteralAclStore$;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u000f\t\u0019B*\u001b;fe\u0006d\u0017i\u00197Ti>\u0014X\rV3ti*\u00111\u0001B\u0001\u0003u.T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013%Q#A\bmSR,'/\u00197SKN|WO]2f+\u00051\u0002CA\f\"\u001b\u0005A\"BA\r\u001b\u0003!\u0011Xm]8ve\u000e,'BA\u000e\u001d\u0003\u0019\u0019w.\\7p]*\u0011Q!\b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014x-\u0003\u0002#1\ty!+Z:pkJ\u001cW\rU1ui\u0016\u0014h\u000e\u0003\u0004%\u0001\u0001\u0006IAF\u0001\u0011Y&$XM]1m%\u0016\u001cx.\u001e:dK\u0002BqA\n\u0001C\u0002\u0013%Q#\u0001\tqe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\"1\u0001\u0006\u0001Q\u0001\nY\t\u0011\u0003\u001d:fM&DX\r\u001a*fg>,(oY3!\u0011\u001dQ\u0003A1A\u0005\n-\nQa\u001d;pe\u0016,\u0012\u0001\f\b\u0003%5J!A\f\u0002\u0002\u001f1KG/\u001a:bY\u0006\u001bGn\u0015;pe\u0016Da\u0001\r\u0001!\u0002\u0013a\u0013AB:u_J,\u0007\u0005C\u00033\u0001\u0011\u00051'\u0001\ftQ>,H\u000e\u001a%bm\u0016\u001cuN\u001d:fGR\u0004\u0016\r\u001e5t)\u0005!\u0004CA\u00056\u0013\t1$B\u0001\u0003V]&$\bFA\u00199!\tID(D\u0001;\u0015\tYt$A\u0003kk:LG/\u0003\u0002>u\t!A+Z:u\u0011\u0015y\u0004\u0001\"\u00014\u0003q\u0019\bn\\;mI\"\u000bg/Z\"peJ,7\r\u001e)biR,'O\u001c+za\u0016D#A\u0010\u001d\t\u000b\t\u0003A\u0011A\u001a\u0002EMDw.\u001e7e)\"\u0014xn\u001e$s_6,enY8eK>sgj\u001c8f\u0019&$XM]1mQ\u0011\t\u0005\bR#\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013A\u0012\t\u0003\u000f>s!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-3\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tq%\"A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u0011aJ\u0003\u0005\u0006'\u0002!\taM\u0001!g\"|W\u000f\u001c3Xe&$Xm\u00115b]\u001e,7\u000fV8UQ\u0016<&/\u001b;f!\u0006$\b\u000e\u000b\u0002Sq!)a\u000b\u0001C\u0001g\u0005I2\u000f[8vY\u0012\u0014v.\u001e8e)JL\u0007o\u00115b]\u001e,gj\u001c3fQ\t)\u0006\bC\u0003Z\u0001\u0011\u00051'A\u0013tQ>,H\u000e\u001a#fG>$WMU3t_V\u00148-Z+tS:<Gk^8QCJ$Hj\\4jG\"\u0012\u0001\f\u000f")
public class LiteralAclStoreTest {
    private final ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, "some-topic", PatternType.LITERAL);
    private final ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "some-topic", PatternType.PREFIXED);
    private final LiteralAclStore$ store = LiteralAclStore$.MODULE$;

    private ResourcePattern literalResource() {
        return this.literalResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private LiteralAclStore$ store() {
        return this.store;
    }

    @Test
    public void shouldHaveCorrectPaths() {
        Assert.assertEquals((Object)"/kafka-acl", (Object)this.store().aclPath());
        Assert.assertEquals((Object)"/kafka-acl/Topic", (Object)this.store().path(ResourceType.TOPIC));
        Assert.assertEquals((Object)"/kafka-acl-changes", (Object)this.store().changeStore().aclChangePath());
    }

    @Test
    public void shouldHaveCorrectPatternType() {
        Assert.assertEquals((Object)PatternType.LITERAL, (Object)this.store().patternType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowFromEncodeOnNoneLiteral() {
        this.store().changeStore().createChangeNode(this.prefixedResource());
    }

    @Test
    public void shouldWriteChangesToTheWritePath() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.literalResource());
        Assert.assertEquals((Object)"/kafka-acl-changes/acl_changes_", (Object)changeNode.path());
    }

    @Test
    public void shouldRoundTripChangeNode() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.literalResource());
        ResourcePattern actual = this.store().changeStore().decode(changeNode.bytes());
        Assert.assertEquals((Object)this.literalResource(), (Object)actual);
    }

    @Test
    public void shouldDecodeResourceUsingTwoPartLogic() {
        ResourcePattern resource = new ResourcePattern(ResourceType.GROUP, "PREFIXED:this, including the PREFIXED part, is a valid two part group name", PatternType.LITERAL);
        byte[] encoded = new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)resource.resourceType()), AclEntry$.MODULE$.ResourceSeparator())).append((Object)resource.name()).toString().getBytes(StandardCharsets.UTF_8);
        ResourcePattern actual = this.store().changeStore().decode(encoded);
        Assert.assertEquals((Object)resource, (Object)actual);
    }
}

