/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.cluster;

import java.io.File;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.PartitionStateStore;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0001\u0003\u0001%\u0011Q#\u00112tiJ\f7\r\u001e)beRLG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(BA\u0003\u0007\u0003\u0015Y\u0017MZ6b\u0015\u00059\u0011\u0001B;oSR\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"\u0001\u0002\t\u000fY\u0001!\u0019!C\u0001/\u0005A!M]8lKJLE-F\u0001\u0019!\tY\u0011$\u0003\u0002\u001b\u0019\t\u0019\u0011J\u001c;\t\rq\u0001\u0001\u0015!\u0003\u0019\u0003%\u0011'o\\6fe&#\u0007\u0005C\u0004\u001f\u0001\t\u0007I\u0011A\u0010\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t\u0001\u0005\u0005\u0002\"S5\t!E\u0003\u0002$I\u000511m\\7n_:T!!B\u0013\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0005\u0003U\t\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004-\u0001\u0001\u0006I\u0001I\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA!9a\u0006\u0001b\u0001\n\u0003y\u0013\u0001\u0002;j[\u0016,\u0012\u0001\r\t\u0003cUj\u0011A\r\u0006\u0003gQ\nQ!\u001e;jYNT\u0011!B\u0005\u0003mI\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007q\u0001\u0001\u000b\u0011\u0002\u0019\u0002\u000bQLW.\u001a\u0011\t\u0013i\u0002\u0001\u0019!a\u0001\n\u0003Y\u0014A\u0002;na\u0012K'/F\u0001=!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0002j_*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"?\u0005\u00111\u0015\u000e\\3\t\u0013\u0015\u0003\u0001\u0019!a\u0001\n\u00031\u0015A\u0003;na\u0012K'o\u0018\u0013fcR\u0011qI\u0013\t\u0003\u0017!K!!\u0013\u0007\u0003\tUs\u0017\u000e\u001e\u0005\b\u0017\u0012\u000b\t\u00111\u0001=\u0003\rAH%\r\u0005\u0007\u001b\u0002\u0001\u000b\u0015\u0002\u001f\u0002\u000fQl\u0007\u000fR5sA!Iq\n\u0001a\u0001\u0002\u0004%\taO\u0001\bY><G)\u001b:2\u0011%\t\u0006\u00011AA\u0002\u0013\u0005!+A\u0006m_\u001e$\u0015N]\u0019`I\u0015\fHCA$T\u0011\u001dY\u0005+!AA\u0002qBa!\u0016\u0001!B\u0013a\u0014\u0001\u00037pO\u0012K'/\r\u0011\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003Y\u0014a\u00027pO\u0012K'O\r\u0005\n3\u0002\u0001\r\u00111A\u0005\u0002i\u000b1\u0002\\8h\t&\u0014(g\u0018\u0013fcR\u0011qi\u0017\u0005\b\u0017b\u000b\t\u00111\u0001=\u0011\u0019i\u0006\u0001)Q\u0005y\u0005AAn\\4ESJ\u0014\u0004\u0005C\u0005`\u0001\u0001\u0007\t\u0019!C\u0001A\u0006QAn\\4NC:\fw-\u001a:\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u001b\u0002\u00071|w-\u0003\u0002gG\nQAj\\4NC:\fw-\u001a:\t\u0013!\u0004\u0001\u0019!a\u0001\n\u0003I\u0017A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0003\u000f*DqaS4\u0002\u0002\u0003\u0007\u0011\r\u0003\u0004m\u0001\u0001\u0006K!Y\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005C\u0005o\u0001\u0001\u0007\t\u0019!C\u0001_\u0006IAn\\4D_:4\u0017nZ\u000b\u0002aB\u0011!-]\u0005\u0003e\u000e\u0014\u0011\u0002T8h\u0007>tg-[4\t\u0013Q\u0004\u0001\u0019!a\u0001\n\u0003)\u0018!\u00047pO\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0002Hm\"91j]A\u0001\u0002\u0004\u0001\bB\u0002=\u0001A\u0003&\u0001/\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002BqA\u001f\u0001C\u0002\u0013\u000510\u0001\u0006ti\u0006$Xm\u0015;pe\u0016,\u0012\u0001 \t\u0003{~l\u0011A \u0006\u0003\u0007QJ1!!\u0001\u007f\u0005M\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cFo\u001c:f\u0011\u001d\t)\u0001\u0001Q\u0001\nq\f1b\u001d;bi\u0016\u001cFo\u001c:fA!I\u0011\u0011\u0002\u0001C\u0002\u0013\u0005\u00111B\u0001\u0012I\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u001cXCAA\u0007!\ri\u0018qB\u0005\u0004\u0003#q(!\u0005#fY\u0006LX\rZ(qKJ\fG/[8og\"A\u0011Q\u0003\u0001!\u0002\u0013\ti!\u0001\neK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]N\u0004\u0003\"CA\r\u0001\t\u0007I\u0011AA\u000e\u00035iW\r^1eCR\f7)Y2iKV\u0011\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u0005\u001b\u0002\rM,'O^3s\u0013\u0011\t9#!\t\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!\tY\u0003\u0001Q\u0001\n\u0005u\u0011AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\n\u0003_\u0001!\u0019!C\u0001\u0003c\t\u0011c\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;t+\t\t\u0019\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\u0011\tI$!\t\u0002\u0017\rDWmY6q_&tGo]\u0005\u0005\u0003{\t9DA\tPM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oiND\u0001\"!\u0011\u0001A\u0003%\u00111G\u0001\u0013_\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R\u001c\b\u0005C\u0006\u0002F\u0001\u0001\r\u00111A\u0005\u0002\u0005\u001d\u0013!\u00039beRLG/[8o+\t\tI\u0005E\u0002~\u0003\u0017J1!!\u0014\u007f\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0006\u0002R\u0001\u0001\r\u00111A\u0005\u0002\u0005M\u0013!\u00049beRLG/[8o?\u0012*\u0017\u000fF\u0002H\u0003+B\u0011bSA(\u0003\u0003\u0005\r!!\u0013\t\u0011\u0005e\u0003\u0001)Q\u0005\u0003\u0013\n!\u0002]1si&$\u0018n\u001c8!\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\nQa]3ukB$\u0012a\u0012\u0015\u0005\u00037\n\u0019\u0007\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tIgJ\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003[\n9G\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003c\u0002A\u0011AA:\u0003M\u0019'/Z1uK2{w\r\u0015:pa\u0016\u0014H/[3t)\u0011\t)(!!\u0011\t\u0005]\u0014QP\u0007\u0003\u0003sR1!a\u001fA\u0003\u0011)H/\u001b7\n\t\u0005}\u0014\u0011\u0010\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\u0002CAB\u0003_\u0002\r!!\"\u0002\u0013=4XM\u001d:jI\u0016\u001c\b\u0003CAD\u0003\u001b\u000b\u0019*a%\u000f\u0007-\tI)C\u0002\u0002\f2\ta\u0001\u0015:fI\u00164\u0017\u0002BAH\u0003#\u00131!T1q\u0015\r\tY\t\u0004\t\u0005\u0003\u000f\u000b)*\u0003\u0003\u0002\u0018\u0006E%AB*ue&tw\rC\u0004\u0002\u001c\u0002!\t!a\u0018\u0002\u0011Q,\u0017M\u001d#po:DC!!'\u0002 B!\u0011QMAQ\u0013\u0011\t\u0019+a\u001a\u0003\u000b\u00053G/\u001a:")
public class AbstractPartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private LogManager logManager;
    private LogConfig logConfig;
    private final PartitionStateStore stateStore = (PartitionStateStore)Mockito.mock(PartitionStateStore.class);
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public PartitionStateStore stateStore() {
        return this.stateStore;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @Before
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        int x$9 = CleanerConfig$.MODULE$.apply$default$9();
        String x$10 = CleanerConfig$.MODULE$.apply$default$10();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9, x$10), this.time(), TestUtils$.MODULE$.createLogManager$default$5()));
        this.logManager().startup();
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), this.logManager(), (Option)None$.MODULE$));
        Mockito.when((Object)this.stateStore().fetchTopicConfig()).thenReturn((Object)this.createLogProperties((Map<String, String>)Predef$.MODULE$.Map().empty()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public Properties createLogProperties(Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1)new Serializable(this, logProps){
            public static final long serialVersionUID = 0L;
            private final Properties logProps$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.logProps$1.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.logProps$1 = logProps$1;
            }
        });
        return var2_2;
    }

    @After
    public void tearDown() {
        if (this.tmpDir().exists()) {
            this.logManager().shutdown();
            Utils.delete((File)this.tmpDir());
            TestUtils$.MODULE$.clearYammerMetrics();
        }
    }

    public AbstractPartitionTest() {
        this.brokerId = 101;
    }
}

