/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.controller;

import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import unit.kafka.controller.ControllerContextTest$;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001%\u0011QcQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0005\u00151\u0011!B6bM.\f'\"A\u0004\u0002\tUt\u0017\u000e^\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001A\u0002\u0013\u0005q#A\u0004d_:$X\r\u001f;\u0016\u0003a\u0001\"!\u0007\u000f\u000e\u0003iQ!aA\u000e\u000b\u0003\u0015I!!\b\u000e\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000fC\u0004 \u0001\u0001\u0007I\u0011\u0001\u0011\u0002\u0017\r|g\u000e^3yi~#S-\u001d\u000b\u0003C\u0011\u0002\"a\u0003\u0012\n\u0005\rb!\u0001B+oSRDq!\n\u0010\u0002\u0002\u0003\u0007\u0001$A\u0002yIEBaa\n\u0001!B\u0013A\u0012\u0001C2p]R,\u0007\u0010\u001e\u0011\t\u000f%\u0002!\u0019!C\u0001U\u00059!M]8lKJ\u001cX#A\u0016\u0011\u00071\"tG\u0004\u0002.e9\u0011a&M\u0007\u0002_)\u0011\u0001\u0007C\u0001\u0007yI|w\u000e\u001e \n\u00035I!a\r\u0007\u0002\u000fA\f7m[1hK&\u0011QG\u000e\u0002\u0004'\u0016\f(BA\u001a\r!\tY\u0001(\u0003\u0002:\u0019\t\u0019\u0011J\u001c;\t\rm\u0002\u0001\u0015!\u0003,\u0003!\u0011'o\\6feN\u0004\u0003bB\u001f\u0001\u0005\u0004%\tAP\u0001\u0004iB\fT#A \u0011\u0005\u0001CU\"A!\u000b\u0005\t\u001b\u0015AB2p[6|gN\u0003\u0002\u0006\t*\u0011QIR\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tI\u0015I\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r-\u0003\u0001\u0015!\u0003@\u0003\u0011!\b/\r\u0011\t\u000f5\u0003!\u0019!C\u0001}\u0005\u0019A\u000f\u001d\u001a\t\r=\u0003\u0001\u0015!\u0003@\u0003\u0011!\bO\r\u0011\t\u000fE\u0003!\u0019!C\u0001}\u0005\u0019A\u000f]\u001a\t\rM\u0003\u0001\u0015!\u0003@\u0003\u0011!\bo\r\u0011\t\u000bU\u0003A\u0011\u0001,\u0002\u000bM,G/\u00169\u0015\u0003\u0005B#\u0001\u0016-\u0011\u0005ecV\"\u0001.\u000b\u0005m3\u0015!\u00026v]&$\u0018BA/[\u0005\u0019\u0011UMZ8sK\")q\f\u0001C\u0001-\u0006\u0001E/Z:u+B$\u0017\r^3QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG/\u00169eCR,7OU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u001f:d\u0017\u0010\u000b\u0002_CB\u0011\u0011LY\u0005\u0003Gj\u0013A\u0001V3ti\")Q\r\u0001C\u0001-\u0006\u0001E/Z:u+B$\u0017\r^3QCJ$\u0018\u000e^5p]\u001a+H\u000e\u001c*fa2L7-Y!tg&<g.\\3oiV\u0003H-\u0019;fgJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0002eC\")\u0001\u000e\u0001C\u0001-\u0006YE/Z:u!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e*fiV\u0014hn]#naRL8+Z9JMR{\u0007/[2PeB\u000b'\u000f^5uS>tGi\\3t\u001d>$X\t_5ti\"\u0012q-\u0019\u0005\u0006W\u0002!\tAV\u0001Wi\u0016\u001cH\u000fU1si&$\u0018n\u001c8Gk2d'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;SKR,(O\\:F[B$\u00180Q:tS\u001etW.\u001a8u\u0013\u001a$v\u000e]5d\u001fJ\u0004\u0016M\u001d;ji&|g\u000eR8fg:{G/\u0012=jgRD#A[1\t\u000b9\u0004A\u0011\u0001,\u0002\u0011R,7\u000f\u001e)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$hi\u001c:U_BL7MU3ukJt7/R7qifl\u0015\r]%g)>\u0004\u0018n\u0019#pKNtu\u000e^#ySN$\bFA7b\u0011\u0015\t\b\u0001\"\u0001W\u0003\u001d#Xm\u001d;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tGOR8s)>\u0004\u0018n\u0019*fiV\u0014hn]#ya\u0016\u001cG/\u001a3SKBd\u0017nY1BgNLwM\\7f]R\u001c\bF\u00019b\u0011\u0015!\b\u0001\"\u0001W\u0003y!Xm\u001d;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0002tC\")q\u000f\u0001C\u0001-\u0006IC/Z:u%\u0016\f7o]5h]6,g\u000e\u001e$s_6|%m]3sm\u0016\u0014Hk\\*z]\u000e\u0014V\r\u001d7jG\u0006D#A^1\t\u000bi\u0004A\u0011\u0001,\u00021Q,7\u000f\u001e*f[>4\u0018\r\\(g'ft7MU3qY&\u001c\u0017\r\u000b\u0002zC\")Q\u0010\u0001C\u0001-\u0006)B/Z:u%\u0016lwN^1m\u001f\u001a|%m]3sm\u0016\u0014\bF\u0001?b\u0011\u0019\t\t\u0001\u0001C\u0001-\u0006\u0019D/Z:u%\u0016lwN^1m\u001f\u001a|%m]3sm\u0016\u0014\u0018I\u001c3NC.,7+\u001f8d%\u0016\u0004H.[2b\u0013:$xn\u00142tKJ4XM\u001d\u0015\u0003\u007f\u0006Da!a\u0002\u0001\t\u00031\u0016!\u000b;fgR\u0014V-\\8wC2|emU=oGJ+\u0007\u000f\\5dC\u0006sGm\u00142tKJ4XM]\"iC:<W\rK\u0002\u0002\u0006\u0005Da!!\u0004\u0001\t\u00031\u0016!\f;fgR\u0014V-Y:tS\u001etW.\u001a8u'^\f\u0007o](cg\u0016\u0014h/\u001a:t\u0003:$7+\u001f8d%\u0016\u0004H.[2bg\"\u001a\u00111B1\t\r\u0005M\u0001\u0001\"\u0001W\u00039!Xm\u001d;SK\u0006\u001c8/[4o)>D3!!\u0005b\u0011\u0019\tI\u0002\u0001C\u0001-\u0006\u0019C/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006LUNY1mC:\u001cW-T3ue&\u001c\u0007fAA\fC\u0002")
public class ControllerContextTest {
    private ControllerContext context = null;
    private final Seq<Object> brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
    private final TopicPartition tp1 = new TopicPartition("A", 0);
    private final TopicPartition tp2 = new TopicPartition("A", 1);
    private final TopicPartition tp3 = new TopicPartition("B", 0);

    public ControllerContext context() {
        return this.context;
    }

    public void context_$eq(ControllerContext x$1) {
        this.context = x$1;
    }

    public Seq<Object> brokers() {
        return this.brokers;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public TopicPartition tp3() {
        return this.tp3;
    }

    @Before
    public void setUp() {
        this.context_$eq(new ControllerContext());
        scala.collection.immutable.Map brokerEpochs = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Broker, Object> apply(int brokerId) {
                EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(brokerId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L));
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.context().setLiveBrokerAndEpochs((Map)brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.tp2(), this.tp3()}))).foreach((Function1)new Serializable(this, leaderIndex){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerContextTest $outer;
            public final IntRef leaderIndex$1;

            public final void apply(TopicPartition partition) {
                IndexedSeq replicas = (IndexedSeq)this.$outer.brokers().indices().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$setUp$1 $outer;

                    public final int apply(int i) {
                        return this.apply$mcII$sp(i);
                    }

                    public int apply$mcII$sp(int i) {
                        return BoxesRunTime.unboxToInt((Object)this.$outer.unit$kafka$controller$ControllerContextTest$$anonfun$$$outer().brokers().apply((i + this.$outer.leaderIndex$1.elem) % this.$outer.unit$kafka$controller$ControllerContextTest$$anonfun$$$outer().brokers().size()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                this.$outer.context().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas, (Seq)Seq$.MODULE$.empty()));
                ++this.leaderIndex$1.elem;
            }

            public /* synthetic */ ControllerContextTest unit$kafka$controller$ControllerContextTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderIndex$1 = leaderIndex$1;
            }
        });
    }

    @Test
    public void testUpdatePartitionReplicaAssignmentUpdatesReplicaAssignmentOnly() {
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply(expectedReplicas, (Seq)Seq$.MODULE$.empty()));
        Seq assignment2 = this.context().partitionReplicaAssignment(this.tp1());
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assert.assertEquals((Object)expectedReplicas, (Object)assignment2);
        Assert.assertEquals((Object)expectedReplicas, (Object)fullAssignment.replicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)fullAssignment.addingReplicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)fullAssignment.removingReplicas());
    }

    @Test
    public void testUpdatePartitionFullReplicaAssignmentUpdatesReplicaAssignment() {
        Seq initialReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply(initialReplicas, (Seq)Seq$.MODULE$.empty()));
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assert.assertEquals((Object)initialReplicas, (Object)fullAssignment.replicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)fullAssignment.addingReplicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)fullAssignment.removingReplicas());
        ReplicaAssignment expectedFullAssignment = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)Seq$.MODULE$.empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), expectedFullAssignment);
        ReplicaAssignment updatedFullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assert.assertEquals((Object)expectedFullAssignment.replicas(), (Object)updatedFullAssignment.replicas());
        Assert.assertEquals((Object)expectedFullAssignment.addingReplicas(), (Object)updatedFullAssignment.addingReplicas());
        Assert.assertEquals((Object)expectedFullAssignment.removingReplicas(), (Object)updatedFullAssignment.removingReplicas());
    }

    @Test
    public void testPartitionReplicaAssignmentReturnsEmptySeqIfTopicOrPartitionDoesNotExist() {
        Seq noTopicReplicas = this.context().partitionReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)noTopicReplicas);
        Seq noPartitionReplicas = this.context().partitionReplicaAssignment(new TopicPartition("A", 100));
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)noPartitionReplicas);
    }

    @Test
    public void testPartitionFullReplicaAssignmentReturnsEmptyAssignmentIfTopicOrPartitionDoesNotExist() {
        ReplicaAssignment expectedEmptyAssignment = ReplicaAssignment$.MODULE$.empty();
        ReplicaAssignment noTopicAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assert.assertEquals((Object)expectedEmptyAssignment, (Object)noTopicAssignment);
        ReplicaAssignment noPartitionAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("A", 100));
        Assert.assertEquals((Object)expectedEmptyAssignment, (Object)noPartitionAssignment);
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsEmptyMapIfTopicDoesNotExist() {
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.context().partitionReplicaAssignmentForTopic("NONEXISTENT"));
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsExpectedReplicaAssignments() {
        scala.collection.immutable.Map expectedAssignments = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)this.context().partitionReplicaAssignment(this.tp1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)this.context().partitionReplicaAssignment(this.tp2()))}));
        Map receivedAssignments = this.context().partitionReplicaAssignmentForTopic("A");
        Assert.assertEquals((Object)expectedAssignments, (Object)receivedAssignments);
    }

    @Test
    public void testPartitionReplicaAssignment() {
        ReplicaAssignment reassigningPartition = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6})), (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)Seq$.MODULE$.empty()));
        Assert.assertTrue((boolean)reassigningPartition.isBeingReassigned());
        Assert.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)Seq$.MODULE$.empty())), (Object)reassigningPartition.targetAssignment());
        ReplicaAssignment reassigningPartition2 = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)Nil$.MODULE$, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})), (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)Seq$.MODULE$.empty()));
        Assert.assertTrue((boolean)reassigningPartition2.isBeingReassigned());
        Assert.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Seq)Seq$.MODULE$.empty())), (Object)reassigningPartition2.targetAssignment());
        ReplicaAssignment reassigningPartition3 = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)Seq$.MODULE$.empty()));
        Assert.assertTrue((boolean)reassigningPartition3.isBeingReassigned());
        Assert.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Seq)Seq$.MODULE$.empty())), (Object)reassigningPartition3.targetAssignment());
        ReplicaAssignment partition = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)Seq$.MODULE$.empty());
        Assert.assertFalse((boolean)partition.isBeingReassigned());
        Assert.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)Seq$.MODULE$.empty()), (Object)partition.targetReplicaAssignment());
        ReplicaAssignment reassigningPartition4 = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)Seq$.MODULE$.empty()).reassignTo(new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Seq)Seq$.MODULE$.empty()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3, 1})), (Object)reassigningPartition4.replicas());
        Assert.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Seq)Seq$.MODULE$.empty())), (Object)reassigningPartition4.targetAssignment());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5})), (Object)reassigningPartition4.addingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassigningPartition4.removingReplicas());
        Assert.assertTrue((boolean)reassigningPartition4.isBeingReassigned());
        ReplicaAssignment reassigningPartition5 = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty()).reassignTo(new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.empty()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Object)reassigningPartition5.replicas());
        Assert.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.empty())), (Object)reassigningPartition5.targetAssignment());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Object)reassigningPartition5.addingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassigningPartition5.removingReplicas());
        Assert.assertTrue((boolean)reassigningPartition5.isBeingReassigned());
        ReplicaAssignment nonReassigningPartition = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty()).reassignTo(new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)Seq$.MODULE$.empty()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)nonReassigningPartition.replicas());
        Assert.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)Seq$.MODULE$.empty()), (Object)nonReassigningPartition.targetReplicaAssignment());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.addingReplicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.removingReplicas());
        Assert.assertFalse((boolean)nonReassigningPartition.isBeingReassigned());
    }

    @Test
    public void testReassignmentFromObserverToSyncReplica() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$);
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassignment.replicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.removingReplicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfSyncReplica() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4, 2, 3})), (Object)reassignment.replicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfObserver() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)reassignment.replicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfObserverAndMakeSyncReplicaIntoObserver() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)reassignment.replicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfSyncReplicaAndObserverChange() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2, 3})), (Object)reassignment.replicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassignment.removingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testReassignmentSwapsObserversAndSyncReplicas() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 1, 2})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 1, 2})), (Object)reassignment.replicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)reassignment.effectiveObservers());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)reassignment.addingReplicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)reassignment.removingReplicas());
    }

    @Test
    public void testReassignTo() {
        ReplicaAssignment assignment2 = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty());
        ReplicaAssignment firstReassign = assignment2.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.empty()));
        Assert.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)Seq$.MODULE$.empty())), (Object)firstReassign);
        Assert.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)Seq$.MODULE$.empty())), (Object)firstReassign.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.empty())));
        Assert.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)Seq$.MODULE$.empty())), (Object)assignment2.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.empty())));
        Assert.assertEquals((Object)assignment2, (Object)firstReassign.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty())));
    }

    @Test
    public void testPreferredReplicaImbalanceMetric() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp3(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty()));
        Assert.assertEquals((long)0L, (long)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assert.assertEquals((long)0L, (long)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp2(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1}))), 0));
        Assert.assertEquals((long)1L, (long)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), 0));
        Assert.assertEquals((long)2L, (long)this.context().preferredReplicaImbalanceCount());
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), (Seq)Seq$.MODULE$.empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), (Seq)Seq$.MODULE$.empty()));
        Assert.assertEquals((long)2L, (long)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tp3().topic()})));
        Assert.assertEquals((long)1L, (long)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), 0));
        Assert.assertEquals((long)1L, (long)this.context().preferredReplicaImbalanceCount());
        this.context().removeTopic(this.tp1().topic());
        this.context().removeTopic(this.tp2().topic());
        this.context().removeTopic(this.tp3().topic());
        Assert.assertEquals((long)0L, (long)this.context().preferredReplicaImbalanceCount());
    }
}

