/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionSpec;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ZkSecurityMigrator$;
import kafka.common.Config$class;
import kafka.common.TopicPlacement;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.Defaults$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.KafkaConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging$class;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class ConfigCommand$
implements kafka.common.Config {
    public static final ConfigCommand$ MODULE$;
    private final String BrokerDefaultEntityName;
    private final String BrokerLoggerConfigType;
    private final Seq<String> BrokerSupportedConfigTypes;
    private final int DefaultScramIterations;
    private final Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConfigCommand$();
    }

    @Override
    public void validateChars(String prop, String value2) {
        Config$class.validateChars(this, prop, value2);
    }

    private Logger logger$lzycompute() {
        ConfigCommand$ configCommand$ = this;
        synchronized (configCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String BrokerDefaultEntityName() {
        return this.BrokerDefaultEntityName;
    }

    public String BrokerLoggerConfigType() {
        return this.BrokerLoggerConfigType;
    }

    public Seq<String> BrokerSupportedConfigTypes() {
        return this.BrokerSupportedConfigTypes;
    }

    public int DefaultScramIterations() {
        return this.DefaultScramIterations;
    }

    public Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning() {
        return this.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning;
    }

    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manipulate and describe entity config for a topic, client, user or broker");
            opts.checkArgs();
            if (opts.options().has(opts.zkConnectOpt())) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warning: --zookeeper is deprecated and will be removed in a future version of Kafka."})).s((Seq)Nil$.MODULE$));
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use --bootstrap-server instead to specify a broker to connect to."})).s((Seq)Nil$.MODULE$));
                this.processCommandWithZk((String)opts.options().valueOf(opts.zkConnectOpt()), opts);
            } else {
                this.processCommand(opts);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalArgumentException ? true : (throwable2 instanceof InvalidConfigurationException ? true : throwable2 instanceof OptionException);
            if (bl) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed config command with args '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])args).mkString(" ")})), throwable2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                System.err.println(throwable2.getMessage());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            if (throwable2 != null) {
                BoxedUnit boxedUnit;
                Throwable throwable3 = throwable2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing config command with args '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])args).mkString(" ")})), throwable3);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing config command with args '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])args).mkString(" ")})));
                throwable3.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processCommandWithZk(String zkConnectString, ConfigCommand.ConfigCommandOptions opts) {
        ZKClientConfig zkClientConfig = (ZKClientConfig)ZkSecurityMigrator$.MODULE$.createZkClientConfigFromOption(opts.options(), opts.zkTlsConfigFile()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ZKClientConfig apply() {
                return new ZKClientConfig();
            }
        });
        String x$26 = zkConnectString;
        boolean x$27 = JaasUtils.isZkSaslEnabled() || KafkaConfig$.MODULE$.zkTlsClientAuthEnabled(zkClientConfig);
        int x$28 = 30000;
        int x$29 = 30000;
        int x$30 = Integer.MAX_VALUE;
        Time x$31 = Time.SYSTEM;
        Some x$32 = new Some((Object)zkClientConfig);
        String x$33 = KafkaZkClient$.MODULE$.apply$default$7();
        String x$34 = KafkaZkClient$.MODULE$.apply$default$8();
        Option<String> x$35 = KafkaZkClient$.MODULE$.apply$default$9();
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(x$26, x$27, x$28, x$29, x$30, x$31, x$33, x$34, x$35, (Option<ZKClientConfig>)x$32);
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfigWithZk(zkClient, opts, adminZkClient);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfigWithZk(zkClient, opts, adminZkClient);
            }
            zkClient.close();
            return;
        }
        catch (Throwable throwable) {
            void var4_14;
            var4_14.close();
            throw throwable;
        }
    }

    public void alterConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        String string = entityType;
        String string2 = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.preProcessScramCredentials(configsToBeAdded);
        } else {
            Set dynamicBrokerConfigs;
            String string3 = entityType;
            String string4 = ConfigType$.MODULE$.Broker();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null) && (dynamicBrokerConfigs = (Set)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filterNot((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String elem) {
                    return ConfigCommand$.MODULE$.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning().contains((Object)elem);
                }
            })).nonEmpty()) {
                String string5 = entityName;
                String string6 = ConfigEntityName$.MODULE$.Default();
                boolean perBrokerConfig = string5 != null ? !string5.equals(string6) : string6 != null;
                String errorMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server option must be specified to update broker configs ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dynamicBrokerConfigs}));
                String info = "Broker configuration updates using ZooKeeper are supported for bootstrapping before brokers are started to enable encrypted password configs to be stored in ZooKeeper.";
                if (perBrokerConfig) {
                    adminZkClient.parseBroker(entityName).foreach((Function1)new Serializable(zkClient, entityName, errorMessage, info){
                        public static final long serialVersionUID = 0L;
                        private final KafkaZkClient zkClient$1;
                        public final String entityName$1;
                        public final String errorMessage$1;
                        public final String info$1;

                        public final void apply(int brokerId) {
                            this.apply$mcVI$sp(brokerId);
                        }

                        public void apply$mcVI$sp(int brokerId) {
                            Predef$.MODULE$.require(this.zkClient$1.getBroker(brokerId).isEmpty(), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.alterConfigWithZk.1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " when broker ", " is running. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.errorMessage$1, this.$outer.entityName$1, this.$outer.info$1}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.zkClient$1 = zkClient$1;
                            this.entityName$1 = entityName$1;
                            this.errorMessage$1 = errorMessage$1;
                            this.info$1 = info$1;
                        }
                    });
                } else {
                    Predef$.MODULE$.require(zkClient.getAllBrokersInCluster().isEmpty(), (Function0)new Serializable(errorMessage, info){
                        public static final long serialVersionUID = 0L;
                        private final String errorMessage$1;
                        private final String info$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for default cluster if any broker is running. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.errorMessage$1, this.info$1}));
                        }
                        {
                            this.errorMessage$1 = errorMessage$1;
                            this.info$1 = info$1;
                        }
                    });
                }
                this.preProcessBrokerConfigs(configsToBeAdded, perBrokerConfig);
            }
        }
        Properties configs = adminZkClient.fetchEntityConfig(entityType, entityName);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1)new Serializable(configs){
            public static final long serialVersionUID = 0L;
            private final Properties configs$1;

            public final boolean apply(String x$1) {
                return this.configs$1.containsKey(x$1);
            }
            {
                this.configs$1 = configs$1;
            }
        });
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config(s): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidConfigs.mkString(",")})));
        }
        Implicits$.MODULE$.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
        configsToBeDeleted.foreach((Function1)new Serializable(configs){
            public static final long serialVersionUID = 0L;
            private final Properties configs$1;

            public final Object apply(String x$2) {
                return this.configs$1.remove(x$2);
            }
            {
                this.configs$1 = configs$1;
            }
        });
        adminZkClient.changeConfigs(entityType, entityName, configs);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed updating config for entity: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity})));
    }

    private void preProcessScramCredentials(Properties configsToBeAdded) {
        Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values()).foreach((Function1)new Serializable(configsToBeAdded){
            public static final long serialVersionUID = 0L;
            private final Properties configsToBeAdded$1;

            public final Object apply(ScramMechanism mechanism) {
                String string = this.configsToBeAdded$1.getProperty(mechanism.mechanismName());
                Object object = string == null ? BoxedUnit.UNIT : this.configsToBeAdded$1.setProperty(mechanism.mechanismName(), ConfigCommand$.MODULE$.kafka$admin$ConfigCommand$$scramCredential$1(mechanism, string));
                return object;
            }
            {
                this.configsToBeAdded$1 = configsToBeAdded$1;
            }
        });
    }

    public PasswordEncoder createPasswordEncoder(Map<String, String> encoderConfigs) {
        encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
        String encoderSecret = (String)encoderConfigs.getOrElse((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException("Password encoder secret not specified");
            }
        });
        return new PasswordEncoder(new Password(encoderSecret), (Option<String>)None$.MODULE$, (String)encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return Defaults$.MODULE$.PasswordEncoderCipherAlgorithm();
            }
        }), BoxesRunTime.unboxToInt((Object)encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Defaults$.MODULE$.PasswordEncoderKeyLength();
            }
        })), BoxesRunTime.unboxToInt((Object)encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Defaults$.MODULE$.PasswordEncoderIterations();
            }
        })));
    }

    private void preProcessBrokerConfigs(Properties configsToBeAdded, boolean perBrokerConfig) {
        Properties passwordEncoderConfigs = new Properties();
        Implicits$.MODULE$.PropertiesOps(passwordEncoderConfigs).$plus$plus$eq((Map<String, Object>)((Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    boolean bl = key.startsWith("password.encoder.");
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })));
        if (!passwordEncoderConfigs.isEmpty()) {
            this.info((Function0<String>)new Serializable(passwordEncoderConfigs){
                public static final long serialVersionUID = 0L;
                private final Properties passwordEncoderConfigs$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Password encoder configs ", " will be used for encrypting"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.passwordEncoderConfigs$1.keySet()}))).append((Object)" passwords, but will not be stored in ZooKeeper.").toString();
                }
                {
                    this.passwordEncoderConfigs$1 = passwordEncoderConfigs$1;
                }
            });
            ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()).keySet().foreach((Function1)new Serializable(configsToBeAdded){
                public static final long serialVersionUID = 0L;
                private final Properties configsToBeAdded$2;

                public final Object apply(Object x$1) {
                    return this.configsToBeAdded$2.remove(x$1);
                }
                {
                    this.configsToBeAdded$2 = configsToBeAdded$2;
                }
            });
        }
        DynamicBrokerConfig$.MODULE$.validateConfigs(configsToBeAdded, perBrokerConfig);
        Set passwordConfigs = (Set)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String name) {
                return DynamicBrokerConfig$.MODULE$.isPasswordConfig(name);
            }
        });
        if (passwordConfigs.nonEmpty()) {
            Predef$.MODULE$.require(passwordEncoderConfigs.containsKey(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (Function0)new Serializable(passwordConfigs){
                public static final long serialVersionUID = 0L;
                private final Set passwordConfigs$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " must be specified to update ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), this.passwordConfigs$1}))).append((Object)" Other password encoder configs like cipher algorithm and iterations may also be specified").append((Object)" to override the default encoding parameters. Password encoder configs will not be persisted").append((Object)" in ZooKeeper.").toString();
                }
                {
                    this.passwordConfigs$1 = passwordConfigs$1;
                }
            });
            PasswordEncoder passwordEncoder2 = this.createPasswordEncoder((Map<String, String>)((Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()));
            passwordConfigs.foreach((Function1)new Serializable(configsToBeAdded, passwordEncoder2){
                public static final long serialVersionUID = 0L;
                private final Properties configsToBeAdded$2;
                private final PasswordEncoder passwordEncoder$1;

                public final Object apply(String configName) {
                    String encodedValue = this.passwordEncoder$1.encode(new Password(this.configsToBeAdded$2.getProperty(configName)));
                    return this.configsToBeAdded$2.setProperty(configName, encodedValue);
                }
                {
                    this.configsToBeAdded$2 = configsToBeAdded$2;
                    this.passwordEncoder$1 = passwordEncoder$1;
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private void describeConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        configEntity = this.parseEntity(opts);
        v0 = configEntity.root().entityType();
        var6_5 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        entities = configEntity.getAllEntities(zkClient);
        entities.foreach((Function1)new Serializable(adminZkClient, describeAllUsers){
            public static final long serialVersionUID = 0L;
            private final AdminZkClient adminZkClient$1;
            private final boolean describeAllUsers$1;

            public final void apply(ConfigCommand.ConfigEntity entity) {
                Properties configs = this.adminZkClient$1.fetchEntityConfig(entity.root().entityType(), entity.fullSanitizedName());
                if (!configs.isEmpty() || !this.describeAllUsers$1) {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Configs for %s are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configs).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, String> kv) {
                            return new StringBuilder().append((Object)((String)kv._1())).append((Object)"=").append(kv._2()).toString();
                        }
                    }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
                }
            }
            {
                this.adminZkClient$1 = adminZkClient$1;
                this.describeAllUsers$1 = describeAllUsers$1;
            }
        });
    }

    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = new Properties();
        if (opts.options().has(opts.addConfig())) {
            String pattern = "(?=[^\\]]*(?:\\[|$))";
            String[][] configsToBeAdded = (String[][])Predef$.MODULE$.refArrayOps((Object[])((String)opts.options().valueOf(opts.addConfig())).split(new StringBuilder().append((Object)",").append((Object)pattern).toString())).map((Function1)new Serializable(pattern){
                public static final long serialVersionUID = 0L;
                private final String pattern$1;

                public final String[] apply(String x$6) {
                    return x$6.split(new StringBuilder().append((Object)"\\s*=\\s*").append((Object)this.pattern$1).toString(), -1);
                }
                {
                    this.pattern$1 = pattern$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
            Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded).forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String[] config) {
                    return config.length == 2;
                }
            }), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Invalid entity config: all configs to be added must be in the format \"key=val\".";
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded).foreach((Function1)new Serializable(props){
                public static final long serialVersionUID = 0L;
                private final Properties props$1;

                public final Object apply(String[] pair) {
                    return this.props$1.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim());
                }
                {
                    this.props$1 = props$1;
                }
            });
            if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: The configuration ", "=", " is specified. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker."})).s((Seq)Nil$.MODULE$)).toString());
            }
        }
        return this.parseReplicaPlacementConfig(props, opts);
    }

    private Properties parseReplicaPlacementConfig(Properties props, ConfigCommand.ConfigCommandOptions opts) {
        if (props.containsKey("confluent.placement.constraints")) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"When adding the ", " configuration please use the --replica-placement flag"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"confluent.placement.constraints"})));
        }
        if (opts.options().has(opts.replicaPlacementOpt())) {
            String jsonString = Utils.readFileAsString((String)((String)opts.options().valueOf(opts.replicaPlacementOpt())));
            OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse(jsonString))).foreach((Function1)new Serializable(props){
                public static final long serialVersionUID = 0L;
                private final Properties props$2;

                public final Object apply(TopicPlacement replicaPlacement) {
                    return this.props$2.setProperty("confluent.placement.constraints", replicaPlacement.toJson());
                }
                {
                    this.props$2 = props$2;
                }
            });
        }
        return props;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.deleteConfig())).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$7) {
                    return x$7.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1)new Serializable(propsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Properties propsToBeDeleted$1;

                public final Object apply(String x$8) {
                    return this.propsToBeDeleted$1.setProperty(x$8, "");
                }
                {
                    this.propsToBeDeleted$1 = propsToBeDeleted$1;
                }
            });
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    private void processCommand(ConfigCommand.ConfigCommandOptions opts) {
        AdminClient adminClient;
        block6: {
            Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
            props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
            adminClient = AdminClient.create((Properties)props);
            if (opts.entityTypes().size() != 1) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exactly one entity type (out of ", ") must be specified with --bootstrap-server"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.BrokerSupportedConfigTypes().mkString(",")})));
            }
            List<String> entityNames2 = opts.entityNames();
            if (entityNames2.size() > 1) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"At most one entity name must be specified with --bootstrap-server"})).s((Seq)Nil$.MODULE$));
            }
            if (opts.options().has((OptionSpec)opts.alterOpt()) && entityNames2.size() != 1) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exactly one entity name must be specified with --bootstrap-server for --alter"})).s((Seq)Nil$.MODULE$));
            }
            try {
                if (opts.options().has((OptionSpec)opts.alterOpt())) {
                    this.alterConfig((Admin)adminClient, opts);
                    break block6;
                }
                if (!opts.options().has((OptionSpec)opts.describeOpt())) break block6;
                this.describeConfig((Admin)adminClient, opts);
            }
            catch (Throwable throwable) {
                void var3_3;
                var3_3.close();
                throw throwable;
            }
        }
        adminClient.close();
    }

    public void alterConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        String entityType;
        block12: {
            String entityName;
            block10: {
                Void void_;
                String string;
                Seq<String> configsToBeDeleted;
                scala.collection.mutable.Map configsToBeAdded;
                block11: {
                    block9: {
                        entityType = (String)opts.entityTypes().head();
                        entityName = (String)opts.entityNames().head();
                        configsToBeAdded = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.parseConfigsToBeAdded(opts)).asScala()).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, ConfigEntry> apply(Tuple2<String, String> x0$2) {
                                Tuple2<String, String> tuple2 = x0$2;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    String v = (String)tuple2._2();
                                    Tuple2 tuple22 = new Tuple2((Object)k, (Object)new ConfigEntry(k, v));
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Map$.MODULE$.canBuildFrom());
                        configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
                        string = entityType;
                        String string2 = ConfigType$.MODULE$.Topic();
                        String string3 = string;
                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block9;
                        scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.kafka$admin$ConfigCommand$$getConfig(adminClient, entityType, entityName, false, false).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, ConfigEntry> apply(ConfigEntry entry2) {
                                return new Tuple2((Object)entry2.name(), (Object)entry2);
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1)new Serializable(oldConfig){
                            public static final long serialVersionUID = 0L;
                            private final scala.collection.immutable.Map oldConfig$1;

                            public final boolean apply(String key) {
                                return this.oldConfig$1.contains((Object)key);
                            }
                            {
                                this.oldConfig$1 = oldConfig$1;
                            }
                        });
                        if (invalidConfigs.nonEmpty()) {
                            throw new InvalidConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config(s): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidConfigs.mkString(",")})));
                        }
                        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, entityName);
                        AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                        Collection alterEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAdded.values().map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final AlterConfigOp apply(ConfigEntry x$9) {
                                return new AlterConfigOp(x$9, AlterConfigOp.OpType.SET);
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final AlterConfigOp apply(String k) {
                                return new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE);
                            }
                        }, Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
                        void_ = (Void)adminClient.incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)alterEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
                        break block10;
                    }
                    String string4 = ConfigType$.MODULE$.Broker();
                    String string5 = string;
                    if (string4 != null ? !string4.equals(string5) : string5 != null) break block11;
                    scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.kafka$admin$ConfigCommand$$getConfig(adminClient, entityType, entityName, false, false).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, ConfigEntry> apply(ConfigEntry entry2) {
                            return new Tuple2((Object)entry2.name(), (Object)entry2);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1)new Serializable(oldConfig){
                        public static final long serialVersionUID = 0L;
                        private final scala.collection.immutable.Map oldConfig$2;

                        public final boolean apply(String key) {
                            return this.oldConfig$2.contains((Object)key);
                        }
                        {
                            this.oldConfig$2 = oldConfig$2;
                        }
                    });
                    if (invalidConfigs.nonEmpty()) {
                        throw new InvalidConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config(s): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidConfigs.mkString(",")})));
                    }
                    scala.collection.immutable.Map newEntries = (scala.collection.immutable.Map)oldConfig.$plus$plus((GenTraversableOnce)configsToBeAdded).$minus$minus(configsToBeDeleted);
                    scala.collection.immutable.Map sensitiveEntries = (scala.collection.immutable.Map)newEntries.filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, ConfigEntry> x$10) {
                            return ((ConfigEntry)x$10._2()).value() == null;
                        }
                    });
                    if (sensitiveEntries.nonEmpty()) {
                        throw new InvalidConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All sensitive broker config entries must be specified for --alter, missing entries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sensitiveEntries.keySet()})));
                    }
                    Config newConfig = new Config(((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newEntries).asJava()).values());
                    ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityName);
                    AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                    void_ = (Void)adminClient.alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)newConfig)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
                    break block10;
                }
                String string6 = this.BrokerLoggerConfigType();
                String string7 = string;
                if (string6 != null ? !string6.equals(string7) : string7 != null) break block12;
                Seq validLoggers = (Seq)this.kafka$admin$ConfigCommand$$getConfig(adminClient, entityType, entityName, true, false).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ConfigEntry x$11) {
                        return x$11.name();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq invalidBrokerLoggers = (Seq)((TraversableLike)configsToBeDeleted.filterNot((Function1)new Serializable(validLoggers){
                    public static final long serialVersionUID = 0L;
                    private final Seq validLoggers$1;

                    public final boolean apply(Object elem) {
                        return this.validLoggers$1.contains(elem);
                    }
                    {
                        this.validLoggers$1 = validLoggers$1;
                    }
                })).$plus$plus((GenTraversableOnce)configsToBeAdded.keys().filterNot((Function1)new Serializable(validLoggers){
                    public static final long serialVersionUID = 0L;
                    private final Seq validLoggers$1;

                    public final boolean apply(Object elem) {
                        return this.validLoggers$1.contains(elem);
                    }
                    {
                        this.validLoggers$1 = validLoggers$1;
                    }
                }), Seq$.MODULE$.canBuildFrom());
                if (invalidBrokerLoggers.nonEmpty()) {
                    throw new InvalidConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid broker logger(s): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidBrokerLoggers.mkString(",")})));
                }
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityName);
                AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                Collection alterLogLevelEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAdded.values().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final AlterConfigOp apply(ConfigEntry x$12) {
                        return new AlterConfigOp(x$12, AlterConfigOp.OpType.SET);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final AlterConfigOp apply(String k) {
                        return new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE);
                    }
                }, Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
                void_ = (Void)adminClient.incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)alterLogLevelEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
            }
            if (new StringOps(Predef$.MODULE$.augmentString(entityName)).nonEmpty()) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed updating config for ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(entityType)).dropRight(1), entityName})));
            } else {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed updating default config for ", " in the cluster."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityType})));
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported entity type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityType})));
    }

    public void describeConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        String entityType = (String)opts.entityTypes().head();
        Option entityName = opts.entityNames().headOption();
        boolean describeAll = opts.options().has((OptionSpec)opts.allOpt());
        Seq entities = (Seq)entityName.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(String name) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
            }
        }).getOrElse((Function0)new Serializable(adminClient, entityType){
            public static final long serialVersionUID = 0L;
            private final Admin adminClient$1;
            private final String entityType$2;

            public final Seq<String> apply() {
                String string;
                block7: {
                    Seq seq;
                    block6: {
                        boolean bl;
                        block5: {
                            string = this.entityType$2;
                            String string2 = ConfigType$.MODULE$.Topic();
                            String string3 = string;
                            if (string2 != null ? !string2.equals(string3) : string3 != null) break block5;
                            seq = ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)this.adminClient$1.listTopics(new ListTopicsOptions().listInternal(true)).names().get()).asScala()).toSeq();
                            break block6;
                        }
                        String string4 = ConfigType$.MODULE$.Broker();
                        String string5 = string;
                        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                            bl = true;
                        } else {
                            String string6 = ConfigCommand$.MODULE$.BrokerLoggerConfigType();
                            String string7 = string;
                            bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
                        }
                        if (!bl) break block7;
                        seq = (Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.adminClient$1.describeCluster(new DescribeClusterOptions()).nodes().get()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Node x$13) {
                                return x$13.idString();
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).toSeq().$colon$plus((Object)ConfigCommand$.MODULE$.BrokerDefaultEntityName(), Seq$.MODULE$.canBuildFrom());
                    }
                    return seq;
                }
                throw new MatchError((Object)string);
            }
            {
                this.adminClient$1 = adminClient$1;
                this.entityType$2 = entityType$2;
            }
        });
        entities.foreach((Function1)new Serializable(adminClient, entityType, describeAll){
            public static final long serialVersionUID = 0L;
            private final Admin adminClient$1;
            private final String entityType$2;
            private final boolean describeAll$1;

            public final void apply(String entity) {
                String string = entity;
                String string2 = ConfigCommand$.MODULE$.BrokerDefaultEntityName();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Default configs for ", " in the cluster are:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entityType$2})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String configSourceStr = this.describeAll$1 ? "All" : "Dynamic";
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " configs for ", " ", " are:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configSourceStr, new StringOps(Predef$.MODULE$.augmentString(this.entityType$2)).dropRight(1), entity})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                ConfigCommand$.MODULE$.kafka$admin$ConfigCommand$$getConfig(this.adminClient$1, this.entityType$2, entity, true, this.describeAll$1).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ConfigEntry entry2) {
                        String synonyms = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(entry2.synonyms()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(ConfigEntry.ConfigSynonym synonym) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{synonym.source(), synonym.name(), synonym.value()}));
                            }
                        }, Buffer$.MODULE$.canBuildFrom())).mkString(", ");
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", "=", " sensitive=", " synonyms={", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entry2.name(), entry2.value(), BoxesRunTime.boxToBoolean((boolean)entry2.isSensitive()), synonyms})));
                    }
                });
            }
            {
                this.adminClient$1 = adminClient$1;
                this.entityType$2 = entityType$2;
                this.describeAll$1 = describeAll$1;
            }
        });
    }

    public Seq<ConfigEntry> kafka$admin$ConfigCommand$$getConfig(Admin adminClient, String entityType, String entityName, boolean includeSynonyms, boolean describeAll) {
        String string;
        block11: {
            Tuple2 tuple2;
            block9: {
                block10: {
                    Tuple2 tuple22;
                    block8: {
                        string = entityType;
                        String string2 = ConfigType$.MODULE$.Topic();
                        String string3 = string;
                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block8;
                        if (!entityName.isEmpty()) {
                            Topic.validate((String)entityName);
                        }
                        tuple2 = new Tuple2((Object)ConfigResource.Type.TOPIC, (Object)new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG));
                        break block9;
                    }
                    String string4 = ConfigType$.MODULE$.Broker();
                    String string5 = string;
                    if (string4 != null ? !string4.equals(string5) : string5 != null) break block10;
                    String string6 = entityName;
                    String string7 = this.BrokerDefaultEntityName();
                    String string8 = string6;
                    if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                        tuple22 = new Tuple2((Object)ConfigResource.Type.BROKER, (Object)new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG));
                    } else {
                        this.validateBrokerId$1(entityType, entityName);
                        tuple22 = new Tuple2((Object)ConfigResource.Type.BROKER, (Object)new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG));
                    }
                    tuple2 = tuple22;
                    break block9;
                }
                String string9 = this.BrokerLoggerConfigType();
                String string10 = string;
                if (string9 != null ? !string9.equals(string10) : string10 != null) break block11;
                if (!entityName.isEmpty()) {
                    this.validateBrokerId$1(entityType, entityName);
                }
                tuple2 = new Tuple2((Object)ConfigResource.Type.BROKER_LOGGER, (Object)None$.MODULE$);
            }
            Tuple2 tuple23 = tuple2;
            if (tuple23 != null) {
                Tuple2 tuple24;
                ConfigResource.Type configResourceType = (ConfigResource.Type)tuple23._1();
                Option dynamicConfigSource = (Option)tuple23._2();
                Tuple2 tuple25 = tuple24 = new Tuple2((Object)configResourceType, (Object)dynamicConfigSource);
                ConfigResource.Type configResourceType2 = (ConfigResource.Type)tuple25._1();
                Option dynamicConfigSource2 = (Option)tuple25._2();
                None$ configSourceFilter = describeAll ? None$.MODULE$ : dynamicConfigSource2;
                ConfigResource configResource = new ConfigResource(configResourceType2, entityName);
                DescribeConfigsOptions describeOptions = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
                java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource), describeOptions).all().get(30L, TimeUnit.SECONDS);
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs.get(configResource)).entries()).asScala()).filter((Function1)new Serializable((Option)configSourceFilter){
                    public static final long serialVersionUID = 0L;
                    private final Option configSourceFilter$1;

                    public final boolean apply(ConfigEntry entry2) {
                        Option option;
                        block4: {
                            boolean bl;
                            block3: {
                                block2: {
                                    option = this.configSourceFilter$1;
                                    if (!(option instanceof Some)) break block2;
                                    Some some = (Some)option;
                                    ConfigEntry.ConfigSource configSource = (ConfigEntry.ConfigSource)some.x();
                                    ConfigEntry.ConfigSource configSource2 = entry2.source();
                                    ConfigEntry.ConfigSource configSource3 = configSource;
                                    bl = !(configSource2 != null ? !configSource2.equals(configSource3) : configSource3 != null);
                                    break block3;
                                }
                                if (!None$.MODULE$.equals(option)) break block4;
                                bl = true;
                            }
                            return bl;
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        this.configSourceFilter$1 = configSourceFilter$1;
                    }
                })).toSeq();
            }
            throw new MatchError((Object)tuple23);
        }
        throw new MatchError((Object)string);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        void var10_11;
        Some some;
        String string;
        ConfigCommand.ConfigEntity configEntity;
        List<String> entityNames2;
        List<String> entityTypes2;
        block6: {
            block5: {
                entityTypes2 = opts.entityTypes();
                entityNames2 = opts.entityNames();
                Object object = entityTypes2.head();
                String string2 = ConfigType$.MODULE$.User();
                if (!(object == null ? string2 != null : !object.equals(string2))) break block5;
                Object object2 = entityTypes2.head();
                String string3 = ConfigType$.MODULE$.Client();
                if (object2 != null ? !object2.equals(string3) : string3 != null) break block6;
            }
            configEntity = this.parseQuotaEntity(opts, entityTypes2, entityNames2);
            return configEntity;
        }
        Option option = entityNames2.headOption();
        if (option instanceof Some && "".equals(string = (String)(some = (Some)option).x())) {
            Some some2 = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else {
            Option option2 = option;
        }
        void name = var10_11;
        configEntity = new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)entityTypes2.head(), (Option<String>)name), (Option<ConfigCommand.Entity>)None$.MODULE$);
        return configEntity;
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseQuotaEntity(ConfigCommand.ConfigCommandOptions opts, List<String> types, List<String> names) {
        if (opts.options().has((OptionSpec)opts.alterOpt()) && names.size() != types.size()) {
            throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
        }
        if (types.size() != 2) ** GOTO lbl-1000
        v0 = types.head();
        var5_4 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? types.reverse() : types;
        sortedNames = (reverse != false && names.length() == 2 ? names.reverse() : names).iterator();
        entities = (List)entityTypes.map((Function1)new Serializable(sortedNames){
            public static final long serialVersionUID = 0L;
            private final Iterator sortedNames$1;

            public final ConfigCommand.Entity apply(String t) {
                return new ConfigCommand.Entity(t, (Option<String>)(this.sortedNames$1.hasNext() ? new Some((Object)ConfigCommand$.MODULE$.kafka$admin$ConfigCommand$$sanitizeName$1(t, (String)this.sortedNames$1.next())) : None$.MODULE$));
            }
            {
                this.sortedNames$1 = sortedNames$1;
            }
        }, List$.MODULE$.canBuildFrom());
        return new ConfigCommand.ConfigEntity((ConfigCommand.Entity)entities.head(), (Option<ConfigCommand.Entity>)(entities.size() > 1 ? new Some(entities.apply(1)) : None$.MODULE$));
    }

    public final String kafka$admin$ConfigCommand$$scramCredential$1(ScramMechanism mechanism, String credentialStr) {
        String string;
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString("(?:iterations=([0-9]*),)?password=(.*)")).r();
        Option option = pattern.unapplySeq((CharSequence)(string = credentialStr));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String password;
            String iterations = (String)((LinearSeqOptimized)option.get()).apply(0);
            Tuple2 tuple2 = new Tuple2((Object)(iterations == null ? BoxesRunTime.boxToInteger((int)this.DefaultScramIterations()) : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(iterations)).toInt())), (Object)(password = (String)((LinearSeqOptimized)option.get()).apply(1)));
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                int iterations2 = tuple22._1$mcI$sp();
                String password2 = (String)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)iterations2), (Object)password2);
                int iterations3 = tuple24._1$mcI$sp();
                String password3 = (String)tuple24._2();
                if (iterations3 < mechanism.minIterations()) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iterations ", " is less than the minimum ", " required for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iterations3), BoxesRunTime.boxToInteger((int)mechanism.minIterations()), mechanism})));
                }
                ScramCredential credential = new ScramFormatter(mechanism).generateCredential(password3, iterations3);
                return ScramCredentialUtils.credentialToString((ScramCredential)credential);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid credential property ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mechanism, credentialStr})));
    }

    private final void validateBrokerId$1(String entityType$1, String entityName$2) {
        try {
            new StringOps(Predef$.MODULE$.augmentString(entityName$2)).toInt();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The entity name for ", " must be a valid integer broker id, found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityType$1, entityName$2})));
        }
    }

    public final String kafka$admin$ConfigCommand$$sanitizeName$1(String entityType, String name) {
        block7: {
            String string;
            block6: {
                String string2;
                boolean bl;
                block5: {
                    if (!name.isEmpty()) break block5;
                    string = ConfigEntityName$.MODULE$.Default();
                    break block6;
                }
                String string3 = entityType;
                String string4 = ConfigType$.MODULE$.User();
                String string5 = string3;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = ConfigType$.MODULE$.Client();
                    String string7 = string3;
                    bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
                }
                if (!bl) break block7;
                string = string2 = Sanitizer.sanitize((String)name);
            }
            return string;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid entity type ").append((Object)entityType).toString());
    }

    private ConfigCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        Config$class.$init$(this);
        this.BrokerDefaultEntityName = "";
        this.BrokerLoggerConfigType = "broker-loggers";
        this.BrokerSupportedConfigTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Topic(), ConfigType$.MODULE$.Broker(), this.BrokerLoggerConfigType()}));
        this.DefaultScramIterations = 4096;
        this.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()}));
    }
}

