/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import kafka.admin.ReplicaStatusCommand;
import kafka.admin.ReplicaStatusCommand$;
import kafka.admin.ReplicaStatusCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.WrappedArray;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class ReplicaStatusCommand$
implements Logging {
    public static final ReplicaStatusCommand$ MODULE$;
    private final List<String> kafka$admin$ReplicaStatusCommand$$allColumns;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplicaStatusCommand$();
    }

    private Logger logger$lzycompute() {
        ReplicaStatusCommand$ replicaStatusCommand$ = this;
        synchronized (replicaStatusCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public List<String> kafka$admin$ReplicaStatusCommand$$allColumns() {
        return this.kafka$admin$ReplicaStatusCommand$$allColumns;
    }

    public void main(String[] args) {
        this.run(args, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).second());
    }

    /*
     * WARNING - void declaration
     */
    public void run(String[] args, Duration timeout) {
        ReplicaStatusCommandOptions commandOptions = new ReplicaStatusCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(commandOptions, "This tool prints out the replica status of partitions.");
        ReplicaStatusCommand.Args initializedArgs = this.validateAndInitializeArgs(commandOptions);
        ConfluentAdmin adminClient = this.createAdminClient(commandOptions, timeout);
        try {
            this.replicaStatus(initializedArgs, adminClient);
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        adminClient.close();
    }

    private ConfluentAdmin createAdminClient(ReplicaStatusCommandOptions commandOptions, Duration timeout) {
        Properties props = commandOptions.options().has(commandOptions.adminClientConfigOpt()) ? Utils.loadProps((String)((String)commandOptions.options().valueOf(commandOptions.adminClientConfigOpt()))) : new Properties();
        props.setProperty("bootstrap.servers", (String)commandOptions.options().valueOf(commandOptions.bootstrapServer()));
        props.setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)timeout.toMillis())).toString());
        return (KafkaAdminClient)AdminClient.create((Properties)props);
    }

    private void replicaStatus(ReplicaStatusCommand.Args args, ConfluentAdmin client) {
        try {
            this.doReplicaStatus(args, client);
            return;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"Error while issuing request");
            throw throwable;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable;
                String message = "Timeout waiting for results";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, timeoutException);
            }
            if (throwable instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                String message = "Not authorized";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, (Throwable)clusterAuthorizationException);
            }
            throw executionException;
        }
    }

    private void doReplicaStatus(ReplicaStatusCommand.Args args, ConfluentAdmin client) {
        Iterable iterable;
        Seq topics;
        Seq seq;
        if (args.topics() == null) {
            this.debug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Calling AdminClient.listTopics()"})).s((Seq)Nil$.MODULE$);
                }
            });
            seq = ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)client.listTopics(new ListTopicsOptions().listInternal(!args.excludeInternalTopics())).names().get()).asScala()).toSeq();
        } else {
            seq = topics = (Seq)args.topics().filterNot((Function1)new Serializable(args){
                public static final long serialVersionUID = 0L;
                private final ReplicaStatusCommand.Args args$1;

                public final boolean apply(String x$1) {
                    return Topic.isInternal((String)x$1) && this.args$1.excludeInternalTopics();
                }
                {
                    this.args$1 = args$1;
                }
            });
        }
        if (args.partitions() == null) {
            this.debug((Function0<String>)new Serializable(topics){
                public static final long serialVersionUID = 0L;
                private final Seq topics$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Calling AdminClient.describeTopics(", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topics$1}));
                }
                {
                    this.topics$1 = topics$1;
                }
            });
            iterable = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Map)client.describeTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)topics).asJavaCollection()).all().get()).values()).asScala()).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Buffer<TopicPartition> apply(TopicDescription td) {
                    return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(td.partitions()).asScala()).map((Function1)new Serializable(this, td){
                        public static final long serialVersionUID = 0L;
                        private final TopicDescription td$1;

                        public final TopicPartition apply(TopicPartitionInfo pi) {
                            return new TopicPartition(this.td$1.name(), pi.partition());
                        }
                        {
                            this.td$1 = td$1;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                }
            }, Iterable$.MODULE$.canBuildFrom());
        } else {
            iterable = (Iterable)topics.flatMap((Function1)new Serializable(args){
                public static final long serialVersionUID = 0L;
                private final ReplicaStatusCommand.Args args$1;

                public final Seq<TopicPartition> apply(String topic) {
                    return (Seq)this.args$1.partitions().map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;

                        public final TopicPartition apply(int x$2) {
                            return new TopicPartition(this.topic$1, x$2);
                        }
                        {
                            this.topic$1 = topic$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
                {
                    this.args$1 = args$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        Iterable topicPartitions2 = iterable;
        this.debug((Function0<String>)new Serializable(topicPartitions2){
            public static final long serialVersionUID = 0L;
            private final Iterable topicPartitions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Calling AdminClient.replicaStatus(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartitions$1}));
            }
            {
                this.topicPartitions$1 = topicPartitions$1;
            }
        });
        ReplicaStatusResult result = client.replicaStatus((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)topicPartitions2.toSet()).asJava(), new ReplicaStatusOptions());
        ListBuffer entries = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((List)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(result.result()).asScala()).toList().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>> x0$1) {
                Tuple2<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition key = (TopicPartition)tuple2._1();
                    Tuple2 tuple22 = new Tuple2((Object)key.topic(), (Object)BoxesRunTime.boxToInteger((int)key.partition()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$))).foreach((Function1)new Serializable(args, entries){
            public static final long serialVersionUID = 0L;
            public final ReplicaStatusCommand.Args args$1;
            public final ListBuffer entries$1;

            public final Buffer<ListBuffer<List<String>>> apply(Tuple2<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>> x0$2) {
                Tuple2<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    KafkaFuture replicas = (KafkaFuture)tuple2._2();
                    Buffer status = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)replicas.get()).asScala()).sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(ReplicaStatus x$3) {
                            return x$3.brokerId();
                        }
                    }, (Ordering)Ordering.Int$.MODULE$);
                    long leaderTimeMs = BoxesRunTime.unboxToLong((Object)((TraversableLike)((TraversableLike)status.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ReplicaStatus x$4) {
                            return x$4.isLeader();
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(ReplicaStatus x$5) {
                            return x$5.lastCaughtUpTimeMs();
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }));
                    Buffer buffer = (Buffer)((TraversableLike)status.filterNot((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.doReplicaStatus.3 $outer;

                        public final boolean apply(ReplicaStatus st) {
                            return this.$outer.args$1.leaders().exists((Function1)new Serializable(this, st){
                                public static final long serialVersionUID = 0L;
                                private final ReplicaStatus st$1;

                                public final boolean apply(boolean x$6) {
                                    return x$6 != this.st$1.isLeader();
                                }
                                {
                                    this.st$1 = st$1;
                                }
                            }) || this.$outer.args$1.observers().exists((Function1)new Serializable(this, st){
                                public static final long serialVersionUID = 0L;
                                private final ReplicaStatus st$1;

                                public final boolean apply(boolean x$7) {
                                    return x$7 != this.st$1.isObserver();
                                }
                                {
                                    this.st$1 = st$1;
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    })).map((Function1)new Serializable(this, partition, leaderTimeMs){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.doReplicaStatus.3 $outer;
                        private final TopicPartition partition$1;
                        private final long leaderTimeMs$1;

                        public final ListBuffer<List<String>> apply(ReplicaStatus x$8) {
                            return this.$outer.entries$1.$plus$eq(ReplicaStatusCommand$.MODULE$.kafka$admin$ReplicaStatusCommand$$toEntries(this.$outer.args$1, this.partition$1, x$8, this.leaderTimeMs$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$1 = partition$1;
                            this.leaderTimeMs$1 = leaderTimeMs$1;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    return buffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.args$1 = args$1;
                this.entries$1 = entries$1;
            }
        });
        if (args.jsonOutput()) {
            this.printJson((List<List<String>>)entries.toList());
        } else if (args.verboseOutput()) {
            this.printVerbose((List<List<String>>)entries.toList());
        } else {
            this.printCompact(args, (List<List<String>>)entries.toList());
        }
    }

    public List<String> kafka$admin$ReplicaStatusCommand$$toEntries(ReplicaStatusCommand.Args args, TopicPartition partition, ReplicaStatus status, long leaderTimeMs) {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{partition.topic(), ((Object)BoxesRunTime.boxToInteger((int)partition.partition())).toString(), ((Object)BoxesRunTime.boxToInteger((int)status.brokerId())).toString(), ((Object)BoxesRunTime.boxToBoolean((boolean)status.isLeader())).toString(), ((Object)BoxesRunTime.boxToBoolean((boolean)status.isObserver())).toString(), ((Object)BoxesRunTime.boxToBoolean((boolean)status.isIsrEligible())).toString(), ((Object)BoxesRunTime.boxToBoolean((boolean)status.isInIsr())).toString(), ((Object)BoxesRunTime.boxToBoolean((boolean)status.isCaughtUp())).toString(), this.toLagMsStr$1(status.lastCaughtUpTimeMs(), leaderTimeMs), this.toLagMsStr$1(status.lastFetchTimeMs(), leaderTimeMs), this.toLogOffsetStr$1(status.logStartOffset()), this.toLogOffsetStr$1(status.logEndOffset())}));
    }

    private void printJson(List<List<String>> entries) {
        if (entries.isEmpty()) {
            Predef$.MODULE$.println((Object)"[]");
            return;
        }
        ObjectRef lastTopic = ObjectRef.create((Object)"");
        ObjectRef lastPartition = ObjectRef.create((Object)"");
        Predef$.MODULE$.println((Object)"[");
        ((List)entries.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(lastTopic, lastPartition){
            public static final long serialVersionUID = 0L;
            private final ObjectRef lastTopic$1;
            private final ObjectRef lastPartition$1;

            /*
             * Unable to fully structure code
             */
            public final void apply(Tuple2<List<String>, Object> x0$3) {
                block10: {
                    var2_2 = x0$3;
                    if (var2_2 == null) break block10;
                    entry = (List)var2_2._1();
                    index = var2_2._2$mcI$sp();
                    v0 = (String)this.lastTopic$1.elem;
                    var7_5 = entry.apply(0);
                    v1 = !(v0 != null ? v0.equals(var7_5) == false : var7_5 != null) ? false : (newTopic = true);
                    if (newTopic) ** GOTO lbl-1000
                    v2 = (String)this.lastPartition$1.elem;
                    var9_7 = entry.apply(1);
                    if (!(v2 != null ? v2.equals(var9_7) == false : var9_7 != null)) {
                        v3 = false;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = newPartition = true;
                    }
                    if (index > 0) {
                        if (newPartition) {
                            ReplicaStatusCommand$.MODULE$.kafka$admin$ReplicaStatusCommand$$closePartition$1();
                        }
                        if (newTopic) {
                            ReplicaStatusCommand$.MODULE$.kafka$admin$ReplicaStatusCommand$$closeTopic$1();
                        }
                    }
                    if (newTopic) {
                        if (index > 0) {
                            Predef$.MODULE$.println((Object)",");
                        }
                        Predef$.MODULE$.println((Object)"  {");
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    \"Topic\": ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ReplicaStatusCommand$.MODULE$.kafka$admin$ReplicaStatusCommand$$addQuotes$1((String)entry.apply(0))})));
                        Predef$.MODULE$.println((Object)"    \"Partitions\": [");
                    }
                    if (newPartition) {
                        if (!newTopic) {
                            Predef$.MODULE$.println((Object)",");
                        }
                        Predef$.MODULE$.println((Object)"      {");
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"        \"Partition\": ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entry.apply(1)})));
                        Predef$.MODULE$.println((Object)"        \"Replicas\": [");
                    }
                    this.lastTopic$1.elem = (String)entry.apply(0);
                    this.lastPartition$1.elem = (String)entry.apply(1);
                    if (!newPartition) {
                        Predef$.MODULE$.println((Object)",");
                    }
                    Predef$.MODULE$.println((Object)"          {");
                    ((List)entry.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, entry){
                        public static final long serialVersionUID = 0L;
                        private final List entry$1;

                        public final void apply(Tuple2<String, Object> x0$4) {
                            Tuple2<String, Object> tuple2 = x0$4;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                String subEntry = (String)tuple2._1();
                                int subIndex = tuple2._2$mcI$sp();
                                if (subIndex >= 2) {
                                    Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"            ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ReplicaStatusCommand$.MODULE$.kafka$admin$ReplicaStatusCommand$$addQuotes$1((String)ReplicaStatusCommand$.MODULE$.kafka$admin$ReplicaStatusCommand$$allColumns().apply(subIndex)), subEntry})));
                                    if (subIndex < this.entry$1.size() - 1) {
                                        Predef$.MODULE$.println((Object)",");
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        Predef$.MODULE$.println();
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.entry$1 = entry$1;
                        }
                    });
                    Predef$.MODULE$.print((Object)"          }");
                    var5_9 = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(var2_2);
            }
            {
                this.lastTopic$1 = lastTopic$1;
                this.lastPartition$1 = lastPartition$1;
            }
        });
        this.kafka$admin$ReplicaStatusCommand$$closePartition$1();
        this.kafka$admin$ReplicaStatusCommand$$closeTopic$1();
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"]");
    }

    private void printVerbose(List<List<String>> entries) {
        ((List)entries.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(entries){
            public static final long serialVersionUID = 0L;
            private final List entries$2;

            public final void apply(Tuple2<List<String>, Object> x0$5) {
                Tuple2<List<String>, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    List entry2 = (List)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    ((List)ReplicaStatusCommand$.MODULE$.kafka$admin$ReplicaStatusCommand$$allColumns().zip((GenIterable)entry2, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<String, String> subEntry) {
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subEntry._1(), subEntry._2()})));
                        }
                    });
                    if (index < this.entries$2.size() - 1) {
                        Predef$.MODULE$.println();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.entries$2 = entries$2;
            }
        });
    }

    private void printCompact(ReplicaStatusCommand.Args args, List<List<String>> entries) {
        ArrayBuffer maxWidth = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((List)this.kafka$admin$ReplicaStatusCommand$$allColumns().zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(maxWidth){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer maxWidth$1;

            public final ArrayBuffer<Object> apply(Tuple2<String, Object> x0$6) {
                Tuple2<String, Object> tuple2 = x0$6;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    ArrayBuffer arrayBuffer = this.maxWidth$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(name)).size()));
                    return arrayBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.maxWidth$1 = maxWidth$1;
            }
        });
        entries.foreach((Function1)new Serializable(maxWidth){
            public static final long serialVersionUID = 0L;
            public final ArrayBuffer maxWidth$1;

            public final void apply(List<String> entry2) {
                ((List)entry2.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.printCompact.2 $outer;

                    public final void apply(Tuple2<String, Object> x0$7) {
                        Tuple2<String, Object> tuple2 = x0$7;
                        if (tuple2 != null) {
                            String subEntry = (String)tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            this.$outer.maxWidth$1.update(index, (Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)this.$outer.maxWidth$1.apply(index))), new StringOps(Predef$.MODULE$.augmentString(subEntry)).size())));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.maxWidth$1 = maxWidth$1;
            }
        });
        this.kafka$admin$ReplicaStatusCommand$$printEntries$1(this.kafka$admin$ReplicaStatusCommand$$allColumns(), maxWidth);
        entries.foreach((Function1)new Serializable(maxWidth){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer maxWidth$1;

            public final void apply(List<String> x$9) {
                ReplicaStatusCommand$.MODULE$.kafka$admin$ReplicaStatusCommand$$printEntries$1(x$9, this.maxWidth$1);
            }
            {
                this.maxWidth$1 = maxWidth$1;
            }
        });
    }

    private ReplicaStatusCommand.Args validateAndInitializeArgs(ReplicaStatusCommandOptions commandOptions) {
        List missingOptions = List$.MODULE$.empty();
        if (!commandOptions.options().has(commandOptions.bootstrapServer())) {
            String string = (String)commandOptions.bootstrapServer().options().get(0);
            missingOptions = missingOptions.$colon$colon((Object)string);
        }
        if (missingOptions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing required option(s): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingOptions.mkString(", ")})));
        }
        WrappedArray topicsArg = null;
        if (commandOptions.options().has(commandOptions.topicsOpt())) {
            topicsArg = Predef$.MODULE$.wrapRefArray((Object[])((String)commandOptions.options().valueOf(commandOptions.topicsOpt())).split(","));
            topicsArg.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$11) {
                    Topic.validate((String)x$11);
                }
            });
        }
        ListBuffer partitionsArg = null;
        if (commandOptions.options().has(commandOptions.partitionsOpt())) {
            ListBuffer tmpPartitions = new ListBuffer();
            Predef$.MODULE$.refArrayOps((Object[])((String)commandOptions.options().valueOf(commandOptions.partitionsOpt())).split(",")).foreach((Function1)new Serializable(tmpPartitions){
                public static final long serialVersionUID = 0L;
                public final ListBuffer tmpPartitions$1;

                public final Object apply(String partitionStr) {
                    String[] divPartitions = partitionStr.split("-");
                    if (Predef$.MODULE$.refArrayOps((Object[])divPartitions).isEmpty() || Predef$.MODULE$.refArrayOps((Object[])divPartitions).size() > 2) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid partition range: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionStr})));
                    }
                    try {
                        ListBuffer listBuffer;
                        int first = new StringOps(Predef$.MODULE$.augmentString(divPartitions[0])).toInt();
                        if (Predef$.MODULE$.refArrayOps((Object[])divPartitions).size() == 1) {
                            listBuffer = this.tmpPartitions$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)first));
                        } else {
                            int second = new StringOps(Predef$.MODULE$.augmentString(divPartitions[1])).toInt();
                            if (first > second) {
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid partition range: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionStr})));
                            }
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(first), second + 1).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.validateAndInitializeArgs.2 $outer;

                                public final ListBuffer<Object> apply(int i) {
                                    return this.$outer.tmpPartitions$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            listBuffer = BoxedUnit.UNIT;
                        }
                        return listBuffer;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse partition: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionStr})));
                    }
                }
                {
                    this.tmpPartitions$1 = tmpPartitions$1;
                }
            });
            partitionsArg = tmpPartitions;
        }
        boolean verboseOutputArg = commandOptions.options().has((OptionSpec)commandOptions.verboseOutputOpt());
        boolean jsonOutputArg = commandOptions.options().has((OptionSpec)commandOptions.jsonOutputOpt());
        boolean excludeInternalTopicsArg = commandOptions.options().has((OptionSpec)commandOptions.excludeInternalTopicsOpt());
        Option leadersArg = this.parseBoolOpt$1(commandOptions.leadersOpt(), commandOptions);
        Option observersArg = this.parseBoolOpt$1(commandOptions.observersOpt(), commandOptions);
        return new ReplicaStatusCommand.Args((Seq<String>)topicsArg, (Seq<Object>)partitionsArg, (Option<Object>)leadersArg, (Option<Object>)observersArg, verboseOutputArg, jsonOutputArg, excludeInternalTopicsArg);
    }

    private final String toLagMsStr$1(long timeMs, long leaderTimeMs$2) {
        return timeMs > 0L ? ((Object)BoxesRunTime.boxToLong((long)(leaderTimeMs$2 - timeMs))).toString() : "-1";
    }

    private final String toLogOffsetStr$1(long logOffset) {
        return logOffset >= 0L ? ((Object)BoxesRunTime.boxToLong((long)logOffset)).toString() : "-1";
    }

    public final String kafka$admin$ReplicaStatusCommand$$addQuotes$1(String string) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string}));
    }

    public final void kafka$admin$ReplicaStatusCommand$$closeTopic$1() {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    ]");
        Predef$.MODULE$.print((Object)"  }");
    }

    public final void kafka$admin$ReplicaStatusCommand$$closePartition$1() {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"        ]");
        Predef$.MODULE$.print((Object)"      }");
    }

    public final void kafka$admin$ReplicaStatusCommand$$printEntry$1(String string, int index, ArrayBuffer maxWidth$1) {
        Predef$.MODULE$.print((Object)string);
        Predef$.MODULE$.print((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(BoxesRunTime.unboxToInt((Object)maxWidth$1.apply(index)) - new StringOps(Predef$.MODULE$.augmentString(string)).size() + 1));
    }

    public final void kafka$admin$ReplicaStatusCommand$$printEntries$1(List entries, ArrayBuffer maxWidth$1) {
        ((List)entries.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(maxWidth$1){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer maxWidth$1;

            public final void apply(Tuple2<String, Object> e) {
                ReplicaStatusCommand$.MODULE$.kafka$admin$ReplicaStatusCommand$$printEntry$1((String)e._1(), e._2$mcI$sp(), this.maxWidth$1);
            }
            {
                this.maxWidth$1 = maxWidth$1;
            }
        });
        Predef$.MODULE$.println();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Option parseBoolOpt$1(ArgumentAcceptingOptionSpec spec, ReplicaStatusCommandOptions commandOptions$1) {
        None$ none$;
        if (commandOptions$1.options().has((OptionSpec)spec)) {
            if (commandOptions$1.options().valueOf((OptionSpec)spec) == null) {
                none$ = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                return none$;
            } else {
                Some some;
                String string = ((String)commandOptions$1.options().valueOf((OptionSpec)spec)).toLowerCase();
                if ("only".equals(string)) {
                    some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                } else {
                    if (!"exclude".equals(string)) throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
                    some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
                none$ = some;
            }
            return none$;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private ReplicaStatusCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.kafka$admin$ReplicaStatusCommand$$allColumns = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic", "Partition", "Replica", "IsLeader", "IsObserver", "IsIsrEligible", "IsInIsr", "IsCaughtUp", "LastCaughtUpLagMs", "LastFetchLagMs", "LogStartOffset", "LogEndOffset"}));
    }
}

