/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.DelayedHeartbeat;
import kafka.coordinator.group.DelayedJoin;
import kafka.coordinator.group.GroupConfig;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadataManager;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.LeaveMemberResponse;
import kafka.coordinator.group.MemberSummary;
import kafka.coordinator.group.OffsetConfig;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class GroupCoordinator$ {
    public static final GroupCoordinator$ MODULE$;
    private final String NoState;
    private final String NoProtocolType;
    private final String NoProtocol;
    private final String NoLeader;
    private final int NoGeneration;
    private final List<MemberSummary> NoMembers;
    private final GroupSummary EmptyGroup;
    private final GroupSummary DeadGroup;
    private final int NewMemberJoinTimeoutMs;

    static {
        new GroupCoordinator$();
    }

    public String NoState() {
        return this.NoState;
    }

    public String NoProtocolType() {
        return this.NoProtocolType;
    }

    public String NoProtocol() {
        return this.NoProtocol;
    }

    public String NoLeader() {
        return this.NoLeader;
    }

    public int NoGeneration() {
        return this.NoGeneration;
    }

    public List<MemberSummary> NoMembers() {
        return this.NoMembers;
    }

    public GroupSummary EmptyGroup() {
        return this.EmptyGroup;
    }

    public GroupSummary DeadGroup() {
        return this.DeadGroup;
    }

    public int NewMemberJoinTimeoutMs() {
        return this.NewMemberJoinTimeoutMs;
    }

    public GroupCoordinator apply(KafkaConfig config, KafkaZkClient zkClient, ReplicaManager replicaManager, Time time, Metrics metrics) {
        DelayedOperationPurgatory<DelayedHeartbeat> heartbeatPurgatory = DelayedOperationPurgatory$.MODULE$.apply("Heartbeat", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        DelayedOperationPurgatory<DelayedJoin> joinPurgatory = DelayedOperationPurgatory$.MODULE$.apply("Rebalance", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        return this.apply(config, zkClient, replicaManager, heartbeatPurgatory, joinPurgatory, time, metrics);
    }

    public OffsetConfig offsetConfig(KafkaConfig config) {
        return new OffsetConfig(Predef$.MODULE$.Integer2int(config.offsetMetadataMaxSize()), Predef$.MODULE$.Integer2int(config.offsetsLoadBufferSize()), (long)Predef$.MODULE$.Integer2int(config.offsetsRetentionMinutes()) * 60L * 1000L, Predef$.MODULE$.Long2long(config.offsetsRetentionCheckIntervalMs()), Predef$.MODULE$.Integer2int(config.offsetsTopicPartitions()), Predef$.MODULE$.Integer2int(config.offsetsTopicSegmentBytes()), Predef$.MODULE$.Short2short(config.offsetsTopicReplicationFactor()), config.offsetsTopicCompressionCodec(), Predef$.MODULE$.Integer2int(config.offsetCommitTimeoutMs()), Predef$.MODULE$.Short2short(config.offsetCommitRequiredAcks()));
    }

    public GroupCoordinator apply(KafkaConfig config, KafkaZkClient zkClient, ReplicaManager replicaManager, DelayedOperationPurgatory<DelayedHeartbeat> heartbeatPurgatory, DelayedOperationPurgatory<DelayedJoin> joinPurgatory, Time time, Metrics metrics) {
        OffsetConfig offsetConfig = this.offsetConfig(config);
        GroupConfig groupConfig = new GroupConfig(Predef$.MODULE$.Integer2int(config.groupMinSessionTimeoutMs()), Predef$.MODULE$.Integer2int(config.groupMaxSessionTimeoutMs()), Predef$.MODULE$.Integer2int(config.groupMaxSize()), Predef$.MODULE$.Integer2int(config.groupInitialRebalanceDelay()));
        GroupMetadata$.MODULE$.VerifyGroupSubscriptionPrefix_$eq(Predef$.MODULE$.Boolean2boolean(config.verifyGroupSubscriptionPrefix()));
        GroupMetadataManager groupMetadataManager = new GroupMetadataManager(config.brokerId(), config.interBrokerProtocolVersion(), offsetConfig, replicaManager, zkClient, time, metrics);
        return new GroupCoordinator(config.brokerId(), groupConfig, offsetConfig, groupMetadataManager, heartbeatPurgatory, joinPurgatory, time, metrics);
    }

    public LeaveMemberResponse kafka$coordinator$group$GroupCoordinator$$memberLeaveError(LeaveGroupRequestData.MemberIdentity memberIdentity, Errors error) {
        return new LeaveMemberResponse(memberIdentity.memberId(), (Option<String>)Option$.MODULE$.apply((Object)memberIdentity.groupInstanceId()), error);
    }

    public LeaveGroupResult kafka$coordinator$group$GroupCoordinator$$leaveError(Errors topLevelError, List<LeaveMemberResponse> memberResponses) {
        return new LeaveGroupResult(topLevelError, memberResponses);
    }

    private GroupCoordinator$() {
        MODULE$ = this;
        this.NoState = "";
        this.NoProtocolType = "";
        this.NoProtocol = "";
        this.NoLeader = "";
        this.NoGeneration = -1;
        this.NoMembers = Nil$.MODULE$;
        this.EmptyGroup = new GroupSummary(this.NoState(), this.NoProtocolType(), this.NoProtocol(), this.NoMembers());
        this.DeadGroup = new GroupSummary(((Object)Dead$.MODULE$).toString(), this.NoProtocolType(), this.NoProtocol(), this.NoMembers());
        this.NewMemberJoinTimeoutMs = 300000;
    }
}

