/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.regex.Pattern;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class Log$ {
    public static final Log$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;
    private final String TimeIndexFileSuffix;
    private final String ProducerSnapshotFileSuffix;
    private final String TxnIndexFileSuffix;
    private final String DeletedFileSuffix;
    private final String CleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String CleanShutdownFile;
    private final String DeleteDirSuffix;
    private final String FutureDirSuffix;
    private final String TierStateSuffix;
    private final Pattern DeleteDirPattern;
    private final Pattern FutureDirPattern;
    private final long UnknownOffset;

    static {
        new Log$();
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return this.TimeIndexFileSuffix;
    }

    public String ProducerSnapshotFileSuffix() {
        return this.ProducerSnapshotFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return this.TxnIndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return this.DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String CleanShutdownFile() {
        return this.CleanShutdownFile;
    }

    public String DeleteDirSuffix() {
        return this.DeleteDirSuffix;
    }

    public String FutureDirSuffix() {
        return this.FutureDirSuffix;
    }

    public String TierStateSuffix() {
        return this.TierStateSuffix;
    }

    public Pattern DeleteDirPattern() {
        return this.DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return this.FutureDirPattern;
    }

    public long UnknownOffset() {
        return this.UnknownOffset;
    }

    public MergedLog apply(File dir, LogConfig config, long logStartOffset2, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, Option<TierLogComponents> tierLogComponentsOpt) {
        TierLogComponents tierLogComponents = (TierLogComponents)tierLogComponentsOpt.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TierLogComponents apply() {
                return TierLogComponents$.MODULE$.EMPTY();
            }
        });
        return MergedLog$.MODULE$.apply(dir, config, logStartOffset2, recoveryPoint, scheduler, brokerTopicStats, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, logDirFailureChannel, tierLogComponents);
    }

    public Time apply$default$7() {
        return Time.SYSTEM;
    }

    public Option<TierLogComponents> apply$default$11() {
        return None$.MODULE$;
    }

    public String filenamePrefixFromOffset(long offset2) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset2);
    }

    public File logFile(File dir, long offset2, String suffix) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset2)).append((Object)this.LogFileSuffix()).append((Object)suffix).toString());
    }

    public String logFile$default$3() {
        return "";
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        String suffix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-", ".", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)topicPartition.partition()), uniqueId, this.DeleteDirSuffix()}));
        int prefixLength = Math.min(new StringOps(Predef$.MODULE$.augmentString(topicPartition.topic())).size(), 255 - new StringOps(Predef$.MODULE$.augmentString(suffix)).size());
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition.topic().substring(0, prefixLength), suffix}));
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return this.logDirNameWithSuffix(topicPartition, this.FutureDirSuffix());
    }

    private String logDirNameWithSuffix(TopicPartition topicPartition, String suffix) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logDirName(topicPartition), uniqueId, suffix}));
    }

    public String logDirName(TopicPartition topicPartition) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition.topic(), BoxesRunTime.boxToInteger((int)topicPartition.partition())}));
    }

    public File offsetIndexFile(File dir, long offset2, String suffix) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset2)).append((Object)this.IndexFileSuffix()).append((Object)suffix).toString());
    }

    public String offsetIndexFile$default$3() {
        return "";
    }

    public File timeIndexFile(File dir, long offset2, String suffix) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset2)).append((Object)this.TimeIndexFileSuffix()).append((Object)suffix).toString());
    }

    public String timeIndexFile$default$3() {
        return "";
    }

    public void deleteFileIfExists(File file, String suffix) {
        Files.deleteIfExists(new File(new StringBuilder().append((Object)file.getPath()).append((Object)suffix).toString()).toPath());
    }

    public String deleteFileIfExists$default$2() {
        return "";
    }

    public File producerSnapshotFile(File dir, long offset2) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset2)).append((Object)this.ProducerSnapshotFileSuffix()).toString());
    }

    public File transactionIndexFile(File dir, long offset2, String suffix) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset2)).append((Object)this.TxnIndexFileSuffix()).append((Object)suffix).toString());
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public File tierStateFile(File dir, long offset2, String suffix) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset2)).append((Object)this.TierStateSuffix()).append((Object)suffix).toString());
    }

    public String tierStateFile$default$3() {
        return "";
    }

    public long offsetFromFileName(String filename) {
        return new StringOps(Predef$.MODULE$.augmentString(filename.substring(0, filename.indexOf(46)))).toLong();
    }

    public long offsetFromFile(File file) {
        return this.offsetFromFileName(file.getName());
    }

    public long sizeInBytes(Iterable<LogSegment> segments) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)segments.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$58) {
                return x$58.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TopicPartition parseTopicPartitionName(File dir) {
        int partition;
        if (dir == null) {
            throw new KafkaException("dir should not be null");
        }
        String dirName = dir.getName();
        if (dirName == null || dirName.isEmpty() || !new StringOps(Predef$.MODULE$.augmentString(dirName)).contains((Object)BoxesRunTime.boxToCharacter((char)'-'))) throw this.exception$1(dir);
        if (dirName.endsWith(this.DeleteDirSuffix()) && !this.DeleteDirPattern().matcher(dirName).matches() || dirName.endsWith(this.FutureDirSuffix()) && !this.FutureDirPattern().matcher(dirName).matches()) {
            throw this.exception$1(dir);
        }
        String name = dirName.endsWith(this.DeleteDirSuffix()) || dirName.endsWith(this.FutureDirSuffix()) ? dirName.substring(0, dirName.lastIndexOf(46)) : dirName;
        int index = name.lastIndexOf(45);
        String topic = name.substring(0, index);
        String partitionString = name.substring(index + 1);
        if (topic.isEmpty() || partitionString.isEmpty()) {
            throw this.exception$1(dir);
        }
        try {
            partition = new StringOps(Predef$.MODULE$.augmentString(partitionString)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exception$1(dir);
        }
        return new TopicPartition(topic, partition);
    }

    public boolean kafka$log$Log$$isIndexFile(File file) {
        String filename = file.getName();
        return filename.endsWith(this.IndexFileSuffix()) || filename.endsWith(this.TimeIndexFileSuffix()) || filename.endsWith(this.TxnIndexFileSuffix());
    }

    public boolean kafka$log$Log$$isLogFile(File file) {
        return file.getPath().endsWith(this.LogFileSuffix());
    }

    public boolean isTierStateFile(File file) {
        return file.getPath().endsWith(this.TierStateSuffix());
    }

    public <A> ConcurrentNavigableMap<Long, A> logSegments(ConcurrentNavigableMap<Long, A> segments, long from, long to, Object lock2) {
        Object object = lock2;
        synchronized (object) {
            ConcurrentNavigableMap view;
            ConcurrentNavigableMap concurrentNavigableMap = view = (ConcurrentNavigableMap)Option$.MODULE$.apply((Object)segments.floorKey(Predef$.MODULE$.long2Long(from))).map((Function1)new Serializable(segments, to){
                public static final long serialVersionUID = 0L;
                private final ConcurrentNavigableMap segments$3;
                private final long to$2;

                public final ConcurrentNavigableMap<Long, A> apply(Long floor) {
                    return this.segments$3.subMap(floor, Predef$.MODULE$.long2Long(this.to$2));
                }
                {
                    this.segments$3 = segments$3;
                    this.to$2 = to$2;
                }
            }).getOrElse((Function0)new Serializable(segments, to){
                public static final long serialVersionUID = 0L;
                private final ConcurrentNavigableMap segments$3;
                private final long to$2;

                public final ConcurrentNavigableMap<Long, A> apply() {
                    return this.segments$3.headMap(Predef$.MODULE$.long2Long(this.to$2));
                }
                {
                    this.segments$3 = segments$3;
                    this.to$2 = to$2;
                }
            });
            return concurrentNavigableMap;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Option<ByteBuffer> serializeAbortedTransactions(Seq<AbortedTxn> abortedTxnsList) {
        void var2_2;
        None$ maybeAbortedTxnsBuf = None$.MODULE$;
        if (abortedTxnsList.nonEmpty()) {
            ByteBuffer buf = ByteBuffer.allocate(abortedTxnsList.length() * AbortedTxn$.MODULE$.TotalSize());
            abortedTxnsList.foreach((Function1)new Serializable(buf){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer buf$1;

                public final ByteBuffer apply(AbortedTxn abortedTxn) {
                    return this.buf$1.put(abortedTxn.buffer().duplicate());
                }
                {
                    this.buf$1 = buf$1;
                }
            });
            buf.flip();
            maybeAbortedTxnsBuf = new Some((Object)buf);
        }
        return var2_2;
    }

    public long $lessinit$greater$default$12() {
        return 0L;
    }

    public Function0<Object> $lessinit$greater$default$13() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        };
    }

    private final KafkaException exception$1(File dir) {
        return new KafkaException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found directory ", ", '", "' is not in the form of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir.getCanonicalPath(), dir.getName()}))).append((Object)"topic-partition or topic-partition.uniqueId-delete (if marked for deletion).\n").append((Object)"Kafka's log directories (and children) should only contain Kafka topic data.").toString());
    }

    private Log$() {
        MODULE$ = this;
        this.LogFileSuffix = ".log";
        this.IndexFileSuffix = ".index";
        this.TimeIndexFileSuffix = ".timeindex";
        this.ProducerSnapshotFileSuffix = ".snapshot";
        this.TxnIndexFileSuffix = ".txnindex";
        this.DeletedFileSuffix = ".deleted";
        this.CleanedFileSuffix = ".cleaned";
        this.SwapFileSuffix = ".swap";
        this.CleanShutdownFile = ".kafka_cleanshutdown";
        this.DeleteDirSuffix = "-delete";
        this.FutureDirSuffix = "-future";
        this.TierStateSuffix = ".tierstate";
        this.DeleteDirPattern = Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\\\S+)-(\\\\S+)\\\\.(\\\\S+)", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DeleteDirSuffix()})));
        this.FutureDirPattern = Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\\\S+)-(\\\\S+)\\\\.(\\\\S+)", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.FutureDirSuffix()})));
        this.UnknownOffset = -1L;
    }
}

