/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicBackpressure$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory$;
import kafka.server.QuotaType$Fetch$;
import kafka.server.QuotaType$Produce$;
import kafka.server.QuotaType$Request$;
import org.apache.kafka.common.config.ConfigException;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A;Q!\u0001\u0002\t\u0002\u001d\t1\u0003R=oC6L7MQ1dWB\u0014Xm]:ve\u0016T!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014\tft\u0017-\\5d\u0005\u0006\u001c7\u000e\u001d:fgN,(/Z\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\u0002]\tQCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7/F\u0001\u0019!\rIBDH\u0007\u00025)\u00111DD\u0001\u000bG>dG.Z2uS>t\u0017BA\u000f\u001b\u0005\r\u0019V\r\u001e\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u0019\u0019FO]5oO\"1q%\u0003Q\u0001\na\taCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\t\u0004\u0005\u0015\t\u0001\u0011fE\u0002)\u0019)\u0002\"\u0001C\u0016\n\u00051\u0012!\u0001\u0006\"s_.,'OU3d_:4\u0017nZ;sC\ndW\r\u0003\u0005\u0004Q\t\u0005\t\u0015!\u0003/!\tAq&\u0003\u00021\u0005\tY1*\u00194lCN+'O^3s\u0011\u0015\u0019\u0002\u0006\"\u00013)\t\u0019D\u0007\u0005\u0002\tQ!)1!\ra\u0001]!)a\u0007\u000bC!o\u0005)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cX#\u0001\u001d\u0011\u0007ea\u0012\b\u0005\u0002;{9\u0011QbO\u0005\u0003y9\ta\u0001\u0015:fI\u00164\u0017BA\u0013?\u0015\tad\u0002C\u0003AQ\u0011\u0005\u0013)A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R\u0011!)\u0012\t\u0003\u001b\rK!\u0001\u0012\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006\r~\u0002\raR\u0001\n]\u0016<8i\u001c8gS\u001e\u0004\"\u0001\u0003%\n\u0005%\u0013!aC&bM.\f7i\u001c8gS\u001eDQa\u0013\u0015\u0005B1\u000b1B]3d_:4\u0017nZ;sKR\u0019!)T(\t\u000b9S\u0005\u0019A$\u0002\u0013=dGmQ8oM&<\u0007\"\u0002$K\u0001\u00049\u0005")
public class DynamicBackpressure
implements BrokerReconfigurable {
    private final KafkaServer server;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicBackpressure$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicBackpressure$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Option$.MODULE$.apply((Object)newConfig.getString("confluent.backpressure.types")).isDefined() && !QuotaFactory$.MODULE$.isMultiTenant(newConfig)) {
            throw new ConfigException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Enabling backpressure requires '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to be set to '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"io.confluent.kafka.multitenant.quota.TenantQuotaCallback"}))).toString());
        }
        if (QuotaFactory$.MODULE$.backpressureEnabledInConfig(newConfig, QuotaType$Request$.MODULE$) && QuotaFactory$.MODULE$.brokerBackpressureConfig(newConfig, QuotaType$Request$.MODULE$).tenantEndpointListenerNames().isEmpty()) {
            throw new ConfigException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"confluent.multitenant.listener.names"}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"be set for request backpressure to be enabled."})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.server.quotaManagers().fetch().updateBackpressureConfig(QuotaFactory$.MODULE$.brokerBackpressureConfig(newConfig, QuotaType$Fetch$.MODULE$));
        this.server.quotaManagers().produce().updateBackpressureConfig(QuotaFactory$.MODULE$.brokerBackpressureConfig(newConfig, QuotaType$Produce$.MODULE$));
        this.server.quotaManagers().request().updateBackpressureConfig(QuotaFactory$.MODULE$.brokerBackpressureConfig(newConfig, QuotaType$Request$.MODULE$));
    }

    public DynamicBackpressure(KafkaServer server) {
        this.server = server;
    }
}

