/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Iterator;
import kafka.server.BrokerTopicStats;
import kafka.server.LogReadResult;
import org.apache.kafka.common.record.RecordBatch;

public final class FetchLag$ {
    public static final FetchLag$ MODULE$;
    private final long UnknownFetchLagMs;

    static {
        new FetchLag$();
    }

    public long UnknownFetchLagMs() {
        return this.UnknownFetchLagMs;
    }

    private long lagInMs(LogReadResult result) {
        if (result.isReadAllowed()) {
            Iterator iterator2 = result.info().records().batches().iterator();
            if (iterator2.hasNext()) {
                long firstBatchTimestamp = ((RecordBatch)iterator2.next()).maxTimestamp();
                if (firstBatchTimestamp == -1L || result.fetchTimeMs() < firstBatchTimestamp) {
                    return this.UnknownFetchLagMs();
                }
                return result.fetchTimeMs() - firstBatchTimestamp;
            }
            return 0L;
        }
        return this.UnknownFetchLagMs();
    }

    public void maybeRecordConsumerFetchTimeLag(boolean isFromConsumer, LogReadResult result, BrokerTopicStats brokerTopicStats) {
        long fetchLagMs;
        if (isFromConsumer && (fetchLagMs = this.lagInMs(result)) != this.UnknownFetchLagMs()) {
            brokerTopicStats.allTopicsStats().consumerFetchLagTimeMs().update(fetchLagMs);
        }
    }

    private FetchLag$() {
        MODULE$ = this;
        this.UnknownFetchLagMs = -1L;
    }
}

