/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.RequestChannel;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.Logging$class;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001\u001d\u0011qcS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\u0004vn\u001c7\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u000f)A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\tq!\\3ue&\u001c7/\u0003\u0002\u001a-\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\t\u0011m\u0001!\u0011!Q\u0001\nq\taaY8oM&<\u0007CA\u000f\u001f\u001b\u0005\u0011\u0011BA\u0010\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0011\u0005\u0002!Q1A\u0005\u0002\t\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002GA\u0011\u0011\u0002J\u0005\u0003K)\u00111!\u00138u\u0011!9\u0003A!A!\u0002\u0013\u0019\u0013!\u00032s_.,'/\u00133!\u0011!I\u0003A!b\u0001\n\u0003Q\u0013A\u0004:fcV,7\u000f^\"iC:tW\r\\\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011a\u0006B\u0001\b]\u0016$xo\u001c:l\u0013\t\u0001TF\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\t\u0011I\u0002!\u0011!Q\u0001\n-\nqB]3rk\u0016\u001cHo\u00115b]:,G\u000e\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005!\u0011\r]5t+\u00051\u0004CA\u000f8\u0013\tA$AA\u0005LC\u001a\\\u0017-\u00119jg\"A!\b\u0001B\u0001B\u0003%a'A\u0003ba&\u001c\b\u0005\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0003\u0011!\u0018.\\3\u0011\u0005y:U\"A \u000b\u0005E\u0001%BA!C\u0003\u0019\u0019w.\\7p]*\u0011Qa\u0011\u0006\u0003\t\u0016\u000ba!\u00199bG\",'\"\u0001$\u0002\u0007=\u0014x-\u0003\u0002I\u007f\t!A+[7f\u0011!Q\u0005A!A!\u0002\u0013\u0019\u0013A\u00038v[RC'/Z1eg\"AA\n\u0001B\u0001B\u0003%Q*A\u0010sKF,Xm\u001d;IC:$G.\u001a:Bm\u001eLE\r\\3NKR\u0014\u0018n\u0019(b[\u0016\u0004\"AT)\u000f\u0005%y\u0015B\u0001)\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005AS\u0001\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B'\u0002-1|w-\u00118e)\"\u0014X-\u00193OC6,\u0007K]3gSbD\u0001b\u0006\u0001\u0003\u0006\u0004%IaV\u000b\u00021B\u0011\u0011lW\u0007\u00025*\u0011q\u0003Q\u0005\u00039j\u0013q!T3ue&\u001c7\u000f\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003Y\u0003!iW\r\u001e:jGN\u0004\u0003\"\u00021\u0001\t\u0003\t\u0017A\u0002\u001fj]&$h\b\u0006\u0006cG\u0012,gm\u001a5jU.\u0004\"!\b\u0001\t\u000bmy\u0006\u0019\u0001\u000f\t\u000b\u0005z\u0006\u0019A\u0012\t\u000b%z\u0006\u0019A\u0016\t\u000bQz\u0006\u0019\u0001\u001c\t\u000bqz\u0006\u0019A\u001f\t\u000b){\u0006\u0019A\u0012\t\u000b1{\u0006\u0019A'\t\u000bU{\u0006\u0019A'\t\u000b]y\u0006\u0019\u0001-\t\u000f5\u0004!\u0019!C\u0005]\u0006qA\u000f\u001b:fC\u0012\u0004vn\u001c7TSj,W#A8\u0011\u0005ALX\"A9\u000b\u0005I\u001c\u0018AB1u_6L7M\u0003\u0002uk\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Y<\u0018\u0001B;uS2T\u0011\u0001_\u0001\u0005U\u00064\u0018-\u0003\u0002{c\ni\u0011\t^8nS\u000eLe\u000e^3hKJDa\u0001 \u0001!\u0002\u0013y\u0017a\u0004;ie\u0016\fG\rU8pYNK'0\u001a\u0011\t\u000fy\u0004!\u0019!C\u0005\u007f\u0006\u0011\u0012mZ4sK\u001e\fG/Z%eY\u0016lU\r^3s+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005MQBAA\u0003\u0015\u0011\t9!!\u0003\u0002\t\r|'/\u001a\u0006\u0004/\u0005-!\u0002BA\u0007\u0003\u001f\ta!_1n[\u0016\u0014(BAA\t\u0003\r\u0019w.\\\u0005\u0005\u0003+\t)AA\u0003NKR,'\u000f\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\u0001\u0003M\twm\u001a:fO\u0006$X-\u00133mK6+G/\u001a:!\u0011%\ti\u0002\u0001b\u0001\n\u0013\ty\"A\u000euQJ,\u0017\r\u001a9p_2\u001c\u0015\r]1dSRL8+\u001a8t_J|\u0005\u000f^\u000b\u0003\u0003C\u0001R!CA\u0012\u0003OI1!!\n\u000b\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011,!\u000b\n\u0007\u0005-\"L\u0001\u0004TK:\u001cxN\u001d\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\"\u0005aB\u000f\u001b:fC\u0012\u0004xn\u001c7DCB\f7-\u001b;z'\u0016t7o\u001c:PaR\u0004\u0003\"CA\u001a\u0001\t\u0007I\u0011AA\u001b\u0003%\u0011XO\u001c8bE2,7/\u0006\u0002\u00028A1\u0011\u0011HA\"\u0003\u000fj!!a\u000f\u000b\t\u0005u\u0012qH\u0001\b[V$\u0018M\u00197f\u0015\r\t\tEC\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA#\u0003w\u00111\"\u0011:sCf\u0014UO\u001a4feB\u0019Q$!\u0013\n\u0007\u0005-#AA\nLC\u001a\\\u0017MU3rk\u0016\u001cH\u000fS1oI2,'\u000f\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA\u001c\u0003)\u0011XO\u001c8bE2,7\u000f\t\u0005\b\u0003'\u0002A\u0011AA+\u00035\u0019'/Z1uK\"\u000bg\u000e\u001a7feR!\u0011qKA/!\rI\u0011\u0011L\u0005\u0004\u00037R!\u0001B+oSRDq!a\u0018\u0002R\u0001\u00071%\u0001\u0002jI\"9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0014\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u0011\t9&a\u001a\t\u000f\u0005%\u0014\u0011\ra\u0001G\u00059a.Z<TSj,\u0007bBA7\u0001\u0011\u0005\u0011qN\u0001\tg\",H\u000fZ8x]R\u0011\u0011q\u000b")
public class KafkaRequestHandlerPool
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final KafkaApis apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final Metrics metrics;
    private final AtomicInteger threadPoolSize;
    private final Meter aggregateIdleMeter;
    private final Option<Sensor> threadpoolCapacitySensorOpt;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    private Logger logger$lzycompute() {
        KafkaRequestHandlerPool kafkaRequestHandlerPool = this;
        synchronized (kafkaRequestHandlerPool) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public KafkaApis apis() {
        return this.apis;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    private Option<Sensor> threadpoolCapacitySensorOpt() {
        return this.threadpoolCapacitySensorOpt;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        RequestLogFilter requestLogFilter = this.config.newRequestLogFilter();
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), requestLogFilter, this.apis(), this.time));
        KafkaThread.daemon((String)new StringBuilder().append((Object)this.logAndThreadNamePrefix).append((Object)"-kafka-request-handler-").append((Object)BoxesRunTime.boxToInteger((int)id)).toString(), (Runnable)((Runnable)this.runnables().apply(id))).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)new Serializable(this, newSize, currentSize){
            public static final long serialVersionUID = 0L;
            private final int newSize$1;
            private final int currentSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resizing request handler thread pool size from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentSize$1), BoxesRunTime.boxToInteger((int)this.newSize$1)}));
            }
            {
                this.newSize$1 = newSize$1;
                this.currentSize$1 = currentSize$1;
            }
        });
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaRequestHandlerPool $outer;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.$outer.createHandler(i);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)new Serializable(this, currentSize){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaRequestHandlerPool $outer;
                private final int currentSize$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    ((KafkaRequestHandler)this.$outer.runnables().remove(this.currentSize$1 - i)).stop();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.currentSize$1 = currentSize$1;
                }
            });
        }
        this.threadPoolSize().set(newSize);
        this.threadpoolCapacitySensorOpt().foreach((Function1)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final int newSize$1;

            public final void apply(Sensor sensor2) {
                sensor2.record(100.0 * (double)this.newSize$1);
            }
            {
                this.newSize$1 = newSize$1;
            }
        });
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "shutting down";
            }
        });
        this.runnables().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaRequestHandler handler) {
                handler.initiateShutdown();
            }
        });
        this.runnables().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaRequestHandler handler) {
                handler.awaitShutdown();
            }
        });
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "shut down completely";
            }
        });
    }

    public KafkaRequestHandlerPool(KafkaConfig config, int brokerId, RequestChannel requestChannel, KafkaApis apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix, Metrics metrics) {
        None$ none$;
        this.config = config;
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        this.metrics = metrics;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.threadPoolSize = new AtomicInteger(numThreads);
        this.aggregateIdleMeter = this.newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS, this.newMeter$default$4());
        String string = requestHandlerAvgIdleMetricName;
        String string2 = "RequestHandlerAvgIdlePercent";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Sensor sensor2 = metrics.sensor("TotalIoThreadsPercentage");
            sensor2.add(ThreadUsageMetrics$.MODULE$.ioThreadPoolCapacityMetricName(metrics), (MeasurableStat)new Value());
            sensor2.record(100.0 * (double)numThreads);
            none$ = new Some((Object)sensor2);
        } else {
            none$ = None$.MODULE$;
        }
        this.threadpoolCapacitySensorOpt = none$;
        this.logIdent_$eq(new StringBuilder().append((Object)"[").append((Object)logAndThreadNamePrefix).append((Object)" Kafka Request Handler on Broker ").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).append((Object)"], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaRequestHandlerPool $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.createHandler(i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

