/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsReporter;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class KafkaServer$ {
    public static final KafkaServer$ MODULE$;
    private final long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS;
    private final String MULTI_TENANT_AUTHORIZER_CLASS_NAME;

    static {
        new KafkaServer$();
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> copyKafkaConfigToLog(KafkaConfig kafkaConfig) {
        void var2_2;
        HashMap<String, Object> logProps = new HashMap<String, Object>();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), kafkaConfig.logSegmentBytes());
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), kafkaConfig.logRollTimeMillis());
        logProps.put(LogConfig$.MODULE$.SegmentJitterMsProp(), kafkaConfig.logRollTimeJitterMillis());
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), kafkaConfig.logIndexSizeMaxBytes());
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), kafkaConfig.logFlushIntervalMessages());
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), kafkaConfig.logFlushIntervalMs());
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), kafkaConfig.logRetentionBytes());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.long2Long(kafkaConfig.logRetentionTimeMillis()));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), kafkaConfig.messageMaxBytes());
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), kafkaConfig.logIndexIntervalBytes());
        logProps.put(LogConfig$.MODULE$.DeleteRetentionMsProp(), kafkaConfig.logCleanerDeleteRetentionMs());
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), kafkaConfig.logCleanerMinCompactionLagMs());
        logProps.put(LogConfig$.MODULE$.MaxCompactionLagMsProp(), kafkaConfig.logCleanerMaxCompactionLagMs());
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), kafkaConfig.logDeleteDelayMs());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), kafkaConfig.logCleanerMinCleanRatio());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), kafkaConfig.logCleanupPolicy());
        logProps.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), kafkaConfig.minInSyncReplicas());
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), kafkaConfig.compressionType());
        logProps.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), kafkaConfig.uncleanLeaderElectionEnable());
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), kafkaConfig.logPreAllocateEnable());
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), kafkaConfig.logMessageFormatVersion().version());
        logProps.put(LogConfig$.MODULE$.MessageTimestampTypeProp(), kafkaConfig.logMessageTimestampType().name);
        logProps.put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Predef$.MODULE$.long2Long(kafkaConfig.logMessageTimestampDifferenceMaxMs()));
        logProps.put(LogConfig$.MODULE$.MessageDownConversionEnableProp(), Predef$.MODULE$.boolean2Boolean(kafkaConfig.logMessageDownConversionEnable()));
        logProps.put(LogConfig$.MODULE$.TierEnableProp(), kafkaConfig.tierEnable());
        logProps.put(LogConfig$.MODULE$.TierLocalHotsetBytesProp(), kafkaConfig.tierLocalHotsetBytes());
        logProps.put(LogConfig$.MODULE$.TierLocalHotsetMsProp(), kafkaConfig.tierLocalHotsetMs());
        logProps.put(LogConfig$.MODULE$.TierSegmentHotsetRollMinBytesProp(), kafkaConfig.tierSegmentHotsetRollMinBytes());
        logProps.put(LogConfig$.MODULE$.PreferTierFetchMsProp(), kafkaConfig.preferTierFetchMs());
        logProps.put(LogConfig$.MODULE$.SegmentSpeculativePrefetchEnableProp(), kafkaConfig.segmentSpeculativePrefetchEnable());
        logProps.put(LogConfig$.MODULE$.AppendRecordInterceptorClassesProp(), kafkaConfig.getList(KafkaConfig$.MODULE$.AppendRecordInterceptorClassesProp()));
        logProps.computeIfAbsent("confluent.schema.registry.url", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.schema.registry.url");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.basic.auth.credentials.source", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.basic.auth.credentials.source");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.basic.auth.user.info", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return Option$.MODULE$.apply((Object)this.kafkaConfig$1.getPassword("confluent.basic.auth.user.info")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Password x$1) {
                        return x$1.value();
                    }
                }).orNull(Predef$.MODULE$.$conforms());
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.bearer.auth.credentials.source", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.bearer.auth.credentials.source");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.bearer.auth.token", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return Option$.MODULE$.apply((Object)this.kafkaConfig$1.getPassword("confluent.bearer.auth.token")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Password x$2) {
                        return x$2.value();
                    }
                }).orNull(Predef$.MODULE$.$conforms());
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.protocol", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.ssl.protocol");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.keystore.type", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.ssl.keystore.type");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.keystore.location", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.ssl.keystore.location");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.keystore.password", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return Option$.MODULE$.apply((Object)this.kafkaConfig$1.getPassword("confluent.ssl.keystore.password")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Password x$3) {
                        return x$3.value();
                    }
                }).orNull(Predef$.MODULE$.$conforms());
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.key.password", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return Option$.MODULE$.apply((Object)this.kafkaConfig$1.getPassword("confluent.ssl.key.password")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Password x$4) {
                        return x$4.value();
                    }
                }).orNull(Predef$.MODULE$.$conforms());
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.truststore.type", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.ssl.truststore.type");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.truststore.location", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.ssl.truststore.location");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.truststore.password", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public Object apply(String t) {
                return Option$.MODULE$.apply((Object)this.kafkaConfig$1.getPassword("confluent.ssl.truststore.password")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Password x$5) {
                        return x$5.value();
                    }
                }).orNull(Predef$.MODULE$.$conforms());
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        return var2_2;
    }

    public void augmentWithKafkaConfig(Map<String, Object> logProps, KafkaConfig kafkaConfig) {
        if (kafkaConfig != null) {
            logProps.put("confluent.schema.registry.max.cache.size", kafkaConfig.getInt("confluent.schema.registry.max.cache.size"));
            logProps.put("confluent.schema.registry.max.retries", kafkaConfig.getInt("confluent.schema.registry.max.retries"));
            logProps.put("confluent.schema.registry.retries.wait.ms", kafkaConfig.getInt("confluent.schema.registry.retries.wait.ms"));
            logProps.put("confluent.missing.id.query.range", kafkaConfig.getInt("confluent.missing.id.query.range"));
            logProps.put("confluent.missing.id.cache.ttl.sec", kafkaConfig.getLong("confluent.missing.id.cache.ttl.sec"));
            logProps.put("confluent.missing.schema.cache.ttl.sec", kafkaConfig.getLong("confluent.missing.schema.cache.ttl.sec"));
        }
    }

    public MetricConfig metricConfig(KafkaConfig kafkaConfig) {
        return new MetricConfig().samples(Predef$.MODULE$.Integer2int(kafkaConfig.metricNumSamples())).recordLevel(Sensor.RecordingLevel.forName((String)kafkaConfig.metricRecordingLevel())).timeWindow(Predef$.MODULE$.Long2long(kafkaConfig.metricSampleWindowMs()), TimeUnit.MILLISECONDS);
    }

    public Option<ZKClientConfig> zkClientConfigFromKafkaConfig(KafkaConfig config, boolean forceZkSslClientEnable) {
        None$ none$;
        if (config.zkSslClientEnable() || forceZkSslClientEnable) {
            ZKClientConfig clientConfig = new ZKClientConfig();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "true");
            config.zkClientCnxnSocketClassName().foreach((Function1)new Serializable(clientConfig){
                public static final long serialVersionUID = 0L;
                private final ZKClientConfig clientConfig$1;

                public final void apply(String x$6) {
                    KafkaConfig$.MODULE$.setZooKeeperClientProperty(this.clientConfig$1, KafkaConfig$.MODULE$.ZkClientCnxnSocketProp(), x$6);
                }
                {
                    this.clientConfig$1 = clientConfig$1;
                }
            });
            config.zkSslKeyStoreLocation().foreach((Function1)new Serializable(clientConfig){
                public static final long serialVersionUID = 0L;
                private final ZKClientConfig clientConfig$1;

                public final void apply(String x$7) {
                    KafkaConfig$.MODULE$.setZooKeeperClientProperty(this.clientConfig$1, KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp(), x$7);
                }
                {
                    this.clientConfig$1 = clientConfig$1;
                }
            });
            config.zkSslKeyStorePassword().foreach((Function1)new Serializable(clientConfig){
                public static final long serialVersionUID = 0L;
                private final ZKClientConfig clientConfig$1;

                public final void apply(Password x) {
                    KafkaConfig$.MODULE$.setZooKeeperClientProperty(this.clientConfig$1, KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp(), x.value());
                }
                {
                    this.clientConfig$1 = clientConfig$1;
                }
            });
            config.zkSslKeyStoreType().foreach((Function1)new Serializable(clientConfig){
                public static final long serialVersionUID = 0L;
                private final ZKClientConfig clientConfig$1;

                public final void apply(String x$8) {
                    KafkaConfig$.MODULE$.setZooKeeperClientProperty(this.clientConfig$1, KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp(), x$8);
                }
                {
                    this.clientConfig$1 = clientConfig$1;
                }
            });
            config.zkSslTrustStoreLocation().foreach((Function1)new Serializable(clientConfig){
                public static final long serialVersionUID = 0L;
                private final ZKClientConfig clientConfig$1;

                public final void apply(String x$9) {
                    KafkaConfig$.MODULE$.setZooKeeperClientProperty(this.clientConfig$1, KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp(), x$9);
                }
                {
                    this.clientConfig$1 = clientConfig$1;
                }
            });
            config.zkSslTrustStorePassword().foreach((Function1)new Serializable(clientConfig){
                public static final long serialVersionUID = 0L;
                private final ZKClientConfig clientConfig$1;

                public final void apply(Password x) {
                    KafkaConfig$.MODULE$.setZooKeeperClientProperty(this.clientConfig$1, KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp(), x.value());
                }
                {
                    this.clientConfig$1 = clientConfig$1;
                }
            });
            config.zkSslTrustStoreType().foreach((Function1)new Serializable(clientConfig){
                public static final long serialVersionUID = 0L;
                private final ZKClientConfig clientConfig$1;

                public final void apply(String x$10) {
                    KafkaConfig$.MODULE$.setZooKeeperClientProperty(this.clientConfig$1, KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp(), x$10);
                }
                {
                    this.clientConfig$1 = clientConfig$1;
                }
            });
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslProtocolProp(), config.ZkSslProtocol());
            config.ZkSslEnabledProtocols().foreach((Function1)new Serializable(clientConfig){
                public static final long serialVersionUID = 0L;
                private final ZKClientConfig clientConfig$1;

                public final void apply(List<String> x$11) {
                    KafkaConfig$.MODULE$.setZooKeeperClientProperty(this.clientConfig$1, KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp(), x$11);
                }
                {
                    this.clientConfig$1 = clientConfig$1;
                }
            });
            config.ZkSslCipherSuites().foreach((Function1)new Serializable(clientConfig){
                public static final long serialVersionUID = 0L;
                private final ZKClientConfig clientConfig$1;

                public final void apply(List<String> x$12) {
                    KafkaConfig$.MODULE$.setZooKeeperClientProperty(this.clientConfig$1, KafkaConfig$.MODULE$.ZkSslCipherSuitesProp(), x$12);
                }
                {
                    this.clientConfig$1 = clientConfig$1;
                }
            });
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp(), config.ZkSslEndpointIdentificationAlgorithm());
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslCrlEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslCrlEnable())).toString());
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslOcspEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslOcspEnable())).toString());
            none$ = new Some((Object)clientConfig);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean zkClientConfigFromKafkaConfig$default$2() {
        return false;
    }

    public long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS() {
        return this.MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS;
    }

    public String MULTI_TENANT_AUTHORIZER_CLASS_NAME() {
        return this.MULTI_TENANT_AUTHORIZER_CLASS_NAME;
    }

    public Time $lessinit$greater$default$2() {
        return Time.SYSTEM;
    }

    public Option<String> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Seq<KafkaMetricsReporter> $lessinit$greater$default$4() {
        return Nil$.MODULE$;
    }

    private KafkaServer$() {
        MODULE$ = this;
        this.MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS = 120000L;
        this.MULTI_TENANT_AUTHORIZER_CLASS_NAME = "io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer";
    }
}

