/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaAlterLogDirsThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierState;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.fetcher.TierStateFetcher;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\teg\u0001B\u0001\u0003\u0001\u001d\u0011\u0011DU3qY&\u001c\u0017-\u00117uKJdun\u001a#jeN$\u0006N]3bI*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0011%i\u0001A!A!\u0002\u0013q\u0001$\u0001\u0003oC6,\u0007CA\b\u0016\u001d\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011ac\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\t\u0012BA\u0007\u001a\u0013\tQ2D\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$'B\u0001\u000f\u0005\u0003\u0015)H/\u001b7t\u0011%q\u0002A!A!\u0002\u0013yR%\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#\t\u000591\r\\;ti\u0016\u0014\u0018B\u0001\u0013\"\u00059\u0011%o\\6fe\u0016sG\rU8j]RL!A\b\u0006\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\nAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"!C\u0015\n\u0005)\u0012!aC&bM.\f7i\u001c8gS\u001eD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\"!\u0003\u0018\n\u0005=\u0012!\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014A\u0003:fa2L7-Y'heB\u0011\u0011bM\u0005\u0003i\t\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0003\u0015\tXo\u001c;b!\tI\u0001(\u0003\u0002:\u0005\t9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM\u001d\u0005\nw\u0001\u0011\t\u0011)A\u0005y}\n\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0011\u0005%i\u0014B\u0001 \u0003\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8/\u0003\u0002<\u0015!)\u0011\t\u0001C\u0001\u0005\u00061A(\u001b8jiz\"\u0002b\u0011#F\r\u001eC\u0015J\u0013\t\u0003\u0013\u0001AQ!\u0004!A\u00029AQA\b!A\u0002}AQa\n!A\u0002!BQ\u0001\f!A\u00025BQ!\r!A\u0002IBQA\u000e!A\u0002]BQa\u000f!A\u0002qBq\u0001\u0014\u0001C\u0002\u0013%Q*A\u0005sKBd\u0017nY1JIV\ta\n\u0005\u0002\u0011\u001f&\u0011\u0001+\u0005\u0002\u0004\u0013:$\bB\u0002*\u0001A\u0003%a*\u0001\u0006sKBd\u0017nY1JI\u0002Bq\u0001\u0016\u0001C\u0002\u0013%Q+\u0001\u0005nCb\u0014\u0015\u0010^3t+\u00051\u0006CA,]\u001b\u0005A&BA-[\u0003\u0011a\u0017M\\4\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0017\u0002\b\u0013:$XmZ3s\u0011\u0019y\u0006\u0001)A\u0005-\u0006IQ.\u0019=CsR,7\u000f\t\u0005\bC\u0002\u0011\r\u0011\"\u0003V\u0003%1W\r^2i'&TX\r\u0003\u0004d\u0001\u0001\u0006IAV\u0001\u000bM\u0016$8\r[*ju\u0016\u0004\u0003bB3\u0001\u0001\u0004%IAZ\u0001\u0014S:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\\\u000b\u0002OB\u0019\u0001\u0003\u001b6\n\u0005%\f\"AB(qi&|g\u000e\u0005\u0002lg6\tAN\u0003\u0002n]\u000611m\\7n_:T!!B8\u000b\u0005A\f\u0018AB1qC\u000eDWMC\u0001s\u0003\ry'oZ\u0005\u0003i2\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004w\u0001\u0001\u0007I\u0011B<\u0002/%t\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8`I\u0015\fHC\u0001=|!\t\u0001\u00120\u0003\u0002{#\t!QK\\5u\u0011\u001daX/!AA\u0002\u001d\f1\u0001\u001f\u00132\u0011\u0019q\b\u0001)Q\u0005O\u0006!\u0012N\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]\u0002Bq!!\u0001\u0001\t#\n\u0019!A\u0006mCR,7\u000f^#q_\u000eDG\u0003BA\u0003\u0003\u000f\u00012\u0001\u00055O\u0011\u0019\tIa a\u0001U\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA\u0007\u0001\u0011E\u0013qB\u0001\u000fY><7\u000b^1si>3gm]3u)\u0011\t\t\"a\u0006\u0011\u0007A\t\u0019\"C\u0002\u0002\u0016E\u0011A\u0001T8oO\"9\u0011\u0011BA\u0006\u0001\u0004Q\u0007bBA\u000e\u0001\u0011E\u0013QD\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u000b\u0005\u0003#\ty\u0002C\u0004\u0002\n\u0005e\u0001\u0019\u00016\t\u000f\u0005\r\u0002\u0001\"\u0015\u0002&\u0005\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\u0005\u001d\u0012qFA\u0019!\u0011\u0001\u0002.!\u000b\u0011\u0007%\tY#C\u0002\u0002.\t\u0011ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000eC\u0004\u0002\n\u0005\u0005\u0002\u0019\u00016\t\u000f\u0005M\u0012\u0011\u0005a\u0001\u001d\u0006)Q\r]8dQ\"9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0012a\u00044fi\u000eDgI]8n\u0019\u0016\fG-\u001a:\u0015\t\u0005m\u0012q\n\t\b\u0003{\t\u0019E[A$\u001b\t\tyDC\u0002\u0002BE\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)%a\u0010\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002J\u0005-S\"\u0001\u0001\n\u0007\u00055#BA\u0005GKR\u001c\u0007\u000eR1uC\"A\u0011\u0011KA\u001b\u0001\u0004\t\u0019&\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0005\u0003\u0002V\u0005\u0005d\u0002BA,\u0003;j!!!\u0017\u000b\u0007\u0005mC.\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\ty&!\u0017\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\u0005\r\u0014Q\r\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\ty&!\u0017\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l\u0005!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\u0002\"!\u001c\u0002|\u0005u\u0014\u0011\u0011\t\u0005!!\fy\u0007\u0005\u0003\u0002r\u0005]TBAA:\u0015\r\t)\bB\u0001\u0004Y><\u0017\u0002BA=\u0003g\u0012Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007bBA\u0005\u0003O\u0002\rA\u001b\u0005\t\u0003\u007f\n9\u00071\u0001\u0002\u0012\u0005Ya-\u001a;dQ>3gm]3u\u0011!\t\u0019)a\u001aA\u0002\u0005\u0015\u0015!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0004\u0002\b\u0006\u001d\u0016Q\u0016\b\u0005\u0003\u0013\u000b\u0019K\u0004\u0003\u0002\f\u0006\u0005f\u0002BAG\u0003?sA!a$\u0002\u001e:!\u0011\u0011SAN\u001d\u0011\t\u0019*!'\u000e\u0005\u0005U%bAAL\r\u00051AH]8pizJ\u0011A]\u0005\u0003aFL!!B8\n\u00055t\u0017bAA.Y&!\u0011QUA-\u000351U\r^2i%\u0016\u001c\bo\u001c8tK&!\u0011\u0011VAV\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!\u0011QUA-!\u0011\ty+!.\u000e\u0005\u0005E&bAAZY\u00061!/Z2pe\u0012LA!a.\u00022\n9!+Z2pe\u0012\u001c\bbBA^\u0001\u0011\u0005\u0013QX\u0001\u000eC\u0012$\u0007+\u0019:uSRLwN\\:\u0015\t\u0005}\u0016Q\u0019\t\u0006\u0003{\t\tM[\u0005\u0005\u0003\u0007\fyDA\u0002TKRD\u0001\"a2\u0002:\u0002\u0007\u0011\u0011Z\u0001\u0013S:LG/[1m\r\u0016$8\r[*uCR,7\u000fE\u0004\u0002>\u0005\r#.!\u000b\t\u000f\u00055\u0007\u0001\"\u0015\u0002P\u0006ib-\u001a;dQ\u0016\u000b'\u000f\\5fgR|eMZ:fi\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0004\u0002\u0012\u0005E\u00171\u001b\u0005\b\u0003\u0013\tY\r1\u0001k\u0011\u001d\t).a3A\u00029\u000b1\u0002\\3bI\u0016\u0014X\t]8dQ\"9\u0011\u0011\u001c\u0001\u0005R\u0005m\u0017A\t4fi\u000eDW)\u0019:mS\u0016\u001cH\u000fT8dC2|eMZ:fi\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0004\u0002\u0012\u0005u\u0017q\u001c\u0005\b\u0003\u0013\t9\u000e1\u0001k\u0011\u001d\t).a6A\u00029Cq!a9\u0001\t#\n)/A\u000egKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u0003#\t9/!;\t\u000f\u0005%\u0011\u0011\u001da\u0001U\"9\u0011Q[Aq\u0001\u0004q\u0005bBAw\u0001\u0011\u0005\u0013q^\u0001\u0015M\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\t\u0005E\u0018\u0011 \t\b\u0003{\t\u0019E[Az!\u0011\t9&!>\n\t\u0005]\u0018\u0011\f\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0011!\tY0a;A\u0002\u0005u\u0018A\u00039beRLG/[8ogB9\u0011QHA\"U\u0006}\b\u0003BA%\u0005\u0003I1Aa\u0001\u000b\u0005%)\u0005o\\2i\t\u0006$\u0018\rC\u0004\u0003\b\u0001!\tF!\u0003\u0002?%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G-\u0006\u0002\u0003\fA\u0019\u0001C!\u0004\n\u0007\t=\u0011CA\u0004C_>dW-\u00198\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016\u0005AAO];oG\u0006$X\rF\u0003y\u0005/\u0011I\u0002C\u0004\u0002\n\tE\u0001\u0019\u00016\t\u0011\tm!\u0011\u0003a\u0001\u0005;\tq\u0002\u001e:v]\u000e\fG/[8o'R\fG/\u001a\t\u0004\u0013\t}\u0011b\u0001B\u0011\u0005\t)rJ\u001a4tKR$&/\u001e8dCRLwN\\*uCR,\u0007b\u0002B\u0013\u0001\u0011E#qE\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$R\u0001\u001fB\u0015\u0005WAq!!\u0003\u0003$\u0001\u0007!\u000e\u0003\u0005\u0003.\t\r\u0002\u0019AA\t\u0003\u0019ygMZ:fi\"9!\u0011\u0007\u0001\u0005\n\tM\u0012A\u00058fqR\u0014V-\u00193z!\u0006\u0014H/\u001b;j_:$BA!\u000e\u0003DA!\u0001\u0003\u001bB\u001c!\u0019\u0001\"\u0011\b6\u0003>%\u0019!1H\t\u0003\rQ+\b\u000f\\33!\rI!qH\u0005\u0004\u0005\u0003\u0012!a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0007\u0002\u0003B#\u0005_\u0001\rAa\u0012\u0002\u0019A\f'\u000f^5uS>tW*\u00199\u0011\u000f\u0005u\u00121\t6\u0003>!9!1\n\u0001\u0005\n\t5\u0013AF:fY\u0016\u001cG\u000fU1si&$\u0018n\u001c8U_\u001a+Go\u00195\u0015\t\tU\"q\n\u0005\t\u0005\u000b\u0012I\u00051\u0001\u0003H!9!1\u000b\u0001\u0005\n\tU\u0013A\u00062vS2$g)\u001a;dQ\u001a{'\u000fU1si&$\u0018n\u001c8\u0015\r\t]#Q\u000fB=!\u0019\u0011IFa\u001a\u0003n9!!1\fB2\u001d\u0011\u0011iF!\u0019\u000f\t\u0005M%qL\u0005\u0002\u000b%\u00111\u0001B\u0005\u0004\u0005K\u0012\u0011!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0005\u0005\u0005S\u0012YG\u0001\u000bSKN,H\u000e^,ji\"\u0004\u0016M\u001d;ji&|gn\u001d\u0006\u0004\u0005K\u0012\u0001\u0003\u0002\ti\u0005_\u0002BA!\u0017\u0003r%!!1\u000fB6\u00051\u0011V\r\u001d7jG\u00064U\r^2i\u0011\u001d\u00119H!\u0015A\u0002)\f!\u0001\u001e9\t\u0011\tm$\u0011\u000ba\u0001\u0005{\t!BZ3uG\"\u001cF/\u0019;f\u0011\u001d\u0011y\b\u0001C\u0001\u0005\u0003\u000b!BY;jY\u00124U\r^2i)\u0011\u00119Fa!\t\u0011\t\u0015#Q\u0010a\u0001\u0005\u000fBqAa\"\u0001\t#\u0012I)\u0001\np]J+7\u000f^8sKRKWM]*uCR,Gc\u0002=\u0003\f\n5%\u0011\u0013\u0005\b\u0003\u0013\u0011)\t1\u0001k\u0011!\u0011yI!\"A\u0002\u0005E\u0011!\u00069s_B|7/\u001a3M_\u000e\fG\u000eT8h'R\f'\u000f\u001e\u0005\t\u0005'\u0013)\t1\u0001\u0003\u0016\u0006IA/[3s'R\fG/\u001a\t\u0004\u0013\t]\u0015b\u0001BM\u0005\tIA+[3s'R\fG/\u001a\u0005\b\u0005;\u0003A\u0011\u000bBP\u000391W\r^2i)&,'o\u0015;bi\u0016$bA!)\u00032\nM\u0006C\u0002BR\u0005[\u0013)*\u0004\u0002\u0003&*!!q\u0015BU\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0005WS\u0016\u0001B;uS2LAAa,\u0003&\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\t\u000f\u0005%!1\u0014a\u0001U\"A!Q\u0017BN\u0001\u0004\u00119,\u0001\nuS\u0016\u0014xJ\u00196fGRlU\r^1eCR\f\u0007\u0003\u0002B]\u0005\u0007l!Aa/\u000b\t\tu&qX\u0001\u0007I>l\u0017-\u001b8\u000b\u0007\t\u0005G!\u0001\u0003uS\u0016\u0014\u0018\u0002\u0002Bc\u0005w\u0013!\u0003V5fe>\u0013'.Z2u\u001b\u0016$\u0018\rZ1uC\"9!\u0011\u001a\u0001\u0005R\t-\u0017aH7bi\u0016\u0014\u0018.\u00197ju\u0016$\u0016.\u001a:Ti\u0006$X-\u00168uS2|eMZ:fiR1!Q\u001aBj\u0005+\u0004bAa)\u0003P\n]\u0016\u0002\u0002Bi\u0005K\u0013aAR;ukJ,\u0007bBA\u0005\u0005\u000f\u0004\rA\u001b\u0005\t\u0005/\u00149\r1\u0001\u0002\u0012\u0005aA/\u0019:hKR|eMZ:fi\u0002")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    public final ReplicaManager kafka$server$ReplicaAlterLogDirsThread$$replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> kafka$server$ReplicaAlterLogDirsThread$$inProgressPartition;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> kafka$server$ReplicaAlterLogDirsThread$$inProgressPartition() {
        return this.kafka$server$ReplicaAlterLogDirsThread$$inProgressPartition;
    }

    public void kafka$server$ReplicaAlterLogDirsThread$$inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.kafka$server$ReplicaAlterLogDirsThread$$inProgressPartition = x$1;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), false, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)new Serializable(this, partitionData){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;
            private final ObjectRef partitionData$1;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responsePartitionData) {
                this.$outer.kafka$server$ReplicaAlterLogDirsThread$$processResponseCallback$1(responsePartitionData, this.partitionData$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionData$1 = partitionData$1;
            }
        }, request.isolationLevel(), (Option<ClientMetadata>)None$.MODULE$);
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to fetch data for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray()).mkString(",")})));
        }
        return ((Seq)partitionData.elem).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Partition partition = (Partition)this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.nonOfflinePartition(topicPartition).get();
        AbstractLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark);
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, OffsetAndEpoch> initialFetchStates) {
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaAlterLogDirsThread $outer;

                public final boolean apply(Tuple2<TopicPartition, OffsetAndEpoch> x0$2) {
                    Tuple2<TopicPartition, OffsetAndEpoch> tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        boolean bl = this.$outer.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.futureLogExists(tp);
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return super.addPartitions((Map<TopicPartition, OffsetAndEpoch>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        Partition partition = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getPartitionOrException(topicPartition, false);
        return partition.localLogOrException().logStartOffset();
    }

    @Override
    public long fetchEarliestLocalOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        throw new UnsupportedOperationException("Alter log dirs does not support tiered partitions");
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        Partition partition = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getPartitionOrException(topicPartition, false);
        return partition.localLogOrException().logEndOffset();
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        return (Map)partitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<TopicPartition, EpochEndOffset> apply(Tuple2<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> x0$3) {
                Tuple2 tuple2;
                Tuple2<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> tuple22 = x0$3;
                if (tuple22 == null) throw new MatchError(tuple22);
                TopicPartition tp = (TopicPartition)tuple22._1();
                OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)tuple22._2();
                try {
                    EpochEndOffset epochEndOffset;
                    if (epochData.leaderEpoch == -1) {
                        epochEndOffset = new EpochEndOffset(-1, -1L);
                    } else {
                        Partition partition = this.$outer.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getPartitionOrException(tp, false);
                        epochEndOffset = partition.lastOffsetForLeaderEpoch(epochData.currentLeaderEpoch, epochData.leaderEpoch, false);
                    }
                    EpochEndOffset endOffset = epochEndOffset;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                    return tuple2;
                }
                catch (Throwable throwable) {
                    this.$outer.warn((Function0<String>)new Serializable(this, tp){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition tp$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when getting EpochEndOffset for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1}));
                        }
                        {
                            this.tp$1 = tp$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable t$1;

                        public final Throwable apply() {
                            return this.t$1;
                        }
                        {
                            this.t$1 = t$1;
                        }
                    });
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)throwable), -1, -1L));
                }
                return tuple2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return true;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        Partition partition = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset2) {
        Partition partition = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateFullyAndStartAt(offset2, true);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((TraversableOnce)partitionMap.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, PartitionFetchState> x0$4) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$4;
                if (tuple2 != null) {
                    PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
                    boolean bl = partitionFetchState.isReadyForFetch();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).reduceLeftOption((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final Tuple2<TopicPartition, PartitionFetchState> apply(Tuple2<TopicPartition, PartitionFetchState> left, Tuple2<TopicPartition, PartitionFetchState> right) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2;
                block3: {
                    block2: {
                        if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$less((Object)((TopicPartition)right._1()).topic())) break block2;
                        String string = ((TopicPartition)left._1()).topic();
                        String string2 = ((TopicPartition)right._1()).topic();
                        if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                    }
                    tuple2 = left;
                    return tuple2;
                }
                tuple2 = right;
                return tuple2;
            }
        });
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Option<Tuple2<TopicPartition, PartitionFetchState>> option;
            Object object = new Object();
            try {
                this.kafka$server$ReplicaAlterLogDirsThread$$inProgressPartition().foreach((Function1)new Serializable(this, partitionMap, object){
                    public static final long serialVersionUID = 0L;
                    private final Map partitionMap$1;
                    public final Object nonLocalReturnKey1$1;

                    public final void apply(TopicPartition tp) {
                        Option fetchStateOpt = this.partitionMap$1.get((Object)tp);
                        fetchStateOpt.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(PartitionFetchState x$2) {
                                return x$2.isReadyForFetch();
                            }
                        }).foreach((Function1)new Serializable(this, tp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$selectPartitionToFetch$1 $outer;
                            private final TopicPartition tp$4;

                            public final Nothing$ apply(PartitionFetchState fetchState2) {
                                throw new NonLocalReturnControl(this.$outer.nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)this.tp$4, (Object)fetchState2)));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tp$4 = tp$4;
                            }
                        });
                    }
                    {
                        this.partitionMap$1 = partitionMap$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                this.kafka$server$ReplicaAlterLogDirsThread$$inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
                Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
                nextPartitionOpt.foreach((Function1)new Serializable(this, partitionMap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaAlterLogDirsThread $outer;
                    public final Map partitionMap$1;

                    public final void apply(Tuple2<TopicPartition, PartitionFetchState> x0$5) {
                        Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$5;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            PartitionFetchState fetchState2 = (PartitionFetchState)tuple2._2();
                            this.$outer.kafka$server$ReplicaAlterLogDirsThread$$inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
                            this.$outer.info((Function0<String>)new Serializable(this, tp, fetchState2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$selectPartitionToFetch$2 $outer;
                                private final TopicPartition tp$2;
                                private final PartitionFetchState fetchState$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning/resuming copy of partition ", " from offset ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$2, BoxesRunTime.boxToLong((long)this.fetchState$1.fetchOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Including this partition, there are ", " remaining partitions to copy by this thread."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.partitionMap$1.size())}))).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.tp$2 = tp$2;
                                    this.fetchState$1 = fetchState$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.partitionMap$1 = partitionMap$1;
                    }
                });
                option = nextPartitionOpt;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                option = (Option<Tuple2<TopicPartition, PartitionFetchState>>)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState2) {
        None$ none$;
        SetLike setLike;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            long logStartOffset2 = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.futureLocalLogOrException(tp).logStartOffset();
            setLike = requestMap.put(tp, new FetchRequest.PartitionData(fetchState2.fetchOffset(), logStartOffset2, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState2.currentLeaderEpoch()))));
        }
        catch (KafkaStorageException kafkaStorageException) {
            this.debug((Function0<String>)new Serializable(this, tp){
                public static final long serialVersionUID = 0L;
                private final TopicPartition tp$3;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to build fetch for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$3}));
                }
                {
                    this.tp$3 = tp$3;
                }
            }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                public static final long serialVersionUID = 0L;
                private final KafkaStorageException e$1;

                public final KafkaStorageException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            setLike = partitionsWithError.$plus$eq((Object)tp);
        }
        if (requestMap.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Option<Tuple2<TopicPartition, PartitionFetchState>> option;
        block6: {
            AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions;
            block3: {
                AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions2;
                block5: {
                    block4: {
                        Some some;
                        Tuple2 tuple2;
                        block2: {
                            if (!this.quota.isQuotaExceeded()) break block2;
                            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
                            break block3;
                        }
                        option = this.selectPartitionToFetch(partitionMap);
                        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block4;
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        PartitionFetchState fetchState2 = (PartitionFetchState)tuple2._2();
                        resultWithPartitions2 = this.buildFetchForPartition(tp, fetchState2);
                        break block5;
                    }
                    if (!None$.MODULE$.equals(option)) break block6;
                    resultWithPartitions2 = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
                }
                resultWithPartitions = resultWithPartitions2;
            }
            return resultWithPartitions;
        }
        throw new MatchError(option);
    }

    @Override
    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        throw new UnsupportedOperationException("Restoring tier state during an alter log dirs operation is not currently supported.");
    }

    public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierObjectMetadata tierObjectMetadata) {
        throw new UnsupportedOperationException("Fetching tier state during an alter log dirs operation is not currently supported.");
    }

    @Override
    public Future<TierObjectMetadata> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        throw new UnsupportedOperationException("Materializing tier state is not supported with alter log dirs.");
    }

    public final void kafka$server$ReplicaAlterLogDirsThread$$processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, FetchResponse.PartitionData<Records>> apply(Tuple2<TopicPartition, FetchPartitionData> x0$1) {
                Tuple2<TopicPartition, FetchPartitionData> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    FetchPartitionData data = (FetchPartitionData)tuple2._2();
                    java.util.List abortedTransactions = (java.util.List)data.abortedTransactions().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final java.util.List<FetchResponse.AbortedTransaction> apply(List<FetchResponse.AbortedTransaction> x$1) {
                            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(x$1).asJava();
                        }
                    }).orNull(Predef$.MODULE$.$conforms());
                    long lastStableOffset2 = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return -1L;
                        }
                    }));
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponse.PartitionData(data.error(), data.highWatermark(), lastStableOffset2, data.logStartOffset(), abortedTransactions, (BaseRecords)data.records()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), (Option<TierStateFetcher>)None$.MODULE$, false, brokerTopicStats);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.kafka$server$ReplicaAlterLogDirsThread$$inProgressPartition = None$.MODULE$;
    }
}

