/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.InputStream;
import java.util.concurrent.CancellationException;
import kafka.log.OffsetPosition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.TierOffsetIndexIterator;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;

final class OffsetIndexFetchRequest {
    OffsetIndexFetchRequest() {
    }

    static OffsetPosition fetchOffsetPositionForStartingOffset(CancellationContext cancellationContext, TierObjectStore tierObjectStore, TierObjectStore.ObjectMetadata tierObjectMetadata, long targetOffset) throws Exception {
        long startOffset = tierObjectMetadata.baseOffset();
        OffsetPosition defaultOffsetPosition = new OffsetPosition(startOffset, 0);
        try (TierObjectStoreResponse response = tierObjectStore.getObject(tierObjectMetadata, TierObjectStore.FileType.OFFSET_INDEX);){
            InputStream responseInputStream = response.getInputStream();
            OffsetPosition currentOffsetPosition = defaultOffsetPosition;
            TierOffsetIndexIterator tierOffsetIndexIterator = new TierOffsetIndexIterator(responseInputStream, startOffset);
            while (tierOffsetIndexIterator.hasNext()) {
                if (cancellationContext.isCancelled()) {
                    throw new CancellationException("Tiered offset index fetch request cancelled");
                }
                OffsetPosition op = (OffsetPosition)tierOffsetIndexIterator.next();
                if (targetOffset == op.offset()) {
                    currentOffsetPosition = op;
                    break;
                }
                if (targetOffset > op.offset()) {
                    currentOffsetPosition = op;
                    continue;
                }
                if (targetOffset >= op.offset()) continue;
                break;
            }
            OffsetPosition offsetPosition = currentOffsetPosition;
            return offsetPosition;
        }
    }
}

