/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import kafka.tier.fetcher.offsetcache.FetchOffsetCache;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;

class TierFetcherMetrics {
    private final Metrics metrics;
    private final String metricGroupName = "TierFetcher";
    private final String bytesFetchedPrefix = "BytesFetched";
    private final String fetchExceptionPrefix = "FetchException";
    private final String fetchCancellationPrefix = "FetchCancellation";
    private final String fetchOffsetForTimestampExceptionPrefix = "FetchOffsetForTimestampException";
    private final Sensor bytesFetched;
    private final Sensor fetchException;
    private final Sensor fetchCancelled;
    private final Sensor fetchOffsetForTimestampException;
    private final String queueSizeName = "QueueSize";
    private final String offsetCacheHitName = "OffsetCacheHitRatio";
    private final String offsetCacheSizeName = "OffsetCacheSize";
    private final List<Sensor> sensors = new ArrayList<Sensor>();
    final MetricName queueSizeMetricName;
    final MetricName bytesFetchedRateMetricName;
    final MetricName bytesFetchedTotalMetricName;
    final MetricName offsetCacheHitMetricName;
    final MetricName offsetCacheSizeMetricName;
    final MetricName fetchExceptionRateMetricName;
    final MetricName fetchExceptionTotalMetricName;
    final MetricName fetchCancellationRateMetricName;
    final MetricName fetchCancellationTotalMetricName;
    final MetricName fetchOffsetForTimestampExceptionRateMetricName;
    final MetricName fetchOffsetForTimestampExceptionTotalMetricName;

    TierFetcherMetrics(Metrics metrics, final ThreadPoolExecutor executor, final FetchOffsetCache cache) {
        this.metrics = metrics;
        this.queueSizeMetricName = metrics.metricName("QueueSize", "TierFetcher", "The number of elements in the TierFetcher executor queue.", Collections.emptyMap());
        this.offsetCacheHitMetricName = metrics.metricName("OffsetCacheHitRatio", "TierFetcher", "TierFetcher offset cache hit ratio", Collections.emptyMap());
        this.offsetCacheSizeMetricName = metrics.metricName("OffsetCacheSize", "TierFetcher", "Number of entries in the TierFetcher offset cache", Collections.emptyMap());
        this.bytesFetched = this.sensor("BytesFetched", new Sensor[0]);
        this.bytesFetchedRateMetricName = metrics.metricName("BytesFetchedRate", "TierFetcher", "The number of bytes fetched per second from tiered storage", Collections.emptyMap());
        this.bytesFetchedTotalMetricName = metrics.metricName("BytesFetchedTotal", "TierFetcher", "The total number of bytes fetched from tiered storage", Collections.emptyMap());
        Meter bytesFetchedMeter = new Meter(this.bytesFetchedRateMetricName, this.bytesFetchedTotalMetricName);
        this.fetchException = this.sensor("FetchException", new Sensor[0]);
        this.fetchExceptionRateMetricName = metrics.metricName("FetchExceptionRate", "TierFetcher", "The number exceptional fetch requests per second from tiered storage", Collections.emptyMap());
        this.fetchExceptionTotalMetricName = metrics.metricName("FetchExceptionTotal", "TierFetcher", "The total number of exceptional fetch requests from tiered storage", Collections.emptyMap());
        Meter fetchObjectStoreExceptionMeter = new Meter(this.fetchExceptionRateMetricName, this.fetchExceptionTotalMetricName);
        this.fetchCancelled = this.sensor("FetchCancellation", new Sensor[0]);
        this.fetchCancellationRateMetricName = metrics.metricName("FetchCancellationRate", "TierFetcher", "The number of cancelled fetch requests per second from tiered storage", Collections.emptyMap());
        this.fetchCancellationTotalMetricName = metrics.metricName("FetchCancellationTotal", "TierFetcher", "The total number of cancelled fetch requests from tiered storage", Collections.emptyMap());
        Meter fetchCancelledMeter = new Meter(this.fetchCancellationRateMetricName, this.fetchCancellationTotalMetricName);
        this.fetchOffsetForTimestampException = this.sensor("FetchOffsetForTimestampException", new Sensor[0]);
        this.fetchOffsetForTimestampExceptionRateMetricName = metrics.metricName("FetchOffsetForTimestampExceptionRate", "TierFetcher", "The number of exceptional fetch offset for timestamps requests per second from tiered storage", Collections.emptyMap());
        this.fetchOffsetForTimestampExceptionTotalMetricName = metrics.metricName("FetchOffsetForTimestampExceptionTotal", "TierFetcher", "The total number of exceptional fetch offset for timestamps requests from tiered storage", Collections.emptyMap());
        Meter fetchTierTimestampAndOffsetExceptionMeter = new Meter(this.fetchOffsetForTimestampExceptionRateMetricName, this.fetchOffsetForTimestampExceptionTotalMetricName);
        Gauge<Integer> queueSizeGauge = new Gauge<Integer>(){

            public Integer value(MetricConfig config, long now) {
                return executor.getQueue().size();
            }
        };
        metrics.addMetric(this.queueSizeMetricName, (MetricValueProvider)queueSizeGauge);
        Gauge<Long> offsetCacheSize = new Gauge<Long>(){

            public Long value(MetricConfig config, long now) {
                return cache.size();
            }
        };
        metrics.addMetric(this.offsetCacheSizeMetricName, (MetricValueProvider)offsetCacheSize);
        Gauge<Double> offsetCacheHitGauge = new Gauge<Double>(){

            public Double value(MetricConfig config, long now) {
                return cache.hitRatio();
            }
        };
        metrics.addMetric(this.offsetCacheHitMetricName, (MetricValueProvider)offsetCacheHitGauge);
        this.bytesFetched.add((CompoundStat)bytesFetchedMeter);
        this.fetchException.add((CompoundStat)fetchObjectStoreExceptionMeter);
        this.fetchCancelled.add((CompoundStat)fetchCancelledMeter);
        this.fetchOffsetForTimestampException.add((CompoundStat)fetchTierTimestampAndOffsetExceptionMeter);
    }

    private Sensor sensor(String name, Sensor ... parents) {
        Sensor sensor2 = this.metrics.sensor(name, parents);
        this.sensors.add(sensor2);
        return sensor2;
    }

    public void close() {
        for (Sensor sensor2 : this.sensors) {
            this.metrics.removeSensor(sensor2.name());
        }
        this.metrics.removeMetric(this.queueSizeMetricName);
    }

    public Sensor bytesFetched() {
        return this.bytesFetched;
    }

    public Sensor fetchException() {
        return this.fetchException;
    }

    public Sensor fetchCancelled() {
        return this.fetchCancelled;
    }

    public Sensor fetchOffsetForTimestampException() {
        return this.fetchOffsetForTimestampException;
    }
}

