/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import kafka.tier.serdes.MaterializationTrackingInfo;
import kafka.tier.serdes.TierPartitionStateHeader;
import kafka.tier.state.TierPartitionStatus;
import kafka.utils.CoreUtils;

public class Header {
    static final int HEADER_LENGTH_LENGTH = 2;
    private final TierPartitionStateHeader header;
    private final MaterializationInfo materializationInfo;

    Header(TierPartitionStateHeader header) {
        this.header = header;
        this.materializationInfo = new MaterializationInfo(header.materializationInfo());
    }

    Header(UUID topicId, byte version, int tierEpoch, TierPartitionStatus status, long endOffset, long localMaterializedOffset) {
        if (tierEpoch < -1) {
            throw new IllegalArgumentException("Illegal tierEpoch " + tierEpoch);
        }
        FlatBufferBuilder builder = new FlatBufferBuilder(100).forceDefaults(true);
        int materializedInfo = MaterializationTrackingInfo.createMaterializationTrackingInfo(builder, -1L, localMaterializedOffset);
        TierPartitionStateHeader.startTierPartitionStateHeader(builder);
        int topicIdOffset = kafka.tier.serdes.UUID.createUUID(builder, topicId.getMostSignificantBits(), topicId.getLeastSignificantBits());
        TierPartitionStateHeader.addTopicId(builder, topicIdOffset);
        TierPartitionStateHeader.addTierEpoch(builder, tierEpoch);
        TierPartitionStateHeader.addVersion(builder, version);
        TierPartitionStateHeader.addStatus(builder, TierPartitionStatus.toByte(status));
        TierPartitionStateHeader.addEndOffset(builder, endOffset);
        TierPartitionStateHeader.addMaterializationInfo(builder, materializedInfo);
        int entryId = TierPartitionStateHeader.endTierPartitionStateHeader(builder);
        builder.finish(entryId);
        this.header = TierPartitionStateHeader.getRootAsTierPartitionStateHeader(builder.dataBuffer());
        this.materializationInfo = new MaterializationInfo(this.header.materializationInfo());
    }

    ByteBuffer payloadBuffer() {
        return this.header.getByteBuffer().duplicate();
    }

    int tierEpoch() {
        return this.header.tierEpoch();
    }

    public UUID topicId() {
        return new UUID(this.header.topicId().mostSignificantBits(), this.header.topicId().leastSignificantBits());
    }

    TierPartitionStatus status() {
        return TierPartitionStatus.fromByte(this.header.status());
    }

    long size() {
        return this.payloadBuffer().remaining() + 2;
    }

    short version() {
        return this.header.version();
    }

    long endOffset() {
        return this.header.endOffset();
    }

    public long localMaterializedOffset() {
        return this.materializationInfo.localMaterializedOffset();
    }

    public long globalMaterializedOffset() {
        return this.materializationInfo.globalMaterializedOffset();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header that = (Header)o;
        return Objects.equals(this.version(), that.version()) && Objects.equals(this.topicId(), that.topicId()) && Objects.equals(this.tierEpoch(), that.tierEpoch()) && Objects.equals((Object)this.status(), (Object)that.status()) && Objects.equals(this.endOffset(), that.endOffset()) && Objects.equals(this.materializationInfo, that.materializationInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version(), this.topicId(), this.tierEpoch(), this.status(), this.endOffset(), this.materializationInfo});
    }

    public String toString() {
        return "Header(version=" + this.version() + ", topicId=" + CoreUtils.uuidToBase64(this.topicId()) + ", tierEpoch=" + this.tierEpoch() + ", status=" + (Object)((Object)this.status()) + ", endOffset=" + this.endOffset() + ", materializationInfo=" + this.materializationInfo + ")";
    }

    private static class MaterializationInfo {
        private final MaterializationTrackingInfo info;

        MaterializationInfo(MaterializationTrackingInfo info) {
            if (info == null) {
                FlatBufferBuilder builder = new FlatBufferBuilder(100);
                MaterializationTrackingInfo.startMaterializationTrackingInfo(builder);
                int entryId = MaterializationTrackingInfo.endMaterializationTrackingInfo(builder);
                builder.finish(entryId);
                this.info = MaterializationTrackingInfo.getRootAsMaterializationTrackingInfo(builder.dataBuffer());
            } else {
                this.info = info;
            }
        }

        long localMaterializedOffset() {
            return this.info.localMaterializedOffset();
        }

        long globalMaterializedOffset() {
            return this.info.globalMaterializedOffset();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MaterializationInfo that = (MaterializationInfo)o;
            return Objects.equals(this.localMaterializedOffset(), that.localMaterializedOffset()) && Objects.equals(this.globalMaterializedOffset(), that.globalMaterializedOffset());
        }

        public int hashCode() {
            return Objects.hash(this.localMaterializedOffset(), this.globalMaterializedOffset());
        }

        public String toString() {
            return "MaterializationInfo(localMaterializedOffset=" + this.localMaterializedOffset() + ", globalMaterializedOffset=" + this.globalMaterializedOffset() + ")";
        }
    }
}

