/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.File;
import java.nio.file.NoSuchFileException;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.UploadableSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFatalException;
import kafka.tier.exceptions.TierArchiverFatalException$;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTask$$anonfun$maybeInitiateUpload$1$;
import kafka.tier.tasks.archive.ArchiveTask$$anonfun$upload$1$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class ArchiveTask$
implements Logging {
    public static final ArchiveTask$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ArchiveTask$();
    }

    private Logger logger$lzycompute() {
        ArchiveTask$ archiveTask$ = this;
        synchronized (archiveTask$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    @Override
    public String loggerName() {
        return ArchiveTask.class.getName();
    }

    public ArchiveTask apply(CancellationContext ctx, TopicIdPartition topicIdPartition, int leaderEpoch, ArchiverMetrics archiverMetrics) {
        return new ArchiveTask(ctx, topicIdPartition, new BeforeLeader(leaderEpoch), archiverMetrics);
    }

    public Future<BeforeUpload> establishLeadership(BeforeLeader state, TopicIdPartition topicIdPartition, TierTopicAppender tierTopicAppender, ExecutionContext ec) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0)new Serializable(state, topicIdPartition, tierTopicAppender){
            public static final long serialVersionUID = 0L;
            private final BeforeLeader state$1;
            private final TopicIdPartition topicIdPartition$1;
            private final TierTopicAppender tierTopicAppender$1;

            public final Future<TierPartitionState.AppendResult> apply() {
                return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(this.tierTopicAppender$1.becomeArchiver(this.topicIdPartition$1, this.state$1.leaderEpoch())));
            }
            {
                this.state$1 = state$1;
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierTopicAppender$1 = tierTopicAppender$1;
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Future<TierPartitionState.AppendResult> apply(Future<TierPartitionState.AppendResult> x) {
                return (Future)Predef$.MODULE$.identity(x);
            }
        }, ec).map((Function1)new Serializable(state, topicIdPartition){
            public static final long serialVersionUID = 0L;
            private final BeforeLeader state$1;
            public final TopicIdPartition topicIdPartition$1;

            public final BeforeUpload apply(TierPartitionState.AppendResult result) {
                TierPartitionState.AppendResult appendResult = result;
                if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)((Object)appendResult))) {
                    ArchiveTask$.MODULE$.info((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.establishLeadership.3 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"established leadership for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicIdPartition$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BeforeUpload beforeUpload = new BeforeUpload(this.state$1.leaderEpoch());
                    return beforeUpload;
                }
                if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals((Object)((Object)appendResult))) {
                    throw new NotTierablePartitionException(this.topicIdPartition$1);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)((Object)appendResult))) {
                    throw new TierArchiverFencedException(this.topicIdPartition$1);
                }
                throw new TierArchiverFatalException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown AppendResult ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appendResult})), TierArchiverFatalException$.MODULE$.$lessinit$greater$default$2());
            }
            {
                this.state$1 = state$1;
                this.topicIdPartition$1 = topicIdPartition$1;
            }
        }, ec);
    }

    public Future<ArchiveTaskState> maybeInitiateUpload(BeforeUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0)new Serializable(state, topicIdPartition, time, tierTopicAppender, replicaManager, ec){
            public static final long serialVersionUID = 0L;
            public final BeforeUpload state$2;
            public final TopicIdPartition topicIdPartition$2;
            public final Time time$2;
            public final TierTopicAppender tierTopicAppender$2;
            private final ReplicaManager replicaManager$1;
            private final ExecutionContext ec$1;

            public final Future<Product> apply() {
                Option option;
                block6: {
                    Future future;
                    block5: {
                        Some some;
                        Tuple2 tuple2;
                        block4: {
                            option = this.replicaManager$1.getLog(this.topicIdPartition$2.topicPartition()).flatMap((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.maybeInitiateUpload.1 $outer;

                                public final Option<Tuple2<AbstractLog, LogSegment>> apply(AbstractLog log) {
                                    if (log.tierPartitionState().tierEpoch() != this.$outer.state$2.leaderEpoch()) {
                                        throw new TierArchiverFencedException(this.$outer.topicIdPartition$2);
                                    }
                                    return log.tierableLogSegments().collectFirst((PartialFunction)new Serializable(this, log){
                                        public static final long serialVersionUID = 0L;
                                        private final AbstractLog log$1;

                                        public final <A1 extends LogSegment, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                            Object object;
                                            A1 A1 = x2;
                                            if (A1 != null) {
                                                A1 A12 = A1;
                                                object = new Tuple2((Object)this.log$1, A12);
                                            } else {
                                                object = function1.apply(x2);
                                            }
                                            return (B1)object;
                                        }

                                        public final boolean isDefinedAt(LogSegment x2) {
                                            LogSegment logSegment = x2;
                                            boolean bl = logSegment != null;
                                            return bl;
                                        }
                                        {
                                            this.log$1 = log$1;
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            if (!None$.MODULE$.equals(option)) break block4;
                            ArchiveTask$.MODULE$.debug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.maybeInitiateUpload.1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transitioning back to BeforeUpload for ", " as log has moved or no tierable segments were found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicIdPartition$2}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            future = Future$.MODULE$.apply((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.maybeInitiateUpload.1 $outer;

                                public final BeforeUpload apply() {
                                    return this.$outer.state$2;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, this.ec$1);
                            break block5;
                        }
                        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block6;
                        AbstractLog log = (AbstractLog)tuple2._1();
                        LogSegment logSegment = (LogSegment)tuple2._2();
                        if (log == null) break block6;
                        AbstractLog abstractLog = log;
                        if (logSegment == null) break block6;
                        LogSegment logSegment2 = logSegment;
                        UploadableSegment segment = ArchiveTask$.MODULE$.uploadableSegment(abstractLog, logSegment2, this.topicIdPartition$2);
                        if (abstractLog.isDeleted()) {
                            throw new NotTierablePartitionException(this.topicIdPartition$2);
                        }
                        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition$2, this.state$2.leaderEpoch(), UUID.randomUUID(), logSegment2.baseOffset(), segment.nextOffset() - 1L, logSegment2.largestTimestamp(), logSegment2.size(), segment.leaderEpochStateOpt().isDefined(), segment.abortedTxnIndexOpt().isDefined(), segment.producerStateOpt().isDefined());
                        long startTime = this.time$2.milliseconds();
                        future = Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0)new Serializable(this, uploadInitiate){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.maybeInitiateUpload.1 $outer;
                            private final TierSegmentUploadInitiate uploadInitiate$1;

                            public final Future<TierPartitionState.AppendResult> apply() {
                                return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(this.$outer.tierTopicAppender$2.addMetadata(this.uploadInitiate$1)));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.uploadInitiate$1 = uploadInitiate$1;
                            }
                        })).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Future<TierPartitionState.AppendResult> apply(Future<TierPartitionState.AppendResult> x) {
                                return (Future)Predef$.MODULE$.identity(x);
                            }
                        }, this.ec$1).map((Function1)new Serializable(this, segment, uploadInitiate, startTime){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.maybeInitiateUpload.1 $outer;
                            private final UploadableSegment segment$1;
                            public final TierSegmentUploadInitiate uploadInitiate$1;
                            public final long startTime$1;

                            public final Upload apply(TierPartitionState.AppendResult x0$1) {
                                TierPartitionState.AppendResult appendResult = x0$1;
                                if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)((Object)appendResult))) {
                                    ArchiveTask$.MODULE$.info((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$maybeInitiateUpload$1$$anonfun$apply$7 $outer;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed UploadInitiate(objectId: ", ", baseOffset: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.uploadInitiate$1.messageId(), BoxesRunTime.boxToLong((long)this.$outer.uploadInitiate$1.baseOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" endOffset: ", "]) for ", " in ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.uploadInitiate$1.endOffset()), this.$outer.kafka$tier$tasks$archive$ArchiveTask$$anonfun$$anonfun$$$outer().topicIdPartition$2, BoxesRunTime.boxToLong((long)(this.$outer.kafka$tier$tasks$archive$ArchiveTask$$anonfun$$anonfun$$$outer().time$2.milliseconds() - this.$outer.startTime$1))}))).toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    Upload upload2 = new Upload(this.$outer.state$2.leaderEpoch(), this.uploadInitiate$1, this.segment$1);
                                    return upload2;
                                }
                                if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals((Object)((Object)appendResult))) {
                                    throw new NotTierablePartitionException(this.$outer.topicIdPartition$2);
                                }
                                if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)((Object)appendResult))) {
                                    throw new TierArchiverFencedException(this.$outer.topicIdPartition$2);
                                }
                                throw new MatchError((Object)((Object)appendResult));
                            }

                            public /* synthetic */ anonfun.maybeInitiateUpload.1 kafka$tier$tasks$archive$ArchiveTask$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.segment$1 = segment$1;
                                this.uploadInitiate$1 = uploadInitiate$1;
                                this.startTime$1 = startTime$1;
                            }
                        }, this.ec$1);
                    }
                    return future;
                }
                throw new MatchError((Object)option);
            }
            {
                this.state$2 = state$2;
                this.topicIdPartition$2 = topicIdPartition$2;
                this.time$2 = time$2;
                this.tierTopicAppender$2 = tierTopicAppender$2;
                this.replicaManager$1 = replicaManager$1;
                this.ec$1 = ec$1;
            }
        }, ec).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Future<Product> apply(Future<Product> x) {
                return (Future)Predef$.MODULE$.identity(x);
            }
        }, ec);
    }

    public Future<AfterUpload> upload(Upload state, TopicIdPartition topicIdPartition, Time time, TierObjectStore tierObjectStore, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0)new Serializable(state, topicIdPartition, time, tierObjectStore){
            public static final long serialVersionUID = 0L;
            public final Upload state$3;
            public final TopicIdPartition topicIdPartition$3;
            public final Time time$3;
            public final TierObjectStore tierObjectStore$1;

            public final AfterUpload apply() {
                UploadableSegment uploadableSegment = this.state$3.uploadableSegment();
                TierSegmentUploadInitiate uploadInitiate = this.state$3.uploadInitiate();
                TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadableSegment.abortedTxnIndexOpt().isDefined());
                return (AfterUpload)package$.MODULE$.blocking((Function0)new Serializable(this, uploadableSegment, uploadInitiate, metadata){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.upload.1 $outer;
                    private final UploadableSegment uploadableSegment$1;
                    private final TierSegmentUploadInitiate uploadInitiate$2;
                    private final TierObjectStore.ObjectMetadata metadata$1;

                    public final AfterUpload apply() {
                        long startTime = this.$outer.time$3.milliseconds();
                        try {
                            this.$outer.tierObjectStore$1.putSegment(this.metadata$1, this.uploadableSegment$1.logSegmentFile(), this.uploadableSegment$1.offsetIndex(), this.uploadableSegment$1.timeIndex(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.uploadableSegment$1.producerStateOpt())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.uploadableSegment$1.abortedTxnIndexOpt())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.uploadableSegment$1.leaderEpochStateOpt())));
                            ArchiveTask$.MODULE$.info((Function0<String>)new Serializable(this, startTime){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$upload$1$$anonfun$apply$9 $outer;
                                private final long startTime$2;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uploaded segment for ", " in ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$tier$tasks$archive$ArchiveTask$$anonfun$$anonfun$$$outer().topicIdPartition$3, BoxesRunTime.boxToLong((long)(this.$outer.kafka$tier$tasks$archive$ArchiveTask$$anonfun$$anonfun$$$outer().time$3.milliseconds() - this.startTime$2))}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.startTime$2 = startTime$2;
                                }
                            });
                            return new AfterUpload(this.$outer.state$3.leaderEpoch(), this.uploadInitiate$2, this.$outer.state$3.uploadableSegment().uploadedSize());
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof Exception) {
                                Exception exception = (Exception)throwable2;
                                if (!ArchiveTask$.MODULE$.kafka$tier$tasks$archive$ArchiveTask$$segmentFilesExist(this.$outer.state$3.uploadableSegment())) {
                                    throw new ArchiveTask.SegmentDeletedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Segment ", " of ", " deleted when tiering"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uploadableSegment$1.logSegmentFile().getAbsolutePath(), this.$outer.topicIdPartition$3})), exception);
                                }
                            }
                            throw throwable;
                        }
                    }

                    public /* synthetic */ anonfun.upload.1 kafka$tier$tasks$archive$ArchiveTask$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.uploadableSegment$1 = uploadableSegment$1;
                        this.uploadInitiate$2 = uploadInitiate$2;
                        this.metadata$1 = metadata$1;
                    }
                });
            }
            {
                this.state$3 = state$3;
                this.topicIdPartition$3 = topicIdPartition$3;
                this.time$3 = time$3;
                this.tierObjectStore$1 = tierObjectStore$1;
            }
        }, ec);
    }

    public Future<BeforeUpload> finalizeUpload(AfterUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, Option<Meter> byteRateMetric, ExecutionContext ec) {
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(state.uploadInitiate());
        long startTime = time.milliseconds();
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0)new Serializable(tierTopicAppender, uploadComplete){
            public static final long serialVersionUID = 0L;
            private final TierTopicAppender tierTopicAppender$3;
            private final TierSegmentUploadComplete uploadComplete$1;

            public final Future<TierPartitionState.AppendResult> apply() {
                return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(this.tierTopicAppender$3.addMetadata(this.uploadComplete$1)));
            }
            {
                this.tierTopicAppender$3 = tierTopicAppender$3;
                this.uploadComplete$1 = uploadComplete$1;
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Future<TierPartitionState.AppendResult> apply(Future<TierPartitionState.AppendResult> x) {
                return (Future)Predef$.MODULE$.identity(x);
            }
        }, ec).map((Function1)new Serializable(state, topicIdPartition, time, byteRateMetric, uploadComplete, startTime){
            public static final long serialVersionUID = 0L;
            public final AfterUpload state$4;
            public final TopicIdPartition topicIdPartition$4;
            public final Time time$4;
            private final Option byteRateMetric$1;
            public final TierSegmentUploadComplete uploadComplete$1;
            public final long startTime$3;

            public final BeforeUpload apply(TierPartitionState.AppendResult x0$2) {
                TierPartitionState.AppendResult appendResult = x0$2;
                if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)((Object)appendResult))) {
                    ArchiveTask$.MODULE$.info((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.finalizeUpload.3 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finalized UploadComplete(", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.uploadComplete$1.messageId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for ", " in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicIdPartition$4, BoxesRunTime.boxToLong((long)(this.$outer.time$4.milliseconds() - this.$outer.startTime$3))}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.byteRateMetric$1.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.finalizeUpload.3 $outer;

                        public final void apply(Meter x$1) {
                            x$1.mark(this.$outer.state$4.uploadedSize());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BeforeUpload beforeUpload = new BeforeUpload(this.state$4.leaderEpoch());
                    return beforeUpload;
                }
                if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals((Object)((Object)appendResult))) {
                    throw new NotTierablePartitionException(this.topicIdPartition$4);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)((Object)appendResult))) {
                    throw new TierArchiverFencedException(this.topicIdPartition$4);
                }
                throw new MatchError((Object)((Object)appendResult));
            }
            {
                this.state$4 = state$4;
                this.topicIdPartition$4 = topicIdPartition$4;
                this.time$4 = time$4;
                this.byteRateMetric$1 = byteRateMetric$1;
                this.uploadComplete$1 = uploadComplete$1;
                this.startTime$3 = startTime$3;
            }
        }, ec);
    }

    public UploadableSegment uploadableSegment(AbstractLog log, LogSegment logSegment, TopicIdPartition topicIdPartition) {
        try {
            return log.createUploadableSegment(logSegment);
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new ArchiveTask.SegmentDeletedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Segment ", " of ", " deleted when tiering"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logSegment, topicIdPartition})), noSuchFileException);
        }
    }

    public boolean kafka$tier$tasks$archive$ArchiveTask$$segmentFilesExist(UploadableSegment uploadableSegment) {
        return uploadableSegment.allFiles().forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$2) {
                return x$2.exists();
            }
        });
    }

    private ArchiveTask$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

