/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import joptsimple.OptionSpec;
import kafka.common.MessageFormatter;
import kafka.tools.ConsoleConsumer;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConsoleConsumer$
implements Logging {
    public static final ConsoleConsumer$ MODULE$;
    private int messageCount;
    private final CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConsoleConsumer$();
    }

    private Logger logger$lzycompute() {
        ConsoleConsumer$ consoleConsumer$ = this;
        synchronized (consoleConsumer$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int messageCount() {
        return this.messageCount;
    }

    public void messageCount_$eq(int x$1) {
        this.messageCount = x$1;
    }

    public CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch() {
        return this.kafka$tools$ConsoleConsumer$$shutdownLatch;
    }

    public void main(String[] args) {
        ConsoleConsumer.ConsumerConfig conf = new ConsoleConsumer.ConsumerConfig(args);
        try {
            this.run(conf);
            return;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Unknown error when running consumer: ";
                }
            }, (Function0<Throwable>)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        catch (AuthenticationException authenticationException) {
            this.error((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Authentication failed: terminating consumer process";
                }
            }, (Function0<Throwable>)new Serializable(authenticationException){
                public static final long serialVersionUID = 0L;
                private final AuthenticationException e$1;

                public final AuthenticationException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run(ConsoleConsumer.ConsumerConfig conf) {
        long timeoutMs = conf.timeoutMs() >= 0 ? (long)conf.timeoutMs() : Long.MAX_VALUE;
        KafkaConsumer consumer = new KafkaConsumer(this.consumerProps(conf), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        ConsoleConsumer.ConsumerWrapper consumerWrapper = conf.partitionArg().isDefined() ? new ConsoleConsumer.ConsumerWrapper((Option<String>)Option$.MODULE$.apply((Object)conf.topicArg()), conf.partitionArg(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)conf.offsetArg())), (Option<String>)None$.MODULE$, (Consumer<byte[], byte[]>)consumer, timeoutMs) : new ConsoleConsumer.ConsumerWrapper((Option<String>)Option$.MODULE$.apply((Object)conf.topicArg()), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)conf.whitelistArg()), (Consumer<byte[], byte[]>)consumer, timeoutMs);
        this.addShutdownHook(consumerWrapper, conf);
        try {
            this.process(Predef$.MODULE$.int2Integer(conf.maxMessages()), conf.formatter(), consumerWrapper, System.out, conf.skipMessageOnError());
            consumerWrapper.cleanup();
            conf.formatter().close();
            this.reportRecordCount();
            this.kafka$tools$ConsoleConsumer$$shutdownLatch().countDown();
            return;
        }
        catch (Throwable throwable) {
            void var5_4;
            var5_4.cleanup();
            conf.formatter().close();
            this.reportRecordCount();
            this.kafka$tools$ConsoleConsumer$$shutdownLatch().countDown();
            throw throwable;
        }
    }

    public void addShutdownHook(ConsoleConsumer.ConsumerWrapper consumer, ConsoleConsumer.ConsumerConfig conf) {
        Exit$.MODULE$.addShutdownHook("consumer-shutdown-hook", (Function0<BoxedUnit>)new Serializable(consumer, conf){
            public static final long serialVersionUID = 0L;
            private final ConsoleConsumer.ConsumerWrapper consumer$1;
            private final ConsoleConsumer.ConsumerConfig conf$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.consumer$1.wakeup();
                ConsoleConsumer$.MODULE$.kafka$tools$ConsoleConsumer$$shutdownLatch().await();
                if (this.conf$1.enableSystestEventsLogging()) {
                    System.out.println("shutdown_complete");
                }
            }
            {
                this.consumer$1 = consumer$1;
                this.conf$1 = conf$1;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(Integer maxMessages, MessageFormatter formatter, ConsoleConsumer.ConsumerWrapper consumer, PrintStream output, boolean skipMessageOnError) {
        while (this.messageCount() < Predef$.MODULE$.Integer2int(maxMessages) || BoxesRunTime.equalsNumObject((Number)maxMessages, (Object)BoxesRunTime.boxToInteger((int)-1))) {
            ConsumerRecord<byte[], byte[]> consumerRecord;
            try {
                consumerRecord = consumer.receive();
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Error processing message, terminating consumer process: ";
                    }
                }, (Function0<Throwable>)new Serializable(throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$3;

                    public final Throwable apply() {
                        return this.e$3;
                    }
                    {
                        this.e$3 = e$3;
                    }
                });
                return;
            }
            catch (WakeupException wakeupException) {
                this.trace((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Caught WakeupException because consumer is shutdown, ignore and terminate.";
                    }
                });
                return;
            }
            ConsumerRecord<byte[], byte[]> msg = consumerRecord;
            this.messageCount_$eq(this.messageCount() + 1);
            try {
                formatter.writeTo((ConsumerRecord<byte[], byte[]>)new ConsumerRecord(msg.topic(), msg.partition(), msg.offset(), msg.timestamp(), msg.timestampType(), Predef$.MODULE$.long2Long(0L), 0, 0, msg.key(), msg.value(), msg.headers()), output);
            }
            catch (Throwable throwable) {
                if (!skipMessageOnError) throw throwable;
                this.error((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Error processing message, skipping this message: ";
                    }
                }, (Function0<Throwable>)new Serializable(throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$4;

                    public final Throwable apply() {
                        return this.e$4;
                    }
                    {
                        this.e$4 = e$4;
                    }
                });
            }
            if (!this.checkErr(output, formatter)) continue;
            return;
        }
    }

    public void reportRecordCount() {
        System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processed a total of ", " messages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messageCount())})));
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkErr(PrintStream output, MessageFormatter formatter) {
        void var3_3;
        boolean gotError = output.checkError();
        if (gotError) {
            System.err.println("Unable to write to standard out, closing consumer.");
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties consumerProps(ConsoleConsumer.ConsumerConfig config) {
        void var2_2;
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.consumerProps());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.extraConsumerProps());
        this.setAutoOffsetResetValue(config, props);
        props.put("bootstrap.servers", config.bootstrapServer());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "isolation.level", config.options(), config.isolationLevelOpt());
        return var2_2;
    }

    public void setAutoOffsetResetValue(ConsoleConsumer.ConsumerConfig config, Properties props) {
        Tuple2 tuple2 = new Tuple2((Object)"earliest", (Object)"latest");
        if (tuple2 != null) {
            Tuple2 tuple22;
            String earliestConfigValue = (String)tuple2._1();
            String latestConfigValue = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)earliestConfigValue, (Object)latestConfigValue);
            String earliestConfigValue2 = (String)tuple23._1();
            String latestConfigValue2 = (String)tuple23._2();
            if (props.containsKey("auto.offset.reset")) {
                String autoResetOption = props.getProperty("auto.offset.reset");
                if (config.options().has((OptionSpec)config.resetBeginningOpt())) {
                    String string = earliestConfigValue2;
                    String string2 = autoResetOption;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        System.err.println(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't simultaneously specify --from-beginning and 'auto.offset.reset=", "', "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{autoResetOption}))).append((Object)"please remove one option").toString());
                        throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
                    }
                }
            } else {
                String autoResetOption = config.options().has((OptionSpec)config.resetBeginningOpt()) ? earliestConfigValue2 : latestConfigValue2;
                props.put("auto.offset.reset", autoResetOption);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private ConsoleConsumer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.messageCount = 0;
        this.kafka$tools$ConsoleConsumer$$shutdownLatch = new CountDownLatch(1);
    }
}

