/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import java.util.UUID;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.cluster.Observer$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.AdminZkClient$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001B\u0001\u0003\u0001\u001d\u0011Q\"\u00113nS:T6n\u00117jK:$(BA\u0002\u0005\u0003\tQ8NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003!Q8n\u00117jK:$\bCA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u00055Y\u0015MZ6b5.\u001cE.[3oi\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\"!\b\u0010\u0011\u0005]\u0001\u0001\"B\u000b\u001b\u0001\u00041\u0002\"\u0002\u0011\u0001\t\u0003\t\u0013aC2sK\u0006$X\rV8qS\u000e$rAI\u0013/gUzt\t\u0005\u0002\nG%\u0011AE\u0003\u0002\u0005+:LG\u000fC\u0003'?\u0001\u0007q%A\u0003u_BL7\r\u0005\u0002)W9\u0011\u0011\"K\u0005\u0003U)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!F\u0003\u0005\u0006_}\u0001\r\u0001M\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bCA\u00052\u0013\t\u0011$BA\u0002J]RDQ\u0001N\u0010A\u0002A\n\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011\u001d1t\u0004%AA\u0002]\n1\u0002^8qS\u000e\u001cuN\u001c4jOB\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0005kRLGNC\u0001=\u0003\u0011Q\u0017M^1\n\u0005yJ$A\u0003)s_B,'\u000f^5fg\"9\u0001i\bI\u0001\u0002\u0004\t\u0015!\u0004:bG.\fu/\u0019:f\u001b>$W\r\u0005\u0002C\u000b6\t1I\u0003\u0002E\t\u0005)\u0011\rZ7j]&\u0011ai\u0011\u0002\u000e%\u0006\u001c7.Q<be\u0016lu\u000eZ3\t\u000f!{\u0002\u0013!a\u0001\u0013\u0006i1M]3bi\u0016$v\u000e]5d\u0013\u0012\u0004\"!\u0003&\n\u0005-S!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001b\u0002!\tAT\u0001\u0013O\u0016$(I]8lKJlU\r^1eCR\f7\u000fF\u0002P1f\u00032\u0001U*V\u001b\u0005\t&B\u0001*\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003)F\u00131aU3r!\t\u0011e+\u0003\u0002X\u0007\nq!I]8lKJlU\r^1eCR\f\u0007b\u0002!M!\u0003\u0005\r!\u0011\u0005\b52\u0003\n\u00111\u0001\\\u0003)\u0011'o\\6fe2K7\u000f\u001e\t\u0004\u0013qs\u0016BA/\u000b\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001k\u0015\u0019\t\u000b\u0001\u0004A\u0011A1\u00023\r\u0014X-\u0019;f)>\u0004\u0018nY,ji\"\f5o]5h]6,g\u000e\u001e\u000b\u0006E\t\u001cW\r\u001d\u0005\u0006M}\u0003\ra\n\u0005\u0006I~\u0003\raN\u0001\u0007G>tg-[4\t\u000b\u0019|\u0006\u0019A4\u00025A\f'\u000f^5uS>t'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;\u0011\tAC\u0007G[\u0005\u0003SF\u00131!T1q!\tYg.D\u0001m\u0015\tiG!\u0001\u0006d_:$(o\u001c7mKJL!a\u001c7\u0003#I+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fC\u0004I?B\u0005\t\u0019A%\t\u000bI\u0004A\u0011A:\u0002'Y\fG.\u001b3bi\u0016$v\u000e]5d\u0007J,\u0017\r^3\u0015\t\t\"XO\u001e\u0005\u0006ME\u0004\ra\n\u0005\u0006MF\u0004\ra\u001a\u0005\u0006IF\u0004\ra\u000e\u0005\u0006q\u0002!I!_\u0001\u001eoJLG/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\!tg&<g.\\3oiR)!E_>~\u007f\")ae\u001ea\u0001O!)Ap\u001ea\u0001O\u0006\t\"/\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;\t\u000by<\b\u0019A%\u0002\u0011%\u001cX\u000b\u001d3bi\u0016Dq\u0001S<\u0011\u0002\u0003\u0007\u0011\nC\u0004\u0002\u0004\u0001!\t!!\u0002\u0002\u0017\u0011,G.\u001a;f)>\u0004\u0018n\u0019\u000b\u0004E\u0005\u001d\u0001B\u0002\u0014\u0002\u0002\u0001\u0007q\u0005C\u0004\u0002\f\u0001!\t!!\u0004\u0002\u001b\u0005$G\rU1si&$\u0018n\u001c8t)=9\u0017qBA\t\u0003+\tI\"!\b\u0002\"\u0005\u0015\u0002B\u0002\u0014\u0002\n\u0001\u0007q\u0005C\u0004\u0002\u0014\u0005%\u0001\u0019A4\u0002%\u0015D\u0018n\u001d;j]\u001e\f5o]5h]6,g\u000e\u001e\u0005\b\u0003/\tI\u00011\u0001P\u0003)\tG\u000e\u001c\"s_.,'o\u001d\u0005\n\u00037\tI\u0001%AA\u0002A\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\"\u0003?\u0002\nA\u0005\t\u0019AA\u0010!\rIAl\u001a\u0005\n\u0003G\tI\u0001%AA\u0002%\u000bAB^1mS\u0012\fG/Z(oYfD\u0001\"a\n\u0002\n\u0001\u0007\u0011\u0011F\u0001\u000fi>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u!\u0011IA,a\u000b\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r\u0005\u0003\u0019\u0019w.\\7p]&!\u0011QGA\u0018\u00059!v\u000e]5d!2\f7-Z7f]RDq!!\u000f\u0001\t\u0013\tY$A\rwC2LG-\u0019;f%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$Hc\u0002\u0012\u0002>\u0005}\u00121\t\u0005\u0007y\u0006]\u0002\u0019A4\t\u000f\u0005\u0005\u0013q\u0007a\u0001a\u0005IR\r\u001f9fGR,GMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011!\t)%a\u000eA\u0002\u0005\u001d\u0013AE1wC&d\u0017M\u00197f\u0005J|7.\u001a:JIN\u0004B\u0001KA%a%\u0019\u00111J\u0017\u0003\u0007M+G\u000fC\u0004\u0002P\u0001!\t!!\u0015\u0002\u0017A\f'o]3Ce>\\WM\u001d\u000b\u0005\u0003'\n)\u0006E\u0002\n9BBq!a\u0016\u0002N\u0001\u0007q%\u0001\u0004ce>\\WM\u001d\u0005\b\u00037\u0002A\u0011AA/\u00035\u0019\u0007.\u00198hK\u000e{gNZ5hgR9!%a\u0018\u0002d\u0005\u001d\u0004bBA1\u00033\u0002\raJ\u0001\u000bK:$\u0018\u000e^=UsB,\u0007bBA3\u00033\u0002\raJ\u0001\u000bK:$\u0018\u000e^=OC6,\u0007bBA5\u00033\u0002\raN\u0001\bG>tg-[4t\u0011\u001d\ti\u0007\u0001C\u0001\u0003_\nAc\u00195b]\u001e,7\t\\5f]RLEmQ8oM&<G#\u0002\u0012\u0002r\u0005U\u0004bBA:\u0003W\u0002\raJ\u0001\u0012g\u0006t\u0017\u000e^5{K\u0012\u001cE.[3oi&#\u0007bBA5\u0003W\u0002\ra\u000e\u0005\b\u0003s\u0002A\u0011AA>\u0003y\u0019\u0007.\u00198hKV\u001bXM](s+N,'o\u00117jK:$\u0018\nZ\"p]\u001aLw\rF\u0003#\u0003{\n\t\tC\u0004\u0002\u0000\u0005]\u0004\u0019A\u0014\u0002'M\fg.\u001b;ju\u0016$WI\u001c;jift\u0015-\\3\t\u000f\u0005%\u0014q\u000fa\u0001o!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0015a\u0005<bY&$\u0017\r^3U_BL7mQ8oM&<G#\u0002\u0012\u0002\n\u0006-\u0005B\u0002\u0014\u0002\u0004\u0002\u0007q\u0005C\u0004\u0002j\u0005\r\u0005\u0019A\u001c\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u0006\t2\r[1oO\u0016$v\u000e]5d\u0007>tg-[4\u0015\u000b\t\n\u0019*!&\t\r\u0019\ni\t1\u0001(\u0011\u001d\tI'!$A\u0002]Bq!!'\u0001\t\u0003\tY*\u0001\ndQ\u0006tw-\u001a\"s_.,'oQ8oM&<G#\u0002\u0012\u0002\u001e\u0006\u0005\u0006bBAP\u0003/\u0003\rAX\u0001\bEJ|7.\u001a:t\u0011\u001d\tI'a&A\u0002]Bq!!'\u0001\t\u0003\t)\u000bF\u0003#\u0003O\u000bI\u000b\u0003\u0005\u0002X\u0005\r\u0006\u0019AA*\u0011\u001d\tI'a)A\u0002]Bq!!,\u0001\t\u0003\ty+\u0001\u000bwC2LG-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u0004E\u0005E\u0006bBA5\u0003W\u0003\ra\u000e\u0005\b\u0003k\u0003A\u0011BA\\\u0003I\u0019\u0007.\u00198hK\u0016sG/\u001b;z\u0007>tg-[4\u0015\u000f\t\nI,!0\u0002B\"9\u00111XAZ\u0001\u00049\u0013A\u0004:p_R,e\u000e^5usRK\b/\u001a\u0005\b\u0003\u007f\u000b\u0019\f1\u0001(\u0003]1W\u000f\u001c7TC:LG/\u001b>fI\u0016sG/\u001b;z\u001d\u0006lW\rC\u0004\u0002j\u0005M\u0006\u0019A\u001c\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\u0006\tb-\u001a;dQ\u0016sG/\u001b;z\u0007>tg-[4\u0015\u000b]\nI-a3\t\u000f\u0005m\u00161\u0019a\u0001O!9\u0011qPAb\u0001\u00049\u0003bBAh\u0001\u0011\u0005\u0011\u0011[\u0001\u0013O\u0016$\u0018\t\u001c7U_BL7mQ8oM&<7\u000f\u0006\u0002\u0002TB!\u0001\u000b[\u00148\u0011\u001d\t9\u000e\u0001C\u0001\u00033\fQCZ3uG\"\fE\u000e\\#oi&$\u0018pQ8oM&<7\u000f\u0006\u0003\u0002T\u0006m\u0007bBA1\u0003+\u0004\ra\n\u0005\b\u0003?\u0004A\u0011AAq\u0003i1W\r^2i\u00032d7\t[5mI\u0016sG/\u001b;z\u0007>tg-[4t)\u0019\t\u0019.a9\u0002f\"9\u00111XAo\u0001\u00049\u0003bBAt\u0003;\u0004\raJ\u0001\u0010G\"LG\u000eZ#oi&$\u0018\u0010V=qK\"9\u00111\u0004\u0001\u0005\u0002\u0005-H\u0003BAw\u0003_\u0004B\u0001\u00155(a!A\u0011\u0011_Au\u0001\u0004\t\u00190\u0001\u0004u_BL7m\u001d\t\u0005Q\u0005%s\u0005C\u0005\u0002x\u0002\t\n\u0011\"\u0001\u0002z\u0006ar-\u001a;Ce>\\WM]'fi\u0006$\u0017\r^1tI\u0011,g-Y;mi\u0012\nTCAA~U\r\t\u0015Q`\u0016\u0003\u0003\u007f\u0004BA!\u0001\u0003\f5\u0011!1\u0001\u0006\u0005\u0005\u000b\u00119!A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u0002\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u000e\t\r!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!\u0011\u0003\u0001\u0012\u0002\u0013\u0005!1C\u0001\u001dO\u0016$(I]8lKJlU\r^1eCR\f7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)BK\u0002\\\u0003{D\u0011B!\u0007\u0001#\u0003%\tAa\u0007\u0002G\r\u0014X-\u0019;f)>\u0004\u0018nY,ji\"\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u0004\u0016\u0004\u0013\u0006u\b\"\u0003B\u0011\u0001E\u0005I\u0011\u0001B\u0012\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIQ*\"A!\n+\u0007]\ni\u0010C\u0005\u0003*\u0001\t\n\u0011\"\u0001\u0002z\u0006)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012*\u0004\"\u0003B\u0017\u0001E\u0005I\u0011\u0001B\u000e\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIYB\u0011B!\r\u0001#\u0003%\tAa\r\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012\"TC\u0001B\u001bU\r\u0001\u0014Q \u0005\n\u0005s\u0001\u0011\u0013!C\u0001\u0005w\tq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tu\"\u0006BA\u0010\u0003{D\u0011B!\u0011\u0001#\u0003%\tAa\u0007\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u00122\u0004\"\u0003B#\u0001E\u0005I\u0011\u0002B\u000e\u0003\u001d:(/\u001b;f)>\u0004\u0018n\u0019)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$H\u0005Z3gCVdG\u000f\n\u001b")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        AdminZkClient adminZkClient = this;
        synchronized (adminZkClient) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean createTopicId) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map replicaAssignment2 = (Map)AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, ReplicaAssignment> apply(Tuple2<Object, Seq<Object>> x0$1) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int partition = tuple2._1$mcI$sp();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)replicas, (Seq<Object>)((Seq)Seq$.MODULE$.empty())));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.createTopicWithAssignment(topic, topicConfig, (Map<Object, ReplicaAssignment>)replicaAssignment2, createTopicId);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        RackAwareMode rackAwareMode2;
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1)new Serializable(this, allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$2;

            public final Seq<Broker> apply(Seq<Object> brokerIds) {
                return (Seq)this.allBrokers$2.filter((Function1)new Serializable(this, brokerIds){
                    public static final long serialVersionUID = 0L;
                    private final Seq brokerIds$1;

                    public final boolean apply(Broker b) {
                        return this.brokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)b.id()));
                    }
                    {
                        this.brokerIds$1 = brokerIds$1;
                    }
                });
            }
            {
                this.allBrokers$2 = allBrokers$2;
            }
        }).getOrElse((Function0)new Serializable(this, allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$2;

            public final Seq<Broker> apply() {
                return this.allBrokers$2;
            }
            {
                this.allBrokers$2 = allBrokers$2;
            }
        });
        Seq brokersWithRack = (Seq)brokers.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Broker x$1) {
                return x$1.rack().nonEmpty();
            }
        });
        RackAwareMode rackAwareMode3 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode3 != null ? !rackAwareMode3.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode2 = rackAwareMode) ? (Seq)brokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode2) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), broker.rack());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Seq brokerMetadatas = seq;
        return (Seq)brokerMetadatas.sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$2) {
                return x$2.id();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, ReplicaAssignment> partitionReplicaAssignment2, boolean createTopicId) {
        this.validateTopicCreate(topic, partitionReplicaAssignment2, config);
        this.info((Function0<String>)new Serializable(this, topic, config, partitionReplicaAssignment2){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Properties config$1;
            private final Map partitionReplicaAssignment$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating topic ", " with configuration ", " and initial partition "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.config$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"assignment ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionReplicaAssignment$1}))).toString();
            }
            {
                this.topic$1 = topic$1;
                this.config$1 = config$1;
                this.partitionReplicaAssignment$1 = partitionReplicaAssignment$1;
            }
        });
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment2, false, createTopicId);
    }

    public boolean createTopicWithAssignment$default$4() {
        return false;
    }

    public void validateTopicCreate(String topic, Map<Object, ReplicaAssignment> partitionReplicaAssignment2, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        if (Topic.hasCollisionChars((String)topic)) {
            Set<String> allTopics = this.zkClient.getAllTopicsInCluster();
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            Set collidingTopics = (Set)allTopics.filter((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final String topic$3;

                public final boolean apply(String x$3) {
                    return Topic.hasCollision((String)this.topic$3, (String)x$3);
                }
                {
                    this.topic$3 = topic$3;
                }
            });
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' collides with existing topics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, collidingTopics.mkString(", ")})));
            }
        }
        if (((TraversableOnce)partitionReplicaAssignment2.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ReplicaAssignment x$4) {
                return x$4.replicas().size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        if (((TraversableOnce)partitionReplicaAssignment2.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ReplicaAssignment x$5) {
                return x$5.observers().size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of observers");
        }
        partitionReplicaAssignment2.values().foreach((Function1)new Serializable(this, partitionReplicaAssignment2){
            public static final long serialVersionUID = 0L;
            private final Map partitionReplicaAssignment$2;

            public final void apply(ReplicaAssignment assignment) {
                if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
                    throw new InvalidReplicaAssignmentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate replica assignment found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionReplicaAssignment$2})));
                }
                if (assignment.observers().size() != assignment.observers().toSet().size()) {
                    throw new InvalidReplicaAssignmentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate observers assignment found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionReplicaAssignment$2})));
                }
            }
            {
                this.partitionReplicaAssignment$2 = partitionReplicaAssignment$2;
            }
        });
        int partitionSize = partitionReplicaAssignment2.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment2.size() != partitionReplicaAssignment2.toSet().size() || BoxesRunTime.unboxToInt((Object)((TraversableOnce)partitionReplicaAssignment2.keys().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$6) {
                return this.apply$mcZI$sp(x$6);
            }

            public boolean apply$mcZI$sp(int x$6) {
                return x$6 >= 0;
            }
        })).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig$.MODULE$.validate(config);
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment2, boolean isUpdate, boolean createTopicId) {
        try {
            scala.collection.immutable.Map assignment = ((TraversableOnce)replicaAssignment2.map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final String topic$4;

                public final Tuple2<TopicPartition, ReplicaAssignment> apply(Tuple2<Object, ReplicaAssignment> x0$2) {
                    Tuple2<Object, ReplicaAssignment> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int partitionId = tuple2._1$mcI$sp();
                        ReplicaAssignment replicas = (ReplicaAssignment)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)new TopicPartition(this.topic$4, partitionId), (Object)replicas);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.topic$4 = topic$4;
                }
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (isUpdate) {
                Map<String, UUID> topicIds = this.zkClient.getTopicIdsForTopics((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                this.zkClient.setTopicAssignment(topic, (Option<UUID>)topicIds.get((Object)topic), (Map<TopicPartition, ReplicaAssignment>)assignment, this.zkClient.setTopicAssignment$default$4());
            } else {
                None$ topicIdOpt = createTopicId ? new Some((Object)UUID.randomUUID()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<UUID>)topicIdOpt, (Map<TopicPartition, ReplicaAssignment>)assignment);
            }
            this.debug((Function0<String>)new Serializable(this, topic, assignment){
                public static final long serialVersionUID = 0L;
                private final String topic$4;
                private final scala.collection.immutable.Map assignment$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(this.topic$4), this.assignment$1}));
                }
                {
                    this.topic$4 = topic$4;
                    this.assignment$1 = assignment$1;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    private boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteTopic(String topic) {
        if (!this.zkClient.topicExists(topic)) throw new UnknownTopicOrPartitionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic `", "` to delete does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        try {
            this.zkClient.createDeleteTopicPath(topic);
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.getMessage());
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    public Map<Object, ReplicaAssignment> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions2, Option<Map<Object, ReplicaAssignment>> replicaAssignment2, boolean validateOnly, Option<TopicPlacement> topicPlacement) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0)new Serializable(this, topic, existingAssignment){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final Map existingAssignment$1;

            public final Nothing$ apply() {
                throw new AdminOperationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected existing replica assignment for topic '", "', partition id 0 is missing. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignment: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.existingAssignment$1}))).toString());
            }
            {
                this.topic$2 = topic$2;
                this.existingAssignment$1 = existingAssignment$1;
            }
        })).replicas();
        int partitionsToAdd = numPartitions2 - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of partitions for a topic can only be increased. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " currently has ", " partitions, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)existingAssignment.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " would not be an increase."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numPartitions2)}))).toString());
        }
        replicaAssignment2.foreach((Function1)new Serializable(this, allBrokers, existingAssignmentPartition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final Seq allBrokers$1;
            private final Seq existingAssignmentPartition0$1;

            public final void apply(Map<Object, ReplicaAssignment> proposedReplicaAssignment) {
                this.$outer.kafka$zk$AdminZkClient$$validateReplicaAssignment(proposedReplicaAssignment, this.existingAssignmentPartition0$1.size(), (Set<Object>)((TraversableOnce)this.allBrokers$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(BrokerMetadata x$7) {
                        return x$7.id();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allBrokers$1 = allBrokers$1;
                this.existingAssignmentPartition0$1 = existingAssignmentPartition0$1;
            }
        });
        Map proposedAssignmentForNewPartitions = (Map)replicaAssignment2.getOrElse((Function0)new Serializable(this, existingAssignment, allBrokers, topicPlacement, existingAssignmentPartition0, partitionsToAdd){
            public static final long serialVersionUID = 0L;
            private final Map existingAssignment$1;
            private final Seq allBrokers$1;
            private final Option topicPlacement$1;
            public final Seq existingAssignmentPartition0$1;
            private final int partitionsToAdd$1;

            public final Map<Object, ReplicaAssignment> apply() {
                int startIndex = package$.MODULE$.max(0, this.allBrokers$1.indexWhere((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final boolean apply(BrokerMetadata x$8) {
                        return x$8.id() >= BoxesRunTime.unboxToInt((Object)this.$outer.existingAssignmentPartition0$1.head());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                return Observer$.MODULE$.getReplicaAssignment((Seq<BrokerMetadata>)this.allBrokers$1, (Option<TopicPlacement>)this.topicPlacement$1, this.partitionsToAdd$1, this.existingAssignmentPartition0$1.size(), startIndex, this.existingAssignment$1.size());
            }
            {
                this.existingAssignment$1 = existingAssignment$1;
                this.allBrokers$1 = allBrokers$1;
                this.topicPlacement$1 = topicPlacement$1;
                this.existingAssignmentPartition0$1 = existingAssignmentPartition0$1;
                this.partitionsToAdd$1 = partitionsToAdd$1;
            }
        });
        Map proposedAssignment = existingAssignment.$plus$plus((GenTraversableOnce)proposedAssignmentForNewPartitions);
        if (!validateOnly) {
            this.info((Function0<String>)new Serializable(this, topic, partitionsToAdd, proposedAssignmentForNewPartitions){
                public static final long serialVersionUID = 0L;
                private final String topic$2;
                private final int partitionsToAdd$1;
                private final Map proposedAssignmentForNewPartitions$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ", " partitions for '", "' with the following replica assignment: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.partitionsToAdd$1), this.topic$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.proposedAssignmentForNewPartitions$1}))).toString();
                }
                {
                    this.topic$2 = topic$2;
                    this.partitionsToAdd$1 = partitionsToAdd$1;
                    this.proposedAssignmentForNewPartitions$1 = proposedAssignmentForNewPartitions$1;
                }
            });
            this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)proposedAssignment, true, this.writeTopicPartitionAssignment$default$4());
        }
        return proposedAssignment;
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, ReplicaAssignment>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public void kafka$zk$AdminZkClient$$validateReplicaAssignment(Map<Object, ReplicaAssignment> replicaAssignment2, int expectedReplicationFactor, Set<Object> availableBrokerIds) {
        replicaAssignment2.foreach((Function1)new Serializable(this, availableBrokerIds){
            public static final long serialVersionUID = 0L;
            private final Set availableBrokerIds$1;

            public final void apply(Tuple2<Object, ReplicaAssignment> x0$3) {
                Tuple2<Object, ReplicaAssignment> tuple2 = x0$3;
                if (tuple2 != null) {
                    int partitionId = tuple2._1$mcI$sp();
                    ReplicaAssignment assignment = (ReplicaAssignment)tuple2._2();
                    if (assignment.replicas().isEmpty()) {
                        throw new InvalidReplicaAssignmentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot have replication factor of 0 for partition id ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})));
                    }
                    if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
                        throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate brokers not allowed in replica assignment: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for partition id ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignment.replicas().mkString(", "), BoxesRunTime.boxToInteger((int)partitionId)}))).toString());
                    }
                    if (assignment.replicas().toSet().subsetOf((GenSet)this.availableBrokerIds$1)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new BrokerNotAvailableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some brokers specified for partition id ", " are not available. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified brokers: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignment.replicas().mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"available brokers: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.availableBrokerIds$1.mkString(", ")}))).toString());
                }
                throw new MatchError(tuple2);
            }
            {
                this.availableBrokerIds$1 = availableBrokerIds$1;
            }
        });
        Map badRepFactors = (Map)replicaAssignment2.collect((PartialFunction)new Serializable(this, expectedReplicationFactor){
            public static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, ReplicaAssignment>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition = A1._1$mcI$sp();
                    ReplicaAssignment assignment = (ReplicaAssignment)A1._2();
                    if (assignment.replicas().size() != this.expectedReplicationFactor$1) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)assignment.replicas().size()));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, ReplicaAssignment> x1) {
                ReplicaAssignment assignment;
                Tuple2<Object, ReplicaAssignment> tuple2 = x1;
                boolean bl = tuple2 != null && (assignment = (ReplicaAssignment)tuple2._2()).replicas().size() != this.expectedReplicationFactor$1;
                return bl;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$4) {
                    Tuple2<Object, Object> tuple2 = x0$4;
                    if (tuple2 != null) {
                        int partitionId;
                        int n = partitionId = tuple2._1$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, (Ordering)Ordering.Int$.MODULE$);
            Seq partitions = (Seq)sortedBadRepFactors.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$5) {
                    Tuple2<Object, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        int partitionId;
                        int n = partitionId = tuple2._1$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq repFactors = (Seq)sortedBadRepFactors.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$6) {
                    Tuple2<Object, Object> tuple2 = x0$6;
                    if (tuple2 != null) {
                        int rf;
                        int n = rf = tuple2._2$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inconsistent replication factor between partitions, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition 0 has ", " while partitions [", "] have "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedReplicationFactor), partitions.mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replication factors [", "], respectively."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{repFactors.mkString(", ")}))).toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Object> parseBroker(String broker) {
        String string = broker;
        String string2 = ConfigEntityName$.MODULE$.Default();
        String string3 = string;
        if (string2 == null) {
            if (string3 == null) return None$.MODULE$;
        } else if (string2.equals(string3)) {
            return None$.MODULE$;
        }
        try {
            return new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(broker)).toInt()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error parsing broker ", ". The broker's Entity Name must be a single integer value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{broker})));
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        block6: {
            block3: {
                String string;
                block5: {
                    block4: {
                        block2: {
                            string = entityType;
                            String string2 = ConfigType$.MODULE$.Topic();
                            String string3 = string;
                            if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                            this.changeTopicConfig(entityName, configs);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        String string4 = ConfigType$.MODULE$.Client();
                        String string5 = string;
                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                        this.changeClientIdConfig(entityName, configs);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    String string6 = ConfigType$.MODULE$.User();
                    String string7 = string;
                    if (string6 != null ? !string6.equals(string7) : string7 != null) break block5;
                    this.changeUserOrUserClientIdConfig(entityName, configs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                String string8 = ConfigType$.MODULE$.Broker();
                String string9 = string;
                if (string8 != null ? !string8.equals(string9) : string9 != null) break block6;
                this.changeBrokerConfig(this.parseBroker(entityName), configs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a known entityType. Should be one of ", ", ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityType, ConfigType$.MODULE$.Topic(), ConfigType$.MODULE$.Client(), ConfigType$.MODULE$.Broker()})));
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        java.util.Map<String, Object> map = !(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients") ? DynamicConfig$Client$.MODULE$.validate(configs) : DynamicConfig$User$.MODULE$.validate(configs);
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (this.zkClient.topicExists(topic)) {
            LogConfig$.MODULE$.validate(configs);
            return;
        }
        throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)new Serializable(this, configs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final Properties configs$1;

            public final void apply(int broker) {
                this.apply$mcVI$sp(broker);
            }

            public void apply$mcVI$sp(int broker) {
                this.$outer.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)broker)).toString(), this.configs$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.configs$1 = configs$1;
            }
        });
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$9) {
                return ((Object)BoxesRunTime.boxToInteger((int)x$9)).toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ConfigEntityName$.MODULE$.Default();
            }
        }), configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    public void kafka$zk$AdminZkClient$$changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder().append((Object)rootEntityType).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((TraversableOnce)this.zkClient.getAllTopicsInCluster().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;

            public final Tuple2<String, Properties> apply(String topic) {
                return new Tuple2((Object)topic, (Object)this.$outer.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((TraversableOnce)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1)new Serializable(this, entityType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final String entityType$1;

            public final Tuple2<String, Properties> apply(String entity) {
                return new Tuple2((Object)entity, (Object)this.$outer.fetchEntityConfig(this.entityType$1, entity));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entityType$1 = entityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.kafka$zk$AdminZkClient$$entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1)new Serializable(this, rootEntityType, childEntityType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final String rootEntityType$1;
            private final String childEntityType$1;

            public final Seq<String> apply(String entity) {
                return this.$outer.kafka$zk$AdminZkClient$$entityPaths$1((Option)new Some((Object)new StringBuilder().append((Object)entity).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)this.childEntityType$1).toString()), this.rootEntityType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rootEntityType$1 = rootEntityType$1;
                this.childEntityType$1 = childEntityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, rootEntityType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final String rootEntityType$1;

            public final Tuple2<String, Properties> apply(String entityPath) {
                return new Tuple2((Object)entityPath, (Object)this.$outer.fetchEntityConfig(this.rootEntityType$1, entityPath));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rootEntityType$1 = rootEntityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Object> numPartitions(Set<String> topics) {
        return (Map)this.zkClient.getPartitionsForTopics(topics).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<String, Seq<Object>> x0$7) {
                Tuple2<String, Seq<Object>> tuple2 = x0$7;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    Seq partitions = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitions.size()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public final Seq kafka$zk$AdminZkClient$$entityPaths$1(Option rootPath, String rootEntityType$1) {
        Option option;
        block4: {
            Option option2;
            block7: {
                Seq seq;
                block6: {
                    Seq entityNames2;
                    block5: {
                        String string;
                        block3: {
                            block2: {
                                option = rootPath;
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String path = (String)some.x();
                                string = new StringBuilder().append((Object)rootEntityType$1).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)path).toString();
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            string = rootEntityType$1;
                        }
                        String root = string;
                        entityNames2 = this.zkClient.getAllEntitiesWithConfig(root);
                        option2 = rootPath;
                        if (!(option2 instanceof Some)) break block5;
                        Some some = (Some)option2;
                        String path = (String)some.x();
                        seq = (Seq)entityNames2.map((Function1)new Serializable(this, path){
                            public static final long serialVersionUID = 0L;
                            private final String path$1;

                            public final String apply(String entityName) {
                                return new StringBuilder().append((Object)this.path$1).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)entityName).toString();
                            }
                            {
                                this.path$1 = path$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    seq = entityNames2;
                }
                return seq;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
        Logging$class.$init$(this);
    }
}

