/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.internals.FatalExitError;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001\u0015\u0011\u0011bS1gW\u0006$Vm\u001d;\u000b\u0003\r\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\rA\u0011qAC\u0007\u0002\u0011)\t\u0011\"A\u0003tG\u0006d\u0017-\u0003\u0002\f\u0011\t1\u0011I\\=SK\u001aDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005A\u0001Q\"\u0001\u0002\t\u000bI\u0001A\u0011A\n\u0002\u000bM,G/\u00169\u0015\u0003Q\u0001\"aB\u000b\n\u0005YA!\u0001B+oSRD#!\u0005\r\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012!\u00026v]&$(\"A\u000f\u0002\u0007=\u0014x-\u0003\u0002 5\t1!)\u001a4pe\u0016DQ!\t\u0001\u0005\u0002M\t\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003A\r\u0002\"!\u0007\u0013\n\u0005\u0015R\"!B!gi\u0016\u0014\b\"B\u0014\u0001\t\u0003\u0019\u0012A\u0007;fgR<U\r^&bM.\f7i\u001c8gS\u001e4%o\\7Be\u001e\u001c\bF\u0001\u0014*!\tI\"&\u0003\u0002,5\t!A+Z:u\u0011\u0015i\u0003\u0001\"\u0001\u0014\u0003%\"Xm\u001d;HKR\\\u0015MZ6b\u0007>tg-[4Ge>l\u0017I]4t\u001d>t\u0017I]4t\u0003R$\u0006.Z#oI\"\"A&K\u00181\u0003!)\u0007\u0010]3di\u0016$7%A\u0019\u0011\u0005IRT\"A\u001a\u000b\u0005Q*\u0014!C5oi\u0016\u0014h.\u00197t\u0015\t1t'\u0001\u0004d_6lwN\u001c\u0006\u0003\u0007aR!!\u000f\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tY4G\u0001\bGCR\fG.\u0012=ji\u0016\u0013(o\u001c:\t\u000bu\u0002A\u0011A\n\u0002KQ,7\u000f^$fi.\u000bgm[1D_:4\u0017n\u001a$s_6\f%oZ:O_:\f%oZ:P]2L\b\u0006\u0002\u001f*_ABQ\u0001\u0011\u0001\u0005\u0002M\tQ\u0006^3ti\u001e+GoS1gW\u0006\u001cuN\u001c4jO\u001a\u0013x.\\!sONtuN\\!sON\fE\u000f\u00165f\u0005\u0016<w-\u001b8hQ\u0011y\u0014f\f\u0019\t\u000b\r\u0003A\u0011A\n\u0002+Q,7\u000f^&bM.\f7k\u001d7QCN\u001cxo\u001c:eg\"\u0012!)\u000b\u0005\u0006\r\u0002!\taE\u0001!i\u0016\u001cHoS1gW\u0006\u001c6\u000f\u001c)bgN<xN\u001d3t/&$\bnU=nE>d7\u000f\u000b\u0002FS!9\u0011\n\u0001b\u0001\n\u0013Q\u0015!\u00062p_2,\u0017M\u001c)s_B4\u0016\r\\;f)>\u001cV\r^\u000b\u0002\u0017B\u0011q\u0001T\u0005\u0003\u001b\"\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004P\u0001\u0001\u0006IaS\u0001\u0017E>|G.Z1o!J|\u0007OV1mk\u0016$vnU3uA!9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0016\u0001F:ue&tw\r\u0015:paZ\u000bG.^3U_N+G/F\u0001T!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0003mC:<'\"\u0001-\u0002\t)\fg/Y\u0005\u00035V\u0013aa\u0015;sS:<\u0007B\u0002/\u0001A\u0003%1+A\u000btiJLgn\u001a)s_B4\u0016\r\\;f)>\u001cV\r\u001e\u0011\t\u000fy\u0003!\u0019!C\u0005%\u00061\u0002/Y:to>\u0014H\r\u0015:paZ\u000bG.^3U_N+G\u000f\u0003\u0004a\u0001\u0001\u0006IaU\u0001\u0018a\u0006\u001c8o^8sIB\u0013x\u000e\u001d,bYV,Gk\\*fi\u0002BqA\u0019\u0001C\u0002\u0013%1-\u0001\nmSN$\bK]8q-\u0006dW/\u001a+p'\u0016$X#\u00013\u0011\u0007\u0015T7+D\u0001g\u0015\t9\u0007.A\u0005j[6,H/\u00192mK*\u0011\u0011\u000eC\u0001\u000bG>dG.Z2uS>t\u0017BA6g\u0005\u0011a\u0015n\u001d;\t\r5\u0004\u0001\u0015!\u0003e\u0003Ma\u0017n\u001d;Qe>\u0004h+\u00197vKR{7+\u001a;!\u0011\u0015y\u0007\u0001\"\u0001\u0014\u0003U!Xm\u001d;[WN\u001bHn\u00117jK:$XI\\1cY\u0016D#A\\\u0015\t\u000bI\u0004A\u0011A\n\u00023Q,7\u000f\u001e.l'Nd7*Z=Ti>\u0014X\rT8dCRLwN\u001c\u0015\u0003c&BQ!\u001e\u0001\u0005\u0002M\t1\u0004^3tij[7k\u001d7UeV\u001cHo\u0015;pe\u0016dunY1uS>t\u0007F\u0001;*\u0011\u0015A\b\u0001\"\u0001\u0014\u0003u!Xm\u001d;[_>\\W-\u001a9fe.+\u0017p\u0015;pe\u0016\u0004\u0016m]:x_J$\u0007FA<*\u0011\u0015Y\b\u0001\"\u0001\u0014\u0003}!Xm\u001d;[_>\\W-\u001a9feR\u0013Xo\u001d;Ti>\u0014X\rU1tg^|'\u000f\u001a\u0015\u0003u&BQA \u0001\u0005\u0002M\tQ\u0003^3tij[7k\u001d7LKf\u001cFo\u001c:f)f\u0004X\r\u000b\u0002~S!1\u00111\u0001\u0001\u0005\u0002M\tq\u0003^3tij[7k\u001d7UeV\u001cHo\u0015;pe\u0016$\u0016\u0010]3)\u0007\u0005\u0005\u0011\u0006\u0003\u0004\u0002\n\u0001!\taE\u0001\u0012i\u0016\u001cHOW6Tg2\u0004&o\u001c;pG>d\u0007fAA\u0004S!1\u0011q\u0002\u0001\u0005\u0002M\t\u0011\u0004^3tij[7k\u001d7F]\u0006\u0014G.\u001a3Qe>$xnY8mg\"\u001a\u0011QB\u0015\t\r\u0005U\u0001\u0001\"\u0001\u0014\u0003U!Xm\u001d;[WN\u001bHnQ5qQ\u0016\u00148+^5uKND3!a\u0005*\u0011\u0019\tY\u0002\u0001C\u0001'\u0005AC/Z:u5.\u001c6\u000f\\#oIB|\u0017N\u001c;JI\u0016tG/\u001b4jG\u0006$\u0018n\u001c8BY\u001e|'/\u001b;i[\"\u001a\u0011\u0011D\u0015\t\r\u0005\u0005\u0002\u0001\"\u0001\u0014\u0003I!Xm\u001d;[WN\u001bHn\u0011:m\u000b:\f'\r\\3)\u0007\u0005}\u0011\u0006\u0003\u0004\u0002(\u0001!\taE\u0001\u0014i\u0016\u001cHOW6Tg2|5m\u001d9F]\u0006\u0014G.\u001a\u0015\u0004\u0003KI\u0003BBA\u0017\u0001\u0011\u00051#A\u0011uKN$8i\u001c8oK\u000e$\u0018n\u001c8t\u001b\u0006D(+Z1vi\"l5\u000fR3gCVdG\u000fK\u0002\u0002,%Ba!a\r\u0001\t\u0003\u0019\u0012A\t;fgR\u001cuN\u001c8fGRLwN\\:NCb\u0014V-Y;uQ6\u001bX\t\u001f9mS\u000eLG\u000fK\u0002\u00022%Bq!!\u000f\u0001\t\u0013\tY$\u0001\u0007uKN$(l[\"p]\u001aLw-\u0006\u0004\u0002>\u0005}\u00131\u0013\u000b\u0010)\u0005}\u0012qJA*\u0003/\n\t(!$\u0002\u0018\"A\u0011\u0011IA\u001c\u0001\u0004\t\u0019%A\u0007lC\u001a\\\u0017\r\u0015:pa:\u000bW.\u001a\t\u0005\u0003\u000b\nYED\u0002\b\u0003\u000fJ1!!\u0013\t\u0003\u0019\u0001&/\u001a3fM&\u0019!,!\u0014\u000b\u0007\u0005%\u0003\u0002\u0003\u0005\u0002R\u0005]\u0002\u0019AA\"\u0003U)\u0007\u0010]3di\u0016$7*\u00194lCB\u0013x\u000e\u001d(b[\u0016D\u0001\"!\u0016\u00028\u0001\u0007\u00111I\u0001\fgf\u001c\bK]8q\u001d\u0006lW\r\u0003\u0005\u0002Z\u0005]\u0002\u0019AA.\u00039\u0001(o\u001c9WC2,X\rV8TKR\u0004B!!\u0018\u0002`1\u0001A\u0001CA1\u0003o\u0011\r!a\u0019\u0003\u0003Q\u000bB!!\u001a\u0002lA\u0019q!a\u001a\n\u0007\u0005%\u0004BA\u0004O_RD\u0017N\\4\u0011\u0007\u001d\ti'C\u0002\u0002p!\u00111!\u00118z\u0011!\t\u0019(a\u000eA\u0002\u0005U\u0014\u0001E4fiB\u0013x\u000e\u001d,bYV,gI]8n!\u001d9\u0011qOA>\u0003\u000fK1!!\u001f\t\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\tIA\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\u0015\u0015q\u0010\u0002\f\u0017\u000647.Y\"p]\u001aLw\rE\u0003\b\u0003\u0013\u000bY&C\u0002\u0002\f\"\u0011aa\u00149uS>t\u0007\u0002CAH\u0003o\u0001\r!!%\u0002+\u0015D\b/Z2uK\u0012\u0004&o\u001c9feRLh+\u00197vKB!\u0011QLAJ\t!\t)*a\u000eC\u0002\u0005\r$!A+\t\u0015\u0005e\u0015q\u0007I\u0001\u0002\u0004\t9)\u0001\u000bfqB,7\r^3e\t\u00164\u0017-\u001e7u-\u0006dW/\u001a\u0005\b\u0003;\u0003A\u0011AAP\u0003Q\u0001(/\u001a9be\u0016$UMZ1vYR\u001cuN\u001c4jOR\u0011\u00111\t\u0005\b\u0003G\u0003A\u0011AAS\u00035\u0001(/\u001a9be\u0016\u001cuN\u001c4jOR!\u00111IAT\u0011!\tI+!)A\u0002\u0005-\u0016!\u00027j]\u0016\u001c\b#B\u0004\u0002.\u0006\r\u0013bAAX\u0011\t)\u0011I\u001d:bs\"I\u00111\u0017\u0001\u0012\u0002\u0013%\u0011QW\u0001\u0017i\u0016\u001cHOW6D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%oU1\u0011qWAj\u0003+,\"!!/+\t\u0005m\u0016\u0011\u0019\b\u0004\u000f\u0005u\u0016bAA`\u0011\u0005!aj\u001c8fW\t\t\u0019\r\u0005\u0003\u0002F\u0006=WBAAd\u0015\u0011\tI-a3\u0002\u0013Ut7\r[3dW\u0016$'bAAg\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0017q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0001CA1\u0003c\u0013\r!a\u0019\u0005\u0011\u0005U\u0015\u0011\u0017b\u0001\u0003G\u0002")
public class KafkaTest {
    private final boolean booleanPropValueToSet;
    private final String stringPropValueToSet;
    private final String passwordPropValueToSet;
    private final List<String> listPropValueToSet = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"}));

    @Before
    public void setUp() {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(int status, Option<String> x$1) {
                throw new FatalExitError(status);
            }
        });
    }

    @After
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assert.assertEquals((long)1L, (long)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"})));
        Assert.assertEquals((long)1L, (long)config3.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact"}), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config4.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact", "delete"}), (Object)config4.logCleanupPolicy());
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"})));
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password"})));
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assert.assertEquals((Object)"key_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assert.assertEquals((Object)"keystore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assert.assertEquals((Object)"truststore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    @Test
    public void testKafkaSslPasswordsWithSymbols() {
        String password = "=!#-+!?*/\"'^%$=\\.,@:;=";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringBuilder().append((Object)"ssl.keystore.password=").append((Object)password).toString(), "--override", new StringBuilder().append((Object)"ssl.key.password=").append((Object)password).toString(), "--override", new StringBuilder().append((Object)"ssl.truststore.password=").append((Object)password).toString()})));
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    private boolean booleanPropValueToSet() {
        return this.booleanPropValueToSet;
    }

    private String stringPropValueToSet() {
        return this.stringPropValueToSet;
    }

    private String passwordPropValueToSet() {
        return this.passwordPropValueToSet;
    }

    private List<String> listPropValueToSet() {
        return this.listPropValueToSet;
    }

    @Test
    public void testZkSslClientEnable() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "zookeeper.ssl.client.enable", "zookeeper.client.secure", (Object)BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet()), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Some<Object> apply(KafkaConfig config) {
                return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.zkSslClientEnable()));
            }
        }, (Object)BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet()), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    @Test
    public void testZkSslKeyStoreLocation() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp(), "zookeeper.ssl.keystore.location", "zookeeper.ssl.keyStore.location", (Object)this.stringPropValueToSet(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(KafkaConfig config) {
                return config.zkSslKeyStoreLocation();
            }
        }, (Object)this.stringPropValueToSet(), (Option)this.testZkConfig$default$7());
    }

    @Test
    public void testZkSslTrustStoreLocation() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp(), "zookeeper.ssl.truststore.location", "zookeeper.ssl.trustStore.location", (Object)this.stringPropValueToSet(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(KafkaConfig config) {
                return config.zkSslTrustStoreLocation();
            }
        }, (Object)this.stringPropValueToSet(), (Option)this.testZkConfig$default$7());
    }

    @Test
    public void testZookeeperKeyStorePassword() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp(), "zookeeper.ssl.keystore.password", "zookeeper.ssl.keyStore.password", (Object)this.passwordPropValueToSet(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Password> apply(KafkaConfig config) {
                return config.zkSslKeyStorePassword();
            }
        }, (Object)new Password(this.passwordPropValueToSet()), (Option)this.testZkConfig$default$7());
    }

    @Test
    public void testZookeeperTrustStorePassword() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp(), "zookeeper.ssl.truststore.password", "zookeeper.ssl.trustStore.password", (Object)this.passwordPropValueToSet(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Password> apply(KafkaConfig config) {
                return config.zkSslTrustStorePassword();
            }
        }, (Object)new Password(this.passwordPropValueToSet()), (Option)this.testZkConfig$default$7());
    }

    @Test
    public void testZkSslKeyStoreType() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp(), "zookeeper.ssl.keystore.type", "zookeeper.ssl.keyStore.type", (Object)this.stringPropValueToSet(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(KafkaConfig config) {
                return config.zkSslKeyStoreType();
            }
        }, (Object)this.stringPropValueToSet(), (Option)this.testZkConfig$default$7());
    }

    @Test
    public void testZkSslTrustStoreType() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp(), "zookeeper.ssl.truststore.type", "zookeeper.ssl.trustStore.type", (Object)this.stringPropValueToSet(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(KafkaConfig config) {
                return config.zkSslTrustStoreType();
            }
        }, (Object)this.stringPropValueToSet(), (Option)this.testZkConfig$default$7());
    }

    @Test
    public void testZkSslProtocol() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslProtocolProp(), "zookeeper.ssl.protocol", "zookeeper.ssl.protocol", (Object)this.stringPropValueToSet(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Some<String> apply(KafkaConfig config) {
                return new Some((Object)config.ZkSslProtocol());
            }
        }, (Object)this.stringPropValueToSet(), (Option)new Some((Object)"TLSv1.2"));
    }

    @Test
    public void testZkSslEnabledProtocols() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp(), "zookeeper.ssl.enabled.protocols", "zookeeper.ssl.enabledProtocols", (Object)this.listPropValueToSet().mkString(","), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<java.util.List<String>> apply(KafkaConfig config) {
                return config.ZkSslEnabledProtocols();
            }
        }, (Object)JavaConverters$.MODULE$.seqAsJavaListConverter(this.listPropValueToSet()).asJava(), (Option)this.testZkConfig$default$7());
    }

    @Test
    public void testZkSslCipherSuites() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslCipherSuitesProp(), "zookeeper.ssl.cipher.suites", "zookeeper.ssl.ciphersuites", (Object)this.listPropValueToSet().mkString(","), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<java.util.List<String>> apply(KafkaConfig config) {
                return config.ZkSslCipherSuites();
            }
        }, (Object)JavaConverters$.MODULE$.seqAsJavaListConverter(this.listPropValueToSet()).asJava(), (Option)this.testZkConfig$default$7());
    }

    @Test
    public void testZkSslEndpointIdentificationAlgorithm() {
        String kafkaPropName = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        Assert.assertEquals((Object)"zookeeper.ssl.endpoint.identification.algorithm", (Object)kafkaPropName);
        String sysProp = "zookeeper.ssl.hostnameVerification";
        String expectedDefaultValue = "HTTPS";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assert.assertNull(emptyConfig.originals().get(kafkaPropName));
        Assert.assertEquals((Object)expectedDefaultValue, emptyConfig.values().get(kafkaPropName));
        Assert.assertEquals((Object)expectedDefaultValue, (Object)emptyConfig.ZkSslEndpointIdentificationAlgorithm());
        ((IterableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), (Object)"")}))).foreach((Function1)new Serializable(this, kafkaPropName, sysProp, expectedDefaultValue, propertiesFile){
            public static final long serialVersionUID = 0L;
            private final String kafkaPropName$1;
            private final String sysProp$1;
            private final String expectedDefaultValue$1;
            private final String propertiesFile$1;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String sysPropValue = (String)tuple2._1();
                    String expected = (String)tuple2._2();
                    System.setProperty(this.sysProp$1, sysPropValue);
                    KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{this.propertiesFile$1})));
                    Assert.assertNull(config.originals().get(this.kafkaPropName$1));
                    Assert.assertEquals((Object)this.expectedDefaultValue$1, config.values().get(this.kafkaPropName$1));
                    Assert.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
                finally {
                    System.clearProperty(this.sysProp$1);
                }
            }
            {
                this.kafkaPropName$1 = kafkaPropName$1;
                this.sysProp$1 = sysProp$1;
                this.expectedDefaultValue$1 = expectedDefaultValue$1;
                this.propertiesFile$1 = propertiesFile$1;
            }
        });
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https", ""})).foreach((Function1)new Serializable(this, kafkaPropName, propertiesFile){
            public static final long serialVersionUID = 0L;
            private final String kafkaPropName$1;
            private final String propertiesFile$1;

            public final void apply(String expected) {
                KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{this.propertiesFile$1, "--override", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPropName$1, expected}))})));
                Assert.assertEquals((Object)expected, config.originals().get(this.kafkaPropName$1));
                Assert.assertEquals((Object)expected, config.values().get(this.kafkaPropName$1));
                Assert.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
            }
            {
                this.kafkaPropName$1 = kafkaPropName$1;
                this.propertiesFile$1 = propertiesFile$1;
            }
        });
    }

    @Test
    public void testZkSslCrlEnable() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslCrlEnableProp(), "zookeeper.ssl.crl.enable", "zookeeper.ssl.crl", (Object)BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet()), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Some<Object> apply(KafkaConfig config) {
                return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslCrlEnable()));
            }
        }, (Object)BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet()), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    @Test
    public void testZkSslOcspEnable() {
        this.testZkConfig(KafkaConfig$.MODULE$.ZkSslOcspEnableProp(), "zookeeper.ssl.ocsp.enable", "zookeeper.ssl.ocsp", (Object)BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet()), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Some<Object> apply(KafkaConfig config) {
                return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslOcspEnable()));
            }
        }, (Object)BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet()), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    @Test
    public void testConnectionsMaxReauthMsDefault() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testConnectionsMaxReauthMsExplicit() {
        String propertiesFile = this.prepareDefaultConfig();
        int expected = 3600000;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sasl_ssl.oauthbearer.connections.max.reauth.ms=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expected)}))})));
        Assert.assertEquals((long)expected, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    private <T, U> void testZkConfig(String kafkaPropName, String expectedKafkaPropName, String sysPropName, T propValueToSet, Function1<KafkaConfig, Option<T>> getPropValueFrom, U expectedPropertyValue, Option<T> expectedDefaultValue) {
        Assert.assertEquals((Object)expectedKafkaPropName, (Object)kafkaPropName);
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assert.assertNull(emptyConfig.originals().get(kafkaPropName));
        if (expectedDefaultValue.isDefined()) {
            Assert.assertEquals((Object)expectedDefaultValue.get(), emptyConfig.values().get(kafkaPropName));
            Assert.assertEquals((Object)expectedDefaultValue.get(), (Object)((Option)getPropValueFrom.apply((Object)emptyConfig)).get());
        } else {
            Assert.assertNull(emptyConfig.values().get(kafkaPropName));
            Assert.assertEquals((Object)None$.MODULE$, (Object)getPropValueFrom.apply((Object)emptyConfig));
        }
        System.setProperty(sysPropName, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{propValueToSet})));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assert.assertNull(config.originals().get(kafkaPropName));
        if (expectedDefaultValue.isDefined()) {
            Assert.assertEquals((Object)expectedDefaultValue.get(), config.values().get(kafkaPropName));
        } else {
            Assert.assertNull(config.values().get(kafkaPropName));
        }
        Assert.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kafkaPropName, propValueToSet}))})));
        Assert.assertEquals(expectedPropertyValue, config2.values().get(kafkaPropName));
        Assert.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config2));
        return;
        finally {
            System.clearProperty(sysPropName);
        }
    }

    private <T, U> None$ testZkConfig$default$7() {
        return None$.MODULE$;
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig((String[])((Object[])new String[]{"broker.id=1", "zookeeper.connect=somewhere"}));
    }

    /*
     * WARNING - void declaration
     */
    public String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        try {
            Predef$.MODULE$.refArrayOps((Object[])lines).foreach((Function1)new Serializable(this, writer){
                public static final long serialVersionUID = 0L;
                private final OutputStream writer$1;

                public final void apply(String l) {
                    this.writer$1.write(l.getBytes());
                    this.writer$1.write("\n".getBytes());
                }
                {
                    this.writer$1 = writer$1;
                }
            });
            string = file.getAbsolutePath();
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        writer.close();
        return string;
    }

    public KafkaTest() {
        this.booleanPropValueToSet = true;
        this.stringPropValueToSet = "foo";
        this.passwordPropValueToSet = "ThePa$$word!";
    }
}

