/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminZkClientTest$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReplicaDistributions;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.AbstractLog;
import kafka.log.Defaults$;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#\u00113nS:T6n\u00117jK:$H+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u000f)A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0003u.L!!\u0004\u0006\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u00055\u0011\u0016mY6Bo\u0006\u0014X\rV3ti\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u0003+\u0001Aq!\b\u0001A\u0002\u0013\u0005a$A\u0004tKJ4XM]:\u0016\u0003}\u00012\u0001I\u0013(\u001b\u0005\t#B\u0001\u0012$\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002I\u0005)1oY1mC&\u0011a%\t\u0002\u0004'\u0016\f\bC\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011A&\u000b\u0002\f\u0017\u000647.Y*feZ,'\u000fC\u0004/\u0001\u0001\u0007I\u0011A\u0018\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003aQ\u0002\"!\r\u001a\u000e\u0003\rJ!aM\u0012\u0003\tUs\u0017\u000e\u001e\u0005\bk5\n\t\u00111\u0001 \u0003\rAH%\r\u0005\u0007o\u0001\u0001\u000b\u0015B\u0010\u0002\u0011M,'O^3sg\u0002BQ!\u000f\u0001\u0005Bi\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002a!\u0012\u0001\b\u0010\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000bQA[;oSRT\u0011!Q\u0001\u0004_J<\u0017BA\"?\u0005\u0015\te\r^3s\u0011\u0015)\u0005\u0001\"\u0001;\u0003m!Xm\u001d;NC:,\u0018\r\u001c*fa2L7-Y!tg&<g.\\3oi\"\u0012Ai\u0012\t\u0003{!K!!\u0013 \u0003\tQ+7\u000f\u001e\u0005\u0006\u0017\u0002!\tAO\u0001\u0016i\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>t\u0017J\u001c.LQ\tQu\tC\u0003O\u0001\u0011\u0005!(\u0001\u0010uKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:<\u0016\u000e\u001e5D_2d\u0017n]5p]\"\u0012Qj\u0012\u0005\u0006#\u0002!\tAO\u0001\"i\u0016\u001cH/T8dW\u0016$7i\u001c8dkJ\u0014XM\u001c;U_BL7m\u0011:fCRLwN\u001c\u0015\u0003!\u001eCQ\u0001\u0016\u0001\u0005\u0002i\n1\u0004^3ti\u000e{gnY;se\u0016tG\u000fV8qS\u000e\u001c%/Z1uS>t\u0007FA*H\u0011\u00159\u0006\u0001\"\u0001;\u0003U!Xm\u001d;U_BL7mQ8oM&<7\t[1oO\u0016D#AV$\t\u000bi\u0003A\u0011\u0001\u001e\u0002kQ,7\u000f^!eIB\u000b'\u000f^5uS>tw+\u001b;i\u001d>\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u\u001d>\f5o]5h]6,g\u000e\u001e\u0015\u00033\u001eCQ!\u0018\u0001\u0005\u0002i\nq\u0007^3ti\u0006#G\rU1si&$\u0018n\u001c8XSRDgj\u001c)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$x+\u001b;i\u0003N\u001c\u0018n\u001a8nK:$\bF\u0001/H\u0011\u0015\u0001\u0007\u0001\"\u0001;\u0003q\"Xm\u001d;BI\u0012\u0004\u0016M\u001d;ji&|gnV5uQBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;O_B\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;)\u0005};\u0005\"B2\u0001\t\u0003Q\u0014A\u0010;fgR\fE\r\u001a)beRLG/[8o/&$\b\u000e\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]R<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0002c\u000f\")a\r\u0001C\u0001u\u0005QD/Z:u\u0003\u0012$\u0007+\u0019:uSRLwN\\,ji\"\u0014V\r\u001d7jG\u0006\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u\u001d>$8+\u0019;jg\u001aLW\r\u001a\u0015\u0005K\u001eC\u0017.\u0001\u0005fqB,7\r^3eG\u0005Q\u0007CA6t\u001b\u0005a'BA7o\u0003\u0019)'O]8sg*\u0011q\u000e]\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\t(B\u0001:A\u0003\u0019\t\u0007/Y2iK&\u0011A\u000f\u001c\u0002\u001e\u0013:4\u0018\r\\5e\u0007>tg-[4ve\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\")a\u000f\u0001C\u0001u\u0005YD/Z:u\u0003\u0012$\u0007+\u0019:uSRLwN\\,ji\"|%m]3sm\u0016\u0014\b\u000b\\1dK6,g\u000e^\"p]N$(/Y5oi:{GoU1uSN4\u0017.\u001a3)\tU<\u0005.\u001b\u0005\u0006s\u0002!\tAO\u0001$g\"|W\u000f\u001c3Qe>\u0004\u0018mZ1uK\u0012Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4tQ\tAx\tC\u0003}\u0001\u0011\u0005!(A\u000euKN$(i\\8ugR\u0014\u0018\r]\"mS\u0016tG/\u00133D_:4\u0017n\u001a\u0015\u0003w\u001eCQa \u0001\u0005\u0002i\na\u0003^3ti\u001e+GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0015\u0003}\u001e\u0003")
public class AdminZkClientTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private Seq<KafkaServer> servers;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment2, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment2, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testManualReplicaAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Properties topicConfig = new Properties();
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final Properties topicConfig$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient qual$1 = this.$outer.adminZkClient();
                String x$13 = "test";
                Properties x$14 = this.topicConfig$1;
                Map x$15 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0})), (Seq)Seq$.MODULE$.empty()))}));
                boolean x$16 = qual$1.createTopicWithAssignment$default$4();
                qual$1.createTopicWithAssignment(x$13, x$14, x$15, x$16);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicConfig$1 = topicConfig$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final Properties topicConfig$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient qual$2 = this.$outer.adminZkClient();
                String x$17 = "test";
                Properties x$18 = this.topicConfig$1;
                Map x$19 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Seq$.MODULE$.empty()))}));
                boolean x$20 = qual$2.createTopicWithAssignment$default$4();
                qual$2.createTopicWithAssignment(x$17, x$18, x$19, x$20);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicConfig$1 = topicConfig$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final Properties topicConfig$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient qual$3 = this.$outer.adminZkClient();
                String x$21 = "test";
                Properties x$22 = this.topicConfig$1;
                Map x$23 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty()))}));
                boolean x$24 = qual$3.createTopicWithAssignment$default$4();
                qual$3.createTopicWithAssignment(x$21, x$22, x$23, x$24);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicConfig$1 = topicConfig$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final Properties topicConfig$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient qual$4 = this.$outer.adminZkClient();
                String x$25 = "test";
                Properties x$26 = this.topicConfig$1;
                Map x$27 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty()))}));
                boolean x$28 = qual$4.createTopicWithAssignment$default$4();
                qual$4.createTopicWithAssignment(x$25, x$26, x$27, x$28);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicConfig$1 = topicConfig$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final Properties topicConfig$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient qual$5 = this.$outer.adminZkClient();
                String x$29 = "test";
                Properties x$30 = this.topicConfig$1;
                Map x$31 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty()))}));
                boolean x$32 = qual$5.createTopicWithAssignment$default$4();
                qual$5.createTopicWithAssignment(x$29, x$30, x$31, x$32);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicConfig$1 = topicConfig$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        Map assignment2 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty()))}));
        AdminZkClient qual$6 = this.adminZkClient();
        String x$33 = "test";
        Properties x$34 = topicConfig;
        Map x$35 = assignment2;
        boolean x$36 = qual$6.createTopicWithAssignment$default$4();
        qual$6.createTopicWithAssignment(x$33, x$34, x$35, x$36);
        Map found = this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assert.assertEquals((Object)assignment2, (Object)found.apply((Object)"test"));
    }

    @Test
    public void testTopicCreationInZK() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Seq)Seq$.MODULE$.empty()))}));
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        String topic = "test";
        Properties topicConfig = new Properties();
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminZkClient qual$7 = this.adminZkClient();
        String x$37 = topic;
        Properties x$38 = topicConfig;
        Map x$39 = expectedReplicaAssignment;
        boolean x$40 = qual$7.createTopicWithAssignment$default$4();
        qual$7.createTopicWithAssignment(x$37, x$38, x$39, x$40);
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkClient(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        Map actualReplicaMap = (Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).apply((Object)topic);
        Assert.assertEquals((long)expectedReplicaAssignment.size(), (long)actualReplicaMap.size());
        actualReplicaMap.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, ReplicaAssignment> check$ifrefutable$1) {
                Tuple2<Object, ReplicaAssignment> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, expectedReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final Map expectedReplicaAssignment$1;

            public final void apply(Tuple2<Object, ReplicaAssignment> x$1) {
                Tuple2<Object, ReplicaAssignment> tuple2 = x$1;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    ReplicaAssignment value = (ReplicaAssignment)tuple2._2();
                    Assert.assertEquals((Object)this.expectedReplicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)key)), (Object)value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
            }
        });
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, expectedReplicaAssignment, topic, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final Map expectedReplicaAssignment$1;
            private final String topic$1;
            private final Properties topicConfig$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient qual$8 = this.$outer.adminZkClient();
                String x$41 = this.topic$1;
                Properties x$42 = this.topicConfig$2;
                Map x$43 = this.expectedReplicaAssignment$1;
                boolean x$44 = qual$8.createTopicWithAssignment$default$4();
                qual$8.createTopicWithAssignment(x$41, x$42, x$43, x$44);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
                this.topic$1 = topic$1;
                this.topicConfig$2 = topicConfig$2;
            }
        }, ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminZkClient qual$9 = this.adminZkClient();
        String x$45 = topic;
        int x$46 = 3;
        int x$47 = 1;
        Properties x$48 = qual$9.createTopic$default$4();
        RackAwareMode x$49 = qual$9.createTopic$default$5();
        boolean x$50 = qual$9.createTopic$default$6();
        qual$9.createTopic(x$45, x$46, x$47, x$48, x$49, x$50);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, collidingTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final String collidingTopic$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient qual$10 = this.$outer.adminZkClient();
                String x$51 = this.collidingTopic$1;
                int x$52 = 3;
                int x$53 = 1;
                Properties x$54 = qual$10.createTopic$default$4();
                RackAwareMode x$55 = qual$10.createTopic$default$5();
                boolean x$56 = qual$10.createTopic$default$6();
                qual$10.createTopic(x$51, x$52, x$53, x$54, x$55, x$56);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.collidingTopic$1 = collidingTopic$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
    }

    @Test
    public void testMockedConcurrentTopicCreation() {
        String topic = "test.topic";
        KafkaZkClient zkMock = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.topicExists(topic))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)zkMock.getAllTopicsInCluster()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"some.topic", topic, "some.other.topic"})));
        EasyMock.replay((Object[])new Object[]{zkMock});
        AdminZkClient adminZkClient = new AdminZkClient(zkMock);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, topic, adminZkClient){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final AdminZkClient adminZkClient$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.adminZkClient$1.validateTopicCreate(this.topic$2, (Map)Map$.MODULE$.empty(), new Properties());
            }
            {
                this.topic$2 = topic$2;
                this.adminZkClient$1 = adminZkClient$1;
            }
        }, ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
    }

    @Test
    public void testConcurrentTopicCreation() {
        String topic = "test-concurrent-topic-creation";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        Properties props = new Properties();
        props.setProperty("min.insync.replicas", "2");
        TestUtils$.MODULE$.assertConcurrent("Concurrent topic creation failed", (Seq<Function0<Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this, topic, props){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final String topic$3;
            private final Properties props$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$AdminZkClientTest$$createTopic$1(this.topic$3, this.props$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.props$1 = props$1;
            }
        }, new Serializable(this, topic, props){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final String topic$3;
            private final Properties props$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$AdminZkClientTest$$createTopic$1(this.topic$3, this.props$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.props$1 = props$1;
            }
        }}))), (int)15000L);
    }

    @Test
    public void testTopicConfigChange() {
        int partitions = 3;
        String topic = "my-topic";
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))));
        int maxMessageSize = 1024;
        int retentionMs = 1000000;
        AdminZkClient qual$13 = this.adminZkClient();
        String x$65 = topic;
        int x$66 = partitions;
        int x$67 = 1;
        Properties x$68 = this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1");
        RackAwareMode x$69 = qual$13.createTopic$default$5();
        boolean x$70 = qual$13.createTopic$default$6();
        qual$13.createTopic(x$65, x$66, x$67, x$68, x$69, x$70);
        this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        Properties newConfig = this.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*");
        this.adminZkClient().changeTopicConfig(topic, this.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*"));
        this.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*", true, partitions, topic, server);
        Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        Assert.assertEquals((Object)newConfig, (Object)configInZk);
        this.adminZkClient().changeTopicConfig(topic, new Properties());
        this.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)""), new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"")})));
        this.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
    }

    @Test
    public void testAddPartitionWithNoPlacementConstraintNoAssignment() {
        Map existingAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty()))}));
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int id) {
                String rack = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(id / 5 + 1))}));
                return new BrokerMetadata(id, (Option)new Some((Object)rack));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        AdminZkClient qual$14 = this.adminZkClient();
        String x$71 = topicName;
        int x$72 = 1;
        int x$73 = 3;
        Properties x$74 = props;
        RackAwareMode x$75 = qual$14.createTopic$default$5();
        boolean x$76 = qual$14.createTopic$default$6();
        qual$14.createTopic(x$71, x$72, x$73, x$74, x$75, x$76);
        AdminZkClient qual$15 = this.adminZkClient();
        String x$77 = topicName;
        Map x$78 = existingAssignment;
        IndexedSeq x$79 = brokers;
        int x$80 = 3;
        None$ x$81 = None$.MODULE$;
        None$ x$82 = None$.MODULE$;
        boolean x$83 = qual$15.addPartitions$default$6();
        Map partitionAssignment = qual$15.addPartitions(x$77, x$78, (Seq)x$79, x$80, (Option)x$81, x$83, (Option)x$82);
        Assert.assertEquals((long)3L, (long)partitionAssignment.size());
        ((IterableLike)partitionAssignment.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$2) {
                return x$2.replicas();
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Object> assignedBrokers) {
                Assert.assertEquals((long)3L, (long)assignedBrokers.toSet().size());
            }
        });
        ((IterableLike)partitionAssignment.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$3) {
                return x$3.observers();
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Object> observers) {
                Assert.assertTrue((String)observers.mkString(","), (boolean)observers.isEmpty());
            }
        });
    }

    @Test
    public void testAddPartitionWithNoPlacementConstraintWithAssignment() {
        Map existingAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty()))}));
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int id) {
                String rack = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(id / 5 + 1))}));
                return new BrokerMetadata(id, (Option)new Some((Object)rack));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        AdminZkClient qual$16 = this.adminZkClient();
        String x$84 = topicName;
        int x$85 = 1;
        int x$86 = 3;
        Properties x$87 = props;
        RackAwareMode x$88 = qual$16.createTopic$default$5();
        boolean x$89 = qual$16.createTopic$default$6();
        qual$16.createTopic(x$84, x$85, x$86, x$87, x$88, x$89);
        Map newReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2})), (Seq)Seq$.MODULE$.empty()))}));
        AdminZkClient qual$17 = this.adminZkClient();
        String x$90 = topicName;
        Map x$91 = existingAssignment;
        IndexedSeq x$92 = brokers;
        int x$93 = 10;
        Some x$94 = new Some((Object)newReplicaAssignment);
        None$ x$95 = None$.MODULE$;
        boolean x$96 = qual$17.addPartitions$default$6();
        Map partitionAssignment = qual$17.addPartitions(x$90, x$91, (Seq)x$92, x$93, (Option)x$94, x$96, (Option)x$95);
        Assert.assertEquals((Object)existingAssignment.$plus$plus((GenTraversableOnce)newReplicaAssignment), (Object)partitionAssignment);
    }

    @Test
    public void testAddPartitionWithPlacementConstraintNoPartitionAssignment() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack-1\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack-2\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        Option topicPlacement = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        Map existingAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6}))))}));
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int id) {
                String rack = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(id / 5 + 1))}));
                return new BrokerMetadata(id, (Option)new Some((Object)rack));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        props.setProperty("confluent.placement.constraints", placementJson);
        AdminZkClient qual$18 = this.adminZkClient();
        String x$97 = topicName;
        int x$98 = 1;
        int x$99 = 4;
        Properties x$100 = props;
        RackAwareMode x$101 = qual$18.createTopic$default$5();
        boolean x$102 = qual$18.createTopic$default$6();
        qual$18.createTopic(x$97, x$98, x$99, x$100, x$101, x$102);
        Map partitionAssignment = this.adminZkClient().addPartitions(topicName, existingAssignment, (Seq)brokers, 3, (Option)None$.MODULE$, false, topicPlacement);
        Assert.assertEquals((long)3L, (long)partitionAssignment.size());
        ((IterableLike)partitionAssignment.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$4) {
                return x$4.replicas();
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Object> assignedBrokers) {
                Assert.assertEquals((long)4L, (long)assignedBrokers.toSet().size());
                ((IterableLike)assignedBrokers.take(2)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(int brokerId) {
                        this.apply$mcVI$sp(brokerId);
                    }

                    public void apply$mcVI$sp(int brokerId) {
                        Assert.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0);
                    }
                });
                ((IterableLike)assignedBrokers.slice(2, 4)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(int brokerId) {
                        this.apply$mcVI$sp(brokerId);
                    }

                    public void apply$mcVI$sp(int brokerId) {
                        Assert.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0);
                    }
                });
            }
        });
        ((IterableLike)partitionAssignment.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$5) {
                return x$5.observers();
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Object> observers) {
                Assert.assertTrue((String)observers.mkString(","), (boolean)observers.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int observerId) {
                        return this.apply$mcZI$sp(observerId);
                    }

                    public boolean apply$mcZI$sp(int observerId) {
                        return observerId >= 5 && observerId <= 9;
                    }
                }));
            }
        });
    }

    @Test
    public void testAddPartitionWithPlacementConstraintWithPartitionAssignment() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack-1\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack-2\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        Option topicPlacement = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        Map existingAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6}))))}));
        Map newAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 7, 8})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8}))))}));
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int id) {
                String rack = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(id / 5 + 1))}));
                return new BrokerMetadata(id, (Option)new Some((Object)rack));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        props.setProperty("confluent.placement.constraints", placementJson);
        AdminZkClient qual$19 = this.adminZkClient();
        String x$103 = topicName;
        int x$104 = 1;
        int x$105 = 4;
        Properties x$106 = props;
        RackAwareMode x$107 = qual$19.createTopic$default$5();
        boolean x$108 = qual$19.createTopic$default$6();
        qual$19.createTopic(x$103, x$104, x$105, x$106, x$107, x$108);
        Map partitionAssignment = this.adminZkClient().addPartitions(topicName, existingAssignment, (Seq)brokers, 2, (Option)new Some((Object)newAssignment), false, topicPlacement);
        Assert.assertEquals((Object)existingAssignment.$plus$plus((GenTraversableOnce)newAssignment), (Object)partitionAssignment);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testAddPartitionWithReplicaPlacementConstraintNotSatisfied() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 6,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack-1\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack-2\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        Option topicPlacement = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        Map existingAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7}))))}));
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int id) {
                String rack = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(id / 5 + 1))}));
                return new BrokerMetadata(id, (Option)new Some((Object)rack));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        props.setProperty("confluent.placement.constraints", placementJson);
        AdminZkClient qual$20 = this.adminZkClient();
        String x$109 = topicName;
        int x$110 = 1;
        int x$111 = 4;
        Properties x$112 = props;
        RackAwareMode x$113 = qual$20.createTopic$default$5();
        boolean x$114 = qual$20.createTopic$default$6();
        qual$20.createTopic(x$109, x$110, x$111, x$112, x$113, x$114);
        this.adminZkClient().addPartitions(topicName, existingAssignment, (Seq)brokers, 3, (Option)None$.MODULE$, false, topicPlacement);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testAddPartitionWithObserverPlacementConstraintNotSatisfied() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack-1\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 6,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack-2\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        Option topicPlacement = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        Map existingAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), 10), (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(4), 10)))}));
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int id) {
                String rack = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(id / 5 + 1))}));
                return new BrokerMetadata(id, (Option)new Some((Object)rack));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        props.setProperty("confluent.placement.constraints", placementJson);
        AdminZkClient qual$21 = this.adminZkClient();
        String x$115 = topicName;
        int x$116 = 1;
        int x$117 = 4;
        Properties x$118 = props;
        RackAwareMode x$119 = qual$21.createTopic$default$5();
        boolean x$120 = qual$21.createTopic$default$6();
        qual$21.createTopic(x$115, x$116, x$117, x$118, x$119, x$120);
        this.adminZkClient().addPartitions(topicName, existingAssignment, (Seq)brokers, 3, (Option)None$.MODULE$, false, topicPlacement);
    }

    @Test
    public void shouldPropagateDynamicBrokerConfigs() {
        Seq brokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig x$6) {
                return TestUtils$.MODULE$.createServer(x$6, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        long limit = 1000000L;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)limit)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)limit)).toString())})));
        this.checkConfig$2(limit);
        long newLimit = 2L * limit;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)newLimit)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)newLimit)).toString())})));
        this.checkConfig$2(newLimit);
        brokerIds.foreach((Function1)new Serializable(this, newLimit){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final long newLimit$1;

            public final void apply(int brokerId) {
                this.apply$mcVI$sp(brokerId);
            }

            public void apply$mcVI$sp(int brokerId) {
                Properties configInZk = this.$outer.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString());
                Assert.assertEquals((long)this.newLimit$1, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()))).toInt());
                Assert.assertEquals((long)this.newLimit$1, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()))).toInt());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newLimit$1 = newLimit$1;
            }
        });
        this.adminZkClient().changeBrokerConfig(brokerIds, new Properties());
        this.checkConfig$2(DynamicConfig.Broker$.MODULE$.DefaultReplicationThrottledRate());
    }

    @Test
    public void testBootstrapClientIdConfig() {
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Client(), clientId, props);
        Map configInZk = this.adminZkClient().fetchAllEntityConfigs(ConfigType$.MODULE$.Client());
        Assert.assertEquals((String)"Must have 1 overridden client config", (long)1L, (long)configInZk.size());
        Assert.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))));
        Assert.assertEquals((Object)new Quota(1000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().produce().quota("ANONYMOUS", clientId));
        Assert.assertEquals((Object)new Quota(2000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().fetch().quota("ANONYMOUS", clientId));
    }

    @Test
    public void testGetBrokerMetadatas() {
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5);
        Map rackInfo = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        Seq<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)brokerList.filterNot((Function1)rackInfo.keySet())));
        TestUtils$.MODULE$.createBrokersInZk(brokerMetadatas, this.zkClient());
        AdminZkClient qual$22 = this.adminZkClient();
        RackAwareMode.Disabled$ x$121 = RackAwareMode.Disabled$.MODULE$;
        Option x$122 = qual$22.getBrokerMetadatas$default$2();
        Seq processedMetadatas1 = qual$22.getBrokerMetadatas((RackAwareMode)x$121, x$122);
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$7) {
                return x$7.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        }), (Object)processedMetadatas1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(BrokerMetadata x$8) {
                return x$8.rack();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        AdminZkClient qual$23 = this.adminZkClient();
        RackAwareMode.Safe$ x$123 = RackAwareMode.Safe$.MODULE$;
        Option x$124 = qual$23.getBrokerMetadatas$default$2();
        Seq processedMetadatas2 = qual$23.getBrokerMetadatas((RackAwareMode)x$123, x$124);
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$9) {
                return x$9.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        }), (Object)processedMetadatas2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(BrokerMetadata x$10) {
                return x$10.rack();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;

            public final Seq<BrokerMetadata> apply() {
                AdminZkClient qual$24 = this.$outer.adminZkClient();
                RackAwareMode.Enforced$ x$125 = RackAwareMode.Enforced$.MODULE$;
                Option x$126 = qual$24.getBrokerMetadatas$default$2();
                return qual$24.getBrokerMetadatas((RackAwareMode)x$125, x$126);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
        List partialList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5}));
        Seq processedMetadatas3 = this.adminZkClient().getBrokerMetadatas((RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assert.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$11) {
                return x$11.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)partialList.map((Function1)rackInfo, List$.MODULE$.canBuildFrom()), (Object)processedMetadatas3.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(BrokerMetadata x$12) {
                return Option$.MODULE$.option2Iterable(x$12.rack());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        int numPartitions = 3;
        AdminZkClient qual$25 = this.adminZkClient();
        String x$127 = "foo";
        int x$128 = numPartitions;
        int x$129 = 2;
        RackAwareMode.Safe$ x$130 = RackAwareMode.Safe$.MODULE$;
        Properties x$131 = qual$25.createTopic$default$4();
        boolean x$132 = qual$25.createTopic$default$6();
        qual$25.createTopic(x$127, x$128, x$129, x$131, (RackAwareMode)x$130, x$132);
        Map assignment2 = this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((long)numPartitions, (long)assignment2.size());
    }

    public final void kafka$admin$AdminZkClientTest$$createTopic$1(String topic$3, Properties props$1) {
        try {
            AdminZkClient qual$11 = this.adminZkClient();
            String x$57 = topic$3;
            int x$58 = 3;
            int x$59 = 1;
            Properties x$60 = props$1;
            RackAwareMode x$61 = qual$11.createTopic$default$5();
            boolean x$62 = qual$11.createTopic$default$6();
            qual$11.createTopic(x$57, x$58, x$59, x$60, x$61, x$62);
        }
        catch (TopicExistsException topicExistsException) {}
        Tuple2 tuple2 = (Tuple2)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$3}))).head();
        if (tuple2 != null) {
            Map partitionAssignment;
            Map map;
            Map partitionAssignment2 = map = (partitionAssignment = (Map)tuple2._2());
            Assert.assertEquals((long)3L, (long)partitionAssignment2.size());
            partitionAssignment2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Object, ReplicaAssignment> x0$1) {
                    Tuple2<Object, ReplicaAssignment> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int partition = tuple2._1$mcI$sp();
                        ReplicaAssignment partitionReplicaAssignment = (ReplicaAssignment)tuple2._2();
                        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected replication factor for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition)})), (long)1L, (long)partitionReplicaAssignment.replicas().size());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            Properties savedProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), topic$3);
            Assert.assertEquals((Object)props$1, (Object)savedProps);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final Properties makeConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)messageSize)).toString());
        props.setProperty(LogConfig$.MODULE$.RetentionMsProp(), ((Object)BoxesRunTime.boxToLong((long)retentionMs)).toString());
        props.setProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), throttledLeaders);
        props.setProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), throttledFollowers);
        return props;
    }

    public final void kafka$admin$AdminZkClientTest$$checkList$1(java.util.List actual, String expected) {
        Assert.assertNotNull((Object)actual);
        String string = expected;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Assert.assertTrue((boolean)actual.isEmpty());
        } else {
            Assert.assertEquals((Object)Predef$.MODULE$.refArrayOps((Object[])expected.split(",")).toSeq(), (Object)JavaConverters$.MODULE$.asScalaBufferConverter(actual).asScala());
        }
    }

    private final void checkConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers, boolean quotaManagerIsThrottled, int partitions$1, String topic$4, KafkaServer server$1) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, partitions$1, topic$4, server$1, messageSize, retentionMs, throttledLeaders, throttledFollowers, quotaManagerIsThrottled){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final int partitions$1;
            public final String topic$4;
            public final KafkaServer server$1;
            public final int messageSize$1;
            public final long retentionMs$1;
            public final String throttledLeaders$1;
            public final String throttledFollowers$1;
            public final boolean quotaManagerIsThrottled$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitions$1).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkConfig$1$1 $outer;

                    public final void apply(int part) {
                        this.apply$mcVI$sp(part);
                    }

                    public void apply$mcVI$sp(int part) {
                        TopicPartition tp = new TopicPartition(this.$outer.topic$4, part);
                        LogManager qual$12 = this.$outer.server$1.logManager();
                        TopicPartition x$63 = tp;
                        boolean x$64 = qual$12.getLog$default$2();
                        Option log2 = qual$12.getLog(x$63, x$64);
                        Assert.assertTrue((boolean)log2.isDefined());
                        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)this.$outer.retentionMs$1), (Object)((AbstractLog)log2.get()).config().retentionMs());
                        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)this.$outer.messageSize$1), (Object)((AbstractLog)log2.get()).config().maxMessageSize());
                        this.$outer.kafka$admin$AdminZkClientTest$$anonfun$$$outer().kafka$admin$AdminZkClientTest$$checkList$1(((AbstractLog)log2.get()).config().LeaderReplicationThrottledReplicas(), this.$outer.throttledLeaders$1);
                        this.$outer.kafka$admin$AdminZkClientTest$$anonfun$$$outer().kafka$admin$AdminZkClientTest$$checkList$1(((AbstractLog)log2.get()).config().FollowerReplicationThrottledReplicas(), this.$outer.throttledFollowers$1);
                        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.quotaManagerIsThrottled$1), (Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.server$1.quotaManagers().leader().isThrottled(tp)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ AdminZkClientTest kafka$admin$AdminZkClientTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitions$1 = partitions$1;
                this.topic$4 = topic$4;
                this.server$1 = server$1;
                this.messageSize$1 = messageSize$1;
                this.retentionMs$1 = retentionMs$1;
                this.throttledLeaders$1 = throttledLeaders$1;
                this.throttledFollowers$1 = throttledFollowers$1;
                this.quotaManagerIsThrottled$1 = quotaManagerIsThrottled$1;
            }
        });
    }

    private final void checkConfig$2(long limit) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, limit){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            public final long limit$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.servers().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkConfig$2$1 $outer;

                    public final void apply(KafkaServer server) {
                        Assert.assertEquals((String)"Leader Quota Manager was not updated", (long)this.$outer.limit$1, (long)server.quotaManagers().leader().upperBound());
                        Assert.assertEquals((String)"Follower Quota Manager was not updated", (long)this.$outer.limit$1, (long)server.quotaManagers().follower().upperBound());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.limit$1 = limit$1;
            }
        });
    }

    public AdminZkClientTest() {
        RackAwareTest$class.$init$(this);
        this.servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

