/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.DeleteTopicTest$;
import kafka.admin.RackAwareMode;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.TopicCommand;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.log.AbstractLog;
import kafka.log.LogCleaner;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002R3mKR,Gk\u001c9jGR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0011!p[\u0005\u0003\u001b)\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002\u00011A\u0005\u0002U\tqa]3sm\u0016\u00148/F\u0001\u0017!\r9BDH\u0007\u00021)\u0011\u0011DG\u0001\u000bG>dG.Z2uS>t'\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uA\"aA*fcB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\r\u0002#aC&bM.\f7+\u001a:wKJDq!\n\u0001A\u0002\u0013\u0005a%A\u0006tKJ4XM]:`I\u0015\fHCA\u0014,!\tA\u0013&D\u0001\u001b\u0013\tQ#D\u0001\u0003V]&$\bb\u0002\u0017%\u0003\u0003\u0005\rAF\u0001\u0004q\u0012\n\u0004B\u0002\u0018\u0001A\u0003&a#\u0001\u0005tKJ4XM]:!\u0011\u001d\u0001\u0004A1A\u0005\u0002E\n\u0011$\u001a=qK\u000e$X\r\u001a*fa2L7-Y!tg&<g.\\3oiV\t!\u0007\u0005\u00034maZT\"\u0001\u001b\u000b\u0005UB\u0012!C5n[V$\u0018M\u00197f\u0013\t9DGA\u0002NCB\u0004\"\u0001K\u001d\n\u0005iR\"aA%oiB\u00191\u0007\u0010\u001d\n\u0005u\"$\u0001\u0002'jgRDaa\u0010\u0001!\u0002\u0013\u0011\u0014AG3ya\u0016\u001cG/\u001a3SKBd\u0017nY1BgNLwM\\7f]R\u0004\u0003bB!\u0001\u0005\u0004%\tAQ\u0001\u001eKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dC\u001a+H\u000e\\!tg&<g.\\3oiV\t1\t\u0005\u00034ma\"\u0005CA#I\u001b\u00051%BA$\u0005\u0003)\u0019wN\u001c;s_2dWM]\u0005\u0003\u0013\u001a\u0013\u0011CU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u0019Y\u0005\u0001)A\u0005\u0007\u0006qR\r\u001f9fGR,GMU3qY&\u001c\u0017MR;mY\u0006\u001b8/[4o[\u0016tG\u000f\t\u0005\u0006\u001b\u0002!\tET\u0001\ti\u0016\f'\u000fR8x]R\tq\u0005\u000b\u0002M!B\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002+\u0006\u0019qN]4\n\u0005]\u0013&!B!gi\u0016\u0014\b\"B-\u0001\t\u0003q\u0015a\t;fgR$U\r\\3uKR{\u0007/[2XSRD\u0017\t\u001c7BY&4XMU3qY&\u001c\u0017m\u001d\u0015\u00031n\u0003\"!\u0015/\n\u0005u\u0013&\u0001\u0002+fgRDQa\u0018\u0001\u0005\u00029\u000b!\u0006^3tiJ+7/^7f\t\u0016dW\r^3U_BL7mV5uQJ+7m\u001c<fe\u0016$gi\u001c7m_^,'\u000f\u000b\u0002_7\")!\r\u0001C\u0001\u001d\u0006IC/Z:u%\u0016\u001cX/\\3EK2,G/\u001a+pa&\u001cwJ\\\"p]R\u0014x\u000e\u001c7fe\u001a\u000b\u0017\u000e\\8wKJD#!Y.\t\u000b\u0015\u0004A\u0011\u0001(\u0002UQ,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e#ve&tw\rR3mKR,Gk\u001c9jG\"\u0012Am\u0017\u0005\u0006Q\u0002!I![\u0001\u000eO\u0016$8i\u001c8ue>dG.\u001a:\u0015\u0003)\u0004B\u0001K6\u001fq%\u0011AN\u0007\u0002\u0007)V\u0004H.\u001a\u001a\t\u000b9\u0004A\u0011\u0002(\u0002-\u0015t7/\u001e:f\u0007>tGO]8mY\u0016\u0014X\t_5tiNDQ\u0001\u001d\u0001\u0005\nE\fAdZ3u\u00032d'+\u001a9mS\u000e\f7O\u0012:p[\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0003sy\u0006\r\u0001cA:ws:\u0011\u0001\u0006^\u0005\u0003kj\ta\u0001\u0015:fI\u00164\u0017BA<y\u0005\r\u0019V\r\u001e\u0006\u0003kj\u0001\"!\u0012>\n\u0005m4%a\u0005)beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0007\"B?p\u0001\u0004q\u0018!\u0002;pa&\u001c\u0007CA:\u0000\u0013\r\t\t\u0001\u001f\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005\u0015q\u000e1\u0001\u0002\b\u0005Q\u0011m]:jO:lWM\u001c;\u0011\rM\fI\u0001OA\u0006\u0013\t9\u0004\u0010E\u0002\u00189aBa!a\u0004\u0001\t\u0003q\u0015a\u000b;fgRLen\u0019:fCN,\u0007+\u0019:uSRLwN\\\"pk:$H)\u001e:j]\u001e$U\r\\3uKR{\u0007/[2)\u0007\u000551\f\u0003\u0004\u0002\u0016\u0001!\tAT\u0001\"i\u0016\u001cH\u000fR3mKR,Gk\u001c9jG\u0012+(/\u001b8h\u0003\u0012$\u0007+\u0019:uSRLwN\u001c\u0015\u0004\u0003'Y\u0006BBA\u000e\u0001\u0011\u0005a*A\u0011uKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]\u0012+(/\u001b8h\t\u0016dW\r^3U_BL7\rK\u0002\u0002\u001amCa!!\t\u0001\t\u0003q\u0015A\b;fgR\u0014Vm\u0019:fCR,Gk\u001c9jG\u00063G/\u001a:EK2,G/[8oQ\r\tyb\u0017\u0005\u0007\u0003O\u0001A\u0011\u0001(\u00025Q,7\u000f\u001e#fY\u0016$XMT8o\u000bbL7\u000f^5oOR{\u0007/[2)\u0007\u0005\u00152\f\u0003\u0004\u0002.\u0001!\tAT\u0001\u001bi\u0016\u001cH\u000fR3mKR,Gk\u001c9jG^KG\u000f[\"mK\u0006tWM\u001d\u0015\u0004\u0003WY\u0006BBA\u001a\u0001\u0011\u0005a*A\u0013uKN$H)\u001a7fi\u0016$v\u000e]5d\u00032\u0014X-\u00193z\u001b\u0006\u00148.\u001a3Bg\u0012+G.\u001a;fI\"\u001a\u0011\u0011G.\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u0005I2M]3bi\u0016$Vm\u001d;U_BL7-\u00118e\u00072,8\u000f^3s)\u001d1\u0012QHA \u0003\u0013Ba!`A\u001c\u0001\u0004q\bBCA!\u0003o\u0001\n\u00111\u0001\u0002D\u0005\u0011B-\u001a7fi\u0016$v\u000e]5d\u000b:\f'\r\\3e!\rA\u0013QI\u0005\u0004\u0003\u000fR\"a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003\u0017\n9\u0004%AA\u0002\u00055\u0013!\u0005:fa2L7-Y!tg&<g.\\3oiB11/!\u00039\u0003\u001f\u0002R!!\u0015\u0002barA!a\u0015\u0002^9!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0007\u0005}#$A\u0004qC\u000e\\\u0017mZ3\n\u0007u\n\u0019GC\u0002\u0002`iAq!!\u000f\u0001\t\u0013\t9\u0007F\u0004\u0017\u0003S\nY'!!\t\ru\f)\u00071\u0001\u007f\u0011!\ti'!\u001aA\u0002\u0005=\u0014!\u00042s_.,'oQ8oM&<7\u000f\u0005\u0003\u00189\u0005E\u0004\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\u0005kRLGN\u0003\u0002\u0002|\u0005!!.\u0019<b\u0013\u0011\ty(!\u001e\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0005\u0002L\u0005\u0015\u0004\u0019AA'\u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\u000b\u0011b\u001e:ji\u0016$U\u000f]:\u0015\u0011\u0005%\u0015QRAI\u0003+\u0003Ba\u0006\u000f\u0002\fB!\u0001f\u001b\u001d9\u0011\u001d\ty)a!A\u0002a\nqA\\;n\u0017\u0016L8\u000fC\u0004\u0002\u0014\u0006\r\u0005\u0019\u0001\u001d\u0002\u000f9,X\u000eR;qg\"A\u0011qSAB\u0001\u0004\tI*A\u0002m_\u001e\u0004B!a'\u0002 6\u0011\u0011Q\u0014\u0006\u0004\u0003/#\u0011\u0002BAQ\u0003;\u00131\"\u00112tiJ\f7\r\u001e'pO\"1\u0011Q\u0015\u0001\u0005\u00029\u000ba\u0003^3ti\u0012K7/\u00192mK\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u0015\u0004\u0003G[\u0006BBAV\u0001\u0011\u0005a*A\u0011uKN$H)\u001a7fi&tw\rU1si&\fG\u000e\\=EK2,G/\u001a3U_BL7\rK\u0002\u0002*nC\u0011\"!-\u0001#\u0003%I!a-\u0002G\r\u0014X-\u0019;f)\u0016\u001cH\u000fV8qS\u000e\fe\u000eZ\"mkN$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0017\u0016\u0005\u0003\u0007\n9l\u000b\u0002\u0002:B!\u00111XAc\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017!C;oG\",7m[3e\u0015\r\t\u0019MG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAd\u0003{\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tY\rAI\u0001\n\u0013\ti-A\u0012de\u0016\fG/\u001a+fgR$v\u000e]5d\u0003:$7\t\\;ti\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005='\u0006BA'\u0003o\u0003")
public class DeleteTopicTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> expectedReplicaFullAssignment = this.expectedReplicaAssignment().mapValues((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final ReplicaAssignment apply(List<Object> x$1) {
            return ReplicaAssignment$.MODULE$.apply(x$1, (Seq)Seq$.MODULE$.empty());
        }
    }).toMap(Predef$.MODULE$.$conforms());

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> expectedReplicaFullAssignment() {
        return this.expectedReplicaFullAssignment;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$1.get());
            }
            {
                this.leaderIdOpt$1 = leaderIdOpt$1;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, follower2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition topicPartition$1;
            public final KafkaServer follower$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((IterableLike)this.$outer.servers().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer s) {
                        return s.config().brokerId() != this.$outer.follower$1.config().brokerId();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer x$2) {
                        LogManager qual$1 = x$2.getLogManager();
                        TopicPartition x$18 = this.$outer.topicPartition$1;
                        boolean x$19 = qual$1.getLog$default$2();
                        return qual$1.getLog(x$18, x$19).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
                this.follower$1 = follower$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas 0,1 have not deleted log.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().isTopicMarkedForDeletion(this.topic$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Admin path /admin/delete_topics/test path deleted even when a follower replica is down";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return Assertions$.MODULE$.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            }
        }));
        KafkaServer controller = (KafkaServer)((IterableLike)this.servers().filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        })).head();
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, controllerId, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;
            private final Option leaderIdOpt$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$2.get()) && s.config().brokerId() != this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
                this.leaderIdOpt$2 = leaderIdOpt$2;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        controller.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().isTopicMarkedForDeletion(this.topic$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Admin path /admin/delete_topics/test path deleted even when a replica is down";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        controller.startup();
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        Seq allServers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final boolean apply(KafkaServer s) {
                return ((LinearSeqOptimized)this.$outer.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$2;
            private final Seq servers$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPartitionReassignmentDuringDeleteTopic$1 $outer;

                    public final boolean apply(KafkaServer x$3) {
                        LogManager qual$2 = x$3.getLogManager();
                        TopicPartition x$20 = this.$outer.topicPartition$2;
                        boolean x$21 = qual$2.getLog$default$2();
                        return qual$2.getLog(x$20, x$21).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$2 = topicPartition$2;
                this.servers$1 = servers$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$3;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$3.get());
            }
            {
                this.leaderIdOpt$3 = leaderIdOpt$3;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        Seq oldAssignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        KafkaZkClient x$22 = this.zkClient();
        None$ x$23 = None$.MODULE$;
        scala.collection.immutable.Map x$24 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)newReplicas)}));
        AdminZkClient x$25 = this.adminZkClient();
        Map x$26 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$22, (Option)x$23, (Map)x$24, x$26, x$25);
        Assert.assertTrue((String)"Partition reassignment should fail for [test,0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition topicPartition$2;
            private final Seq newReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Object object = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition$2), (Object)this.newReplicas$1)}))).getOrElse((Object)this.topicPartition$2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPartitionReassignmentDuringDeleteTopic$2 $outer;

                    public final Nothing$ apply() {
                        return Assertions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get reassignment status for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicPartition$2})), new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                return !(object != null ? !object.equals(reassignmentFailed$) : reassignmentFailed$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$2 = topicPartition$2;
                this.newReplicas$1 = newReplicas$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition reassignment shouldn't complete.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return Assertions$.MODULE$.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            }
        }));
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$2;
            }
            {
                this.controllerId$2 = controllerId$2;
            }
        })).head();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, controller){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$2;
            private final KafkaServer controller$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.controller$1.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)this.topicPartition$2);
            }
            {
                this.topicPartition$2 = topicPartition$2;
                this.controller$1 = controller$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition should be removed from partitionsBeingReassigned.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Assert.assertEquals((String)"Partition should not be reassigned to 0, 1, 2", (Object)oldAssignedReplicas, (Object)assignedReplicas);
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)servers);
    }

    public Tuple2<KafkaServer, Object> kafka$admin$DeleteTopicTest$$getController() {
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return Assertions$.MODULE$.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            }
        }));
        KafkaServer controller = (KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$3;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$3;
            }
            {
                this.controllerId$3 = controllerId$3;
            }
        }).get();
        return new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
    }

    private void ensureControllerExists() {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                try {
                    this.$outer.kafka$admin$DeleteTopicTest$$getController();
                    bl = true;
                }
                catch (Throwable throwable) {
                    bl = false;
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Controller should eventually exist";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private scala.collection.immutable.Set<PartitionAndReplica> getAllReplicasFromAssignment(String topic, scala.collection.immutable.Map<Object, Seq<Object>> assignment2) {
        return ((TraversableOnce)assignment2.flatMap((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            public final String topic$3;

            public final Seq<PartitionAndReplica> apply(Tuple2<Object, Seq<Object>> x0$1) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int partition = tuple2._1$mcI$sp();
                    Seq replicas = (Seq)tuple2._2();
                    Seq seq = (Seq)replicas.map((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$getAllReplicasFromAssignment$1 $outer;
                        private final int partition$1;

                        public final PartitionAndReplica apply(int r) {
                            return new PartitionAndReplica(new TopicPartition(this.$outer.topic$3, this.partition$1), r);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$1 = partition$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return seq;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topic$3 = topic$3;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Test
    public void testIncreasePartitionCountDuringDeleteTopic() {
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        Seq allServers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final boolean apply(KafkaServer s) {
                return ((LinearSeqOptimized)this.$outer.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$3;
            private final Seq servers$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$2.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testIncreasePartitionCountDuringDeleteTopic$1 $outer;

                    public final boolean apply(KafkaServer x$4) {
                        LogManager qual$3 = x$4.getLogManager();
                        TopicPartition x$27 = this.$outer.topicPartition$3;
                        boolean x$28 = qual$3.getLog$default$2();
                        return qual$3.getLog(x$27, x$28).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$3 = topicPartition$3;
                this.servers$2 = servers$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(topicPartition);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$4;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$4.get());
            }
            {
                this.leaderIdOpt$4 = leaderIdOpt$4;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        this.ensureControllerExists();
        Tuple2<KafkaServer, Object> tuple2 = this.kafka$admin$DeleteTopicTest$$getController();
        if (tuple2 != null) {
            Tuple2 tuple22;
            KafkaServer controller = (KafkaServer)tuple2._1();
            int controllerId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
            KafkaServer controller2 = (KafkaServer)tuple23._1();
            int controllerId2 = tuple23._2$mcI$sp();
            scala.collection.immutable.Set<PartitionAndReplica> allReplicasForTopic = this.getAllReplicasFromAssignment(topic, this.expectedReplicaAssignment());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, controller2, allReplicasForTopic){
                public static final long serialVersionUID = 0L;
                private final String topic$4;
                private final KafkaServer controller$2;
                private final scala.collection.immutable.Set allReplicasForTopic$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    Set replicasInDeletionSuccessful = this.controller$2.kafkaController().controllerContext().replicasInState(this.topic$4, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
                    Set offlineReplicas = this.controller$2.kafkaController().controllerContext().replicasInState(this.topic$4, (ReplicaState)OfflineReplica$.MODULE$);
                    scala.collection.immutable.Set set = this.allReplicasForTopic$1;
                    Set set2 = replicasInDeletionSuccessful.union((GenSet)offlineReplicas);
                    return !(set != null ? !set.equals(set2) : set2 != null);
                }
                {
                    this.topic$4 = topic$4;
                    this.controller$2 = controller$2;
                    this.allReplicasForTopic$1 = allReplicasForTopic$1;
                }
            }, (Function0<String>)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final String topic$4;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not all replicas for topic ", " are in states of either ReplicaDeletionSuccessful or OfflineReplica"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                }
                {
                    this.topic$4 = topic$4;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            TopicCommand.TopicCommandOptions topicCommandOptions = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--alter", "--topic", topic, "--partitions", "2"}));
            new TopicCommand.ZookeeperTopicService(this.zkClient()).alterTopic(topicCommandOptions);
            int previousControllerId = controllerId2;
            controller2.shutdown();
            this.ensureControllerExists();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, previousControllerId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicTest $outer;
                private final int previousControllerId$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    Tuple2<KafkaServer, Object> tuple2 = this.$outer.kafka$admin$DeleteTopicTest$$getController();
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        KafkaServer newController = (KafkaServer)tuple2._1();
                        int newControllerId = tuple2._2$mcI$sp();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)newController, (Object)BoxesRunTime.boxToInteger((int)newControllerId));
                        KafkaServer newController2 = (KafkaServer)tuple23._1();
                        int newControllerId2 = tuple23._2$mcI$sp();
                        return newControllerId2 != this.previousControllerId$1;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.previousControllerId$1 = previousControllerId$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The new controller should not have the failed controller id";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            follower2.startup();
            controller2.startup();
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, (Seq<KafkaServer>)servers);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$5;

            public final boolean apply(KafkaServer x$7) {
                return x$7.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$5.get());
            }
            {
                this.leaderIdOpt$5 = leaderIdOpt$5;
            }
        })).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$4 = this.adminZkClient();
        RackAwareMode x$29 = qual$4.getBrokerMetadatas$default$1();
        Option x$30 = qual$4.getBrokerMetadatas$default$2();
        Seq brokers = qual$4.getBrokerMetadatas(x$29, x$30);
        follower2.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final KafkaServer follower$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getBroker(this.follower$2.config().brokerId()).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.follower$2 = follower$2;
            }
        }, (Function0<String>)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final KafkaServer follower$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower ", " was not removed from ZK"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.follower$2.config().brokerId())}));
            }
            {
                this.follower$2 = follower$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        AdminZkClient qual$5 = this.adminZkClient();
        String x$31 = topic;
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$32 = this.expectedReplicaFullAssignment();
        Seq x$33 = brokers;
        int x$34 = 2;
        Some x$35 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty()))})));
        None$ x$36 = None$.MODULE$;
        boolean x$37 = qual$5.addPartitions$default$6();
        qual$5.addPartitions(x$31, x$32, x$33, x$34, (Option)x$35, x$37, (Option)x$36);
        this.adminZkClient().deleteTopic(topic);
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition newPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteTopicDuringAddPartition$2 $outer;

                    public final boolean apply(KafkaServer x$8) {
                        LogManager qual$6 = x$8.getLogManager();
                        TopicPartition x$38 = this.$outer.newPartition$1;
                        boolean x$39 = qual$6.getLog$default$2();
                        return qual$6.getLog(x$38, x$39).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newPartition$1 = newPartition$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replica logs not for new partition [test,1] not deleted after delete topic is complete.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        this.zkClient().createTopLevelPaths();
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        AdminZkClient qual$7 = this.adminZkClient();
        RackAwareMode x$40 = qual$7.getBrokerMetadatas$default$1();
        Option x$41 = qual$7.getBrokerMetadatas$default$2();
        Seq brokers = qual$7.getBrokerMetadatas(x$40, x$41);
        this.adminZkClient().deleteTopic(topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$8 = this.adminZkClient();
        String x$42 = topic;
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$43 = this.expectedReplicaFullAssignment();
        Seq x$44 = brokers;
        int x$45 = 2;
        Some x$46 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty()))})));
        None$ x$47 = None$.MODULE$;
        boolean x$48 = qual$8.addPartitions$default$6();
        qual$8.addPartitions(x$42, x$43, x$44, x$45, (Option)x$46, x$48, (Option)x$47);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)this.servers().forall((Function1)new Serializable(this, newPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition newPartition$2;

            public final boolean apply(KafkaServer x$9) {
                LogManager qual$9 = x$9.getLogManager();
                TopicPartition x$49 = this.newPartition$2;
                boolean x$50 = qual$9.getLog$default$2();
                return qual$9.getLog(x$49, x$50).isEmpty();
            }
            {
                this.newPartition$2 = newPartition$2;
            }
        }));
    }

    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition topicPartition$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecreateTopicAfterDeletion$1 $outer;

                    public final boolean apply(KafkaServer x$10) {
                        LogManager qual$10 = x$10.getLogManager();
                        TopicPartition x$51 = this.$outer.topicPartition$4;
                        boolean x$52 = qual$10.getLog$default$2();
                        return qual$10.getLog(x$51, x$52).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$4 = topicPartition$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic("test2");
            throw Assertions$.MODULE$.fail("Expected UnknownTopicOrPartitionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test2", 1, this.servers());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicTest $outer;
                public final TopicPartition topicPartition$5;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.servers().forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDeleteNonExistingTopic$1 $outer;

                        public final boolean apply(KafkaServer x$11) {
                            LogManager qual$11 = x$11.getLogManager();
                            TopicPartition x$53 = this.$outer.topicPartition$5;
                            boolean x$54 = qual$11.getLog$default$2();
                            return qual$11.getLog(x$53, x$54).isDefined();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicPartition$5 = topicPartition$5;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Replicas for topic test not created";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)this.zkClient().topicExists(topic));
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            return;
        }
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.servers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs, this.expectedReplicaAssignment()));
        KafkaServer server = (KafkaServer)this.servers().head();
        LogManager qual$12 = server.logManager();
        TopicPartition x$55 = topicPartition;
        boolean x$56 = qual$12.getLog$default$2();
        AbstractLog log2 = (AbstractLog)qual$12.getLog(x$55, x$56).get();
        this.writeDups(100, 3, log2);
        LogCleaner qual$13 = server.logManager().cleaner();
        TopicPartition x$57 = new TopicPartition(topicName, 0);
        long x$58 = 0L;
        long x$59 = qual$13.awaitCleaned$default$3();
        qual$13.awaitCleaned(x$57, x$58, x$59);
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test", 1, this.servers());
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic(topic);
            this.adminZkClient().deleteTopic(topic);
            throw Assertions$.MODULE$.fail("Expected TopicAlreadyMarkedForDeletionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        }
        catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
            return;
        }
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        brokerConfigs.foreach((Function1)new Serializable(this, deleteTopicEnabled){
            public static final long serialVersionUID = 0L;
            private final boolean deleteTopicEnabled$1;

            public final Object apply(Properties x$12) {
                return x$12.setProperty("delete.topic.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)this.deleteTopicEnabled$1)).toString());
            }
            {
                this.deleteTopicEnabled$1 = deleteTopicEnabled$1;
            }
        });
        return this.createTestTopicAndCluster(topic, brokerConfigs, replicaAssignment);
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$6;
            private final Seq servers$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$3.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createTestTopicAndCluster$1 $outer;

                    public final boolean apply(KafkaServer x$13) {
                        LogManager qual$14 = x$13.getLogManager();
                        TopicPartition x$60 = this.$outer.topicPartition$6;
                        boolean x$61 = qual$14.getLog$default$2();
                        return qual$14.getLog(x$60, x$61).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$6 = topicPartition$6;
                this.servers$3 = servers$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private scala.collection.immutable.Map<Object, List<Object>> createTestTopicAndCluster$default$3() {
        return this.expectedReplicaAssignment();
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, AbstractLog log2) {
        IntRef counter = IntRef.create((int)0);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log2, counter){
            public static final long serialVersionUID = 0L;
            private final int numKeys$1;
            public final AbstractLog log$1;
            public final IntRef counter$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.counter$1.elem;
                        this.$outer.log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)this.$outer.counter$1.elem)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.$outer.log$1.appendAsLeader$default$3(), this.$outer.log$1.appendAsLeader$default$4());
                        ++this.$outer.counter$1.elem;
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.counter$1 = counter$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, false, this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().isTopicMarkedForDeletion(this.topic$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$5 = topic$5;
            }
        }, (Function0<String>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$5;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topics/%s path not deleted even if deleteTopic is disabled")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$5}));
            }
            {
                this.topic$5 = topic$5;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((boolean)this.servers().forall((Function1)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$7;

            public final boolean apply(KafkaServer x$14) {
                LogManager qual$15 = x$14.getLogManager();
                TopicPartition x$62 = this.topicPartition$7;
                boolean x$63 = qual$15.getLog$default$2();
                return qual$15.getLog(x$62, x$63).isDefined();
            }
            {
                this.topicPartition$7 = topicPartition$7;
            }
        }));
        Assert.assertTrue((String)"Topic path disappeared", (boolean)this.zkClient().topicExists(topic));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
    }

    @Test
    public void testDeletingPartiallyDeletedTopic() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, (scala.collection.immutable.Map<Object, List<Object>>)replicaAssignment));
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$15) {
                x$15.shutdown();
            }
        });
        KafkaZkClient qual$16 = this.zkClient();
        String x$64 = TopicPartitionZNode$.MODULE$.path(new TopicPartition(topic, 0));
        int x$65 = qual$16.deleteRecursive$default$2();
        qual$16.deleteRecursive(x$64, x$65);
        this.adminZkClient().deleteTopic(topic);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$16) {
                x$16.startup();
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(KafkaServer x$17) {
                        return x$17.kafkaController().isActive();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "No controller is elected";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, this.servers());
    }
}

