/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Collection;
import kafka.admin.TopicCommand;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001\u001d\u0011Qe\u00142tKJ4XM]!xCJ,\u0007+\u0019:uSRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0006i>\u0004\u0018nY\u000b\u0002-A\u0011q\u0003H\u0007\u00021)\u0011\u0011DG\u0001\u0005Y\u0006twMC\u0001\u001c\u0003\u0011Q\u0017M^1\n\u0005uA\"AB*ue&tw\r\u0003\u0004 \u0001\u0001\u0006IAF\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f\u0005\u0002!\u0019!C\u0005E\u0005)an\u001c3fgV\t1\u0005\u0005\u0003%S-rS\"A\u0013\u000b\u0005\u0019:\u0013!C5n[V$\u0018M\u00197f\u0015\tA#\"\u0001\u0006d_2dWm\u0019;j_:L!AK\u0013\u0003\u00075\u000b\u0007\u000f\u0005\u0002\nY%\u0011QF\u0003\u0002\u0004\u0013:$\bCA\u00188\u001b\u0005\u0001$BA\u00193\u0003\u0019\u0019w.\\7p]*\u0011Qa\r\u0006\u0003iU\na!\u00199bG\",'\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029a\t!aj\u001c3f\u0011\u0019Q\u0004\u0001)A\u0005G\u00051an\u001c3fg\u0002BQ\u0001\u0010\u0001\u0005\nu\nQ\u0002]1si&$\u0018n\u001c8J]\u001a|G\u0003\u0002 B\r>\u0003\"aL \n\u0005\u0001\u0003$A\u0005+pa&\u001c\u0007+\u0019:uSRLwN\\%oM>DQAQ\u001eA\u0002\r\u000ba\u0001\\3bI\u0016\u0014\bcA\u0005EW%\u0011QI\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b\u001d[\u0004\u0019\u0001%\u0002\u0007%\u001c(\u000fE\u0002J\u0019.r!!\u0003&\n\u0005-S\u0011A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n\u00191+\u001a;\u000b\u0005-S\u0001\"\u0002)<\u0001\u0004\t\u0016!C8cg\u0016\u0014h/\u001a:t!\r\u0011&l\u000b\b\u0003'bs!\u0001V,\u000e\u0003US!A\u0016\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA-\u000b\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0017/\u0003\t1K7\u000f\u001e\u0006\u00033*AQA\u0018\u0001\u0005\n}\u000b1cY8oM&<w+\u001b;i!2\f7-Z7f]R$\"\u0001Y4\u0011\u0005\u0005,W\"\u00012\u000b\u0005\r\u0019'B\u000133\u0003\u001d\u0019G.[3oiNL!A\u001a2\u0003\r\r{gNZ5h\u0011\u0015AW\f1\u0001j\u0003%\u0001H.Y2f[\u0016tG\u000f\u0005\u0002JU&\u0011QD\u0014\u0005\u0006Y\u0002!\t!\\\u00012i\u0016\u001cHOT8PEN,'O^3sg&3\u0007\u000b\\1dK6,g\u000e^\"p]N$(/Y5oi:{GoQ8oM&<WO]3e)\u0005q\u0007CA\u0005p\u0013\t\u0001(B\u0001\u0003V]&$\bFA6s!\t\u0019h/D\u0001u\u0015\t)X'A\u0003kk:LG/\u0003\u0002xi\n!A+Z:u\u0011\u0015I\b\u0001\"\u0001n\u0003)\"Xm\u001d;O_>\u00137/\u001a:wKJ\u001c\u0018J\u001a)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$\u0018j\u001d(vY2D#\u0001\u001f:\t\u000bq\u0004A\u0011A7\u0002aQ,7\u000f^(cg\u0016\u0014h/\u001a:t/&$\bn\u00148msJ+\u0007\u000f\\5dC\u000e{gn\u001d;sC&tGoQ8oM&<WO]3eQ\tY(\u000fC\u0003\u0000\u0001\u0011\u0005Q.A\u0014uKN$xJY:feZ,'o]'bi\u000eD\u0017N\\4PEN,'O^3s\u0007>t7\u000f\u001e:bS:$\bF\u0001@s\u0011\u0019\t)\u0001\u0001C\u0001[\u0006YC/Z:u\u001f\n\u001cXM\u001d<feN\u001c\u0015M\\(oYfl\u0015\r^2i\u001f\n\u001cXM\u001d<fe\u000e{gn\u001d;sC&tG\u000fK\u0002\u0002\u0004IDa!a\u0003\u0001\t\u0003i\u0017A\b;fgRL5O\u001d*fa2L7-Y:Be\u0016tu\u000e^(cg\u0016\u0014h/\u001a:tQ\r\tIA\u001d\u0005\u0007\u0003#\u0001A\u0011A7\u0002EQ,7\u000f^(gM2Lg.\u001a*fa2L7-Y:Be\u0016tu\u000e^(cg\u0016\u0014h/\u001a:tQ\r\tyA\u001d\u0005\u0007\u0003/\u0001A\u0011A7\u0002\u0001R,7\u000f^%t+:$WM\u001d*fa2L7-\u0019;fI^CWM\u001c*fa2L7-Y\"p]N$(/Y5oi6\u000bGo\u00195j]\u001e\u0014%o\\6fe:{G/\u00138JgJD3!!\u0006s\u0011\u0019\ti\u0002\u0001C\u0001[\u0006YD/Z:u\u001d>d\u0015N^3PEN,'O^3sg&37)\u001e:sK:$H*Z1eKJl\u0015\r^2iKN|%m]3sm\u0016\u00148i\u001c8tiJ\f\u0017N\u001c;)\u0007\u0005m!\u000f")
public class ObserverAwarePartitionDescriptionTest {
    private final String topic;
    private final Map<Object, Node> nodes = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new Node(0, "localhost", 9092, "r1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Node(1, "localhost", 9093, "r1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new Node(2, "localhost", 9094, "r2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new Node(3, "localhost", 9095, "r2"))}));

    private String topic() {
        return this.topic;
    }

    private Map<Object, Node> nodes() {
        return this.nodes;
    }

    private TopicPartitionInfo partitionInfo(Option<Object> leader2, scala.collection.immutable.Set<Object> isr, List<Object> observers) {
        return TopicPartitionInfo.ofReplicasAndObservers((int)0, (Node)((Node)leader2.map(this.nodes()).orNull(Predef$.MODULE$.$conforms())), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.nodes().values().toList()).asJava()), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.nodes().filterKeys((Function1)new Serializable(this, observers){
            public static final long serialVersionUID = 0L;
            private final List observers$1;

            public final boolean apply(Object elem) {
                return this.observers$1.contains(elem);
            }
            {
                this.observers$1 = observers$1;
            }
        }).values().toList()).asJava()), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.nodes().filterKeys((Function1)new Serializable(this, isr){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set isr$1;

            public final boolean apply(int elem) {
                return this.apply$mcZI$sp(elem);
            }

            public boolean apply$mcZI$sp(int elem) {
                return this.isr$1.contains((Object)BoxesRunTime.boxToInteger((int)elem));
            }
            {
                this.isr$1 = isr$1;
            }
        }).values().toList()).asJava()));
    }

    private Config configWithPlacement(String placement) {
        return new Config((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("confluent.placement.constraints", placement)}))).asJava());
    }

    @Test
    public void testNoObserversIfPlacementConstraintNotConfigured() {
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)List$.MODULE$.empty());
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        Some config = new Some((Object)new Config((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava()));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)config, false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)desc.observerIds());
        Assert.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testNoObserversIfPlacementConstraintIsNull() {
        Config config = this.configWithPlacement(null);
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)List$.MODULE$.empty());
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)desc.observerIds());
        Assert.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testObserversWithOnlyReplicaConstraintConfigured() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)List$.MODULE$.empty());
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)desc.observerIds());
        Assert.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testObserversMatchingObserverConstraint() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r2\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        List observers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)observers);
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assert.assertEquals((Object)observers, (Object)desc.observerIds());
        Assert.assertFalse((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testObserversCanOnlyMatchObserverConstraint() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r3\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)List$.MODULE$.empty());
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assert.assertTrue((boolean)desc.observerIds().isEmpty());
        Assert.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testIsrReplicasAreNotObservers() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r2\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        List observers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)observers);
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assert.assertEquals((Object)observers, (Object)desc.observerIds());
        Assert.assertFalse((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testOfflineReplicasAreNotObservers() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r2\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        List observers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)observers);
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assert.assertEquals((Object)observers, (Object)desc.observerIds());
        Assert.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testIsUnderReplicatedWhenReplicaConstraintMatchingBrokerNotInIsr() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r2\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        List observers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)observers);
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assert.assertEquals((Object)observers, (Object)desc.observerIds());
        Assert.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testNoLiveObserversIfCurrentLeaderMatchesObserverConstraint() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r2\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)List$.MODULE$.empty());
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assert.assertTrue((boolean)desc.observerIds().isEmpty());
        Assert.assertTrue((boolean)desc.isUnderReplicated());
    }

    public ObserverAwarePartitionDescriptionTest() {
        this.topic = "foo";
    }
}

