/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.admin.ResetConsumerGroupOffsetTest$;
import kafka.admin.ResetConsumerGroupOffsetTest$$anonfun$resetAndAssertOffsets$1$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0001\u0003\u0001\u001d\u0011ADU3tKR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005a\u0019uN\\:v[\u0016\u0014xI]8va\u000e{W.\\1oIR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000fE\u0001!\u0019!C\u0001%\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0003vi&d'\"\u0001\r\u0002\t)\fg/Y\u0005\u00035U\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019a\u0002\u0001)A\u0005'\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003\u0019!x\u000e]5dcU\t\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$/\u0005!A.\u00198h\u0013\t)#E\u0001\u0004TiJLgn\u001a\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u000fQ|\u0007/[22A!9\u0011\u0006\u0001b\u0001\n\u0003y\u0012A\u0002;pa&\u001c'\u0007\u0003\u0004,\u0001\u0001\u0006I\u0001I\u0001\bi>\u0004\u0018n\u0019\u001a!\u0011\u0015i\u0003\u0001\"\u0011/\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A\u0018\u0011\u0007A*t'D\u00012\u0015\t\u00114'\u0001\u0006d_2dWm\u0019;j_:T\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mE\u00121aU3r!\tA4(D\u0001:\u0015\tQD!\u0001\u0004tKJ4XM]\u0005\u0003ye\u00121bS1gW\u0006\u001cuN\u001c4jO\")a\b\u0001C\u0005\u007f\u0005I!-Y:jG\u0006\u0013xm]\u000b\u0002\u0001B\u0019\u0011I\u0011#\u000e\u0003MJ!aQ\u001a\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0015CeBA!G\u0013\t95'\u0001\u0004Qe\u0016$WMZ\u0005\u0003K%S!aR\u001a\t\u000b-\u0003A\u0011\u0002'\u0002%\t,\u0018\u000e\u001c3Be\u001e\u001chi\u001c:He>,\bo\u001d\u000b\u0004\u00016\u0003\u0006\"\u0002(K\u0001\u0004y\u0015AB4s_V\u00048\u000fE\u00021k\u0011CQ!\u0015&A\u0002I\u000bA!\u0019:hgB\u0019\u0011i\u0015#\n\u0005Q\u001b$A\u0003\u001fsKB,\u0017\r^3e}!)a\u000b\u0001C\u0005/\u0006\t\"-^5mI\u0006\u0013xm\u001d$pe\u001e\u0013x.\u001e9\u0015\u0007\u0001C&\fC\u0003Z+\u0002\u0007A)A\u0003he>,\b\u000fC\u0003R+\u0002\u0007!\u000bC\u0003]\u0001\u0011%Q,A\u000bck&dG-\u0011:hg\u001a{'/\u00117m\u000fJ|W\u000f]:\u0015\u0005\u0001s\u0006\"B)\\\u0001\u0004\u0011\u0006\"\u00021\u0001\t\u0003\t\u0017\u0001\t;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u001d>$X\t_5ti&twm\u0012:pkB$\u0012A\u0019\t\u0003\u0003\u000eL!\u0001Z\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0003?\u001a\u0004\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\u000b),h.\u001b;\u000b\u0003-\f1a\u001c:h\u0013\ti\u0007N\u0001\u0003UKN$\b\"B8\u0001\t\u0003\t\u0017!\b;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u000bbL7\u000f^5oOR{\u0007/[2)\u000594\u0007\"\u0002:\u0001\t\u0003\t\u0017a\u000b;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u000bbL7\u000f^5oOR{\u0007/[2TK2,7\r^3e\u000fJ|W\u000f]:)\u0005E4\u0007\"B;\u0001\t\u0003\t\u0017A\n;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u000bbL7\u000f^5oOR{\u0007/[2BY2<%o\\;qg\"\u0012AO\u001a\u0005\u0006q\u0002!\t!Y\u0001#i\u0016\u001cHOU3tKR|eMZ:fiN\fE\u000e\u001c+pa&\u001c7/\u00117m\u000fJ|W\u000f]:)\u0005]4\u0007\"B>\u0001\t\u0003\t\u0017a\b;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>dunY1m\t\u0006$X\rV5nK\"\u0012!P\u001a\u0005\u0006}\u0002!\t!Y\u0001 i\u0016\u001cHOU3tKR|eMZ:fiN$vNW8oK\u0012$\u0015\r^3US6,\u0007FA?g\u0011\u0019\t\u0019\u0001\u0001C\u0001C\u0006QB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d\"z\tV\u0014\u0018\r^5p]\"\u001a\u0011\u0011\u00014\t\r\u0005%\u0001\u0001\"\u0001b\u0003\u0011\"Xm\u001d;SKN,Go\u00144gg\u0016$8OQ=EkJ\fG/[8o)>,\u0015M\u001d7jKN$\bfAA\u0004M\"1\u0011q\u0002\u0001\u0005\u0002\u0005\f!\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_\u0016\u000b'\u000f\\5fgRD3!!\u0004g\u0011\u0019\t)\u0002\u0001C\u0001C\u0006AB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u0019\u0006$Xm\u001d;)\u0007\u0005Ma\r\u0003\u0004\u0002\u001c\u0001!\t!Y\u0001 i\u0016\u001cHOU3tKR|eMZ:fiN$vnQ;se\u0016tGo\u00144gg\u0016$\bfAA\rM\"1\u0011\u0011\u0005\u0001\u0005\u0002\u0005\f\u0001\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_N\u0003XmY5gS\u000e|eMZ:fi\"\u001a\u0011q\u00044\t\r\u0005\u001d\u0002\u0001\"\u0001b\u0003e!Xm\u001d;SKN,Go\u00144gg\u0016$8o\u00155jMR\u0004F.^:)\u0007\u0005\u0015b\r\u0003\u0004\u0002.\u0001!\t!Y\u0001\u001bi\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u\u001b&tWo\u001d\u0015\u0004\u0003W1\u0007BBA\u001a\u0001\u0011\u0005\u0011-\u0001\u0015uKN$(+Z:fi>3gm]3ugNC\u0017N\u001a;Cs2{w/\u001a:UQ\u0006tW)\u0019:mS\u0016\u001cH\u000fK\u0002\u00022\u0019Da!!\u000f\u0001\t\u0003\t\u0017a\n;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t'\"Lg\r\u001e\"z\u0011&<\u0007.\u001a:UQ\u0006tG*\u0019;fgRD3!a\u000eg\u0011\u0019\ty\u0004\u0001C\u0001C\u0006!C/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u000b\u0006\u0014H.[3ti>swJ\\3U_BL7\rK\u0002\u0002>\u0019Da!!\u0012\u0001\t\u0003\t\u0017\u0001\r;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>,\u0015M\u001d7jKN$xJ\\(oKR{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eK\u0002\u0002D\u0019Da!a\u0013\u0001\t\u0003\t\u0017A\t;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>,\u0015M\u001d7jKN$xJ\u001c+pa&\u001c7\u000fK\u0002\u0002J\u0019Da!!\u0015\u0001\t\u0003\t\u0017a\f;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>,\u0015M\u001d7jKN$xJ\u001c+pa&\u001c7/\u00118e!\u0006\u0014H/\u001b;j_:\u001c\bfAA(M\"1\u0011q\u000b\u0001\u0005\u0002\u0005\fa\u0006^3tiJ+7/\u001a;PM\u001a\u001cX\r^:FqB|'\u000f^%na>\u0014H\u000f\u00157b]NKgn\u001a7f\u000fJ|W\u000f]!sO\"\u001a\u0011Q\u000b4\t\r\u0005u\u0003\u0001\"\u0001b\u0003\u0001\"Xm\u001d;SKN,Go\u00144gg\u0016$8/\u0012=q_J$\u0018*\u001c9peR\u0004F.\u00198)\u0007\u0005mc\r\u0003\u0004\u0002d\u0001!\t!Y\u0001+i\u0016\u001cHOU3tKR<\u0016\u000e\u001e5V]J,7m\\4oSj,GMT3x\u0007>t7/^7fe>\u0003H/[8oQ\u001d\t\tGZA4\u0003S\n\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0003W\u0002B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0003\u0003c\n!B[8qiNLW\u000e\u001d7f\u0013\u0011\t)(a\u001c\u0003\u001f=\u0003H/[8o\u000bb\u001cW\r\u001d;j_:Dq!!\u001f\u0001\t\u0013\tY(A\bqe>$WoY3NKN\u001c\u0018mZ3t)\u0015\u0011\u0017QPAA\u0011\u001d\ty(a\u001eA\u0002\u0011\u000bQ\u0001^8qS\u000eD\u0001\"a!\u0002x\u0001\u0007\u0011QQ\u0001\f]VlW*Z:tC\u001e,7\u000fE\u0002B\u0003\u000fK1!!#4\u0005\rIe\u000e\u001e\u0005\b\u0003\u001b\u0003A\u0011BAH\u0003e\u0001(o\u001c3vG\u0016\u001cuN\\:v[\u0016\fe\u000eZ*ikR$wn\u001e8\u0015\u0013\t\f\t*a%\u0002\u0016\u0006e\u0005bBA@\u0003\u0017\u0003\r\u0001\u0012\u0005\u00073\u0006-\u0005\u0019\u0001#\t\u0011\u0005]\u00151\u0012a\u0001\u0003\u000b\u000bQ\u0002^8uC2lUm]:bO\u0016\u001c\bBCAN\u0003\u0017\u0003\n\u00111\u0001\u0002\u0006\u0006aa.^7D_:\u001cX/\\3sg\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0016!F1xC&$8i\u001c8tk6,'\u000f\u0015:pOJ,7o\u001d\u000b\bE\u0006\r\u0016QUAT\u0011%\ty(!(\u0011\u0002\u0003\u0007A\t\u0003\u0005Z\u0003;\u0003\n\u00111\u0001E\u0011!\tI+!(A\u0002\u0005-\u0016!B2pk:$\bcA!\u0002.&\u0019\u0011qV\u001a\u0003\t1{gn\u001a\u0005\b\u0003g\u0003A\u0011BA[\u0003U\u0011Xm]3u\u0003:$\u0017i]:feR|eMZ:fiN$\u0012BYA\\\u0003s\u000bi,a2\t\rE\u000b\t\f1\u0001A\u0011!\tY,!-A\u0002\u0005-\u0016AD3ya\u0016\u001cG/\u001a3PM\u001a\u001cX\r\u001e\u0005\u000b\u0003\u007f\u000b\t\f%AA\u0002\u0005\u0005\u0017A\u00023ssJ+h\u000eE\u0002B\u0003\u0007L1!!24\u0005\u001d\u0011un\u001c7fC:D\u0011\"!3\u00022B\u0005\t\u0019A(\u0002\rQ|\u0007/[2t\u0011\u001d\ti\r\u0001C\u0005\u0003\u001f\faD]3tKR\fe\u000eZ!tg\u0016\u0014Ho\u00144gg\u0016$8oQ8n[&$H/\u001a3\u0015\u000f\t\f\t.!=\u0003\u000e!A\u00111[Af\u0001\u0004\t).\u0001\u000bd_:\u001cX/\\3s\u000fJ|W\u000f]*feZL7-\u001a\t\u0005\u0003/\fYO\u0004\u0003\u0002Z\u0006\u001dh\u0002BAn\u0003KtA!!8\u0002d6\u0011\u0011q\u001c\u0006\u0004\u0003C4\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\t\u0019A!C\u0002\u0002j\n\tAcQ8ogVlWM]$s_V\u00048i\\7nC:$\u0017\u0002BAw\u0003_\u0014AcQ8ogVlWM]$s_V\u00048+\u001a:wS\u000e,'bAAu\u0005!A\u00111_Af\u0001\u0004\t)0A\bfqB,7\r^3e\u001f\u001a47/\u001a;t!\u001d)\u0015q_A~\u0003WK1!!?J\u0005\ri\u0015\r\u001d\t\u0005\u0003{\u0014I!\u0004\u0002\u0002\u0000*!!\u0011\u0001B\u0002\u0003\u0019\u0019w.\\7p]*\u0019QA!\u0002\u000b\u0007\t\u001d!.\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0005\u0017\tyP\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005}\u00141\u001aa\u0001\t\"9!\u0011\u0003\u0001\u0005\n\tM\u0011\u0001\u0004:fg\u0016$xJ\u001a4tKR\u001cH\u0003\u0002B\u000b\u0005W\u0001b\u0001\rB\f\t\ne\u0011bAA}cA9\u0001Ga\u0006\u0002|\nm\u0001\u0003\u0002B\u000f\u0005Oi!Aa\b\u000b\t\t\u0005\"1E\u0001\tG>t7/^7fe*!!Q\u0005B\u0002\u0003\u001d\u0019G.[3oiNLAA!\u000b\u0003 \t\trJ\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\t\u0011\u0005M'q\u0002a\u0001\u0003+D\u0011Ba\f\u0001#\u0003%IA!\r\u0002?I,7/\u001a;B]\u0012\f5o]3si>3gm]3ug\u0012\"WMZ1vYR$3'\u0006\u0002\u00034)\"\u0011\u0011\u0019B\u001bW\t\u00119\u0004\u0005\u0003\u0003:\t\rSB\u0001B\u001e\u0015\u0011\u0011iDa\u0010\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B!g\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015#1\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B%\u0001E\u0005I\u0011\u0002B&\u0003}\u0011Xm]3u\u0003:$\u0017i]:feR|eMZ:fiN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u001bR3a\u0014B\u001b\u0011%\u0011\t\u0006AI\u0001\n\u0013\u0011\u0019&A\u0010bo\u0006LGoQ8ogVlWM\u001d)s_\u001e\u0014Xm]:%I\u00164\u0017-\u001e7uIE*\"A!\u0016+\u0007\u0011\u0013)\u0004C\u0005\u0003Z\u0001\t\n\u0011\"\u0003\u0003T\u0005y\u0012m^1ji\u000e{gn];nKJ\u0004&o\\4sKN\u001cH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\tu\u0003!%A\u0005\n\t}\u0013a\t9s_\u0012,8-Z\"p]N,X.Z!oINCW\u000f\u001e3po:$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005CRC!!\"\u00036\u0001")
public class ResetConsumerGroupOffsetTest
extends ConsumerGroupCommandTest {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private String[] basicArgs() {
        return (String[])((Object[])new String[]{"--reset-offsets", "--bootstrap-server", this.brokerList(), "--timeout", ((Object)BoxesRunTime.boxToLong((long)15000L)).toString()});
    }

    private String[] buildArgsForGroups(Seq<String> groups, Seq<String> args) {
        String[] groupArgs = (String[])((TraversableOnce)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String group) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--group", group}));
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.basicArgs()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])groupArgs), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus(args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    private String[] buildArgsForGroup(String group, Seq<String> args) {
        return this.buildArgsForGroups((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{group}))), args);
    }

    private String[] buildArgsForAllGroups(Seq<String> args) {
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.basicArgs()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--all-groups"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus(args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    @Test
    public void testResetOffsetsNotExistingGroup() {
        String group = "missing.group";
        String[] args = this.buildArgsForGroup(group, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-current", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, group, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final String group$1;
            private final ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.consumerGroupCommand$1.collectGroupState(this.group$1).coordinator().host();
                String string2 = "localhost";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.group$1 = group$1;
                this.consumerGroupCommand$1 = consumerGroupCommand$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't find a coordinator";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map resetOffsets = (Map)consumerGroupCommand.resetOffsets().apply((Object)group);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)resetOffsets);
        String x$20 = group;
        String x$21 = this.committedOffsets$default$1();
        Assert.assertEquals((Object)resetOffsets, this.committedOffsets(x$21, x$20));
    }

    @Test
    public void testResetOffsetsExistingTopic() {
        String group = "new.group";
        String[] args = this.buildArgsForGroup(group, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsExistingTopicSelectedGroups() {
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 100);
        IndexedSeq groups = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;

            /*
             * WARNING - void declaration
             */
            public final String apply(int id) {
                void var2_2;
                String group = new StringBuilder().append((Object)this.$outer.group()).append((Object)BoxesRunTime.boxToInteger((int)id)).toString();
                ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.$outer.addConsumerGroupExecutor(1, this.$outer.topic(), group, this.$outer.addConsumerGroupExecutor$default$4(), this.$outer.addConsumerGroupExecutor$default$5(), this.$outer.addConsumerGroupExecutor$default$6());
                long x$22 = 100L;
                String x$23 = group;
                String x$24 = this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress$default$1();
                this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress(x$24, x$23, x$22);
                executor.shutdown();
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        String[] args = this.buildArgsForGroups((Seq<String>)groups, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsExistingTopicAllGroups() {
        String[] args = this.buildArgsForAllGroups((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 100);
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;

            public final String apply(int x$2) {
                return new StringBuilder().append((Object)this.$outer.group()).append((Object)BoxesRunTime.boxToInteger((int)x$2)).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;

            public final void apply(String group) {
                ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.$outer.addConsumerGroupExecutor(1, this.$outer.topic(), group, this.$outer.addConsumerGroupExecutor$default$4(), this.$outer.addConsumerGroupExecutor$default$5(), this.$outer.addConsumerGroupExecutor$default$6());
                long x$25 = 100L;
                String x$26 = group;
                String x$27 = this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress$default$1();
                this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress(x$27, x$26, x$25);
                executor.shutdown();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsAllTopicsAllGroups() {
        String[] args = this.buildArgsForAllGroups((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "50"}));
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;

            public final String apply(int x$3) {
                return new StringBuilder().append((Object)this.$outer.topic()).append((Object)BoxesRunTime.boxToInteger((int)x$3)).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq groups = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;

            public final String apply(int x$4) {
                return new StringBuilder().append((Object)this.$outer.group()).append((Object)BoxesRunTime.boxToInteger((int)x$4)).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        topics.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;

            public final void apply(String topic) {
                this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(topic, 100);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        topics.foreach((Function1)new Serializable(this, groups){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;
            private final IndexedSeq groups$1;

            public final void apply(String topic) {
                this.groups$1.foreach((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResetOffsetsAllTopicsAllGroups$2 $outer;
                    private final String topic$4;

                    public final void apply(String group) {
                        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$anonfun$$$outer().addConsumerGroupExecutor(3, this.topic$4, group, this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$anonfun$$$outer().addConsumerGroupExecutor$default$4(), this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$anonfun$$$outer().addConsumerGroupExecutor$default$5(), this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$anonfun$$$outer().addConsumerGroupExecutor$default$6());
                        String x$28 = this.topic$4;
                        long x$29 = 100L;
                        String x$30 = group;
                        this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$anonfun$$$outer().kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress(x$28, x$30, x$29);
                        executor.shutdown();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topic$4 = topic$4;
                    }
                });
            }

            public /* synthetic */ ResetConsumerGroupOffsetTest kafka$admin$ResetConsumerGroupOffsetTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.groups$1 = groups$1;
            }
        });
        this.resetAndAssertOffsets(args, 50L, true, (Seq<String>)topics);
        this.resetAndAssertOffsets((String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, (Seq<String>)topics);
        String[] x$31 = (String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long x$32 = 50L;
        IndexedSeq x$33 = topics;
        boolean x$34 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$31, x$32, x$34, (Seq<String>)x$33);
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 100);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        long x$35 = 100L;
        String x$36 = this.kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress$default$1();
        String x$37 = this.awaitConsumerProgress$default$2();
        this.kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress(x$36, x$37, x$35);
        executor.shutdown();
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"}));
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 50);
        Date checkpoint = new Date();
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 50);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        long x$38 = 100L;
        String x$39 = this.kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress$default$1();
        String x$40 = this.awaitConsumerProgress$default$2();
        this.kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress(x$39, x$40, x$38);
        executor.shutdown();
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-datetime", format.format(checkpoint), "--execute"}));
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--by-duration", "PT1M", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--by-duration", "PT0.1S", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-earliest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-latest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-current", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "1", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 1L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "50", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 150L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "-50", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "-150", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "150", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-earliest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        String topic = "bar";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        scala.collection.immutable.Map<TopicPartition, Object> priorCommittedOffsets = this.committedOffsets(topic, this.committedOffsets$default$2());
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        scala.collection.immutable.Map expectedOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), priorCommittedOffsets.apply((Object)tp0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))}));
        this.resetAndAssertOffsetsCommitted(consumerGroupCommand, (scala.collection.immutable.Map<TopicPartition, Object>)expectedOffsets, topic);
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", topic1, "--topic", topic2, "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 1);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 1);
        TopicPartition tp1 = new TopicPartition(topic1, 0);
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        scala.collection.immutable.Map allResetOffsets = ((MapLike)this.resetOffsets(consumerGroupCommand).apply((Object)this.group())).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$5) {
                return x$5.offset();
            }
        }).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), (Object)allResetOffsets);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic1})), "--topic", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic2})), "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 2);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 2);
        scala.collection.immutable.Map<TopicPartition, Object> priorCommittedOffsets1 = this.committedOffsets(topic1, this.committedOffsets$default$2());
        scala.collection.immutable.Map<TopicPartition, Object> priorCommittedOffsets2 = this.committedOffsets(topic2, this.committedOffsets$default$2());
        TopicPartition tp1 = new TopicPartition(topic1, 1);
        TopicPartition tp2 = new TopicPartition(topic2, 1);
        scala.collection.immutable.Map allResetOffsets = ((MapLike)this.resetOffsets(consumerGroupCommand).apply((Object)this.group())).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$6) {
                return x$6.offset();
            }
        }).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)0))})), (Object)allResetOffsets);
        Assert.assertEquals((Object)priorCommittedOffsets1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)priorCommittedOffsets2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsExportImportPlanSingleGroupArg() {
        String topic = "bar";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "2", "--export"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)exportedOffsets.apply((Object)this.group())).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$7) {
                return x$7.offset();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        String[] cgcArgsExec = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec = this.getConsumerGroupService(cgcArgsExec);
        Map importedOffsets = consumerGroupCommandExec.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets.apply((Object)this.group())).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$8) {
                return x$8.offset();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsExportImportPlan() {
        String group1 = new StringBuilder().append((Object)this.group()).append((Object)"1").toString();
        String group2 = new StringBuilder().append((Object)this.group()).append((Object)"2").toString();
        String topic1 = "bar1";
        String topic2 = "bar2";
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        TopicPartition t1p1 = new TopicPartition(topic1, 1);
        TopicPartition t2p0 = new TopicPartition(topic2, 0);
        TopicPartition t2p1 = new TopicPartition(topic2, 1);
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = this.buildArgsForGroups((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{group1, group2}))), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "2", "--export"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic1, group1, 100, 2);
        this.produceConsumeAndShutdown(topic2, group2, 100, 5);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)exportedOffsets.apply((Object)group1)).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$9) {
                return x$9.offset();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)exportedOffsets.apply((Object)group2)).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$10) {
                return x$10.offset();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        String[] cgcArgsExec = this.buildArgsForGroups((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{group1, group2}))), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec = this.getConsumerGroupService(cgcArgsExec);
        Map importedOffsets = consumerGroupCommandExec.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets.apply((Object)group1)).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$11) {
                return x$11.offset();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets.apply((Object)group2)).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$12) {
                return x$12.offset();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        String[] cgcArgsExec2 = this.buildArgsForGroup(group1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec2 = this.getConsumerGroupService(cgcArgsExec2);
        Map importedOffsets2 = consumerGroupCommandExec2.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets2.apply((Object)group1)).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$13) {
                return x$13.offset();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        this.adminZkClient().deleteTopic(this.topic());
    }

    @Test(expected=OptionException.class)
    public void testResetWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        this.getConsumerGroupService(cgcArgs);
    }

    public void kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(String topic, int numMessages) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final ProducerRecord<byte[], byte[]> apply(int x$14) {
                return new ProducerRecord(this.topic$1, (Object)new byte[100000]);
            }
            {
                this.topic$1 = topic$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records2, 1);
    }

    private void produceConsumeAndShutdown(String topic, String group, int totalMessages, int numConsumers) {
        this.kafka$admin$ResetConsumerGroupOffsetTest$$produceMessages(topic, totalMessages);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(numConsumers, topic, group, this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        this.kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress(topic, group, totalMessages);
        executor.shutdown();
    }

    private int produceConsumeAndShutdown$default$4() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public void kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress(String topic, String group, long count) {
        KafkaConsumer<String, String> consumer = this.createNoAutoCommitConsumer(group);
        try {
            scala.collection.immutable.Set partitions = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(consumer.partitionsFor(topic)).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicPartition apply(PartitionInfo partitionInfo2) {
                    return new TopicPartition(partitionInfo2.topic(), partitionInfo2.partition());
                }
            }, Buffer$.MODULE$.canBuildFrom())).toSet();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, count, consumer, partitions){
                public static final long serialVersionUID = 0L;
                private final long count$1;
                private final KafkaConsumer consumer$1;
                private final scala.collection.immutable.Set partitions$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    Iterable committed = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.consumer$1.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.partitions$1).asJava()).values()).asScala();
                    long total = BoxesRunTime.unboxToLong((Object)committed.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(long x0$1, OffsetAndMetadata x1$1) {
                            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)x1$1);
                            if (tuple2 != null) {
                                long currentSum = tuple2._1$mcJ$sp();
                                OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tuple2._2();
                                long l = currentSum + BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)offsetAndMetadata).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final long apply(OffsetAndMetadata x$15) {
                                        return x$15.offset();
                                    }
                                }).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final long apply() {
                                        return this.apply$mcJ$sp();
                                    }

                                    public long apply$mcJ$sp() {
                                        return 0L;
                                    }
                                }));
                                return l;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                    }));
                    return total == this.count$1;
                }
                {
                    this.count$1 = count$1;
                    this.consumer$1 = consumer$1;
                    this.partitions$1 = partitions$1;
                }
            }, (Function0<String>)new Serializable(this, topic, group, count){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;
                private final String topic$2;
                private final String group$2;
                private final long count$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Expected that consumer group has consumed all messages from topic/partition. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected offset: ", ". Actual offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.count$1), this.$outer.committedOffsets(this.topic$2, this.group$2).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$2 = topic$2;
                    this.group$2 = group$2;
                    this.count$1 = count$1;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
        catch (Throwable throwable) {
            void var5_4;
            var5_4.close();
            throw throwable;
        }
        consumer.close();
    }

    public String kafka$admin$ResetConsumerGroupOffsetTest$$awaitConsumerProgress$default$1() {
        return this.topic();
    }

    private String awaitConsumerProgress$default$2() {
        return this.group();
    }

    /*
     * WARNING - void declaration
     */
    private void resetAndAssertOffsets(String[] args, long expectedOffset, boolean dryRun, Seq<String> topics) {
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        scala.collection.immutable.Map expectedOffsets = ((TraversableOnce)topics.map((Function1)new Serializable(this, expectedOffset){
            public static final long serialVersionUID = 0L;
            private final long expectedOffset$1;

            public final Tuple2<String, scala.collection.immutable.Map<TopicPartition, Object>> apply(String topic) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)BoxesRunTime.boxToLong((long)this.expectedOffset$1))})));
            }
            {
                this.expectedOffset$1 = expectedOffset$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsetsResultByGroup = this.resetOffsets(consumerGroupCommand);
        try {
            topics.foreach((Function1)new Serializable(this, dryRun, expectedOffsets, resetOffsetsResultByGroup){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;
                public final boolean dryRun$1;
                public final scala.collection.immutable.Map expectedOffsets$2;
                private final Map resetOffsetsResultByGroup$1;

                public final void apply(String topic) {
                    this.resetOffsetsResultByGroup$1.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, Map<TopicPartition, OffsetAndMetadata>> check$ifrefutable$1) {
                            Tuple2<String, Map<TopicPartition, OffsetAndMetadata>> tuple2 = check$ifrefutable$1;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$resetAndAssertOffsets$1 $outer;
                        public final String topic$5;

                        public final void apply(Tuple2<String, Map<TopicPartition, OffsetAndMetadata>> x$17) {
                            Tuple2<String, Map<TopicPartition, OffsetAndMetadata>> tuple2 = x$17;
                            if (tuple2 != null) {
                                String group = (String)tuple2._1();
                                Map partitionInfo2 = (Map)tuple2._2();
                                scala.collection.immutable.Map<TopicPartition, Object> priorOffsets = this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$anonfun$$$outer().committedOffsets(this.topic$5, group);
                                Assert.assertEquals((Object)this.$outer.expectedOffsets$2.apply((Object)this.topic$5), (Object)((MapLike)partitionInfo2.filter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$resetAndAssertOffsets$1$$anonfun$apply$5 $outer;

                                    public final boolean apply(Tuple2<TopicPartition, OffsetAndMetadata> partitionInfo2) {
                                        String string = ((TopicPartition)partitionInfo2._1()).topic();
                                        String string2 = this.$outer.topic$5;
                                        return !(string != null ? !string.equals(string2) : string2 != null);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                })).mapValues((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final long apply(OffsetAndMetadata x$16) {
                                        return x$16.offset();
                                    }
                                }).toMap(Predef$.MODULE$.$conforms()));
                                Assert.assertEquals(this.$outer.dryRun$1 ? priorOffsets : this.$outer.expectedOffsets$2.apply((Object)this.topic$5), this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$anonfun$$$outer().committedOffsets(this.topic$5, group));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.topic$5 = topic$5;
                        }
                    });
                }

                public /* synthetic */ ResetConsumerGroupOffsetTest kafka$admin$ResetConsumerGroupOffsetTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dryRun$1 = dryRun$1;
                    this.expectedOffsets$2 = expectedOffsets$2;
                    this.resetOffsetsResultByGroup$1 = resetOffsetsResultByGroup$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var6_5;
            var6_5.close();
            throw throwable;
        }
        consumerGroupCommand.close();
    }

    private boolean resetAndAssertOffsets$default$3() {
        return false;
    }

    private Seq<String> resetAndAssertOffsets$default$4() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}));
    }

    private void resetAndAssertOffsetsCommitted(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, scala.collection.immutable.Map<TopicPartition, Object> expectedOffsets, String topic) {
        Map<String, Map<TopicPartition, OffsetAndMetadata>> allResetOffsets = this.resetOffsets(consumerGroupService);
        allResetOffsets.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Map<TopicPartition, OffsetAndMetadata>> check$ifrefutable$2) {
                Tuple2<String, Map<TopicPartition, OffsetAndMetadata>> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, expectedOffsets, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;
            public final scala.collection.immutable.Map expectedOffsets$1;
            public final String topic$3;

            public final void apply(Tuple2<String, Map<TopicPartition, OffsetAndMetadata>> x$19) {
                Tuple2<String, Map<TopicPartition, OffsetAndMetadata>> tuple2 = x$19;
                if (tuple2 != null) {
                    String group = (String)tuple2._1();
                    Map offsetsInfo = (Map)tuple2._2();
                    offsetsInfo.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<TopicPartition, OffsetAndMetadata> check$ifrefutable$3) {
                            Tuple2<TopicPartition, OffsetAndMetadata> tuple2 = check$ifrefutable$3;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, group){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$resetAndAssertOffsetsCommitted$2 $outer;
                        private final String group$3;

                        public final void apply(Tuple2<TopicPartition, OffsetAndMetadata> x$18) {
                            Tuple2<TopicPartition, OffsetAndMetadata> tuple2 = x$18;
                            if (tuple2 != null) {
                                TopicPartition tp = (TopicPartition)tuple2._1();
                                OffsetAndMetadata offsetMetadata = (OffsetAndMetadata)tuple2._2();
                                Assert.assertEquals((long)offsetMetadata.offset(), (long)BoxesRunTime.unboxToLong((Object)this.$outer.expectedOffsets$1.apply((Object)tp)));
                                Assert.assertEquals((Object)this.$outer.expectedOffsets$1, this.$outer.kafka$admin$ResetConsumerGroupOffsetTest$$anonfun$$$outer().committedOffsets(this.$outer.topic$3, this.group$3));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.group$3 = group$3;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ResetConsumerGroupOffsetTest kafka$admin$ResetConsumerGroupOffsetTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedOffsets$1 = expectedOffsets$1;
                this.topic$3 = topic$3;
            }
        });
    }

    private Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsets(ConsumerGroupCommand.ConsumerGroupService consumerGroupService) {
        return consumerGroupService.resetOffsets();
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
    }
}

