/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.BaseAdminIntegrationTest$;
import kafka.api.IntegrationTestHarness;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e!B\u0001\u0003\u0003\u00039!\u0001\u0007\"bg\u0016\fE-\\5o\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\u0007\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011!B;uS2\u001c\u0018BA\t\u000f\u0005\u001daunZ4j]\u001eDQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005%\u0001\u0001\"B\f\u0001\t\u0003A\u0012a\u00032s_.,'oQ8v]R,\u0012!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0004\u0013:$\b\"\u0002\u0011\u0001\t\u0003B\u0012a\u00037pO\u0012K'oQ8v]RD\u0011B\t\u0001A\u0002\u0003\u0007I\u0011A\u0012\u0002\r\rd\u0017.\u001a8u+\u0005!\u0003CA\u00130\u001b\u00051#BA\u0014)\u0003\u0015\tG-\\5o\u0015\tI#&A\u0004dY&,g\u000e^:\u000b\u0005\u0015Y#B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001eL!\u0001\r\u0014\u0003\u000b\u0005#W.\u001b8\t\u0013I\u0002\u0001\u0019!a\u0001\n\u0003\u0019\u0014AC2mS\u0016tGo\u0018\u0013fcR\u0011Ag\u000e\t\u00035UJ!AN\u000e\u0003\tUs\u0017\u000e\u001e\u0005\bqE\n\t\u00111\u0001%\u0003\rAH%\r\u0005\u0007u\u0001\u0001\u000b\u0015\u0002\u0013\u0002\u000f\rd\u0017.\u001a8uA!)A\b\u0001C\u0001{\u0005iq\r\\8cC2$\u0016.\\3pkR,\u0012A\u0010\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bQA];mKNT!aQ\u0017\u0002\u000b),h.\u001b;\n\u0005\u0015\u0003%a\u0002+j[\u0016|W\u000f\u001e\u0015\u0003w\u001d\u0003\"\u0001S%\u000e\u0003\tK!A\u0013\"\u0003\tI+H.\u001a\u0005\u0006\u0019\u0002!\t%T\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002i!\u00121j\u0014\t\u0003\u0011BK!!\u0015\"\u0003\r\t+gm\u001c:f\u0011\u0015\u0019\u0006\u0001\"\u0011N\u0003!!X-\u0019:E_^t\u0007F\u0001*V!\tAe+\u0003\u0002X\u0005\n)\u0011I\u001a;fe\")\u0011\f\u0001C\u0001\u001b\u00061B/Z:u\u0007J,\u0017\r^3EK2,G/\u001a+pa&\u001c7\u000f\u000b\u0002Y7B\u0011\u0001\nX\u0005\u0003;\n\u0013A\u0001V3ti\")q\f\u0001C\u0001\u001b\u0006AB/Z:u\u0003V$\bn\u001c:ju\u0016$w\n]3sCRLwN\\:)\u0005y[\u0006\"\u00022\u0001\t\u0003\u0019\u0017\u0001H2p]\u001aLw-\u001e:fI\u000ecWo\u001d;feB+'/\\5tg&|gn\u001d\u000b\u0002IB\u0019Q\r[6\u000f\u0005i1\u0017BA4\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011N\u001b\u0002\u0004'\u0016$(BA4\u001c!\ta\u0017/D\u0001n\u0015\tqw.A\u0002bG2T!\u0001\u001d\u0016\u0002\r\r|W.\\8o\u0013\t\u0011XN\u0001\u0007BG2|\u0005/\u001a:bi&|g\u000eC\u0003u\u0001\u0011\u0005S/A\u0007n_\u0012Lg-_\"p]\u001aLwm\u001d\u000b\u0003iYDQa^:A\u0002a\fqaY8oM&<7\u000fE\u0002zyzl\u0011A\u001f\u0006\u0003wn\t!bY8mY\u0016\u001cG/[8o\u0013\ti(PA\u0002TKF\u00042a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001B;uS2T!!a\u0002\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\t\tA\u0001\u0006Qe>\u0004XM\u001d;jKNDq!a\u0004\u0001\t\u0003\t\t\"\u0001\u0007de\u0016\fG/Z\"p]\u001aLw\r\u0006\u0002\u0002\u0014A9q0!\u0006\u0002\u001a\u0005}\u0011\u0002BA\f\u0003\u0003\u00111!T1q!\r)\u00171D\u0005\u0004\u0003;Q'AB*ue&tw\r\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\u0011\t)#!\u0002\u0002\t1\fgnZ\u0005\u0005\u0003S\t\u0019C\u0001\u0004PE*,7\r\u001e\u0005\b\u0003[\u0001A\u0011AA\u0018\u000359\u0018-\u001b;G_J$v\u000e]5dgR9A'!\r\u00024\u0005e\u0002B\u0002\u0012\u0002,\u0001\u0007A\u0005\u0003\u0005\u00026\u0005-\u0002\u0019AA\u001c\u0003=)\u0007\u0010]3di\u0016$\u0007K]3tK:$\b\u0003B=}\u00033A\u0001\"a\u000f\u0002,\u0001\u0007\u0011qG\u0001\u0010Kb\u0004Xm\u0019;fI6K7o]5oO\"9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0013\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b))\t\u0019%!\u0013\u0002L\u0005=\u0013\u0011\f\t\u0004K\u0005\u0015\u0013bAA$M\t\u0001Bk\u001c9jG\u0012+7o\u0019:jaRLwN\u001c\u0005\u0007E\u0005u\u0002\u0019\u0001\u0013\t\u0011\u00055\u0013Q\ba\u0001\u00033\tQ\u0001^8qS\u000eD!\"!\u0015\u0002>A\u0005\t\u0019AA*\u0003=!Wm]2sS\n,w\n\u001d;j_:\u001c\bcA\u0013\u0002V%\u0019\u0011q\u000b\u0014\u0003+\u0011+7o\u0019:jE\u0016$v\u000e]5dg>\u0003H/[8og\"Q\u00111LA\u001f!\u0003\u0005\r!!\u0018\u00021\u0015D\b/Z2uK\u0012tU/\u001c)beRLG/[8og>\u0003H\u000f\u0005\u0003\u001b\u0003?J\u0012bAA17\t1q\n\u001d;j_:D\u0011\"!\u001a\u0001#\u0003%\t!a\u001a\u00025\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005%$\u0006BA*\u0003WZ#!!\u001c\u0011\t\u0005=\u0014\u0011P\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003oZ\u0012AC1o]>$\u0018\r^5p]&!\u00111PA9\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u007f\u0002\u0011\u0013!C\u0001\u0003\u0003\u000b!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ*\"!a!+\t\u0005u\u00131\u000e")
public abstract class BaseAdminIntegrationTest
extends IntegrationTestHarness {
    private Admin client;

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public int logDirCount() {
        return 2;
    }

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    @Test
    public void testCreateDeleteTopics() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2", "mytopic3"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0)}))).asJava())}))).asJava()), new NewTopic("mytopic2", 3, (short)3), new NewTopic("mytopic3", OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())))}));
        CreateTopicsResult validateResult = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true));
        validateResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.validateMetadataAndConfigs$1(validateResult);
        CreateTopicsResult createResult = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava());
        createResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        this.validateMetadataAndConfigs$1(createResult);
        CreateTopicsResult failedCreateResult = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava());
        java.util.Map results = failedCreateResult.values();
        Assert.assertTrue((boolean)results.containsKey("mytopic"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assert.assertTrue((boolean)results.containsKey("mytopic2"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assert.assertTrue((boolean)results.containsKey("mytopic3"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.numPartitions("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.replicationFactor("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.config("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assert.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assert.assertEquals((long)2L, (long)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assert.assertEquals((long)1L, (long)topic0Partition0.leader().id());
        Assert.assertEquals((long)0L, (long)topic0Partition0.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$1) {
                return x$1.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$2) {
                return x$2.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assert.assertEquals((long)2L, (long)topic0Partition1.leader().id());
        Assert.assertEquals((long)1L, (long)topic0Partition1.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$3) {
                return x$3.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$4) {
                return x$4.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assert.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assert.assertEquals((long)3L, (long)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseAdminIntegrationTest $outer;
            private final TopicDescription topic1$1;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                TopicPartitionInfo partition = (TopicPartitionInfo)this.topic1$1.partitions().get(partitionId);
                Assert.assertEquals((long)partitionId, (long)partition.partition());
                Assert.assertEquals((long)3L, (long)partition.replicas().size());
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCreateDeleteTopics$1 $outer;

                    public final void apply(Node replica) {
                        Assert.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
                        Assert.assertTrue((replica.id() < this.$outer.kafka$api$BaseAdminIntegrationTest$$anonfun$$$outer().brokerCount() ? 1 : 0) != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Assert.assertEquals((String)"No duplicate replica ids", (long)partition.replicas().size(), (long)((SeqLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Node x$5) {
                        return x$5.id();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).distinct()).size());
                Assert.assertEquals((long)3L, (long)partition.isr().size());
                Assert.assertEquals((Object)partition.replicas(), (Object)partition.isr());
                Assert.assertTrue((boolean)partition.replicas().contains(partition.leader()));
            }

            public /* synthetic */ BaseAdminIntegrationTest kafka$api$BaseAdminIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$1 = topic1$1;
            }
        });
        TopicDescription topic3 = (TopicDescription)topicToDescription.get("mytopic3");
        Assert.assertEquals((Object)"mytopic3", (Object)topic3.name());
        Assert.assertEquals((Object)((KafkaConfig)this.configs().head()).numPartitions(), (Object)BoxesRunTime.boxToInteger((int)topic3.partitions().size()));
        Assert.assertEquals((long)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (long)((TopicPartitionInfo)topic3.partitions().get(0)).replicas().size());
        this.client().deleteTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testAuthorizedOperations() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Assert.assertNull((Object)result.authorizedOperations().get());
        result = this.client().describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true));
        java.util.Set expectedOperations = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.configuredClusterPermissions()).asJava();
        Assert.assertEquals((Object)expectedOperations, (Object)result.authorizedOperations().get());
        String topic = "mytopic";
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic, 3, (short)3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), (Seq<String>)Nil$.MODULE$);
        TopicDescription topicResult = this.getTopicMetadata(this.client(), topic, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assert.assertNull((Object)topicResult.authorizedOperations());
        topicResult = this.getTopicMetadata(this.client(), topic, new DescribeTopicsOptions().includeAuthorizedOperations(true), this.getTopicMetadata$default$4());
        expectedOperations = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)AclEntry$.MODULE$.supportedOperations(ResourceType.TOPIC)).asJava();
        Assert.assertEquals((Object)expectedOperations, (Object)topicResult.authorizedOperations());
    }

    public scala.collection.immutable.Set<AclOperation> configuredClusterPermissions() {
        return AclEntry$.MODULE$.supportedOperations(ResourceType.CLUSTER);
    }

    @Override
    public void modifyConfigs(Seq<Properties> configs) {
        super.modifyConfigs(configs);
        configs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
                config.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
                config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
                config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
                return config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp()) ? BoxedUnit.UNIT : config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        config.put("request.timeout.ms", "20000");
        Properties securityProps2 = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)securityProps2).asScala()).foreach((Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final HashMap config$1;

            public final Object apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    Object value = tuple2._2();
                    Object object = this.config$1.put((String)key, value);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.config$1 = config$1;
            }
        });
        return var1_1;
    }

    public void waitForTopics(Admin client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, client, expectedPresent, expectedMissing){
            public static final long serialVersionUID = 0L;
            private final Admin client$1;
            private final Seq expectedPresent$1;
            private final Seq expectedMissing$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                java.util.Set topics = (java.util.Set)this.client$1.listTopics().names().get();
                return this.expectedPresent$1.forall((Function1)new Serializable(this, topics){
                    public static final long serialVersionUID = 0L;
                    private final java.util.Set topics$1;

                    public final boolean apply(String topicName) {
                        return this.topics$1.contains(topicName);
                    }
                    {
                        this.topics$1 = topics$1;
                    }
                }) && this.expectedMissing$1.forall((Function1)new Serializable(this, topics){
                    public static final long serialVersionUID = 0L;
                    private final java.util.Set topics$1;

                    public final boolean apply(String topicName) {
                        return !this.topics$1.contains(topicName);
                    }
                    {
                        this.topics$1 = topics$1;
                    }
                });
            }
            {
                this.client$1 = client$1;
                this.expectedPresent$1 = expectedPresent$1;
                this.expectedMissing$1 = expectedMissing$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "timed out waiting for topics";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public TopicDescription getTopicMetadata(Admin client, String topic, DescribeTopicsOptions describeOptions, Option<Object> expectedNumPartitionsOpt) {
        ObjectRef result = ObjectRef.create(null);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, client, topic, describeOptions, expectedNumPartitionsOpt, result){
            public static final long serialVersionUID = 0L;
            private final Admin client$2;
            private final String topic$1;
            private final DescribeTopicsOptions describeOptions$1;
            private final Option expectedNumPartitionsOpt$1;
            public final ObjectRef result$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Throwable throwable2;
                block2: {
                    boolean bl;
                    KafkaFuture topicResult = (KafkaFuture)this.client$2.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic$1}))).asJava(), this.describeOptions$1).values().get(this.topic$1);
                    try {
                        this.result$1.elem = (TopicDescription)topicResult.get();
                        bl = BoxesRunTime.unboxToBoolean((Object)this.expectedNumPartitionsOpt$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$getTopicMetadata$1 $outer;

                            public final boolean apply(int x$6) {
                                return this.apply$mcZI$sp(x$6);
                            }

                            public boolean apply$mcZI$sp(int x$6) {
                                return x$6 == ((TopicDescription)this.$outer.result$1.elem).partitions().size();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return true;
                            }
                        }));
                    }
                    catch (Throwable throwable2) {
                        boolean bl2;
                        ExecutionException executionException;
                        Throwable throwable3 = throwable2;
                        if (!(throwable3 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable3).getCause() instanceof UnknownTopicOrPartitionException)) break block2;
                        bl = bl2 = false;
                    }
                    return bl;
                }
                throw throwable2;
            }
            {
                this.client$2 = client$2;
                this.topic$1 = topic$1;
                this.describeOptions$1 = describeOptions$1;
                this.expectedNumPartitionsOpt$1 = expectedNumPartitionsOpt$1;
                this.result$1 = result$1;
            }
        }, (Function0<String>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out waiting for metadata for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1}));
            }
            {
                this.topic$1 = topic$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        return (TopicDescription)result.elem;
    }

    public DescribeTopicsOptions getTopicMetadata$default$3() {
        return new DescribeTopicsOptions();
    }

    public Option<Object> getTopicMetadata$default$4() {
        return None$.MODULE$;
    }

    private final void validateMetadataAndConfigs$1(CreateTopicsResult result) {
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)result.numPartitions("mytopic").get());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)result.replicationFactor("mytopic").get());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)3), (Object)result.numPartitions("mytopic2").get());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)3), (Object)result.replicationFactor("mytopic2").get());
        Assert.assertEquals((Object)((KafkaConfig)this.configs().head()).numPartitions(), (Object)result.numPartitions("mytopic3").get());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)((KafkaConfig)this.configs().head()).defaultReplicationFactor()), (Object)result.replicationFactor("mytopic3").get());
        Assert.assertFalse((boolean)((Config)result.config("mytopic").get()).entries().isEmpty());
    }
}

