/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractConsumerTest;
import kafka.api.ConsumerBounceTest$;
import kafka.api.FixedPortTestUtils$;
import kafka.log.AbstractLog;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u001df\u0001B\u0001\u0003\u0001\u001d\u0011!cQ8ogVlWM\u001d\"pk:\u001cW\rV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\u0007\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!\u0001F!cgR\u0014\u0018m\u0019;D_:\u001cX/\\3s)\u0016\u001cH\u000f\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\t\u0005)Q\u000f^5mg&\u0011\u0011C\u0004\u0002\b\u0019><w-\u001b8h\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\n\u0001!9q\u0003\u0001b\u0001\n\u0003A\u0012\u0001D7bq\u001e\u0013x.\u001e9TSj,W#A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\u0007%sG\u000f\u0003\u0004!\u0001\u0001\u0006I!G\u0001\u000e[\u0006DxI]8vaNK'0\u001a\u0011\t\u000f\t\u0002!\u0019!C\u0001G\u0005\u0019rM]1dK\u001a,Hn\u00117pg\u0016$\u0016.\\3NgV\tA\u0005E\u0002\u001bK\u001dJ!AJ\u000e\u0003\tM{W.\u001a\t\u00035!J!!K\u000e\u0003\t1{gn\u001a\u0005\u0007W\u0001\u0001\u000b\u0011\u0002\u0013\u0002)\u001d\u0014\u0018mY3gk2\u001cEn\\:f)&lW-T:!\u0011\u001di\u0003A1A\u0005\u00029\n\u0001\"\u001a=fGV$xN]\u000b\u0002_A\u0011\u0001gN\u0007\u0002c)\u0011!gM\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001b6\u0003\u0011)H/\u001b7\u000b\u0003Y\nAA[1wC&\u0011\u0001(\r\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007B\u0002\u001e\u0001A\u0003%q&A\u0005fq\u0016\u001cW\u000f^8sA!9A\b\u0001b\u0001\n\u0003i\u0014aD2p]N,X.\u001a:Q_2dWM]:\u0016\u0003y\u00022a\u0010#G\u001b\u0005\u0001%BA!C\u0003\u001diW\u000f^1cY\u0016T!aQ\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002F\u0001\n1!)\u001e4gKJ\u0004\"a\u0012%\u000e\u0003\u0001I!!\u0013\u0006\u00031\r{gn];nKJ\f5o]5h]6,g\u000e\u001e)pY2,'\u000f\u0003\u0004L\u0001\u0001\u0006IAP\u0001\u0011G>t7/^7feB{G\u000e\\3sg\u0002BQ!\u0014\u0001\u0005B9\u000bqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002\u001fB\u0019\u0001+U*\u000e\u0003\tK!A\u0015\"\u0003\u0007M+\u0017\u000f\u0005\u0002U/6\tQK\u0003\u0002W\t\u000511/\u001a:wKJL!\u0001W+\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u00065\u0002!IaW\u0001\u0015O\u0016tWM]1uK.\u000bgm[1D_:4\u0017nZ:\u0015\u0005=c\u0006bB\fZ!\u0003\u0005\r!\u0018\t\u0003=\u0006t!AG0\n\u0005\u0001\\\u0012A\u0002)sK\u0012,g-\u0003\u0002cG\n11\u000b\u001e:j]\u001eT!\u0001Y\u000e\t\u000b\u0015\u0004A\u0011\t4\u0002\u0011Q,\u0017M\u001d#po:$\u0012a\u001a\t\u00035!L!![\u000e\u0003\tUs\u0017\u000e\u001e\u0015\u0003I.\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\u000b),h.\u001b;\u000b\u0003A\f1a\u001c:h\u0013\t\u0011XNA\u0003BMR,'\u000fC\u0003u\u0001\u0011\u0005a-A\u0011uKN$8i\u001c8tk6\u0004H/[8o/&$\bN\u0011:pW\u0016\u0014h)Y5mkJ,7\u000f\u000b\u0002tmB\u0011An^\u0005\u0003q6\u0014a!S4o_J,\u0007FA:{!\ta70\u0003\u0002}[\n!A+Z:u\u0011\u0015q\b\u0001\"\u0001\u0000\u0003e\u0019wN\\:v[\u0016<\u0016\u000e\u001e5Ce>\\WM\u001d$bS2,(/Z:\u0015\u0007\u001d\f\t\u0001\u0003\u0004\u0002\u0004u\u0004\r!G\u0001\t]Vl\u0017\n^3sg\"1\u0011q\u0001\u0001\u0005\u0002\u0019\f1\u0005^3tiN+Wm[!oI\u000e{W.\\5u/&$\bN\u0011:pW\u0016\u0014h)Y5mkJ,7\u000fK\u0002\u0002\u0006iDq!!\u0004\u0001\t\u0003\ty!A\u0010tK\u0016\\\u0017I\u001c3D_6l\u0017\u000e^,ji\"\u0014%o\\6fe\u001a\u000b\u0017\u000e\\;sKN$2aZA\t\u0011\u001d\t\u0019!a\u0003A\u0002eAa!!\u0006\u0001\t\u00031\u0017!\t;fgR\u001cVOY:de&\u0014Wm\u00165f]R{\u0007/[2V]\u00064\u0018-\u001b7bE2,\u0007fAA\nu\"1\u00111\u0004\u0001\u0005\u0002\u0019\f\u0011\u0002^3ti\u000ecwn]3)\u0007\u0005e!\u0010C\u0004\u0002\"\u0001!I!a\t\u0002%\rDWmY6DY>\u001cXmR8pIB\u000bG\u000f\u001b\u000b\u0006O\u0006\u0015\u0012\u0011\u0006\u0005\b\u0003O\ty\u00021\u0001\u001a\u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\b\u0003W\ty\u00021\u0001^\u0003\u001d9'o\\;q\u0013\u0012Dq!a\f\u0001\t\u0013\t\t$\u0001\u0011dQ\u0016\u001c7n\u00117pg\u0016<\u0016\u000e\u001e5D_>\u0014H-\u001b8bi>\u0014h)Y5mkJ,GcB4\u00024\u0005U\u0012\u0011\b\u0005\b\u0003O\ti\u00031\u0001\u001a\u0011\u001d\t9$!\fA\u0002u\u000bA\u0002Z=oC6L7m\u0012:pkBDq!a\u000f\u0002.\u0001\u0007Q,A\u0006nC:,\u0018\r\\$s_V\u0004\bbBA \u0001\u0011%\u0011\u0011I\u0001\u0010M&tGmQ8pe\u0012Lg.\u0019;peR\u0019\u0011$a\u0011\t\u000f\u0005\u0015\u0013Q\ba\u0001;\u0006)qM]8va\"9\u0011\u0011\n\u0001\u0005\n\u0005-\u0013\u0001H2iK\u000e\\7\t\\8tK^KG\u000f[\"mkN$XM\u001d$bS2,(/\u001a\u000b\bO\u00065\u0013qJA*\u0011\u001d\t9#a\u0012A\u0002eAq!!\u0015\u0002H\u0001\u0007Q,\u0001\u0004he>,\b/\r\u0005\b\u0003+\n9\u00051\u0001^\u0003\u00199'o\\;qe!1\u0011\u0011\f\u0001\u0005\u0002\u0019\fa\t^3tiJ{G\u000e\\5oO\n\u0013xn[3s%\u0016\u001cH/\u0019:ug^KG\u000f[*nC2dWM]'bq\u001e\u0013x.\u001e9TSj,7i\u001c8gS\u001e$\u0015n\u001d:vaR\u001c()[4He>,\b\u000fK\u0002\u0002XiDa!a\u0018\u0001\t\u00031\u0017\u0001\u000f;fgR\u001cuN\\:v[\u0016\u0014(+Z2fSZ,7OR1uC2,\u0005pY3qi&|gn\u00165f]\u001e\u0013x.\u001e9QCN\u001cXm]'bqNK'0\u001a\u0015\u0004\u0003;R\bBBA3\u0001\u0011\u0005a-\u0001\ruKN$8\t\\8tK\u0012+(/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016D3!a\u0019{\u0011\u001d\tY\u0007\u0001C\u0005\u0003[\n\u0011d\u00195fG.\u001cEn\\:f\tV\u0014\u0018N\\4SK\n\fG.\u00198dKRIq-a\u001c\u0002r\u0005U\u0014Q\u0010\u0005\b\u0003W\tI\u00071\u0001^\u0011\u001d\t\u0019(!\u001bA\u0002u\u000bQ\u0001^8qS\u000eDq!LA5\u0001\u0004\t9\bE\u00021\u0003sJ1!a\u001f2\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007\u0002CA@\u0003S\u0002\r!!!\u00027\t\u0014xn[3sg\u00063\u0018-\u001b7bE2,G)\u001e:j]\u001e\u001cEn\\:f!\rQ\u00121Q\u0005\u0004\u0003\u000b[\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0013\u0003A\u0011BAF\u0003a\u0019'/Z1uK\u000e{gn];nKJ\fe\u000e\u001a*fG\u0016Lg/\u001a\u000b\t\u0003\u001b\u000by+!-\u00026BA\u0011qRAP\u0003G\u000b\u0019+\u0004\u0002\u0002\u0012*!\u00111SAK\u0003!\u0019wN\\:v[\u0016\u0014(\u0002BAL\u00033\u000bqa\u00197jK:$8OC\u0002\u0006\u00037S1!!(p\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011UAI\u00055Y\u0015MZ6b\u0007>t7/^7feB)!$!*\u0002*&\u0019\u0011qU\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0007i\tY+C\u0002\u0002.n\u0011AAQ=uK\"9\u00111FAD\u0001\u0004i\u0006\u0002CAZ\u0003\u000f\u0003\r!!!\u0002\u00195\fg.^1m\u0003N\u001c\u0018n\u001a8\t\u000f\u0005\u001d\u0012q\u0011a\u00013!9\u0011\u0011\u0018\u0001\u0005\n\u0005m\u0016a\u0005:fG\u0016Lg/Z#yC\u000e$(+Z2pe\u0012\u001cHcB4\u0002>\u0006}\u0016\u0011\u0019\u0005\b\u0003'\u000b9\f1\u0001G\u0011\u001d\t9#a.A\u0002eA\u0011\"a1\u00028B\u0005\t\u0019A\u0014\u0002\u0013QLW.Z8vi6\u001b\bbBAd\u0001\u0011%\u0011\u0011Z\u0001\u0017gV\u0014W.\u001b;DY>\u001cX-\u00118e-\u0006d\u0017\u000eZ1uKRQ\u00111ZAl\u00033\fi.a:\u0011\u000bA\ni-!5\n\u0007\u0005=\u0017G\u0001\u0004GkR,(/\u001a\t\u00045\u0005M\u0017bAAk7\t\u0019\u0011I\\=\t\u0011\u0005M\u0015Q\u0019a\u0001\u0003\u001bCq!a7\u0002F\u0002\u0007q%\u0001\bdY>\u001cX\rV5nK>,H/T:\t\u0011\u0005}\u0017Q\u0019a\u0001\u0003C\fa\"\\5o\u00072|7/\u001a+j[\u0016l5\u000f\u0005\u0003\u001b\u0003G<\u0013bAAs7\t1q\n\u001d;j_:D\u0001\"!;\u0002F\u0002\u0007\u0011\u0011]\u0001\u000f[\u0006D8\t\\8tKRKW.Z't\u0011\u001d\ti\u000f\u0001C\u0005\u0003_\f\u0001c\u00195fG.\u001cEn\\:fIN#\u0018\r^3\u0015\u000b\u001d\f\t0a=\t\u000f\u0005-\u00121\u001ea\u0001;\"9\u0011Q_Av\u0001\u0004I\u0012\u0001E2p[6LG\u000f^3e%\u0016\u001cwN\u001d3t\r\u0019\tI\u0010\u0001\u0003\u0002|\n)\"i\\;oG\u0016\u0014%o\\6feN\u001b\u0007.\u001a3vY\u0016\u00148\u0003BA|\u0003{\u00042!DA\u0000\u0013\r\u0011\tA\u0004\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0003\u0006\u0002\u0004\u0005](Q1A\u0005\u0002aA!Ba\u0002\u0002x\n\u0005\t\u0015!\u0003\u001a\u0003%qW/\\%uKJ\u001c\b\u0005C\u0004\u0014\u0003o$\tAa\u0003\u0015\t\t5!q\u0002\t\u0004\u000f\u0006]\bbBA\u0002\u0005\u0013\u0001\r!\u0007\u0005\n\u0005'\t9\u00101A\u0005\u0002a\tA!\u001b;fe\"Q!qCA|\u0001\u0004%\tA!\u0007\u0002\u0011%$XM]0%KF$2a\u001aB\u000e\u0011%\u0011iB!\u0006\u0002\u0002\u0003\u0007\u0011$A\u0002yIEB\u0001B!\t\u0002x\u0002\u0006K!G\u0001\u0006SR,'\u000f\t\u0005\b\u0005K\t9\u0010\"\u0011g\u0003\u0019!wnV8sW\"9!\u0011\u0006\u0001\u0005\n\t-\u0012!F2sK\u0006$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u000b\u0005[\u0011yD!\u0011\u0003F\t%\u0003#\u00020\u00030\tM\u0012b\u0001B\u0019G\n\u00191+\u001a;\u0011\t\tU\"1H\u0007\u0003\u0005oQAA!\u000f\u0002\u001a\u000611m\\7n_:LAA!\u0010\u00038\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA:\u0005O\u0001\r!\u0018\u0005\b\u0005\u0007\u00129\u00031\u0001\u001a\u00035qW/\u001c)beRLG/[8og\"9!q\tB\u0014\u0001\u0004I\u0012!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\"Q!1\nB\u0014!\u0003\u0005\rA!\u0014\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u0005\u0005\u001f\u0012\t&D\u00014\u0013\r\u0011\u0019f\r\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002B,\u0001\u0011%!\u0011L\u0001\fg\u0016tGMU3d_J$7\u000fF\u0005h\u00057\u0012IGa\u001b\u0003n!A!Q\fB+\u0001\u0004\u0011y&\u0001\u0005qe>$WoY3s!!\u0011\tG!\u001a\u0002$\u0006\rVB\u0001B2\u0015\u0011\u0011i&!&\n\t\t\u001d$1\r\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\t\u000f\u0005\u001d\"Q\u000ba\u00013!I\u00111\u000fB+!\u0003\u0005\r!\u0018\u0005\u000b\u0005\u0007\u0012)\u0006%AA\u0002\t=\u0004\u0003\u0002\u000e\u0002dfA\u0011Ba\u001d\u0001#\u0003%IA!\u001e\u0002=\u001d,g.\u001a:bi\u0016\\\u0015MZ6b\u0007>tg-[4tI\u0011,g-Y;mi\u0012\nTC\u0001B<U\ri&\u0011P\u0016\u0003\u0005w\u0002BA! \u0003\b6\u0011!q\u0010\u0006\u0005\u0005\u0003\u0013\u0019)A\u0005v]\u000eDWmY6fI*\u0019!QQ\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\n\n}$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!Q\u0012\u0001\u0012\u0002\u0013%!QO\u0001\u0016g\u0016tGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u0011\t\nAI\u0001\n\u0013\u0011\u0019*A\u000btK:$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tU%\u0006\u0002B8\u0005sB\u0011B!'\u0001#\u0003%IAa'\u0002;I,7-Z5wK\u0016C\u0018m\u0019;SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*\"A!(+\u0007\u001d\u0012I\bC\u0005\u0003\"\u0002\t\n\u0011\"\u0003\u0003$\u0006y2M]3bi\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0015&\u0006\u0002B'\u0005s\u0002")
public class ConsumerBounceTest
extends AbstractConsumerTest {
    private final int maxGroupSize;
    private final Some<Object> gracefulCloseTimeMs = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public int maxGroupSize() {
        return this.maxGroupSize;
    }

    public Some<Object> gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers() {
        return this.consumerPollers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return this.generateKafkaConfigs(this.generateKafkaConfigs$default$1());
    }

    private Seq<KafkaConfig> generateKafkaConfigs(String maxGroupSize) {
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.GroupMaxSizeProp(), maxGroupSize);
        properties.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1)new Serializable(this, properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.properties$1);
            }
            {
                this.properties$1 = properties$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private String generateKafkaConfigs$default$1() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.maxGroupSize())).toString();
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.consumerPollers().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(AbstractConsumerTest.ConsumerAssignmentPoller x$2) {
                    x$2.shutdown();
                }
            });
            this.executor().shutdownNow();
            Assert.assertTrue((String)"Executor did not terminate", (boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS));
            return;
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    @Ignore
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records2 = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(100L)).asScala();
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
            records2.foreach((Function1)new Serializable(this, consumed){
                public static final long serialVersionUID = 0L;
                private final LongRef consumed$1;

                public final void apply(ConsumerRecord<byte[], byte[]> record) {
                    Assert.assertEquals((long)this.consumed$1.elem, (long)record.offset());
                    ++this.consumed$1.elem;
                }
                {
                    this.consumed$1 = consumed$1;
                }
            });
            if (!records2.nonEmpty()) continue;
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numRecords){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            public final int numRecords$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$seekAndCommitWithBrokerFailures$1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return ((AbstractLog)server.replicaManager().localLog(this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$$outer().tp()).get()).highWatermark() == (long)this.$outer.numRecords$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$1 = numRecords$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for followers after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Seeking to end of log";
                    }
                });
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)new Serializable(this, pos){
                    public static final long serialVersionUID = 0L;
                    private final long pos$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Seeking to ").append((Object)BoxesRunTime.boxToLong((long)this.pos$1)).toString();
                    }
                    {
                        this.pos$1 = pos$1;
                    }
                });
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Committing offset.";
                }
            });
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.brokerCount(), this.$outer.brokerCount(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(Duration.ZERO);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        AbstractConsumerTest.ConsumerAssignmentPoller poller = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{newtopic})));
        this.consumerPollers().$plus$eq((Object)poller);
        poller.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
        poller.shutdown();
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        AbstractConsumerTest.ConsumerAssignmentPoller poller2 = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{newtopic})));
        this.consumerPollers().$plus$eq((Object)poller2);
        poller2.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        Future<Object> future = this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        future.get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    private int findCoordinator(String group) {
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setKey(group)).build();
        IntRef nodeId = IntRef.create((int)-1);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, request, nodeId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final FindCoordinatorRequest request$1;
            private final IntRef nodeId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                FindCoordinatorResponse response = (FindCoordinatorResponse)this.$outer.connectAndReceive((AbstractRequest)this.request$1, this.$outer.connectAndReceive$default$2(), this.$outer.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
                this.nodeId$1.elem = response.node().id();
                Errors errors = response.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.nodeId$1 = nodeId$1;
            }
        }, (Function0<String>)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final String group$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find coordinator for group ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group$1}));
            }
            {
                this.group$1 = group$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        return nodeId.elem;
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeout)).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    @Test
    public void testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup() {
        String group = "group-max-size-test";
        String topic = "group-max-size-test";
        int maxGroupSize = 2;
        int consumerCount = maxGroupSize + 1;
        int partitionCount = consumerCount * 2;
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, partitionCount, this.brokerCount(), this.createTopicPartitions$default$4());
        this.addConsumersToGroupAndWaitForGroupAssignment(consumerCount, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), partitions, group);
        Seq<KafkaConfig> newConfigs = this.generateKafkaConfigs(((Object)BoxesRunTime.boxToInteger((int)maxGroupSize)).toString());
        this.servers().indices().foreach$mVc$sp((Function1)new Serializable(this, newConfigs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final Seq newConfigs$1;

            public final void apply(int serverIdx) {
                this.apply$mcVI$sp(serverIdx);
            }

            public void apply$mcVI$sp(int serverIdx) {
                this.$outer.killBroker(serverIdx);
                KafkaConfig config = (KafkaConfig)this.newConfigs$1.apply(serverIdx);
                this.$outer.servers().update(serverIdx, (Object)TestUtils$.MODULE$.createServer(config, this.$outer.brokerTime(config.brokerId())));
                this.$outer.restartDeadBrokers();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newConfigs$1 = newConfigs$1;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$api$ConsumerBounceTest$$raisedExceptions$1().nonEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The remaining consumers in the group could not fetch the expected records";
            }
        }, 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)1L, (long)this.kafka$api$ConsumerBounceTest$$raisedExceptions$1().size());
        Assert.assertTrue((boolean)(this.kafka$api$ConsumerBounceTest$$raisedExceptions$1().head() instanceof GroupMaxSizeReachedException));
    }

    @Test
    public void testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize() {
        String group = "fatal-exception-test";
        String topic = "fatal-exception-test";
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, this.maxGroupSize(), this.brokerCount(), this.createTopicPartitions$default$4());
        this.addConsumersToGroupAndWaitForGroupAssignment(this.maxGroupSize(), (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), partitions, group);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.addConsumersToGroup(1, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), partitions, group);
        if (tuple2 != null) {
            Buffer rejectedConsumerPollers;
            Buffer buffer;
            Buffer rejectedConsumerPollers2 = buffer = (rejectedConsumerPollers = (Buffer)tuple2._2());
            AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer = (AbstractConsumerTest.ConsumerAssignmentPoller)((Object)rejectedConsumerPollers2.head());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, rejectedConsumer){
                public static final long serialVersionUID = 0L;
                private final AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.rejectedConsumer$1.thrownException().isDefined();
                }
                {
                    this.rejectedConsumer$1 = rejectedConsumer$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Extra consumer did not throw an exception";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertTrue((boolean)(rejectedConsumer.thrownException().get() instanceof GroupMaxSizeReachedException));
            this.sendRecords(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()), this.maxGroupSize() * 100, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitions.size())));
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConsumerBounceTest $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.consumerPollers().forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(AbstractConsumerTest.ConsumerAssignmentPoller p) {
                            return p.receivedMessages() >= 100;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The consumers in the group could not fetch the expected records";
                }
            }, 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.brokerCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerWithGroupId(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer1, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerWithGroupId(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer2, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, topic, executor);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        this.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, topic, executor);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller = manualAssign ? this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)Nil$.MODULE$, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})))) : this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), this.subscribeConsumerAndStartPolling$default$3());
        this.receiveExactRecords(consumerPoller, numRecords, this.receiveExactRecords$default$3());
        consumerPoller.shutdown();
        return consumer;
    }

    private void receiveExactRecords(AbstractConsumerTest.ConsumerAssignmentPoller consumer, int numRecords, long timeoutMs) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, numRecords){
            public static final long serialVersionUID = 0L;
            private final AbstractConsumerTest.ConsumerAssignmentPoller consumer$1;
            private final int numRecords$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.consumer$1.receivedMessages() == this.numRecords$2;
            }
            {
                this.consumer$1 = consumer$1;
                this.numRecords$2 = numRecords$2;
            }
        }, (Function0<String>)new Serializable(this, consumer, numRecords){
            public static final long serialVersionUID = 0L;
            private final AbstractConsumerTest.ConsumerAssignmentPoller consumer$1;
            private final int numRecords$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumer did not receive expected ", ". It received ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numRecords$2), BoxesRunTime.boxToInteger((int)this.consumer$1.receivedMessages())}));
            }
            {
                this.consumer$1 = consumer$1;
                this.numRecords$2 = numRecords$2;
            }
        }, timeoutMs, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private long receiveExactRecords$default$3() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, consumer, closeTimeoutMs, minCloseTimeMs, maxCloseTimeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final KafkaConsumer consumer$2;
            public final long closeTimeoutMs$1;
            private final Option minCloseTimeMs$1;
            private final Option maxCloseTimeMs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int closeGraceTimeMs = 2000;
                long startMs = System.currentTimeMillis();
                this.$outer.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$submitCloseAndValidate$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Closing consumer with timeout ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.closeTimeoutMs$1)).append((Object)" ms.").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.consumer$2.close(Duration.ofMillis(this.closeTimeoutMs$1));
                long timeTakenMs = System.currentTimeMillis() - startMs;
                this.maxCloseTimeMs$1.foreach((Function1)new Serializable(this, closeGraceTimeMs, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final int closeGraceTimeMs$1;
                    private final long timeTakenMs$1;

                    public final void apply(long ms) {
                        this.apply$mcVJ$sp(ms);
                    }

                    public void apply$mcVJ$sp(long ms) {
                        Assert.assertTrue((String)new StringBuilder().append((Object)"Close took too long ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).toString(), (this.timeTakenMs$1 < ms + (long)this.closeGraceTimeMs$1 ? 1 : 0) != 0);
                    }
                    {
                        this.closeGraceTimeMs$1 = closeGraceTimeMs$1;
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
                this.minCloseTimeMs$1.foreach((Function1)new Serializable(this, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final long timeTakenMs$1;

                    public final void apply(long ms) {
                        this.apply$mcVJ$sp(ms);
                    }

                    public void apply$mcVJ$sp(long ms) {
                        Assert.assertTrue((String)new StringBuilder().append((Object)"Close finished too quickly ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).toString(), (this.timeTakenMs$1 >= ms ? 1 : 0) != 0);
                    }
                    {
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
                this.$outer.info((Function0<String>)new Serializable(this, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final long timeTakenMs$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"consumer.close() completed in ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).append((Object)" ms.").toString();
                    }
                    {
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$2 = consumer$2;
                this.closeTimeoutMs$1 = closeTimeoutMs$1;
                this.minCloseTimeMs$1 = minCloseTimeMs$1;
                this.maxCloseTimeMs$1 = maxCloseTimeMs$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(this, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(Duration.ofSeconds(3L));
        Assert.assertTrue((String)"Assignment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            Assert.assertEquals((long)committedRecords, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        }
        consumer.close();
    }

    private scala.collection.immutable.Set<TopicPartition> createTopicPartitions(String topic, int numPartitions, int replicationFactor, Properties topicConfig) {
        this.createTopic(topic, numPartitions, replicationFactor, topicConfig);
        return ((TraversableOnce)package$.MODULE$.Range().apply(0, numPartitions).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final TopicPartition apply(int part) {
                return new TopicPartition(this.topic$3, part);
            }
            {
                this.topic$3 = topic$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
    }

    private Properties createTopicPartitions$default$4() {
        return new Properties();
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, String topic, Option<Object> numPartitions) {
        IntRef partitionIndex = IntRef.create((int)0);
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, topic, numPartitions, partitionIndex){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final KafkaProducer producer$1;
            private final String topic$1;
            private final Option numPartitions$1;
            private final IntRef partitionIndex$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$1.send(new ProducerRecord(this.topic$1, Predef$.MODULE$.int2Integer(this.$outer.kafka$api$ConsumerBounceTest$$getPartition$1(this.numPartitions$1, this.partitionIndex$1)), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
                this.topic$1 = topic$1;
                this.numPartitions$1 = numPartitions$1;
                this.partitionIndex$1 = partitionIndex$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$4) {
                return x$4.get();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String sendRecords$default$3() {
        return this.topic();
    }

    private Option<Object> sendRecords$default$4() {
        return None$.MODULE$;
    }

    private final void sendRecords$1(int numRecords, String topic, KafkaProducer producer$2) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1)new Serializable(this, producer$2, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConsumerBounceTest $outer;
                private final KafkaProducer producer$2;
                private final String topic$2;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$2.send(new ProducerRecord(this.topic$2, Predef$.MODULE$.int2Integer(this.$outer.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$2 = producer$2;
                    this.topic$2 = topic$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            futures.map((Function1)new Serializable(this, remainingRecords){
                public static final long serialVersionUID = 0L;
                private final IntRef remainingRecords$1;

                public final void apply(Future<RecordMetadata> future) {
                    try {
                        future.get();
                        --this.remainingRecords$1.elem;
                    }
                    catch (Exception exception) {}
                }
                {
                    this.remainingRecords$1 = remainingRecords$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    public final Seq kafka$api$ConsumerBounceTest$$raisedExceptions$1() {
        return (Seq)this.consumerPollers().flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Throwable> apply(AbstractConsumerTest.ConsumerAssignmentPoller x$3) {
                return Option$.MODULE$.option2Iterable(x$3.thrownException());
            }
        });
    }

    private final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, String topic$4, ExecutorService executor$1) {
        return executor$1.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, topic$4, consumer, revokeSemaphore){
            public static final long serialVersionUID = 0L;
            private final String topic$4;
            private final KafkaConsumer consumer$3;
            private final Option revokeSemaphore$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.consumer$3.subscribe(Collections.singletonList(this.topic$4));
                this.revokeSemaphore$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Semaphore s) {
                        s.release();
                    }
                });
                this.consumer$3.poll(0L);
            }
            {
                this.topic$4 = topic$4;
                this.consumer$3 = consumer$3;
                this.revokeSemaphore$1 = revokeSemaphore$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsumerRecords<byte[], byte[]> apply(KafkaConsumer<byte[], byte[]> consumer) {
                    return consumer.poll(Duration.ofMillis(100L));
                }
            });
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$1, String topic$4, ExecutorService executor$1) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = this.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), topic$4, executor$1);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    public final int kafka$api$ConsumerBounceTest$$getPartition$1(Option numPartitions$1, IntRef partitionIndex$1) {
        Option option;
        block4: {
            int n;
            block3: {
                block2: {
                    option = numPartitions$1;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    int partitions = BoxesRunTime.unboxToInt((Object)some.x());
                    int nextPart = partitionIndex$1.elem % partitions;
                    ++partitionIndex$1.elem;
                    n = nextPart;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                n = this.part();
            }
            return n;
        }
        throw new MatchError((Object)option);
    }

    public ConsumerBounceTest() {
        this.maxGroupSize = 5;
        this.consumerConfig().setProperty("enable.auto.commit", "true");
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
            } else {
                Thread.sleep(500L);
            }
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

