/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.ProducerStateEntry;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tec\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003\u0016:b]N\f7\r^5p]N$Vm\u001d;\u000b\u0005\r!\u0011aA1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00055Q!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%\t!F\u0001\u000b]Vl7+\u001a:wKJ\u001cX#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0007%sG\u000f\u0003\u0004\u001e\u0001\u0001\u0006IAF\u0001\f]Vl7+\u001a:wKJ\u001c\b\u0005C\u0004 \u0001\t\u0007I\u0011A\u000b\u00025Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2fe\u000e{WO\u001c;\t\r\u0005\u0002\u0001\u0015!\u0003\u0017\u0003m!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cu.\u001e8uA!91\u0005\u0001b\u0001\n\u0003)\u0012A\u0007;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]\"pk:$\bBB\u0013\u0001A\u0003%a#A\u000eue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:D_VtG\u000f\t\u0005\bO\u0001\u0011\r\u0011\"\u0001\u0016\u0003uqwN\u001c+sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]\"pk:$\bBB\u0015\u0001A\u0003%a#\u0001\u0010o_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001cu.\u001e8uA!91\u0006\u0001b\u0001\n\u0003a\u0013A\u0002;pa&\u001c\u0017'F\u0001.!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0003mC:<'\"\u0001\u001a\u0002\t)\fg/Y\u0005\u0003i=\u0012aa\u0015;sS:<\u0007B\u0002\u001c\u0001A\u0003%Q&A\u0004u_BL7-\r\u0011\t\u000fa\u0002!\u0019!C\u0001Y\u00051Ao\u001c9jGJBaA\u000f\u0001!\u0002\u0013i\u0013a\u0002;pa&\u001c'\u0007\t\u0005\by\u0001\u0011\r\u0011\"\u0001\u0016\u00035qW/\u001c)beRLG/[8og\"1a\b\u0001Q\u0001\nY\taB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0004A\u0001\t\u0007I\u0011A!\u0002-Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2feN,\u0012A\u0011\t\u0004\u0007\"SU\"\u0001#\u000b\u0005\u00153\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u000fb\t!bY8mY\u0016\u001cG/[8o\u0013\tIEI\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0017V;v+D\u0001M\u0015\tie*\u0001\u0005qe>$WoY3s\u0015\ty\u0005+A\u0004dY&,g\u000e^:\u000b\u0005\u0015\t&B\u0001*T\u0003\u0019\t\u0007/Y2iK*\tA+A\u0002pe\u001eL!A\u0016'\u0003\u001b-\u000bgm[1Qe>$WoY3s!\r9\u0002LW\u0005\u00033b\u0011Q!\u0011:sCf\u0004\"aF.\n\u0005qC\"\u0001\u0002\"zi\u0016DaA\u0018\u0001!\u0002\u0013\u0011\u0015a\u0006;sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM]:!\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005\fa\u0003\u001e:b]N\f7\r^5p]\u0006d7i\u001c8tk6,'o]\u000b\u0002EB\u00191\tS2\u0011\t\u0011<wkV\u0007\u0002K*\u0011aMT\u0001\tG>t7/^7fe&\u0011\u0001.\u001a\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\t\r)\u0004\u0001\u0015!\u0003c\u0003]!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001c\b\u0005C\u0004m\u0001\t\u0007I\u0011A1\u000239|g\u000e\u0016:b]N\f7\r^5p]\u0006d7i\u001c8tk6,'o\u001d\u0005\u0007]\u0002\u0001\u000b\u0011\u00022\u000259|g\u000e\u0016:b]N\f7\r^5p]\u0006d7i\u001c8tk6,'o\u001d\u0011\t\u000bA\u0004A\u0011I9\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012A\u001d\t\u0004gR4X\"\u0001$\n\u0005U4%aA*fcB\u0011qO_\u0007\u0002q*\u0011\u0011\u0010B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005mD(aC&bM.\f7i\u001c8gS\u001eDQ! \u0001\u0005By\fQa]3u+B$\u0012a \t\u0004/\u0005\u0005\u0011bAA\u00021\t!QK\\5uQ\ra\u0018q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB*\u0002\u000b),h.\u001b;\n\t\u0005E\u00111\u0002\u0002\u0007\u0005\u00164wN]3\t\r\u0005U\u0001\u0001\"\u0011\u007f\u0003!!X-\u0019:E_^t\u0007\u0006BA\n\u00033\u0001B!!\u0003\u0002\u001c%!\u0011QDA\u0006\u0005\u0015\te\r^3s\u0011\u0019\t\t\u0003\u0001C\u0001}\u0006)B/Z:u\u0005\u0006\u001c\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:\u001c\b\u0006BA\u0010\u0003K\u0001B!!\u0003\u0002(%!\u0011\u0011FA\u0006\u0005\u0011!Vm\u001d;\t\r\u00055\u0002\u0001\"\u0001\u007f\u0003I\"Xm\u001d;SK\u0006$7i\\7nSR$X\rZ\"p]N,X.\u001a:TQ>,H\u000e\u001a(piN+W-\u00168eK\u000eLG-\u001a3ECR\f\u0007\u0006BA\u0016\u0003KAa!a\r\u0001\t\u0003q\u0018A\u000b;fgR$U\r\\1zK\u00124U\r^2i\u0013:\u001cG.\u001e3fg\u0006\u0013wN\u001d;fIR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0005\u0003c\t)\u0003\u0003\u0004\u0002:\u0001!\tA`\u0001\u001bi\u0016\u001cHoU3oI>3gm]3ug^KG\u000f[$s_V\u0004\u0018\n\u001a\u0015\u0005\u0003o\t)\u0003\u0003\u0004\u0002@\u0001!\tA`\u0001!i\u0016\u001cHoU3oI>3gm]3ug^KG\u000f[$s_V\u0004X*\u001a;bI\u0006$\u0018\r\u000b\u0003\u0002>\u0005\u0015\u0002bBA#\u0001\u0011%\u0011qI\u0001\u000bg\u0016tGm\u00144gg\u0016$HcA@\u0002J!A\u00111JA\"\u0001\u0004\ti%\u0001\u0004d_6l\u0017\u000e\u001e\t\t/\u0005=#*a\u0015d\u007f&\u0019\u0011\u0011\u000b\r\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004\u0003BA+\u00037r1aFA,\u0013\r\tI\u0006G\u0001\u0007!J,G-\u001a4\n\u0007Q\niFC\u0002\u0002ZaAa!!\u0019\u0001\t\u0003q\u0018a\u0005;fgR4UM\\2j]\u001e|enQ8n[&$\b\u0006BA0\u0003KAa!a\u001a\u0001\t\u0003q\u0018\u0001\u0007;fgR4UM\\2j]\u001e|enU3oI>3gm]3ug\"\"\u0011QMA\u0013\u0011\u0019\ti\u0007\u0001C\u0001}\u0006aC/Z:u\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0013:\u001cVM\u001c3PM\u001a\u001cX\r^:U_R\u0013\u0018M\\:bGRLwN\u001c\u0015\u0005\u0003W\n)\u0003\u0003\u0004\u0002t\u0001!\tA`\u0001\u0012i\u0016\u001cHOR3oG&twm\u00148TK:$\u0007\u0006BA9\u0003KAa!!\u001f\u0001\t\u0003q\u0018A\u0007;fgR4UM\\2j]\u001e|e.\u00113e!\u0006\u0014H/\u001b;j_:\u001c\b\u0006BA<\u0003KAa!a \u0001\t\u0003q\u0018A\t;fgR4UM\\2j]\u001e|e\u000e\u0016:b]N\f7\r^5p]\u0016C\b/\u001b:bi&|g\u000e\u000b\u0003\u0002~\u0005\u0015\u0002BBAC\u0001\u0011\u0005a0\u0001\u000fuKN$X*\u001e7uSBdW-T1sW\u0016\u00148o\u00148f\u0019\u0016\fG-\u001a:)\t\u0005\r\u0015Q\u0005\u0005\u0007\u0003\u0017\u0003A\u0011\u0001@\u0002IQ,7\u000f^\"p]N,7-\u001e;jm\u0016d\u0017PU;o\u0013:LG\u000f\u0016:b]N\f7\r^5p]ND\u0003\"!#\u0002&\u0005=\u0015\u0011S\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u00111\u0013\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014)\u0002\r\r|W.\\8o\u0013\u0011\ti*a&\u0003\u001d-\u000bgm[1Fq\u000e,\u0007\u000f^5p]\"1\u0011\u0011\u0015\u0001\u0005\u0002y\fA\u0004^3ti\u000e{W.\\5u)J\fgn]1di&|g\u000eV5nK>,H\u000f\u000b\u0005\u0002 \u0006\u0015\u0012qRASG\t\t9\u000b\u0005\u0003\u0002*\u0006=VBAAV\u0015\u0011\ti+a&\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\t\t,a+\u0003!QKW.Z8vi\u0016C8-\u001a9uS>t\u0007BBA[\u0001\u0011\u0005a0\u0001\u000euKN$()^7q)J\fgn]1di&|g.\u00197Fa>\u001c\u0007\u000e\u000b\u0003\u00024\u0006\u0015\u0002bBA^\u0001\u0011%\u0011QX\u0001(g\u0016tG\r\u0016:b]N\f7\r^5p]\u0006dW*Z:tC\u001e,7oV5uQZ\u000bG.^3SC:<W\rF\u0006\u0000\u0003\u007f\u000b\t-!2\u0002J\u00065\u0007BB'\u0002:\u0002\u0007!\n\u0003\u0005\u0002D\u0006e\u0006\u0019AA*\u0003\u0015!x\u000e]5d\u0011\u001d\t9-!/A\u0002Y\tQa\u001d;beRDq!a3\u0002:\u0002\u0007a#A\u0002f]\u0012D\u0001\"a4\u0002:\u0002\u0007\u0011\u0011[\u0001\u0010o&dGNQ3D_6l\u0017\u000e\u001e;fIB\u0019q#a5\n\u0007\u0005U\u0007DA\u0004C_>dW-\u00198\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\u0006Y1/\u001a:wKJ\u0004&o\u001c9t)\t\ti\u000e\u0005\u0003\u0002`\u0006\u0015XBAAq\u0015\r\t\u0019/M\u0001\u0005kRLG.\u0003\u0003\u0002h\u0006\u0005(A\u0003)s_B,'\u000f^5fg\"9\u00111\u001e\u0001\u0005\n\u00055\u0018aG2sK\u0006$XMU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'\u000fF\u0004d\u0003_\f\u00190a>\t\u0015\u0005E\u0018\u0011\u001eI\u0001\u0002\u0004\t\u0019&A\u0003he>,\b\u000fC\u0005\u0002v\u0006%\b\u0013!a\u0001-\u0005qQ.\u0019=Q_2d'+Z2pe\u0012\u001c\bBCA}\u0003S\u0004\n\u00111\u0001\u0002^\u0006)\u0001O]8qg\"9\u0011Q \u0001\u0005\n\u0005}\u0018!H2sK\u0006$XMU3bIVs7m\\7nSR$X\rZ\"p]N,X.\u001a:\u0015\u0007\r\u0014\t\u0001\u0003\u0005\u0002r\u0006m\b\u0019AA*\u0011\u001d\u0011)\u0001\u0001C\u0005\u0005\u000f\t1d\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014H#\u0003&\u0003\n\t5!q\u0003B\u000e\u0011!\u0011YAa\u0001A\u0002\u0005M\u0013a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\t\u0015\t=!1\u0001I\u0001\u0002\u0004\u0011\t\"\u0001\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\t\u0004/\tM\u0011b\u0001B\u000b1\t!Aj\u001c8h\u0011)\u0011IBa\u0001\u0011\u0002\u0003\u0007!\u0011C\u0001\u000b[\u0006D(\t\\8dW6\u001b\b\"\u0003B\u000f\u0005\u0007\u0001\n\u00111\u0001\u0017\u0003E!W\r\\5wKJLH+[7f_V$Xj\u001d\u0005\n\u0005C\u0001\u0011\u0013!C\u0005\u0005G\tQe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0015\"\u0006\u0002B\t\u0005OY#A!\u000b\u0011\t\t-\"QG\u0007\u0003\u0005[QAAa\f\u00032\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005gA\u0012AC1o]>$\u0018\r^5p]&!!q\u0007B\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005w\u0001\u0011\u0013!C\u0005\u0005G\tQe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\t\u0013\t}\u0002!%A\u0005\n\t\u0005\u0013!J2sK\u0006$X\r\u0016:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019EK\u0002\u0017\u0005OA\u0011Ba\u0012\u0001#\u0003%IA!\u0013\u0002K\r\u0014X-\u0019;f%\u0016\fGmQ8n[&$H/\u001a3D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\nTC\u0001B&U\u0011\t\u0019Fa\n\t\u0013\t=\u0003!%A\u0005\n\t\u0005\u0013!J2sK\u0006$XMU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011%\u0011\u0019\u0006AI\u0001\n\u0013\u0011)&A\u0013de\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u000b\u0016\u0005\u0003;\u00149\u0003")
public class TransactionsTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public int numServers() {
        return this.numServers;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionsTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.kafka$api$TransactionsTest$$serverProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(this.topic1(), this.numPartitions(), this.numServers(), topicConfig);
        this.createTopic(this.topic2(), this.numPartitions(), this.numServers(), topicConfig);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.transactionalProducerCount()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionsTest $outer;

            public final KafkaProducer<byte[], byte[]> apply(int _) {
                return this.$outer.kafka$api$TransactionsTest$$createTransactionalProducer("transactional-producer", this.$outer.kafka$api$TransactionsTest$$createTransactionalProducer$default$2(), this.$outer.kafka$api$TransactionsTest$$createTransactionalProducer$default$3(), this.$outer.kafka$api$TransactionsTest$$createTransactionalProducer$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.transactionalConsumerCount()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionsTest $outer;

            public final KafkaConsumer<byte[], byte[]> apply(int _) {
                return this.$outer.kafka$api$TransactionsTest$$createReadCommittedConsumer("transactional-group", this.$outer.kafka$api$TransactionsTest$$createReadCommittedConsumer$default$2(), this.$outer.kafka$api$TransactionsTest$$createReadCommittedConsumer$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nonTransactionalConsumerCount()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionsTest $outer;

            public final KafkaConsumer<byte[], byte[]> apply(int _) {
                return this.$outer.kafka$api$TransactionsTest$$createReadUncommittedConsumer("non-transactional-group");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    @After
    public void tearDown() {
        this.transactionalProducers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$2) {
                x$2.close();
            }
        });
        this.transactionalConsumers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaConsumer<byte[], byte[]> x$3) {
                x$3.close();
            }
        });
        this.nonTransactionalConsumers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaConsumer<byte[], byte[]> x$4) {
                x$4.close();
            }
        });
        super.tearDown();
    }

    @Test
    public void testBasicTransactions() {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        unCommittedConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        Seq records2 = TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        records2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConsumerRecord<byte[], byte[]> record) {
                return TestUtils$.MODULE$.assertCommittedAndGetValue(record);
            }
        });
        Seq allRecords2 = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3", "4"})).toSet();
        allRecords2.foreach((Function1)new Serializable(this, expectedValues){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set expectedValues$1;

            public final void apply(ConsumerRecord<byte[], byte[]> record) {
                Assert.assertTrue((boolean)this.expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString(record)));
            }
            {
                this.expectedValues$1 = expectedValues$1;
            }
        });
    }

    @Test
    public void testReadCommittedConsumerShouldNotSeeUndecidedData() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.kafka$api$TransactionsTest$$createTransactionalProducer("other", this.kafka$api$TransactionsTest$$createTransactionalProducer$default$2(), this.kafka$api$TransactionsTest$$createTransactionalProducer$default$3(), this.kafka$api$TransactionsTest$$createTransactionalProducer$default$4());
        KafkaConsumer readCommittedConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer readUncommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        readUncommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, TestUtils$.MODULE$.consumeRecords$default$3());
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assert.assertEquals((long)2L, (long)readUncommittedOffsetsForTimes.size());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        readCommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        Seq records2 = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        records2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ConsumerRecord<byte[], byte[]> record) {
                Assert.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
                Assert.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
            }
        });
        Assert.assertEquals((long)2L, (long)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(readCommittedConsumer.assignment()).asScala()).foreach((Function1)new Serializable(this, readCommittedConsumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer readCommittedConsumer$1;

            public final void apply(TopicPartition tp) {
                Assert.assertEquals((long)1L, (long)this.readCommittedConsumer$1.position(tp));
            }
            {
                this.readCommittedConsumer$1 = readCommittedConsumer$1;
            }
        });
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransaction() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.kafka$api$TransactionsTest$$createTransactionalProducer("other", this.kafka$api$TransactionsTest$$createTransactionalProducer$default$2(), this.kafka$api$TransactionsTest$$createTransactionalProducer$default$3(), this.kafka$api$TransactionsTest$$createTransactionalProducer$default$4());
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        producer1.abortTransaction();
        producer2.commitTransaction();
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        Properties x$31 = consumerProps;
        String x$32 = this.createReadCommittedConsumer$default$1();
        int x$33 = this.kafka$api$TransactionsTest$$createReadCommittedConsumer$default$2();
        KafkaConsumer<byte[], byte[]> readCommittedConsumer = this.kafka$api$TransactionsTest$$createReadCommittedConsumer(x$32, x$33, x$31);
        readCommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 0)}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records2 = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        Assert.assertEquals((long)2L, (long)records2.size());
        ConsumerRecord first = (ConsumerRecord)records2.head();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assert.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assert.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records2.last();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assert.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assert.assertEquals((long)3L, (long)second.offset());
    }

    @Test
    public void testSendOffsetsWithGroupId() {
        this.sendOffset((Function3<KafkaProducer<byte[], byte[]>, String, KafkaConsumer<byte[], byte[]>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> producer, String groupId, KafkaConsumer<byte[], byte[]> consumer) {
                producer.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions(consumer)).asJava(), groupId);
            }
        });
    }

    @Test
    public void testSendOffsetsWithGroupMetadata() {
        this.sendOffset((Function3<KafkaProducer<byte[], byte[]>, String, KafkaConsumer<byte[], byte[]>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> producer, String x$5, KafkaConsumer<byte[], byte[]> consumer) {
                producer.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions(consumer)).asJava(), consumer.groupMetadata());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void sendOffset(Function3<KafkaProducer<byte[], byte[]>, String, KafkaConsumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> consumer = this.kafka$api$TransactionsTest$$createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, this.kafka$api$TransactionsTest$$createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        producer.initTransactions();
        BooleanRef shouldCommit = BooleanRef.create((boolean)false);
        IntRef recordsProcessed = IntRef.create((int)0);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records2 = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records2.foreach((Function1)new Serializable(this, producer, shouldCommit){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TransactionsTest $outer;
                    private final KafkaProducer producer$1;
                    private final BooleanRef shouldCommit$1;

                    public final Future<RecordMetadata> apply(ConsumerRecord<byte[], byte[]> record) {
                        String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                        String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                        return this.producer$1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.$outer.topic2(), null, key, value, this.shouldCommit$1.elem));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$1 = producer$1;
                        this.shouldCommit$1 = shouldCommit$1;
                    }
                });
                commit.apply((Object)producer, (Object)consumerGroupId, consumer);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records2.size();
                    this.debug((Function0<String>)new Serializable(this, recordsProcessed, records2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ TransactionsTest $outer;
                        private final IntRef recordsProcessed$1;
                        private final Seq records$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed transaction.. Last committed record: ", ". Num "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String((byte[])((ConsumerRecord)this.records$1.last()).value(), StandardCharsets.UTF_8)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"records written to ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic2(), BoxesRunTime.boxToInteger((int)this.recordsProcessed$1.elem)}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.recordsProcessed$1 = recordsProcessed$1;
                            this.records$1 = records$1;
                        }
                    });
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)new Serializable(this, recordsProcessed, records2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TransactionsTest $outer;
                    private final IntRef recordsProcessed$1;
                    private final Seq records$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aborted transaction Last committed record: ", ". Num "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String((byte[])((ConsumerRecord)this.records$1.last()).value(), StandardCharsets.UTF_8)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"records written to ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic2(), BoxesRunTime.boxToInteger((int)this.recordsProcessed$1.elem)}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.recordsProcessed$1 = recordsProcessed$1;
                        this.records$1 = records$1;
                    }
                });
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        consumer.close();
        KafkaConsumer verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ConsumerRecord<byte[], byte[]> record) {
                return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue(record))).toInt();
            }
        }, Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " values in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numSeedMessages), this.topic2()})), (long)numSeedMessages, (long)valueSeq.size());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " unique messages in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)valueSeq.size()), this.topic2()})), (long)valueSeq.size(), (long)valueSet.size());
    }

    @Test
    public void testFencingOnCommit() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        try {
            producer1.commitTransaction();
            throw Assertions$.MODULE$.fail("Should not be able to commit transactions from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        }
        catch (Exception exception) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)exception, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        }
        catch (ProducerFencedException producerFencedException) {
            producer2.commitTransaction();
            Seq records2 = TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
            records2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ConsumerRecord<byte[], byte[]> record) {
                    return TestUtils$.MODULE$.assertCommittedAndGetValue(record);
                }
            });
            return;
        }
    }

    @Test
    public void testFencingOnSendOffsets() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        try {
            producer1.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foobartopic", 0)), (Object)new OffsetAndMetadata(110L))}))).asJava(), "foobarGroup");
            throw Assertions$.MODULE$.fail("Should not be able to send offsets from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        }
        catch (Exception exception) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)exception, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        }
        catch (ProducerFencedException producerFencedException) {
            producer2.commitTransaction();
            Seq records2 = TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
            records2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ConsumerRecord<byte[], byte[]> record) {
                    return TestUtils$.MODULE$.assertCommittedAndGetValue(record);
                }
            });
            return;
        }
    }

    @Test
    public void testOffsetMetadataInSendOffsetsToTransaction() {
        TopicPartition tp = new TopicPartition(this.topic1(), 0);
        String groupId = "group";
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> consumer = this.kafka$api$TransactionsTest$$createReadCommittedConsumer(groupId, this.kafka$api$TransactionsTest$$createReadCommittedConsumer$default$2(), this.kafka$api$TransactionsTest$$createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L, Optional.of(Predef$.MODULE$.int2Integer(15)), "some metadata");
        producer.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetAndMetadata)}))).asJava(), groupId);
        producer.commitTransaction();
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        producer2.initTransactions();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, consumer, offsetAndMetadata){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$1;
            private final KafkaConsumer consumer$1;
            private final OffsetAndMetadata offsetAndMetadata$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.offsetAndMetadata$1.equals(this.consumer$1.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$1}))).asJava()).get(this.tp$1));
            }
            {
                this.tp$1 = tp$1;
                this.consumer$1 = consumer$1;
                this.offsetAndMetadata$1 = offsetAndMetadata$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "cannot read committed offset";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testFencingOnSend() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get();
        try {
            Future result = producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false));
            RecordMetadata recordMetadata = (RecordMetadata)result.get();
            this.error((Function0<String>)new Serializable(this, recordMetadata){
                public static final long serialVersionUID = 0L;
                private final RecordMetadata recordMetadata$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missed a producer fenced exception when writing to ", "-", ". Grab the logs!!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.recordMetadata$1.topic(), BoxesRunTime.boxToInteger((int)this.recordMetadata$1.partition())}));
                }
                {
                    this.recordMetadata$1 = recordMetadata$1;
                }
            });
            this.servers().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransactionsTest $outer;

                public final void apply(KafkaServer server) {
                    this.$outer.error((Function0<String>)new Serializable(this, server){
                        public static final long serialVersionUID = 0L;
                        private final KafkaServer server$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log dirs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((IterableLike)this.server$1.logManager().liveLogDirs().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(File x$6) {
                                    return x$6.getAbsolutePath();
                                }
                            }, Seq$.MODULE$.canBuildFrom())).head()}));
                        }
                        {
                            this.server$1 = server$1;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw Assertions$.MODULE$.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        }
        catch (Exception exception) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)exception, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        producer2.commitTransaction();
        Seq records2 = TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        records2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConsumerRecord<byte[], byte[]> record) {
                return TestUtils$.MODULE$.assertCommittedAndGetValue(record);
            }
        });
    }

    @Test
    public void testFencingOnAddPartitions() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            Future result = producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false));
            RecordMetadata recordMetadata = (RecordMetadata)result.get();
            this.error((Function0<String>)new Serializable(this, recordMetadata){
                public static final long serialVersionUID = 0L;
                private final RecordMetadata recordMetadata$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missed a producer fenced exception when writing to ", "-", ". Grab the logs!!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.recordMetadata$2.topic(), BoxesRunTime.boxToInteger((int)this.recordMetadata$2.partition())}));
                }
                {
                    this.recordMetadata$2 = recordMetadata$2;
                }
            });
            this.servers().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransactionsTest $outer;

                public final void apply(KafkaServer server) {
                    this.$outer.error((Function0<String>)new Serializable(this, server){
                        public static final long serialVersionUID = 0L;
                        private final KafkaServer server$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log dirs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((IterableLike)this.server$2.logManager().liveLogDirs().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(File x$7) {
                                    return x$7.getAbsolutePath();
                                }
                            }, Seq$.MODULE$.canBuildFrom())).head()}));
                        }
                        {
                            this.server$2 = server$2;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw Assertions$.MODULE$.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        }
        catch (Exception exception) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)exception, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (ProducerFencedException producerFencedException) {}
        producer2.commitTransaction();
        Seq records2 = TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        records2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConsumerRecord<byte[], byte[]> record) {
                return TestUtils$.MODULE$.assertCommittedAndGetValue(record);
            }
        });
    }

    @Test
    public void testFencingOnTransactionExpiration() {
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$TransactionsTest$$createTransactionalProducer("expiringProducer", 100L, this.kafka$api$TransactionsTest$$createTransactionalProducer$default$3(), this.kafka$api$TransactionsTest$$createTransactionalProducer$default$4());
        producer.initTransactions();
        producer.beginTransaction();
        RecordMetadata firstMessageResult = (RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false)).get();
        Assert.assertTrue((boolean)firstMessageResult.hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get();
            throw Assertions$.MODULE$.fail("should have raised a ProducerFencedException since the transaction has expired", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (ProducerFencedException producerFencedException) {}
        KafkaConsumer nonTransactionalConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        nonTransactionalConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        Seq records2 = TestUtils$.MODULE$.consumeRecords(nonTransactionalConsumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        Assert.assertEquals((long)1L, (long)records2.size());
        Assert.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records2.head())));
        KafkaConsumer transactionalConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        Seq transactionalRecords = TestUtils$.MODULE$.consumeRecordsFor(transactionalConsumer, 1000L);
        Assert.assertTrue((boolean)transactionalRecords.isEmpty());
    }

    @Test
    public void testMultipleMarkersOneLeader() {
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(topicWith10Partitions, 10, this.numServers(), topicConfig);
        this.createTopic(topicWith10PartitionsAndOneReplica, 10, 1, new Properties());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicWith10PartitionsAndOneReplica, topicWith10Partitions}))).asJava());
        unCommittedConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicWith10PartitionsAndOneReplica, topicWith10Partitions}))).asJava());
        Seq records2 = TestUtils$.MODULE$.consumeRecords(consumer, 1000, TestUtils$.MODULE$.consumeRecords$default$3());
        records2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConsumerRecord<byte[], byte[]> record) {
                return TestUtils$.MODULE$.assertCommittedAndGetValue(record);
            }
        });
        Seq allRecords2 = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = ((TraversableOnce)package$.MODULE$.Range().apply(0, 11000).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$8) {
                return ((Object)BoxesRunTime.boxToInteger((int)x$8)).toString();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        allRecords2.foreach((Function1)new Serializable(this, expectedValues){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set expectedValues$2;

            public final void apply(ConsumerRecord<byte[], byte[]> record) {
                Assert.assertTrue((boolean)this.expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString(record)));
            }
            {
                this.expectedValues$2 = expectedValues$2;
            }
        });
    }

    @Test(expected=KafkaException.class)
    public void testConsecutivelyRunInitTransactions() {
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$TransactionsTest$$createTransactionalProducer("normalProducer", this.kafka$api$TransactionsTest$$createTransactionalProducer$default$2(), this.kafka$api$TransactionsTest$$createTransactionalProducer$default$3(), this.kafka$api$TransactionsTest$$createTransactionalProducer$default$4());
        producer.initTransactions();
        producer.initTransactions();
        throw Assertions$.MODULE$.fail("Should have raised a KafkaException", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=TimeoutException.class)
    public void testCommitTransactionTimeout() {
        String x$34 = "transactionalProducer";
        long x$35 = 1000L;
        long x$36 = this.kafka$api$TransactionsTest$$createTransactionalProducer$default$2();
        int x$37 = this.kafka$api$TransactionsTest$$createTransactionalProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$TransactionsTest$$createTransactionalProducer(x$34, x$36, x$35, x$37);
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(new ProducerRecord(this.topic1(), (Object)"foobar".getBytes()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.servers().size()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionsTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.killBroker(i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        try {
            producer.commitTransaction();
        }
        catch (Throwable throwable) {
            void var1_5;
            var1_5.close(Duration.ZERO);
            throw throwable;
        }
        producer.close(Duration.ZERO);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBumpTransactionalEpoch() {
        String x$38 = "transactionalProducer";
        int x$39 = 5000;
        long x$40 = this.kafka$api$TransactionsTest$$createTransactionalProducer$default$2();
        long x$41 = this.kafka$api$TransactionsTest$$createTransactionalProducer$default$3();
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$TransactionsTest$$createTransactionalProducer(x$38, x$40, x$41, x$39);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        try {
            String testTopic = "test-topic";
            this.createTopic(testTopic, this.numPartitions(), 1, new Properties());
            int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)this.servers(), new TopicPartition(testTopic, 0), TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", true));
            producer.commitTransaction();
            LogManager qual$1 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
            TopicPartition x$42 = new TopicPartition(testTopic, 0);
            boolean x$43 = qual$1.getLog$default$2();
            ProducerStateEntry producerStateEntry = (ProducerStateEntry)((Tuple2)((AbstractLog)qual$1.getLog(x$42, x$43).get()).producerStateManager().activeProducers().head())._2();
            long producerId = producerStateEntry.producerId();
            short initialProducerEpoch = producerStateEntry.producerEpoch();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", false));
            this.killBroker(partitionLeader);
            Future failedFuture = producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", false));
            Thread.sleep(6000L);
            this.restartDeadBrokers();
            TestUtils.assertFutureThrows((Future)failedFuture, TimeoutException.class);
            producer.abortTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "1", "1", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", true));
            producer.commitTransaction();
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2(), testTopic}))).asJava());
            Seq records2 = TestUtils$.MODULE$.consumeRecords(consumer, 5, TestUtils$.MODULE$.consumeRecords$default$3());
            records2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ConsumerRecord<byte[], byte[]> record) {
                    return TestUtils$.MODULE$.assertCommittedAndGetValue(record);
                }
            });
            LogManager qual$2 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
            TopicPartition x$44 = new TopicPartition(testTopic, 0);
            boolean x$45 = qual$2.getLog$default$2();
            producerStateEntry = (ProducerStateEntry)((AbstractLog)qual$2.getLog(x$44, x$45).get()).producerStateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
            Assert.assertTrue((producerStateEntry.producerEpoch() > initialProducerEpoch ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var1_5;
            var1_5.close(Duration.ZERO);
            throw throwable;
        }
        producer.close(Duration.ZERO);
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start2, int end, boolean willBeCommitted) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).foreach((Function1)new Serializable(this, producer, topic, willBeCommitted){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$2;
            private final String topic$1;
            private final boolean willBeCommitted$1;

            public final Future<RecordMetadata> apply(int i) {
                String x$46 = this.topic$1;
                Object x$47 = null;
                String x$48 = ((Object)BoxesRunTime.boxToInteger((int)i)).toString();
                boolean x$49 = this.willBeCommitted$1;
                String x$50 = ((Object)BoxesRunTime.boxToInteger((int)i)).toString();
                return this.producer$2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(x$46, null, x$50, x$48, x$49));
            }
            {
                this.producer$2 = producer$2;
                this.topic$1 = topic$1;
                this.willBeCommitted$1 = willBeCommitted$1;
            }
        });
        producer.flush();
    }

    /*
     * WARNING - void declaration
     */
    public Properties kafka$api$TransactionsTest$$serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return var1_1;
    }

    public KafkaConsumer<byte[], byte[]> kafka$api$TransactionsTest$$createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        String x$9 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$10 = group;
        boolean x$11 = false;
        boolean x$12 = true;
        int x$13 = maxPollRecords;
        String x$14 = TestUtils$.MODULE$.createConsumer$default$3();
        SecurityProtocol x$15 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$16 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$17 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$18 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$19 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$9, x$10, x$14, x$11, x$12, x$13, x$15, x$16, x$17, x$18, x$19);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    public int kafka$api$TransactionsTest$$createReadCommittedConsumer$default$2() {
        return 500;
    }

    public Properties kafka$api$TransactionsTest$$createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaConsumer<byte[], byte[]> kafka$api$TransactionsTest$$createReadUncommittedConsumer(String group) {
        void var2_13;
        String x$20 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$21 = group;
        boolean x$22 = false;
        String x$23 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$24 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$25 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$26 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$27 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$28 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$29 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$30 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$20, x$21, x$23, x$22, x$24, x$25, x$26, x$27, x$28, x$29, x$30);
        this.nonTransactionalConsumers().$plus$eq(consumer);
        return var2_13;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$TransactionsTest$$createTransactionalProducer(String transactionalId, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs) {
        String x$51 = transactionalId;
        Buffer<KafkaServer> x$52 = this.servers();
        long x$53 = transactionTimeoutMs;
        long x$54 = maxBlockMs;
        int x$55 = deliveryTimeoutMs;
        int x$56 = TestUtils$.MODULE$.createTransactionalProducer$default$3();
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(x$51, (Seq<KafkaServer>)x$52, x$56, x$53, x$54, x$55);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    public long kafka$api$TransactionsTest$$createTransactionalProducer$default$2() {
        return 60000L;
    }

    public long kafka$api$TransactionsTest$$createTransactionalProducer$default$3() {
        return 60000L;
    }

    public int kafka$api$TransactionsTest$$createTransactionalProducer$default$4() {
        return 120000;
    }

    public TransactionsTest() {
        this.numServers = 3;
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }
}

