/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker;
import kafka.cluster.DelayedOperations;
import kafka.cluster.ObserverPartitionTest$;
import kafka.cluster.Partition;
import kafka.cluster.PartitionStateStore;
import kafka.log.AbstractLog;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfluentObserverTest;
import kafka.server.ConfluentObserverTest$;
import kafka.server.Defaults$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.tier.TierReplicaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0005\u001d\u0011Qc\u00142tKJ4XM\u001d)beRLG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%\t!F\u0001\u0005i&lW-F\u0001\u0017!\t9\"$D\u0001\u0019\u0015\tIB!A\u0003vi&d7/\u0003\u0002\u001c1\tAQj\\2l)&lW\r\u0003\u0004\u001e\u0001\u0001\u0006IAF\u0001\u0006i&lW\r\t\u0005\b?\u0001\u0011\r\u0011\"\u0001!\u0003!\u0011'o\\6fe&#W#A\u0011\u0011\u0005%\u0011\u0013BA\u0012\u000b\u0005\rIe\u000e\u001e\u0005\u0007K\u0001\u0001\u000b\u0011B\u0011\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0003\"C\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0001)\u0003%awnZ\"p]\u001aLw-F\u0001*!\tQS&D\u0001,\u0015\taC!A\u0002m_\u001eL!AL\u0016\u0003\u00131{wmQ8oM&<\u0007\"\u0003\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u00012\u00035awnZ\"p]\u001aLwm\u0018\u0013fcR\u0011!'\u000e\t\u0003\u0013MJ!\u0001\u000e\u0006\u0003\tUs\u0017\u000e\u001e\u0005\bm=\n\t\u00111\u0001*\u0003\rAH%\r\u0005\u0007q\u0001\u0001\u000b\u0015B\u0015\u0002\u00151|wmQ8oM&<\u0007\u0005C\u0005;\u0001\u0001\u0007\t\u0019!C\u0001w\u0005QAn\\4NC:\fw-\u001a:\u0016\u0003q\u0002\"AK\u001f\n\u0005yZ#A\u0003'pO6\u000bg.Y4fe\"I\u0001\t\u0001a\u0001\u0002\u0004%\t!Q\u0001\u000fY><W*\u00198bO\u0016\u0014x\fJ3r)\t\u0011$\tC\u00047\u007f\u0005\u0005\t\u0019\u0001\u001f\t\r\u0011\u0003\u0001\u0015)\u0003=\u0003-awnZ'b]\u0006<WM\u001d\u0011\t\u0013\u0019\u0003\u0001\u0019!a\u0001\n\u00039\u0015A\u0002;na\u0012K'/F\u0001I!\tIe*D\u0001K\u0015\tYE*\u0001\u0002j_*\tQ*\u0001\u0003kCZ\f\u0017BA(K\u0005\u00111\u0015\u000e\\3\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0016A\u0003;na\u0012K'o\u0018\u0013fcR\u0011!g\u0015\u0005\bmA\u000b\t\u00111\u0001I\u0011\u0019)\u0006\u0001)Q\u0005\u0011\u00069A/\u001c9ESJ\u0004\u0003\"C,\u0001\u0001\u0004\u0005\r\u0011\"\u0001Y\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001Z!\t\u0011\",\u0003\u0002\\\u0005\tI\u0001+\u0019:uSRLwN\u001c\u0005\n;\u0002\u0001\r\u00111A\u0005\u0002y\u000bQ\u0002]1si&$\u0018n\u001c8`I\u0015\fHC\u0001\u001a`\u0011\u001d1D,!AA\u0002eCa!\u0019\u0001!B\u0013I\u0016A\u00039beRLG/[8oA!91\r\u0001b\u0001\n\u0003!\u0017AC:uCR,7\u000b^8sKV\tQ\r\u0005\u0002\u0013M&\u0011qM\u0001\u0002\u0014!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f'R|'/\u001a\u0005\u0007S\u0002\u0001\u000b\u0011B3\u0002\u0017M$\u0018\r^3Ti>\u0014X\r\t\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0003=!W\r\\1z\u001fB,'/\u0019;j_:\u001cX#A7\u0011\u0005Iq\u0017BA8\u0003\u0005E!U\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u001d\u0005\u0007c\u0002\u0001\u000b\u0011B7\u0002!\u0011,G.Y=Pa\u0016\u0014\u0018\r^5p]N\u0004\u0003bB:\u0001\u0005\u0004%\t\u0001^\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003U\u0004\"A^=\u000e\u0003]T!\u0001\u001f\u0003\u0002\rM,'O^3s\u0013\tQxOA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0005\u0007y\u0002\u0001\u000b\u0011B;\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA!9a\u0010\u0001b\u0001\n\u0003y\u0018!E8gMN,Go\u00115fG.\u0004x.\u001b8ugV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA<\u0002\u0017\rDWmY6q_&tGo]\u0005\u0005\u0003\u0017\t)AA\tPM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oiND\u0001\"a\u0004\u0001A\u0003%\u0011\u0011A\u0001\u0013_\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R\u001c\b\u0005C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0001\u0002\u0016\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA\f!\u0011\tI\"!\u000b\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\taaY8n[>t'bA\u0003\u0002\")!\u00111EA\u0013\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qE\u0001\u0004_J<\u0017\u0002BA\u0016\u00037\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\f\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003bBA\u001a\u0001\u0011\u0005\u0011QG\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002e!\"\u0011\u0011GA\u001d!\u0011\tY$!\u0011\u000e\u0005\u0005u\"\u0002BA \u0003K\tQA[;oSRLA!a\u0011\u0002>\t1!)\u001a4pe\u0016Dq!a\u0012\u0001\t\u0003\t)$\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\t)%a\u0013\u0011\t\u0005m\u0012QJ\u0005\u0005\u0003\u001f\niDA\u0003BMR,'\u000fC\u0004\u0002T\u0001!\t!!\u000e\u0002]Q,7\u000f\u001e%jO\"<\u0016\r^3s[\u0006\u00148.\u00138de\u0016\f7/Z:XSRDw.\u001e;PEN,'O^3s\r\u0016$8\r\u001b\u0015\u0005\u0003#\n9\u0006\u0005\u0003\u0002<\u0005e\u0013\u0002BA.\u0003{\u0011A\u0001V3ti\u001e9\u0011q\f\u0002\t\u0002\u0005\u0005\u0014!F(cg\u0016\u0014h/\u001a:QCJ$\u0018\u000e^5p]R+7\u000f\u001e\t\u0004%\u0005\rdAB\u0001\u0003\u0011\u0003\t)gE\u0002\u0002d!AqaDA2\t\u0003\tI\u0007\u0006\u0002\u0002b!A\u0011QNA2\t\u0003\ty'A\u0006tK\u0016$Gj\\4ECR\fGc\u0002\u001a\u0002r\u0005e\u0014Q\u0010\u0005\bY\u0005-\u0004\u0019AA:!\rQ\u0013QO\u0005\u0004\u0003oZ#aC!cgR\u0014\u0018m\u0019;M_\u001eDq!a\u001f\u0002l\u0001\u0007\u0011%\u0001\u0006ok6\u0014VmY8sINDq!a \u0002l\u0001\u0007\u0011%A\u0006mK\u0006$WM]#q_\u000eD\u0007\u0002CAB\u0003G\"\t!!\"\u0002'\r\u0014X-\u0019;f\u0019><\u0007K]8qKJ$\u0018.Z:\u0015\t\u0005\u001d\u00151\u0013\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011Q\u0012'\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003#\u000bYI\u0001\u0006Qe>\u0004XM\u001d;jKND\u0001\"!&\u0002\u0002\u0002\u0007\u0011qS\u0001\n_Z,'O]5eKN\u0004\u0002\"!'\u0002 \u0006\u0015\u0016Q\u0015\b\u0004\u0013\u0005m\u0015bAAO\u0015\u00051\u0001K]3eK\u001aLA!!)\u0002$\n\u0019Q*\u00199\u000b\u0007\u0005u%\u0002\u0005\u0003\u0002\u001a\u0006\u001d\u0016\u0002BAU\u0003G\u0013aa\u0015;sS:<\u0007")
public final class ObserverPartitionTest {
    private final MockTime time = new MockTime();
    private final int brokerId;
    private LogConfig logConfig;
    private LogManager logManager;
    private File tmpDir;
    private Partition partition;
    private final PartitionStateStore stateStore = (PartitionStateStore)Mockito.mock(PartitionStateStore.class);
    private final DelayedOperations delayOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private final TopicPartition topicPartition = new TopicPartition("test-observer", 0);

    public static Properties createLogProperties(scala.collection.immutable.Map<String, String> map) {
        return ObserverPartitionTest$.MODULE$.createLogProperties(map);
    }

    public static void seedLogData(AbstractLog abstractLog, int n, int n2) {
        ObserverPartitionTest$.MODULE$.seedLogData(abstractLog, n, n2);
    }

    public MockTime time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public PartitionStateStore stateStore() {
        return this.stateStore;
    }

    public DelayedOperations delayOperations() {
        return this.delayOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Before
    public void setup() {
        this.logConfig_$eq(new LogConfig((Map)ObserverPartitionTest$.MODULE$.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(2, "replica"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(1, "observer"))))})))), LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        File logDir1 = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        int x$9 = CleanerConfig$.MODULE$.apply$default$9();
        String x$10 = CleanerConfig$.MODULE$.apply$default$10();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{logDir1}))), this.logConfig(), new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9, x$10), this.time(), TestUtils$.MODULE$.createLogManager$default$5()));
        this.logManager().startup();
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayOperations(), this.metadataCache(), this.logManager(), (Option)new Some(Mockito.mock(TierReplicaManager.class))));
        Mockito.when((Object)this.stateStore().fetchTopicConfig()).thenReturn((Object)ObserverPartitionTest$.MODULE$.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    @After
    public void tearDown() {
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testHighWatermarkIncreasesWithoutObserverFetch() {
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int followerId = this.brokerId() + 1;
        int observerId = followerId + 1;
        List replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(followerId), Predef$.MODULE$.int2Integer(observerId)}))).asJava();
        List isr = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(followerId)}))).asJava();
        Mockito.when((Object)this.metadataCache().getAliveBroker(this.brokerId())).thenReturn((Object)new Some((Object)new Broker(this.brokerId(), (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)"replica"))));
        Mockito.when((Object)this.metadataCache().getAliveBroker(followerId)).thenReturn((Object)new Some((Object)new Broker(followerId, (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)"replica"))));
        Mockito.when((Object)this.metadataCache().getAliveBroker(observerId)).thenReturn((Object)new Some((Object)new Broker(observerId, (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)"observer"))));
        LogManager qual$1 = this.logManager();
        TopicPartition x$11 = this.topicPartition();
        Serializable x$12 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ObserverPartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$13 = qual$1.getOrCreateLog$default$3();
        boolean x$14 = qual$1.getOrCreateLog$default$4();
        AbstractLog log2 = qual$1.getOrCreateLog(x$11, (Function0)x$12, x$13, x$14);
        ObserverPartitionTest$.MODULE$.seedLogData(log2, 6, 4);
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topicPartition().topic()).setPartitionIndex(this.topicPartition().partition()).setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setObservers((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(observerId)}))).asJava()).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertTrue((String)"Leader didn't recognize replica", (boolean)this.partition().updateFollowerFetchState(observerId, new LogOffsetMetadata(3L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 3L, this.partition().localLogOrException().highWatermark()));
        Assert.assertTrue((String)"Leader didn't recognize replica", (boolean)this.partition().updateFollowerFetchState(followerId, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 5L, this.partition().localLogOrException().highWatermark()));
        Assert.assertEquals((String)"Expect the highwatermark to only include followers", (long)this.partition().localLogOrException().highWatermark(), (long)5L);
    }

    public ObserverPartitionTest() {
        this.brokerId = 101;
    }
}

