/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.admin.BrokerMetadata;
import kafka.cluster.Observer$;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001\u001d\u0011Ab\u00142tKJ4XM\u001d+fgRT!a\u0001\u0003\u0002\u000f\rdWo\u001d;fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0013)\u0012\u0001\n;pa&\u001cw+\u001b;i\u001f\n\u001cXM\u001d<feBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;\u0016\u0003Y\u00012!C\f\u001a\u0013\tA\"B\u0001\u0004PaRLwN\u001c\t\u00035ui\u0011a\u0007\u0006\u00039\u0011\taaY8n[>t\u0017B\u0001\u0010\u001c\u00059!v\u000e]5d!2\f7-Z7f]RDa\u0001\t\u0001!\u0002\u00131\u0012!\n;pa&\u001cw+\u001b;i\u001f\n\u001cXM\u001d<feBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;!\u0011\u001d\u0011\u0003A1A\u0005\nU\tq\u0005^8qS\u000e<\u0016\u000e\u001e5Uo>|%m]3sm\u0016\u0014\b\u000b\\1dK6,g\u000e^\"p]N$(/Y5oi\"1A\u0005\u0001Q\u0001\nY\t\u0001\u0006^8qS\u000e<\u0016\u000e\u001e5Uo>|%m]3sm\u0016\u0014\b\u000b\\1dK6,g\u000e^\"p]N$(/Y5oi\u0002BqA\n\u0001C\u0002\u0013%Q#A\u0010u_BL7mV5uQ>,Ho\u00142tKJ4XM]:D_:\u001cHO]1j]RDa\u0001\u000b\u0001!\u0002\u00131\u0012\u0001\t;pa&\u001cw+\u001b;i_V$xJY:feZ,'o]\"p]N$(/Y5oi\u0002BqA\u000b\u0001C\u0002\u0013%1&\u0001\u000bbY2\u0014%o\\6feN\fE\u000f\u001e:jEV$Xm]\u000b\u0002YA!QF\r\u001b8\u001b\u0005q#BA\u00181\u0003%IW.\\;uC\ndWM\u0003\u00022\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Mr#aA'baB\u0011\u0011\"N\u0005\u0003m)\u00111!\u00138u!\u0011A\u0014H\u000f\u001e\u000e\u0003AJ!a\r\u0019\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014\u0001\u00027b]\u001eT\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002By\t11\u000b\u001e:j]\u001eDaa\u0011\u0001!\u0002\u0013a\u0013!F1mY\n\u0013xn[3sg\u0006#HO]5ckR,7\u000f\t\u0005\u0006\u000b\u0002!\tAR\u0001(i\u0016\u001cH\u000f\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]R\u0004&/\u001a3jG\u0006$XmU;dG\u0016\u001c8\u000fF\u0001H!\tI\u0001*\u0003\u0002J\u0015\t!QK\\5uQ\t!5\n\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006)!.\u001e8ji*\t\u0001+A\u0002pe\u001eL!AU'\u0003\tQ+7\u000f\u001e\u0005\u0006)\u0002!\tAR\u0001(i\u0016\u001cH\u000f\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]R\u0004&/\u001a3jG\u0006$XMR1jYV\u0014X\r\u000b\u0002T\u0017\")q\u000b\u0001C\u0001\r\u0006iC/Z:u!2\f7-Z7f]R\u001cuN\\:ue\u0006Lg\u000e\u001e)sK\u0012L7-\u0019;f\u001d>\u001cuN\\:ue\u0006Lg\u000e^:)\u0005Y[\u0005\"\u0002.\u0001\t\u00031\u0015\u0001\f;fgR\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u!J,G-[2bi\u0016tuN\u0011:pW\u0016\u0014(+Y2lQ\tI6\nC\u0003^\u0001\u0011\u0005a)A\u000buKN$X*\u001a:hK\u0012K7O[8j]Rl\u0015\r]:)\u0005q[\u0005\"\u00021\u0001\t\u00031\u0015!\u0005;fgRlUM]4f\u000b6\u0004H/_'ba\"\u0012ql\u0013\u0005\u0006G\u0002!\tAR\u0001\u0016i\u0016\u001cH/T3sO\u0016l\u0015\r\u001d,bYV,7+Y7fQ\u0011\u00117*\u001a4\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013a\u001a\t\u0003Q>l\u0011!\u001b\u0006\u0003U.\fa!\u001a:s_J\u001c(B\u0001\u000fm\u0015\t)QN\u0003\u0002o\u001f\u00061\u0011\r]1dQ\u0016L!\u0001]5\u0003;%sg/\u00197jI\u000e{gNZ5hkJ\fG/[8o\u000bb\u001cW\r\u001d;j_:DQA\u001d\u0001\u0005\u0002\u0019\u000b1\u0003^3ti6+'oZ3NCB\\U-_*b[\u0016D#!]&\t\u000bU\u0004A\u0011\u0001$\u00025Q,7\u000f^'fe\u001e,G)[:k_&tGoU3rk\u0016t7-Z:)\u0005Q\\\u0005\"\u0002=\u0001\t\u00031\u0015a\u0006;fgRlUM]4f\u000b6\u0004H/_*fcV,gnY3tQ\t98\nC\u0003|\u0001\u0011\u0005a)A\rnKJ<WMT8o\t&\u001c(n\\5oiN+\u0017/^3oG\u0016\u001c\b\u0006\u0002>LK\u001aDQA \u0001\u0005\u0002\u0019\u000b\u0001\u0005^3tiB\u000b'\u000f^5uS>t'I]8lKJ\u001c()_\"p]N$(/Y5oi\"\u0012Qp\u0013\u0005\u0007\u0003\u0007\u0001A\u0011\u0001$\u0002YQ,7\u000f\u001e)beRLG/[8o\u0005J|7.\u001a:t\u0005f\u001cuN\\:ue\u0006Lg\u000e^%om\u0006d\u0017\u000eZ\"pk:$\b&BA\u0001\u0017\u00164\u0007BBA\u0005\u0001\u0011\u0005a)\u0001\u0017uKN$(+Y2l+:\fw/\u0019:f\u001d>\u001cuN\\:ue\u0006Lg\u000e\u001e*fa2L7-Y!tg&<g.\\3oi\"\u001a\u0011qA&\t\r\u0005=\u0001\u0001\"\u0001G\u0003y\"Xm\u001d;SC\u000e\\WK\\1xCJ,'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;XSRD\u0007\u000b\\1dK6,g\u000e^\"p]N$(/Y5oi6K7o]5oO\"\u001a\u0011QB&\t\u0011\u0005U\u0001\u0001)C\u0005\u0003/\tAE^1mS\u0012\fG/\u001a*bG.,f.Y<be\u0016\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u000b\u0006\u000f\u0006e\u0011q\u0006\u0005\t\u00037\t\u0019\u00021\u0001\u0002\u001e\u00059!M]8lKJ\u001c\b#B\u0017\u0002 \u0005\r\u0012bAA\u0011]\tQ\u0011J\u001c3fq\u0016$7+Z9\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b\u0005\u0003\u0015\tG-\\5o\u0013\u0011\ti#a\n\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\"A\u0011\u0011GA\n\u0001\u0004\t\u0019$A\u0006bgNLwM\\7f]R\u001c\b#\u0002\u001d:i\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mB!\u0001\u0006d_:$(o\u001c7mKJLA!a\u0010\u0002:\t\t\"+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;\t\r\u0005\r\u0003\u0001\"\u0001G\u0003)\"Xm\u001d;SC\u000e\\\u0017i^1sK:{7i\u001c8tiJ\f\u0017N\u001c;SKBd\u0017nY1BgNLwM\\7f]RD3!!\u0011L\u0011\u0019\tI\u0005\u0001C\u0001\r\u0006aC/Z:u%\u0006\u001c7.Q<be\u0016<\u0016\u000e\u001e5D_:\u001cHO]1j]R\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0015\u0004\u0003\u000fZ\u0005BBA(\u0001\u0011\u0005a)\u0001\u001euKN$(+Y2l\u0003^\f'/Z,ji\"\u001cuN\\:ue\u0006Lg\u000e\u001e*fa2L7-Y!tg&<g.\\3oi^KG\u000f[*uCJ$\u0018J\u001c3fq\"\u001a\u0011QJ&\t\r\u0005U\u0003\u0001\"\u0001G\u0003m1\u0018\r\\5eCR,\u0007+\u0019:uSRLwN\\5oON+8mY3tg\"\u001a\u00111K&\t\r\u0005m\u0003\u0001\"\u0001G\u0003m1\u0018\r\\5eCR,\u0007+\u0019:uSRLwN\\5oO\u001a\u000b\u0017\u000e\\;sK\"*\u0011\u0011L&fM\"1\u0011\u0011\r\u0001\u0005\u0002\u0019\u000bQF^1mS\u0012\fG/\u001a)beRLG/[8oS:<g)Y5mkJ,W*\u001e7uSBdW\rU1si&$\u0018n\u001c8tQ\u0015\tyfS3g\u0011\u0019\t9\u0007\u0001C\u0001\r\u0006IC/Z:u-\u0006d\u0017\u000eZ1uKJ+\u0007\u000f\\5dCNtu\u000e\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]RD3!!\u001aL\u0011\u0019\ti\u0007\u0001C\u0001\r\u0006yB/Z:u-\u0006d\u0017\u000eZ1uK>\u00137/\u001a:wKJ\u001c8i\u001c8tiJ\f\u0017N\u001c;)\u0007\u0005-4\n\u0003\u0004\u0002t\u0001!\tAR\u0001&i\u0016\u001cHOV1mS\u0012\fG/\u001a*fa2L7-Y:NCR\u001c\u0007.Z:D_:\u001cHO]1j]RD3!!\u001dL\u0011\u0019\tI\b\u0001C\u0001\r\u00069C/Z:u-\u0006d\u0017\u000eZ1uKJ+\u0007\u000f\\5dCN|e/\u001a:D_:\u001cHO]1j]R\u001cu.\u001e8uQ\r\t9h\u0013\u0005\u0007\u0003\u007f\u0002A\u0011\u0001$\u0002QQ,7\u000f\u001e,bY&$\u0017\r^3SKBd\u0017nY1t+:$WM]\"p]N$(/Y5oi\u000e{WO\u001c;)\u0007\u0005u4\n\u0003\u0004\u0002\u0006\u0002!\tAR\u00011i\u0016\u001cHOU3qY&\u001c\u0017-\u00138eSZLG-^1m\u0007>t7\u000f\u001e:bS:$8i\\;oi:{GoU1uSN4\u0017.\u001a3)\u0007\u0005\r5\n\u0003\u0004\u0002\f\u0002!\tAR\u0001\u001ei\u0016\u001cHo\u00142tKJ4XM]'bi\u000eDWm]\"p]N$(/Y5oi\"\u001a\u0011\u0011R&\t\r\u0005E\u0005\u0001\"\u0001G\u0003a!Xm\u001d;J]Z\fG.\u001b3PEN,'O^3s\u0007>,h\u000e\u001e\u0015\u0004\u0003\u001f[\u0005BBAL\u0001\u0011\u0005a)\u0001\u000fuKN$\u0018J\u001c<bY&$wJY:feZ,'/\u0011;ue&\u0014W\u000f^3)\u0007\u0005U5\n\u0003\u0004\u0002\u001e\u0002!\tAR\u0001 i\u0016\u001cHOU3qY&\u001c\u0017m\u001d%bg>\u00137/\u001a:wKJ\f5oU;gM&D\bfAAN\u0017\"1\u00111\u0015\u0001\u0005\u0002\u0019\u000bQ\u0003^3ti:{G)\u001e9mS\u000e\f'+\u001a9mS\u000e\f7\u000fK\u0002\u0002\".Ca!!+\u0001\t\u00031\u0015\u0001\u0007;fgRtuNT3hCRLg/\u001a*fa2L7-Y%eg\"\u001a\u0011qU&\t\r\u0005=\u0006\u0001\"\u0001G\u0003\u001d\"Xm\u001d;WC2LGMU3bgNLwM\\7f]R\fE\u000e\\(gM2Lg.Z(cg\u0016\u0014h/\u001a:)\u0007\u000556\n\u0003\u0004\u00026\u0002!\tAR\u0001(i\u0016\u001cHOV1mS\u0012\u0014V-Y:tS\u001etW.\u001a8u\u001f:,wJ\u001a4mS:,wJY:feZ,'\u000fK\u0002\u00024.Ca!a/\u0001\t\u00031\u0015!\u000b;fgRLeN^1mS\u0012\u0014V-Y:tS\u001etW.\u001a8u\u001d\u0016<xJ\u001a4mS:,wJY:feZ,'\u000fK\u0002\u0002:.Ca!!1\u0001\t\u00031\u0015A\t;fgRLeN^1mS\u0012\u0014V-Y:tS\u001etW.\u001a8u\u001f\u001a4G.\u001b8f'ft7\rK\u0002\u0002@.\u0003")
public class ObserverTest {
    private final Option<TopicPlacement> topicWithObserverPlacementConstraint;
    private final Option<TopicPlacement> topicWithTwoObserverPlacementConstraint;
    private final Option<TopicPlacement> topicWithoutObserversConstraint;
    private final scala.collection.immutable.Map<Object, Map<String, String>> allBrokersAttributes;

    private Option<TopicPlacement> topicWithObserverPlacementConstraint() {
        return this.topicWithObserverPlacementConstraint;
    }

    private Option<TopicPlacement> topicWithTwoObserverPlacementConstraint() {
        return this.topicWithTwoObserverPlacementConstraint;
    }

    private Option<TopicPlacement> topicWithoutObserversConstraint() {
        return this.topicWithoutObserversConstraint;
    }

    private scala.collection.immutable.Map<Object, Map<String, String>> allBrokersAttributes() {
        return this.allBrokersAttributes;
    }

    @Test
    public void testPlacementConstraintPredicateSuccess() {
        BrokerMetadata replicaBroker = new BrokerMetadata(2, (Option)new Some((Object)"east-1"));
        BrokerMetadata observerBroker = new BrokerMetadata(2, (Option)new Some((Object)"west-1"));
        this.topicWithObserverPlacementConstraint().foreach((Function1)new Serializable(this, replicaBroker, observerBroker){
            public static final long serialVersionUID = 0L;
            private final BrokerMetadata replicaBroker$1;
            private final BrokerMetadata observerBroker$1;

            public final void apply(TopicPlacement topicPlacement) {
                Buffer replicaConstraints = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala();
                Assert.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(this.replicaBroker$1, (TopicPlacement.ConstraintCount)replicaConstraints.head()));
                Assert.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(this.replicaBroker$1, (TopicPlacement.ConstraintCount)((IterableLike)replicaConstraints.tail()).head()));
                Assert.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(this.observerBroker$1, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
            }
            {
                this.replicaBroker$1 = replicaBroker$1;
                this.observerBroker$1 = observerBroker$1;
            }
        });
    }

    @Test
    public void testPlacementConstraintPredicateFailure() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"));
        this.topicWithObserverPlacementConstraint().foreach((Function1)new Serializable(this, broker){
            public static final long serialVersionUID = 0L;
            private final BrokerMetadata broker$1;

            public final void apply(TopicPlacement topicPlacement) {
                Assert.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(this.broker$1, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
                Assert.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(this.broker$1, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
            }
            {
                this.broker$1 = broker$1;
            }
        });
    }

    @Test
    public void testPlacementConstraintPredicateNoConstraints() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"));
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        TopicPlacement topicPlacement = (TopicPlacement)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))).get();
        Assert.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
        Assert.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    @Test
    public void testPlacementConstraintPredicateNoBrokerRack() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)None$.MODULE$);
        this.topicWithObserverPlacementConstraint().foreach((Function1)new Serializable(this, broker){
            public static final long serialVersionUID = 0L;
            private final BrokerMetadata broker$2;

            public final void apply(TopicPlacement topicPlacement) {
                Assert.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(this.broker$2, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
                Assert.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(this.broker$2, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
            }
            {
                this.broker$2 = broker$2;
            }
        });
    }

    @Test
    public void testMergeDisjointMaps() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 16))}));
        scala.collection.mutable.Map mergedMap = Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap);
        Assert.assertEquals((Object)firstMap.$plus$plus((GenTraversableOnce)secondMap), (Object)mergedMap);
    }

    @Test
    public void testMergeEmptyMap() {
        scala.collection.mutable.Map assignmentMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        Assert.assertEquals((Object)assignmentMap, (Object)Observer$.MODULE$.mergeAssignmentMap(assignmentMap, (Map)Map$.MODULE$.empty()));
        Assert.assertEquals((Object)assignmentMap, (Object)Observer$.MODULE$.mergeAssignmentMap(Map$.MODULE$.empty(), (Map)assignmentMap));
        Assert.assertEquals((Object)Map$.MODULE$.empty(), (Object)Observer$.MODULE$.mergeAssignmentMap(Map$.MODULE$.empty(), (Map)Map$.MODULE$.empty()));
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testMergeMapValueSame() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 16))}));
        Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap);
    }

    @Test
    public void testMergeMapKeySame() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15))}));
        scala.collection.mutable.Map expectedMergedMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15))}));
        Assert.assertEquals((Object)expectedMergedMap, (Object)Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap));
    }

    @Test
    public void testMergeDisjointSequences() {
        Range.Inclusive firstSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        Range.Inclusive secondSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 20);
        Assert.assertEquals((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20), (Object)Observer$.MODULE$.mergeReplicaLists((Seq)firstSeq, (Seq)secondSeq));
    }

    @Test
    public void testMergeEmptySequences() {
        Range.Inclusive testSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        Assert.assertEquals((Object)testSeq, (Object)Observer$.MODULE$.mergeReplicaLists((Seq)testSeq, (Seq)Seq$.MODULE$.empty()));
        Assert.assertEquals((Object)testSeq, (Object)Observer$.MODULE$.mergeReplicaLists((Seq)Seq$.MODULE$.empty(), (Seq)testSeq));
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)Observer$.MODULE$.mergeReplicaLists((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty()));
    }

    @Test(expected=InvalidConfigurationException.class)
    public void mergeNonDisjointSequences() {
        Range.Inclusive firstSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        Range.Inclusive secondSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 15);
        Observer$.MODULE$.mergeReplicaLists((Seq)firstSeq, (Seq)secondSeq);
    }

    @Test
    public void testPartitionBrokersByConstraint() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        IndexedSeq east1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$1) {
                return new BrokerMetadata(x$1, (Option)new Some((Object)"east-1"));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq east2Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 20).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$2) {
                return new BrokerMetadata(x$2, (Option)new Some((Object)"east-2"));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq west1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(21), 30).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$3) {
                return new BrokerMetadata(x$3, (Option)new Some((Object)"west-1"));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq allBrokers = (IndexedSeq)((TraversableLike)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)west1Brokers, IndexedSeq$.MODULE$.canBuildFrom());
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Serializable partitionFunction = new Serializable(this, allBrokers){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq allBrokers$1;

            public final Seq<Tuple2<Object, Seq<BrokerMetadata>>> apply(Seq<TopicPlacement.ConstraintCount> constraints) {
                return Observer$.MODULE$.partitionBrokersByConstraint((Seq)this.allBrokers$1, constraints);
            }
            {
                this.allBrokers$1 = allBrokers$1;
            }
        };
        Seq replicasTuple = (Seq)partitionFunction.apply(JavaConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala());
        Seq replicas = (Seq)replicasTuple.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<BrokerMetadata> apply(Tuple2<Object, Seq<BrokerMetadata>> x0$1) {
                Tuple2<Object, Seq<BrokerMetadata>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Seq replica;
                    Seq seq = replica = (Seq)tuple2._2();
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom()), (Object)replicas);
        Seq replicaCount = (Seq)replicasTuple.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Seq<BrokerMetadata>> x0$2) {
                Tuple2<Object, Seq<BrokerMetadata>> tuple2 = x0$2;
                if (tuple2 != null) {
                    int count;
                    int n = count = tuple2._1$mcI$sp();
                    return n;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)replicaCount);
        Seq observersTuple = (Seq)partitionFunction.apply(JavaConverters$.MODULE$.asScalaBufferConverter(topicPlacement.observers()).asScala());
        Seq observers = (Seq)observersTuple.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<BrokerMetadata> apply(Tuple2<Object, Seq<BrokerMetadata>> x0$3) {
                Tuple2<Object, Seq<BrokerMetadata>> tuple2 = x0$3;
                if (tuple2 != null) {
                    Seq observer;
                    Seq seq = observer = (Seq)tuple2._2();
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)west1Brokers, (Object)observers);
        Seq observersCount = (Seq)observersTuple.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Seq<BrokerMetadata>> x0$4) {
                Tuple2<Object, Seq<BrokerMetadata>> tuple2 = x0$4;
                if (tuple2 != null) {
                    int count;
                    int n = count = tuple2._1$mcI$sp();
                    return n;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)observersCount);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testPartitionBrokersByConstraintInvalidCount() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 5,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        IndexedSeq east1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$4) {
                return new BrokerMetadata(x$4, (Option)new Some((Object)"east-1"));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq east2Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 13).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$5) {
                return new BrokerMetadata(x$5, (Option)new Some((Object)"east-2"));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq west1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(14), 20).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$6) {
                return new BrokerMetadata(x$6, (Option)new Some((Object)"west-1"));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq allBrokers = (IndexedSeq)((TraversableLike)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)west1Brokers, IndexedSeq$.MODULE$.canBuildFrom());
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Serializable partitionFunction = new Serializable(this, allBrokers){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq allBrokers$2;

            public final Seq<Tuple2<Object, Seq<BrokerMetadata>>> apply(Seq<TopicPlacement.ConstraintCount> constraints) {
                return Observer$.MODULE$.partitionBrokersByConstraint((Seq)this.allBrokers$2, constraints);
            }
            {
                this.allBrokers$2 = allBrokers$2;
            }
        };
        partitionFunction.apply(JavaConverters$.MODULE$.asScalaBufferConverter(topicPlacement.observers()).asScala());
        partitionFunction.apply(JavaConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala());
    }

    @Test
    public void testRackUnawareNoConstraintReplicaAssignment() {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$7) {
                return new BrokerMetadata(x$7, (Option)None$.MODULE$);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        int numPartitions = 10;
        int replicationFactor = 3;
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, (Option)None$.MODULE$, numPartitions, replicationFactor, Observer$.MODULE$.getReplicaAssignment$default$5(), Observer$.MODULE$.getReplicaAssignment$default$6());
        this.validateRackUnawareReplicaAssignment((IndexedSeq<BrokerMetadata>)brokers, (Map<Object, ReplicaAssignment>)assignments);
    }

    @Test
    public void testRackUnawareReplicaAssignmentWithPlacementConstraintMissing() {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$8) {
                return new BrokerMetadata(x$8, (Option)None$.MODULE$);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        int numPartitions = 10;
        int replicationFactor = 3;
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)"{\"version\":1, \"replicas\":[{\"count\":3}]}"))), numPartitions, replicationFactor, Observer$.MODULE$.getReplicaAssignment$default$5(), Observer$.MODULE$.getReplicaAssignment$default$6());
        this.validateRackUnawareReplicaAssignment((IndexedSeq<BrokerMetadata>)brokers, (Map<Object, ReplicaAssignment>)assignments);
    }

    private void validateRackUnawareReplicaAssignment(IndexedSeq<BrokerMetadata> brokers, Map<Object, ReplicaAssignment> assignments) {
        Iterable brokerAssignment = (Iterable)((GenericTraversableTemplate)assignments.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$9) {
                return x$9.replicas();
            }
        }, Iterable$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms());
        brokerAssignment.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<Object> assignedPartitions) {
                assignedPartitions.groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int brokerId) {
                        return this.apply$mcII$sp(brokerId);
                    }

                    public int apply$mcII$sp(int brokerId) {
                        return brokerId;
                    }
                }).values().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Iterable<Object> brokerIds) {
                        Assert.assertEquals((long)2L, (long)brokerIds.size());
                    }
                });
                Assert.assertEquals((long)10L, (long)assignedPartitions.size());
                Assert.assertEquals((long)5L, (long)assignedPartitions.toSet().size());
            }
        });
        ((IterableLike)assignments.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$10) {
                return x$10.replicas();
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Object> brokers) {
                Assert.assertEquals((long)3L, (long)brokers.size());
            }
        });
    }

    @Test
    public void testRackAwareNoConstraintReplicaAssignment() {
        int numPartitions = 9;
        int replicationFactor = 3;
        IndexedSeq racks = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(int id) {
                return (List)List$.MODULE$.fill(3, (Function0)new Serializable(this, id){
                    public static final long serialVersionUID = 0L;
                    private final int id$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"rack").append((Object)BoxesRunTime.boxToInteger((int)this.id$1)).toString();
                    }
                    {
                        this.id$1 = id$1;
                    }
                });
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq brokers = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).zip((GenIterable)racks, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Tuple2<Object, String> x0$5) {
                Tuple2<Object, String> tuple2 = x0$5;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    String rack = (String)tuple2._2();
                    BrokerMetadata brokerMetadata = new BrokerMetadata(id, (Option)new Some((Object)rack));
                    return brokerMetadata;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, (Option)None$.MODULE$, numPartitions, replicationFactor, Observer$.MODULE$.getReplicaAssignment$default$5(), Observer$.MODULE$.getReplicaAssignment$default$6());
        ((IterableLike)assignments.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$11) {
                return x$11.replicas();
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Object> assignedBrokers) {
                Assert.assertEquals((long)3L, (long)assignedBrokers.toSet().size());
            }
        });
        ((IterableLike)((GenericTraversableTemplate)assignments.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$12) {
                return x$12.replicas();
            }
        }, Iterable$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<Object> assignedBrokers) {
                Assert.assertEquals((long)9L, (long)assignedBrokers.toSet().size());
            }
        });
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignment() {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 14).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int id) {
                String rack = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(id / 5 + 1))}));
                return new BrokerMetadata(id, (Option)new Some((Object)rack));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                           | \"version\": 1,\n                           |  \"replicas\": [{\n                           |      \"count\": 3,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack1\"\n                           |      }\n                           |    },\n                           |    {\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack2\"\n                           |      }\n                           |    }\n                           |  ],\n                           |  \"observers\": [{\n                           |    \"count\": 2,\n                           |    \"constraints\": {\n                           |      \"rack\": \"rack3\"\n                           |    }\n                           |  }]\n                           |}")).stripMargin();
        Map partitionAssignment = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))), 10, 3, Observer$.MODULE$.getReplicaAssignment$default$5(), Observer$.MODULE$.getReplicaAssignment$default$6());
        ((IterableLike)partitionAssignment.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$13) {
                return x$13.replicas();
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Object> assignedBrokers) {
                Assert.assertEquals((long)7L, (long)assignedBrokers.toSet().size());
                ((IterableLike)assignedBrokers.take(3)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(int brokerId) {
                        this.apply$mcVI$sp(brokerId);
                    }

                    public void apply$mcVI$sp(int brokerId) {
                        Assert.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0);
                    }
                });
                ((IterableLike)assignedBrokers.slice(3, 5)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(int brokerId) {
                        this.apply$mcVI$sp(brokerId);
                    }

                    public void apply$mcVI$sp(int brokerId) {
                        Assert.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0);
                    }
                });
                ((IterableLike)assignedBrokers.slice(5, 7)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(int brokerId) {
                        this.apply$mcVI$sp(brokerId);
                    }

                    public void apply$mcVI$sp(int brokerId) {
                        Assert.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0);
                    }
                });
            }
        });
        ((IterableLike)partitionAssignment.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$14) {
                return x$14.observers();
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Object> observers) {
                Assert.assertTrue((String)observers.mkString(","), (boolean)observers.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int observerId) {
                        return this.apply$mcZI$sp(observerId);
                    }

                    public boolean apply$mcZI$sp(int observerId) {
                        return observerId >= 10 && observerId <= 14;
                    }
                }));
            }
        });
        Iterable brokerAssignment = (Iterable)((GenericTraversableTemplate)partitionAssignment.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$15) {
                return x$15.replicas();
            }
        }, Iterable$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms());
        brokerAssignment.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<Object> assignedPartitions) {
                assignedPartitions.groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int brokerId) {
                        return this.apply$mcII$sp(brokerId);
                    }

                    public int apply$mcII$sp(int brokerId) {
                        return brokerId;
                    }
                }).values().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Iterable<Object> brokerIds) {
                        Assert.assertEquals((long)2L, (long)brokerIds.size());
                    }
                });
            }
        });
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignmentWithStartIndex() {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 14).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int id) {
                String rack = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(id / 5 + 1))}));
                return new BrokerMetadata(id, (Option)new Some((Object)rack));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                           | \"version\": 1,\n                           |  \"replicas\": [{\n                           |      \"count\": 4,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack1\"\n                           |      }\n                           |    }\n                           |  ],\n                           |  \"observers\": [{\n                           |    \"count\": 3,\n                           |    \"constraints\": {\n                           |      \"rack\": \"rack3\"\n                           |    }\n                           |  }]\n                           |}")).stripMargin();
        Map partitionAssignment = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))), 15, 3, 2, 3);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3, 4})), (Object)((ReplicaAssignment)partitionAssignment.values().head()).replicas().slice(0, 4));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12, 11, 13})), (Object)((ReplicaAssignment)partitionAssignment.values().head()).observers());
        ((IterableLike)partitionAssignment.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$16) {
                return x$16.replicas();
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Object> assignedBrokers) {
                Assert.assertEquals((long)7L, (long)assignedBrokers.toSet().size());
                ((IterableLike)assignedBrokers.take(4)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(int brokerId) {
                        this.apply$mcVI$sp(brokerId);
                    }

                    public void apply$mcVI$sp(int brokerId) {
                        Assert.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0);
                    }
                });
                ((IterableLike)assignedBrokers.slice(5, 7)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(int brokerId) {
                        this.apply$mcVI$sp(brokerId);
                    }

                    public void apply$mcVI$sp(int brokerId) {
                        Assert.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0);
                    }
                });
            }
        });
        ((IterableLike)partitionAssignment.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$17) {
                return x$17.observers();
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Object> observers) {
                Assert.assertTrue((String)observers.mkString(","), (boolean)observers.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int observerId) {
                        return this.apply$mcZI$sp(observerId);
                    }

                    public boolean apply$mcZI$sp(int observerId) {
                        return observerId >= 10 && observerId <= 14;
                    }
                }));
            }
        });
    }

    @Test
    public void validatePartitioningSuccess() {
        IndexedSeq partitionedBrokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, IndexedSeq<BrokerMetadata>> apply(int partitionNumber) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionNumber)), RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this, partitionNumber){
                    public static final long serialVersionUID = 0L;
                    private final int partitionNumber$1;

                    public final BrokerMetadata apply(int brokerId) {
                        return new BrokerMetadata(this.partitionNumber$1 * 5 + brokerId, (Option)new Some((Object)"rack"));
                    }
                    {
                        this.partitionNumber$1 = partitionNumber$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Observer$.MODULE$.validatePartitioning((Seq)partitionedBrokers);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void validatePartitioningFailure() {
        List commonBrokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(1, (Option)new Some((Object)"rack-1")), new BrokerMetadata(2, (Option)new Some((Object)"rack-1"))}));
        Seq partitionedBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(3, (Option)new Some((Object)"rack-1"))})).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom())), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(4, (Option)new Some((Object)"rack-1"))})).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom()))}));
        Observer$.MODULE$.validatePartitioning(partitionedBrokers);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void validatePartitioningFailureMultiplePartitions() {
        List commonBrokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(1, (Option)new Some((Object)"rack-1")), new BrokerMetadata(2, (Option)new Some((Object)"rack-1"))}));
        Seq partitionedBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(3, (Option)new Some((Object)"rack-1"))})).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom())), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(4, (Option)new Some((Object)"rack-1"))}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(5, (Option)new Some((Object)"rack-1"))})).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom()))}));
        Observer$.MODULE$.validatePartitioning(partitionedBrokers);
    }

    @Test
    public void testValidateReplicasNoPlacementConstraint() {
        Observer$.MODULE$.validateAssignment((Option)None$.MODULE$, new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
    }

    @Test
    public void testValidateObserversConstraint() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
        Assert.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$18) {
                return x$18.error();
            }
        }));
    }

    @Test
    public void testValidateReplicasMatchesConstraint() {
        Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
    }

    @Test
    public void testValidateReplicasOverConstraintCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
        Assert.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$19) {
                return x$19.error();
            }
        }));
    }

    @Test
    public void testValidateReplicasUnderConstraintCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
        Assert.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$20) {
                return x$20.error();
            }
        }));
    }

    @Test
    public void testReplicaIndividualConstraintCountNotSatisfied() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 4, 5, 6, 7})), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
        Assert.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$21) {
                return x$21.error();
            }
        }));
    }

    @Test
    public void testObserverMatchesConstraint() {
        Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6)), this.allBrokersAttributes());
    }

    @Test
    public void testInvalidObserverCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 7)), this.allBrokersAttributes());
        Assert.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$22) {
                return x$22.error();
            }
        }));
    }

    @Test
    public void testInvalidObserverAttribute() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9})), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 9}))), this.allBrokersAttributes());
        Assert.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$23) {
                return x$23.error();
            }
        }));
    }

    @Test
    public void testReplicasHasObserverAsSuffix() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1)));
        Assert.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$24) {
                return x$24.error();
            }
        }));
    }

    @Test
    public void testNoDuplicaReplicas() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 1})), (Seq)Seq$.MODULE$.empty()));
        Assert.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$25) {
                return x$25.error();
            }
        }));
    }

    @Test
    public void testNoNegativeReplicaIds() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, -2})), (Seq)Seq$.MODULE$.empty()));
        Assert.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$26) {
                return x$26.error();
            }
        }));
    }

    @Test
    public void testValidReassignmentAllOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4))), (Map)this.allBrokersAttributes().$minus$minus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4)));
        Assert.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$27) {
                return x$27.error();
            }
        }));
    }

    @Test
    public void testValidReassignmentOneOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4))), this.allBrokersAttributes().$minus((Object)BoxesRunTime.boxToInteger((int)0)));
        Assert.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$28) {
                return x$28.error();
            }
        }));
    }

    @Test
    public void testInvalidReassignmentNewOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10})), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10})), IndexedSeq$.MODULE$.canBuildFrom()))), this.allBrokersAttributes());
        Assert.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$29) {
                return x$29.error();
            }
        }));
    }

    @Test
    public void testInvalidReassignmentOfflineSync() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4))), this.allBrokersAttributes().$minus((Object)BoxesRunTime.boxToInteger((int)5)));
        Assert.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(ApiError x$30) {
                return x$30.error();
            }
        }));
    }

    public ObserverTest() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"replicas\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    }\n      |  ],\n      |  \"observers\": [{\n      |    \"count\": 2,\n      |    \"constraints\": {\n      |      \"rack\": \"west-1\"\n      |    }\n      |  }]\n      |}")).stripMargin();
        this.topicWithObserverPlacementConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        String placementJson2 = new StringOps(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"observers\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    }\n      |  ],\n      |  \"replicas\": [{\n      |    \"count\": 2,\n      |    \"constraints\": {\n      |      \"rack\": \"west-1\"\n      |    }\n      |  }]\n      |}")).stripMargin();
        this.topicWithTwoObserverPlacementConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson2)));
        String placementJsonWithoutObservers = new StringOps(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"replicas\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"west-1\"\n      |      }\n      |    }\n      |  ]\n      |}")).stripMargin();
        this.topicWithoutObserversConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithoutObservers)));
        this.allBrokersAttributes = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Map<String, String>> apply(int id) {
                int n = id;
                switch (n) {
                    default: 
                }
                String rack = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).contains(n) ? "east-1" : (RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 4).contains(n) ? "east-2" : (RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 7).contains(n) ? "west-1" : "west-2"));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rack"), (Object)rack)})));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }
}

