/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.PartitionStateStore;
import kafka.cluster.PartitionTest$;
import kafka.cluster.PartitionTest$$anonfun$10$;
import kafka.cluster.Replica;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.TierLogComponents$;
import kafka.server.Defaults$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.tier.TierReplicaManager;
import kafka.tier.state.TierPartitionState;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r=f\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002U1si&$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#\u0001\u0005ce>\\WM]%e+\u00051\u0002CA\u0005\u0018\u0013\tA\"BA\u0002J]RDaA\u0007\u0001!\u0002\u00131\u0012!\u00032s_.,'/\u00133!\u0011\u001da\u0002A1A\u0005\u0002u\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001\u001f!\tyr%D\u0001!\u0015\t\t#%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\rR!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO&\u0011\u0001\u0006\t\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019Q\u0003\u0001)A\u0005=\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\tQLW.Z\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007B\u0001\u0006kRLGn]\u0005\u0003gA\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0018\u0002\u000bQLW.\u001a\u0011\t\u0013]\u0002\u0001\u0019!a\u0001\n\u0003A\u0014A\u0002;na\u0012K'/F\u0001:!\tQt(D\u0001<\u0015\taT(\u0001\u0002j_*\ta(\u0001\u0003kCZ\f\u0017B\u0001!<\u0005\u00111\u0015\u000e\\3\t\u0013\t\u0003\u0001\u0019!a\u0001\n\u0003\u0019\u0015A\u0003;na\u0012K'o\u0018\u0013fcR\u0011Ai\u0012\t\u0003\u0013\u0015K!A\u0012\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b\u0011\u0006\u000b\t\u00111\u0001:\u0003\rAH%\r\u0005\u0007\u0015\u0002\u0001\u000b\u0015B\u001d\u0002\u000fQl\u0007\u000fR5sA!IA\n\u0001a\u0001\u0002\u0004%\t\u0001O\u0001\bY><G)\u001b:2\u0011%q\u0005\u00011AA\u0002\u0013\u0005q*A\u0006m_\u001e$\u0015N]\u0019`I\u0015\fHC\u0001#Q\u0011\u001dAU*!AA\u0002eBaA\u0015\u0001!B\u0013I\u0014\u0001\u00037pO\u0012K'/\r\u0011\t\u0013Q\u0003\u0001\u0019!a\u0001\n\u0003A\u0014a\u00027pO\u0012K'O\r\u0005\n-\u0002\u0001\r\u00111A\u0005\u0002]\u000b1\u0002\\8h\t&\u0014(g\u0018\u0013fcR\u0011A\t\u0017\u0005\b\u0011V\u000b\t\u00111\u0001:\u0011\u0019Q\u0006\u0001)Q\u0005s\u0005AAn\\4ESJ\u0014\u0004\u0005C\u0005]\u0001\u0001\u0007\t\u0019!C\u0001;\u0006QAn\\4NC:\fw-\u001a:\u0016\u0003y\u0003\"a\u00182\u000e\u0003\u0001T!!\u0019\u0003\u0002\u00071|w-\u0003\u0002dA\nQAj\\4NC:\fw-\u001a:\t\u0013\u0015\u0004\u0001\u0019!a\u0001\n\u00031\u0017A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0003\t\u001eDq\u0001\u00133\u0002\u0002\u0003\u0007a\f\u0003\u0004j\u0001\u0001\u0006KAX\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005C\u0005l\u0001\u0001\u0007\t\u0019!C\u0001Y\u0006IAn\\4D_:4\u0017nZ\u000b\u0002[B\u0011qL\\\u0005\u0003_\u0002\u0014\u0011\u0002T8h\u0007>tg-[4\t\u0013E\u0004\u0001\u0019!a\u0001\n\u0003\u0011\u0018!\u00047pO\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0002Eg\"9\u0001\n]A\u0001\u0002\u0004i\u0007BB;\u0001A\u0003&Q.\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002Bqa\u001e\u0001C\u0002\u0013\u0005\u00010\u0001\u0006ti\u0006$Xm\u0015;pe\u0016,\u0012!\u001f\t\u0003%iL!a\u001f\u0002\u0003'A\u000b'\u000f^5uS>t7\u000b^1uKN#xN]3\t\ru\u0004\u0001\u0015!\u0003z\u0003-\u0019H/\u0019;f'R|'/\u001a\u0011\t\u0011}\u0004!\u0019!C\u0001\u0003\u0003\t\u0011\u0003Z3mCf,Gm\u00149fe\u0006$\u0018n\u001c8t+\t\t\u0019\u0001E\u0002\u0013\u0003\u000bI1!a\u0002\u0003\u0005E!U\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u001d\u0005\t\u0003\u0017\u0001\u0001\u0015!\u0003\u0002\u0004\u0005\u0011B-\u001a7bs\u0016$w\n]3sCRLwN\\:!\u0011%\ty\u0001\u0001b\u0001\n\u0003\t\t\"A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003'\u0001B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033!\u0011AB:feZ,'/\u0003\u0003\u0002\u001e\u0005]!!D'fi\u0006$\u0017\r^1DC\u000eDW\r\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\n\u00039iW\r^1eCR\f7)Y2iK\u0002B\u0011\"!\n\u0001\u0005\u0004%\t!a\n\u0002#=4gm]3u\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002*A!\u00111FA\u0019\u001b\t\tiC\u0003\u0003\u00020\u0005]\u0011aC2iK\u000e\\\u0007o\\5oiNLA!a\r\u0002.\t\trJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e^:\t\u0011\u0005]\u0002\u0001)A\u0005\u0003S\t!c\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;tA!I\u00111\b\u0001C\u0002\u0013\u0005\u0011QH\u0001\u0013i&,'OU3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002F\u0011\tA\u0001^5fe&!\u0011\u0011JA\"\u0005I!\u0016.\u001a:SKBd\u0017nY1NC:\fw-\u001a:\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u007f\t1\u0003^5feJ+\u0007\u000f\\5dC6\u000bg.Y4fe\u0002B1\"!\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002T\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0003\u0003+\u00022AEA,\u0013\r\tIF\u0001\u0002\n!\u0006\u0014H/\u001b;j_:D1\"!\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002`\u0005i\u0001/\u0019:uSRLwN\\0%KF$2\u0001RA1\u0011%A\u00151LA\u0001\u0002\u0004\t)\u0006\u0003\u0005\u0002f\u0001\u0001\u000b\u0015BA+\u0003)\u0001\u0018M\u001d;ji&|g\u000e\t\u0005\b\u0003S\u0002A\u0011AA6\u0003\u0015\u0019X\r^;q)\u0005!\u0005\u0006BA4\u0003_\u0002B!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003k*\u0013!\u00026v]&$\u0018\u0002BA=\u0003g\u0012aAQ3g_J,\u0007bBA?\u0001\u0011%\u0011qP\u0001\u0014GJ,\u0017\r^3M_\u001e\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0003\u0003\u000bi\t\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\r\t9)P\u0001\u0005kRLG.\u0003\u0003\u0002\f\u0006\u0015%A\u0003)s_B,'\u000f^5fg\"A\u0011qRA>\u0001\u0004\t\t*A\u0005pm\u0016\u0014(/\u001b3fgBA\u00111SAM\u0003?\u000byJD\u0002\n\u0003+K1!a&\u000b\u0003\u0019\u0001&/\u001a3fM&!\u00111TAO\u0005\ri\u0015\r\u001d\u0006\u0004\u0003/S\u0001\u0003BAJ\u0003CKA!a)\u0002\u001e\n11\u000b\u001e:j]\u001eDq!a*\u0001\t\u0003\tY'\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\t)+a+\u0011\t\u0005E\u0014QV\u0005\u0005\u0003_\u000b\u0019HA\u0003BMR,'\u000fC\u0004\u00024\u0002!\t!a\u001b\u0002?Q,7\u000f^'bW\u0016dU-\u00193feV\u0003H-\u0019;fg\u0016\u0003xn\u00195DC\u000eDW\r\u000b\u0003\u00022\u0006]\u0006\u0003BA9\u0003sKA!a/\u0002t\t!A+Z:u\u0011\u001d\ty\f\u0001C\u0001\u0003W\n!\u0007^3ti6\u000b7.\u001a'fC\u0012,'\u000fR8fg:{G/\u00169eCR,W\t]8dQ\u000e\u000b7\r[3G_J|E\u000e\u001a$pe6\fGo\u001d\u0015\u0005\u0003{\u000b9\fC\u0004\u0002F\u0002!\t!a\u001b\u0002QQ,7\u000f^'bs\n,'+\u001a9mC\u000e,7)\u001e:sK:$x+\u001b;i\rV$XO]3SKBd\u0017nY1)\t\u0005\r\u0017q\u0017\u0005\b\u0003\u0017\u0004A\u0011AA6\u0003q\"Xm\u001d;NCf\u0014WMU3qY\u0006\u001cWmQ;se\u0016tGoV5uQ\u001a+H/\u001e:f%\u0016\u0004H.[2b\t&4g-\u001a:f]R\u0014\u0015m]3PM\u001a\u001cX\r^:)\t\u0005%\u0017q\u0017\u0005\b\u0003#\u0004A\u0011AA6\u0003=\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$8K\\1qg\"|G/\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe2+\u0017\rZ3sQ\u0011\ty-a.\t\u000f\u0005]\u0007\u0001\"\u0001\u0002l\u0005\tD/Z:u\r\u0016$8\r[(gMN,Go\u00158baNDw\u000e^#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_J4u\u000e\u001c7po\u0016\u0014\b\u0006BAk\u0003oCq!!8\u0001\t\u0003\tY'A\u0016uKN$xJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe2+\u0017\rZ3sQ\u0011\tY.a.\t\u000f\u0005\r\b\u0001\"\u0001\u0002l\u0005iC/Z:u\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d$pY2|w/\u001a:)\t\u0005\u0005\u0018q\u0017\u0005\b\u0003S\u0004A\u0011AA6\u0003\u0019\"Xm\u001d;SK\u0006$'+Z2pe\u0012,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:MK\u0006$WM\u001d\u0015\u0005\u0003O\f9\fC\u0004\u0002p\u0002!\t!a\u001b\u0002QQ,7\u000f\u001e*fC\u0012\u0014VmY8sI\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d$pY2|w/\u001a:)\t\u00055\u0018q\u0017\u0005\b\u0003k\u0004A\u0011AA6\u0003M\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$hi\u001c:US6,7\u000f^1na\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d'fC\u0012,'\u000f\u000b\u0003\u0002t\u0006]\u0006bBA~\u0001\u0011\u0005\u00111N\u00016i\u0016\u001cHOR3uG\"|eMZ:fi\u001a{'\u000fV5nKN$\u0018-\u001c9Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014hi\u001c7m_^,'\u000f\u000b\u0003\u0002z\u0006]\u0006b\u0002B\u0001\u0001\u0011\u0005\u00111N\u0001)i\u0016\u001cHOR3uG\"d\u0015\r^3ti>3gm]3u\u0013:\u001cG.\u001e3fg2+\u0017\rZ3s\u000bB|7\r\u001b\u0015\u0005\u0003\u007f\f9\fC\u0004\u0003\b\u0001!\t!a\u001b\u0002KQ,7\u000f^'p]>$xN\\5d\u001f\u001a47/\u001a;t\u0003\u001a$XM\u001d'fC\u0012,'o\u00115b]\u001e,\u0007\u0006\u0002B\u0003\u0003oCqA!\u0004\u0001\t\u0013\u0011y!A\ftKR,\b\u000fU1si&$\u0018n\u001c8XSRDWj\\2lgRQ\u0011Q\u000bB\t\u0005+\u0011yBa\n\t\u000f\tM!1\u0002a\u0001-\u0005YA.Z1eKJ,\u0005o\\2i\u0011!\u00119Ba\u0003A\u0002\te\u0011\u0001C5t\u0019\u0016\fG-\u001a:\u0011\u0007%\u0011Y\"C\u0002\u0003\u001e)\u0011qAQ8pY\u0016\fg\u000eC\u0005b\u0005\u0017\u0001\n\u00111\u0001\u0003\"A\u0019qLa\t\n\u0007\t\u0015\u0002MA\u0006BEN$(/Y2u\u0019><\u0007B\u0003B\u0015\u0005\u0017\u0001\n\u00111\u0001\u0003,\u0005QAo\u001c9jG&#w\n\u001d;\u0011\u000b%\u0011iC!\r\n\u0007\t=\"B\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0007\u0013\u0019$\u0003\u0003\u00036\u0005\u0015%\u0001B+V\u0013\u0012CqA!\u000f\u0001\t\u0003\tY'\u0001\u0018uKN$\u0018\t\u001d9f]\u0012\u0014VmY8sIN\f5OR8mY><XM\u001d\"fY><Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b\u0006\u0002B\u001c\u0003oCqAa\u0010\u0001\t\u0003\tY'A\u000fuKN$H*[:u\u001f\u001a47/\u001a;Jg>d\u0017\r^5p]2+g/\u001a7tQ\u0011\u0011i$a.\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002l\u0005qA/Z:u\u000f\u0016$(+\u001a9mS\u000e\f\u0007\u0006\u0002B\"\u0003oCqAa\u0013\u0001\t\u0003\tY'A\u001cuKN$\u0018\t\u001d9f]\u0012\u0014VmY8sIN$vNR8mY><XM],ji\"tuNU3qY&\u001c\u0017\r\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0005\u0005\u0013\n9\fC\u0004\u0003R\u0001!\t!a\u001b\u0002IQ,7\u000f^'bW\u00164u\u000e\u001c7po\u0016\u0014x+\u001b;i\u001d>dU-\u00193fe&#7\t[1oO\u0016DCAa\u0014\u00028\"9!q\u000b\u0001\u0005\u0002\u0005-\u0014a\u0012;fgR4u\u000e\u001c7po\u0016\u0014Hi\\3t\u001d>$(j\\5o\u0013N\u0013VK\u001c;jY\u000e\u000bWo\u001a5u+B$vn\u00144gg\u0016$x+\u001b;iS:\u001cUO\u001d:f]RdU-\u00193fe\u0016\u0003xn\u00195)\t\tU\u0013q\u0017\u0005\b\u0005;\u0002A\u0011AA6\u0003\t\"Xm\u001d;EK2\f\u00170\u001a3GKR\u001c\u0007.\u00114uKJ\f\u0005\u000f]3oIJ+7m\u001c:eg\"\"!1LA\\\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u0005K\nA\"Y:tKJ$xJ\u001a4tKR$R\u0001\u0012B4\u0005cB\u0001B!\u001b\u0003b\u0001\u0007!1N\u0001\tKb\u0004Xm\u0019;fIB\u0019\u0011B!\u001c\n\u0007\t=$B\u0001\u0003M_:<\u0007\u0002\u0003B:\u0005C\u0002\rA!\u001e\u0002%QLW.Z:uC6\u0004\u0018I\u001c3PM\u001a\u001cX\r\u001e\t\u0005\u0005o\u0012YJ\u0004\u0003\u0003z\tUe\u0002\u0002B>\u0005#sAA! \u0003\u0010:!!q\u0010BG\u001d\u0011\u0011\tIa#\u000f\t\t\r%\u0011R\u0007\u0003\u0005\u000bS1Aa\"\u0007\u0003\u0019a$o\\8u}%\ta%\u0003\u0002%K%\u0011QaI\u0005\u0003C\tJ1Aa%!\u0003\u0019\u0011XmY8sI&!!q\u0013BM\u0003-1\u0015\u000e\\3SK\u000e|'\u000fZ:\u000b\u0007\tM\u0005%\u0003\u0003\u0003\u001e\n}%A\u0005+j[\u0016\u001cH/Y7q\u0003:$wJ\u001a4tKRTAAa&\u0003\u001a\"9!1\u0015\u0001\u0005\u0002\t\u0015\u0016!D2sK\u0006$XMU3d_J$7\u000f\u0006\u0005\u0003(\n=&1\u001aBh!\u0011\u0011IKa+\u000e\u0005\te\u0015\u0002\u0002BW\u00053\u0013Q\"T3n_JL(+Z2pe\u0012\u001c\b\u0002\u0003BY\u0005C\u0003\rAa-\u0002\u000fI,7m\u001c:egB1!Q\u0017B`\u0005\u000btAAa.\u0003<:!!1\u0011B]\u0013\u0005Y\u0011b\u0001B_\u0015\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002Ba\u0005\u0007\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005{S\u0001\u0003\u0002BU\u0005\u000fLAA!3\u0003\u001a\na1+[7qY\u0016\u0014VmY8sI\"A!Q\u001aBQ\u0001\u0004\u0011Y'\u0001\u0006cCN,wJ\u001a4tKRD\u0011B!5\u0003\"B\u0005\t\u0019\u0001\f\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0011\u001d\u0011)\u000e\u0001C\u0001\u0005/\f!d\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0014VmY8sIN$\u0002Ba*\u0003Z\nm'Q\u001c\u0005\t\u0005c\u0013\u0019\u000e1\u0001\u00034\"A!Q\u001aBj\u0001\u0004\u0011Y\u0007C\u0005\u0003R\nM\u0007\u0013!a\u0001-!9!\u0011\u001d\u0001\u0005\u0002\u0005-\u0014\u0001\u0004;fgR\fE/T5o\u0013N\u0014\b\u0006\u0002Bp\u0003oCqAa:\u0001\t\u0003\tY'\u0001\u000fuKN$X\u000b\u001d3bi\u00164u\u000e\u001c7po\u0016\u0014h)\u001a;dQN#\u0018\r^3)\t\t\u0015\u0018q\u0017\u0005\b\u0005[\u0004A\u0011AA6\u0003A!Xm\u001d;JgJ,\u0005\u0010]1og&|g\u000e\u000b\u0003\u0003l\u0006]\u0006b\u0002Bz\u0001\u0011\u0005\u00111N\u0001 i\u0016\u001cH/S:s\u001d>$X\t\u001f9b]\u0012,G-\u00134Va\u0012\fG/\u001a$bS2\u001c\b\u0006\u0002By\u0003oCqA!?\u0001\t\u0003\tY'\u0001\nuKN$X*Y=cKNC'/\u001b8l\u0013N\u0014\b\u0006\u0002B|\u0003oCqAa@\u0001\t\u0003\tY'A\u0018uKN$8\u000b[8vY\u0012tu\u000e^*ie&t7.S:s\u0013\u001a\u0004&/\u001a<j_V\u001ch)\u001a;dQ&\u001b8)Y;hQR,\u0006\u000f\u000b\u0003\u0003~\u0006]\u0006bBB\u0003\u0001\u0011\u0005\u00111N\u00011i\u0016\u001cHo\u00155pk2$gj\u001c;TQJLgn[%te&3gi\u001c7m_^,'oQ1vO\"$X\u000b\u001d+p\u0019><WI\u001c3)\t\r\r\u0011q\u0017\u0005\b\u0007\u0017\u0001A\u0011AA6\u0003u!Xm\u001d;JgJtu\u000e^*ieVt7.\u00134Va\u0012\fG/\u001a$bS2\u001c\b\u0006BB\u0005\u0003oCqa!\u0005\u0001\t\u0003\tY'\u0001\u0016uKN$Xk]3DQ\u0016\u001c7\u000e]8j]R$v.\u00138ji&\fG.\u001b>f\u0011&<\u0007nV1uKJl\u0017M]6)\t\r=\u0011q\u0017\u0005\b\u0007/\u0001A\u0011AA6\u0003]!Xm\u001d;BI\u0012\fe\u000e\u001a*f[>4X-T3ue&\u001c7\u000f\u000b\u0003\u0004\u0016\u0005]\u0006bBB\u000f\u0001\u0011\u0005\u00111N\u0001\u0016i\u0016\u001cH\u000fT8h\u0007>tg-[4O_R$\u0015N\u001d;zQ\u0011\u0019Y\"a.\t\u000f\r\r\u0002\u0001\"\u0001\u0002l\u0005\u0001C/Z:u\u0019><7i\u001c8gS\u001e$\u0015N\u001d;z\u0003N$v\u000e]5d+B$\u0017\r^3eQ\u0011\u0019\t#a.\t\u000f\r%\u0002\u0001\"\u0001\u0002l\u0005\tC/Z:u\u0019><7i\u001c8gS\u001e$\u0015N\u001d;z\u0003N\u0014%o\\6feV\u0003H-\u0019;fI\"\"1qEA\\\u0011\u001d\u0019y\u0003\u0001C\u0001\u0003W\n\u0011\u0004^3ti6\u000b7.\u001a'fC\u0012,'oV5uQR{\u0007/[2JI\"\"1QFA\\\u0011\u001d\u0019)\u0004\u0001C\u0001\u0003W\n1\u0004^3ti6\u000b7.\u001a$pY2|w/\u001a:XSRDGk\u001c9jG&#\u0007\u0006BB\u001a\u0003oCqaa\u000f\u0001\t\u0003\tY'\u0001\u0011uKN$8\u000b[8vY\u0012\u0014V-\\8wK>\u00137/\u001a:wKJ\u001chI]8n\u0013N\u0014\b\u0006BB\u001d\u0003oCqa!\u0011\u0001\t\u0003\tY'A\u001duKN$8\u000b[8vY\u0012tu\u000e\u001e*f[>4Xm\u00142tKJ4XM\u001d$s_6L5O]%g)\"\fGoQ1vg\u0016\u001cXK\u001c3fe6Kg.S:sQ\u0011\u0019y$a.\t\u000f\r\u001d\u0003\u0001\"\u0001\u0002l\u0005\u0019D/Z:u'\"|W\u000f\u001c3BI\u0012\fE\u000e\u001c*fa2L7-Y:U_&\u001b(o\u00165f]2+\u0017\rZ3s\u0013N\fen\u00142tKJ4XM\u001d\u0015\u0005\u0007\u000b\n9\fC\u0004\u0004N\u0001!\t!a\u001b\u0002oQ,7\u000f^*i_VdGMT8u\u0003\u0012$wJY:feZ,'o\u001d+p\u0013N\u0014x\u000b[3o\u0019\u0016\fG-\u001a:Jg:{G/\u00118PEN,'O^3sQ\u0011\u0019Y%a.\t\u000f\rM\u0003\u0001\"\u0001\u0002l\u00051D/Z:u'\"|W\u000f\u001c3BI\u0012\u001c\u0016P\\2SKBd\u0017nY1U_&\u001b(o\u00165f]2+\u0017\rZ3s\u0013Ntu\u000e^!o\u001f\n\u001cXM\u001d<fe\"\"1\u0011KA\\\u0011\u001d\u0019I\u0006\u0001C\u0005\u00077\n1b]3fI2{w\rR1uCR9Ai!\u0018\u0004`\r\r\u0004bB1\u0004X\u0001\u0007!\u0011\u0005\u0005\b\u0007C\u001a9\u00061\u0001\u0017\u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\b\u0005'\u00199\u00061\u0001\u0017\u0011%\u00199\u0007AI\u0001\n\u0013\u0019I'A\u0011tKR,\b\u000fU1si&$\u0018n\u001c8XSRDWj\\2lg\u0012\"WMZ1vYR$3'\u0006\u0002\u0004l)\"!\u0011EB7W\t\u0019y\u0007\u0005\u0003\u0004r\rmTBAB:\u0015\u0011\u0019)ha\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAB=\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\ru41\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CBA\u0001E\u0005I\u0011BBB\u0003\u0005\u001aX\r^;q!\u0006\u0014H/\u001b;j_:<\u0016\u000e\u001e5N_\u000e\\7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019)I\u000b\u0003\u0003,\r5\u0004\"CBE\u0001E\u0005I\u0011ABF\u0003]\u0019'/Z1uKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0004\u000e*\u001aac!\u001c\t\u0013\rE\u0005!%A\u0005\u0002\r-\u0015\u0001J2sK\u0006$X\r\u0016:b]N\f7\r^5p]\u0006d'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\b\u000f\rU%\u0001#\u0001\u0004\u0018\u0006i\u0001+\u0019:uSRLwN\u001c+fgR\u00042AEBM\r\u0019\t!\u0001#\u0001\u0004\u001cN\u00191\u0011\u0014\u0005\t\u000f=\u0019I\n\"\u0001\u0004 R\u00111q\u0013\u0005\t\u0007G\u001bI\n\"\u0001\u0004&\u0006\u0001Rn\\2l\u00032Lg/\u001a\"s_.,'o\u001d\u000b\u0006\t\u000e\u001d6\u0011\u0016\u0005\t\u0003\u001f\u0019\t\u000b1\u0001\u0002\u0014!A11VBQ\u0001\u0004\u0019i+A\u0002jIN\u0004RA!.\u0003@Z\u0001")
public class PartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private LogManager logManager;
    private LogConfig logConfig;
    private final PartitionStateStore stateStore = (PartitionStateStore)Mockito.mock(PartitionStateStore.class);
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private final TierReplicaManager tierReplicaManager = (TierReplicaManager)Mockito.mock(TierReplicaManager.class);
    private Partition partition;

    public static void mockAliveBrokers(MetadataCache metadataCache, Iterable<Object> iterable) {
        PartitionTest$.MODULE$.mockAliveBrokers(metadataCache, iterable);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public PartitionStateStore stateStore() {
        return this.stateStore;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @Before
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$9 = false;
        int x$10 = CleanerConfig$.MODULE$.apply$default$1();
        long x$11 = CleanerConfig$.MODULE$.apply$default$2();
        double x$12 = CleanerConfig$.MODULE$.apply$default$3();
        int x$13 = CleanerConfig$.MODULE$.apply$default$4();
        int x$14 = CleanerConfig$.MODULE$.apply$default$5();
        double x$15 = CleanerConfig$.MODULE$.apply$default$6();
        long x$16 = CleanerConfig$.MODULE$.apply$default$7();
        int x$17 = CleanerConfig$.MODULE$.apply$default$9();
        String x$18 = CleanerConfig$.MODULE$.apply$default$10();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), new CleanerConfig(x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$9, x$17, x$18), this.time(), TierLogComponents$.MODULE$.EMPTY()));
        this.logManager().startup();
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), this.logManager(), (Option)new Some((Object)this.tierReplicaManager())));
        Mockito.when((Object)this.stateStore().fetchTopicConfig()).thenReturn((Object)this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1)new Serializable(this, logProps){
            public static final long serialVersionUID = 0L;
            private final Properties logProps$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.logProps$1.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.logProps$1 = logProps$1;
            }
        });
        return var2_2;
    }

    @After
    public void tearDown() {
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$19 = this.topicPartition();
        Serializable x$20 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$21 = qual$1.getOrCreateLog$default$3();
        boolean x$22 = qual$1.getOrCreateLog$default$4();
        AbstractLog log2 = qual$1.getOrCreateLog(x$19, (Function0)x$20, x$21, x$22);
        log2.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(5), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}), 5, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log2.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log2, this.setupPartitionWithMocks$default$4());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderLogIfLocal().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(AbstractLog x$1) {
                return x$1.logEndOffset();
            }
        }));
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)leaderEpoch, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        int leaderEpoch = 8;
        LogConfig logConfig = new LogConfig((Map)this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_10_2_IV0$.MODULE$.shortVersion())})))), LogConfig$.MODULE$.apply$default$2());
        LogManager qual$2 = this.logManager();
        TopicPartition x$23 = this.topicPartition();
        Serializable x$24 = new Serializable(this, logConfig){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$1;

            public final LogConfig apply() {
                return this.logConfig$1;
            }
            {
                this.logConfig$1 = logConfig$1;
            }
        };
        boolean x$25 = qual$2.getOrCreateLog$default$3();
        boolean x$26 = qual$2.getOrCreateLog$default$4();
        AbstractLog log2 = qual$2.getOrCreateLog(x$23, (Function0)x$24, x$25, x$26);
        log2.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())})), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log2.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log2, this.setupPartitionWithMocks$default$4());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderLogIfLocal().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(AbstractLog x$2) {
                return x$2.logEndOffset();
            }
        }));
        Assert.assertEquals((Object)None$.MODULE$, (Object)log2.latestEpoch());
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)-1L, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(this.brokerId(), true, false, this.offsetCheckpoints());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Thread thread1 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                Partition qual$3 = this.$outer.partition();
                boolean x$27 = qual$3.removeFutureLocalReplica$default$1();
                qual$3.removeFutureLocalReplica(x$27);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread thread2 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                this.$outer.partition().maybeReplaceCurrentWithFutureReplica();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().futureLog());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplicaDifferentBaseOffsets() {
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(this.brokerId(), true, false, this.offsetCheckpoints());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        AbstractLog currentLog = (AbstractLog)this.partition().log().get();
        currentLog.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k1".getBytes(), "v2".getBytes()), new SimpleRecord("k1".getBytes(), "v3".getBytes()), new SimpleRecord("k2".getBytes(), "v4".getBytes()), new SimpleRecord("k2".getBytes(), "v5".getBytes()), new SimpleRecord("k2".getBytes(), "v6".getBytes())}), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4());
        currentLog.roll(currentLog.roll$default$1());
        currentLog.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v7".getBytes()), new SimpleRecord("k4".getBytes(), "v8".getBytes())}), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4());
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)-1L, (int)0);
        builder.appendWithOffset(2L, new SimpleRecord("k1".getBytes(), "v3".getBytes()));
        builder.appendWithOffset(5L, new SimpleRecord("k2".getBytes(), "v6".getBytes()));
        builder.appendWithOffset(6L, new SimpleRecord("k3".getBytes(), "v7".getBytes()));
        builder.appendWithOffset(7L, new SimpleRecord("k4".getBytes(), "v8".getBytes()));
        AbstractLog futureLog = this.partition().futureLocalLogOrException();
        futureLog.appendAsFollower(builder.build());
        Assert.assertTrue((boolean)this.partition().maybeReplaceCurrentWithFutureReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3(), this.setupPartitionWithMocks$default$4());
        this.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        this.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3(), this.setupPartitionWithMocks$default$4());
        this.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3(), this.setupPartitionWithMocks$default$4());
        this.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        this.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3(), this.setupPartitionWithMocks$default$4());
        this.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3(), this.setupPartitionWithMocks$default$4());
        this.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        this.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3(), this.setupPartitionWithMocks$default$4());
        this.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3(), this.setupPartitionWithMocks$default$4());
        this.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        this.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3(), this.setupPartitionWithMocks$default$4());
        this.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchLatestOffsetIncludesLeaderEpoch() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3(), this.setupPartitionWithMocks$default$4());
        Option timestampAndOffsetOpt = partition.fetchOffsetForTimestamp(-1L, (Option)None$.MODULE$, Optional.empty(), true);
        Assert.assertTrue((boolean)timestampAndOffsetOpt.isDefined());
        FileRecords.TimestampAndOffset timestampAndOffset = (FileRecords.TimestampAndOffset)timestampAndOffsetOpt.get();
        Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)timestampAndOffset.leaderEpoch());
    }

    @Test
    public void testMonotonicOffsetsAfterLeaderChange() {
        Either either;
        block5: {
            Either either2;
            block9: {
                Either either3;
                block14: {
                    Either either4;
                    block18: {
                        Either either5;
                        block22: {
                            Either either6;
                            block26: {
                                Either either7;
                                block31: {
                                    Either either8;
                                    block35: {
                                        block33: {
                                            Left left;
                                            ApiException e;
                                            block34: {
                                                Option option;
                                                Right right;
                                                boolean bl;
                                                block32: {
                                                    int leaderEpoch;
                                                    int follower2;
                                                    int follower1;
                                                    int leader2;
                                                    int controllerEpoch;
                                                    block28: {
                                                        ApiException e2;
                                                        Left left2;
                                                        boolean bl2;
                                                        block30: {
                                                            block29: {
                                                                Option option2;
                                                                Right right2;
                                                                boolean bl3;
                                                                block27: {
                                                                    block24: {
                                                                        Left left3;
                                                                        ApiException e3;
                                                                        block25: {
                                                                            Option option3;
                                                                            Right right3;
                                                                            boolean bl4;
                                                                            block23: {
                                                                                block20: {
                                                                                    Left left4;
                                                                                    ApiException e4;
                                                                                    block21: {
                                                                                        Option option4;
                                                                                        Right right4;
                                                                                        boolean bl5;
                                                                                        block19: {
                                                                                            block16: {
                                                                                                Left left5;
                                                                                                ApiException e5;
                                                                                                block17: {
                                                                                                    Option option5;
                                                                                                    Right right5;
                                                                                                    boolean bl6;
                                                                                                    block15: {
                                                                                                        block11: {
                                                                                                            ApiException e6;
                                                                                                            Left left6;
                                                                                                            boolean bl7;
                                                                                                            block13: {
                                                                                                                block12: {
                                                                                                                    Option option6;
                                                                                                                    Right right6;
                                                                                                                    boolean bl8;
                                                                                                                    block10: {
                                                                                                                        java.util.List isr;
                                                                                                                        List replicas;
                                                                                                                        int controllerId;
                                                                                                                        block7: {
                                                                                                                            block8: {
                                                                                                                                Option option7;
                                                                                                                                Right right7;
                                                                                                                                boolean bl9;
                                                                                                                                block6: {
                                                                                                                                    block3: {
                                                                                                                                        block4: {
                                                                                                                                            Option option8;
                                                                                                                                            Right right8;
                                                                                                                                            boolean bl10;
                                                                                                                                            block2: {
                                                                                                                                                controllerEpoch = 3;
                                                                                                                                                leader2 = this.brokerId();
                                                                                                                                                follower1 = this.brokerId() + 1;
                                                                                                                                                follower2 = this.brokerId() + 2;
                                                                                                                                                controllerId = this.brokerId() + 3;
                                                                                                                                                replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader2, follower1, follower2}));
                                                                                                                                                isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
                                                                                                                                                leaderEpoch = 8;
                                                                                                                                                MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                                                                                                                                MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord(20L, "k4".getBytes(), "v2".getBytes()), new SimpleRecord(21L, "k5".getBytes(), "v3".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                                                                                                                                LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader2).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)new Serializable(this){
                                                                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                                                                    public final Integer apply(int x) {
                                                                                                                                                        return BoxesRunTime.boxToInteger((int)x);
                                                                                                                                                    }
                                                                                                                                                }, List$.MODULE$.canBuildFrom())).asJava()).setIsNew(true);
                                                                                                                                                Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)this.partition().makeLeader(controllerId, leaderState, 0, this.offsetCheckpoints()));
                                                                                                                                                Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)this.partition().getLeaderEpoch());
                                                                                                                                                Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
                                                                                                                                                this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
                                                                                                                                                this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
                                                                                                                                                Assert.assertEquals((String)"Expected leader's HW not move", (long)this.partition().localLogOrException().logStartOffset(), (long)this.partition().localLogOrException().highWatermark());
                                                                                                                                                PartitionTest$.MODULE$.mockAliveBrokers(this.metadataCache(), (Iterable<Object>)replicas);
                                                                                                                                                Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(leader2, leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader2, follower2, follower1})), 1))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                                                                                                                                                this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                                                                                                                                this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                                                                                                                                this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                                                                                                                                this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                                                                                                                                Assert.assertEquals((long)2L, (long)this.partition().localLogOrException().highWatermark());
                                                                                                                                                bl10 = false;
                                                                                                                                                right8 = null;
                                                                                                                                                either = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                                                                                                                                                if (!(either instanceof Right)) break block2;
                                                                                                                                                bl10 = true;
                                                                                                                                                right8 = (Right)either;
                                                                                                                                                Option option9 = (Option)right8.b();
                                                                                                                                                if (!(option9 instanceof Some)) break block2;
                                                                                                                                                Some some = (Some)option9;
                                                                                                                                                FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                                                                                                                this.assertOffset(5L, offsetAndTimestamp);
                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                break block3;
                                                                                                                                            }
                                                                                                                                            if (!bl10 || !None$.MODULE$.equals(option8 = (Option)right8.b())) break block4;
                                                                                                                                            Assert.fail((String)"Should have seen some offsets");
                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                            break block3;
                                                                                                                                        }
                                                                                                                                        if (!(either instanceof Left)) break block5;
                                                                                                                                        Assert.fail((String)"Should not have seen an error");
                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                    }
                                                                                                                                    bl9 = false;
                                                                                                                                    right7 = null;
                                                                                                                                    either2 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                                                                                                                    if (!(either2 instanceof Right)) break block6;
                                                                                                                                    bl9 = true;
                                                                                                                                    right7 = (Right)either2;
                                                                                                                                    Option option10 = (Option)right7.b();
                                                                                                                                    if (!(option10 instanceof Some)) break block6;
                                                                                                                                    Some some = (Some)option10;
                                                                                                                                    FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                                                                                                    this.assertOffset(2L, offsetAndTimestamp);
                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                    break block7;
                                                                                                                                }
                                                                                                                                if (!bl9 || !None$.MODULE$.equals(option7 = (Option)right7.b())) break block8;
                                                                                                                                Assert.fail((String)"Should have seen some offsets");
                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                break block7;
                                                                                                                            }
                                                                                                                            if (!(either2 instanceof Left)) break block9;
                                                                                                                            Assert.fail((String)"Should not have seen an error");
                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                        }
                                                                                                                        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(30L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
                                                                                                                        LeaderAndIsrRequestData.LeaderAndIsrPartitionState followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(4).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)new Serializable(this){
                                                                                                                            public static final long serialVersionUID = 0L;

                                                                                                                            public final Integer apply(int x) {
                                                                                                                                return BoxesRunTime.boxToInteger((int)x);
                                                                                                                            }
                                                                                                                        }, List$.MODULE$.canBuildFrom())).asJava()).setIsNew(false);
                                                                                                                        Assert.assertTrue((boolean)this.partition().makeFollower(controllerId, followerState, 1, this.offsetCheckpoints()));
                                                                                                                        LeaderAndIsrRequestData.LeaderAndIsrPartitionState newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader2).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(5).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)new Serializable(this){
                                                                                                                            public static final long serialVersionUID = 0L;

                                                                                                                            public final Integer apply(int x) {
                                                                                                                                return BoxesRunTime.boxToInteger((int)x);
                                                                                                                            }
                                                                                                                        }, List$.MODULE$.canBuildFrom())).asJava()).setIsNew(false);
                                                                                                                        Assert.assertTrue((boolean)this.partition().makeLeader(controllerId, newLeaderState, 2, this.offsetCheckpoints()));
                                                                                                                        bl8 = false;
                                                                                                                        right6 = null;
                                                                                                                        bl7 = false;
                                                                                                                        left6 = null;
                                                                                                                        either3 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                                                                                                        if (!(either3 instanceof Right)) break block10;
                                                                                                                        bl8 = true;
                                                                                                                        right6 = (Right)either3;
                                                                                                                        Option option11 = (Option)right6.b();
                                                                                                                        if (!(option11 instanceof Some)) break block10;
                                                                                                                        Assert.fail((String)"Should have failed with OffsetNotAvailable");
                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                        break block11;
                                                                                                                    }
                                                                                                                    if (!bl8 || !None$.MODULE$.equals(option6 = (Option)right6.b())) break block12;
                                                                                                                    Assert.fail((String)"Should have seen an error");
                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                    break block11;
                                                                                                                }
                                                                                                                if (!(either3 instanceof Left)) break block13;
                                                                                                                bl7 = true;
                                                                                                                left6 = (Left)either3;
                                                                                                                ApiException e7 = (ApiException)left6.a();
                                                                                                                if (!(e7 instanceof OffsetNotAvailableException)) break block13;
                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                break block11;
                                                                                                            }
                                                                                                            if (!bl7 || (e6 = (ApiException)left6.a()) == null) break block14;
                                                                                                            ApiException apiException = e6;
                                                                                                            Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected OffsetNotAvailableException, got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                        }
                                                                                                        bl6 = false;
                                                                                                        right5 = null;
                                                                                                        either4 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                                                                                                        if (!(either4 instanceof Right)) break block15;
                                                                                                        bl6 = true;
                                                                                                        right5 = (Right)either4;
                                                                                                        Option option12 = (Option)right5.b();
                                                                                                        if (!(option12 instanceof Some)) break block15;
                                                                                                        Some some = (Some)option12;
                                                                                                        FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                                                                        this.assertOffset(5L, offsetAndTimestamp);
                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                        break block16;
                                                                                                    }
                                                                                                    if (!bl6 || !None$.MODULE$.equals(option5 = (Option)right5.b())) break block17;
                                                                                                    Assert.fail((String)"Should have seen some offsets");
                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                    break block16;
                                                                                                }
                                                                                                if (!(either4 instanceof Left) || (e5 = (ApiException)(left5 = (Left)either4).a()) == null) break block18;
                                                                                                ApiException apiException = e5;
                                                                                                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ApiException ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                            }
                                                                                            bl5 = false;
                                                                                            right4 = null;
                                                                                            either5 = this.fetchOffsetsForTimestamp$1(-2L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                                                                            if (!(either5 instanceof Right)) break block19;
                                                                                            bl5 = true;
                                                                                            right4 = (Right)either5;
                                                                                            Option option13 = (Option)right4.b();
                                                                                            if (!(option13 instanceof Some)) break block19;
                                                                                            Some some = (Some)option13;
                                                                                            FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                                                            this.assertOffset(0L, offsetAndTimestamp);
                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                            break block20;
                                                                                        }
                                                                                        if (!bl5 || !None$.MODULE$.equals(option4 = (Option)right4.b())) break block21;
                                                                                        Assert.fail((String)"Should have seen some offsets");
                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                        break block20;
                                                                                    }
                                                                                    if (!(either5 instanceof Left) || (e4 = (ApiException)(left4 = (Left)either5).a()) == null) break block22;
                                                                                    ApiException apiException = e4;
                                                                                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ApiException ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                }
                                                                                bl4 = false;
                                                                                right3 = null;
                                                                                either6 = this.fetchOffsetsForTimestamp$1(11L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                                                                if (!(either6 instanceof Right)) break block23;
                                                                                bl4 = true;
                                                                                right3 = (Right)either6;
                                                                                Option option14 = (Option)right3.b();
                                                                                if (!(option14 instanceof Some)) break block23;
                                                                                Some some = (Some)option14;
                                                                                FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                                                this.assertOffset(1L, offsetAndTimestamp);
                                                                                Assert.assertEquals((long)11L, (long)offsetAndTimestamp.timestamp());
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                break block24;
                                                                            }
                                                                            if (!bl4 || !None$.MODULE$.equals(option3 = (Option)right3.b())) break block25;
                                                                            Assert.fail((String)"Should have seen some offsets");
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            break block24;
                                                                        }
                                                                        if (!(either6 instanceof Left) || (e3 = (ApiException)(left3 = (Left)either6).a()) == null) break block26;
                                                                        ApiException apiException = e3;
                                                                        Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ApiException ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    }
                                                                    bl3 = false;
                                                                    right2 = null;
                                                                    bl2 = false;
                                                                    left2 = null;
                                                                    either7 = this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                                                    if (!(either7 instanceof Right)) break block27;
                                                                    bl3 = true;
                                                                    right2 = (Right)either7;
                                                                    Option option15 = (Option)right2.b();
                                                                    if (!(option15 instanceof Some)) break block27;
                                                                    Assert.fail((String)"Should have failed");
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    break block28;
                                                                }
                                                                if (!bl3 || !None$.MODULE$.equals(option2 = (Option)right2.b())) break block29;
                                                                Assert.fail((String)"Should have failed");
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                break block28;
                                                            }
                                                            if (!(either7 instanceof Left)) break block30;
                                                            bl2 = true;
                                                            left2 = (Left)either7;
                                                            ApiException e8 = (ApiException)left2.a();
                                                            if (!(e8 instanceof OffsetNotAvailableException)) break block30;
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            break block28;
                                                        }
                                                        if (!bl2 || (e2 = (ApiException)left2.a()) == null) break block31;
                                                        ApiException apiException = e2;
                                                        Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have seen OffsetNotAvailableException, saw ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    }
                                                    Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(leader2, leaderEpoch + 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader2, follower2, follower1})), 5))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                                                    this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                                    this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                                    bl = false;
                                                    right = null;
                                                    either8 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                                    if (!(either8 instanceof Right)) break block32;
                                                    bl = true;
                                                    right = (Right)either8;
                                                    Option option16 = (Option)right.b();
                                                    if (!(option16 instanceof Some)) break block32;
                                                    Some some = (Some)option16;
                                                    FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                    this.assertOffset(5L, offsetAndTimestamp);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block33;
                                                }
                                                if (!bl || !None$.MODULE$.equals(option = (Option)right.b())) break block34;
                                                Assert.fail((String)"Should have seen some offsets");
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block33;
                                            }
                                            if (!(either8 instanceof Left) || (e = (ApiException)(left = (Left)either8).a()) == null) break block35;
                                            ApiException apiException = e;
                                            Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ApiException ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        }
                                        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
                                        return;
                                    }
                                    throw new MatchError((Object)either8);
                                }
                                throw new MatchError((Object)either7);
                            }
                            throw new MatchError((Object)either6);
                        }
                        throw new MatchError((Object)either5);
                    }
                    throw new MatchError((Object)either4);
                }
                throw new MatchError((Object)either3);
            }
            throw new MatchError((Object)either2);
        }
        throw new MatchError((Object)either);
    }

    private Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader, AbstractLog log2, Option<UUID> topicIdOpt) {
        java.util.List replicas;
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        int controllerId = 0;
        int controllerEpoch = 0;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        if (isLeader) {
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
            topicIdOpt.foreach((Function1)new Serializable(this, partitionState){
                public static final long serialVersionUID = 0L;
                private final LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState$1;

                public final LeaderAndIsrRequestData.LeaderAndIsrPartitionState apply(UUID topicId) {
                    return this.partitionState$1.setTopicId(topicId);
                }
                {
                    this.partitionState$1 = partitionState$1;
                }
            });
            Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, partitionState, 0, this.offsetCheckpoints()));
            Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        } else {
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId() + 1).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
            topicIdOpt.foreach((Function1)new Serializable(this, partitionState){
                public static final long serialVersionUID = 0L;
                private final LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState$2;

                public final LeaderAndIsrRequestData.LeaderAndIsrPartitionState apply(UUID topicId) {
                    return this.partitionState$2.setTopicId(topicId);
                }
                {
                    this.partitionState$2 = partitionState$2;
                }
            });
            Assert.assertTrue((String)"Expected become follower transition to succeed", (boolean)this.partition().makeFollower(controllerId, partitionState, 0, this.offsetCheckpoints()));
            Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }

    private AbstractLog setupPartitionWithMocks$default$3() {
        LogManager qual$17 = this.logManager();
        TopicPartition x$80 = this.topicPartition();
        Serializable x$81 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$82 = qual$17.getOrCreateLog$default$3();
        boolean x$83 = qual$17.getOrCreateLog$default$4();
        return qual$17.getOrCreateLog(x$80, (Function0)x$81, x$82, x$83);
    }

    private Option<UUID> setupPartitionWithMocks$default$4() {
        return None$.MODULE$;
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        AbstractLog log2 = this.partition().localLogOrException();
        long initialLogStartOffset = 5L;
        this.partition().truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)log2.logEndOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)log2.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final Option<LogAppendInfo> apply() {
                return this.$outer.partition().appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 3L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)initialLogStartOffset, (long)log2.logEndOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())})), newLogStartOffset, this.createRecords$default$3());
        this.partition().appendRecordsToFollowerOrFutureReplica(records2, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)7L, (long)log2.logEndOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)newLogStartOffset, (long)log2.logStartOffset());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 7:"})).s((Seq)Nil$.MODULE$), (long)8L, (long)log2.logEndOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)log2.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final Option<LogAppendInfo> apply() {
                MemoryRecords records2 = this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), 3L, this.$outer.createRecords$default$3());
                return this.$outer.partition().appendRecordsToFollowerOrFutureReplica(records2, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)8L, (long)log2.logEndOffset());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 8:"})).s((Seq)Nil$.MODULE$), (long)9L, (long)log2.logEndOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)log2.logStartOffset());
    }

    @Test
    public void testListOffsetIsolationLevels() {
        java.util.List replicas;
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        MemoryRecords records2 = this.createTransactionalRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())})), 0L, this.createTransactionalRecords$default$3());
        this.partition().appendRecordsToLeader(records2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        this.assertOffset(3L, this.fetchLatestOffset$1((Option)None$.MODULE$));
        this.assertOffset(0L, this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
        this.assertOffset(0L, this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)));
        ((AbstractLog)this.partition().log().get()).updateHighWatermark(1L);
        this.assertOffset(3L, this.fetchLatestOffset$1((Option)None$.MODULE$));
        this.assertOffset(1L, this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
        this.assertOffset(0L, this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)));
        this.assertOffset(0L, this.fetchEarliestOffset$1((Option)None$.MODULE$));
        this.assertOffset(0L, this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
        this.assertOffset(0L, this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)));
    }

    @Test
    public void testGetReplica() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().log());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final AbstractLog apply() {
                return this.$outer.partition().localLogOrException();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final Option<LogAppendInfo> apply() {
                return this.$outer.partition().appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 0L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 823));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setIsNew(false);
        this.partition().makeFollower(0, partitionState, 0, this.offsetCheckpoints());
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setIsNew(false);
        Assert.assertTrue((boolean)this.partition().makeFollower(0, partitionState, 2, this.offsetCheckpoints()));
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava());
        Assert.assertFalse((boolean)this.partition().makeFollower(0, partitionState, 2, this.offsetCheckpoints()));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader2 = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord("k4".getBytes(), "v2".getBytes()), new SimpleRecord("k5".getBytes(), "v3".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k6".getBytes(), "v1".getBytes()), new SimpleRecord("k7".getBytes(), "v2".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader2).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)this.partition().makeLeader(controllerId, leaderState, 0, this.offsetCheckpoints()));
        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
        long lastOffsetOfFirstBatch = this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0).lastOffset();
        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        Assert.assertEquals((String)"Expected leader's HW not move", (long)this.partition().localLogOrException().logStartOffset(), (long)((AbstractLog)this.partition().log().get()).highWatermark());
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Expected leader's HW", (long)lastOffsetOfFirstBatch, (long)((AbstractLog)this.partition().log().get()).highWatermark());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeFollower(controllerId, followerState, 1, this.offsetCheckpoints());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader2).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        Assert.assertTrue((String)"Expected makeLeader() to return 'leader changed' after makeFollower()", (boolean)this.partition().makeLeader(controllerEpoch, newLeaderState, 2, this.offsetCheckpoints()));
        long currentLeaderEpochStartOffset = this.partition().localLogOrException().logEndOffset();
        this.partition().appendRecordsToLeader(batch3, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(leader2, leaderEpoch + 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader2, follower2, follower1})), 1))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(currentLeaderEpochStartOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
    }

    @Test
    public void testDelayedFetchAfterAppendRecords() {
        java.util.List replicaIds;
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicaIds = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        IndexedSeq topicPartitions2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(int i) {
                return new TopicPartition("test-topic", i);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq logs = (IndexedSeq)topicPartitions2.map((Function1)new Serializable(this, logConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            public final LogConfig logConfig$2;

            public final AbstractLog apply(TopicPartition tp) {
                LogManager qual$5 = this.$outer.logManager();
                TopicPartition x$32 = tp;
                Serializable x$33 = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final LogConfig apply() {
                        return this.$outer.logConfig$2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                boolean x$34 = qual$5.getOrCreateLog$default$3();
                boolean x$35 = qual$5.getOrCreateLog$default$4();
                return qual$5.getOrCreateLog(x$32, (Function0)x$33, x$34, x$35);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logConfig$2 = logConfig$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ListBuffer partitions = (ListBuffer)ListBuffer$.MODULE$.empty();
        logs.foreach((Function1)new Serializable(this, controllerId, controllerEpoch, leaderEpoch, replicaIds, isr, topicPartitions2, partitions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final int controllerId$1;
            private final int controllerEpoch$1;
            public final int leaderEpoch$1;
            private final java.util.List replicaIds$1;
            private final java.util.List isr$1;
            public final IndexedSeq topicPartitions$1;
            public final ListBuffer partitions$1;

            public final ListBuffer<Partition> apply(AbstractLog log2) {
                TopicPartition tp = log2.topicPartition();
                DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
                Partition partition = new Partition(tp, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.$outer.brokerId(), (Time)this.$outer.time(), this.$outer.stateStore(), delayedOperations, this.$outer.metadataCache(), this.$outer.logManager(), (Option)new Some(Mockito.mock(TierReplicaManager.class)));
                delayedOperations.checkAndCompleteFetch();
                Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this, tp){
                    private final /* synthetic */ $anonfun$testDelayedFetchAfterAppendRecords$2 $outer;
                    private final TopicPartition tp$1;

                    public void answer(InvocationOnMock invocation) {
                        int anotherPartition = (this.tp$1.partition() + 1) % this.$outer.topicPartitions$1.size();
                        Partition partition = (Partition)this.$outer.partitions$1.apply(anotherPartition);
                        partition.fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(this.$outer.leaderEpoch$1)), true);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tp$1 = tp$1;
                    }
                });
                partition.setLog(log2, false);
                LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(this.controllerEpoch$1).setLeader(this.$outer.brokerId()).setLeaderEpoch(this.leaderEpoch$1).setIsr(this.isr$1).setZkVersion(1).setReplicas(this.replicaIds$1).setIsNew(true);
                partition.makeLeader(this.controllerId$1, leaderState, 0, this.$outer.offsetCheckpoints());
                return this.partitions$1.$plus$eq((Object)partition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.controllerId$1 = controllerId$1;
                this.controllerEpoch$1 = controllerEpoch$1;
                this.leaderEpoch$1 = leaderEpoch$1;
                this.replicaIds$1 = replicaIds$1;
                this.isr$1 = isr$1;
                this.topicPartitions$1 = topicPartitions$1;
                this.partitions$1 = partitions$1;
            }
        });
        AtomicBoolean done = new AtomicBoolean();
        ExecutorService executor = Executors.newFixedThreadPool(topicPartitions2.size() + 1);
        try {
            try {
                executor.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, partitions, done){
                    public static final long serialVersionUID = 0L;
                    private final ListBuffer partitions$1;
                    private final AtomicBoolean done$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        while (!this.done$1.get()) {
                            this.partitions$1.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Partition x$3) {
                                    x$3.maybeShrinkIsr();
                                }
                            });
                        }
                        return;
                    }
                    {
                        this.partitions$1 = partitions$1;
                        this.done$1 = done$1;
                    }
                }));
                ListBuffer futures = (ListBuffer)partitions.map((Function1)new Serializable(this, executor){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionTest $outer;
                    private final ExecutorService executor$1;

                    public final Future<?> apply(Partition partition) {
                        return this.executor$1.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, partition){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$10 $outer;
                            public final Partition partition$9;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10000).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$10$$anonfun$apply$1 $outer;

                                    public final LogAppendInfo apply(int x$4) {
                                        return this.$outer.partition$9.appendRecordsToLeader(this.$outer.kafka$cluster$PartitionTest$$anonfun$$anonfun$$$outer().kafka$cluster$PartitionTest$$anonfun$$$outer().kafka$cluster$PartitionTest$$createRecords$1(0L), (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$10 kafka$cluster$PartitionTest$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.partition$9 = partition$9;
                            }
                        }));
                    }

                    public /* synthetic */ PartitionTest kafka$cluster$PartitionTest$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executor$1 = executor$1;
                    }
                }, ListBuffer$.MODULE$.canBuildFrom());
                futures.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Future<?> x$5) {
                        return x$5.get(15L, TimeUnit.SECONDS);
                    }
                });
                done.set(true);
            }
            catch (TimeoutException timeoutException) {
                String allThreads2 = TestUtils$.MODULE$.allThreadStackTraces();
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test timed out with exception ", ", thread stack traces: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timeoutException, allThreads2})));
            }
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    private void assertOffset(long expected, FileRecords.TimestampAndOffset timestampAndOffset) {
        Assert.assertTrue((boolean)(timestampAndOffset instanceof FileRecords.FileTimestampAndOffset));
        Assert.assertEquals((long)expected, (long)((FileRecords.FileTimestampAndOffset)timestampAndOffset).offset);
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records2, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$2;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$2.append(x$1);
            }
            {
                this.builder$2 = builder$2;
            }
        });
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records2, long baseOffset, int partitionLeaderEpoch) {
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (CompressionType)CompressionType.NONE, (long)baseOffset, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$3;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$3.append(x$1);
            }
            {
                this.builder$3 = builder$3;
            }
        });
        return builder.build();
    }

    public int createTransactionalRecords$default$3() {
        return 0;
    }

    @Test
    public void testAtMinIsr() {
        int controllerEpoch = 3;
        int leader2 = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2)}))).asJava();
        int leaderEpoch = 8;
        Assert.assertFalse((boolean)this.partition().isAtMinIsr());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader2).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        this.partition().makeLeader(controllerId, leaderState, 0, this.offsetCheckpoints());
        Assert.assertTrue((boolean)this.partition().isAtMinIsr());
    }

    @Test
    public void testUpdateFollowerFetchState() {
        java.util.List replicas;
        LogManager qual$6 = this.logManager();
        TopicPartition x$36 = this.topicPartition();
        Serializable x$37 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$38 = qual$6.getOrCreateLog$default$3();
        boolean x$39 = qual$6.getOrCreateLog$default$4();
        AbstractLog log2 = qual$6.getOrCreateLog(x$36, (Function0)x$37, x$38, x$39);
        this.seedLogData(log2, 6, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        long initializeTimeMs = this.time().milliseconds();
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), 0, this.offsetCheckpoints()));
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() / 2L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() / 2L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(6L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)this.time().milliseconds(), (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)6L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    @Test
    public void testIsrExpansion() {
        LogManager qual$7 = this.logManager();
        TopicPartition x$40 = this.topicPartition();
        Serializable x$41 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$42 = qual$7.getOrCreateLog$default$3();
        boolean x$43 = qual$7.getOrCreateLog$default$4();
        AbstractLog log2 = qual$7.getOrCreateLog(x$40, (Function0)x$41, x$42, x$43);
        this.seedLogData(log2, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        PartitionTest$.MODULE$.mockAliveBrokers(this.metadataCache(), (Iterable<Object>)replicas);
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x) {
                return BoxesRunTime.boxToInteger((int)x);
            }
        }, List$.MODULE$.canBuildFrom())).asJava()).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), 1);
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    @Test
    public void testIsrNotExpandedIfUpdateFails() {
        LogManager qual$8 = this.logManager();
        TopicPartition x$44 = this.topicPartition();
        Serializable x$45 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$46 = qual$8.getOrCreateLog$default$3();
        boolean x$47 = qual$8.getOrCreateLog$default$4();
        AbstractLog log2 = qual$8.getOrCreateLog(x$44, (Function0)x$45, x$46, x$47);
        this.seedLogData(log2, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        PartitionTest$.MODULE$.mockAliveBrokers(this.metadataCache(), (Iterable<Object>)replicas);
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x$1) {
                return x$1;
            }
        }, List$.MODULE$.canBuildFrom())).asJava()).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), 1);
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)None$.MODULE$);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    @Test
    public void testMaybeShrinkIsr() {
        LogManager qual$9 = this.logManager();
        TopicPartition x$48 = this.topicPartition();
        Serializable x$49 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$50 = qual$9.getOrCreateLog$default$3();
        boolean x$51 = qual$9.getOrCreateLog$default$4();
        AbstractLog log2 = qual$9.getOrCreateLog(x$48, (Function0)x$49, x$50, x$51);
        this.seedLogData(log2, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        PartitionTest$.MODULE$.mockAliveBrokers(this.metadataCache(), (Iterable<Object>)replicas);
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x) {
                return BoxesRunTime.boxToInteger((int)x);
            }
        }, List$.MODULE$.canBuildFrom())).asJava()).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), 1);
        Mockito.when((Object)this.stateStore().shrinkIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp() {
        LogManager qual$10 = this.logManager();
        TopicPartition x$52 = this.topicPartition();
        Serializable x$53 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$54 = qual$10.getOrCreateLog$default$3();
        boolean x$55 = qual$10.getOrCreateLog$default$4();
        AbstractLog log2 = qual$10.getOrCreateLog(x$52, (Function0)x$53, x$54, x$55);
        this.seedLogData(log2, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        PartitionTest$.MODULE$.mockAliveBrokers(this.metadataCache(), (Iterable<Object>)replicas);
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x) {
                return BoxesRunTime.boxToInteger((int)x);
            }
        }, List$.MODULE$.canBuildFrom())).asJava()).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(5000L);
        long firstFetchTimeMs = this.time().milliseconds();
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, firstFetchTimeMs, 10L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)5L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)5L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(5001L);
        this.seedLogData(log2, 5, leaderEpoch);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 15L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)firstFetchTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
    }

    @Test
    public void testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd() {
        LogManager qual$11 = this.logManager();
        TopicPartition x$56 = this.topicPartition();
        Serializable x$57 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$58 = qual$11.getOrCreateLog$default$3();
        boolean x$59 = qual$11.getOrCreateLog$default$4();
        AbstractLog log2 = qual$11.getOrCreateLog(x$56, (Function0)x$57, x$58, x$59);
        this.seedLogData(log2, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        PartitionTest$.MODULE$.mockAliveBrokers(this.metadataCache(), (Iterable<Object>)replicas);
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x) {
                return BoxesRunTime.boxToInteger((int)x);
            }
        }, List$.MODULE$.canBuildFrom())).asJava()).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
    }

    @Test
    public void testIsrNotShrunkIfUpdateFails() {
        LogManager qual$12 = this.logManager();
        TopicPartition x$60 = this.topicPartition();
        Serializable x$61 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$62 = qual$12.getOrCreateLog$default$3();
        boolean x$63 = qual$12.getOrCreateLog$default$4();
        AbstractLog log2 = qual$12.getOrCreateLog(x$60, (Function0)x$61, x$62, x$63);
        this.seedLogData(log2, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        PartitionTest$.MODULE$.mockAliveBrokers(this.metadataCache(), (Iterable<Object>)replicas);
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x$1) {
                return x$1;
            }
        }, List$.MODULE$.canBuildFrom())).asJava()).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), 1);
        Mockito.when((Object)this.stateStore().shrinkIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)None$.MODULE$);
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testUseCheckpointToInitializeHighWatermark() {
        LogManager qual$13 = this.logManager();
        TopicPartition x$64 = this.topicPartition();
        Serializable x$65 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$66 = qual$13.getOrCreateLog$default$3();
        boolean x$67 = qual$13.getOrCreateLog$default$4();
        AbstractLog log2 = qual$13.getOrCreateLog(x$64, (Function0)x$65, x$66, x$67);
        this.seedLogData(log2, 6, 5);
        Mockito.when((Object)this.offsetCheckpoints().fetch(this.logDir1().getAbsolutePath(), this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)4L)));
        int controllerId = 0;
        int controllerEpoch = 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(controllerId, leaderState, 0, this.offsetCheckpoints());
        Assert.assertEquals((long)4L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAddAndRemoveMetrics() {
        List metricsToCheck = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnderReplicated", "UnderMinIsr", "InSyncReplicasCount", "CaughtUpReplicasCount", "ReplicasCount", "LastStableOffsetLag", "AtMinIsr", "IsNotCaughtUp", "ObserverReplicasCount"}));
        Assert.assertTrue((boolean)metricsToCheck.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final boolean apply(String x$7) {
                return this.$outer.kafka$cluster$PartitionTest$$getMetric$1(x$7).isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        Partition$.MODULE$.removeMetrics(this.topicPartition());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$8) {
                String string = x$8.getType();
                String string2 = "Partition";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }));
    }

    @Test
    public void testLogConfigNotDirty() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Partition partition = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), spyLogManager, (Option)None$.MODULE$);
        partition.createLog(this.brokerId(), true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore())).fetchTopicConfig();
    }

    @Test
    public void testLogConfigDirtyAsTopicUpdated() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ PartitionTest $outer;

            public void answer(InvocationOnMock invocation) {
                this.$outer.logManager().initializingLog(this.$outer.topicPartition());
                this.$outer.logManager().topicConfigUpdated(this.$outer.topicPartition().topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        Partition partition = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), spyLogManager, (Option)None$.MODULE$);
        partition.createLog(this.brokerId(), true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore(), (VerificationMode)Mockito.times((int)2))).fetchTopicConfig();
    }

    @Test
    public void testLogConfigDirtyAsBrokerUpdated() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ PartitionTest $outer;

            public void answer(InvocationOnMock invocation) {
                this.$outer.logManager().initializingLog(this.$outer.topicPartition());
                this.$outer.logManager().brokerConfigUpdated();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        Partition partition = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), spyLogManager, (Option)None$.MODULE$);
        partition.createLog(this.brokerId(), true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore(), (VerificationMode)Mockito.times((int)2))).fetchTopicConfig();
    }

    @Test
    public void testMakeLeaderWithTopicId() {
        int leaderEpoch = 7;
        LogManager qual$14 = this.logManager();
        TopicPartition x$68 = this.topicPartition();
        Serializable x$69 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$70 = qual$14.getOrCreateLog$default$3();
        boolean x$71 = qual$14.getOrCreateLog$default$4();
        AbstractLog log2 = qual$14.getOrCreateLog(x$68, (Function0)x$69, x$70, x$71);
        TierPartitionState tierPartitionState2 = log2.tierPartitionState();
        UUID topicId = UUID.randomUUID();
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log2, (Option<UUID>)new Some((Object)topicId));
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)partition.assignmentState().replicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x) {
                return BoxesRunTime.boxToInteger((int)x);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava();
        Assert.assertTrue((boolean)tierPartitionState2.topicIdPartition().isPresent());
        ((TierReplicaManager)Mockito.verify((Object)this.tierReplicaManager(), (VerificationMode)Mockito.times((int)1))).becomeLeader(tierPartitionState2, leaderEpoch);
        leaderEpoch = 8;
        partition.makeLeader(0, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(leaderEpoch).setIsr(replicas).setReplicas(replicas).setZkVersion(1).setIsNew(true), 0, this.offsetCheckpoints());
        Assert.assertTrue((boolean)tierPartitionState2.topicIdPartition().isPresent());
        ((TierReplicaManager)Mockito.verify((Object)this.tierReplicaManager(), (VerificationMode)Mockito.times((int)1))).becomeLeader(tierPartitionState2, leaderEpoch);
    }

    @Test
    public void testMakeFollowerWithTopicId() {
        int leaderEpoch = 7;
        LogManager qual$15 = this.logManager();
        TopicPartition x$72 = this.topicPartition();
        Serializable x$73 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$74 = qual$15.getOrCreateLog$default$3();
        boolean x$75 = qual$15.getOrCreateLog$default$4();
        AbstractLog log2 = qual$15.getOrCreateLog(x$72, (Function0)x$73, x$74, x$75);
        TierPartitionState tierPartitionState2 = log2.tierPartitionState();
        UUID topicId = UUID.randomUUID();
        this.setupPartitionWithMocks(leaderEpoch, false, log2, (Option<UUID>)new Some((Object)topicId));
        Assert.assertTrue((boolean)tierPartitionState2.topicIdPartition().isPresent());
        ((TierReplicaManager)Mockito.verify((Object)this.tierReplicaManager(), (VerificationMode)Mockito.times((int)1))).becomeFollower(tierPartitionState2);
    }

    @Test
    public void testShouldRemoveObserversFromIsr() {
        int zkVersion = 23934;
        int controllerEpoch = 137;
        int leaderEpoch = 245;
        int syncReplicaId1 = this.brokerId();
        int syncReplicaId2 = this.brokerId() + 1;
        int observerId1 = this.brokerId() + 2;
        int observerId2 = this.brokerId() + 3;
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrUpdate = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeader(syncReplicaId1).setLeaderEpoch(leaderEpoch).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(syncReplicaId1), Predef$.MODULE$.int2Integer(syncReplicaId2), Predef$.MODULE$.int2Integer(observerId1), Predef$.MODULE$.int2Integer(observerId2)}))).asJava()).setControllerEpoch(controllerEpoch).setObservers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(observerId1), Predef$.MODULE$.int2Integer(observerId2)}))).asJava()).setTopicName(this.topicPartition().topic()).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(syncReplicaId1), Predef$.MODULE$.int2Integer(syncReplicaId2), Predef$.MODULE$.int2Integer(observerId1)}))).asJava()).setZkVersion(zkVersion).setPartitionIndex(0);
        Assert.assertTrue((boolean)this.partition().makeLeader(1, leaderAndIsrUpdate, 2334, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId1, observerId2})), (Object)this.partition().assignmentState().observers());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2, observerId1})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2, observerId1, observerId2})), (Object)this.partition().assignmentState().replicas());
        Assert.assertFalse((boolean)this.partition().isUnderReplicated());
        Mockito.when((Object)this.stateStore().shrinkIsr(controllerEpoch, new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2})), zkVersion))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(zkVersion + 1))));
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId1, observerId2})), (Object)this.partition().assignmentState().observers());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2, observerId1, observerId2})), (Object)this.partition().assignmentState().replicas());
        Assert.assertFalse((boolean)this.partition().isUnderReplicated());
    }

    @Test
    public void testShouldNotRemoveObserverFromIsrIfThatCausesUnderMinIsr() {
        LogConfig logConfig = new LogConfig((Map)this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MinInSyncReplicasProp()), (Object)"2")})))), LogConfig$.MODULE$.apply$default$2());
        LogManager qual$16 = this.logManager();
        TopicPartition x$76 = this.topicPartition();
        Serializable x$77 = new Serializable(this, logConfig){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$3;

            public final LogConfig apply() {
                return this.logConfig$3;
            }
            {
                this.logConfig$3 = logConfig$3;
            }
        };
        boolean x$78 = qual$16.getOrCreateLog$default$3();
        boolean x$79 = qual$16.getOrCreateLog$default$4();
        qual$16.getOrCreateLog(x$76, (Function0)x$77, x$78, x$79);
        int zkVersion = 23934;
        int controllerEpoch = 137;
        int leaderEpoch = 245;
        int syncReplicaId1 = this.brokerId();
        int syncReplicaId2 = this.brokerId() + 1;
        int observerId1 = this.brokerId() + 2;
        int observerId2 = this.brokerId() + 3;
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrUpdate = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeader(syncReplicaId1).setLeaderEpoch(leaderEpoch).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(syncReplicaId1), Predef$.MODULE$.int2Integer(syncReplicaId2), Predef$.MODULE$.int2Integer(observerId1), Predef$.MODULE$.int2Integer(observerId2)}))).asJava()).setControllerEpoch(controllerEpoch).setObservers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(observerId1), Predef$.MODULE$.int2Integer(observerId2)}))).asJava()).setTopicName(this.topicPartition().topic()).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(syncReplicaId1), Predef$.MODULE$.int2Integer(observerId1)}))).asJava()).setZkVersion(zkVersion).setPartitionIndex(0);
        Assert.assertTrue((boolean)this.partition().makeLeader(1, leaderAndIsrUpdate, 2334, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId1, observerId2})), (Object)this.partition().assignmentState().observers());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, observerId1})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2, observerId1, observerId2})), (Object)this.partition().assignmentState().replicas());
        Assert.assertFalse((boolean)this.partition().isUnderReplicated());
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId1, observerId2})), (Object)this.partition().assignmentState().observers());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, observerId1})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2, observerId1, observerId2})), (Object)this.partition().assignmentState().replicas());
        Assert.assertFalse((boolean)this.partition().isUnderReplicated());
    }

    @Test
    public void testShouldAddAllReplicasToIsrWhenLeaderIsAnObserver() {
        int zkVersion = 23934;
        int controllerEpoch = 137;
        int leaderEpoch = 245;
        int observerId1 = this.brokerId();
        int observerId2 = this.brokerId() + 1;
        int syncReplicaId1 = this.brokerId() + 2;
        int syncReplicaId2 = this.brokerId() + 3;
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrUpdate = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeader(observerId1).setLeaderEpoch(leaderEpoch).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(syncReplicaId1), Predef$.MODULE$.int2Integer(syncReplicaId2), Predef$.MODULE$.int2Integer(observerId1), Predef$.MODULE$.int2Integer(observerId2)}))).asJava()).setControllerEpoch(controllerEpoch).setObservers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(observerId1), Predef$.MODULE$.int2Integer(observerId2)}))).asJava()).setTopicName(this.topicPartition().topic()).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(observerId1)}))).asJava()).setZkVersion(zkVersion).setPartitionIndex(0);
        Assert.assertTrue((boolean)this.partition().makeLeader(1, leaderAndIsrUpdate, 2334, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId1, observerId2})), (Object)this.partition().assignmentState().observers());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId1})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2, observerId1, observerId2})), (Object)this.partition().assignmentState().replicas());
        Assert.assertTrue((boolean)this.partition().isUnderReplicated());
        ObjectRef expectedIsr = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId1}))));
        IntRef expectedZkVersion = IntRef.create((int)zkVersion);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId2, syncReplicaId1, syncReplicaId2}))).foreach((Function1)new Serializable(this, controllerEpoch, leaderEpoch, observerId1, observerId2, syncReplicaId1, syncReplicaId2, expectedIsr, expectedZkVersion){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final int controllerEpoch$2;
            private final int leaderEpoch$3;
            private final int observerId1$1;
            private final int observerId2$1;
            private final int syncReplicaId1$1;
            private final int syncReplicaId2$1;
            private final ObjectRef expectedIsr$1;
            private final IntRef expectedZkVersion$1;

            public final void apply(int replicaId) {
                this.apply$mcVI$sp(replicaId);
            }

            public void apply$mcVI$sp(int replicaId) {
                this.expectedIsr$1.elem = (Seq)((Seq)this.expectedIsr$1.elem).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), Seq$.MODULE$.canBuildFrom());
                ++this.expectedZkVersion$1.elem;
                Mockito.when((Object)this.$outer.stateStore().expandIsr(this.controllerEpoch$2, new LeaderAndIsr(this.$outer.brokerId(), this.leaderEpoch$3, ((Seq)this.expectedIsr$1.elem).toList(), this.expectedZkVersion$1.elem - 1))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.expectedZkVersion$1.elem)));
                this.$outer.partition().updateFollowerFetchState(replicaId, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.$outer.time().milliseconds(), 0L, this.$outer.partition().localLogOrException().highWatermark());
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.observerId1$1, this.observerId2$1})), (Object)this.$outer.partition().assignmentState().observers());
                Assert.assertEquals((Object)((Seq)this.expectedIsr$1.elem).toSet(), (Object)this.$outer.partition().inSyncReplicaIds());
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.syncReplicaId1$1, this.syncReplicaId2$1, this.observerId1$1, this.observerId2$1})), (Object)this.$outer.partition().assignmentState().replicas());
                Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((this.$outer.partition().inSyncReplicaIds().size() < 2 ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.partition().isUnderReplicated()));
                Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((this.$outer.partition().inSyncReplicaIds().size() < 4 ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.partition().isNotCaughtUp()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.controllerEpoch$2 = controllerEpoch$2;
                this.leaderEpoch$3 = leaderEpoch$3;
                this.observerId1$1 = observerId1$1;
                this.observerId2$1 = observerId2$1;
                this.syncReplicaId1$1 = syncReplicaId1$1;
                this.syncReplicaId2$1 = syncReplicaId2$1;
                this.expectedIsr$1 = expectedIsr$1;
                this.expectedZkVersion$1 = expectedZkVersion$1;
            }
        });
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUnderReplicated()));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isNotCaughtUp()));
    }

    @Test
    public void testShouldNotAddObserversToIsrWhenLeaderIsNotAnObserver() {
        int zkVersion = 23934;
        int controllerEpoch = 137;
        int leaderEpoch = 245;
        int syncReplicaId1 = this.brokerId();
        int syncReplicaId2 = this.brokerId() + 1;
        int observerId1 = this.brokerId() + 2;
        int observerId2 = this.brokerId() + 3;
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrUpdate = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeader(syncReplicaId1).setLeaderEpoch(leaderEpoch).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(syncReplicaId1), Predef$.MODULE$.int2Integer(syncReplicaId2), Predef$.MODULE$.int2Integer(observerId1), Predef$.MODULE$.int2Integer(observerId2)}))).asJava()).setControllerEpoch(controllerEpoch).setObservers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(observerId1), Predef$.MODULE$.int2Integer(observerId2)}))).asJava()).setTopicName(this.topicPartition().topic()).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(syncReplicaId1), Predef$.MODULE$.int2Integer(syncReplicaId2)}))).asJava()).setZkVersion(zkVersion).setPartitionIndex(0);
        Assert.assertTrue((boolean)this.partition().makeLeader(1, leaderAndIsrUpdate, 2334, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId1, observerId2})), (Object)this.partition().assignmentState().observers());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2, observerId1, observerId2})), (Object)this.partition().assignmentState().replicas());
        Assert.assertFalse((boolean)this.partition().isUnderReplicated());
        this.partition().updateFollowerFetchState(observerId2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 0L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId1, observerId2})), (Object)this.partition().assignmentState().observers());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2, observerId1, observerId2})), (Object)this.partition().assignmentState().replicas());
        Assert.assertFalse((boolean)this.partition().isUnderReplicated());
    }

    @Test
    public void testShouldAddSyncReplicaToIsrWhenLeaderIsNotAnObserver() {
        int zkVersion = 23934;
        int controllerEpoch = 137;
        int leaderEpoch = 245;
        int syncReplicaId1 = this.brokerId();
        int syncReplicaId2 = this.brokerId() + 1;
        int observerId1 = this.brokerId() + 2;
        int observerId2 = this.brokerId() + 3;
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrUpdate = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeader(syncReplicaId1).setLeaderEpoch(leaderEpoch).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(syncReplicaId1), Predef$.MODULE$.int2Integer(syncReplicaId2), Predef$.MODULE$.int2Integer(observerId1), Predef$.MODULE$.int2Integer(observerId2)}))).asJava()).setControllerEpoch(controllerEpoch).setObservers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(observerId1), Predef$.MODULE$.int2Integer(observerId2)}))).asJava()).setTopicName(this.topicPartition().topic()).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(syncReplicaId1)}))).asJava()).setZkVersion(zkVersion).setPartitionIndex(0);
        Assert.assertTrue((boolean)this.partition().makeLeader(1, leaderAndIsrUpdate, 2334, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId1, observerId2})), (Object)this.partition().assignmentState().observers());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2, observerId1, observerId2})), (Object)this.partition().assignmentState().replicas());
        Assert.assertTrue((boolean)this.partition().isUnderReplicated());
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2})), zkVersion))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(zkVersion + 1))));
        this.partition().updateFollowerFetchState(syncReplicaId2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 0L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{observerId1, observerId2})), (Object)this.partition().assignmentState().observers());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{syncReplicaId1, syncReplicaId2, observerId1, observerId2})), (Object)this.partition().assignmentState().replicas());
        Assert.assertFalse((boolean)this.partition().isUnderReplicated());
    }

    private void seedLogData(AbstractLog log2, int numRecords, int leaderEpoch) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, log2, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$1;
            private final int leaderEpoch$2;

            public final LogAppendInfo apply(int i) {
                MemoryRecords records2 = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(this.leaderEpoch$2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes())});
                return this.log$1.appendAsLeader(records2, this.leaderEpoch$2, this.log$1.appendAsLeader$default$3(), this.log$1.appendAsLeader$default$4());
            }
            {
                this.log$1 = log$1;
                this.leaderEpoch$2 = leaderEpoch$2;
            }
        });
    }

    private final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$1) {
        try {
            partition$1.fetchOffsetSnapshot(currentLeaderEpoch, true);
            Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
        }
        catch (ApiException apiException) {
            Assert.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)apiException));
        }
    }

    private final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$2) {
        try {
            partition$2.fetchOffsetSnapshot(currentLeaderEpoch, fetchOnlyLeader);
            Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
        }
        catch (ApiException apiException) {
            Assert.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)apiException));
        }
    }

    private final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$3) {
        EpochEndOffset endOffset = partition$3.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$4) {
        EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$5) {
        try {
            partition$5.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyFromLeader, Partition partition$6) {
        try {
            partition$6.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyFromLeader, false, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$7) {
        try {
            partition$7.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final void updateFollowerFetchState$1(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset(), this.partition().localLogOrException().highWatermark());
    }

    private final Either fetchOffsetsForTimestamp$1(long timestamp, Option isolation) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)this.partition().fetchOffsetForTimestamp(timestamp, isolation, Optional.of(Predef$.MODULE$.int2Integer(this.partition().getLeaderEpoch())), true));
        }
        catch (ApiException apiException) {
            left = package$.MODULE$.Left().apply((Object)apiException);
        }
        return left;
    }

    private final FileRecords.TimestampAndOffset fetchLatestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final FileRecords.TimestampAndOffset fetchEarliestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final void updateFollowerFetchState$2(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset(), this.partition().localLogOrException().highWatermark());
    }

    public final MemoryRecords kafka$cluster$PartitionTest$$createRecords$1(long baseOffset) {
        List records2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}));
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)0);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$1.append(x$1);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public final Option kafka$cluster$PartitionTest$$getMetric$1(String metric) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, metric){
            public static final long serialVersionUID = 0L;
            private final String metric$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(MetricName metricName) {
                String string = metricName.getName();
                String string2 = this.metric$1;
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = metricName.getType();
                String string4 = "Partition";
                if (string3 == null) {
                    if (string4 == null) return true;
                    return false;
                } else {
                    if (!string3.equals(string4)) return false;
                    return true;
                }
            }
            {
                this.metric$1 = metric$1;
            }
        }).headOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Metric apply(Tuple2<MetricName, Metric> x$6) {
                return (Metric)x$6._2();
            }
        });
    }

    public PartitionTest() {
        this.brokerId = 101;
    }
}

