/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.cluster.ReplicaTest$;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u000f\tY!+\u001a9mS\u000e\fG+Z:u\u0015\t\u0019A!A\u0004dYV\u001cH/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u00051A/\u001c9ESJ,\u0012A\u0006\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\t!![8\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u0005\r&dW\r\u0003\u0004 \u0001\u0001\u0006IAF\u0001\bi6\u0004H)\u001b:!\u0011\u001d\t\u0003A1A\u0005\u0002U\ta\u0001\\8h\t&\u0014\bBB\u0012\u0001A\u0003%a#A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000f\u0015\u0002!\u0019!C\u0001M\u0005!A/[7f+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0005\u0003\u0015)H/\u001b7t\u0013\ta\u0013F\u0001\u0005N_\u000e\\G+[7f\u0011\u0019q\u0003\u0001)A\u0005O\u0005)A/[7fA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t+\u0005\u0011\u0004CA\u001a7\u001b\u0005!$BA\u001b\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011q\u0007\u000e\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biNDa!\u000f\u0001!\u0002\u0013\u0011\u0014!\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;tA!I1\b\u0001a\u0001\u0002\u0004%\t\u0001P\u0001\u0004Y><W#A\u001f\u0011\u0005y\u0002U\"A \u000b\u0005m\"\u0011BA!@\u0005-\t%m\u001d;sC\u000e$Hj\\4\t\u0013\r\u0003\u0001\u0019!a\u0001\n\u0003!\u0015a\u00027pO~#S-\u001d\u000b\u0003\u000b\"\u0003\"!\u0003$\n\u0005\u001dS!\u0001B+oSRDq!\u0013\"\u0002\u0002\u0003\u0007Q(A\u0002yIEBaa\u0013\u0001!B\u0013i\u0014\u0001\u00027pO\u0002BQ!\u0014\u0001\u0005\u00029\u000bQa]3ukB$\u0012!\u0012\u0015\u0003\u0019B\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u000b),h.\u001b;\u000b\u0003U\u000b1a\u001c:h\u0013\t9&K\u0001\u0004CK\u001a|'/\u001a\u0005\u00063\u0002!\tAT\u0001\ti\u0016\f'\u000fR8x]\"\u0012\u0001l\u0017\t\u0003#rK!!\u0018*\u0003\u000b\u00053G/\u001a:\t\u000b}\u0003A\u0011\u0001(\u0002eQ,7\u000f^*fO6,g\u000e\u001e#fY\u0016$\u0018n\u001c8XSRD\u0007*[4i/\u0006$XM]7be.Le.\u001b;jC2L'0\u0019;j_:D#AX1\u0011\u0005E\u0013\u0017BA2S\u0005\u0011!Vm\u001d;\t\u000b\u0015\u0004A\u0011\u0001(\u0002]Q,7\u000f^\"b]:|G\u000fR3mKR,7+Z4nK:$8/\u0011;Pe\u0006\u0013wN^3IS\u001eDw+\u0019;fe6\f'o\u001b\u0015\u0003I\u0006DQ\u0001\u001b\u0001\u0005\u00029\u000b!\u0007^3ti\u000e\u000bgN\\8u\u0013:\u001c'/Z7f]RdunZ*uCJ$xJ\u001a4tKR\u0004\u0016m\u001d;IS\u001eDw+\u0019;fe6\f'o\u001b\u0015\u0005O\u0006T7.\u0001\u0005fqB,7\r^3eG\u0005a\u0007CA7v\u001b\u0005q'BA8q\u0003\u0019)'O]8sg*\u0011\u0011O]\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0019(B\u0001;U\u0003\u0019\t\u0007/Y2iK&\u0011aO\u001c\u0002\u001a\u001f\u001a47/\u001a;PkR|eMU1oO\u0016,\u0005pY3qi&|g\u000e")
public class ReplicaTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private AbstractLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        this.log_$eq((AbstractLog)Log$.MODULE$.apply(this.logDir(), config, 0L, 0L, (Scheduler)this.time().scheduler(), this.brokerTopicStats(), (Time)this.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10), Log$.MODULE$.apply$default$11()));
    }

    @After
    public void tearDown() {
        this.log().close();
        this.brokerTopicStats().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testSegmentDeletionWithHighWatermarkInitialization() {
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, expiredTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;
            private final long expiredTimestamp$1;

            public final LogAppendInfo apply(int i) {
                byte[] x$1 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes();
                long x$2 = this.expiredTimestamp$1;
                byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
                CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
                byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
                MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
                AbstractLog qual$1 = this.$outer.log();
                MemoryRecords x$6 = records2;
                int x$7 = 0;
                AppendOrigin x$8 = qual$1.appendAsLeader$default$3();
                ApiVersion x$9 = qual$1.appendAsLeader$default$4();
                return qual$1.appendAsLeader(x$6, x$7, x$8, x$9);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expiredTimestamp$1 = expiredTimestamp$1;
            }
        });
        long initialHighWatermark = this.log().updateHighWatermark(25L);
        Assert.assertEquals((long)25L, (long)initialHighWatermark);
        int initialNumSegments = this.log().numberOfSegments();
        this.log().deleteOldSegments();
        Assert.assertTrue((this.log().numberOfSegments() < initialNumSegments ? 1 : 0) != 0);
        Assert.assertTrue((this.log().logStartOffset() <= initialHighWatermark ? 1 : 0) != 0);
    }

    @Test
    public void testCannotDeleteSegmentsAtOrAboveHighWatermark() {
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, expiredTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;
            private final long expiredTimestamp$2;

            public final LogAppendInfo apply(int i) {
                byte[] x$10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes();
                long x$11 = this.expiredTimestamp$2;
                byte[] x$12 = TestUtils$.MODULE$.singletonRecords$default$2();
                CompressionType x$13 = TestUtils$.MODULE$.singletonRecords$default$3();
                byte x$14 = TestUtils$.MODULE$.singletonRecords$default$5();
                MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(x$10, x$12, x$13, x$11, x$14);
                AbstractLog qual$2 = this.$outer.log();
                MemoryRecords x$15 = records2;
                int x$16 = 0;
                AppendOrigin x$17 = qual$2.appendAsLeader$default$3();
                ApiVersion x$18 = qual$2.appendAsLeader$default$4();
                return qual$2.appendAsLeader(x$15, x$16, x$17, x$18);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expiredTimestamp$2 = expiredTimestamp$2;
            }
        });
        Assert.assertTrue((this.log().numberOfSegments() > 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.log().highWatermark());
        Assert.assertEquals((long)0L, (long)this.log().logStartOffset());
        Assert.assertEquals((long)100L, (long)this.log().logEndOffset());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;

            public final void apply(int hw) {
                this.apply$mcVI$sp(hw);
            }

            public void apply$mcVI$sp(int hw) {
                this.$outer.log().updateHighWatermark((long)hw);
                Assert.assertEquals((long)hw, (long)this.$outer.log().highWatermark());
                this.$outer.log().deleteOldSegments();
                Assert.assertTrue((this.$outer.log().logStartOffset() <= (long)hw ? 1 : 0) != 0);
                this.$outer.log().localLogSegments().headOption().foreach((Function1)new Serializable(this, hw){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1 $outer;
                    private final int hw$1;

                    public final void apply(LogSegment segment) {
                        Assert.assertTrue((segment.baseOffset() <= (long)this.hw$1 ? 1 : 0) != 0);
                        Assert.assertTrue((segment.baseOffset() >= this.$outer.kafka$cluster$ReplicaTest$$anonfun$$$outer().log().logStartOffset() ? 1 : 0) != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.hw$1 = hw$1;
                    }
                });
                ((IterableLike)this.$outer.log().localLogSegments().tail()).foreach((Function1)new Serializable(this, hw){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1 $outer;
                    private final int hw$1;

                    public final void apply(LogSegment segment) {
                        Assert.assertTrue((segment.baseOffset() > (long)this.hw$1 ? 1 : 0) != 0);
                        Assert.assertTrue((segment.baseOffset() >= this.$outer.kafka$cluster$ReplicaTest$$anonfun$$$outer().log().logStartOffset() ? 1 : 0) != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.hw$1 = hw$1;
                    }
                });
            }

            public /* synthetic */ ReplicaTest kafka$cluster$ReplicaTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)100L, (long)this.log().logStartOffset());
        Assert.assertEquals((long)1L, (long)this.log().numberOfSegments());
        Assert.assertEquals((long)0L, (long)this.log().activeSegment().size());
    }

    @Test(expected=OffsetOutOfRangeException.class)
    public void testCannotIncrementLogStartOffsetPastHighWatermark() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;

            public final LogAppendInfo apply(int i) {
                MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                AbstractLog qual$3 = this.$outer.log();
                MemoryRecords x$19 = records2;
                int x$20 = 0;
                AppendOrigin x$21 = qual$3.appendAsLeader$default$3();
                ApiVersion x$22 = qual$3.appendAsLeader$default$4();
                return qual$3.appendAsLeader(x$19, x$20, x$21, x$22);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.log().updateHighWatermark(25L);
        this.log().maybeIncrementLogStartOffset(26L);
    }
}

