/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.Collections;
import java.util.Map;
import kafka.common.TopicPlacement;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;

public final class TopicPlacementTest {
    private TopicPlacement getTopicPlacement(String placementJson) {
        return (TopicPlacement)TopicPlacement.parse((String)placementJson).orElseThrow(() -> {
            throw new RuntimeException("Invalid topic placement json: " + placementJson);
        });
    }

    @Test
    public void testAttributeRackMatches() {
        String json = "{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"abc\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"def\"}}]}";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assert.assertTrue((boolean)topicPlacement.matchesReplicas(Collections.singletonMap("rack", "abc")));
        Assert.assertTrue((boolean)topicPlacement.matchesObservers(Collections.singletonMap("rack", "def")));
    }

    @Test
    public void testAttributeRackMatchingEmptyReplicaConstraints() {
        String json = "{ \"version\": 1, \"replicas\": [{\"count\": 1}] }";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assert.assertTrue((boolean)topicPlacement.matchesReplicas(Collections.singletonMap("rack", "abc")));
        Assert.assertTrue((boolean)topicPlacement.matchesReplicas(Collections.emptyMap()));
    }

    @Test
    public void testAttributeRackMatchingEmptyReplicaAndObserverConstraints() {
        String json = "{ \"version\": 1, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}] }";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assert.assertTrue((boolean)topicPlacement.matchesReplicas(Collections.singletonMap("rack", "abc")));
        Assert.assertTrue((boolean)topicPlacement.matchesReplicas(Collections.emptyMap()));
        Assert.assertTrue((boolean)topicPlacement.matchesObservers(Collections.singletonMap("rack", "def")));
        Assert.assertTrue((boolean)topicPlacement.matchesObservers(Collections.emptyMap()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailsWithEmptyConstraints() {
        String json = "{\"version\": 1}";
        this.getTopicPlacement(json);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailsWithEmptyReplicas() {
        String input = "{\"version\":1,\"replicas\":null}";
        this.getTopicPlacement(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailsWithOnlyObservers() {
        String input = "{\"version\":1,\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"def\"}}]}";
        this.getTopicPlacement(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailsWithEmptyReplicasAndObservers() {
        String input = "{\"version\":1,\"replicas\":null,\"observers\":null}";
        this.getTopicPlacement(input);
    }

    @Test
    public void testAttributeRackDoesNotMatch() {
        String json = "{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"abc\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"def\"}}]}";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assert.assertFalse((boolean)topicPlacement.matchesReplicas(Collections.singletonMap("rack", "def")));
        Assert.assertFalse((boolean)topicPlacement.matchesReplicas(Collections.singletonMap("rack", "not_match")));
        Assert.assertFalse((boolean)topicPlacement.matchesReplicas(Collections.emptyMap()));
        Assert.assertFalse((boolean)topicPlacement.matchesObservers(Collections.singletonMap("rack", "abc")));
        Assert.assertFalse((boolean)topicPlacement.matchesObservers(Collections.singletonMap("rack", "not_match")));
        Assert.assertFalse((boolean)topicPlacement.matchesObservers(Collections.emptyMap()));
    }

    @Test
    public void testBasicParsingFailures() {
        String missingVersion = "{\"replicas\":[{\"constraints\":{\"rack\":\"abc\"}}],\"observers\":[{\"constraints\":{\"rack\":\"def\"}}]}";
        Assert.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(missingVersion));
        String unknownFields = "{\"version\": 1, \"unknown\": \"unknown\"}";
        Assert.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(unknownFields));
        String unknownVersion = "{\"version\": 2}";
        Assert.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(unknownVersion));
    }

    @Test
    public void testValidation() {
        String missingReplicaConstraint = "{\"version\":1,\"observers\":[{\"constraints\":{\"rack\":\"def\"}}]}";
        Assert.assertThrows(ConfigException.class, () -> TopicPlacement.VALIDATOR.ensureValid("property.name", (Object)missingReplicaConstraint));
    }

    @Test
    public void testPlacementConstraintPredicateSuccess() {
        Map<String, String> replicaBroker = Collections.singletonMap("rack", "east-1");
        Map<String, String> observerBroker = Collections.singletonMap("rack", "west-1");
        String placementJson = "{\"version\": 1, \"replicas\": [{\"count\": 2, \"constraints\": {\"rack\": \"east-1\"}},{\"count\": 1, \"constraints\": {\"rack\": \"east-2\"}}],\"observers\": [{\"count\": 1, \"constraints\": {\"rack\": \"west-1\"}}]}";
        TopicPlacement topicPlacement = this.getTopicPlacement(placementJson);
        Assert.assertTrue((boolean)topicPlacement.matchesReplicas(replicaBroker));
        Assert.assertTrue((boolean)topicPlacement.matchesObservers(observerBroker));
    }

    @Test
    public void testPlacementConstraintPredicateFailure() {
        Map<String, String> broker = Collections.singletonMap("rack", "south-1");
        String placementJson = "{\"version\": 1, \"replicas\": [{\"count\": 2, \"constraints\": {\"rack\": \"east-1\"}},{\"count\": 1, \"constraints\": {\"rack\": \"east-2\"}}],\"observers\": [{\"count\": 1, \"constraints\": {\"rack\": \"west-1\"}}]}";
        TopicPlacement topicPlacement = this.getTopicPlacement(placementJson);
        Assert.assertFalse((boolean)topicPlacement.matchesReplicas(broker));
        Assert.assertFalse((boolean)topicPlacement.matchesObservers(broker));
    }

    @Test
    public void testPlacementConstraintPredicateNoBrokerRack() {
        String placementJson = "{\"version\": 1, \"replicas\": [{\"count\": 2, \"constraints\": {\"rack\": \"east-1\"}},{\"count\": 1, \"constraints\": {\"rack\": \"east-2\"}}],\"observers\": [{\"count\": 1, \"constraints\": {\"rack\": \"west-1\"}}]}";
        TopicPlacement topicPlacement = this.getTopicPlacement(placementJson);
        Assert.assertFalse((boolean)topicPlacement.matchesReplicas(Collections.emptyMap()));
        Assert.assertFalse((boolean)topicPlacement.matchesObservers(Collections.emptyMap()));
    }

    @Test
    public void testJSONSerialization() {
        String placementJson = "{\"version\": 1,%n  \"replicas\": [%n    {%n      \"count\": 2,%n      \"constraints\": {\"rack\": \"rack-1\"}%n    }%n  ],%n  \"observers\":[%n    {%n      \"count\": 1,%n      \"constraints\": {\"rack\": \"rack-2\"}%n    }%n  ]%n}";
        String platformIndependentJson = String.format(placementJson, new Object[0]);
        TopicPlacement tp = this.getTopicPlacement(platformIndependentJson);
        String serializedJson = tp.toJson();
        Assert.assertTrue((serializedJson.length() < platformIndependentJson.length() ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyStringParsesToEmptyTopicPlacement() {
        Assert.assertEquals((Object)false, (Object)TopicPlacement.parse((String)"").isPresent());
    }

    @Test
    public void testSuccessfulHandlingOfNullProperties() {
        String input = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":null}],\"observers\":[{\"count\":1,\"constraints\":null}]}";
        TopicPlacement placement = this.getTopicPlacement(input);
        Assert.assertTrue((boolean)placement.replicas().stream().allMatch(constraint -> constraint.constraints().isEmpty()));
        Assert.assertTrue((boolean)placement.observers().stream().allMatch(constraint -> constraint.constraints().isEmpty()));
        input = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":null}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":null}}]}";
        placement = this.getTopicPlacement(input);
        Assert.assertTrue((boolean)placement.replicas().stream().allMatch(constraint -> constraint.constraints().isEmpty()));
        Assert.assertTrue((boolean)placement.observers().stream().allMatch(constraint -> constraint.constraints().isEmpty()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingReplicaCount() {
        String placementJson = "{\"version\": 1, \"replicas\": [{\"constraints\": {\"rack\": \"east-1\"}},{\"constraints\": {\"rack\": \"east-2\"}}],\"observers\": [{\"constraints\": {\"rack\": \"west-1\"}}]}";
        this.getTopicPlacement(placementJson);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingObserverCount() {
        String placementJson = "{\"version\": 1, \"replicas\": [{\"count\": 2, \"constraints\": {\"rack\": \"east-1\"}},{\"count\": 1, \"constraints\": {\"rack\": \"east-2\"}}],\"observers\": [{\"constraints\": {\"rack\": \"west-1\"}}]}";
        this.getTopicPlacement(placementJson);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailsWithStringNull() {
        this.getTopicPlacement("null");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailsWithEmptyJsonObject() {
        this.getTopicPlacement("{}");
    }
}

