/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnIdAndMarkerEntry;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eh\u0001B\u0001\u0003\u0001%\u0011Q\u0006\u0016:b]N\f7\r^5p]6\u000b'o[3s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0006ue\u0006t7/Y2uS>t'BA\u0003\u0007\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"\u0001\u0002\t\u000fY\u0001!\u0019!C\u0005/\u0005A!M]8lKJLE-F\u0001\u0019!\tY\u0011$\u0003\u0002\u001b\u0019\t\u0019\u0011J\u001c;\t\rq\u0001\u0001\u0015!\u0003\u0019\u0003%\u0011'o\\6fe&#\u0007\u0005C\u0004\u001f\u0001\t\u0007I\u0011B\f\u0002#QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004!\u0001\u0001\u0006I\u0001G\u0001\u0013ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0004#\u0001\t\u0007I\u0011B\u0012\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0012\u0001\n\t\u0003K)j\u0011A\n\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016'\u0005\u0019\u0019FO]5oO\"1Q\u0006\u0001Q\u0001\n\u0011\n\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u0011\t\u000f=\u0002!\u0019!C\u0005a\u0005Q\u0001O]8ek\u000e,'/\u00133\u0016\u0003E\u0002\"a\u0003\u001a\n\u0005Mb!\u0001\u0002'p]\u001eDa!\u000e\u0001!\u0002\u0013\t\u0014a\u00039s_\u0012,8-\u001a:JI\u0002Bqa\u000e\u0001C\u0002\u0013%\u0001(A\u0007qe>$WoY3s\u000bB|7\r[\u000b\u0002sA\u00111BO\u0005\u0003w1\u0011Qa\u00155peRDa!\u0010\u0001!\u0002\u0013I\u0014A\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\t\u0005\b\u007f\u0001\u0011\r\u0011\"\u00039\u0003Ea\u0017m\u001d;Qe>$WoY3s\u000bB|7\r\u001b\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001d\u0002%1\f7\u000f\u001e)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\t\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003\u0018\u00031!\bP\u001c+j[\u0016|W\u000f^'t\u0011\u0019)\u0005\u0001)A\u00051\u0005iA\u000f\u001f8US6,w.\u001e;Ng\u0002Bqa\u0012\u0001C\u0002\u0013%q#\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\"1\u0011\n\u0001Q\u0001\na\t\u0011cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195!\u0011\u001dY\u0005A1A\u0005\n1\u000b\u0011\u0002\u001e=o%\u0016\u001cX\u000f\u001c;\u0016\u00035\u0003\"A\u0014-\u000e\u0003=S!\u0001U)\u0002\u0011I,\u0017/^3tiNT!AU*\u0002\r\r|W.\\8o\u0015\t9AK\u0003\u0002V-\u00061\u0011\r]1dQ\u0016T\u0011aV\u0001\u0004_J<\u0017BA-P\u0005E!&/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u00077\u0002\u0001\u000b\u0011B'\u0002\u0015QDhNU3tk2$\b\u0005C\u0004^\u0001\t\u0007I\u0011\u00020\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tq\f\u0005\u0002aC6\t\u0011+\u0003\u0002c#\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007B\u00023\u0001A\u0003%q,A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011\u001d1\u0007A1A\u0005\n\u001d\fq\u0002\u001e=o\u0013\u0012\fe\u000eZ'be.,'o]\u000b\u0002QB\u0019\u0011\u000e\u001c8\u000e\u0003)T!a\u001b\u0015\u0002\tU$\u0018\u000e\\\u0005\u0003[*\u0014A\u0001T5tiB\u0011Ac\\\u0005\u0003a\n\u00111\u0003\u0016=o\u0013\u0012\fe\u000eZ'be.,'/\u00128uefDaA\u001d\u0001!\u0002\u0013A\u0017\u0001\u0005;y]&#\u0017I\u001c3NCJ\\WM]:!\u0011\u001d!\bA1A\u0005\nU\f1\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCV\ta\u000f\u0005\u0002\u0015o&\u0011\u0001P\u0001\u0002\u0014)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0005\u0007u\u0002\u0001\u000b\u0011\u0002<\u0002\u0019QDh.T3uC\u0012\fG/\u0019\u0011\t\u000fq\u0004!\u0019!C\u0005{\u0006!R.\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ,\u0012A \t\u0003)}L1!!\u0001\u0003\u0005}!&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003\u007f\u0003Ui\u0017M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0002B\u0011\"!\u0003\u0001\u0005\u0004%I!a\u0003\u0002\u001fQDhn\u0015;bi\u0016l\u0015M\\1hKJ,\"!!\u0004\u0011\u0007Q\ty!C\u0002\u0002\u0012\t\u0011q\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001b\t\u0001\u0003\u001e=o'R\fG/Z'b]\u0006<WM\u001d\u0011\t\u0013\u0005e\u0001A1A\u0005\n\u0005m\u0011a\u00025b]\u0012dWM]\u000b\u0003\u0003;\u00012\u0001FA\u0010\u0013\r\t\tC\u0001\u0002*)J\fgn]1di&|g.T1sW\u0016\u0014(+Z9vKN$8i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003;\t\u0001\u0002[1oI2,'\u000f\t\u0005\b\u0003S\u0001A\u0011BA\u0016\u0003%iwnY6DC\u000eDW\r\u0006\u0002\u0002.A\u00191\"a\f\n\u0007\u0005EBB\u0001\u0003V]&$\bbBA\u001b\u0001\u0011\u0005\u00111F\u00010g\"|W\u000f\u001c3SK\u0016s\u0017/^3vKB\u000b'\u000f^5uS>t7o\u00165f]\n\u0013xn[3s\t&\u001c8m\u001c8oK\u000e$X\r\u001a\u0015\u0005\u0003g\tI\u0004\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\tyDV\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0007\niD\u0001\u0003UKN$\bbBA$\u0001\u0011\u0005\u00111F\u0001>g\"|W\u000f\u001c3UQJ|w/\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|g.\u00134FeJ|'oQ8eK:{G/\u0011<bS2\f'\r\\3G_J\u0004\u0016\u000e\u001a\u0015\u0005\u0003\u000b\nI\u0004C\u0004\u0002N\u0001!\t!a\u000b\u0002UMDw.\u001e7e\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fI>\u0003XM]1uS>tw\u000b[3o\u001d>,%O]8sg\"\"\u00111JA\u001d\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003W\t\u0001g\u001d5pk2$7i\\7qY\u0016$X\rR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8XQ\u0016tgj\u001c;D_>\u0014H-\u001b8bi>\u0014\b\u0006BA)\u0003sAq!!\u0017\u0001\t\u0003\tY#\u0001\u001btQ>,H\u000eZ\"p[BdW\r^3EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]^CWM\\\"p_J$\u0017N\\1u_Jdu.\u00193j]\u001eDC!a\u0016\u0002:!9\u0011q\f\u0001\u0005\u0002\u0005-\u0012!O:i_VdGmQ8na2,G/\u001a#fY\u0006LX\rZ(qKJ\fG/[8o/\",gnQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195DQ\u0006tw-\u001a3)\t\u0005u\u0013\u0011\b\u0005\b\u0003K\u0002A\u0011AA\u0016\u0003Y\u001a\bn\\;mI\u000e{W\u000e\u001d7fi\u0016$U\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u00165f]&sg/\u00197jIB\u0013x\u000eZ;dKJ,\u0005o\\2iQ\u0011\t\u0019'!\u000f\t\u000f\u0005-\u0004\u0001\"\u0001\u0002,\u000594\u000f[8vY\u0012\u001cu.\u001c9mKR,G)\u001a7bs\u0016$w\n]3sCRLwN\\,iK\u000e{wN\u001d3j]\u0006$xN]#q_\u000eDg)\u001a8dK\u0012DC!!\u001b\u0002:!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005-\u0012\u0001M:i_VdG\r\u00165s_^LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:<\u0006.\u001a8V].twn\u001e8FeJ|'\u000f\u000b\u0003\u0002p\u0005e\u0002bBA<\u0001\u0011\u0005\u00111F\u00018g\"|W\u000f\u001c3UQJ|w/\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|gn\u00165f]\u000e{'O];qi6+7o]1hK\u0016\u0013(o\u001c:)\t\u0005U\u0014\u0011\b\u0005\b\u0003{\u0002A\u0011AA\u0016\u0003a\u001a\bn\\;mIRC'o\\<JY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c8XQ\u0016tW*Z:tC\u001e,Gk\\8MCJ<W-\u0012:s_JDC!a\u001f\u0002:!9\u00111\u0011\u0001\u0005\u0002\u0005-\u0012aO:i_VdG\r\u00165s_^LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:<\u0006.\u001a8SK\u000e|'\u000f\u001a'jgR$vn\u001c'be\u001e,WI\u001d:pe\"\"\u0011\u0011QA\u001d\u0011\u001d\tI\t\u0001C\u0001\u0003W\tAh\u001d5pk2$G\u000b\u001b:po&cG.Z4bYN#\u0018\r^3Fq\u000e,\u0007\u000f^5p]^CWM\\%om\u0006d\u0017\u000e\u001a*fcVL'/\u001a3BG.\u001cXI\u001d:pe\"\"\u0011qQA\u001d\u0011\u001d\ty\t\u0001C\u0001\u0003W\tAg\u001d5pk2$'+\u001a;ssB\u000b'\u000f^5uS>tw\u000b[3o+:\\gn\\<o)>\u0004\u0018nY(s!\u0006\u0014H/\u001b;j_:,%O]8sQ\u0011\ti)!\u000f\t\u000f\u0005U\u0005\u0001\"\u0001\u0002,\u0005\u00114\u000f[8vY\u0012\u0014V\r\u001e:z!\u0006\u0014H/\u001b;j_:<\u0006.\u001a8O_RdU-\u00193fe\u001a{'\u000fU1si&$\u0018n\u001c8FeJ|'\u000f\u000b\u0003\u0002\u0014\u0006e\u0002bBAN\u0001\u0011\u0005\u00111F\u0001/g\"|W\u000f\u001c3SKR\u0014\u0018\u0010U1si&$\u0018n\u001c8XQ\u0016tgj\u001c;F]>,x\r\u001b*fa2L7-Y:FeJ|'\u000f\u000b\u0003\u0002\u001a\u0006e\u0002bBAQ\u0001\u0011\u0005\u00111F\u0001:g\"|W\u000f\u001c3SKR\u0014\u0018\u0010U1si&$\u0018n\u001c8XQ\u0016tgj\u001c;F]>,x\r\u001b*fa2L7-Y:BMR,'/\u00119qK:$WI\u001d:pe\"\"\u0011qTA\u001d\u0011\u001d\t9\u000b\u0001C\u0001\u0003W\t\u0011f\u001d5pk2$'+\u001a;ssB\u000b'\u000f^5uS>tw\u000b[3o\u0017\u000647.Y*u_J\fw-Z#se>\u0014\b\u0006BAS\u0003sAq!!,\u0001\t\u0003\tY#A#tQ>,H\u000e\u001a*f[>4X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gN\u0012:p[^\u000b\u0017\u000e^5oON+Go\u00148V]N,\b\u000f]8si\u0016$gi\u001c:NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e\u0015\u0005\u0003W\u000bI\u0004C\u0004\u00024\u0002!I!!.\u0002;Y,'/\u001b4z%\u0016$(/[3t!\u0006\u0014H/\u001b;j_:|e.\u0012:s_J$B!!\f\u00028\"A\u0011\u0011XAY\u0001\u0004\tY,A\u0003feJ|'\u000f\u0005\u0003\u0002>\u0006\rWBAA`\u0015\r\t\t-U\u0001\taJ|Go\\2pY&!\u0011QYA`\u0005\u0019)%O]8sg\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0017a\n<fe&4\u0017\u0010\u00165s_^LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:|e.\u0012:s_J$B!!\f\u0002N\"A\u0011\u0011XAd\u0001\u0004\tY\fC\u0004\u0002R\u0002!I!a5\u0002KY,'/\u001b4z\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fI>\u0003XM]1uS>twJ\\#se>\u0014H\u0003BA\u0017\u0003+D\u0001\"!/\u0002P\u0002\u0007\u00111\u0018\u0005\b\u00033\u0004A\u0011BAn\u0003\r2XM]5gsJ+Wn\u001c<f\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:|e.\u0012:s_J$B!!\f\u0002^\"A\u0011\u0011XAl\u0001\u0004\tY\fC\u0004\u0002b\u0002!I!a9\u00021\r\u0014X-\u0019;f!J|G-^2fe&#WI\u001d:pe6\u000b\u0007\u000f\u0006\u0003\u0002f\u0006U\bcB5\u0002h\u0006-\u0018q^\u0005\u0004\u0003ST'a\u0002%bg\"l\u0015\r\u001d\t\u0004K\u00055\u0018BA\u001a'!\u0019I\u0017\u0011_0\u0002<&\u0019\u00111\u001f6\u0003\u00075\u000b\u0007\u000f\u0003\u0005\u0002x\u0006}\u0007\u0019AA^\u0003\u0019)'O]8sg\u0002")
public class TransactionMarkerRequestCompletionHandlerTest {
    private final int brokerId;
    private final int txnTopicPartition;
    private final String transactionalId;
    private final long producerId;
    private final short producerEpoch = (short)0;
    private final short lastProducerEpoch = (short)-1;
    private final int txnTimeoutMs;
    private final int coordinatorEpoch;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TopicPartition topicPartition = new TopicPartition("topic1", 0);
    private final List<TxnIdAndMarkerEntry> txnIdAndMarkers = Arrays.asList((Object[])new TxnIdAndMarkerEntry[]{new TxnIdAndMarkerEntry(this.transactionalId(), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.topicPartition()})))});
    private final TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})), 0L, 0L);
    private final TransactionMarkerChannelManager markerChannelManager = (TransactionMarkerChannelManager)EasyMock.createNiceMock(TransactionMarkerChannelManager.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)EasyMock.createNiceMock(TransactionStateManager.class);
    private final TransactionMarkerRequestCompletionHandler handler = new TransactionMarkerRequestCompletionHandler(this.brokerId(), this.txnStateManager(), this.markerChannelManager(), this.txnIdAndMarkers());

    private int brokerId() {
        return this.brokerId;
    }

    private int txnTopicPartition() {
        return this.txnTopicPartition;
    }

    private String transactionalId() {
        return this.transactionalId;
    }

    private long producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private List<TxnIdAndMarkerEntry> txnIdAndMarkers() {
        return this.txnIdAndMarkers;
    }

    private TransactionMetadata txnMetadata() {
        return this.txnMetadata;
    }

    private TransactionMarkerChannelManager markerChannelManager() {
        return this.markerChannelManager;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TransactionMarkerRequestCompletionHandler handler() {
        return this.handler;
    }

    private void mockCache() {
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition())).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata())))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
    }

    @Test
    public void shouldReEnqueuePartitionsWhenBrokerDisconnected() {
        this.mockCache();
        this.markerChannelManager().addTxnMarkersToBrokerQueue(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnResult(), this.coordinatorEpoch(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, true, null, null, null));
        EasyMock.verify((Object[])new Object[]{this.markerChannelManager()});
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfErrorCodeNotAvailableForPid() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(new HashMap());
        try {
            this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            Assert.fail((String)"should have thrown illegal argument exception");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNoErrors() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNotCoordinator() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorLoading() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorEpochChanged() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch() + 1, this.txnMetadata())))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenInvalidProducerEpoch() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.INVALID_PRODUCER_EPOCH);
    }

    @Test
    public void shouldCompleteDelayedOperationWheCoordinatorEpochFenced() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.TRANSACTION_COORDINATOR_FENCED);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenUnknownError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenCorruptMessageError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.CORRUPT_MESSAGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenMessageTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.MESSAGE_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenRecordListTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.RECORD_LIST_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenInvalidRequiredAcksError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.INVALID_REQUIRED_ACKS);
    }

    @Test
    public void shouldRetryPartitionWhenUnknownTopicOrPartitionError() {
        this.verifyRetriesPartitionOnError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void shouldRetryPartitionWhenNotLeaderForPartitionError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_LEADER_FOR_PARTITION);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasAfterAppendError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
    }

    @Test
    public void shouldRetryPartitionWhenKafkaStorageError() {
        this.verifyRetriesPartitionOnError(Errors.KAFKA_STORAGE_ERROR);
    }

    @Test
    public void shouldRemoveTopicPartitionFromWaitingSetOnUnsupportedForMessageFormat() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT);
    }

    private void verifyRetriesPartitionOnError(Errors error) {
        this.mockCache();
        this.markerChannelManager().addTxnMarkersToBrokerQueue(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnResult(), this.coordinatorEpoch(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assert.assertEquals((Object)this.txnMetadata().topicPartitions(), (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.verify((Object[])new Object[]{this.markerChannelManager()});
    }

    private void verifyThrowIllegalStateExceptionOnError(Errors error) {
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        try {
            this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            Assert.fail((String)"should have thrown illegal state exception");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private void verifyCompleteDelayedOperationOnError(Errors error) {
        BooleanRef completed = BooleanRef.create((boolean)false);
        this.markerChannelManager().completeSendMarkersForTxnId(this.transactionalId());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, completed){
            private final BooleanRef completed$1;

            public void answer() {
                this.completed$1.elem = true;
            }
            {
                this.completed$1 = completed$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assert.assertTrue((boolean)this.txnMetadata().topicPartitions().isEmpty());
        Assert.assertTrue((boolean)completed.elem);
    }

    private void verifyRemoveDelayedOperationOnError(Errors error) {
        BooleanRef removed = BooleanRef.create((boolean)false);
        this.markerChannelManager().removeMarkersForTxnId(this.transactionalId());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, removed){
            private final BooleanRef removed$1;

            public void answer() {
                this.removed$1.elem = true;
            }
            {
                this.removed$1 = removed$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assert.assertTrue((boolean)removed.elem);
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<Long, Map<TopicPartition, Errors>> createProducerIdErrorMap(Errors errors) {
        void var2_2;
        HashMap pidMap = new HashMap();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.topicPartition(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId()), errorsMap);
        return var2_2;
    }

    public TransactionMarkerRequestCompletionHandlerTest() {
        this.brokerId = 0;
        this.txnTopicPartition = 0;
        this.transactionalId = "txnId1";
        this.producerId = 0;
        this.txnTimeoutMs = 0;
        this.coordinatorEpoch = 0;
    }
}

