/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0001%\u0011q\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006$Vm\u001d;\u000b\u0005\r!\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:T!!\u0002\u0004\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003)\u0001i\u0011A\u0001\u0005\b-\u0001\u0011\r\u0011\"\u0001\u0018\u0003\u0011!\u0018.\\3\u0016\u0003a\u0001\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005uQ\"\u0001C'pG.$\u0016.\\3\t\r}\u0001\u0001\u0015!\u0003\u0019\u0003\u0015!\u0018.\\3!\u0011\u001d\t\u0003A1A\u0005\u0002\t\n!\u0002\u001d:pIV\u001cWM]%e+\u0005\u0019\u0003CA\u0006%\u0013\t)CB\u0001\u0003M_:<\u0007BB\u0014\u0001A\u0003%1%A\u0006qe>$WoY3s\u0013\u0012\u0004\u0003bB\u0015\u0001\u0005\u0004%\tAK\u0001\u0010iJ\fgn]1di&|g.\u00197JIV\t1\u0006\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A.\u00198h\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\rM#(/\u001b8h\u0011\u0019!\u0004\u0001)A\u0005W\u0005\u0001BO]1og\u0006\u001cG/[8oC2LE\r\t\u0005\u0006m\u0001!\taN\u0001\u0014i\u0016\u001cH/\u00138ji&\fG.\u001b>f\u000bB|7\r\u001b\u000b\u0002qA\u00111\"O\u0005\u0003u1\u0011A!\u00168ji\"\u0012Q\u0007\u0010\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000bQA[;oSRT\u0011!Q\u0001\u0004_J<\u0017BA\"?\u0005\u0011!Vm\u001d;\t\u000b\u0015\u0003A\u0011A\u001c\u0002'Q,7\u000f\u001e(pe6\fG.\u00129pG\"\u0014U/\u001c9)\u0005\u0011c\u0004\"\u0002%\u0001\t\u00039\u0014\u0001\u000b;fgR\u0014U/\u001c9Fa>\u001c\u0007NT8u\u00032dwn^3e\u0013\u001a,\u0005o\\2ig\u0016C\b.Y;ti\u0016$\u0007\u0006B$=\u0015.\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002\u0019B\u0011A&T\u0005\u0003\u001d6\u0012Q#\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|g\u000eC\u0003Q\u0001\u0011\u0005q'\u0001\u0016uKN$Hk\u001c7fe\u0006$X-\u00169eCR,G+[7f'\"Lg\r\u001e#ve&tw-\u00129pG\"\u0014U/\u001c9)\u0005=c\u0004\"B*\u0001\t\u00039\u0014a\r;fgR$v\u000e\\3sCR,W\u000b\u001d3bi\u0016$\u0016.\\3SKN,G\u000fR;sS:<\u0007K]8ek\u000e,'/\u00133S_R\fG/[8oQ\t\u0011F\bC\u0003W\u0001\u0011\u0005q'\u0001\u0015uKN$Hk\u001c7fe\u0006$X\rV5nKNC\u0017N\u001a;EkJLgnZ!eIB\u000b'\u000f^5uS>t7\u000f\u000b\u0002Vy!)\u0011\f\u0001C\u0001o\u0005AC/Z:u)>dWM]1uKRKW.Z*iS\u001a$H)\u001e:j]\u001e\u0004&/\u001a9be\u0016\u001cu.\\7ji\"\u0012\u0001\f\u0010\u0005\u00069\u0002!\taN\u0001(i\u0016\u001cH\u000fV8mKJ\fG/\u001a+j[\u0016\u001c\u0006.\u001b4u\tV\u0014\u0018N\\4Qe\u0016\u0004\u0018M]3BE>\u0014H\u000f\u000b\u0002\\y!)q\f\u0001C\u0001o\u0005IC/Z:u)>dWM]1uKRKW.Z*iS\u001a$H)\u001e:j]\u001e\u001cu.\u001c9mKR,7i\\7nSRD#A\u0018\u001f\t\u000b\t\u0004A\u0011A\u001c\u0002QQ,7\u000f\u001e+pY\u0016\u0014\u0018\r^3US6,7\u000b[5gi\u0012+(/\u001b8h\u0007>l\u0007\u000f\\3uK\u0006\u0013wN\u001d;)\u0005\u0005d\u0004\"B3\u0001\t\u00039\u0014!\n;fgR4UM\\2f!J|G-^2fe\u00063G/\u001a:Fa>\u001c\u0007n]#yQ\u0006,8\u000f^3eQ\t!G\bC\u0003i\u0001\u0011\u0005q'\u0001\u0017uKN$h)\u001a8dKB\u0013x\u000eZ;dKJtu\u000e^!mY><X\rZ%g\u0013R<v.\u001e7e\u001fZ,'O\u001a7po\"\"q\r\u0010&L\u0011\u0015Y\u0007\u0001\"\u00018\u0003Q!Xm\u001d;S_R\fG/\u001a)s_\u0012,8-\u001a:JI\"\u0012!\u000e\u0010\u0005\u0006]\u0002!\taN\u0001#i\u0016\u001cHOU8uCR,\u0007K]8ek\u000e,'/\u00133J]>swm\\5oON#\u0018\r^3)\t5d$j\u0013\u0005\u0006c\u0002!\taN\u0001(i\u0016\u001cHOU8uCR,\u0007K]8ek\u000e,'/\u00133J]B\u0013X\r]1sK\u0006\u0013wN\u001d;Ti\u0006$X\r\u000b\u0003qy)[\u0005\"\u0002;\u0001\t\u00039\u0014\u0001\u000b;fgR\u0014v\u000e^1uKB\u0013x\u000eZ;dKJLE-\u00138Qe\u0016\u0004\u0018M]3D_6l\u0017\u000e^*uCR,\u0007\u0006B:=\u0015.CQa\u001e\u0001\u0005\u0002]\na\u0006^3ti\u0006#H/Z7qi\u0016$W\t]8dQ\n+X\u000e],ji\"tUm\u001e7z\u0007J,\u0017\r^3e\u001b\u0016$\u0018\rZ1uC\"\u0012a\u000f\u0010\u0005\u0006u\u0002!\taN\u0001&i\u0016\u001cH/\u00129pG\"\u0014U/\u001c9XSRD7)\u001e:sK:$X\t]8dQB\u0013xN^5eK\u0012D#!\u001f\u001f\t\u000bu\u0004A\u0011A\u001c\u0002GQ,7\u000f^!ui\u0016l\u0007\u000f^3e\u000bB|7\r\u001b\"v[B<\u0016\u000e\u001e5MCN$X\t]8dQ\"\u0012A\u0010\u0010\u0005\u0007\u0003\u0003\u0001A\u0011A\u001c\u0002KQ,7\u000f^!ui\u0016l\u0007\u000f^3e\u000bB|7\r\u001b\"v[B<\u0016\u000e\u001e5GK:\u001cW\rZ#q_\u000eD\u0007FA@=\u0011\u0019q\u0007\u0001\"\u0003\u0002\bQ\u0019\u0001(!\u0003\t\u0011\u0005-\u0011Q\u0001a\u0001\u0003\u001b\tQa\u001d;bi\u0016\u00042\u0001FA\b\u0013\r\t\tB\u0001\u0002\u0011)J\fgn]1di&|gn\u0015;bi\u0016\u0004")
public class TransactionMetadataTest {
    private final MockTime time = new MockTime();
    private final long producerId;
    private final String transactionalId;

    public MockTime time() {
        return this.time;
    }

    public long producerId() {
        return this.producerId;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    @Test
    public void testInitializeEpoch() {
        short producerEpoch = -1;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$4 = producerEpoch;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, x$4, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, (Option)None$.MODULE$, this.time().milliseconds()).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testNormalEpochBump() {
        short producerEpoch = (short)735;
        String x$11 = this.transactionalId();
        long x$12 = this.producerId();
        long x$13 = -1L;
        short x$14 = producerEpoch;
        short x$15 = -1;
        int x$16 = 30000;
        Empty$ x$17 = Empty$.MODULE$;
        Set x$18 = Set$.MODULE$.empty();
        long x$19 = this.time().milliseconds();
        long x$20 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$11, x$12, x$13, x$14, x$15, x$16, (TransactionState)x$17, x$18, x$20, x$19);
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, (Option)None$.MODULE$, this.time().milliseconds()).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)(producerEpoch + 1), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
    }

    @Test(expected=IllegalStateException.class)
    public void testBumpEpochNotAllowedIfEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$21 = this.transactionalId();
        long x$22 = this.producerId();
        long x$23 = -1L;
        short x$24 = producerEpoch;
        short x$25 = -1;
        int x$26 = 30000;
        Empty$ x$27 = Empty$.MODULE$;
        Set x$28 = Set$.MODULE$.empty();
        long x$29 = this.time().milliseconds();
        long x$30 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$21, x$22, x$23, x$24, x$25, x$26, (TransactionState)x$27, x$28, x$30, x$29);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        txnMetadata.prepareIncrementProducerEpoch(30000, (Option)None$.MODULE$, this.time().milliseconds());
    }

    @Test
    public void testTolerateUpdateTimeShiftDuringEpochBump() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, Option$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)producerEpoch)), this.time().milliseconds() - 1L).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)(producerEpoch + 1), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateUpdateTimeResetDuringProducerIdRotation() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(this.producerId() + 1L, 30000, this.time().milliseconds() - 1L, true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)(this.producerId() + 1L), (long)txnMetadata.producerId());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringAddPartitions() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), (Object)txnMetadata.topicPartitions());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
        transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds() - 2L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic2", 0)})), (Object)txnMetadata.topicPartitions());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 2L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)PrepareCommit$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)PrepareAbort$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareCommit$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)CompleteCommit$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareAbort$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)CompleteAbort$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testFenceProducerAfterEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$31 = this.transactionalId();
        long x$32 = this.producerId();
        long x$33 = -1L;
        short x$34 = producerEpoch;
        short x$35 = -1;
        int x$36 = 30000;
        Ongoing$ x$37 = Ongoing$.MODULE$;
        Set x$38 = Set$.MODULE$.empty();
        long x$39 = this.time().milliseconds();
        long x$40 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$31, x$32, x$33, x$34, x$35, x$36, (TransactionState)x$37, x$38, x$40, x$39);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        TxnTransitMetadata fencingTransitMetadata = txnMetadata.prepareFenceProducerEpoch();
        Assert.assertEquals((long)32767L, (long)fencingTransitMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)fencingTransitMetadata.lastProducerEpoch());
        Assert.assertEquals((Object)new Some((Object)PrepareEpochFence$.MODULE$), (Object)txnMetadata.pendingState());
        txnMetadata.pendingState_$eq((Option)None$.MODULE$);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)transitMetadata.producerId());
    }

    @Test(expected=IllegalStateException.class)
    public void testFenceProducerNotAllowedIfItWouldOverflow() {
        short producerEpoch = Short.MAX_VALUE;
        String x$41 = this.transactionalId();
        long x$42 = this.producerId();
        long x$43 = -1L;
        short x$44 = producerEpoch;
        short x$45 = -1;
        int x$46 = 30000;
        Ongoing$ x$47 = Ongoing$.MODULE$;
        Set x$48 = Set$.MODULE$.empty();
        long x$49 = this.time().milliseconds();
        long x$50 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$41, x$42, x$43, x$44, x$45, x$46, (TransactionState)x$47, x$48, x$50, x$49);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        txnMetadata.prepareFenceProducerEpoch();
    }

    @Test
    public void testRotateProducerId() {
        short producerEpoch = (short)32766;
        String x$51 = this.transactionalId();
        long x$52 = this.producerId();
        long x$53 = -1L;
        short x$54 = producerEpoch;
        short x$55 = -1;
        int x$56 = 30000;
        Empty$ x$57 = Empty$.MODULE$;
        Set x$58 = Set$.MODULE$.empty();
        long x$59 = this.time().milliseconds();
        long x$60 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$51, x$52, x$53, x$54, x$55, x$56, (TransactionState)x$57, x$58, x$60, x$59);
        long newProducerId = 9893L;
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)newProducerId, (long)txnMetadata.producerId());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.lastProducerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInOngoingState() {
        this.testRotateProducerIdInOngoingState((TransactionState)Ongoing$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInPrepareAbortState() {
        this.testRotateProducerIdInOngoingState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInPrepareCommitState() {
        this.testRotateProducerIdInOngoingState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void testAttemptedEpochBumpWithNewlyCreatedMetadata() {
        short producerEpoch = (short)735;
        String x$61 = this.transactionalId();
        long x$62 = this.producerId();
        long x$63 = -1L;
        short x$64 = -1;
        short x$65 = -1;
        int x$66 = 30000;
        Empty$ x$67 = Empty$.MODULE$;
        Set x$68 = Set$.MODULE$.empty();
        long x$69 = this.time().milliseconds();
        long x$70 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$61, x$62, x$63, x$64, x$65, x$66, (TransactionState)x$67, x$68, x$70, x$69);
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), this.time().milliseconds()).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testEpochBumpWithCurrentEpochProvided() {
        short producerEpoch = (short)735;
        String x$71 = this.transactionalId();
        long x$72 = this.producerId();
        long x$73 = -1L;
        short x$74 = producerEpoch;
        short x$75 = -1;
        int x$76 = 30000;
        Empty$ x$77 = Empty$.MODULE$;
        Set x$78 = Set$.MODULE$.empty();
        long x$79 = this.time().milliseconds();
        long x$80 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$71, x$72, x$73, x$74, x$75, x$76, (TransactionState)x$77, x$78, x$80, x$79);
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), this.time().milliseconds()).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)(producerEpoch + 1), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithLastEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$81 = this.transactionalId();
        long x$82 = this.producerId();
        long x$83 = -1L;
        short x$84 = producerEpoch;
        short x$85 = lastProducerEpoch;
        int x$86 = 30000;
        Empty$ x$87 = Empty$.MODULE$;
        Set x$88 = Set$.MODULE$.empty();
        long x$89 = this.time().milliseconds();
        long x$90 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$81, x$82, x$83, x$84, x$85, x$86, (TransactionState)x$87, x$88, x$90, x$89);
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)lastProducerEpoch)), this.time().milliseconds()).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)lastProducerEpoch, (long)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithFencedEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$91 = this.transactionalId();
        long x$92 = this.producerId();
        long x$93 = this.producerId();
        short x$94 = producerEpoch;
        short x$95 = lastProducerEpoch;
        int x$96 = 30000;
        Empty$ x$97 = Empty$.MODULE$;
        Set x$98 = Set$.MODULE$.empty();
        long x$99 = this.time().milliseconds();
        long x$100 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$91, x$92, x$93, x$94, x$95, x$96, (TransactionState)x$97, x$98, x$100, x$99);
        Errors error = (Errors)txnMetadata.prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)((short)(lastProducerEpoch - 1)))), this.time().milliseconds()).left().get();
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_EPOCH, (Object)error);
    }

    private void testRotateProducerIdInOngoingState(TransactionState state) {
        short producerEpoch = (short)32766;
        String x$101 = this.transactionalId();
        long x$102 = this.producerId();
        long x$103 = this.producerId();
        short x$104 = producerEpoch;
        short x$105 = -1;
        int x$106 = 30000;
        TransactionState x$107 = state;
        Set x$108 = Set$.MODULE$.empty();
        long x$109 = this.time().milliseconds();
        long x$110 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$110, x$109);
        long newProducerId = 9893L;
        txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), false);
    }

    public TransactionMetadataTest() {
        this.producerId = 23423L;
        this.transactionalId = "txnlId";
    }
}

