/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManagerTest$;
import kafka.coordinator.transaction.TransactionStateManagerTest$$anon$4$;
import kafka.coordinator.transaction.TransactionStateManagerTest$$anonfun$collectTransactionalIdsFromTombstones$1$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r\u0015f\u0001B\u0001\u0003\u0001%\u00111\u0004\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:UKN$(BA\u0002\u0005\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\u00151\u0011aC2p_J$\u0017N\\1u_JT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013\u0005q#A\u0006qCJ$\u0018\u000e^5p]&#W#\u0001\r\u0011\u0005-I\u0012B\u0001\u000e\r\u0005\rIe\u000e\u001e\u0005\u00079\u0001\u0001\u000b\u0011\u0002\r\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u000fy\u0001!\u0019!C\u0001/\u0005ia.^7QCJ$\u0018\u000e^5p]NDa\u0001\t\u0001!\u0002\u0013A\u0012A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\bE\u0001\u0011\r\u0011\"\u0001\u0018\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\"1A\u0005\u0001Q\u0001\na\tQ\u0003\u001e:b]N\f7\r^5p]RKW.Z8vi6\u001b\b\u0005C\u0004'\u0001\t\u0007I\u0011A\u0014\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t\u0001\u0006\u0005\u0002*c5\t!F\u0003\u0002,Y\u000511m\\7n_:T!aB\u0017\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0005\u0003e)\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u00045\u0001\u0001\u0006I\u0001K\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA!9a\u0007\u0001b\u0001\n\u00039\u0012\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011\u0019A\u0004\u0001)A\u00051\u0005\t2m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0011\t\u000fi\u0002!\u0019!C\u0001w\u0005QA\u000f\u001f8SK\u000e|'\u000fZ:\u0016\u0003q\u00022!\u0010\"E\u001b\u0005q$BA A\u0003\u001diW\u000f^1cY\u0016T!!\u0011\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002D}\tY\u0011I\u001d:bs\n+hMZ3s!\t)\u0005*D\u0001G\u0015\t9%&\u0001\u0004sK\u000e|'\u000fZ\u0005\u0003\u0013\u001a\u0013AbU5na2,'+Z2pe\u0012Daa\u0013\u0001!\u0002\u0013a\u0014a\u0003;y]J+7m\u001c:eg\u0002Bq!\u0014\u0001C\u0002\u0013\u0005a*\u0001\u0003uS6,W#A(\u0011\u0005A\u001bV\"A)\u000b\u0005IS\u0013!B;uS2\u001c\u0018B\u0001+R\u0005!iunY6US6,\u0007B\u0002,\u0001A\u0003%q*A\u0003uS6,\u0007\u0005C\u0004Y\u0001\t\u0007I\u0011A-\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001.\u0011\u0005mkV\"\u0001/\u000b\u0005I3\u0011B\u00010]\u00055iunY6TG\",G-\u001e7fe\"1\u0001\r\u0001Q\u0001\ni\u000b!b]2iK\u0012,H.\u001a:!\u0011\u001d\u0011\u0007A1A\u0005\u0002\r\f\u0001B_6DY&,g\u000e^\u000b\u0002IB\u0011Q\r[\u0007\u0002M*\u0011qMB\u0001\u0003u.L!!\u001b4\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011\u0019Y\u0007\u0001)A\u0005I\u0006I!p[\"mS\u0016tG\u000f\t\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003e\u001a\taa]3sm\u0016\u0014\u0018B\u0001;r\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDaA\u001e\u0001!\u0002\u0013y\u0017a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\t\u000fa\u0004!\u0019!C\u0001s\u00069Q.\u001a;sS\u000e\u001cX#\u0001>\u0011\u0005mlX\"\u0001?\u000b\u0005aT\u0013B\u0001@}\u0005\u001diU\r\u001e:jGNDq!!\u0001\u0001A\u0003%!0\u0001\u0005nKR\u0014\u0018nY:!\u0011%\t)\u0001\u0001b\u0001\n\u0003\t9!A\u0005uq:\u001cuN\u001c4jOV\u0011\u0011\u0011\u0002\t\u0004)\u0005-\u0011bAA\u0007\u0005\t\tBK]1og\u0006\u001cG/[8o\u0007>tg-[4\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0013\t!\u0002\u001e=o\u0007>tg-[4!\u0011%\t)\u0002\u0001b\u0001\n\u0003\t9\"\u0001\nue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014XCAA\r!\r!\u00121D\u0005\u0004\u0003;\u0011!a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0011!\t\t\u0003\u0001Q\u0001\n\u0005e\u0011a\u0005;sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ\u0004\u0003\"CA\u0013\u0001\t\u0007I\u0011AA\u0014\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017'\u0006\u0002\u0002*A!\u00111FA\u0019\u001d\rY\u0011QF\u0005\u0004\u0003_a\u0011A\u0002)sK\u0012,g-\u0003\u0003\u00024\u0005U\"AB*ue&twMC\u0002\u000201A\u0001\"!\u000f\u0001A\u0003%\u0011\u0011F\u0001\u0012iJ\fgn]1di&|g.\u00197JIF\u0002\u0003\"CA\u001f\u0001\t\u0007I\u0011AA\u0014\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#'\u0007\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u0015\u0003E!(/\u00198tC\u000e$\u0018n\u001c8bY&#'\u0007\t\u0005\n\u0003\u000b\u0002!\u0019!C\u0001\u0003\u000f\n1\u0003\u001e=o\u001b\u0016\u001c8/Y4f\u0017\u0016L()\u001f;fgF*\"!!\u0013\u0011\u000b-\tY%a\u0014\n\u0007\u00055CBA\u0003BeJ\f\u0017\u0010E\u0002\f\u0003#J1!a\u0015\r\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u0013\nA\u0003\u001e=o\u001b\u0016\u001c8/Y4f\u0017\u0016L()\u001f;fgF\u0002\u0003\"CA.\u0001\t\u0007I\u0011AA$\u0003M!\bP\\'fgN\fw-Z&fs\nKH/Z:3\u0011!\ty\u0006\u0001Q\u0001\n\u0005%\u0013\u0001\u0006;y]6+7o]1hK.+\u0017PQ=uKN\u0014\u0004\u0005C\u0005\u0002d\u0001\u0011\r\u0011\"\u0001\u0002f\u0005Y\u0001O]8ek\u000e,'/\u00133t+\t\t9\u0007\u0005\u0005\u0002j\u0005-\u0014\u0011FA8\u001b\u0005\u0001\u0015bAA7\u0001\n\u0019Q*\u00199\u0011\u0007-\t\t(C\u0002\u0002t1\u0011A\u0001T8oO\"A\u0011q\u000f\u0001!\u0002\u0013\t9'\u0001\u0007qe>$WoY3s\u0013\u0012\u001c\b\u0005C\u0005\u0002|\u0001\u0001\r\u0011\"\u0001\u0002~\u0005aA\u000f\u001f8NKR\fG-\u0019;bcU\u0011\u0011q\u0010\t\u0004)\u0005\u0005\u0015bAAB\u0005\t\u0019BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\"I\u0011q\u0011\u0001A\u0002\u0013\u0005\u0011\u0011R\u0001\u0011ibtW*\u001a;bI\u0006$\u0018-M0%KF$B!a#\u0002\u0012B\u00191\"!$\n\u0007\u0005=EB\u0001\u0003V]&$\bBCAJ\u0003\u000b\u000b\t\u00111\u0001\u0002\u0000\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005]\u0005\u0001)Q\u0005\u0003\u007f\nQ\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCF\u0002\u0003\"CAN\u0001\u0001\u0007I\u0011AA?\u00031!\bP\\'fi\u0006$\u0017\r^13\u0011%\ty\n\u0001a\u0001\n\u0003\t\t+\u0001\tuq:lU\r^1eCR\f'g\u0018\u0013fcR!\u00111RAR\u0011)\t\u0019*!(\u0002\u0002\u0003\u0007\u0011q\u0010\u0005\t\u0003O\u0003\u0001\u0015)\u0003\u0002\u0000\u0005iA\u000f\u001f8NKR\fG-\u0019;be\u0001B\u0011\"a+\u0001\u0001\u0004%\t!!,\u0002\u001b\u0015D\b/Z2uK\u0012,%O]8s+\t\ty\u000b\u0005\u0003\u00022\u0006]VBAAZ\u0015\r\t)LK\u0001\taJ|Go\\2pY&!\u0011\u0011XAZ\u0005\u0019)%O]8sg\"I\u0011Q\u0018\u0001A\u0002\u0013\u0005\u0011qX\u0001\u0012Kb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:`I\u0015\fH\u0003BAF\u0003\u0003D!\"a%\u0002<\u0006\u0005\t\u0019AAX\u0011!\t)\r\u0001Q!\n\u0005=\u0016AD3ya\u0016\u001cG/\u001a3FeJ|'\u000f\t\u0005\b\u0003\u0013\u0004A\u0011AAf\u0003\u0015\u0019X\r^+q)\t\tY\t\u000b\u0003\u0002H\u0006=\u0007\u0003BAi\u0003/l!!a5\u000b\u0007\u0005Uw&A\u0003kk:LG/\u0003\u0003\u0002Z\u0006M'A\u0002\"fM>\u0014X\rC\u0004\u0002^\u0002!\t!a3\u0002\u0011Q,\u0017M\u001d#po:DC!a7\u0002bB!\u0011\u0011[Ar\u0013\u0011\t)/a5\u0003\u000b\u00053G/\u001a:\t\u000f\u0005%\b\u0001\"\u0001\u0002L\u0006qB/Z:u-\u0006d\u0017\u000eZ1uKR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f\u001e\u0015\u0005\u0003O\fi\u000f\u0005\u0003\u0002R\u0006=\u0018\u0002BAy\u0003'\u0014A\u0001V3ti\"9\u0011Q\u001f\u0001\u0005\u0002\u0005-\u0017A\u0004;fgR\fE\rZ$fiBKGm\u001d\u0015\u0005\u0003g\fi\u000fC\u0004\u0002|\u0002!\t!a3\u0002'Q,7\u000f\u001e#fY\u0016$X\rU1si&$\u0018n\u001c8)\t\u0005e\u0018Q\u001e\u0005\b\u0005\u0003\u0001A\u0011AAf\u0003i!Xm\u001d;EK2,G/\u001a'pC\u0012Lgn\u001a)beRLG/[8oQ\u0011\ty0!<\t\u000f\t\u001d\u0001\u0001\"\u0001\u0002L\u0006IC/Z:u\u0019>\fG-\u00118e%\u0016lwN^3Ue\u0006t7/Y2uS>t7OR8s!\u0006\u0014H/\u001b;j_:DCA!\u0002\u0002n\"9!Q\u0002\u0001\u0005\u0002\u0005-\u0017!\u000b;fgR\u001cu.\u001c9mKR,GK]1og&$\u0018n\u001c8XQ\u0016t\u0017\t\u001d9f]\u0012\u001cVoY2fK\u0012,G\r\u000b\u0003\u0003\f\u00055\bb\u0002B\n\u0001\u0011\u0005\u00111Z\u0001-i\u0016\u001cH/\u00119qK:$g)Y5m)>\u001cun\u001c:eS:\fGo\u001c:O_R\fe/Y5mC\ndW-\u0012:s_JDCA!\u0005\u0002n\"9!\u0011\u0004\u0001\u0005\u0002\u0005-\u0017a\t;fgR\f\u0005\u000f]3oI\u001a\u000b\u0017\u000e\u001c+p\u001d>$8i\\8sI&t\u0017\r^8s\u000bJ\u0014xN\u001d\u0015\u0005\u0005/\ti\u000fC\u0004\u0003 \u0001!\t!a3\u0002OQ,7\u000f^!qa\u0016tGMR1jYR{7i\\8sI&t\u0017\r^8s\u0019>\fG-\u001b8h\u000bJ\u0014xN\u001d\u0015\u0005\u0005;\ti\u000fC\u0004\u0003&\u0001!\t!a3\u00029Q,7\u000f^!qa\u0016tGMR1jYR{WK\\6o_^tWI\u001d:pe\"\"!1EAw\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0003\u0017\fQ\u0005^3tiB+g\u000eZ5oON#\u0018\r^3O_R\u0014Vm]3u\u001f:\u0014V\r\u001e:z\u0003B\u0004XM\u001c3)\t\t%\u0012Q\u001e\u0005\b\u0005c\u0001A\u0011AAf\u00035\"Xm\u001d;BaB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000eT8h/\"LG.\u001a)s_\u0012,8-\u001a:GK:\u001cW\r\u001a\u0015\u0005\u0005_\ti\u000fC\u0004\u00038\u0001!\t!a3\u0002eQ,7\u000f^!qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4XQ&dW\rU3oI&twm\u0015;bi\u0016\u001c\u0005.\u00198hK\u0012D\u0003B!\u000e\u0002n\nm\"QH\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012!q\b\t\u0005\u0005\u0003\u0012Y%\u0004\u0002\u0003D)!!Q\tB$\u0003\u0011a\u0017M\\4\u000b\u0005\t%\u0013\u0001\u00026bm\u0006LAA!\u0014\u0003D\t)\u0012\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>t\u0007b\u0002B)\u0001\u0011\u0005\u00111Z\u0001@g\"|W\u000f\u001c3SKR,(O\u001c(pi\u000e{wN]5e]\u0006$xN]#se>\u0014\u0018J\u001a+sC:\u001c\u0018m\u0019;j_:LE\rU1si&$\u0018n\u001c8O_R|uO\\3eQ\u0011\u0011y%!<\t\u000f\t]\u0003\u0001\"\u0001\u0002L\u000614\u000f[8vY\u0012|e\u000e\\=D_:\u001c\u0018\u000eZ3s)J\fgn]1di&|gn]%o)\",wJ\\4pS:<7\u000b^1uKR{\u0017IY8si\"\"!QKAw\u0011\u001d\u0011i\u0006\u0001C\u0001\u0003\u0017\f\u0001h\u001d5pk2$wK]5uKRCh.T1sW\u0016\u00148OR8s)J\fgn]1di&|g.\u00138Qe\u0016\u0004\u0018M]3e\u0007>lW.\u001b;Ti\u0006$X\r\u000b\u0003\u0003\\\u00055\bb\u0002B2\u0001\u0011\u0005\u00111Z\u00018g\"|W\u000f\u001c3Xe&$X\r\u0016=o\u001b\u0006\u00148.\u001a:t\r>\u0014HK]1og\u0006\u001cG/[8o\u0013:\u0004&/\u001a9be\u0016$\u0017IY8siN#\u0018\r^3)\t\t\u0005\u0014Q\u001e\u0005\b\u0005S\u0002A\u0011AAf\u0003E\u001a\bn\\;mIJ+Wn\u001c<f\u0007>l\u0007\u000f\\3uK\u000e{W.\\5u\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JINDCAa\u001a\u0002n\"9!q\u000e\u0001\u0005\u0002\u0005-\u0017\u0001M:i_VdGMU3n_Z,7i\\7qY\u0016$X-\u00112peR,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000f\u000b\u0003\u0003n\u00055\bb\u0002B;\u0001\u0011\u0005\u00111Z\u0001)g\"|W\u000f\u001c3SK6|g/Z#naRLX\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0005\u0005g\ni\u000fC\u0004\u0003|\u0001!\t!a3\u0002mMDw.\u001e7e\u001d>$(+Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7/\u00134M_\u001e\f\u0005\u000f]3oI\u001a\u000b\u0017\u000e\\:)\t\te\u0014Q\u001e\u0005\b\u0005\u0003\u0003A\u0011AAf\u0003\u0019\u001a\bn\\;mI:{GOU3n_Z,wJ\\4pS:<GK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0005\u0005\u007f\ni\u000fC\u0004\u0003\b\u0002!\t!a3\u0002WMDw.\u001e7e\u001d>$(+Z7pm\u0016\u0004&/\u001a9be\u0016\f%m\u001c:u)J\fgn]1di&|g.\u00197JINDCA!\"\u0002n\"9!Q\u0012\u0001\u0005\u0002\u0005-\u0017\u0001L:i_VdGMT8u%\u0016lwN^3Qe\u0016\u0004\u0018M]3D_6l\u0017\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\u0011\u0011Y)!<\t\u000f\tM\u0005\u0001\"\u0001\u0002L\u0006\u0001D/Z:u)J\fgn]1di&|g.\u00197FqBL'/\u0019;j_:<\u0016\u000e\u001e5U_>\u001cV.\u00197m\u0005\u0006$8\r[*ju\u0016DCA!%\u0002n\"9!\u0011\u0014\u0001\u0005\u0002\u0005-\u0017\u0001\f;fgR$&/\u00198tC\u000e$\u0018n\u001c8bY\u0016C\b/\u001b:bi&|gnV5uQ>3g\r\\5oK2{w\rR5sQ\u0011\u00119*!<\t\u000f\t}\u0005\u0001\"\u0001\u0002L\u0006yC/Z:u)J\fgn]1di&|g.\u0012=qSJ\fG/[8o'\"|W\u000f\u001c3SKN\u0004Xm\u0019;CCR\u001c\u0007nU5{K\"\"!QTAw\u0011\u001d\u0011)\u000b\u0001C\u0005\u0005O\u000bQeY8mY\u0016\u001cG\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:Ge>lGk\\7cgR|g.Z:\u0015\t\t%&q\u0016\t\u0007\u0003W\u0011Y+!\u000b\n\t\t5\u0016Q\u0007\u0002\u0004'\u0016$\b\u0002\u0003BY\u0005G\u0003\rAa-\u0002\u001f\u0005\u0004\b/\u001a8eK\u0012\u0014VmY8sIN\u0004b!\u0010B[Q\t]\u0016bAA7}A)QH!/\u0003>&\u0019!1\u0018 \u0003\r\t+hMZ3s!\r)%qX\u0005\u0004\u0005\u00034%!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0003F\u0002!IAa2\u000271|\u0017\rZ#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t)\u0011\u0011IK!3\t\u000f\t-'1\u0019a\u00011\u0005\u0019b.^7Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"9!q\u001a\u0001\u0005\n\tE\u0017!\b7jgR,\u0005\u0010]5sC\ndW\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:\u0015\u0005\t%\u0006b\u0002Bk\u0001\u0011\u0005\u00111Z\u0001\u001ci\u0016\u001cHoU;dG\u0016\u001c8OZ;m%\u0016LW.\\5he\u0006$\u0018n\u001c8)\t\tM\u0017Q\u001e\u0005\b\u00057\u0004A\u0011AAf\u0003-\"Xm\u001d;M_\u0006$GK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC^KG\u000f[\"peJ,\b\u000f^3e\u0019><\u0007\u0006\u0002Bm\u0003[DqA!9\u0001\t\u0013\u0011\u0019/\u0001\u0012wKJLg-_'fi\u0006$\u0017\r^1E_\u0016\u001cX\t_5ti\u0006sG-S:Vg\u0006\u0014G.\u001a\u000b\u0005\u0003\u0017\u0013)\u000f\u0003\u0005\u0003h\n}\u0007\u0019AA\u0015\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007b\u0002Bv\u0001\u0011%!Q^\u0001\u001am\u0016\u0014\u0018NZ=NKR\fG-\u0019;b\t>,7O\u001c;Fq&\u001cH\u000f\u0006\u0003\u0002\f\n=\b\u0002\u0003Bt\u0005S\u0004\r!!\u000b\t\u000f\tM\b\u0001\"\u0003\u0003v\u0006yR\r\u001f9fGR$&/\u00198tC\u000e$\u0018n\u001c8bY&#W\t\u001f9je\u0006$\u0018n\u001c8\u0015\r\u0005-%q\u001fB~\u0011!\u0011IP!=A\u0002\u0005=\u0016aC1qa\u0016tG-\u0012:s_JD\u0001B!@\u0003r\u0002\u0007!1W\u0001\u0010G\u0006\u0004H/\u001e:fI\u0006\u0003\b/\u001a8eg\"91\u0011\u0001\u0001\u0005\n\r\r\u0011!\b7pC\u0012$&/\u00198tC\u000e$\u0018n\u001c8t\r>\u0014\b+\u0019:uSRLwN\\:\u0015\t\u0005-5Q\u0001\u0005\t\u0007\u000f\u0011y\u00101\u0001\u0004\n\u0005a\u0001/\u0019:uSRLwN\\%egB)11BB\u000e19!1QBB\f\u001d\u0011\u0019ya!\u0006\u000e\u0005\rE!bAB\n\u0011\u00051AH]8pizJ\u0011!D\u0005\u0004\u00073a\u0011a\u00029bG.\fw-Z\u0005\u0005\u0007;\u0019yBA\u0002TKFT1a!\u0007\r\u0011\u001d\u0019\u0019\u0003\u0001C\u0005\u0007K\tq\"\u001a=qK\u000e$Hj\\4D_:4\u0017n\u001a\u000b\u0007\u0003\u0017\u001b9c!\u000b\t\u0011\r\u001d1\u0011\u0005a\u0001\u0007\u0013Aqaa\u000b\u0004\"\u0001\u0007\u0001$\u0001\u0007nCb\u0014\u0015\r^2i'&TX\rC\u0004\u00040\u0001!Ia!\r\u0002IM,G/\u001e9B]\u0012\u0014VO\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:$b!a#\u00044\r]\u0002\u0002CB\u001b\u0007[\u0001\r!a,\u0002\u000b\u0015\u0014(o\u001c:\t\u0011\re2Q\u0006a\u0001\u0007w\t\u0001\u0002\u001e=o'R\fG/\u001a\t\u0004)\ru\u0012bAB \u0005\t\u0001BK]1og\u0006\u001cG/[8o'R\fG/\u001a\u0005\b\u0007\u0007\u0002A\u0011BB#\u0003\u00112XM]5gs^\u0013\u0018\u000e^3t)btW*\u0019:lKJ\u001c\u0018J\u001c)sKB\f'/Z*uCR,G\u0003BAF\u0007\u000fB\u0001b!\u0013\u0004B\u0001\u000711H\u0001\u0006gR\fG/\u001a\u0005\b\u0007\u001b\u0002A\u0011BB(\u00039\t7o]3si\u000e\u000bG\u000e\u001c2bG.$B!a#\u0004R!A1QGB&\u0001\u0004\ty\u000bC\u0004\u0004V\u0001!Iaa\u0016\u0002'Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0015\u0015\u0005}4\u0011LB.\u0007?\u001a\t\u0007\u0003\u0005\u0003h\u000eM\u0003\u0019AA\u0015\u0011!\u0019ifa\u0015A\u0002\u0005=\u0014A\u00039s_\u0012,8-\u001a:JI\"Q1\u0011JB*!\u0003\u0005\raa\u000f\t\u0013\r\r41\u000bI\u0001\u0002\u0004A\u0012A\u0003;y]RKW.Z8vi\"91q\r\u0001\u0005\n\r%\u0014!\u00049sKB\f'/\u001a+y]2{w\r\u0006\u0005\u0002\f\u000e-4QNB9\u0011\u001913Q\ra\u0001Q!A1qNB3\u0001\u0004\ty'A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\b\u0002CB:\u0007K\u0002\rA!0\u0002\u000fI,7m\u001c:eg\"91q\u000f\u0001\u0005\n\re\u0014A\u00079sKB\f'/\u001a$peRCh.T3tg\u0006<W-\u00119qK:$G\u0003BAF\u0007wB\u0001b!\u000e\u0004v\u0001\u0007\u0011q\u0016\u0005\b\u0007\u007f\u0002A\u0011AAf\u0003]!Xm\u001d;QCJ$\u0018\u000e^5p]2{\u0017\rZ'fiJL7\r\u000b\u0003\u0004~\u00055\b\"CBC\u0001E\u0005I\u0011BBD\u0003u!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\u001aTCABEU\u0011\u0019Yda#,\u0005\r5\u0005\u0003BBH\u00073k!a!%\u000b\t\rM5QS\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa&\r\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00077\u001b\tJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011ba(\u0001#\u0003%Ia!)\u0002;Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ*\"aa)+\u0007a\u0019Y\t")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final Metrics metrics;
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @Before
    public void setUp() {
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId1()));
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2()));
    }

    @Test
    public void testDeletePartition() {
        TransactionMetadata metadata1 = this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata("b", 5L, this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$3(), this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$4());
        TransactionMetadata metadata2 = this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata("a", 10L, this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$3(), this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$4());
        Assert.assertEquals((long)0L, (long)this.transactionManager().partitionFor(metadata1.transactionalId()));
        Assert.assertEquals((long)1L, (long)this.transactionManager().partitionFor(metadata2.transactionalId()));
        this.transactionManager().addLoadedTransactionsToCache(0, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata1);
        this.transactionManager().addLoadedTransactionsToCache(1, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata2);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata1.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
        this.transactionManager().removeTransactionsForTxnTopicPartition(0);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
    }

    @Test
    public void testDeleteLoadingPartition() {
        long startOffset = 0L;
        long endOffset = 1L;
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        AbstractLog logMock = (AbstractLog)EasyMock.mock(AbstractLog.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.topicPartition())).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()))});
        CountDownLatch latch = new CountDownLatch(1);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records2.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, records2, latch, bufferCapture){
            private final MemoryRecords records$1;
            private final CountDownLatch latch$1;
            private final Capture bufferCapture$1;

            public void answer() {
                this.latch$1.await();
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.records$1 = records$1;
                this.latch$1 = latch$1;
                this.bufferCapture$1 = bufferCapture$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
        int coordinatorEpoch = 0;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(this.partitionId(), coordinatorEpoch);
        Thread loadingThread = new Thread(new Runnable(this, coordinatorEpoch){
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final int coordinatorEpoch$1;

            public void run() {
                this.$outer.transactionManager().loadTransactionsForTxnTopicPartition(this.$outer.partitionId(), this.coordinatorEpoch$1, (Function5)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String x$2, int x$3, TransactionResult x$4, TransactionMetadata x$5, TxnTransitMetadata x$6) {
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.coordinatorEpoch$1 = coordinatorEpoch$1;
            }
        });
        loadingThread.start();
        Serializable x$44 = new Serializable(this, partitionAndLeaderEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.transactionManager().loadingPartitions().contains((Object)this.partitionAndLeaderEpoch$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionAndLeaderEpoch$1 = partitionAndLeaderEpoch$1;
            }
        };
        Serializable x$45 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for loading partition";
            }
        };
        long x$46 = 10L;
        long x$47 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$44, (Function0<String>)x$45, x$47, x$46);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId());
        Assert.assertFalse((boolean)this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch));
        latch.countDown();
        loadingThread.join();
        Assert.assertEquals((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR), (Object)this.transactionManager().getTransactionState(this.txnMetadata1().transactionalId()));
    }

    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records2);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Errors err) {
                Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Option<CoordinatorEpochAndTxnMetadata> x$7) {
                return Assertions$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId1()).append((Object)"'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Errors err) {
                Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Option<CoordinatorEpochAndTxnMetadata> x$8) {
                return Assertions$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId2()).append((Object)"'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String x$9, int x$10, TransactionResult x$11, TransactionMetadata x$12, TxnTransitMetadata x$13) {
            }
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Errors err) {
                return Assertions$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId1()).append((Object)"'s transaction state access returns error ").append((Object)err).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final CoordinatorEpochAndTxnMetadata apply(Option<CoordinatorEpochAndTxnMetadata> entry) {
                return (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testLoadAndRemoveTransactionsForPartition$7 $outer;

                    public final Nothing$ apply() {
                        return Assertions$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer().transactionalId1()).append((Object)"'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TransactionStateManagerTest kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Errors err) {
                return Assertions$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId1()).append((Object)"'s transaction state access returns error ").append((Object)err).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final CoordinatorEpochAndTxnMetadata apply(Option<CoordinatorEpochAndTxnMetadata> entry) {
                return (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final Nothing$ apply() {
                        return Assertions$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer().transactionalId1()).append((Object)"'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TransactionStateManagerTest kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Errors err) {
                return Assertions$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId2()).append((Object)"'s transaction state access returns error ").append((Object)err).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final CoordinatorEpochAndTxnMetadata apply(Option<CoordinatorEpochAndTxnMetadata> entry) {
                return (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final Nothing$ apply() {
                        return Assertions$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer().transactionalId2()).append((Object)"'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TransactionStateManagerTest kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assert.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Errors err) {
                Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Option<CoordinatorEpochAndTxnMetadata> x$14) {
                return Assertions$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId1()).append((Object)"'s transaction state is still in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Errors err) {
                Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Option<CoordinatorEpochAndTxnMetadata> x$15) {
                return Assertions$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId2()).append((Object)"'s transaction state is still in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), this.coordinatorEpoch(), newMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_FOR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Errors x$16) {
                return true;
            }
        });
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test(expected=IllegalStateException.class)
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Errors err) {
                Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Option<CoordinatorEpochAndTxnMetadata> x$17) {
                return Assertions$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId1()).append((Object)"'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                this.$outer.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.transactionManager().putTransactionStateIfNotExists(this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists(this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$4()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransactionalIdAndProducerIdEpoch[]{new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0)})), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void testTransactionalExpirationWithTooSmallBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 16;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map attemptedAppends = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.MESSAGE_TOO_LARGE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)attemptedAppends);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        attemptedAppends.values().foreach((Function1)new Serializable(this, maxBatchSize){
            public static final long serialVersionUID = 0L;
            public final int maxBatchSize$1;

            public final void apply(Buffer<MemoryRecords> batches) {
                batches.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTransactionalExpirationWithTooSmallBatchSize$1 $outer;

                    public final void apply(MemoryRecords batch) {
                        Assert.assertTrue((batch.sizeInBytes() > this.$outer.maxBatchSize$1 ? 1 : 0) != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.maxBatchSize$1 = maxBatchSize$1;
            }
        });
        Assert.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
    }

    @Test
    public void testTransactionalExpirationWithOfflineLogDir() {
        int onlinePartitionId = 0;
        int offlinePartitionId = 1;
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId, offlinePartitionId}));
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId}))), maxBatchSize);
        EasyMock.expect((Object)this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", offlinePartitionId))).andStubReturn((Object)None$.MODULE$);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId})), (Object)appendedRecords.keySet().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(TopicPartition x$18) {
                return x$18.partition();
            }
        }, scala.collection.Set$.MODULE$.canBuildFrom()));
        Tuple2 tuple2 = allTransactionalIds.partition((Function1)new Serializable(this, onlinePartitionId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final int onlinePartitionId$1;

            public final boolean apply(String transactionalId) {
                return this.$outer.transactionManager().partitionFor(transactionalId) == this.onlinePartitionId$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.onlinePartitionId$1 = onlinePartitionId$1;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Set transactionalIdsForOnlinePartition = (scala.collection.immutable.Set)tuple2._1();
            scala.collection.immutable.Set transactionalIdsForOfflinePartition = (scala.collection.immutable.Set)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)transactionalIdsForOnlinePartition, (Object)transactionalIdsForOfflinePartition);
            scala.collection.immutable.Set transactionalIdsForOnlinePartition2 = (scala.collection.immutable.Set)tuple23._1();
            scala.collection.immutable.Set transactionalIdsForOfflinePartition2 = (scala.collection.immutable.Set)tuple23._2();
            scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
            Assert.assertEquals((Object)transactionalIdsForOnlinePartition2, expiredTransactionalIds);
            Assert.assertEquals((Object)transactionalIdsForOfflinePartition2, this.listExpirableTransactionalIds());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testTransactionExpirationShouldRespectBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(1000);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.listExpirableTransactionalIds());
        Assert.assertEquals((Object)partitionIds.toSet(), (Object)appendedRecords.keys().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(TopicPartition x$20) {
                return x$20.partition();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        appendedRecords.values().foreach((Function1)new Serializable(this, maxBatchSize){
            public static final long serialVersionUID = 0L;
            public final int maxBatchSize$2;

            public final void apply(Buffer<MemoryRecords> batches) {
                Assert.assertTrue((batches.size() > 1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)batches.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTransactionExpirationShouldRespectBatchSize$2 $outer;

                    public final boolean apply(MemoryRecords x$21) {
                        return x$21.sizeInBytes() < this.$outer.maxBatchSize$2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.maxBatchSize$2 = maxBatchSize$2;
            }
        });
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assert.assertEquals(allTransactionalIds, expiredTransactionalIds);
    }

    private scala.collection.immutable.Set<String> collectTransactionalIdsFromTombstones(scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> appendedRecords) {
        scala.collection.mutable.Set expiredTransactionalIds = Set$.MODULE$.empty();
        appendedRecords.values().foreach((Function1)new Serializable(this, expiredTransactionalIds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;
            public final scala.collection.mutable.Set expiredTransactionalIds$1;

            public final void apply(Buffer<MemoryRecords> batches) {
                batches.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$collectTransactionalIdsFromTombstones$1 $outer;

                    public final void apply(MemoryRecords records2) {
                        records2.records().forEach(new Consumer<Record>(this){
                            private final /* synthetic */ $anonfun$collectTransactionalIdsFromTombstones$1$$anonfun$apply$6 $outer;

                            public void accept(Record record) {
                                String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
                                Assert.assertNull((Object)record.value());
                                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$anonfun$$$outer().expiredTransactionalIds$1.$plus$eq((Object)transactionalId);
                                Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$anonfun$$$outer().kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer().transactionManager().getTransactionState(transactionalId));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$collectTransactionalIdsFromTombstones$1 kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TransactionStateManagerTest kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expiredTransactionalIds$1 = expiredTransactionalIds$1;
            }
        });
        return expiredTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> loadExpiredTransactionalIds(int numTransactionalIds) {
        scala.collection.mutable.Set allTransactionalIds = Set$.MODULE$.empty();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numTransactionalIds).foreach((Function1)new Serializable(this, allTransactionalIds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final scala.collection.mutable.Set allTransactionalIds$1;

            public final scala.collection.mutable.Set<String> apply(int i) {
                String txnlId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
                int producerId = i;
                TransactionMetadata txnMetadata = this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata(txnlId, producerId, this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$3(), this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$4());
                txnMetadata.txnLastUpdateTimestamp_$eq(this.$outer.time().milliseconds() - (long)this.$outer.txnConfig().transactionalIdExpirationMs());
                this.$outer.transactionManager().putTransactionStateIfNotExists(txnMetadata);
                return (scala.collection.mutable.Set)this.allTransactionalIds$1.$plus$eq((Object)txnlId);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allTransactionalIds$1 = allTransactionalIds$1;
            }
        });
        return allTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> listExpirableTransactionalIds() {
        Iterable activeTransactionalIds = (Iterable)this.transactionManager().transactionMetadataCache().values().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(TxnMetadataCacheEntry x$22) {
                return (Iterable)x$22.metadataPerTransactionalId().values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(TransactionMetadata x$23) {
                        return x$23.transactionalId();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)activeTransactionalIds.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final boolean apply(String transactionalId) {
                boolean bl;
                Right right;
                Option option;
                Either either = this.$outer.transactionManager().getTransactionState(transactionalId);
                if (either instanceof Right && (option = (Option)(right = (Right)either).b()) instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.x();
                    TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                    long timeSinceLastUpdate = this.$outer.time().milliseconds() - txnMetadata.txnLastUpdateTimestamp();
                    bl = timeSinceLastUpdate >= (long)this.$outer.txnConfig().transactionalIdExpirationMs() && txnMetadata.state().isExpirationAllowed() && txnMetadata.pendingState().isEmpty();
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).toSet();
    }

    @Test
    public void testSuccessfulReimmigration() {
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records2);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String x$24, int x$25, TransactionResult x$26, TransactionMetadata x$27, TxnTransitMetadata x$28) {
            }
        });
        Assert.assertEquals((long)0L, (long)this.transactionManager().loadingPartitions().size());
        this.prepareTxnLog(this.topicPartition(), 0L, records2);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function5)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String x$29, int x$30, TransactionResult x$31, TransactionMetadata x$32, TxnTransitMetadata x$33) {
            }
        });
        Assert.assertEquals((long)0L, (long)this.transactionManager().loadingPartitions().size());
        Assert.assertTrue((boolean)this.transactionManager().transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).isDefined());
        Assert.assertEquals((long)1L, (long)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).get()).coordinatorEpoch());
    }

    @Test
    public void testLoadTransactionMetadataWithCorruptedLog() {
        long startOffset = 0L;
        long endOffset = 10L;
        AbstractLog logMock = (AbstractLog)EasyMock.mock(AbstractLog.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.topicPartition())).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.replay((Object[])new Object[]{logMock});
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String x$34, int x$35, TransactionResult x$36, TransactionMetadata x$37, TxnTransitMetadata x$38) {
            }
        });
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{logMock});
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals((long)0L, (long)this.transactionManager().loadingPartitions().size());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw Assertions$.MODULE$.fail("shouldn't have been any errors", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.b();
            if (None$.MODULE$.equals(option2)) {
                throw Assertions$.MODULE$.fail("metadata should have been removed", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
            }
        }
        if (bl && (option = (Option)right.b()) instanceof Some) {
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata metadata = (CoordinatorEpochAndTxnMetadata)some.x();
            Assert.assertTrue((String)"metadata shouldn't be in a pending state", (boolean)metadata.transactionMetadata().pendingState().isEmpty());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError((Object)either);
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw Assertions$.MODULE$.fail("shouldn't have been any errors", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.b();
            if (option2 instanceof Some) {
                throw Assertions$.MODULE$.fail("metadata should have been removed", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 789));
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.b())) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError((Object)either);
    }

    private void expectTransactionalIdExpiration(Errors appendError, scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> capturedAppends) {
        Capture recordsCapture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.eq((short)((short)-1)), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.capture((Capture)recordsCapture), (Function1)EasyMock.capture((Capture)callbackCapture), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, appendError, capturedAppends, recordsCapture, callbackCapture){
            public final Errors appendError$1;
            public final scala.collection.mutable.Map capturedAppends$1;
            private final Capture recordsCapture$1;
            private final Capture callbackCapture$1;

            public void answer() {
                ((Function1)this.callbackCapture$1.getValue()).apply((Object)((TraversableOnce)((TraversableLike)this.recordsCapture$1.getValue()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$4 $outer;

                    public final Tuple2<TopicPartition, ProduceResponse.PartitionResponse> apply(Tuple2<TopicPartition, MemoryRecords> x0$1) {
                        Tuple2<TopicPartition, MemoryRecords> tuple2 = x0$1;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            MemoryRecords records2 = (MemoryRecords)tuple2._2();
                            Buffer batches = (Buffer)this.$outer.capturedAppends$1.getOrElse((Object)topicPartition, (Function0)new Serializable(this, topicPartition){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anon$4$$anonfun$answer$1 $outer;
                                private final TopicPartition topicPartition$1;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Buffer<MemoryRecords> apply() {
                                    void var1_1;
                                    Buffer batches = (Buffer)Buffer$.MODULE$.empty();
                                    this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$anon$$anonfun$$$outer().capturedAppends$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition$1), (Object)batches));
                                    return var1_1;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.topicPartition$1 = topicPartition$1;
                                }
                            });
                            batches.$plus$eq((Object)records2);
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ProduceResponse.PartitionResponse(this.$outer.appendError$1, 0L, -1L, 0L));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ $anon$4 kafka$coordinator$transaction$TransactionStateManagerTest$$anon$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            }
            {
                this.appendError$1 = appendError$1;
                this.capturedAppends$1 = capturedAppends$1;
                this.recordsCapture$1 = recordsCapture$1;
                this.callbackCapture$1 = callbackCapture$1;
            }
        }).anyTimes();
    }

    private void loadTransactionsForPartitions(Seq<Object> partitionIds) {
        partitionIds.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                this.$outer.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void expectLogConfig(Seq<Object> partitionIds, int maxBatchSize) {
        LogConfig logConfig = (LogConfig)EasyMock.mock(LogConfig.class);
        EasyMock.expect((Object)logConfig.maxMessageSize()).andStubReturn((Object)Predef$.MODULE$.int2Integer(maxBatchSize));
        partitionIds.foreach((Function1)new Serializable(this, logConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final LogConfig logConfig$1;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                EasyMock.expect((Object)this.$outer.replicaManager().getLogConfig(new TopicPartition("__transaction_state", partitionId))).andStubReturn((Object)new Some((Object)this.logConfig$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logConfig$1 = logConfig$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logConfig});
    }

    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        this.expectLogConfig((Seq<Object>)partitionIds, Defaults$.MODULE$.MaxMessageSize());
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2());
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(error, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        TransactionState transactionState = txnState;
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        boolean stateAllowsExpiration = bl2;
        if (stateAllowsExpiration) {
            int partitionId = this.transactionManager().partitionFor(this.transactionalId1());
            TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
            SimpleRecord expectedTombstone = new SimpleRecord(this.time().milliseconds(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null);
            MemoryRecords expectedRecords = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{expectedTombstone});
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})), (Object)appendedRecords.keySet());
            Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MemoryRecords[]{expectedRecords})), (Object)((SeqLike)appendedRecords.apply((Object)topicPartition)).toSeq());
        } else {
            Assert.assertEquals((Object)scala.collection.Map$.MODULE$.empty(), (Object)appendedRecords);
        }
    }

    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records2);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5)new Serializable(this, txnId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final ObjectRef txnId$1;

            public final void apply(String transactionalId, int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$rememberTxnMarkers$1(transactionalId, coordinatorEpoch, command, metadata, newMetadata, this.txnId$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.txnId$1 = txnId$1;
            }
        });
        this.scheduler().tick();
        Assert.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    public void kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(Errors error) {
        Assert.assertEquals((Object)this.expectedError(), (Object)error);
    }

    public TransactionMetadata kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    public TransactionState kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    public int kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records2) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        AbstractLog logMock = (AbstractLog)EasyMock.mock(AbstractLog.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        long endOffset = startOffset + (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size();
        EasyMock.expect((Object)this.replicaManager().getLog(topicPartition)).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(topicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records2.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, records2, bufferCapture){
            private final MemoryRecords records$2;
            private final Capture bufferCapture$2;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$2.getValue();
                buffer.put(this.records$2.buffer().duplicate());
                buffer.flip();
            }
            {
                this.records$2 = records$2;
                this.bufferCapture$2 = bufferCapture$2;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
    }

    private void prepareForTxnMessageAppend(Errors error) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, error, capturedArgument){
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final Errors error$1;
            private final Capture capturedArgument$1;

            public void answer() {
                ((Function1)this.capturedArgument$1.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", this.$outer.partitionId())), (Object)new ProduceResponse.PartitionResponse(this.error$1, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.error$1 = error$1;
                this.capturedArgument$1 = capturedArgument$1;
            }
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testPartitionLoadMetric() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        JmxReporter reporter = new JmxReporter("kafka.server");
        this.metrics().addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assert.assertEquals((double)Double.NaN, (double)this.partitionLoadTime$1("partition-load-time-max", server, mBeanName), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)this.partitionLoadTime$1("partition-load-time-avg", server, mBeanName), (double)0.0);
        Assert.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records2);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String x$39, int x$40, TransactionResult x$41, TransactionMetadata x$42, TxnTransitMetadata x$43) {
            }
        });
        this.scheduler().tick();
        Assert.assertTrue((this.partitionLoadTime$1("partition-load-time-max", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.partitionLoadTime$1("partition-load-time-avg", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
    }

    private final Option cachedProducerEpoch$1(String transactionalId) {
        return this.transactionManager().getTransactionState(transactionalId).right().toOption().flatten(Predef$.MODULE$.$conforms()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply(CoordinatorEpochAndTxnMetadata x$1) {
                return x$1.transactionMetadata().producerEpoch();
            }
        });
    }

    public final void kafka$coordinator$transaction$TransactionStateManagerTest$$rememberTxnMarkers$1(String transactionalId, int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = transactionalId;
    }

    private final double partitionLoadTime$1(String attribute, MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), attribute));
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.metrics = new Metrics();
        this.txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
        this.transactionManager = new TransactionStateManager(0, this.zkClient(), (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time(), this.metrics(), (ApiVersion)KAFKA_2_4_IV1$.MODULE$);
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$3(), this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$4());
        this.txnMetadata2 = this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$3(), this.kafka$coordinator$transaction$TransactionStateManagerTest$$transactionMetadata$default$4());
        this.expectedError = Errors.NONE;
    }
}

