/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.util.Collection;
import java.util.Properties;
import kafka.log.AbstractLog;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerLagIntegrationTest$;
import kafka.log.LogSegment;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.Record;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001\u001d\u0011A\u0004T8h\u00072,\u0017M\\3s\u0019\u0006<\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00111\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003C\u0005\u00137\u000f\u001e:bGRdunZ\"mK\u0006tWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011!B;uS2\u001c\u0018BA\t\u000f\u0005\u001daunZ4j]\u001eD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0015G>l\u0007O]3tg&|gnQ8eK\u000et\u0015-\\3\u0011\u0005UYbB\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001d;\t11\u000b\u001e:j]\u001eT!AG\f\t\u000b}\u0001A\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\t\t#\u0005\u0005\u0002\n\u0001!)1C\ba\u0001)!9A\u0005\u0001b\u0001\n\u0003)\u0013!C7t!\u0016\u0014\bj\\;s+\u00051\u0003C\u0001\f(\u0013\tAsCA\u0002J]RDaA\u000b\u0001!\u0002\u00131\u0013AC7t!\u0016\u0014\bj\\;sA!9A\u0006\u0001b\u0001\n\u0003)\u0013\u0001E7j]\u000e{W\u000e]1di&|g\u000eT1h\u0011\u0019q\u0003\u0001)A\u0005M\u0005\tR.\u001b8D_6\u0004\u0018m\u0019;j_:d\u0015m\u001a\u0011\t\u000fA\u0002!\u0019!C\u0001c\u0005!A/[7f+\u0005\u0011\u0004CA\u00074\u0013\t!dB\u0001\u0005N_\u000e\\G+[7f\u0011\u00191\u0004\u0001)A\u0005e\u0005)A/[7fA!9\u0001\b\u0001b\u0001\n\u0003I\u0014\u0001E2mK\u0006tWM\u001d\"bG.|eMZ't+\u0005Q\u0004C\u0001\f<\u0013\tatC\u0001\u0003M_:<\u0007B\u0002 \u0001A\u0003%!(A\tdY\u0016\fg.\u001a:CC\u000e\\wJ\u001a4Ng\u0002Bq\u0001\u0011\u0001C\u0002\u0013\u0005Q%A\u0006tK\u001elWM\u001c;TSj,\u0007B\u0002\"\u0001A\u0003%a%\u0001\u0007tK\u001elWM\u001c;TSj,\u0007\u0005C\u0003E\u0001\u0011\u0005S)A\u0003d_\u0012,7-F\u0001G!\t9\u0015+D\u0001I\u0015\tI%*\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003\u00172\u000baaY8n[>t'BA\u0003N\u0015\tqu*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0006\u0019qN]4\n\u0005IC%aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\t\u000fQ\u0003!\u0019!C\u0001+\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u0001W!\r1r+W\u0005\u00031^\u0011Q!\u0011:sCf\u0004\"AW.\u000e\u0003)K!\u0001\u0018&\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1a\f\u0001Q\u0001\nY\u000b\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u000b\u0001\u0004A\u0011A1\u0002\u0017\rdW-\u00198feR+7\u000f\u001e\u000b\u0002EB\u0011acY\u0005\u0003I^\u0011A!\u00168ji\"\u0012qL\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S>\u000bQA[;oSRL!a\u001b5\u0003\tQ+7\u000f\u001e\u0005\u0006[\u0002!IA\\\u0001\fe\u0016\fGM\u0012:p[2{w\r\u0006\u0002pqB\u0019\u0001o];\u000e\u0003ET!A]\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002uc\nA\u0011\n^3sC\ndW\r\u0005\u0003\u0017m\u001a2\u0013BA<\u0018\u0005\u0019!V\u000f\u001d7fe!)1\u0001\u001ca\u0001sB\u0011\u0011B_\u0005\u0003w\n\u00111\"\u00112tiJ\f7\r\u001e'pO\")Q\u0010\u0001C\u0005}\u0006IqO]5uK\u0012+\bo\u001d\u000b\f\u007f\u0006\u0015\u0011\u0011BA\u0007\u0003\u001f\t\t\u0002\u0005\u0003q\u0003\u0003)\u0018bAA\u0002c\n\u00191+Z9\t\r\u0005\u001dA\u00101\u0001'\u0003\u001dqW/\\&fsNDa!a\u0003}\u0001\u00041\u0013a\u00028v[\u0012+\bo\u001d\u0005\u0006\u0007q\u0004\r!\u001f\u0005\u0006\tr\u0004\rA\u0012\u0005\u0007\u0003'a\b\u0019\u0001\u001e\u0002\u0013QLW.Z:uC6\u0004\bf\u0002\u0001\u0002\u0018\u0005\r\u0012Q\u0005\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u00045\u0002\rI,hN\\3s\u0013\u0011\t\t#a\u0007\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u0011q\u0005\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u00065\u0002\u000fI,hN\\3sg&!\u0011\u0011GA\u0016\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u001e9\u0011Q\u0007\u0002\t\u0002\u0005]\u0012\u0001\b'pO\u000ecW-\u00198fe2\u000bw-\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0004\u0013\u0005ebAB\u0001\u0003\u0011\u0003\tYd\u0005\u0003\u0002:\u0005u\u0002c\u0001\f\u0002@%\u0019\u0011\u0011I\f\u0003\r\u0005s\u0017PU3g\u0011\u001dy\u0012\u0011\bC\u0001\u0003\u000b\"\"!a\u000e\t\u0011\u0005%\u0013\u0011\bC\u0001\u0003\u0017\nAb\u001c8f!\u0006\u0014\u0018-\\3uKJ,\"!!\u0014\u0011\r\u0005=\u0013\u0011LA/\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001B;uS2T!!a\u0016\u0002\t)\fg/Y\u0005\u0005\u00037\n\tF\u0001\u0006D_2dWm\u0019;j_:\u00042AF,\u0015\u0011!\t\t'!\u000f\u0005\u0002\u0005-\u0013A\u00039be\u0006lW\r^3sg\"\"\u0011qLA3!\u0011\t9'a \u000f\t\u0005%\u00141\u0010\b\u0005\u0003W\nIH\u0004\u0003\u0002n\u0005]d\u0002BA8\u0003kj!!!\u001d\u000b\u0007\u0005Md!\u0001\u0004=e>|GOP\u0005\u0002!&\u0011\u0011nT\u0005\u0004\u0003[A\u0017\u0002BA?\u0003W\tQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002BAA\u0003\u0007\u0013!\u0002U1sC6,G/\u001a:t\u0015\u0011\ti(a\u000b")
public class LogCleanerLagIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements Logging {
    private final String compressionCodecName;
    private final int msPerHour;
    private final int minCompactionLag;
    private final MockTime time;
    private final long cleanerBackOffMs;
    private final int segmentSize;
    private final TopicPartition[] topicPartitions;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerLagIntegrationTest$.MODULE$.parameters();
    }

    public static Collection<String[]> oneParameter() {
        return LogCleanerLagIntegrationTest$.MODULE$.oneParameter();
    }

    private Logger logger$lzycompute() {
        LogCleanerLagIntegrationTest logCleanerLagIntegrationTest = this;
        synchronized (logCleanerLagIntegrationTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int msPerHour() {
        return this.msPerHour;
    }

    public int minCompactionLag() {
        return this.minCompactionLag;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public long cleanerBackOffMs() {
        return this.cleanerBackOffMs;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    @Override
    public CompressionType codec() {
        return CompressionType.forName((String)this.compressionCodecName);
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void cleanerTest() {
        WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$4 = this.cleanerBackOffMs();
        long x$5 = this.minCompactionLag();
        int x$6 = this.segmentSize();
        float x$7 = this.makeCleaner$default$2();
        int x$8 = this.makeCleaner$default$3();
        int x$9 = this.makeCleaner$default$5();
        int x$10 = this.makeCleaner$default$7();
        long x$11 = this.makeCleaner$default$9();
        Option<Object> x$12 = this.makeCleaner$default$10();
        Properties x$13 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$3, x$7, x$8, x$4, x$9, x$5, x$10, x$6, x$11, x$12, x$13));
        AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        long T0 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends0 = this.writeDups(100, 3, log2, this.codec(), T0);
        long startSizeBlock0 = log2.size();
        this.debug((Function0<String>)new Serializable(this, startSizeBlock0){
            public static final long serialVersionUID = 0L;
            private final long startSizeBlock0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total log size at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startSizeBlock0$1)}));
            }
            {
                this.startSizeBlock0$1 = startSizeBlock0$1;
            }
        });
        LogSegment activeSegAtT0 = log2.activeSegment();
        this.debug((Function0<String>)new Serializable(this, activeSegAtT0){
            public static final long serialVersionUID = 0L;
            private final LogSegment activeSegAtT0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"active segment at T0 has base offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.activeSegAtT0$1.baseOffset())}));
            }
            {
                this.activeSegAtT0$1 = activeSegAtT0$1;
            }
        });
        int sizeUpToActiveSegmentAtT0 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.localLogSegments(0L, activeSegAtT0.baseOffset()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$1) {
                return x$1.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)new Serializable(this, sizeUpToActiveSegmentAtT0){
            public static final long serialVersionUID = 0L;
            private final int sizeUpToActiveSegmentAtT0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log size up to base offset of active segment at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.sizeUpToActiveSegmentAtT0$1)}));
            }
            {
                this.sizeUpToActiveSegmentAtT0$1 = sizeUpToActiveSegmentAtT0$1;
            }
        });
        this.cleaner().startup();
        this.time().sleep(this.minCompactionLag() / 2);
        Thread.sleep(5L * this.cleanerBackOffMs());
        Assert.assertEquals((String)"There should be no cleaning until the compaction lag has passed", (long)startSizeBlock0, (long)log2.size());
        this.time().sleep(this.minCompactionLag() / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq appends1 = (Seq)appends0.$plus$plus(this.writeDups(100, 3, log2, this.codec(), T1), Seq$.MODULE$.canBuildFrom());
        long firstBlock1SegmentBaseOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$14 = new TopicPartition("log", 0);
        long x$15 = activeSegAtT0.baseOffset();
        long x$16 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$14, x$15, x$16);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log2);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends1.toMap(Predef$.MODULE$.$conforms()), (Object)read1.toMap(Predef$.MODULE$.$conforms()));
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.localLogSegments(0L, activeSegAtT0.baseOffset()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$2) {
                return x$2.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)new Serializable(this, compactedSize){
            public static final long serialVersionUID = 0L;
            private final int compactedSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"after cleaning the compacted size up to active segment at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.compactedSize$1)}));
            }
            {
                this.compactedSize$1 = compactedSize$1;
            }
        });
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstBlock1SegmentBaseOffset), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstBlock1SegmentBaseOffset ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: size up to offset of active segment at T0=", " compacted size=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sizeUpToActiveSegmentAtT0), BoxesRunTime.boxToInteger((int)compactedSize)})), (sizeUpToActiveSegmentAtT0 > compactedSize ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(AbstractLog log2) {
        return (Iterable)log2.localLogSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Record record) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, AbstractLog log2, CompressionType codec, long timestamp) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log2, codec, timestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerLagIntegrationTest $outer;
            private final int numKeys$1;
            public final AbstractLog log$1;
            public final CompressionType codec$1;
            public final long timestamp$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer().counter();
                        byte[] x$17 = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer().counter())).toString().getBytes();
                        CompressionType x$18 = this.$outer.codec$1;
                        byte[] x$19 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        long x$20 = this.$outer.timestamp$1;
                        byte x$21 = TestUtils$.MODULE$.singletonRecords$default$5();
                        this.$outer.log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$17, x$19, x$18, x$20, x$21), 0, this.$outer.log$1.appendAsLeader$default$3(), this.$outer.log$1.appendAsLeader$default$4());
                        this.$outer.kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer().incCounter();
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerLagIntegrationTest kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.codec$1 = codec$1;
                this.timestamp$1 = timestamp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public LogCleanerLagIntegrationTest(String compressionCodecName) {
        this.compressionCodecName = compressionCodecName;
        Logging.class.$init$((Logging)this);
        this.msPerHour = 3600000;
        this.minCompactionLag = 1 * this.msPerHour();
        Assert.assertTrue((String)"compactionLag must be divisible by 2 for this test", (this.minCompactionLag() % 2 == 0 ? 1 : 0) != 0);
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerBackOffMs = 200L;
        this.segmentSize = 512;
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

