/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Properties;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.log.AbstractLog;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerParameterizedIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Eh\u0001B\u0001\u0003\u0001\u001d\u0011a\u0005T8h\u00072,\u0017M\\3s!\u0006\u0014\u0018-\\3uKJL'0\u001a3J]R,wM]1uS>tG+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t\t\u0013IY:ue\u0006\u001cG\u000fT8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti\"AQ\u0002\u0001B\u0001B\u0003%a\"\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGB\u0011q\"\u0006\b\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#E\u0001\u0007!J,G-\u001a4\n\u0005Y9\"AB*ue&twM\u0003\u0002\u0015#!)\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\"a\u0007\u000f\u0011\u0005%\u0001\u0001\"B\u0007\u0019\u0001\u0004q\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0006G>$WmY\u000b\u0002AA\u0011\u0011eK\u0007\u0002E)\u00111\u0005J\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005\u00152\u0013AB2p[6|gN\u0003\u0002\u0006O)\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0013\ta#EA\bD_6\u0004(/Z:tS>tG+\u001f9f\u0011\u0019q\u0003\u0001)A\u0005A\u000511m\u001c3fG\u0002Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011'\u0001\u0003uS6,W#\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U\"\u0011!B;uS2\u001c\u0018BA\u001c5\u0005!iunY6US6,\u0007BB\u001d\u0001A\u0003%!'A\u0003uS6,\u0007\u0005C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012!\u0010\t\u0004!y\u0002\u0015BA \u0012\u0005\u0015\t%O]1z!\t\t%)D\u0001%\u0013\t\u0019EE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\u0015\u0003\u0001\u0015!\u0003>\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0003H\u0001\u0011\u0005\u0001*A\u0006dY\u0016\fg.\u001a:UKN$H#A%\u0011\u0005AQ\u0015BA&\u0012\u0005\u0011)f.\u001b;)\u0005\u0019k\u0005C\u0001(R\u001b\u0005y%B\u0001)*\u0003\u0015QWO\\5u\u0013\t\u0011vJ\u0001\u0003UKN$\b\"\u0002+\u0001\t\u0003A\u0015a\n;fgR\u001cE.Z1og\u000e{WNY5oK\u0012\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\rV8qS\u000eD#aU'\t\u000b]\u0003A\u0011\u0001%\u0002=Q,7\u000f^\"mK\u0006tWM],ji\"lUm]:bO\u00164uN]7biZ\u0003\u0004F\u0001,N\u0011\u0015Q\u0006\u0001\"\u0001I\u00039\"Xm\u001d;DY\u0016\fg.\u001b8h\u001d\u0016\u001cH/\u001a3NKN\u001c\u0018mZ3t/&$\b.T;mi&\u0004H.\u001a,feNLwN\\:)\u0005ek\u0005\"B/\u0001\t\u0003A\u0015!M2mK\u0006tWM\u001d'pO\u0012+G.\u001a;f\u001b\u0006D8+Z4nK:$8\u000fU3s%Vt7i\u001c8gS\u001e,\u0006\u000fZ1uKR+7\u000f\u001e\u0015\u000396CQ\u0001\u0019\u0001\u0005\u0002!\u000bqc\u00197fC:,'oQ8oM&<W\u000b\u001d3bi\u0016$Vm\u001d;)\u0005}k\u0005\"B2\u0001\t\u0013!\u0017\u0001H6bM.\f7i\u001c8gS\u001e<\u0016\u000e\u001e5DY\u0016\fg.\u001a:D_:4\u0017n\u001a\u000b\u0003K.\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0003\u0002\rM,'O^3s\u0013\tQwMA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"\u00027c\u0001\u0004i\u0017!D2mK\u0006tWM]\"p]\u001aLw\r\u0005\u0002\n]&\u0011qN\u0001\u0002\u000e\u00072,\u0017M\\3s\u0007>tg-[4\t\u000bE\u0004A\u0011\u0002:\u0002!\rDWmY6MCN$8\t\\3b]\u0016$G\u0003B%tkjDQ\u0001\u001e9A\u00029\tQ\u0001^8qS\u000eDQA\u001e9A\u0002]\f1\u0002]1si&$\u0018n\u001c8JIB\u0011\u0001\u0003_\u0005\u0003sF\u00111!\u00138u\u0011\u0015Y\b\u000f1\u0001}\u0003)1\u0017N]:u\t&\u0014H/\u001f\t\u0003!uL!A`\t\u0003\t1{gn\u001a\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0003i\u0019\u0007.Z2l\u0019><\u0017I\u001a;fe\u0006\u0003\b/\u001a8eS:<G)\u001e9t)\u001dI\u0015QAA\u0007\u0003#AaaA@A\u0002\u0005\u001d\u0001cA\u0005\u0002\n%\u0019\u00111\u0002\u0002\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\u0007\u0003\u001fy\b\u0019\u0001?\u0002\u0013M$\u0018M\u001d;TSj,\u0007bBA\n\u007f\u0002\u0007\u0011QC\u0001\bCB\u0004XM\u001c3t!\u0019\t9\"!\b\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0004\u00037\t\u0012AC2pY2,7\r^5p]&!\u0011qDA\r\u0005\r\u0019V-\u001d\t\u0007!\u0005\rrO\u0004?\n\u0007\u0005\u0015\u0012C\u0001\u0004UkBdWm\r\u0005\b\u0003S\u0001A\u0011BA\u0016\u0003\u0015!x.T1q)\u0011\ti#!\u000f\u0011\u000f\u0005]\u0011qF<\u00024%!\u0011\u0011GA\r\u0005\ri\u0015\r\u001d\t\u0006!\u0005Ub\u0002`\u0005\u0004\u0003o\t\"A\u0002+va2,'\u0007\u0003\u0005\u0002<\u0005\u001d\u0002\u0019AA\u001f\u0003!iWm]:bO\u0016\u001c\bCBA\f\u0003\u007f\t\t#\u0003\u0003\u0002B\u0005e!\u0001C%uKJ\f'\r\\3\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H\u0005Y!/Z1e\rJ|W\u000eT8h)\u0011\ti$!\u0013\t\u000f\r\t\u0019\u00051\u0001\u0002\b!9\u0011Q\n\u0001\u0005\n\u0005=\u0013!G<sSR,G)\u001e9t'&tw\r\\3NKN\u001c\u0018mZ3TKR$b\"!\u0006\u0002R\u0005U\u0013\u0011LA.\u0003;\n\t\u0007C\u0004\u0002T\u0005-\u0003\u0019A<\u0002\u000f9,XnS3zg\"9\u0011qKA&\u0001\u00049\u0018a\u00028v[\u0012+\bo\u001d\u0005\b\u0007\u0005-\u0003\u0019AA\u0004\u0011\u0019q\u00121\na\u0001A!I\u0011qLA&!\u0003\u0005\ra^\u0001\tgR\f'\u000f^&fs\"A\u00111MA&\u0001\u0004\t)'\u0001\u0006nC\u001eL7MV1mk\u0016\u00042\u0001EA4\u0013\r\tI'\u0005\u0002\u0005\u0005f$X\rC\u0005\u0002n\u0001\t\n\u0011\"\u0003\u0002p\u0005\u0019sO]5uK\u0012+\bo]*j]\u001edW-T3tg\u0006<WmU3uI\u0011,g-Y;mi\u0012*TCAA9U\r9\u00181O\u0016\u0003\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0005v]\u000eDWmY6fI*\u0019\u0011qP\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0004\u0006e$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\":\u0001!a\"\u0002\u0014\u0006U\u0005\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u00055u*\u0001\u0004sk:tWM]\u0005\u0005\u0003#\u000bYIA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005]\u0005\u0003BAM\u0003?k!!a'\u000b\u0007\u0005uu*A\u0004sk:tWM]:\n\t\u0005\u0005\u00161\u0014\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000f\u0005\u0015&\u0001#\u0001\u0002(\u00061Cj\\4DY\u0016\fg.\u001a:QCJ\fW.\u001a;fe&TX\rZ%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u0007%\tIK\u0002\u0004\u0002\u0005!\u0005\u00111V\n\u0005\u0003S\u000bi\u000bE\u0002\u0011\u0003_K1!!-\u0012\u0005\u0019\te.\u001f*fM\"9\u0011$!+\u0005\u0002\u0005UFCAAT\u0011!\tI,!+\u0005\u0002\u0005m\u0016A\u00039be\u0006lW\r^3sgV\u0011\u0011Q\u0018\t\u0007\u0003\u007f\u000bI-!4\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000b\fA!\u001e;jY*\u0011\u0011qY\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002L\u0006\u0005'AC\"pY2,7\r^5p]B\u0019\u0001C\u0010\b)\t\u0005]\u0016\u0011\u001b\t\u0005\u0003'\fYO\u0004\u0003\u0002V\u0006\u001dh\u0002BAl\u0003KtA!!7\u0002d:!\u00111\\Aq\u001b\t\tiNC\u0002\u0002`\u001a\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0016\n\u0005AK\u0013bAAO\u001f&!\u0011\u0011^AN\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!\u0011Q^Ax\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0005\u0003S\fY\n")
public class LogCleanerParameterizedIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec;
    private final MockTime time;
    private final TopicPartition[] topicPartitions;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerParameterizedIntegrationTest$.MODULE$.parameters();
    }

    @Override
    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void cleanerTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            WrappedArray x$14 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            int x$15 = maxMessageSize;
            float x$16 = this.makeCleaner$default$2();
            int x$17 = this.makeCleaner$default$3();
            long x$18 = this.makeCleaner$default$4();
            long x$19 = this.makeCleaner$default$6();
            int x$20 = this.makeCleaner$default$7();
            int x$21 = this.makeCleaner$default$8();
            long x$22 = this.makeCleaner$default$9();
            Option<Object> x$23 = this.makeCleaner$default$10();
            Properties x$24 = this.makeCleaner$default$11();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$14, x$16, x$17, x$18, x$15, x$19, x$20, x$21, x$22, x$23, x$24));
            AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
            long startSize = log2.size();
            this.cleaner().startup();
            long firstDirty = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.localLogSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogSegment x$2) {
                    return x$2.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log2, startSize, appends);
            LogAppendInfo appendInfo = log2.appendAsLeader(largeMessageSet2, 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
            long largeMessageOffset = BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get());
            int x$25 = largeMessageKey + 1;
            int x$26 = 100;
            int x$27 = 3;
            AbstractLog x$28 = log2;
            CompressionType x$29 = this.codec();
            byte x$30 = this.writeDups$default$6();
            Seq<Tuple3<Object, String, Object>> dups = this.writeDups(x$26, x$27, x$28, x$29, x$25, x$30);
            Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
            this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
            this.cleaner().updateCheckpoints(this.logDir());
            Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
            Assert.assertFalse((boolean)checkpoints.contains((Object)this.topicPartitions()[0]));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleansCombinedCompactAndDeleteTopic() {
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps);
        if (tuple2 != null) {
            AbstractLog log2;
            AbstractLog abstractLog;
            AbstractLog log3 = abstractLog = (log2 = (AbstractLog)tuple2._1());
            log3.localLogSegments().foreach((Function1)new Serializable(this, retentionMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogCleanerParameterizedIntegrationTest $outer;
                private final Integer retentionMs$1;

                public final Path apply(LogSegment x$4) {
                    return x$4.lastModified_$eq(this.$outer.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(this.retentionMs$1)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.retentionMs$1 = retentionMs$1;
                }
            });
            long endOffset = log3.logEndOffset();
            log3.localLogSegments().foreach((Function1)new Serializable(this, retentionMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogCleanerParameterizedIntegrationTest $outer;
                private final Integer retentionMs$1;

                public final Path apply(LogSegment x$5) {
                    return x$5.lastModified_$eq(this.$outer.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(this.retentionMs$1)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.retentionMs$1 = retentionMs$1;
                }
            });
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, log3, endOffset){
                public static final long serialVersionUID = 0L;
                private final AbstractLog log$1;
                private final long endOffset$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.log$1.logStartOffset() == this.endOffset$1;
                }
                {
                    this.log$1 = log$1;
                    this.endOffset$1 = endOffset$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Timed out waiting for deletion of old segments";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertEquals((long)1L, (long)log3.numberOfSegments());
            this.cleaner().shutdown();
            Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps);
            if (tuple22 != null) {
                Tuple2 tuple23;
                AbstractLog log22 = (AbstractLog)tuple22._1();
                Seq messages = (Seq)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)log22, (Object)messages);
                AbstractLog log23 = (AbstractLog)tuple24._1();
                Seq messages2 = (Seq)tuple24._2();
                Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log23);
                Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)messages2), this.toMap(read));
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testCleanerWithMessageFormatV0() {
        CompressionType compressionType = this.codec();
        CompressionType compressionType2 = CompressionType.ZSTD;
        if (!(compressionType != null ? !compressionType.equals(compressionType2) : compressionType2 != null)) {
            return;
        }
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            CompressionType compressionType3 = this.codec();
            int n = CompressionType.NONE.equals(compressionType3) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
            int maxMessageSize = n;
            WrappedArray x$42 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            int x$43 = maxMessageSize;
            float x$44 = this.makeCleaner$default$2();
            int x$45 = this.makeCleaner$default$3();
            long x$46 = this.makeCleaner$default$4();
            long x$47 = this.makeCleaner$default$6();
            int x$48 = this.makeCleaner$default$7();
            int x$49 = this.makeCleaner$default$8();
            long x$50 = this.makeCleaner$default$9();
            Option<Object> x$51 = this.makeCleaner$default$10();
            Properties x$52 = this.makeCleaner$default$11();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$42, x$44, x$45, x$46, x$43, x$47, x$48, x$49, x$50, x$51, x$52));
            AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            int x$53 = maxMessageSize;
            Properties x$54 = this.logConfigProperties$default$1();
            float x$55 = this.logConfigProperties$default$3();
            long x$56 = this.logConfigProperties$default$4();
            int x$57 = this.logConfigProperties$default$5();
            int x$58 = this.logConfigProperties$default$6();
            long x$59 = this.logConfigProperties$default$7();
            Properties props = this.logConfigProperties(x$54, x$53, x$55, x$56, x$57, x$58, x$59);
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
            log2.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
            int x$60 = 100;
            int x$61 = 3;
            AbstractLog x$62 = log2;
            CompressionType x$63 = this.codec();
            byte x$64 = 0;
            int x$65 = this.writeDups$default$5();
            Seq<Tuple3<Object, String, Object>> appends = this.writeDups(x$60, x$61, x$62, x$63, x$65, x$64);
            long startSize = log2.size();
            this.cleaner().startup();
            long firstDirty = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.localLogSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogSegment x$8) {
                    return x$8.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log2, startSize, appends);
            int x$66 = 40;
            int x$67 = 3;
            AbstractLog x$68 = log2;
            CompressionType x$69 = this.codec();
            byte x$70 = 0;
            int x$71 = this.writeDups$default$5();
            Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(x$66, x$67, x$68, x$69, x$71, x$70);
            LogAppendInfo appendInfo = log2.appendAsLeader(largeMessageSet2, 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
            long largeMessageOffset = BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get());
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_11_0_IV0$.MODULE$.version());
            log2.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
            int x$72 = 30;
            int x$73 = 40;
            int x$74 = 3;
            AbstractLog x$75 = log2;
            CompressionType x$76 = this.codec();
            byte x$77 = 1;
            Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(x$73, x$74, x$75, x$76, x$72, x$77);
            int x$78 = 15;
            int x$79 = 5;
            int x$80 = 3;
            AbstractLog x$81 = log2;
            CompressionType x$82 = this.codec();
            byte x$83 = 2;
            Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(x$79, x$80, x$81, x$82, x$78, x$83);
            Seq appends2 = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV2, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleaningNestedMessagesWithMultipleVersions() {
        CompressionType compressionType = this.codec();
        CompressionType compressionType2 = CompressionType.ZSTD;
        if (!(compressionType != null ? !compressionType.equals(compressionType2) : compressionType2 != null)) {
            return;
        }
        int maxMessageSize = 192;
        WrappedArray x$84 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$85 = maxMessageSize;
        int x$86 = 256;
        float x$87 = this.makeCleaner$default$2();
        int x$88 = this.makeCleaner$default$3();
        long x$89 = this.makeCleaner$default$4();
        long x$90 = this.makeCleaner$default$6();
        int x$91 = this.makeCleaner$default$7();
        long x$92 = this.makeCleaner$default$9();
        Option<Object> x$93 = this.makeCleaner$default$10();
        Properties x$94 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$84, x$87, x$88, x$89, x$85, x$90, x$91, x$86, x$92, x$93, x$94));
        AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$95 = maxMessageSize;
        int x$96 = 256;
        Properties x$97 = this.logConfigProperties$default$1();
        float x$98 = this.logConfigProperties$default$3();
        long x$99 = this.logConfigProperties$default$4();
        int x$100 = this.logConfigProperties$default$5();
        long x$101 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$97, x$95, x$98, x$99, x$100, x$96, x$101);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log2.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$102 = 2;
        int x$103 = 3;
        AbstractLog x$104 = log2;
        CompressionType x$105 = this.codec();
        byte x$106 = 0;
        int x$107 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$102, x$103, x$104, x$105, x$107, x$106);
        int x$108 = 2;
        int x$109 = 3;
        int x$110 = 2;
        AbstractLog x$111 = log2;
        CompressionType x$112 = this.codec();
        byte x$113 = 0;
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$108, x$110, x$111, x$112, x$109, x$113), Seq$.MODULE$.canBuildFrom());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
        log2.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$114 = 4;
        int x$115 = 2;
        int x$116 = 2;
        AbstractLog x$117 = log2;
        CompressionType x$118 = this.codec();
        byte x$119 = 1;
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$115, x$116, x$117, x$118, x$114, x$119);
        int x$120 = 4;
        int x$121 = 2;
        int x$122 = 2;
        AbstractLog x$123 = log2;
        CompressionType x$124 = this.codec();
        byte x$125 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$121, x$122, x$123, x$124, x$120, x$125), Seq$.MODULE$.canBuildFrom());
        int x$126 = 6;
        int x$127 = 2;
        int x$128 = 2;
        AbstractLog x$129 = log2;
        CompressionType x$130 = this.codec();
        byte x$131 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$127, x$128, x$129, x$130, x$126, x$131), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log2.size();
        this.cleaner().startup();
        long firstDirty = log2.activeSegment().baseOffset();
        Assert.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.localLogSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$9) {
                return x$9.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    @Test
    public void cleanerLogDeleteMaxSegmentsPerRunConfigUpdateTest() {
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$2(0, logProps, retentionMs);
        if (tuple2 != null) {
            AbstractLog log2 = (AbstractLog)tuple2._1();
            AbstractLog abstractLog = log2;
            AbstractLog log3 = abstractLog;
            Assert.assertFalse((log3.logStartOffset() == log3.logEndOffset() ? 1 : 0) != 0);
            long endOffset = log3.logEndOffset();
            this.reconfigureMaxSegmentDeletedPerRun$1(log3.numberOfSegments());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, log3, endOffset){
                public static final long serialVersionUID = 0L;
                private final AbstractLog log$2;
                private final long endOffset$2;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.log$2.logStartOffset() == this.endOffset$2;
                }
                {
                    this.log$2 = log$2;
                    this.endOffset$2 = endOffset$2;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Timed out waiting for deletion of old segments";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertEquals((long)1L, (long)log3.numberOfSegments());
            this.cleaner().shutdown();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void cleanerConfigUpdateTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            WrappedArray x$153 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            long x$154 = 1L;
            int x$155 = maxMessageSize;
            Some x$156 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            float x$157 = this.makeCleaner$default$2();
            int x$158 = this.makeCleaner$default$3();
            long x$159 = this.makeCleaner$default$6();
            int x$160 = this.makeCleaner$default$7();
            int x$161 = this.makeCleaner$default$8();
            long x$162 = this.makeCleaner$default$9();
            Properties x$163 = this.makeCleaner$default$11();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$153, x$157, x$158, x$154, x$155, x$159, x$160, x$161, x$162, (Option<Object>)x$156, x$163));
            AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            this.writeDups(100, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
            long startSize = log2.size();
            this.cleaner().startup();
            Assert.assertEquals((long)1L, (long)this.cleaner().cleanerCount());
            long firstDirty = log2.activeSegment().baseOffset();
            TopicPartition topicPartition = new TopicPartition("log", 0);
            this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
            Assert.assertTrue((String)"Should not have cleaned", (boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty());
            KafkaConfig oldConfig = this.kafkaConfigWithCleanerConfig(this.cleaner().currentConfig());
            KafkaConfig newConfig = this.kafkaConfigWithCleanerConfig(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize(), this.cleaner().currentConfig().dedupeBufferLoadFactor(), 100000, this.cleaner().currentConfig().maxMessageSize(), this.cleaner().currentConfig().maxIoBytesPerSecond(), this.cleaner().currentConfig().backOffMs(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9(), CleanerConfig$.MODULE$.apply$default$10()));
            this.cleaner().reconfigure(oldConfig, newConfig);
            Assert.assertEquals((long)2L, (long)this.cleaner().cleanerCount());
            this.checkLastCleaned("log", 0, firstDirty);
            int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.localLogSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogSegment x$13) {
                    return x$13.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
            return;
        }
        throw new MatchError(tuple2);
    }

    private KafkaConfig kafkaConfigWithCleanerConfig(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.LogCleanerThreadsProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.numThreads())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.dedupeBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.dedupeBufferLoadFactor())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoBufferSizeProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.ioBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.maxMessageSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.backOffMs())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.maxIoBytesPerSecond())).toString());
        props.put(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.logDeletionMaxSegmentsPerRun())).toString());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$164 = topicPartition;
        long x$165 = firstDirty;
        long x$166 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$164, x$165, x$166);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstDirty), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstDirty ? 1 : 0) != 0);
    }

    private void checkLogAfterAppendingDups(AbstractLog log2, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log2);
        Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read));
        Assert.assertTrue((startSize > log2.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((TraversableOnce)messages.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<String, Object>> apply(Tuple3<Object, String, Object> x0$1) {
                Tuple3<Object, String, Object> tuple3 = x0$1;
                if (tuple3 != null) {
                    int key = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    String value = (String)tuple3._2();
                    long offset = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
                    return tuple2;
                }
                throw new MatchError(tuple3);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(AbstractLog log2) {
        return (Iterable)log2.localLogSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple3<Object, String, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Object, String, Object> apply(Record deepLogEntry) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, AbstractLog log2, CompressionType codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, startKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerParameterizedIntegrationTest $outer;
            private final int numKeys$1;
            private final int startKey$1;

            public final IndexedSeq<Tuple2<Object, String>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startKey$1), this.startKey$1 + this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final Tuple2<Object, String> apply(int key) {
                        String payload = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerParameterizedIntegrationTest$$anonfun$$$outer().counter())).toString();
                        this.$outer.kafka$log$LogCleanerParameterizedIntegrationTest$$anonfun$$$outer().incCounter();
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerParameterizedIntegrationTest kafka$log$LogCleanerParameterizedIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.startKey$1 = startKey$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records2 = (IndexedSeq)kvs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleRecord apply(Tuple2<Object, String> x0$2) {
                Tuple2<Object, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    String payload = (String)tuple2._2();
                    SimpleRecord simpleRecord = new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), payload.toString().getBytes());
                    return simpleRecord;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        LogAppendInfo appendInfo = log2.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (CompressionType)codec, (SimpleRecord[])((SimpleRecord[])records2.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get()))).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((TraversableLike)kvs.zip((GenIterable)offsets, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, String, Object> apply(Tuple2<Tuple2<Object, String>, Object> x0$3) {
                Tuple2<Tuple2<Object, String>, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple2 kv = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
                    return tuple3;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1) {
        WrappedArray x$31 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions()).take(1));
        Properties x$32 = logProps$1;
        long x$33 = 100L;
        float x$34 = this.makeCleaner$default$2();
        int x$35 = this.makeCleaner$default$3();
        int x$36 = this.makeCleaner$default$5();
        long x$37 = this.makeCleaner$default$6();
        int x$38 = this.makeCleaner$default$7();
        int x$39 = this.makeCleaner$default$8();
        long x$40 = this.makeCleaner$default$9();
        Option<Object> x$41 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$31, x$34, x$35, x$33, x$36, x$37, x$38, x$39, x$40, x$41, x$32));
        AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log2.size();
        log2.updateHighWatermark(log2.logEndOffset());
        long firstDirty = log2.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.localLogSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$3) {
                return x$3.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        return new Tuple2((Object)log2, messages);
    }

    private final void reconfigureMaxSegmentDeletedPerRun$1(int logDeletionMaxSegmentsPerRun) {
        KafkaConfig oldConfig = this.kafkaConfigWithCleanerConfig(this.cleaner().currentConfig());
        int x$132 = this.cleaner().currentConfig().numThreads();
        long x$133 = this.cleaner().currentConfig().dedupeBufferSize();
        double x$134 = this.cleaner().currentConfig().dedupeBufferLoadFactor();
        int x$135 = this.cleaner().currentConfig().ioBufferSize();
        int x$136 = this.cleaner().currentConfig().maxMessageSize();
        double x$137 = this.cleaner().currentConfig().maxIoBytesPerSecond();
        long x$138 = this.cleaner().currentConfig().backOffMs();
        int x$139 = logDeletionMaxSegmentsPerRun;
        boolean x$140 = CleanerConfig$.MODULE$.apply$default$8();
        String x$141 = CleanerConfig$.MODULE$.apply$default$10();
        KafkaConfig newConfig = this.kafkaConfigWithCleanerConfig(new CleanerConfig(x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$140, x$139, x$141));
        this.cleaner().reconfigure(oldConfig, newConfig);
    }

    private final Tuple2 runCleanerAndCheckCompacted$2(int logDeletionMaxSegmentsPerRun, Properties logProps$2, Integer retentionMs$2) {
        WrappedArray x$142 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions()).take(1));
        Properties x$143 = logProps$2;
        long x$144 = 100L;
        float x$145 = this.makeCleaner$default$2();
        int x$146 = this.makeCleaner$default$3();
        int x$147 = this.makeCleaner$default$5();
        long x$148 = this.makeCleaner$default$6();
        int x$149 = this.makeCleaner$default$7();
        int x$150 = this.makeCleaner$default$8();
        long x$151 = this.makeCleaner$default$9();
        Option<Object> x$152 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$142, x$145, x$146, x$144, x$147, x$148, x$149, x$150, x$151, x$152, x$143));
        this.reconfigureMaxSegmentDeletedPerRun$1(logDeletionMaxSegmentsPerRun);
        AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(100, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log2.size();
        log2.updateHighWatermark(log2.logEndOffset());
        log2.localLogSegments().foreach((Function1)new Serializable(this, retentionMs$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerParameterizedIntegrationTest $outer;
            private final Integer retentionMs$2;

            public final Path apply(LogSegment x$10) {
                return x$10.lastModified_$eq(this.$outer.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(this.retentionMs$2)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.retentionMs$2 = retentionMs$2;
            }
        });
        long firstDirty = log2.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.localLogSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$11) {
                return x$11.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        return new Tuple2((Object)log2, messages);
    }

    public LogCleanerParameterizedIntegrationTest(String compressionCodec) {
        this.codec = CompressionType.forName((String)compressionCodec);
        this.time = new MockTime();
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

