/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.CleanerConfig;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogManagerTest$;
import kafka.log.LogMetricNames$;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.log.TimeIndex;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005!A/[7f+\u00051\u0002CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u0015)H/\u001b7t\u0013\tY\u0002D\u0001\u0005N_\u000e\\G+[7f\u0011\u0019i\u0002\u0001)A\u0005-\u0005)A/[7fA!9q\u0004\u0001b\u0001\n\u0003\u0001\u0013aD7bqJ{G\u000e\\%oi\u0016\u0014h/\u00197\u0016\u0003\u0005\u0002\"!\u0003\u0012\n\u0005\rR!aA%oi\"1Q\u0005\u0001Q\u0001\n\u0005\n\u0001#\\1y%>dG.\u00138uKJ4\u0018\r\u001c\u0011\t\u000f\u001d\u0002!\u0019!C\u0001A\u0005YQ.\u0019=M_\u001e\fu-Z't\u0011\u0019I\u0003\u0001)A\u0005C\u0005aQ.\u0019=M_\u001e\fu-Z'tA!91\u0006\u0001b\u0001\n\u0003a\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0002e\u0005!!.\u0019<b\u0013\t!tF\u0001\u0006Qe>\u0004XM\u001d;jKNDaA\u000e\u0001!\u0002\u0013i\u0013!\u00037pOB\u0013x\u000e]:!\u0011\u001dA\u0004A1A\u0005\u0002e\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0003i\u0002\"AE\u001e\n\u0005q\u0012!!\u0003'pO\u000e{gNZ5h\u0011\u0019q\u0004\u0001)A\u0005u\u0005QAn\\4D_:4\u0017n\u001a\u0011\t\u000f\u0001\u0003\u0001\u0019!C\u0001\u0003\u00061An\\4ESJ,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bF\n!![8\n\u0005\u001d#%\u0001\u0002$jY\u0016Dq!\u0013\u0001A\u0002\u0013\u0005!*\u0001\u0006m_\u001e$\u0015N]0%KF$\"a\u0013(\u0011\u0005%a\u0015BA'\u000b\u0005\u0011)f.\u001b;\t\u000f=C\u0015\u0011!a\u0001\u0005\u0006\u0019\u0001\u0010J\u0019\t\rE\u0003\u0001\u0015)\u0003C\u0003\u001dawn\u001a#je\u0002Bqa\u0015\u0001A\u0002\u0013\u0005A+\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012!\u0016\t\u0003%YK!a\u0016\u0002\u0003\u00151{w-T1oC\u001e,'\u000fC\u0004Z\u0001\u0001\u0007I\u0011\u0001.\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR\u00111j\u0017\u0005\b\u001fb\u000b\t\u00111\u0001V\u0011\u0019i\u0006\u0001)Q\u0005+\u0006YAn\\4NC:\fw-\u001a:!\u0011\u001dy\u0006A1A\u0005\u0002\u0001\fAA\\1nKV\t\u0011\r\u0005\u0002cK6\t1M\u0003\u0002ec\u0005!A.\u00198h\u0013\t17M\u0001\u0004TiJLgn\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B1\u0002\u000b9\fW.\u001a\u0011\t\u000f)\u0004!\u0019!C\u0001W\u0006Ib/\u001a:z\u0019\u0006\u0014x-\u001a'pO\u001acWo\u001d5J]R,'O^1m+\u0005a\u0007CA\u0005n\u0013\tq'B\u0001\u0003M_:<\u0007B\u00029\u0001A\u0003%A.\u0001\u000ewKJLH*\u0019:hK2{wM\u00127vg\"Le\u000e^3sm\u0006d\u0007\u0005C\u0003s\u0001\u0011\u00051/A\u0003tKR,\u0006\u000fF\u0001LQ\t\tX\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006)!.\u001e8ji*\t!0A\u0002pe\u001eL!\u0001`<\u0003\r\t+gm\u001c:f\u0011\u0015q\b\u0001\"\u0001t\u0003!!X-\u0019:E_^t\u0007fA?\u0002\u0002A\u0019a/a\u0001\n\u0007\u0005\u0015qOA\u0003BMR,'\u000f\u0003\u0004\u0002\n\u0001!\ta]\u0001\u000ei\u0016\u001cHo\u0011:fCR,Gj\\4)\t\u0005\u001d\u0011Q\u0002\t\u0004m\u0006=\u0011bAA\to\n!A+Z:u\u0011\u0019\t)\u0002\u0001C\u0001g\u0006qB/Z:u\u0007J,\u0017\r^3M_\u001e<\u0016\u000e\u001e5J]Z\fG.\u001b3M_\u001e$\u0015N\u001d\u0015\u0005\u0003'\ti\u0001\u0003\u0004\u0002\u001c\u0001!\ta]\u0001 i\u0016\u001cHo\u0011:fCR,Gj\\4XSRDGj\\4ESJ4\u0015\r\u001c7cC\u000e\\\u0007\u0006BA\r\u0003\u001bAa!!\t\u0001\t\u0003\u0019\u0018!\u0006;fgR<U\r\u001e(p]\u0016C\u0018n\u001d;f]Rdun\u001a\u0015\u0005\u0003?\ti\u0001\u0003\u0004\u0002(\u0001!\ta]\u00010i\u0016\u001cH\u000fT8h\t\u0016dW\r^5p]6\u000b\u0007pU3h[\u0016tGo\u001d)feJ+h.\u0012=qSJ,GmU3h[\u0016tGo\u001d\u0015\u0005\u0003K\ti\u0001\u0003\u0004\u0002.\u0001!\ta]\u0001\u001bi\u0016\u001cHo\u00117fC:,\b/\u0012=qSJ,GmU3h[\u0016tGo\u001d\u0015\u0005\u0003W\ti\u0001\u0003\u0004\u00024\u0001!\ta]\u0001\"i\u0016\u001cHo\u00117fC:,\boU3h[\u0016tGo\u001d+p\u001b\u0006Lg\u000e^1j]NK'0\u001a\u0015\u0005\u0003c\ti\u0001\u0003\u0004\u0002:\u0001!\ta]\u0001+i\u0016\u001cH\u000fR8fg:$8\t\\3b]2{wm],ji\"\u001cu.\u001c9bGR$U\r\\3uKB{G.[2zQ\u0011\t9$!\u0004\t\r\u0005}\u0002\u0001\"\u0001t\u0003\u0011\"Xm\u001d;E_\u0016\u001ch\u000e^\"mK\u0006tGj\\4t/&$\bnQ8na\u0006\u001cG\u000fU8mS\u000eL\b\u0006BA\u001f\u0003\u001bAq!!\u0012\u0001\t\u0013\t9%A\nuKN$Hi\\3t]R\u001cE.Z1o\u0019><7\u000fF\u0002L\u0003\u0013B\u0001\"a\u0013\u0002D\u0001\u0007\u0011QJ\u0001\u0007a>d\u0017nY=\u0011\t\u0005=\u0013Q\u000b\b\u0004\u0013\u0005E\u0013bAA*\u0015\u00051\u0001K]3eK\u001aL1AZA,\u0015\r\t\u0019F\u0003\u0005\u0007\u00037\u0002A\u0011A:\u0002%Q,7\u000f\u001e+j[\u0016\u0014\u0015m]3e\r2,8\u000f\u001b\u0015\u0005\u00033\ni\u0001\u0003\u0004\u0002b\u0001!\ta]\u0001\u001ai\u0016\u001cH\u000fT3bgRdu.\u00193fI\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0003\u0002`\u00055\u0001BBA4\u0001\u0011\u00051/A\u0012uKN$Hk^8M_\u001el\u0015M\\1hKJ\u001cXk]5oON\u000bW.\u001a#je\u001a\u000b\u0017\u000e\\:)\t\u0005\u0015\u0014Q\u0002\u0005\u0007\u0003[\u0002A\u0011A:\u00029Q,7\u000f^\"iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef\u0004v.\u001b8ug\"\"\u00111NA\u0007\u0011\u0019\t\u0019\b\u0001C\u0001g\u0006iC/Z:u%\u0016\u001cwN^3ss\u0012K'/Z2u_JLX*\u00199qS:<w+\u001b;i)J\f\u0017\u000e\\5oONc\u0017m\u001d5)\t\u0005E\u0014Q\u0002\u0005\u0007\u0003s\u0002A\u0011A:\u0002cQ,7\u000f\u001e*fG>4XM]=ESJ,7\r^8ss6\u000b\u0007\u000f]5oO^KG\u000f\u001b*fY\u0006$\u0018N^3ESJ,7\r^8ss\"\"\u0011qOA\u0007\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003\u000b\u0001D^3sS\u001aL8\t[3dWB|\u0017N\u001c;SK\u000e|g/\u001a:z)\u001dY\u00151QAY\u0003gC\u0001\"!\"\u0002~\u0001\u0007\u0011qQ\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB1\u0011\u0011RAM\u0003?sA!a#\u0002\u0016:!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u0012\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0007\u0005]%\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0015Q\u0014\u0002\u0004'\u0016\f(bAAL\u0015A!\u0011\u0011UAW\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016AB2p[6|gNC\u0002\u0006\u0003SS1!a+z\u0003\u0019\t\u0007/Y2iK&!\u0011qVAR\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DaaUA?\u0001\u0004)\u0006B\u0002!\u0002~\u0001\u0007!\tC\u0004\u00028\u0002!I!!/\u0002!\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014H#B+\u0002<\u0006\u0005\u0007BCA_\u0003k\u0003\n\u00111\u0001\u0002@\u00069An\\4ESJ\u001c\b#BAE\u00033\u0013\u0005BCAb\u0003k\u0003\n\u00111\u0001\u0002F\u0006\tB/[3s\u0019><7i\\7q_:,g\u000e^:\u0011\u0007I\t9-C\u0002\u0002J\n\u0011\u0011\u0003V5fe2{wmQ8na>tWM\u001c;t\u0011\u0019\ti\r\u0001C\u0001g\u0006\u0011C/Z:u\r&dWMU3gKJ,gnY3t\u0003\u001a$XM]!ts:\u001cG)\u001a7fi\u0016DC!a3\u0002\u000e!1\u00111\u001b\u0001\u0005\u0002M\f!\u0005^3ti\u000e\u0013X-\u0019;f\u0003:$G)\u001a7fi\u0016|e/\u001a:ms2{gn\u001a+pa&\u001c\u0007\u0006BAi\u0003\u001bAa!!7\u0001\t\u0003\u0019\u0018!\t;fgR\u001c\u0005.Z2la>Lg\u000e\u001e$pe>sG._!gM\u0016\u001cG/\u001a3M_\u001e\u001c\b\u0006BAl\u0003\u001bAq!a8\u0001\t\u0013\t\t/A\u0004sK\u0006$Gj\\4\u0015\u0011\u0005\r\u0018q^A|\u0003w\u0004B!!:\u0002l6\u0011\u0011q\u001d\u0006\u0004\u0003S$\u0011AB:feZ,'/\u0003\u0003\u0002n\u0006\u001d(!\u0004$fi\u000eDG)\u0019;b\u0013:4w\u000eC\u0004\u0004\u0003;\u0004\r!!=\u0011\u0007I\t\u00190C\u0002\u0002v\n\u00111\"\u00112tiJ\f7\r\u001e'pO\"9\u0011\u0011`Ao\u0001\u0004a\u0017AB8gMN,G\u000fC\u0005\u0002~\u0006u\u0007\u0013!a\u0001C\u0005IQ.\u0019=MK:<G\u000f\u001b\u0005\u0007\u0005\u0003\u0001A\u0011A:\u0002KQ,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKV\u0003H-\u0019;fg2{wmQ8oM&<\u0007\u0006BA\u0000\u0003\u001bAaAa\u0002\u0001\t\u0003\u0019\u0018!\b;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4f\u000f\u0016$8o\u00117fC:,G-\u00169)\t\t\u0015\u0011Q\u0002\u0005\u0007\u0005\u001b\u0001A\u0011A:\u0002QQ,7\u000f\u001e\"s_.,'oQ8oM&<7\t[1oO\u0016$U\r\\5wKJ,G\rV8BY2dunZ:)\t\t-\u0011Q\u0002\u0005\u0007\u0005'\u0001A\u0011A:\u0002YQ,7\u000f^\"p]\u001aLwm\u00115b]\u001e,7oV5uQ:{Gj\\4HKR$\u0018N\\4J]&$\u0018.\u00197ju\u0016$\u0007\u0006\u0002B\t\u0003\u001bAaA!\u0007\u0001\t\u0003\u0019\u0018A\n;fgR$U\r\\3uK\u0006sG\rV5feN#\u0018\r^3GYV\u001c\bnQ8oGV\u0014(/\u001a8ds\"\"!qCA\u0007\u0011\u0019\u0011y\u0002\u0001C\u0001g\u0006\u0001D/Z:u\u001b\u0016$(/[2t\u000bbL7\u000f^,iK:dunZ%t%\u0016\u001c'/Z1uK\u0012\u0014UMZ8sK\u0012+G.\u001a;j_:DCA!\b\u0002\u000e!1!Q\u0005\u0001\u0005\u0002M\f\u0011\u0007^3ti6+GO]5dg\u0006\u0013XMU3n_Z,Gm\u00165f]6{g/\u001b8h\u0007V\u0014(/\u001a8u)>4U\u000f^;sK2{w\r\u000b\u0003\u0003$\u00055\u0001\"\u0003B\u0016\u0001E\u0005I\u0011\u0002B\u0017\u0003i\u0019'/Z1uK2{w-T1oC\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yC\u000b\u0003\u0002@\nE2F\u0001B\u001a!\u0011\u0011)Da\u0010\u000e\u0005\t]\"\u0002\u0002B\u001d\u0005w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tu\"\"\u0001\u0006b]:|G/\u0019;j_:LAA!\u0011\u00038\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t\u0015\u0003!%A\u0005\n\t\u001d\u0013AG2sK\u0006$X\rT8h\u001b\u0006t\u0017mZ3sI\u0011,g-Y;mi\u0012\u0012TC\u0001B%U\u0011\t)M!\r\t\u0013\t5\u0003!%A\u0005\n\t=\u0013!\u0005:fC\u0012dun\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u000b\u0016\u0004C\tE\u0002")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2()));
        this.logManager().startup();
    }

    @After
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        this.logManager().liveLogDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File x$1) {
                Utils.delete((File)x$1);
            }
        });
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$18 = new TopicPartition(this.name(), 0);
        Serializable x$19 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$20 = qual$1.getOrCreateLog$default$3();
        boolean x$21 = qual$1.getOrCreateLog$default$4();
        AbstractLog log2 = qual$1.getOrCreateLog(x$18, (Function0)x$19, x$20, x$21);
        Assert.assertEquals((long)1L, (long)this.logManager().liveLogDirs().size());
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        Seq dirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir(), new File("\u0000")}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2()));
        this.logManager().startup();
        LogManager qual$2 = this.logManager();
        TopicPartition x$22 = new TopicPartition(this.name(), 0);
        Serializable x$23 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$24 = true;
        boolean x$25 = qual$2.getOrCreateLog$default$4();
        AbstractLog log2 = qual$2.getOrCreateLog(x$22, (Function0)x$23, x$24, x$25);
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$1) {
                return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final File apply(String x$2) {
                return this.$outer.logDir().toPath().resolve(x$2).toFile();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2())));
        Set brokenDirs = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer((Answer)new Answer<Try<File>>(this, dirs, brokenDirs){
            private final IndexedSeq dirs$1;
            private final Set brokenDirs$1;

            public Try<File> answer(InvocationOnMock invocation) {
                Failure failure;
                File logDir = (File)invocation.getArgument(0);
                if (this.brokenDirs$1.contains((Object)logDir) || this.brokenDirs$1.size() < this.dirs$1.length() / 2) {
                    this.brokenDirs$1.add((Object)logDir);
                    failure = new Failure(new Throwable("broken dir"));
                } else {
                    failure = (Try)invocation.callRealMethod();
                }
                return failure;
            }
            {
                this.dirs$1 = dirs$1;
                this.brokenDirs$1 = brokenDirs$1;
            }
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup();
        LogManager qual$3 = this.logManager();
        TopicPartition x$26 = new TopicPartition(this.name(), 0);
        Serializable x$27 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$28 = true;
        boolean x$29 = qual$3.getOrCreateLog$default$4();
        qual$3.getOrCreateLog(x$26, (Function0)x$27, x$28, x$29);
        Assert.assertEquals((long)(dirs.length() / 2), (long)brokenDirs.size());
        Serializable containsLogFile = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(File dir) {
                return new File(dir, new StringBuilder().append((Object)this.$outer.name()).append((Object)"-0").toString()).exists();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        Assert.assertEquals((String)"More than one log file created", (long)1L, (long)dirs.count((Function1)containsLogFile));
        Assert.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$4 = this.logManager();
        TopicPartition x$30 = new TopicPartition(this.name(), 0);
        boolean x$31 = qual$4.getLog$default$2();
        Option log2 = qual$4.getLog(x$30, x$31);
        Assert.assertEquals((String)"No log should be found.", (Object)None$.MODULE$, (Object)log2);
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((!logFile.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testLogDeletionMaxSegmentsPerRunExpiredSegments() {
        LogManager qual$5 = this.logManager();
        TopicPartition x$32 = new TopicPartition(this.name(), 0);
        Serializable x$33 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$34 = qual$5.getOrCreateLog$default$3();
        boolean x$35 = qual$5.getOrCreateLog$default$4();
        AbstractLog log2 = qual$5.getOrCreateLog(x$32, (Function0)x$33, x$34, x$35);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)new Serializable(this, log2, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;
            private final AbstractLog log$1;
            private final LongRef offset$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                byte[] x$36 = "test".getBytes();
                long x$37 = this.$outer.time().milliseconds() - (long)this.$outer.maxLogAgeMs() - 1L;
                byte[] x$38 = TestUtils$.MODULE$.singletonRecords$default$2();
                CompressionType x$39 = TestUtils$.MODULE$.singletonRecords$default$3();
                byte x$40 = TestUtils$.MODULE$.singletonRecords$default$5();
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords(x$36, x$38, x$39, x$37, x$40);
                LogAppendInfo info = this.log$1.appendAsLeader(set, 0, this.log$1.appendAsLeader$default$3(), this.log$1.appendAsLeader$default$4());
                this.offset$1.elem = info.lastOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$1 = log$1;
                this.offset$1 = offset$1;
            }
        });
        Assert.assertTrue((String)"There should be more than one segment now.", (log2.numberOfSegments() > 1 ? 1 : 0) != 0);
        log2.updateHighWatermark(log2.logEndOffset());
        int numSegments = log2.numberOfSegments();
        this.reconfigureMaxSegmentDeletedPerRun$1(0);
        log2.localLogSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(LogSegment x$3) {
                return x$3.log().file().setLastModified(this.$outer.time().milliseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        this.time().sleep(this.logManager().retentionCheckMs() + 1L);
        Assert.assertEquals((String)"No segment should be deleted.", (long)numSegments, (long)log2.numberOfSegments());
        this.reconfigureMaxSegmentDeletedPerRun$1(log2.numberOfSegments());
        this.time().sleep(this.logManager().retentionCheckMs() + 1L);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (long)1L, (long)log2.numberOfSegments());
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$6 = this.logManager();
        TopicPartition x$41 = new TopicPartition(this.name(), 0);
        Serializable x$42 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$43 = qual$6.getOrCreateLog$default$3();
        boolean x$44 = qual$6.getOrCreateLog$default$4();
        AbstractLog log2 = qual$6.getOrCreateLog(x$41, (Function0)x$42, x$43, x$44);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)new Serializable(this, log2, offset){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$2;
            private final LongRef offset$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$2.appendAsLeader(set, 0, this.log$2.appendAsLeader$default$3(), this.log$2.appendAsLeader$default$4());
                this.offset$2.elem = info.lastOffset();
            }
            {
                this.log$2 = log$2;
                this.offset$2 = offset$2;
            }
        });
        Assert.assertTrue((String)"There should be more than one segment now.", (log2.numberOfSegments() > 1 ? 1 : 0) != 0);
        log2.updateHighWatermark(log2.logEndOffset());
        log2.localLogSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(LogSegment x$4) {
                return x$4.log().file().setLastModified(this.$outer.time().milliseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (long)1L, (long)log2.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log2.config().fileDeleteDelayMs()) + 1L);
        log2.localLogSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TimeIndex apply(LogSegment s) {
                s.lazyOffsetIndex().get();
                return (TimeIndex)s.lazyTimeIndex().get();
            }
        });
        Assert.assertEquals((String)"Files should have been deleted", (long)(log2.numberOfSegments() * 4 + 1), (long)log2.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)this.readLog(log2, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes());
        try {
            this.readLog(log2, 0L, this.readLog$default$3());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(10 * setSize));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.long2Long(50L * (long)setSize + 10L));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2()));
        this.logManager().startup();
        LogManager qual$7 = this.logManager();
        TopicPartition x$45 = new TopicPartition(this.name(), 0);
        Serializable x$46 = new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final LogConfig config$1;

            public final LogConfig apply() {
                return this.config$1;
            }
            {
                this.config$1 = config$1;
            }
        };
        boolean x$47 = qual$7.getOrCreateLog$default$3();
        boolean x$48 = qual$7.getOrCreateLog$default$4();
        AbstractLog log2 = qual$7.getOrCreateLog(x$45, (Function0)x$46, x$47, x$48);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log2, offset){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$3;
            private final LongRef offset$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$3.appendAsLeader(set, 0, this.log$3.appendAsLeader$default$3(), this.log$3.appendAsLeader$default$4());
                this.offset$3.elem = BoxesRunTime.unboxToLong((Object)info.firstOffset().get());
            }
            {
                this.log$3 = log$3;
                this.offset$3 = offset$3;
            }
        });
        log2.updateHighWatermark(log2.logEndOffset());
        Assert.assertEquals((String)"Check we have the expected number of segments.", (long)(numMessages * setSize / Predef$.MODULE$.Integer2int(config.segmentSize())), (long)log2.numberOfSegments());
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertEquals((String)"Now there should be exactly 6 segments", (long)6L, (long)log2.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log2.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log2.numberOfSegments() * 4 + 1), (long)log2.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)this.readLog(log2, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes());
        try {
            this.readLog(log2, 0L, this.readLog$default$3());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        LogManager qual$8 = this.logManager();
        TopicPartition x$49 = new TopicPartition(this.name(), 0);
        Serializable x$50 = new Serializable(this, logProps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;
            private final Properties logProps$1;

            public final LogConfig apply() {
                return LogConfig$.MODULE$.fromProps(this.$outer.logConfig().originals(), this.logProps$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logProps$1 = logProps$1;
            }
        };
        boolean x$51 = qual$8.getOrCreateLog$default$3();
        boolean x$52 = qual$8.getOrCreateLog$default$4();
        AbstractLog log2 = qual$8.getOrCreateLog(x$49, (Function0)x$50, x$51, x$52);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)new Serializable(this, log2, offset){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$4;
            private final LongRef offset$4;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$4.appendAsLeader(set, 0, this.log$4.appendAsLeader$default$3(), this.log$4.appendAsLeader$default$4());
                this.offset$4.elem = info.lastOffset();
            }
            {
                this.log$4 = log$4;
                this.offset$4 = offset$4;
            }
        });
        int numSegments = log2.numberOfSegments();
        Assert.assertTrue((String)"There should be more than one segment now.", (log2.numberOfSegments() > 1 ? 1 : 0) != 0);
        log2.localLogSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(LogSegment x$5) {
                return x$5.log().file().setLastModified(this.$outer.time().milliseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"number of segments shouldn't have changed", (long)numSegments, (long)log2.numberOfSegments());
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2()));
        this.logManager().startup();
        LogManager qual$9 = this.logManager();
        TopicPartition x$53 = new TopicPartition(this.name(), 0);
        Serializable x$54 = new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final LogConfig config$2;

            public final LogConfig apply() {
                return this.config$2;
            }
            {
                this.config$2 = config$2;
            }
        };
        boolean x$55 = qual$9.getOrCreateLog$default$3();
        boolean x$56 = qual$9.getOrCreateLog$default$4();
        AbstractLog log2 = qual$9.getOrCreateLog(x$53, (Function0)x$54, x$55, x$56);
        long lastFlush = log2.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$5;

            public final LogAppendInfo apply(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                return this.log$5.appendAsLeader(set, 0, this.log$5.appendAsLeader$default$3(), this.log$5.appendAsLeader$default$4());
            }
            {
                this.log$5 = log$5;
            }
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Time based flush should have been triggered", (lastFlush != log2.lastFlushTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLeastLoadedAssignment() {
        Seq dirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir()}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                LogManager qual$10 = this.$outer.logManager();
                TopicPartition x$57 = new TopicPartition("test", partition);
                Serializable x$58 = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testLeastLoadedAssignment$1 $outer;

                    public final LogConfig apply() {
                        return this.$outer.kafka$log$LogManagerTest$$anonfun$$$outer().logConfig();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                boolean x$59 = qual$10.getOrCreateLog$default$3();
                boolean x$60 = qual$10.getOrCreateLog$default$4();
                qual$10.getOrCreateLog(x$57, (Function0)x$58, x$59, x$60);
                Assert.assertEquals((String)"We should have created the right number of logs", (long)(partition + 1), (long)this.$outer.logManager().allLogs().size());
                Iterable counts = (Iterable)this.$outer.logManager().allLogs().groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AbstractLog x$6) {
                        return x$6.dir().getParent();
                    }
                }).values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Iterable<AbstractLog> x$7) {
                        return x$7.size();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"Load should balance evenly", (BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0);
            }

            public /* synthetic */ LogManagerTest kafka$log$LogManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        try {
            this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2());
            Assert.fail((String)"Should not be able to create a second log manager instance with the same data directory");
        }
        catch (KafkaException kafkaException) {}
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1), new TopicPartition("test-b", 1)}))), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File(new StringBuilder().append((Object)TestUtils$.MODULE$.tempDir().getAbsolutePath()).append((Object)File.separator).toString())}))), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4(), TestUtils$.MODULE$.createLogManager$default$5()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File("data", this.logDir().getName()).getAbsoluteFile()}))), this.createLogManager$default$2()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions2, LogManager logManager, File logDir) {
        Seq logs = (Seq)topicPartitions2.map((Function1)new Serializable(this, logManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;
            private final LogManager logManager$1;

            public final AbstractLog apply(TopicPartition x$8) {
                return this.logManager$1.getOrCreateLog(x$8, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final LogConfig apply() {
                        return this.$outer.kafka$log$LogManagerTest$$anonfun$$$outer().logConfig();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.logManager$1.getOrCreateLog$default$3(), this.logManager$1.getOrCreateLog$default$4());
            }

            public /* synthetic */ LogManagerTest kafka$log$LogManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logManager$1 = logManager$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AbstractLog log2) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, log2){
                    public static final long serialVersionUID = 0L;
                    private final AbstractLog log$6;

                    public final LogAppendInfo apply(int _) {
                        return this.log$6.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.log$6.appendAsLeader$default$3(), this.log$6.appendAsLeader$default$4());
                    }
                    {
                        this.log$6 = log$6;
                    }
                });
                log2.flush();
            }
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)topicPartitions2.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, checkpoints){
            public static final long serialVersionUID = 0L;
            private final Map checkpoints$1;

            public final void apply(Tuple2<TopicPartition, AbstractLog> x0$1) {
                Tuple2<TopicPartition, AbstractLog> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    AbstractLog log2 = (AbstractLog)tuple2._2();
                    Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)this.checkpoints$1.apply((Object)tp)), (long)log2.recoveryPoint());
                    Option firstLocalSegmentNextOffset = log2.localLogSegments().headOption().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(LogSegment x$9) {
                            return x$9.readNextOffset();
                        }
                    });
                    Assert.assertEquals((Object)firstLocalSegmentNextOffset, (Object)log2.oldestProducerSnapshotOffset());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.checkpoints$1 = checkpoints$1;
            }
        });
    }

    private LogManager createLogManager(Seq<File> logDirs, TierLogComponents tierLogComponents) {
        LogConfig x$61 = this.logConfig();
        Seq<File> x$62 = logDirs;
        MockTime x$63 = this.time();
        TierLogComponents x$64 = tierLogComponents;
        CleanerConfig x$65 = TestUtils$.MODULE$.createLogManager$default$3();
        return TestUtils$.MODULE$.createLogManager(x$62, x$61, x$65, x$63, x$64);
    }

    private Seq<File> createLogManager$default$1() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}));
    }

    private TierLogComponents createLogManager$default$2() {
        return TierLogComponents$.MODULE$.EMPTY();
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$11 = this.logManager();
        TopicPartition x$66 = new TopicPartition(this.name(), 0);
        Serializable x$67 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$68 = qual$11.getOrCreateLog$default$3();
        boolean x$69 = qual$11.getOrCreateLog$default$4();
        AbstractLog log2 = qual$11.getOrCreateLog(x$66, (Function0)x$67, x$68, x$69);
        LogSegment activeSegment = log2.activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] indexFilesOnDiskBeforeDelete = (File[])Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$10) {
                return x$10.getName().endsWith("index");
            }
        });
        LogManager qual$12 = this.logManager();
        TopicPartition x$70 = new TopicPartition(this.name(), 0);
        boolean x$71 = qual$12.asyncDelete$default$2();
        AbstractLog removedLog = (AbstractLog)qual$12.asyncDelete(x$70, x$71).get();
        LogSegment removedSegment = removedLog.activeSegment();
        Seq indexFilesAfterDelete = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{removedSegment.lazyOffsetIndex().file(), removedSegment.lazyTimeIndex().file(), removedSegment.txnIndex().file()}));
        Assert.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        Predef$.MODULE$.refArrayOps((Object[])indexFilesOnDiskBeforeDelete).foreach((Function1)new Serializable(this, indexFilesAfterDelete){
            public static final long serialVersionUID = 0L;
            private final Seq indexFilesAfterDelete$1;

            public final void apply(File fileBeforeDelete) {
                Option fileInIndex = this.indexFilesAfterDelete$1.find((Function1)new Serializable(this, fileBeforeDelete){
                    public static final long serialVersionUID = 0L;
                    private final File fileBeforeDelete$1;

                    public final boolean apply(File x$11) {
                        String string = x$11.getName();
                        String string2 = this.fileBeforeDelete$1.getName();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.fileBeforeDelete$1 = fileBeforeDelete$1;
                    }
                });
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find index file ", " in indexFilesAfterDelete"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileBeforeDelete.getName()})), (Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(File x$12) {
                        return x$12.getName();
                    }
                }));
                Assert.assertNotEquals((String)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (Object)((File)fileInIndex.get()).getAbsolutePath());
            }
            {
                this.indexFilesAfterDelete$1 = indexFilesAfterDelete$1;
            }
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Logs deleted too early", (boolean)this.logManager().hasLogsToBeDeleted());
        this.time().sleep(Predef$.MODULE$.Long2long(this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assert.assertFalse((String)"Logs not deleted", (boolean)this.logManager().hasLogsToBeDeleted());
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$13 = this.logManager();
        TopicPartition x$72 = new TopicPartition(invalidTopicName, 0);
        Serializable x$73 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$74 = qual$13.getOrCreateLog$default$3();
        boolean x$75 = qual$13.getOrCreateLog$default$4();
        qual$13.getOrCreateLog(x$72, (Function0)x$73, x$74, x$75);
        LogManager qual$14 = this.logManager();
        TopicPartition x$76 = new TopicPartition(invalidTopicName, 0);
        boolean x$77 = qual$14.asyncDelete$default$2();
        qual$14.asyncDelete(x$76, x$77);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        Seq tps = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 0), new TopicPartition("test-a", 1), new TopicPartition("test-a", 2), new TopicPartition("test-b", 0), new TopicPartition("test-b", 1)}));
        Seq allLogs2 = (Seq)tps.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final AbstractLog apply(TopicPartition x$13) {
                LogManager qual$15 = this.$outer.logManager();
                TopicPartition x$78 = x$13;
                Serializable x$79 = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$21 $outer;

                    public final LogConfig apply() {
                        return this.$outer.kafka$log$LogManagerTest$$anonfun$$$outer().logConfig();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                boolean x$80 = qual$15.getOrCreateLog$default$3();
                boolean x$81 = qual$15.getOrCreateLog$default$4();
                return qual$15.getOrCreateLog(x$78, (Function0)x$79, x$80, x$81);
            }

            public /* synthetic */ LogManagerTest kafka$log$LogManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        allLogs2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AbstractLog log2) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, log2){
                    public static final long serialVersionUID = 0L;
                    private final AbstractLog log$7;

                    public final LogAppendInfo apply(int _) {
                        return this.log$7.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.log$7.appendAsLeader$default$3(), this.log$7.appendAsLeader$default$4());
                    }
                    {
                        this.log$7 = log$7;
                    }
                });
                log2.flush();
            }
        });
        this.logManager().checkpointRecoveryOffsets(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)tps.zip((GenIterable)allLogs2, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, checkpoints){
            public static final long serialVersionUID = 0L;
            private final Map checkpoints$2;

            public final void apply(Tuple2<TopicPartition, AbstractLog> x0$2) {
                Tuple2<TopicPartition, AbstractLog> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    AbstractLog log2 = (AbstractLog)tuple2._2();
                    Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)this.checkpoints$2.apply((Object)tp)), (long)log2.recoveryPoint());
                    Option firstLocalSegmentNextOffset = log2.localLogSegments().headOption().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(LogSegment x$14) {
                            return x$14.readNextOffset();
                        }
                    });
                    Assert.assertEquals((Object)firstLocalSegmentNextOffset, (Object)log2.oldestProducerSnapshotOffset());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.checkpoints$2 = checkpoints$2;
            }
        });
    }

    private FetchDataInfo readLog(AbstractLog log2, long offset, int maxLength) {
        AbstractFetchDataInfo abstractFetchDataInfo = log2.read(offset, maxLength, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
        if (abstractFetchDataInfo instanceof FetchDataInfo) {
            FetchDataInfo fetchDataInfo;
            FetchDataInfo fetchDataInfo2 = fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
            return fetchDataInfo2;
        }
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected result ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{abstractFetchDataInfo})));
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        MergedLog mockLog = (MergedLog)EasyMock.mock(MergedLog.class);
        this.logManager().initializingLog(testTopicOnePartition);
        this.logManager().initializingLog(testTopicTwoPartition);
        this.logManager().topicConfigUpdated(testTopicOne);
        LogConfig logConfig = null;
        BooleanRef configUpdated = BooleanRef.create((boolean)false);
        this.logManager().finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog), (Function0)new Serializable(this, logConfig, configUpdated){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$1;
            private final BooleanRef configUpdated$1;

            public final LogConfig apply() {
                this.configUpdated$1.elem = true;
                return this.logConfig$1;
            }
            {
                this.logConfig$1 = logConfig$1;
                this.configUpdated$1 = configUpdated$1;
            }
        });
        Assert.assertTrue((boolean)configUpdated.elem);
        BooleanRef configNotUpdated = BooleanRef.create((boolean)true);
        this.logManager().finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog), (Function0)new Serializable(this, logConfig, configNotUpdated){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$1;
            private final BooleanRef configNotUpdated$1;

            public final LogConfig apply() {
                this.configNotUpdated$1.elem = false;
                return this.logConfig$1;
            }
            {
                this.logConfig$1 = logConfig$1;
                this.configNotUpdated$1 = configNotUpdated$1;
            }
        });
        Assert.assertTrue((boolean)configNotUpdated.elem);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        TopicPartition testTopicPartition2 = new TopicPartition("test-topic", 1);
        this.logManager().initializingLog(testTopicPartition2);
        LogConfig logConfig = null;
        BooleanRef configUpdateNotCalled = BooleanRef.create((boolean)true);
        this.logManager().finishedInitializingLog(testTopicPartition2, (Option)None$.MODULE$, (Function0)new Serializable(this, logConfig, configUpdateNotCalled){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$2;
            private final BooleanRef configUpdateNotCalled$1;

            public final LogConfig apply() {
                this.configUpdateNotCalled$1.elem = false;
                return this.logConfig$2;
            }
            {
                this.logConfig$2 = logConfig$2;
                this.configUpdateNotCalled$1 = configUpdateNotCalled$1;
            }
        });
        Assert.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        Assert.assertTrue((boolean)configUpdateNotCalled.elem);
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        MergedLog mockLog = (MergedLog)EasyMock.mock(MergedLog.class);
        this.logManager().initializingLog(testTopicOnePartition);
        this.logManager().initializingLog(testTopicTwoPartition);
        this.logManager().brokerConfigUpdated();
        LogConfig logConfig = null;
        IntRef totalChanges = IntRef.create((int)0);
        this.logManager().finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog), (Function0)new Serializable(this, logConfig, totalChanges){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$3;
            private final IntRef totalChanges$1;

            public final LogConfig apply() {
                ++this.totalChanges$1.elem;
                return this.logConfig$3;
            }
            {
                this.logConfig$3 = logConfig$3;
                this.totalChanges$1 = totalChanges$1;
            }
        });
        this.logManager().finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog), (Function0)new Serializable(this, logConfig, totalChanges){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$3;
            private final IntRef totalChanges$1;

            public final LogConfig apply() {
                ++this.totalChanges$1.elem;
                return this.logConfig$3;
            }
            {
                this.logConfig$3 = logConfig$3;
                this.totalChanges$1 = totalChanges$1;
            }
        });
        Assert.assertEquals((long)2L, (long)totalChanges.elem);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assert.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    @Test
    public void testDeleteAndTierStateFlushConcurrency() {
        File logDir = TestUtils$.MODULE$.tempDir();
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        TierPartitionStateFactory tierPartitionStateFactory = new TierPartitionStateFactory(true);
        TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some((Object)tierTopicConsumer), (Option)new Some((Object)tierObjectStore), tierPartitionStateFactory);
        tierTopicConsumer.commitPositions((java.util.Iterator)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this){

            public void answer(InvocationOnMock invocation) {
                Iterator iterator = (Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)invocation.getArgument(0)).asScala();
                iterator.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(TierPartitionState x$15) {
                        x$15.flush();
                    }
                });
            }
        });
        LogManager logManager = this.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{logDir}))), tierLogComponents);
        VolatileBooleanRef isDone = VolatileBooleanRef.create((boolean)false);
        VolatileObjectRef exceptionOpt = VolatileObjectRef.create((Object)None$.MODULE$);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.TierEnableProp(), Predef$.MODULE$.boolean2Boolean(true));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        int numPartitions = 50;
        Thread t = new Thread(this, logManager, isDone, exceptionOpt){
            private final LogManager logManager$2;
            private final VolatileBooleanRef isDone$1;
            private final VolatileObjectRef exceptionOpt$1;

            public void run() {
                try {
                    while (!this.isDone$1.elem) {
                        this.logManager$2.checkpointTierState(false);
                    }
                }
                catch (Exception exception) {
                    this.exceptionOpt$1.elem = new Some((Object)exception);
                }
            }
            {
                this.logManager$2 = logManager$2;
                this.isDone$1 = isDone$1;
                this.exceptionOpt$1 = exceptionOpt$1;
            }
        };
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)new Serializable(this, logManager, config){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;
            private final LogManager logManager$2;
            public final LogConfig config$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                TopicPartition topicPartition = new TopicPartition(this.$outer.name(), i);
                TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
                AbstractLog log2 = this.logManager$2.getOrCreateLog(topicPartition, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteAndTierStateFlushConcurrency$1 $outer;

                    public final LogConfig apply() {
                        return this.$outer.config$3;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.logManager$2.getOrCreateLog$default$3(), this.logManager$2.getOrCreateLog$default$4());
                log2.tierPartitionState().setTopicId(topicIdPartition.topicId());
                TierPartitionState.AppendResult result = log2.tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), 0L);
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logManager$2 = logManager$2;
                this.config$3 = config$3;
            }
        });
        t.start();
        IndexedSeq allLogs2 = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(this, logManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;
            private final LogManager logManager$2;

            public final Option<AbstractLog> apply(int i) {
                return this.logManager$2.asyncDelete(new TopicPartition(this.$outer.name(), i), this.logManager$2.asyncDelete$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logManager$2 = logManager$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        isDone.elem = true;
        t.join();
        allLogs2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Option<AbstractLog> x$16) {
                ((AbstractLog)x$16.get()).close();
            }
        });
        Utils.delete((File)logDir);
        ((Option)exceptionOpt.elem).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Exception x$17) {
                throw x$17;
            }
        });
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic=", ",partition=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp.topic(), BoxesRunTime.boxToInteger((int)tp.partition())}));
        LogManager qual$16 = this.logManager();
        TopicPartition x$82 = tp;
        Serializable x$83 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$84 = qual$16.getOrCreateLog$default$3();
        boolean x$85 = qual$16.getOrCreateLog$default$4();
        qual$16.getOrCreateLog(x$82, (Function0)x$83, x$84, x$85);
        this.verifyMetrics$1(topicName, metricTag);
        LogManager qual$17 = this.logManager();
        TopicPartition x$86 = tp;
        boolean x$87 = qual$17.asyncDelete$default$2();
        AbstractLog removedLog = (AbstractLog)qual$17.asyncDelete(x$86, x$87).get();
        Assert.assertTrue((boolean)this.logMetrics$1(topicName).isEmpty());
        LogManager qual$18 = this.logManager();
        TopicPartition x$88 = tp;
        Serializable x$89 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$90 = qual$18.getOrCreateLog$default$3();
        boolean x$91 = qual$18.getOrCreateLog$default$4();
        qual$18.getOrCreateLog(x$88, (Function0)x$89, x$90, x$91);
        this.verifyMetrics$1(topicName, metricTag);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        Assert.assertTrue((boolean)removedLog.localLogSegments().isEmpty());
        this.verifyMetrics$1(topicName, metricTag);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File dir1 = TestUtils$.MODULE$.tempDir();
        File dir2 = TestUtils$.MODULE$.tempDir();
        this.logManager_$eq(this.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{dir1, dir2}))), this.createLogManager$default$2()));
        this.logManager().startup();
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic=", ",partition=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp.topic(), BoxesRunTime.boxToInteger((int)tp.partition())}));
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$19 = this.logManager();
        TopicPartition x$92 = tp;
        Serializable x$93 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$94 = qual$19.getOrCreateLog$default$3();
        boolean x$95 = qual$19.getOrCreateLog$default$4();
        qual$19.getOrCreateLog(x$92, (Function0)x$93, x$94, x$95);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$20 = this.logManager();
        TopicPartition x$96 = tp;
        Serializable x$97 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final LogConfig apply() {
                return this.$outer.logConfig();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$98 = true;
        boolean x$99 = qual$20.getOrCreateLog$default$3();
        qual$20.getOrCreateLog(x$96, (Function0)x$97, x$99, x$98);
        this.verifyMetrics$2(2, topicName, metricTag);
        this.logManager().replaceCurrentWithFutureLog(tp);
        this.verifyMetrics$2(1, topicName, metricTag);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        this.verifyMetrics$2(1, topicName, metricTag);
    }

    private final KafkaConfig kafkaConfigWithCleanerConfig$1(int logDeletionMaxSegmentsPerRun) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), ((Object)BoxesRunTime.boxToInteger((int)logDeletionMaxSegmentsPerRun)).toString());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private final void reconfigureMaxSegmentDeletedPerRun$1(int logDeletionMaxSegmentsPerRun) {
        KafkaConfig oldConfig = this.kafkaConfigWithCleanerConfig$1(this.logManager().maxSegmentsDeletedPerRun());
        KafkaConfig newConfig = this.kafkaConfigWithCleanerConfig$1(logDeletionMaxSegmentsPerRun);
        this.logManager().reconfigure(oldConfig, newConfig);
    }

    private final Set logMetrics$1(String topicName$1) {
        return (Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1)new Serializable(this, topicName$1){
            public static final long serialVersionUID = 0L;
            private final String topicName$1;

            public final boolean apply(MetricName metric) {
                String string = metric.getType();
                String string2 = "Log";
                return !(string != null ? !string.equals(string2) : string2 != null) && metric.getScope().contains(this.topicName$1);
            }
            {
                this.topicName$1 = topicName$1;
            }
        });
    }

    private final void verifyMetrics$1(String topicName$1, String metricTag$1) {
        Assert.assertEquals((long)LogMetricNames$.MODULE$.allMetricNames().size(), (long)this.logMetrics$1(topicName$1).size());
        this.logMetrics$1(topicName$1).foreach((Function1)new Serializable(this, metricTag$1){
            public static final long serialVersionUID = 0L;
            private final String metricTag$1;

            public final void apply(MetricName metric) {
                Assert.assertTrue((boolean)metric.getMBeanName().contains(this.metricTag$1));
            }
            {
                this.metricTag$1 = metricTag$1;
            }
        });
    }

    private final Set logMetrics$2(String topicName$2) {
        return (Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1)new Serializable(this, topicName$2){
            public static final long serialVersionUID = 0L;
            private final String topicName$2;

            public final boolean apply(MetricName metric) {
                String string = metric.getType();
                String string2 = "Log";
                return !(string != null ? !string.equals(string2) : string2 != null) && metric.getScope().contains(this.topicName$2);
            }
            {
                this.topicName$2 = topicName$2;
            }
        });
    }

    private final void verifyMetrics$2(int logCount, String topicName$2, String metricTag$2) {
        Assert.assertEquals((long)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (long)this.logMetrics$2(topicName$2).size());
        this.logMetrics$2(topicName$2).foreach((Function1)new Serializable(this, metricTag$2){
            public static final long serialVersionUID = 0L;
            private final String metricTag$2;

            public final void apply(MetricName metric) {
                Assert.assertTrue((boolean)metric.getMBeanName().contains(this.metricTag$2));
            }
            {
                this.metricTag$2 = metricTag$2;
            }
        });
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }
}

