/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegmentTest$;
import kafka.log.LogUtils$;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.RollParams;
import kafka.server.FetchDataInfo;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h'\u0016<W.\u001a8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#\u0001\f\u0011\u0005]yR\"\u0001\r\u000b\u0005eQ\u0012AB2p[6|gN\u0003\u0002\u00067)\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0013\t\u0001\u0003D\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\t\u0002\u0001\u0015!\u0003\u0017\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003b\u0002\u0013\u0001\u0005\u0004%\t!J\u0001\tg\u0016<W.\u001a8ugV\ta\u0005E\u0002(Y9j\u0011\u0001\u000b\u0006\u0003S)\nq!\\;uC\ndWM\u0003\u0002,\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00055B#aC!se\u0006L()\u001e4gKJ\u0004\"AE\u0018\n\u0005A\u0012!A\u0003'pON+w-\\3oi\"1!\u0007\u0001Q\u0001\n\u0019\n\u0011b]3h[\u0016tGo\u001d\u0011\t\u0013Q\u0002\u0001\u0019!a\u0001\n\u0003)\u0014A\u00027pO\u0012K'/F\u00017!\t9D(D\u00019\u0015\tI$(\u0001\u0002j_*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u00111\u0015\u000e\\3\t\u0013}\u0002\u0001\u0019!a\u0001\n\u0003\u0001\u0015A\u00037pO\u0012K'o\u0018\u0013fcR\u0011\u0011\t\u0012\t\u0003\u0013\tK!a\u0011\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b\u000bz\n\t\u00111\u00017\u0003\rAH%\r\u0005\u0007\u000f\u0002\u0001\u000b\u0015\u0002\u001c\u0002\u000f1|w\rR5sA!)\u0011\n\u0001C\u0001\u0015\u0006i1M]3bi\u0016\u001cVmZ7f]R$BAL&Q+\")A\n\u0013a\u0001\u001b\u00061qN\u001a4tKR\u0004\"!\u0003(\n\u0005=S!\u0001\u0002'p]\u001eDq!\u0015%\u0011\u0002\u0003\u0007!+\u0001\nj]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\bCA\u0005T\u0013\t!&BA\u0002J]RDqA\u0016%\u0011\u0002\u0003\u0007q+\u0001\u0003uS6,\u0007C\u0001-\\\u001b\u0005I&B\u0001.\u0019\u0003\u0015)H/\u001b7t\u0013\ta\u0016L\u0001\u0003US6,\u0007\"\u00020\u0001\t\u0003y\u0016a\u0002:fG>\u0014Hm\u001d\u000b\u0004A\u001a<\u0007CA1e\u001b\u0005\u0011'BA2\u0019\u0003\u0019\u0011XmY8sI&\u0011QM\u0019\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000b1k\u0006\u0019A'\t\u000byk\u0006\u0019\u00015\u0011\u0007%I7.\u0003\u0002k\u0015\tQAH]3qK\u0006$X\r\u001a \u0011\u00051|gBA\u0005n\u0013\tq'\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u0014aa\u0015;sS:<'B\u00018\u000b\u0011\u0015\u0019\b\u0001\"\u0001u\u0003\u0015\u0019X\r^;q)\u0005\t\u0005F\u0001:w!\t9(0D\u0001y\u0015\tIX$A\u0003kk:LG/\u0003\u0002|q\n1!)\u001a4pe\u0016DQ! \u0001\u0005\u0002Q\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003y~\u00042a^A\u0001\u0013\r\t\u0019\u0001\u001f\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0007\u0003\u000f\u0001A\u0011\u0001;\u0002-Q,7\u000f\u001e*fC\u0012|e.R7qif\u001cVmZ7f]RDC!!\u0002\u0002\fA\u0019q/!\u0004\n\u0007\u0005=\u0001P\u0001\u0003UKN$\bBBA\n\u0001\u0011\u0005A/A\ruKN$(+Z1e\u0005\u00164wN]3GSJ\u001cHo\u00144gg\u0016$\b\u0006BA\t\u0003\u0017Aa!!\u0007\u0001\t\u0003!\u0018!\u0005;fgR\u0014V-\u00193BMR,'\u000fT1ti\"\"\u0011qCA\u0006\u0011\u0019\ty\u0002\u0001C\u0001i\u0006yA/Z:u%\u0016\fGM\u0012:p[\u001e\u000b\u0007\u000f\u000b\u0003\u0002\u001e\u0005-\u0001BBA\u0013\u0001\u0011\u0005A/\u0001\u0007uKN$HK];oG\u0006$X\r\u000b\u0003\u0002$\u0005-\u0001BBA\u0016\u0001\u0011\u0005A/\u0001\ruKN$HK];oG\u0006$X-R7qif\u001cVmZ7f]RDC!!\u000b\u0002\f!1\u0011\u0011\u0007\u0001\u0005\u0002Q\fa\u0007^3tiJ+Gn\\1e\u0019\u0006\u0014x-Z:u)&lWm\u001d;b[B\fe\u000e\u001a(fqR|eMZ:fi\u00063G/\u001a:UeVt7-\u0019;j_:DC!a\f\u0002\f!1\u0011q\u0007\u0001\u0005\u0002Q\f\u0001\u0003^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7)\t\u0005U\u00121\u0002\u0005\u0007\u0003{\u0001A\u0011\u0001;\u00023Q,7\u000f\u001e$j]\u0012|eMZ:fi\nKH+[7fgR\fW\u000e\u001d\u0015\u0005\u0003w\tY\u0001\u0003\u0004\u0002D\u0001!\t\u0001^\u0001\u001ai\u0016\u001cHOT3yi>3gm]3u\u0007\u0006d7-\u001e7bi&|g\u000e\u000b\u0003\u0002B\u0005-\u0001BBA%\u0001\u0011\u0005A/\u0001\fuKN$8\t[1oO\u00164\u0015\u000e\\3Tk\u001a4\u0017\u000e_3tQ\u0011\t9%a\u0003\t\r\u0005=\u0003\u0001\"\u0001u\u0003u!Xm\u001d;SK\u000e|g/\u001a:z\r&DXm]\"peJ,\b\u000f^%oI\u0016D\b\u0006BA'\u0003\u0017Aa!!\u0016\u0001\t\u0003!\u0018a\u0007;fgR\u0014VmY8wKJ$&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010\u000b\u0003\u0002T\u0005-\u0001bBA.\u0001\u0011%\u0011QL\u0001\u000eK:$G\u000b\u001f8SK\u000e|'\u000fZ:\u0015\u001f\u0001\fy&!\u001b\u0002n\u0005]\u0014\u0011PA?\u0003\u0003C\u0001\"!\u0019\u0002Z\u0001\u0007\u00111M\u0001\u0012G>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007cA1\u0002f%\u0019\u0011q\r2\u0003#\r{g\u000e\u001e:pYJ+7m\u001c:e)f\u0004X\rC\u0004\u0002l\u0005e\u0003\u0019A'\u0002\u0015A\u0014x\u000eZ;dKJLE\r\u0003\u0005\u0002p\u0005e\u0003\u0019AA9\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQB\u0019\u0011\"a\u001d\n\u0007\u0005U$BA\u0003TQ>\u0014H\u000f\u0003\u0004M\u00033\u0002\r!\u0014\u0005\n\u0003w\nI\u0006%AA\u0002I\u000bA\u0003]1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0007\"CA@\u00033\u0002\n\u00111\u0001S\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eC\u0005\u0002\u0004\u0006e\u0003\u0013!a\u0001\u001b\u0006IA/[7fgR\fW\u000e\u001d\u0005\u0007\u0003\u000f\u0003A\u0011\u0001;\u0002CQ,7\u000f\u001e*fG>4XM]=GSb,7oQ8seV\u0004H\u000fV5nK&sG-\u001a=)\t\u0005\u0015\u00151\u0002\u0005\u0007\u0003\u001b\u0003A\u0011\u0001;\u0002=Q,7\u000f\u001e*fG>4XM]=XSRD7i\u001c:skB$X*Z:tC\u001e,\u0007\u0006BAF\u0003\u0017Aa!\u0013\u0001\u0005\n\u0005ME#\u0003\u0018\u0002\u0016\u0006e\u00151UAT\u0011\u001d\t9*!%A\u00025\u000b!BY1tK>3gm]3u\u0011!\tY*!%A\u0002\u0005u\u0015!\u00054jY\u0016\fEN]3bIf,\u00050[:ugB\u0019\u0011\"a(\n\u0007\u0005\u0005&BA\u0004C_>dW-\u00198\t\u000f\u0005\u0015\u0016\u0011\u0013a\u0001%\u0006a\u0011N\\5u\r&dWmU5{K\"A\u0011\u0011VAI\u0001\u0004\ti*A\u0006qe\u0016\fG\u000e\\8dCR,\u0007BBAW\u0001\u0011\u0005A/A\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]&$h)\u001b7f'&TX-\u00119qK:$W*Z:tC\u001e,\u0007\u0006BAV\u0003\u0017Aa!a-\u0001\t\u0003!\u0018a\n;fgR\u001c%/Z1uK^KG\u000f[%oSR4\u0015\u000e\\3TSj,7\t\\3beNCW\u000f\u001e3po:DC!!-\u0002\f!1\u0011\u0011\u0018\u0001\u0005\u0002Q\faf\u001d5pk2$GK];oG\u0006$X-\u0012<f]&3wJ\u001a4tKR\u0004v.\u001b8ugR{\u0017iR1q\u0013:$\u0006.\u001a'pO\"\"\u0011qWA\u0006\u0011\u0019\ty\f\u0001C\u0001i\u0006\u0011B/Z:u\u0003B\u0004XM\u001c3Ge>lg)\u001b7fQ\u0011\ti,a\u0003\t\u0013\u0005\u0015\u0007!%A\u0005\u0002\u0005\u001d\u0017aF2sK\u0006$XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tIMK\u0002S\u0003\u0017\\#!!4\u0011\t\u0005=\u0017\u0011\\\u0007\u0003\u0003#TA!a5\u0002V\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/T\u0011AC1o]>$\u0018\r^5p]&!\u00111\\Ai\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003?\u0004\u0011\u0013!C\u0001\u0003C\fqc\u0019:fCR,7+Z4nK:$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\r(fA,\u0002L\"I\u0011q\u001d\u0001\u0012\u0002\u0013%\u0011qY\u0001\u0018K:$G\u000b\u001f8SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIUB\u0011\"a;\u0001#\u0003%I!a2\u0002/\u0015tG\r\u0016=o%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u00122\u0004\"CAx\u0001E\u0005I\u0011BAy\u0003])g\u000e\u001a+y]J+7m\u001c:eg\u0012\"WMZ1vYR$s'\u0006\u0002\u0002t*\u001aQ*a3")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        LogSegment seg = LogUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records2) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records2.map((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final SimpleRecord apply(String s) {
                return new SimpleRecord(this.offset$1 * 10L, s.getBytes());
            }
            {
                this.offset$1 = offset$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @Before
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogSegment x$1) {
                x$1.close();
            }
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        FetchDataInfo read = seg.read(40L, 300, seg.read$default$3(), seg.read$default$4());
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, -1L, -1L, ms);
        Records read = seg.read(41L, 300, seg.read$default$3(), seg.read$default$4()).records();
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        FetchDataInfo read = seg.read(52L, 200, seg.read$default$3(), seg.read$default$4());
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", (Object)read);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)new Serializable(this, seg, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$1;
            private final IntRef offset$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords ms1 = this.$outer.records(this.offset$2.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$1.append((long)this.offset$2.elem, -1L, -1L, ms1);
                MemoryRecords ms2 = this.$outer.records(this.offset$2.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$1.append((long)(this.offset$2.elem + 1), -1L, -1L, ms2);
                FetchDataInfo read = this.seg$1.read((long)this.offset$2.elem, 10000, this.seg$1.read$default$3(), this.seg$1.read$default$4());
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Record[]{(Record)ms1.records().iterator().next(), (Record)ms2.records().iterator().next()})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().records()).asScala()).toList());
                this.seg$1.truncateTo((long)(this.offset$2.elem + 1));
                FetchDataInfo read2 = this.seg$1.read((long)this.offset$2.elem, 10000, this.seg$1.read$default$3(), this.seg$1.read$default$4());
                Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records().records()).asScala()).size());
                TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records().records().iterator());
                ++this.offset$2.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$1 = seg$1;
                this.offset$2 = offset$2;
            }
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        long x$3 = 0L;
        MockTime x$4 = time;
        int x$5 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$3, x$5, (Time)x$4);
        seg.close();
        long x$6 = 0L;
        MockTime x$7 = time;
        int x$8 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(x$6, x$8, (Time)x$7);
        Assert.assertEquals((long)0L, (long)seg.timeIndex().sizeInBytes());
        Assert.assertEquals((long)0L, (long)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assert.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)reopened.timeIndex().isFull());
        Assert.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assert.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assert.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assert.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, (long)Integer.MAX_VALUE + 200L, 1024, time.milliseconds());
        Assert.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, seg, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$2;
            private final IntRef offset$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.seg$2.append((long)this.offset$3.elem, (long)this.offset$3.elem, (long)this.offset$3.elem, this.$outer.records(this.offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
                ++this.offset$3.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$2 = seg$2;
                this.offset$3 = offset$3;
            }
        });
        Assert.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have ", " time indexes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedNumEntries)})), (long)expectedNumEntries, (long)seg.timeIndex().entries());
        seg.truncateTo(41L);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have 0 time indexes"})).s((Seq)Nil$.MODULE$), (long)0L, (long)seg.timeIndex().entries());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Largest timestamp should be 400"})).s((Seq)Nil$.MODULE$), (long)400L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        long x$9 = 40L;
        MockTime x$10 = time;
        int x$11 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$9, x$11, (Time)x$10);
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assert.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assert.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)seg.timeIndex().isFull());
        Assert.assertFalse((boolean)seg.offsetIndex().isFull());
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, 1024, seg.read$default$3(), seg.read$default$4()));
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).s((Seq)Nil$.MODULE$)})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$3.append((long)i, (long)(i * 10), (long)i, this.$outer.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$3 = seg$3;
            }
        });
        Assert.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)42L, (long)((FileRecords.FileTimestampAndOffset)seg.findOffsetByTimestamp((long)420L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)43L, (long)((FileRecords.FileTimestampAndOffset)seg.findOffsetByTimestamp((long)421L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)43L, (long)((FileRecords.FileTimestampAndOffset)seg.findOffsetByTimestamp((long)430L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)44L, (long)((FileRecords.FileTimestampAndOffset)seg.findOffsetByTimestamp((long)431L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assert.assertEquals((long)41L, (long)((FileRecords.FileTimestampAndOffset)seg.findOffsetByTimestamp((long)401L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)40L, (long)((FileRecords.FileTimestampAndOffset)seg.findOffsetByTimestamp((long)399L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assert.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, -1L, -1L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        File logFile = seg.log().file();
        File indexFile = seg.lazyOffsetIndex().file();
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertEquals((Object)new StringBuilder().append((Object)logFile.getAbsolutePath()).append((Object)".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assert.assertEquals((Object)new StringBuilder().append((Object)indexFile.getAbsolutePath()).append((Object)".deleted").toString(), (Object)seg.lazyOffsetIndex().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        Assert.assertTrue((boolean)seg.lazyOffsetIndex().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$4.append((long)i, -1L, -1L, this.$outer.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$4 = seg$4;
            }
        });
        File indexFile = seg.lazyOffsetIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final LogSegment seg$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long x$12 = i;
                int x$13 = 1;
                boolean x$14 = true;
                long x$15 = this.seg$4.read$default$3();
                Iterable records2 = this.seg$4.read(x$12, x$13, x$15, x$14).records().records();
                Assert.assertEquals((long)i, (long)((Record)records2.iterator().next()).offset());
            }
            {
                this.seg$4 = seg$4;
            }
        });
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(101L, -1L, 100L, MemoryRecords.withTransactionalRecords((long)100L, (CompressionType)CompressionType.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(103L, -1L, 102L, MemoryRecords.withTransactionalRecords((long)102L, (CompressionType)CompressionType.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(partitionLeaderEpoch), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{new BatchMetadata(10, 10L, 5, -1L)})), producerEpoch, 0, -1L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)75L))));
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$5.append((long)i, (long)(i * 10), (long)i, this.$outer.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$5 = seg$5;
            }
        });
        File timeIndexFile = seg.lazyTimeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final LogSegment seg$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((FileRecords.FileTimestampAndOffset)this.seg$5.findOffsetByTimestamp((long)((long)(i * 10)), (long)this.seg$5.findOffsetByTimestamp$default$2()).get()).offset);
                if (i < 99) {
                    Assert.assertEquals((long)(i + 1), (long)((FileRecords.FileTimestampAndOffset)this.seg$5.findOffsetByTimestamp((long)((long)(i * 10 + 1)), (long)this.seg$5.findOffsetByTimestamp$default$2()).get()).offset);
                }
            }
            {
                this.seg$5 = seg$5;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, messagesAppended){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final int messagesAppended$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                LogSegment seg = this.$outer.createSegment(0L, this.$outer.createSegment$default$2(), this.$outer.createSegment$default$3());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.messagesAppended$1).foreach$mVc$sp((Function1)new Serializable(this, seg){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecoveryWithCorruptMessage$1 $outer;
                    private final LogSegment seg$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.seg$6.append((long)i, -1L, -1L, this.$outer.kafka$log$LogSegmentTest$$anonfun$$$outer().records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.seg$6 = seg$6;
                    }
                });
                int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(this.messagesAppended$1);
                FileRecords.LogOffsetPosition recordPosition = seg.log().searchForOffsetWithSize((long)offsetToBeginCorruption, 0);
                int position = recordPosition.position + TestUtils$.MODULE$.random().nextInt(15);
                TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
                seg.recover(new ProducerStateManager(this.$outer.topicPartition(), this.$outer.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
                Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileLogInputStream.FileChannelRecordBatch x$2) {
                        return x$2.lastOffset();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList());
                seg.deleteIfExists();
            }

            public /* synthetic */ LogSegmentTest kafka$log$LogSegmentTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.messagesAppended$1 = messagesAppended$1;
            }
        });
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, baseOffset, logConfig, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, false, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assert.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assert.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, true, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200, segReopen.read$default$3(), segReopen.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records().records().iterator());
        int size2 = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assert.assertEquals((long)oldPosition, (long)position);
        Assert.assertEquals((long)oldSize, (long)size2);
        Assert.assertEquals((long)size2, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int offset = 40;
        MemoryRecords ms1 = this.records$1(offset, "first message");
        seg.append((long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = this.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log2 = seg.read((long)offset, 10000, seg.read$default$3(), seg.read$default$4());
        Assert.assertEquals((long)offset, (long)((RecordBatch)log2.records().batches().iterator().next()).baseOffset());
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(log2.records().batches()).asScala()).size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        FileRecords fileRecords = FileRecords.open((File)Log$.MODULE$.logFile(tempDir, 0L, Log$.MODULE$.logFile$default$3()));
        fileRecords.append(this.records$2(0L, 1024));
        fileRecords.append(this.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(this.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)bytesAppended);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assert.assertEquals((long)(sizeAfterOverflow - sizeBeforeOverflow), (long)overflowBytesAppended);
        Assert.assertEquals((long)overflowBytesAppended, (long)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    private final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }

    private final MemoryRecords records$2(long offset, int size2) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new byte[size2])});
    }
}

