/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import kafka.log.OffsetMapTest$;
import kafka.log.SkimpyOffsetMap;
import kafka.log.SkimpyOffsetMap$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u000f\tiqJ\u001a4tKRl\u0015\r\u001d+fgRT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0003\u0015\u0001\u0011\u0005Q#A\nuKN$()Y:jGZ\u000bG.\u001b3bi&|g\u000eF\u0001\u0017!\tIq#\u0003\u0002\u0019\u0015\t!QK\\5uQ\t\u0019\"\u0004\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005)!.\u001e8ji*\tq$A\u0002pe\u001eL!!\t\u000f\u0003\tQ+7\u000f\u001e\u0005\u0006G\u0001!\t!F\u0001\ni\u0016\u001cHo\u00117fCJD#A\t\u000e\t\u000b\u0019\u0002A\u0011A\u000b\u0002\u001fQ,7\u000f^$fi^CWM\u001c$vY2D#!\n\u000e\t\u000b%\u0002A\u0011\u0001\u0016\u0002\u0007-,\u0017\u0010\u0006\u0002,gA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0004]&|'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012!BQ=uK\n+hMZ3s\u0011\u0015I\u0003\u00061\u00015!\tIQ'\u0003\u00027\u0015\t!Aj\u001c8h\u0011\u0015A\u0004\u0001\"\u0001:\u0003-1\u0018\r\\5eCR,W*\u00199\u0015\u0007ij$\t\u0005\u0002\u0013w%\u0011AH\u0001\u0002\u0010'.LW\u000e]=PM\u001a\u001cX\r^'ba\")ah\u000ea\u0001\u007f\u0005)\u0011\u000e^3ngB\u0011\u0011\u0002Q\u0005\u0003\u0003*\u00111!\u00138u\u0011\u001d\u0019u\u0007%AA\u0002\u0011\u000b!\u0002\\8bI\u001a\u000b7\r^8s!\tIQ)\u0003\u0002G\u0015\t1Ai\\;cY\u0016Dq\u0001\u0013\u0001\u0012\u0002\u0013\u0005\u0011*A\u000bwC2LG-\u0019;f\u001b\u0006\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003)S#\u0001R&,\u00031\u0003\"!\u0014*\u000e\u00039S!a\u0014)\u0002\u0013Ut7\r[3dW\u0016$'BA)\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0003':\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f\u0015)&\u0001#\u0001W\u00035yeMZ:fi6\u000b\u0007\u000fV3tiB\u0011!c\u0016\u0004\u0006\u0003\tA\t\u0001W\n\u0003/\"AQaD,\u0005\u0002i#\u0012A\u0016\u0005\u00069^#\t!X\u0001\u0005[\u0006Lg\u000e\u0006\u0002\u0017=\")ql\u0017a\u0001A\u0006!\u0011M]4t!\rI\u0011mY\u0005\u0003E*\u0011Q!\u0011:sCf\u0004\"\u0001Z4\u000f\u0005%)\u0017B\u00014\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019T\u0001")
public class OffsetMapTest {
    public static void main(String[] stringArray) {
        OffsetMapTest$.MODULE$.main(stringArray);
    }

    @Test
    public void testBasicValidation() {
        this.validateMap(10, this.validateMap$default$2());
        this.validateMap(100, this.validateMap$default$2());
        this.validateMap(1000, this.validateMap$default$2());
        this.validateMap(5000, this.validateMap$default$2());
    }

    @Test
    public void testClear() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4000, SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetMapTest $outer;
            private final SkimpyOffsetMap map$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.map$1.put(this.$outer.key(i), (long)i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetMapTest $outer;
            private final SkimpyOffsetMap map$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)this.map$1.get(this.$outer.key(i)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        map.clear();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetMapTest $outer;
            private final SkimpyOffsetMap map$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)this.map$1.get(this.$outer.key(i)), (long)-1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
    }

    @Test
    public void testGetWhenFull() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4096, SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        long i = 37L;
        while (map.size() < map.slots()) {
            map.put(this.key(i), i);
            ++i;
        }
        Assert.assertEquals((long)map.get(this.key(i)), (long)-1L);
        Assert.assertEquals((long)map.get(this.key(i - 1L)), (long)(i - 1L));
    }

    public ByteBuffer key(long key) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToLong((long)key)).toString().getBytes());
    }

    public SkimpyOffsetMap validateMap(int items, double loadFactor) {
        SkimpyOffsetMap map = new SkimpyOffsetMap((int)((double)items / loadFactor * (double)24), SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetMapTest $outer;
            private final SkimpyOffsetMap map$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.map$2.put(this.$outer.key(i), (long)i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetMapTest $outer;
            private final SkimpyOffsetMap map$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)this.map$2.get(this.$outer.key(i)), (long)i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        return map;
    }

    public double validateMap$default$2() {
        return 0.5;
    }
}

