/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001\u001d\u00111\"T3ue&\u001c7\u000fV3ti*\u00111\u0001B\u0001\b[\u0016$(/[2t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00055Q!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00017\u0005Aa.^7O_\u0012,7/F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\rIe\u000e\u001e\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u00139,XNT8eKN\u0004\u0003bB\u0013\u0001\u0005\u0004%\taG\u0001\t]Vl\u0007+\u0019:ug\"1q\u0005\u0001Q\u0001\nq\t\u0011B\\;n!\u0006\u0014Ho\u001d\u0011\t\u000f%\u0002!\u0019!C\u0001U\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003vi&d'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019!\u0004\u0001)A\u0005W\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\u0006m\u0001!\taN\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\t\u0001\bE\u0002:yyj\u0011A\u000f\u0006\u0003wy\t!bY8mY\u0016\u001cG/[8o\u0013\ti$HA\u0002TKF\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0003\u0002\rM,'O^3s\u0013\t\u0019\u0005IA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bB#\u0001\u0005\u0004%\taG\u0001\n]6+7o]1hKNDaa\u0012\u0001!\u0002\u0013a\u0012A\u00038NKN\u001c\u0018mZ3tA!)\u0011\n\u0001C\u0001\u0015\u0006)C/Z:u\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;fe\u00063G/\u001a:EK2,G/\u001b8h)>\u0004\u0018n\u0019\u000b\u0002\u0017B\u0011Q\u0004T\u0005\u0003\u001bz\u0011A!\u00168ji\"\u0012\u0001j\u0014\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000bQA[;oSRT\u0011\u0001V\u0001\u0004_J<\u0017B\u0001,R\u0005\u0011!Vm\u001d;\t\u000ba\u0003A\u0011\u0001&\u0002iQ,7\u000f\u001e\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN,fN]3hSN$XM]3e\u0003\u001a$XM\u001d#fY\u0016$\u0018N\\4U_BL7\r\u000b\u0002X\u001f\")1\f\u0001C\u0001\u0015\u0006\u0019B/Z:u\u00072,8\u000f^3s\u0013\u0012lU\r\u001e:jG\"\u0012!l\u0014\u0005\u0006=\u0002!\tAS\u00013i\u0016\u001cHoR3oKJ\fGN\u0011:pW\u0016\u0014Hk\u001c9jG6+GO]5dg\u0006\u0013Xm\u0012:fK\u0012LG.\u001f*fO&\u001cH/\u001a:fI\"\u0012Ql\u0014\u0005\u0006C\u0002!\tAS\u0001\u0019i\u0016\u001cHoV5oI><8o\u0015;zY\u0016$\u0016m\u001a(b[\u0016\u001c\bF\u00011P\u0011\u0015!\u0007\u0001\"\u0001K\u0003\u0001\"Xm\u001d;Ce>\\WM\u001d+pa&\u001cW*\u001a;sS\u000e\u001c()\u001f;fg&sw*\u001e;)\u0005\r|\u0005\"B4\u0001\t\u0003Q\u0015A\u000e;fgR\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:O_.+\u0017pQ8na\u0006\u001cG/\u001a3U_BL7MU3d_J$7\u000fT8hO\u0016$\u0007F\u00014P\u0011\u0015Q\u0007\u0001\"\u0001K\u0003U!Xm\u001d;D_:$(o\u001c7mKJlU\r\u001e:jGND#![(\t\u000b5\u0004A\u0011\u0001&\u0002KQ,7\u000f^!hOJ,w-\u0019;f%\u0016\u001cwN\u001d3NKR\u0014\u0018nY:J]&$\u0018.\u00197ju\u0016$\u0007F\u00017P\u0011\u0015\u0001\b\u0001\"\u0001K\u0003\t\"Xm\u001d;Ce>\\WM\u001d+pa&\u001cW*\u001a;sS\u000e\u001c8+Z4nK:$(+Z1eg\"\u0012qn\u0014\u0005\u0006g\u0002!\tAS\u0001!i\u0016\u001cHoU3tg&|g.\u0012=qSJ,G*[:uK:,'/T3ue&\u001c7\u000f\u000b\u0002s\u001f\")a\u000f\u0001C\u0005o\u0006aAo\u001c9jG6+GO]5dgR\u0019\u00010!\u0002\u0011\u0007eJ80\u0003\u0002{u\t\u00191+\u001a;\u0011\u0005q|hBA\u000f~\u0013\tqh$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\t\u0019A\u0001\u0004TiJLgn\u001a\u0006\u0003}zAq!a\u0002v\u0001\u0004\tI!A\u0003u_BL7\r\u0005\u0003\u001e\u0003\u0017Y\u0018bAA\u0007=\t1q\n\u001d;j_:Dq!!\u0005\u0001\t\u0013\t\u0019\"A\tu_BL7-T3ue&\u001cwI]8vaN$2\u0001_A\u000b\u0011\u001d\t9!a\u0004A\u0002mDq!!\u0007\u0001\t\u0013\tY\"\u0001\rgS2$XM\u001d\"z)>\u0004\u0018nY'fiJL7MU3hKb$R\u0001_A\u000f\u0003?AaaAA\f\u0001\u0004A\b\u0002CA\u0004\u0003/\u0001\r!!\u0003")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertTrue((String)"Topic metrics don't exist", (boolean)this.topicMetricGroups(topic).nonEmpty());
        this.servers().foreach((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final void apply(KafkaServer s) {
                Assert.assertNotNull((Object)s.brokerTopicStats().topicStats(this.topic$1));
            }
            {
                this.topic$1 = topic$1;
            }
        });
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testClusterIdMetric() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$2) {
                String string = x$2.getMBeanName();
                String string2 = "kafka.server:type=KafkaServer,name=ClusterId";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
    }

    @Test
    public void testGeneralBrokerTopicMetricsAreGreedilyRegistered() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        Assert.assertTrue((String)"General topic metrics don't exist", (boolean)this.topicMetrics((Option<String>)None$.MODULE$).nonEmpty());
        Assert.assertEquals((long)((KafkaServer)this.servers().head()).brokerTopicStats().allTopicsStats().metricMap().size(), (long)this.topicMetrics((Option<String>)None$.MODULE$).size());
        Assert.assertTrue((String)"Topic metrics aren't lazily registered", (boolean)this.topicMetricGroups(topic).isEmpty());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertTrue((String)"Topic metrics aren't registered", (boolean)this.topicMetricGroups(topic).nonEmpty());
    }

    @Test
    public void testWindowsStyleTagNames() {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((TraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = KafkaMetricsGroup$.MODULE$.metricName("test-metric", tags);
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @Test
    public void testBrokerTopicMetricsBytesInOut() {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.BytesInPerSec(), topic}));
        String bytesOut = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.BytesOutPerSec(), topic}));
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers().foreach((Function1)new Serializable(this, topic, topicPartition){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final TopicPartition topicPartition$1;

            public final void apply(KafkaServer server) {
                LogManager qual$1 = server.logManager();
                TopicPartition x$25 = new TopicPartition(this.topic$2, 0);
                boolean x$26 = qual$1.getLog$default$2();
                Option log2 = qual$1.getLog(x$25, x$26);
                int brokerId = server.config().brokerId();
                Option logSize = log2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(AbstractLog x$3) {
                        return x$3.size();
                    }
                });
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected broker ", " to have a Log for ", " with positive size, actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId), this.topicPartition$1, logSize})), (boolean)BoxesRunTime.unboxToBoolean((Object)logSize.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$4) {
                        return this.apply$mcZJ$sp(x$4);
                    }

                    public boolean apply$mcZJ$sp(long x$4) {
                        return x$4 > 0L;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                })));
            }
            {
                this.topic$2 = topic$2;
                this.topicPartition$1 = topicPartition$1;
            }
        });
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        long initialReplicationBytesIn = TestUtils$.MODULE$.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = TestUtils$.MODULE$.meterCount(replicationBytesOut);
        long initialBytesIn = TestUtils$.MODULE$.meterCount(bytesIn);
        long initialBytesOut = TestUtils$.MODULE$.meterCount(bytesOut);
        Assert.assertEquals((long)initialBytesOut, (long)TestUtils$.MODULE$.meterCount(bytesOut));
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @Test
    public void testBrokerTopicMetricsNoKeyCompactedTopicRecordsLogged() {
        String topic = "test-compacted-topic-record-no-key";
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topic, 1, this.numNodes(), topicConfig);
        try {
            TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{new ProducerRecord(topic, (Object)"test".getBytes())})), TestUtils$.MODULE$.produceMessages$default$3());
            Assert.fail((String)"Exception should have been thrown since a compacted topic cannot accept a message without keys");
        }
        catch (Exception exception) {}
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$5) {
                return x$5.getMBeanName().endsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name=NoKeyCompactedTopicRecordsPerSec"})).s((Seq)Nil$.MODULE$));
            }
        }));
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name=NoKeyCompactedTopicRecordsPerSec"})).s((Seq)Nil$.MODULE$)) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testControllerMetrics() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$6) {
                String string = x$6.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$7) {
                String string = x$7.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$8) {
                String string = x$8.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$9) {
                String string = x$9.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$10) {
                String string = x$10.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$11) {
                String string = x$11.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=TopicsToDeleteCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$12) {
                String string = x$12.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=ReplicasToDeleteCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$13) {
                String string = x$13.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=TopicsIneligibleToDeleteCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$14) {
                String string = x$14.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=ReplicasIneligibleToDeleteCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
    }

    @Test
    public void testAggregateRecordMetricsInitialized() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$15) {
                return x$15.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=NoKeyCompactedTopicRecordsPerSec");
            }
        }));
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$16) {
                return x$16.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=InvalidMagicNumberRecordsPerSec");
            }
        }));
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$17) {
                return x$17.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=InvalidMessageCrcRecordsPerSec");
            }
        }));
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$18) {
                return x$18.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=NonIncreasingOffsetRecordsPerSec");
            }
        }));
    }

    @Test
    public void testBrokerTopicMetricsSegmentReads() {
        String topic = "test-segment-reads";
        String segmentReads = BrokerTopicStats$.MODULE$.SegmentReadsPerSec();
        String segmentSpeculativePrefetches = BrokerTopicStats$.MODULE$.SegmentSpeculativePrefetchesPerSec();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.SegmentSpeculativePrefetchEnableProp(), "true");
        topicConfig.setProperty(LogConfig$.MODULE$.SegmentBytesProp(), "128");
        this.createTopic(topic, 1, this.numNodes(), topicConfig);
        Assert.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentReads));
        Assert.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches));
        this.testTopicMetricFails$1(segmentReads, topic);
        this.testTopicMetricFails$1(segmentSpeculativePrefetches, topic);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, 1, TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 32).foreach((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final String topic$3;

            public final Seq<String> apply(int x$19) {
                return TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.$outer.servers(), this.topic$3, 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
            }
        });
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, 32, TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) > 1L ? 1 : 0) != 0);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) - 1L > TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches) ? 1 : 0) != 0);
    }

    @Test
    public void testSessionExpireListenerMetrics() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$20) {
                String string = x$20.getMBeanName();
                String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$21) {
                String string = x$21.getMBeanName();
                String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$22) {
                String string = x$22.getMBeanName();
                String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
    }

    private Set<String> topicMetrics(Option<String> topic) {
        scala.collection.mutable.Set metricNames = (scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(MetricName x$23) {
                return x$23.getMBeanName();
            }
        }, scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        return this.filterByTopicMetricRegex((Set<String>)metricNames, topic);
    }

    private Set<String> topicMetricGroups(String topic) {
        scala.collection.mutable.Set metricGroups = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return this.filterByTopicMetricRegex((Set<String>)metricGroups, (Option<String>)new Some((Object)topic));
    }

    private Set<String> filterByTopicMetricRegex(Set<String> metrics, Option<String> topic) {
        Pattern pattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)".*BrokerTopicMetrics.*").append(topic.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String t) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")$"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString())).r().pattern();
        return (Set)metrics.filter((Function1)new Serializable(this, pattern){
            public static final long serialVersionUID = 0L;
            private final Pattern pattern$1;

            public final boolean apply(String x$24) {
                return this.pattern$1.matcher(x$24).matches();
            }
            {
                this.pattern$1 = pattern$1;
            }
        });
    }

    private final void testTopicMetricFails$1(String metric, String topic$3) {
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, topic$3, metric){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final String metric$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return TestUtils$.MODULE$.meterCount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metric$1, this.topic$3})));
            }
            {
                this.topic$3 = topic$3;
                this.metric$1 = metric$1;
            }
        }, ClassTag$.MODULE$.apply(Throwable.class), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
        this.nMessages = 2;
    }
}

