/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.server.ActiveTenantsManager;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u000f\tA\u0012i\u0019;jm\u0016$VM\\1oiNl\u0015M\\1hKJ$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0004\u0015\u0001\t\u0007I\u0011B\u000b\u0002\tQLW.Z\u000b\u0002-A\u0011q#I\u0007\u00021)\u0011\u0011DG\u0001\u0006kRLGn\u001d\u0006\u00037q\taaY8n[>t'BA\u0003\u001e\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\n\u0005\tB\"\u0001C'pG.$\u0016.\\3\t\r\u0011\u0002\u0001\u0015!\u0003\u0017\u0003\u0015!\u0018.\\3!\u0011%1\u0003\u00011AA\u0002\u0013%q%A\u0004nKR\u0014\u0018nY:\u0016\u0003!\u0002\"!K\u0016\u000e\u0003)R!A\n\u000e\n\u00051R#aB'fiJL7m\u001d\u0005\n]\u0001\u0001\r\u00111A\u0005\n=\n1\"\\3ue&\u001c7o\u0018\u0013fcR\u0011\u0001g\r\t\u0003\u0013EJ!A\r\u0006\u0003\tUs\u0017\u000e\u001e\u0005\bi5\n\t\u00111\u0001)\u0003\rAH%\r\u0005\u0007m\u0001\u0001\u000b\u0015\u0002\u0015\u0002\u00115,GO]5dg\u0002B\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011B\u001d\u0002)\u0005\u001cG/\u001b<f)\u0016t\u0017M\u001c;t\u001b\u0006t\u0017mZ3s+\u0005Q\u0004C\u0001\n<\u0013\ta$A\u0001\u000bBGRLg/\u001a+f]\u0006tGo]'b]\u0006<WM\u001d\u0005\n}\u0001\u0001\r\u00111A\u0005\n}\n\u0001$Y2uSZ,G+\u001a8b]R\u001cX*\u00198bO\u0016\u0014x\fJ3r)\t\u0001\u0004\tC\u00045{\u0005\u0005\t\u0019\u0001\u001e\t\r\t\u0003\u0001\u0015)\u0003;\u0003U\t7\r^5wKR+g.\u00198ug6\u000bg.Y4fe\u0002BQ\u0001\u0012\u0001\u0005\u0002\u0015\u000bABY3g_J,W*\u001a;i_\u0012$\u0012\u0001\r\u0015\u0003\u0007\u001e\u0003\"\u0001S&\u000e\u0003%S!AS\u0010\u0002\u000b),h.\u001b;\n\u00051K%A\u0002\"fM>\u0014X\rC\u0003O\u0001\u0011\u0005Q)A\u0006bMR,'/T3uQ>$\u0007FA'Q!\tA\u0015+\u0003\u0002S\u0013\n)\u0011I\u001a;fe\")A\u000b\u0001C\u0001\u000b\u0006IC/Z:u\u000f\u0016$\u0018i\u0019;jm\u0016$VM\\1oiN\u0004&/\u001e8fg&s\u0017m\u0019;jm\u0016$VM\\1oiND#a\u0015,\u0011\u0005!;\u0016B\u0001-J\u0005\u0011!Vm\u001d;\t\u000bi\u0003A\u0011A#\u0002;Q,7\u000f\u001e*fG>\u0014H-Q2uSZ,G+\u001a8b]R\u001cX*\u001a;sS\u000eD#!\u0017,\t\u000bu\u0003A\u0011\u00010\u0002\u00155,GO]5d)\u0006<7\u000fF\u0002`S.\u0004B\u0001Y2gM:\u0011\u0011\"Y\u0005\u0003E*\ta\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\ri\u0015\r\u001d\u0006\u0003E*\u0001\"\u0001Y4\n\u0005!,'AB*ue&tw\rC\u0003k9\u0002\u0007a-\u0001\u0003vg\u0016\u0014\b\"\u00027]\u0001\u00041\u0017\u0001C2mS\u0016tG/\u00133")
public class ActiveTenantsManagerTest {
    private final MockTime time = new MockTime();
    private Metrics metrics;
    private ActiveTenantsManager activeTenantsManager;

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private ActiveTenantsManager activeTenantsManager() {
        return this.activeTenantsManager;
    }

    private void activeTenantsManager_$eq(ActiveTenantsManager x$1) {
        this.activeTenantsManager = x$1;
    }

    @Before
    public void beforeMethod() {
        this.metrics_$eq(new Metrics());
        this.activeTenantsManager_$eq(new ActiveTenantsManager(this.metrics(), (Time)this.time(), 2L));
    }

    @After
    public void afterMethod() {
        this.metrics().close();
    }

    @Test
    public void testGetActiveTenantsPrunesInactiveTenants() {
        Set activeTenants = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map<String, String> metricTags1 = this.metricTags("", "Client1");
        Map<String, String> metricTags2 = this.metricTags("", "Client2");
        this.activeTenantsManager().trackActiveTenant(metricTags1, this.time().milliseconds());
        activeTenants.$plus$eq(metricTags1);
        Assert.assertEquals((Object)activeTenants, (Object)this.activeTenantsManager().getActiveTenants());
        this.time().sleep(1L);
        this.activeTenantsManager().trackActiveTenant(metricTags2, this.time().milliseconds());
        activeTenants.$plus$eq(metricTags2);
        Assert.assertEquals((Object)activeTenants, (Object)this.activeTenantsManager().getActiveTenants());
        this.time().sleep(1L);
        this.activeTenantsManager().trackActiveTenant(metricTags1, this.time().milliseconds());
        activeTenants.$plus$eq(metricTags1);
        Assert.assertEquals((Object)activeTenants, (Object)this.activeTenantsManager().getActiveTenants());
        this.time().sleep(2L);
        activeTenants.$minus$eq(metricTags2);
        Assert.assertEquals((Object)activeTenants, (Object)this.activeTenantsManager().getActiveTenants());
        this.time().sleep(3L);
        activeTenants.$minus$eq(metricTags1);
        activeTenants.$minus$eq(metricTags2);
        Assert.assertEquals((Object)activeTenants, (Object)this.activeTenantsManager().getActiveTenants());
    }

    @Test
    public void testRecordActiveTenantsMetric() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=multi-tenant-metrics";
        JmxReporter reporter = new JmxReporter("kafka.server");
        this.metrics().addReporter((MetricsReporter)reporter);
        Map<String, String> metricTags1 = this.metricTags("", "Client1");
        Map<String, String> metricTags2 = this.metricTags("", "Client2");
        Assert.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assert.assertEquals((double)0.0, (double)this.numActiveTenants$1(server, mBeanName), (double)0.0);
        Assert.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.time().sleep(1L);
        this.activeTenantsManager().trackActiveTenant(metricTags1, this.time().milliseconds());
        Assert.assertEquals((double)0.0, (double)this.numActiveTenants$1(server, mBeanName), (double)0.0);
        this.time().sleep(3L);
        this.activeTenantsManager().trackActiveTenant(metricTags2, this.time().milliseconds());
        Assert.assertEquals((double)1.0, (double)this.numActiveTenants$1(server, mBeanName), (double)0.0);
    }

    public Map<String, String> metricTags(String user, String clientId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)}));
    }

    private final double numActiveTenants$1(MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), "active-tenants-count"));
    }
}

