/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u000f\ti\u0012\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\b#\u0001\u0011\r\u0011\"\u0003\u0013\u0003\u0019!x\u000e]5dcU\t1\u0003\u0005\u0002\u001535\tQC\u0003\u0002\u0017/\u0005!A.\u00198h\u0015\u0005A\u0012\u0001\u00026bm\u0006L!AG\u000b\u0003\rM#(/\u001b8h\u0011\u0019a\u0002\u0001)A\u0005'\u00059Ao\u001c9jGF\u0002\u0003b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u00121!\u00138u\u0011\u00199\u0003\u0001)A\u0005A\u0005qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0003\"B\u0015\u0001\t\u0003R\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\tYc\u0006\u0005\u0002\"Y%\u0011QF\t\u0002\u0005+:LG\u000fC\u00030Q\u0001\u0007\u0001'\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"!\r\u001b\u000e\u0003IR!aM\f\u0002\tU$\u0018\u000e\\\u0005\u0003kI\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u00159\u0004\u0001\"\u00119\u0003\u0015\u0019X\r^+q)\u0005Y\u0003F\u0001\u001c;!\tY\u0004)D\u0001=\u0015\tid(A\u0003kk:LGOC\u0001@\u0003\ry'oZ\u0005\u0003\u0003r\u0012aAQ3g_J,\u0007\"B\"\u0001\t\u0003A\u0014\u0001P:i_VdGMU3dK&4Xm\u00149fe\u0006$\u0018n\u001c8O_R\fE\u000f^3naR,Gm\u00165f]>#\b.\u001a:QCJ$\u0018\u000e^5p]\"\u000b7/\u0012:s_JD#AQ#\u0011\u0005m2\u0015BA$=\u0005\u0011!Vm\u001d;\t\u000b%\u0003A\u0011\u0002&\u0002\u001b\r\u0014X-\u0019;f%\u0016\fX/Z:u)\tYe\u000b\u0005\u0002M)6\tQJ\u0003\u0002O\u001f\u0006A!/Z9vKN$8O\u0003\u0002Q#\u000611m\\7n_:T!!\u0002*\u000b\u0005Ms\u0014AB1qC\u000eDW-\u0003\u0002V\u001b\nI\u0012\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o%\u0016\fX/Z:u\u0011\u00159\u0006\n1\u0001Y\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u00043\u0006$gB\u0001.`\u001d\tYf,D\u0001]\u0015\tif!\u0001\u0004=e>|GOP\u0005\u0002G%\u0011\u0001MI\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00117M\u0001\u0003MSN$(B\u00011#!\t)g-D\u0001P\u0013\t9wJ\u0001\bU_BL7\rU1si&$\u0018n\u001c8")
public class AddPartitionsToTxnRequestTest
extends BaseRequestTest {
    private final String topic1;
    private final int numPartitions;

    private String topic1() {
        return this.topic1;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic1(), this.numPartitions(), this.servers().size(), new Properties());
    }

    @Test
    public void shouldReceiveOperationNotAttemptedWhenOtherPartitionHasError() {
        TopicPartition nonExistentTopic = new TopicPartition("unknownTopic", 0);
        TopicPartition createdTopicPartition = new TopicPartition(this.topic1(), 0);
        AddPartitionsToTxnRequest request = this.createRequest((List<TopicPartition>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{createdTopicPartition, nonExistentTopic})));
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        AddPartitionsToTxnResponse response = (AddPartitionsToTxnResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AddPartitionsToTxnResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assert.assertEquals((long)2L, (long)response.errors().size());
        Assert.assertTrue((boolean)response.errors().containsKey(createdTopicPartition));
        Assert.assertEquals((Object)Errors.OPERATION_NOT_ATTEMPTED, response.errors().get(createdTopicPartition));
        Assert.assertTrue((boolean)response.errors().containsKey(nonExistentTopic));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.errors().get(nonExistentTopic));
    }

    private AddPartitionsToTxnRequest createRequest(List<TopicPartition> partitions) {
        String transactionalId = "foobar";
        long producerId = 1000L;
        short producerEpoch = 0;
        AddPartitionsToTxnRequest.Builder builder = new AddPartitionsToTxnRequest.Builder(transactionalId, producerId, producerEpoch, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitions).asJava());
        return (AddPartitionsToTxnRequest)builder.build();
    }

    public AddPartitionsToTxnRequestTest() {
        this.topic1 = "foobartopic";
        this.numPartitions = 3;
    }
}

