/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.server.ActiveTenantsManager;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.BrokerBackpressureMetrics$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.NonExemptRequest$;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.server.ThreadUsageMetrics$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\rEa\u0001B\u0001\u0003\u0001\u001d\u0011Qd\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0011S>$\u0006N]3bIB|w\u000e\\*ju\u0016,\u0012A\u0006\t\u0003\u0013]I!\u0001\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0004\u001b\u0001\u0001\u0006IAF\u0001\u0012S>$\u0006N]3bIB|w\u000e\\*ju\u0016\u0004\u0003b\u0002\u000f\u0001\u0005\u0004%I!F\u0001\u0016]\u0016$xo\u001c:l)\"\u0014X-\u00193q_>d7+\u001b>f\u0011\u0019q\u0002\u0001)A\u0005-\u00051b.\u001a;x_J\\G\u000b\u001b:fC\u0012\u0004xn\u001c7TSj,\u0007\u0005C\u0004!\u0001\t\u0007I\u0011B\u000b\u0002)%|G\u000b\u001b:fC\u0012\u0004xn\u001c7DCB\f7-\u001b;z\u0011\u0019\u0011\u0003\u0001)A\u0005-\u0005)\u0012n\u001c+ie\u0016\fG\r]8pY\u000e\u000b\u0007/Y2jif\u0004\u0003b\u0002\u0013\u0001\u0005\u0004%I!F\u0001\u001a]\u0016$xo\u001c:l)\"\u0014X-\u00193q_>d7)\u00199bG&$\u0018\u0010\u0003\u0004'\u0001\u0001\u0006IAF\u0001\u001b]\u0016$xo\u001c:l)\"\u0014X-\u00193q_>d7)\u00199bG&$\u0018\u0010\t\u0005\bQ\u0001\u0011\r\u0011\"\u0003\u0016\u00031i\u0017\r_)vKV,7+\u001b>f\u0011\u0019Q\u0003\u0001)A\u0005-\u0005iQ.\u0019=Rk\u0016,XmU5{K\u0002Bq\u0001\f\u0001C\u0002\u0013%Q#A\u0007u_R\fGnQ1qC\u000eLG/\u001f\u0005\u0007]\u0001\u0001\u000b\u0011\u0002\f\u0002\u001dQ|G/\u00197DCB\f7-\u001b;zA!9\u0001\u0007\u0001b\u0001\n\u0013\t\u0014\u0001\u0003;fgR,6/\u001a:\u0016\u0003I\u0002\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\t1\fgn\u001a\u0006\u0002o\u0005!!.\u0019<b\u0013\tIDG\u0001\u0004TiJLgn\u001a\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u001a\u0002\u0013Q,7\u000f^+tKJ\u0004\u0003bB\u001f\u0001\u0005\u0004%I!M\u0001\u000bi\u0016\u001cHo\u00117jK:$\bBB \u0001A\u0003%!'A\u0006uKN$8\t\\5f]R\u0004\u0003bB!\u0001\u0005\u0004%IAQ\u0001\ri\u0016\u001cH\u000fT5ti\u0016tWM]\u000b\u0002\u0007B\u0011AIT\u0007\u0002\u000b*\u0011aiR\u0001\b]\u0016$xo\u001c:l\u0015\tA\u0015*\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b)S!a\u0013'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0015aA8sO&\u0011q*\u0012\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\u0007#\u0002\u0001\u000b\u0011B\"\u0002\u001bQ,7\u000f\u001e'jgR,g.\u001a:!\u0011\u001d\u0019\u0006A1A\u0005\n\t\u000bab]3d_:$G*[:uK:,'\u000f\u0003\u0004V\u0001\u0001\u0006IaQ\u0001\u0010g\u0016\u001cwN\u001c3MSN$XM\\3sA!9q\u000b\u0001b\u0001\n\u0013A\u0016A\u0005;fgR$v\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012!\u0017\t\u00035nk\u0011aR\u0005\u00039\u001e\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004_\u0001\u0001\u0006I!W\u0001\u0014i\u0016\u001cH\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u00035!Xm\u001d;Qe&t7-\u001b9bYV\t!\r\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006!\u0011-\u001e;i\u0015\t9w)\u0001\u0005tK\u000e,(/\u001b;z\u0013\tIGM\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\r-\u0004\u0001\u0015!\u0003c\u00039!Xm\u001d;Qe&t7-\u001b9bY\u0002Bq!\u001c\u0001C\u0002\u0013%a.\u0001\u0004d_:4\u0017nZ\u000b\u0002_B\u0011!\u0003]\u0005\u0003c\n\u0011\u0001d\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000e{gNZ5h\u0011\u0019\u0019\b\u0001)A\u0005_\u000691m\u001c8gS\u001e\u0004\u0003bB;\u0001\u0005\u0004%IA\\\u0001\u0019i^|G+\u001a8b]R,e\u000e\u001a9pS:$8oQ8oM&<\u0007BB<\u0001A\u0003%q.A\ruo>$VM\\1oi\u0016sG\r]8j]R\u001c8i\u001c8gS\u001e\u0004\u0003bB=\u0001\u0005\u0004%IA\\\u0001\u0015]>\u0014\u0015mY6qe\u0016\u001c8/\u001e:f\u0007>tg-[4\t\rm\u0004\u0001\u0015!\u0003p\u0003UqwNQ1dWB\u0014Xm]:ve\u0016\u001cuN\u001c4jO\u0002Bq! \u0001C\u0002\u0013%a.\u0001\fo_R+g.\u00198u\u0019&\u001cH/\u001a8fe\u000e{gNZ5h\u0011\u0019y\b\u0001)A\u0005_\u00069bn\u001c+f]\u0006tG\u000fT5ti\u0016tWM]\"p]\u001aLw\r\t\u0005\t\u0003\u0007\u0001!\u0019!C\u0005]\u0006qan\\)v_R\f7oQ8oM&<\u0007bBA\u0004\u0001\u0001\u0006Ia\\\u0001\u0010]>\fVo\u001c;bg\u000e{gNZ5hA!Y\u00111\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0007\u0003\u0011!\u0018.\\3\u0016\u0005\u0005=\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005Uq)A\u0003vi&d7/\u0003\u0003\u0002\u001a\u0005M!\u0001C'pG.$\u0016.\\3\t\u0017\u0005u\u0001\u00011AA\u0002\u0013%\u0011qD\u0001\ti&lWm\u0018\u0013fcR!\u0011\u0011EA\u0014!\rI\u00111E\u0005\u0004\u0003KQ!\u0001B+oSRD!\"!\u000b\u0002\u001c\u0005\u0005\t\u0019AA\b\u0003\rAH%\r\u0005\t\u0003[\u0001\u0001\u0015)\u0003\u0002\u0010\u0005)A/[7fA!Y\u0011\u0011\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001a\u0003\u001diW\r\u001e:jGN,\"!!\u000e\u0011\t\u0005]\u00121H\u0007\u0003\u0003sQ1!!\rH\u0013\u0011\ti$!\u000f\u0003\u000f5+GO]5dg\"Y\u0011\u0011\t\u0001A\u0002\u0003\u0007I\u0011BA\"\u0003-iW\r\u001e:jGN|F%Z9\u0015\t\u0005\u0005\u0012Q\t\u0005\u000b\u0003S\ty$!AA\u0002\u0005U\u0002\u0002CA%\u0001\u0001\u0006K!!\u000e\u0002\u00115,GO]5dg\u0002B1\"!\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002P\u0005Y\u0011n\\\"baN+gn]8s+\t\t\t\u0006\u0005\u0003\u00028\u0005M\u0013\u0002BA+\u0003s\u0011aaU3og>\u0014\bbCA-\u0001\u0001\u0007\t\u0019!C\u0005\u00037\nq\"[8DCB\u001cVM\\:pe~#S-\u001d\u000b\u0005\u0003C\ti\u0006\u0003\u0006\u0002*\u0005]\u0013\u0011!a\u0001\u0003#B\u0001\"!\u0019\u0001A\u0003&\u0011\u0011K\u0001\rS>\u001c\u0015\r]*f]N|'\u000f\t\u0005\f\u0003K\u0002\u0001\u0019!a\u0001\n\u0013\ty%\u0001\toKR<xN]6DCB\u001cVM\\:pe\"Y\u0011\u0011\u000e\u0001A\u0002\u0003\u0007I\u0011BA6\u0003QqW\r^<pe.\u001c\u0015\r]*f]N|'o\u0018\u0013fcR!\u0011\u0011EA7\u0011)\tI#a\u001a\u0002\u0002\u0003\u0007\u0011\u0011\u000b\u0005\t\u0003c\u0002\u0001\u0015)\u0003\u0002R\u0005\tb.\u001a;x_J\\7)\u00199TK:\u001cxN\u001d\u0011\t\u0017\u0005U\u0004\u00011AA\u0002\u0013%\u0011qO\u0001\u0015C\u000e$\u0018N^3UK:\fg\u000e^:NC:\fw-\u001a:\u0016\u0005\u0005e\u0004c\u0001\n\u0002|%\u0019\u0011Q\u0010\u0002\u0003)\u0005\u001bG/\u001b<f)\u0016t\u0017M\u001c;t\u001b\u0006t\u0017mZ3s\u0011-\t\t\t\u0001a\u0001\u0002\u0004%I!a!\u00021\u0005\u001cG/\u001b<f)\u0016t\u0017M\u001c;t\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0005\u0015\u0005BCA\u0015\u0003\u007f\n\t\u00111\u0001\u0002z!A\u0011\u0011\u0012\u0001!B\u0013\tI(A\u000bbGRLg/\u001a+f]\u0006tGo]'b]\u0006<WM\u001d\u0011\t\u0017\u00055\u0005\u00011AA\u0002\u0013%\u0011qR\u0001\u0014e\u0016\fX/Z:u#V|G/Y'b]\u0006<WM]\u000b\u0003\u0003#\u00032AEAJ\u0013\r\t)J\u0001\u0002\u001a\u00072LWM\u001c;SKF,Xm\u001d;Rk>$\u0018-T1oC\u001e,'\u000fC\u0006\u0002\u001a\u0002\u0001\r\u00111A\u0005\n\u0005m\u0015a\u0006:fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014x\fJ3r)\u0011\t\t#!(\t\u0015\u0005%\u0012qSA\u0001\u0002\u0004\t\t\n\u0003\u0005\u0002\"\u0002\u0001\u000b\u0015BAI\u0003Q\u0011X-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3sA!9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0016\u0001\u00042fM>\u0014X-T3uQ>$GCAA\u0011Q\u0011\t\u0019+a+\u0011\t\u00055\u00161W\u0007\u0003\u0003_S1!!-M\u0003\u0015QWO\\5u\u0013\u0011\t),a,\u0003\r\t+gm\u001c:f\u0011\u001d\tI\f\u0001C\u0001\u0003O\u000b1\"\u00194uKJlU\r\u001e5pI\"\"\u0011qWA_!\u0011\ti+a0\n\t\u0005\u0005\u0017q\u0016\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003\u000b\u0004A\u0011BAT\u0003!\u0012Xm\u0019:fCR,'+Z9vKN$\u0018+^8uC6\u000bg.Y4fe^KG\u000f[8viF+x\u000e^1t\u0011\u001d\tI\r\u0001C\u0005\u0003O\u000baF]3de\u0016\fG/\u001a*fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014x+\u001b;i_V$()Y2laJ,7o];sK\"9\u0011Q\u001a\u0001\u0005\n\u0005\u001d\u0016\u0001\r:fGJ,\u0017\r^3SKF,Xm\u001d;Rk>$\u0018-T1oC\u001e,'oV5uQ>,H\u000fV3oC:$H*[:uK:,'\u000fC\u0004\u0002R\u0002!I!a*\u0002aI,7M]3bi\u0016\u0014V-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3s/&$\b\u000eV<p)\u0016t\u0017M\u001c;F]B|\u0017N\u001c;t\u0011\u001d\t)\u000e\u0001C\u0001\u0003O\u000b1\b^3ti\n\u000b7m\u001b9sKN\u001cXO]3Jg\u0012K7/\u00192mK\u0012Le\u000eR3gCVdGo\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000e{gNZ5hQ\u0011\t\u0019.!7\u0011\t\u00055\u00161\\\u0005\u0005\u0003;\fyK\u0001\u0003UKN$\bbBAq\u0001\u0011\u0005\u0011qU\u0001*i\u0016\u001cH/Q;u_R+h.\u001a*fcV,7\u000f^)v_R\f\u0017\t\u001c7BE>4XMR1je2KW.\u001b;)\t\u0005}\u0017\u0011\u001c\u0005\b\u0003O\u0004A\u0011AAT\u00039\"Xm\u001d;BkR|G+\u001e8f%\u0016\fX/Z:u#V|G/Y!c_Z,\u0017I\u001c3CK2|wOR1je2KW.\u001b;)\t\u0005\u0015\u0018\u0011\u001c\u0005\b\u0003[\u0004A\u0011AAT\u0003%\"Xm\u001d;BkR|G+\u001e8f%\u0016\fX/Z:u#V|G/Y!mY\n+Gn\\<GC&\u0014H*[7ji\"\"\u00111^Am\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003O\u000b\u0001\u0006^3ti\n\u0013xn[3s#V|G/\u0019'j[&$\u0018j]%oSRL\u0017\r\u001c7z+:d\u0017.\\5uK\u0012DC!!=\u0002Z\"9\u0011\u0011 \u0001\u0005\u0002\u0005\u001d\u0016a\u000e;fgR\u0014%o\\6feF+x\u000e^1MS6LG/S:Va\u0012\fG/\u001a3XQ\u0016t')Y2laJ,7o];sK&\u001bH)[:bE2,G\r\u000b\u0003\u0002x\u0006e\u0007bBA\u0000\u0001\u0011\u0005\u0011qU\u0001>i\u0016\u001cHO\u0011:pW\u0016\u0014\u0018+^8uC2KW.\u001b;Jg:{G/\u00169eCR,G-\u00134UK:\fg\u000e\u001e'jgR,g.\u001a:O_R\u001cuN\u001c4jOV\u0014X\r\u001a\u0015\u0005\u0003{\fI\u000eC\u0004\u0003\u0006\u0001!\t!a*\u0002\tR,7\u000f\u001e(p]\u0016CX-\u001c9u%\u0016\fX/Z:u#V|G/Y:ESN\f'\r\\3e%\u0016\u001cwN\u001d3t)>$\u0018\r\u001c+ie\u0016\fG-V:bO\u0016lU\r\u001e:jGN|e\u000e\\=)\t\t\r\u0011\u0011\u001c\u0005\b\u0005\u0017\u0001A\u0011AAT\u0003\u0011#Xm\u001d;Fq\u0016l\u0007\u000f\u001e*fcV,7\u000f^,ji\"\fVo\u001c;bg\u0016s\u0017M\u00197fIJ+7m\u001c:egR{G/\u00197UQJ,\u0017\rZ+tC\u001e,W*\u001a;sS\u000e\u001cxJ\u001c7zQ\u0011\u0011I!!7\t\u000f\tE\u0001\u0001\"\u0001\u0002(\u0006\tE/Z:u\u001d>tW\t_3naR\u0014V-];fgR<\u0016\u000e\u001e5Rk>$\u0018m]#oC\ndW\r\u001a*fG>\u0014Hm]!mYRC'/Z1e+N\fw-Z'fiJL7m\u001d\u0015\u0005\u0005\u001f\tI\u000eC\u0004\u0003\u0018\u0001!\t!a*\u0002qQ,7\u000f\u001e\"s_.,'/U;pi\u0006d\u0015.\\5u\u000b:\u001cXO]3t\u0013>$\u0006N]3bIB|w\u000e\\%t\u001d>$xJ^3s+RLG.\u001b>fI\"\"!QCAm\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003O\u000bQ\b^3ti\n\u0013xn[3s#V|G/\u0019'j[&$XI\\:ve\u0016\u001ch*\u001a;x_J\\G\u000b\u001b:fC\u0012\u0004xn\u001c7Jg:{Go\u0014<feV#\u0018\u000e\\5{K\u0012DCAa\u0007\u0002Z\"9!1\u0005\u0001\u0005\u0002\u0005\u001d\u0016a\u000b;fgR\u0014%o\\6feF+x\u000e^1MS6LG\u000fR8fg:{GOR1mY\n+Gn\\<NS:,X.^7)\t\t\u0005\u0012\u0011\u001c\u0005\b\u0005S\u0001A\u0011AAT\u0003!#Xm\u001d;OKR<xN]6UQJ,\u0017\rZ+tC\u001e,gI]8n\u001d>tG+\u001a8b]R,e\u000e\u001a9pS:$Hi\\3t\u001d>$\u0018I\u001a4fGR\u0014%o\\6feF+x\u000e^1MS6LG\u000f\u000b\u0003\u0003(\u0005e\u0007b\u0002B\u0018\u0001\u0011\u0005\u0011qU\u0001Hi\u0016\u001cH/\u00169eCR,\u0017\t\u001a6vgR,GmQ1qC\u000eLG/\u001f#pKNtu\u000e^!eUV\u001cH\u000fT5nSR<\u0006.\u001a8Rk\u0016,XmU5{K\n+Gn\\<UQJ,7\u000f[8mI\"\"!QFAm\u0011\u001d\u0011)\u0004\u0001C\u0001\u0003O\u000bq\u000b^3tiV\u0003H-\u0019;f\u0003\u0012TWo\u001d;fI\u000e\u000b\u0007/Y2jif$Um\u0019:fCN,7\u000fT5nSR$UO]5oOJ+\u0017/^3ti>3XM\u001d7pC\u0012\fe\u000e\u001a\"bG.\u001cxJ\u001a4EkJLgnZ+oI\u0016\u0014Hn\\1eQ\u0011\u0011\u0019$!7\t\u000f\tm\u0002\u0001\"\u0001\u0002(\u0006\tD/Z:u\u0005J|7.\u001a:SKF,Xm\u001d;MS6LG/S:BI*,8\u000f^3e\u001f:\u0014V-];fgR|e/\u001a:m_\u0006$\u0007\u0006\u0002B\u001d\u00033DqA!\u0011\u0001\t\u0003\t9+A\u0017uKN$(I]8lKJ\u0014V-];fgRd\u0015.\\5u\t>,7OT8u\r\u0006dGNQ3m_^l\u0015N\\5nk6DCAa\u0010\u0002Z\"9!q\t\u0001\u0005\u0002\u0005\u001d\u0016a\u0007;fgRlU\u000f\u001c;ja2,G+\u001a8b]R,e\u000e\u001a9pS:$8\u000f\u000b\u0003\u0003F\u0005e\u0007b\u0002B'\u0001\u0011\u0005\u0011qU\u0001\u001ai\u0016\u001cHOU3n_Z,G*[:uK:,'/T3ue&\u001c7\u000f\u000b\u0003\u0003L\u0005e\u0007b\u0002B*\u0001\u0011%!QK\u0001#g&lW\u000f\\1uKRKW.Z(o%\u0016\fX/Z:u\u0011\u0006tG\r\\3s)\"\u0014X-\u00193\u0015\r\u0005\u0005\"q\u000bB7\u0011!\u0011IF!\u0015A\u0002\tm\u0013a\u0002:fcV,7\u000f\u001e\t\u0005\u0005;\u00129G\u0004\u0003\u0003`\t\rTB\u0001B1\u0015\t1E!\u0003\u0003\u0003f\t\u0005\u0014A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0005S\u0012YGA\u0004SKF,Xm\u001d;\u000b\t\t\u0015$\u0011\r\u0005\t\u0005_\u0012\t\u00061\u0001\u0003r\u0005\u0011Qn\u001d\t\u0004\u0013\tM\u0014b\u0001B;\u0015\t!Aj\u001c8h\u0011\u001d\u0011I\b\u0001C\u0005\u0005w\nQ$Y:tKJ$()Y2laJ,7o];sK6+GO]5d-\u0006dW/\u001a\u000b\t\u0003C\u0011iH!$\u0003\u001e\"A!q\u0010B<\u0001\u0004\u0011\t)\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004BAa!\u0003\n:\u0019\u0011B!\"\n\u0007\t\u001d%\"\u0001\u0004Qe\u0016$WMZ\u0005\u0004s\t-%b\u0001BD\u0015!A!q\u0012B<\u0001\u0004\u0011\t*\u0001\tfqB,7\r^3e-\u0006dW/Z(qiB)\u0011Ba%\u0003\u0018&\u0019!Q\u0013\u0006\u0003\r=\u0003H/[8o!\rI!\u0011T\u0005\u0004\u00057S!A\u0002#pk\ndW\r\u0003\u0005\u0003 \n]\u0004\u0019\u0001BL\u0003\u0015!W\r\u001c;b\u0011\u001d\u0011\u0019\u000b\u0001C\u0005\u0005K\u000b!C\u0019:pW\u0016\u0014(+Z9vKN$H*[7jiV\u0011!q\u0013\u0005\b\u0005S\u0003A\u0011\u0002BV\u0003y\t7o]3si&{G\u000b\u001b:fC\u0012,6/Y4f\u001b\u0016$(/[2WC2,X\r\u0006\u0005\u0002\"\t5&q\u0016BY\u0011!\u0011yHa*A\u0002\t\u0005\u0005\u0002\u0003BH\u0005O\u0003\rA!%\t\u0011\t}%q\u0015a\u0001\u0005/CqA!.\u0001\t\u0013\u00119,A\u0012bgN,'\u000f\u001e(fi^|'o\u001b+ie\u0016\fG-V:bO\u0016lU\r\u001e:jGZ\u000bG.^3\u0015\u0011\u0005\u0005\"\u0011\u0018B^\u0005{C\u0001Ba \u00034\u0002\u0007!\u0011\u0011\u0005\t\u0005\u001f\u0013\u0019\f1\u0001\u0003\u0012\"A!q\u0014BZ\u0001\u0004\u00119\nC\u0004\u00036\u0002!IA!1\u0015\u0015\u0005\u0005\"1\u0019Bc\u0005\u0013\u0014Y\r\u0003\u0005\u0003\u0000\t}\u0006\u0019\u0001BA\u0011!\u00119Ma0A\u0002\t\u0005\u0015\u0001\u00037jgR,g.\u001a:\t\u0011\t=%q\u0018a\u0001\u0005#C\u0001Ba(\u0003@\u0002\u0007!q\u0013\u0005\b\u0005\u001f\u0004A\u0011\u0002Bi\u0003E\t7o]3si6+GO]5d-\u0006dW/\u001a\u000b\r\u0003C\u0011\u0019N!6\u0003Z\n\r(Q\u001d\u0005\t\u0005\u007f\u0012i\r1\u0001\u0003\u0002\"A!q\u001bBg\u0001\u0004\u0011\t)A\u0003he>,\b\u000f\u0003\u0005\u0003\\\n5\u0007\u0019\u0001Bo\u0003)iW\r\u001e:jGR\u000bwm\u001d\t\t\u0005\u0007\u0013yN!!\u0003\u0002&!!\u0011\u001dBF\u0005\ri\u0015\r\u001d\u0005\t\u0005\u001f\u0013i\r1\u0001\u0003\u0012\"A!q\u0014Bg\u0001\u0004\u00119\nC\u0004\u0003j\u0002!IAa;\u0002\u0019\t,\u0018\u000e\u001c3SKF,Xm\u001d;\u0015\u0005\tm\u0003b\u0002Bu\u0001\u0011%!q\u001e\u000b\u0005\u00057\u0012\t\u0010C\u0004\u0003t\n5\b\u0019A\"\u0002\u00191L7\u000f^3oKJt\u0015-\\3\t\u000f\t]\b\u0001\"\u0003\u0003z\u0006YQ.Y=cKJ+7m\u001c:e)\u001d1\"1 B\u0000\u0007\u0007A\u0001B!@\u0003v\u0002\u0007!\u0011Q\u0001\u0005kN,'\u000f\u0003\u0005\u0004\u0002\tU\b\u0019\u0001BA\u0003!\u0019G.[3oi&#\u0007\u0002CB\u0003\u0005k\u0004\rAa&\u0002\u000bY\fG.^3\t\u000f\r%\u0001\u0001\"\u0001\u0004\f\u0005yQ.\u001b7mSN$v\u000eU3sG\u0016tG\u000f\u0006\u0003\u0003\u0018\u000e5\u0001\u0002CB\b\u0007\u000f\u0001\rAa&\u0002\r5LG\u000e\\5t\u0001")
public class ClientRequestQuotaManagerTest {
    private final int ioThreadpoolSize;
    private final int networkThreadpoolSize;
    private final int ioThreadpoolCapacity = this.ioThreadpoolSize() * 100;
    private final int networkThreadpoolCapacity = this.networkThreadpoolSize() * 100;
    private final int maxQueueSize;
    private final int totalCapacity = this.ioThreadpoolCapacity() + this.networkThreadpoolCapacity();
    private final String testUser;
    private final String testClient;
    private final ListenerName testListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final ListenerName secondListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT);
    private final TopicPartition testTopicPartition = new TopicPartition("test-topic", 0);
    private final KafkaPrincipal testPrincipal = new KafkaPrincipal("User", this.testUser());
    private final ClientQuotaManagerConfig kafka$server$ClientRequestQuotaManagerTest$$config;
    private final ClientQuotaManagerConfig twoTenantEndpointsConfig;
    private final ClientQuotaManagerConfig noBackpressureConfig;
    private final ClientQuotaManagerConfig noTenantListenerConfig;
    private final ClientQuotaManagerConfig noQuotasConfig;
    private MockTime kafka$server$ClientRequestQuotaManagerTest$$time;
    private Metrics metrics;
    private Sensor ioCapSensor;
    private Sensor networkCapSensor;
    private ActiveTenantsManager activeTenantsManager;
    private ClientRequestQuotaManager kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager;

    private int ioThreadpoolSize() {
        return this.ioThreadpoolSize;
    }

    private int networkThreadpoolSize() {
        return this.networkThreadpoolSize;
    }

    private int ioThreadpoolCapacity() {
        return this.ioThreadpoolCapacity;
    }

    private int networkThreadpoolCapacity() {
        return this.networkThreadpoolCapacity;
    }

    private int maxQueueSize() {
        return this.maxQueueSize;
    }

    private int totalCapacity() {
        return this.totalCapacity;
    }

    private String testUser() {
        return this.testUser;
    }

    private String testClient() {
        return this.testClient;
    }

    private ListenerName testListener() {
        return this.testListener;
    }

    private ListenerName secondListener() {
        return this.secondListener;
    }

    private TopicPartition testTopicPartition() {
        return this.testTopicPartition;
    }

    private KafkaPrincipal testPrincipal() {
        return this.testPrincipal;
    }

    public ClientQuotaManagerConfig kafka$server$ClientRequestQuotaManagerTest$$config() {
        return this.kafka$server$ClientRequestQuotaManagerTest$$config;
    }

    private ClientQuotaManagerConfig twoTenantEndpointsConfig() {
        return this.twoTenantEndpointsConfig;
    }

    private ClientQuotaManagerConfig noBackpressureConfig() {
        return this.noBackpressureConfig;
    }

    private ClientQuotaManagerConfig noTenantListenerConfig() {
        return this.noTenantListenerConfig;
    }

    private ClientQuotaManagerConfig noQuotasConfig() {
        return this.noQuotasConfig;
    }

    public MockTime kafka$server$ClientRequestQuotaManagerTest$$time() {
        return this.kafka$server$ClientRequestQuotaManagerTest$$time;
    }

    private void kafka$server$ClientRequestQuotaManagerTest$$time_$eq(MockTime x$1) {
        this.kafka$server$ClientRequestQuotaManagerTest$$time = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private Sensor ioCapSensor() {
        return this.ioCapSensor;
    }

    private void ioCapSensor_$eq(Sensor x$1) {
        this.ioCapSensor = x$1;
    }

    private Sensor networkCapSensor() {
        return this.networkCapSensor;
    }

    private void networkCapSensor_$eq(Sensor x$1) {
        this.networkCapSensor = x$1;
    }

    private ActiveTenantsManager activeTenantsManager() {
        return this.activeTenantsManager;
    }

    private void activeTenantsManager_$eq(ActiveTenantsManager x$1) {
        this.activeTenantsManager = x$1;
    }

    public ClientRequestQuotaManager kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager() {
        return this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager;
    }

    private void kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager_$eq(ClientRequestQuotaManager x$1) {
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager = x$1;
    }

    @Before
    public void beforeMethod() {
        this.kafka$server$ClientRequestQuotaManagerTest$$time_$eq(new MockTime());
        this.metrics_$eq(new Metrics(new MetricConfig().timeWindow(1L, TimeUnit.SECONDS), Collections.emptyList(), (Time)this.kafka$server$ClientRequestQuotaManagerTest$$time()));
        this.activeTenantsManager_$eq(new ActiveTenantsManager(this.metrics(), (Time)this.kafka$server$ClientRequestQuotaManagerTest$$time(), 10000L));
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager_$eq(new ClientRequestQuotaManager(this.kafka$server$ClientRequestQuotaManagerTest$$config(), this.metrics(), (Time)this.kafka$server$ClientRequestQuotaManagerTest$$time(), "", (Option)None$.MODULE$, (Option)new Some((Object)this.activeTenantsManager())));
        this.ioCapSensor_$eq(this.metrics().sensor("TotalIoThreadsPercentage"));
        this.ioCapSensor().add(ThreadUsageMetrics$.MODULE$.ioThreadPoolCapacityMetricName(this.metrics()), (MeasurableStat)new Value());
        this.ioCapSensor().record((double)this.ioThreadpoolCapacity());
        this.networkCapSensor_$eq(this.metrics().sensor("TotalNetworkThreadsPercentage"));
        this.networkCapSensor().add(ThreadUsageMetrics$.MODULE$.networkThreadPoolCapacityMetricName(this.metrics(), this.testListener().value()), (MeasurableStat)new Value());
        this.networkCapSensor().record((double)this.networkThreadpoolCapacity());
    }

    @After
    public void afterMethod() {
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().shutdown();
        this.metrics().close();
    }

    private void recreateRequestQuotaManagerWithoutQuotas() {
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().shutdown();
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager_$eq(new ClientRequestQuotaManager(this.noQuotasConfig(), this.metrics(), (Time)this.kafka$server$ClientRequestQuotaManagerTest$$time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$));
    }

    private void recreateRequestQuotaManagerWithoutBackpressure() {
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().shutdown();
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager_$eq(new ClientRequestQuotaManager(this.noBackpressureConfig(), this.metrics(), (Time)this.kafka$server$ClientRequestQuotaManagerTest$$time(), "", (Option)None$.MODULE$, (Option)new Some((Object)this.activeTenantsManager())));
    }

    private void recreateRequestQuotaManagerWithoutTenantListener() {
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().shutdown();
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager_$eq(new ClientRequestQuotaManager(this.noTenantListenerConfig(), this.metrics(), (Time)this.kafka$server$ClientRequestQuotaManagerTest$$time(), "", (Option)None$.MODULE$, (Option)new Some((Object)this.activeTenantsManager())));
    }

    private void recreateRequestQuotaManagerWithTwoTenantEnpoints() {
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().shutdown();
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager_$eq(new ClientRequestQuotaManager(this.twoTenantEndpointsConfig(), this.metrics(), (Time)this.kafka$server$ClientRequestQuotaManagerTest$$time(), "", (Option)None$.MODULE$, (Option)new Some((Object)this.activeTenantsManager())));
        this.networkCapSensor().add(ThreadUsageMetrics$.MODULE$.networkThreadPoolCapacityMetricName(this.metrics(), this.secondListener().value()), (MeasurableStat)new Value());
        this.networkCapSensor().record((double)this.networkThreadpoolCapacity());
    }

    @Test
    public void testBackpressureIsDisabledInDefaultClientQuotaManagerConfig() {
        ClientQuotaManagerConfig defaultConfig = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4());
        Assert.assertFalse((boolean)defaultConfig.backpressureConfig().backpressureEnabledInConfig());
    }

    @Test
    public void testAutoTuneRequestQuotaAllAboveFairLimit() {
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().nonExemptCapacitySensor().record(1200.0);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateQuota((Option)new Some((Object)"UserA"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)Quota.upperBound((double)800.0)));
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateQuota((Option)new Some((Object)"UserB"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)Quota.upperBound((double)800.0)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                int throttleTime1 = this.$outer.kafka$server$ClientRequestQuotaManagerTest$$maybeRecord("UserA", "Client1", this.$outer.millisToPercent(7000.0));
                int throttleTime2 = this.$outer.kafka$server$ClientRequestQuotaManagerTest$$maybeRecord("UserB", "Client2", this.$outer.millisToPercent(7000.0));
                this.$outer.kafka$server$ClientRequestQuotaManagerTest$$time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeAutoTuneQuota(this.activeTenantsManager(), this.kafka$server$ClientRequestQuotaManagerTest$$time().milliseconds());
        Assert.assertEquals((double)600.0, (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().dynamicQuota("UserA", "Client1").bound(), (double)0.0);
        Assert.assertEquals((double)600.0, (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().dynamicQuota("UserB", "Client2").bound(), (double)0.0);
        BrokerBackpressureConfig newBackpressureConfig = new BrokerBackpressureConfig(false, BrokerBackpressureConfig$.MODULE$.apply$default$2(), BrokerBackpressureConfig$.MODULE$.apply$default$3(), BrokerBackpressureConfig$.MODULE$.apply$default$4());
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBackpressureConfig(newBackpressureConfig);
        Assert.assertEquals((double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().quota("UserA", "Client1").bound(), (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().dynamicQuota("UserA", "Client1").bound(), (double)1.0E-8);
        Assert.assertEquals((double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().quota("UserB", "Client2").bound(), (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().dynamicQuota("UserB", "Client2").bound(), (double)1.0E-8);
    }

    @Test
    public void testAutoTuneRequestQuotaAboveAndBelowFairLimit() {
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().nonExemptCapacitySensor().record(1200.0);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateQuota((Option)new Some((Object)"UserA"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)Quota.upperBound((double)800.0)));
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateQuota((Option)new Some((Object)"UserB"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)Quota.upperBound((double)800.0)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                int throttleTime1 = this.$outer.kafka$server$ClientRequestQuotaManagerTest$$maybeRecord("UserA", "Client1", this.$outer.millisToPercent(7500.0));
                int throttleTime2 = this.$outer.kafka$server$ClientRequestQuotaManagerTest$$maybeRecord("UserB", "Client2", this.$outer.millisToPercent(5000.0));
                this.$outer.kafka$server$ClientRequestQuotaManagerTest$$time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeAutoTuneQuota(this.activeTenantsManager(), this.kafka$server$ClientRequestQuotaManagerTest$$time().milliseconds());
        Assert.assertEquals((double)700.0, (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().dynamicQuota("UserA", "Client1").bound(), (double)1.0E-8);
        Assert.assertEquals((double)600.0, (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().dynamicQuota("UserB", "Client2").bound(), (double)1.0E-8);
    }

    @Test
    public void testAutoTuneRequestQuotaAllBelowFairLimit() {
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().nonExemptCapacitySensor().record(1200.0);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateQuota((Option)new Some((Object)"UserA"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)Quota.upperBound((double)800.0)));
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateQuota((Option)new Some((Object)"UserB"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)Quota.upperBound((double)800.0)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                int throttleTime1 = this.$outer.kafka$server$ClientRequestQuotaManagerTest$$maybeRecord("UserA", "Client1", this.$outer.millisToPercent(1000.0));
                int throttleTime2 = this.$outer.kafka$server$ClientRequestQuotaManagerTest$$maybeRecord("UserB", "Client2", this.$outer.millisToPercent(1000.0));
                this.$outer.kafka$server$ClientRequestQuotaManagerTest$$time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeAutoTuneQuota(this.activeTenantsManager(), this.kafka$server$ClientRequestQuotaManagerTest$$time().milliseconds());
        Assert.assertEquals((double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().quota("UserA", "Client1").bound(), (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().dynamicQuota("UserA", "Client1").bound(), (double)1.0E-8);
        Assert.assertEquals((double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().quota("UserB", "Client2").bound(), (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().dynamicQuota("UserB", "Client2").bound(), (double)1.0E-8);
    }

    @Test
    public void testBrokerQuotaLimitIsInitiallyUnlimited() {
        Assert.assertEquals((double)Double.MAX_VALUE, (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().getBrokerQuotaLimit(), (double)1.0);
    }

    @Test
    public void testBrokerQuotaLimitIsUpdatedWhenBackpressureIsDisabled() {
        this.recreateRequestQuotaManagerWithoutBackpressure();
        Assert.assertFalse((boolean)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().backpressureEnabled());
        Assert.assertEquals((double)Double.MAX_VALUE, (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().getBrokerQuotaLimit(), (double)1.0);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(this.noBackpressureConfig().backpressureConfig().backpressureCheckFrequencyMs() + 100L);
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 2L);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request);
        double expectedBrokerQuotaLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        Assert.assertEquals((double)expectedBrokerQuotaLimit, (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().getBrokerQuotaLimit(), (double)0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(1L);
        request.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Function1<Object, BoxedUnit> record) {
                record.apply$mcVJ$sp(1000000L);
            }
        });
        Assert.assertEquals((double)expectedBrokerQuotaLimit, (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().getBrokerQuotaLimit(), (double)0.01);
    }

    @Test
    public void testBrokerQuotaLimitIsNotUpdatedIfTenantListenerNotConfigured() {
        this.recreateRequestQuotaManagerWithoutTenantListener();
        Assert.assertFalse((boolean)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().backpressureEnabled());
        Assert.assertEquals((double)Double.MAX_VALUE, (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().getBrokerQuotaLimit(), (double)1.0);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(this.noTenantListenerConfig().backpressureConfig().backpressureCheckFrequencyMs() + 100L);
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 2L);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request);
        Assert.assertEquals((double)Double.MAX_VALUE, (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().getBrokerQuotaLimit(), (double)1.0);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(1L);
        request.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Function1<Object, BoxedUnit> record) {
                record.apply$mcVJ$sp(1000000L);
            }
        });
        Assert.assertEquals((double)Double.MAX_VALUE, (double)this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().getBrokerQuotaLimit(), (double)1.0);
    }

    @Test
    public void testNonExemptRequestQuotasDisabledRecordsTotalThreadUsageMetricsOnly() {
        this.recreateRequestQuotaManagerWithoutQuotas();
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 1L);
        int throttleMs = this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request);
        Assert.assertEquals((long)0L, (long)throttleMs);
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)None$.MODULE$, 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)None$.MODULE$, 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(2L);
        request.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Function1<Object, BoxedUnit> record) {
                record.apply$mcVJ$sp(2000000L);
            }
        });
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)None$.MODULE$, 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)None$.MODULE$, 0.01);
    }

    @Test
    public void testExemptRequestWithQuotasEnabledRecordsTotalThreadUsageMetricsOnly() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 2L);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordExempt(request);
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)None$.MODULE$, 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        double expectedBrokerQuotaLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() - 0.2;
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(1L);
        request.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Function1<Object, BoxedUnit> record) {
                record.apply$mcVJ$sp(1000000L);
            }
        });
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)None$.MODULE$, 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        double updatedBrokerLimit = expectedBrokerQuotaLimit - 0.1;
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)updatedBrokerLimit)), 0.01);
    }

    @Test
    public void testNonExemptRequestWithQuotasEnabledRecordsAllThreadUsageMetrics() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 2L);
        int throttleMs = this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request);
        Assert.assertEquals((long)0L, (long)throttleMs);
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        double expectedBrokerQuotaLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(1L);
        request.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Function1<Object, BoxedUnit> record) {
                record.apply$mcVJ$sp(1000000L);
            }
        });
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
    }

    @Test
    public void testBrokerQuotaLimitEnsuresIoThreadpoolIsNotOverUtilized() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 1000L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach$mVc$sp((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;
            private final RequestChannel.Request request$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                int throttleMs = this.$outer.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(this.request$1);
                Assert.assertEquals((long)0L, (long)throttleMs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
            }
        });
        double expectedIoThreadpoolUsage = (double)this.ioThreadpoolSize() * 100.0;
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(1L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.request$1.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Function1<Object, BoxedUnit> record) {
                        record.apply$mcVJ$sp(1000000L);
                    }
                });
            }
            {
                this.request$1 = request$1;
            }
        });
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedIoThreadpoolUsage)), 1.0);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedIoThreadpoolUsage)), 1.0);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        double expectedLimit = (double)this.ioThreadpoolCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() + 0.4;
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedLimit)), 1.0);
    }

    @Test
    public void testBrokerQuotaLimitEnsuresNetworkThreadpoolIsNotOverUtilized() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 10L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.ioThreadpoolSize()).foreach$mVc$sp((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;
            private final RequestChannel.Request request$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                int throttleMs = this.$outer.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(this.request$2);
                Assert.assertEquals((long)0L, (long)throttleMs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$2 = request$2;
            }
        });
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(1000L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.networkThreadpoolSize()).foreach$mVc$sp((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.request$2.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Function1<Object, BoxedUnit> record) {
                        record.apply$mcVJ$sp(1000000000L);
                    }
                });
            }
            {
                this.request$2 = request$2;
            }
        });
        double expectedNetworkThreadpoolUsage = (double)this.networkThreadpoolSize() * 100.0;
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)8.0)), 0.1);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)8.0)), 0.1);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedNetworkThreadpoolUsage)), 1.0);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedNetworkThreadpoolUsage)), 1.0);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        double expectedLimit = (double)this.networkThreadpoolCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() + 8.0;
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedLimit)), 1.0);
    }

    @Test
    public void testBrokerQuotaLimitDoesNotFallBelowMinumum() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 1000L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.ioThreadpoolSize()).foreach$mVc$sp((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;
            private final RequestChannel.Request request$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.$outer.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordExempt(this.request$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$3 = request$3;
            }
        });
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(1000L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.networkThreadpoolSize()).foreach$mVc$sp((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.request$3.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Function1<Object, BoxedUnit> record) {
                        record.apply$mcVJ$sp(1000000000L);
                    }
                });
            }
            {
                this.request$3 = request$3;
            }
        });
        double expectedIoThreadpoolUsage = (double)this.ioThreadpoolSize() * 100.0;
        double expectedNetworkThreadpoolUsage = (double)this.networkThreadpoolSize() * 100.0;
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedIoThreadpoolUsage)), 1.0);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)None$.MODULE$, 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedNetworkThreadpoolUsage)), 1.0);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        double expectedLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMinNonExemptRequestUtilization();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedLimit)), 1.0);
    }

    @Test
    public void testNetworkThreadUsageFromNonTenantEndpointDoesNotAffectBrokerQuotaLimit() {
        RequestChannel.Request request = this.buildRequest(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT));
        this.simulateTimeOnRequestHandlerThread(request, 10L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.ioThreadpoolSize()).foreach$mVc$sp((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;
            private final RequestChannel.Request request$4;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                int throttleMs = this.$outer.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(this.request$4);
                Assert.assertEquals((long)0L, (long)throttleMs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$4 = request$4;
            }
        });
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(1000L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.networkThreadpoolSize()).foreach$mVc$sp((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$4;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.request$4.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Function1<Object, BoxedUnit> record) {
                        record.apply$mcVJ$sp(1000000000L);
                    }
                });
            }
            {
                this.request$4 = request$4;
            }
        });
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)8.0)), 0.1);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)8.0)), 0.1);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 1.0);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 1.0);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        double expectedLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedLimit)), 1.0);
    }

    @Test
    public void testUpdateAdjustedCapacityDoesNotAdjustLimitWhenQueueSizeBelowThreshold() {
        double brokerRequestLimit = 800.0;
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Percentiles queueSizePercentiles = RequestQueueSizePercentiles$.MODULE$.createPercentiles(this.metrics(), this.maxQueueSize(), SocketServer$.MODULE$.DataPlaneMetricPrefix());
        queueSizeSensor.add((CompoundStat)queueSizePercentiles);
        double correctedLimit = this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateAdjustedCapacity(brokerRequestLimit);
        Assert.assertEquals((String)"Expected no request limit correction during no request load", (double)brokerRequestLimit, (double)correctedLimit, (double)0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)new Serializable(this, queueSizeSensor){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;
            private final Sensor queueSizeSensor$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.queueSizeSensor$1.record(this.$outer.kafka$server$ClientRequestQuotaManagerTest$$config().backpressureConfig().queueSizeCap() - 1.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queueSizeSensor$1 = queueSizeSensor$1;
            }
        });
        double newCorrectedLimit = this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateAdjustedCapacity(brokerRequestLimit);
        Assert.assertEquals((String)"Expected no request limit correction when queue load is below the threshold", (double)brokerRequestLimit, (double)newCorrectedLimit, (double)0.0);
    }

    @Test
    public void testUpdateAdjustedCapacityDecreasesLimitDuringRequestOverloadAndBacksOffDuringUnderload() {
        int mult = 10;
        double brokerRequestLimit = BrokerBackpressureConfig$.MODULE$.DefaultMinRequestQuotaLimit() + (double)mult * BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment();
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Percentiles queueSizePercentiles = RequestQueueSizePercentiles$.MODULE$.createPercentiles(this.metrics(), this.maxQueueSize(), SocketServer$.MODULE$.DataPlaneMetricPrefix());
        queueSizeSensor.add((CompoundStat)queueSizePercentiles);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)new Serializable(this, queueSizeSensor){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;
            private final Sensor queueSizeSensor$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.queueSizeSensor$2.record(this.$outer.kafka$server$ClientRequestQuotaManagerTest$$config().backpressureConfig().queueSizeCap() + 1.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queueSizeSensor$2 = queueSizeSensor$2;
            }
        });
        DoubleRef expectedLimit = DoubleRef.create((double)brokerRequestLimit);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mult).foreach$mVc$sp((Function1)new Serializable(this, brokerRequestLimit, expectedLimit){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;
            private final double brokerRequestLimit$1;
            private final DoubleRef expectedLimit$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                double correctedLimit = this.$outer.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateAdjustedCapacity(this.brokerRequestLimit$1);
                this.expectedLimit$1.elem -= BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment();
                Assert.assertEquals((String)"Expected request limit correction during request overload", (double)this.expectedLimit$1.elem, (double)correctedLimit, (double)0.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerRequestLimit$1 = brokerRequestLimit$1;
                this.expectedLimit$1 = expectedLimit$1;
            }
        });
        double minCorrectedLimit = this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateAdjustedCapacity(brokerRequestLimit);
        Assert.assertEquals((String)"Expected request limit correction during request overload", (double)expectedLimit.elem, (double)minCorrectedLimit, (double)0.0);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(100000L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)new Serializable(this, queueSizeSensor){
            public static final long serialVersionUID = 0L;
            private final Sensor queueSizeSensor$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.queueSizeSensor$2.record((double)(i % 10));
            }
            {
                this.queueSizeSensor$2 = queueSizeSensor$2;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mult).foreach$mVc$sp((Function1)new Serializable(this, brokerRequestLimit, expectedLimit){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;
            private final double brokerRequestLimit$1;
            private final DoubleRef expectedLimit$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                double correctedLimit = this.$outer.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateAdjustedCapacity(this.brokerRequestLimit$1);
                this.expectedLimit$1.elem += BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment();
                Assert.assertEquals((String)"Expected request limit correction during request overload", (double)this.expectedLimit$1.elem, (double)correctedLimit, (double)0.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerRequestLimit$1 = brokerRequestLimit$1;
                this.expectedLimit$1 = expectedLimit$1;
            }
        });
        double maxCorrectedLimit = this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateAdjustedCapacity(brokerRequestLimit);
        Assert.assertEquals((String)"Expected request limit correction during request overload", (double)expectedLimit.elem, (double)maxCorrectedLimit, (double)0.0);
    }

    @Test
    public void testBrokerRequestLimitIsAdjustedOnRequestOverload() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 500L);
        int throttleMs = this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request);
        Assert.assertEquals((long)0L, (long)throttleMs);
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)), 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        double expectedBrokerQuotaLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(10L);
        request.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Function1<Object, BoxedUnit> record) {
                record.apply$mcVJ$sp(10000000L);
            }
        });
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Percentiles queueSizePercentiles = RequestQueueSizePercentiles$.MODULE$.createPercentiles(this.metrics(), this.maxQueueSize(), SocketServer$.MODULE$.DataPlaneMetricPrefix());
        queueSizeSensor.add((CompoundStat)queueSizePercentiles);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)new Serializable(this, queueSizeSensor){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;
            private final Sensor queueSizeSensor$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.queueSizeSensor$3.record(this.$outer.kafka$server$ClientRequestQuotaManagerTest$$config().backpressureConfig().queueSizeCap() + 1.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queueSizeSensor$3 = queueSizeSensor$3;
            }
        });
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)(expectedBrokerQuotaLimit - BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment()))), 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(100000L);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
    }

    @Test
    public void testBrokerRequestLimitDoesNotFallBelowMinimum() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 500L);
        int throttleMs = this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request);
        Assert.assertEquals((long)0L, (long)throttleMs);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(10L);
        request.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Function1<Object, BoxedUnit> record) {
                record.apply$mcVJ$sp(10000000L);
            }
        });
        double expectedBrokerQuotaLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Percentiles queueSizePercentiles = RequestQueueSizePercentiles$.MODULE$.createPercentiles(this.metrics(), this.maxQueueSize(), SocketServer$.MODULE$.DataPlaneMetricPrefix());
        queueSizeSensor.add((CompoundStat)queueSizePercentiles);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)new Serializable(this, queueSizeSensor){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;
            private final Sensor queueSizeSensor$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.queueSizeSensor$4.record(this.$outer.kafka$server$ClientRequestQuotaManagerTest$$config().backpressureConfig().queueSizeCap() + 1.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queueSizeSensor$4 = queueSizeSensor$4;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManagerTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)BrokerBackpressureConfig$.MODULE$.DefaultMinRequestQuotaLimit())), 0.01);
    }

    @Test
    public void testMultipleTenantEndpoints() {
        this.recreateRequestQuotaManagerWithTwoTenantEnpoints();
        RequestChannel.Request request1 = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request1, 2L);
        int throttleMs1 = this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request1);
        Assert.assertEquals((long)0L, (long)throttleMs1);
        RequestChannel.Request request2 = this.buildRequest(this.secondListener());
        this.simulateTimeOnRequestHandlerThread(request2, 2L);
        int throttleMs2 = this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request2);
        Assert.assertEquals((long)0L, (long)throttleMs2);
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", this.testListener().value(), (Option<Object>)None$.MODULE$, 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", this.secondListener().value(), (Option<Object>)None$.MODULE$, 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", this.testListener().value(), (Option<Object>)None$.MODULE$, 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", this.secondListener().value(), (Option<Object>)None$.MODULE$, 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        int threadsCapacity = this.ioThreadpoolCapacity() + this.networkThreadpoolCapacity() + this.networkThreadpoolCapacity();
        double expectedBrokerQuotaLimit = (double)threadsCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(1L);
        request1.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Function1<Object, BoxedUnit> record) {
                record.apply$mcVJ$sp(1000000L);
            }
        });
        request2.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Function1<Object, BoxedUnit> record) {
                record.apply$mcVJ$sp(1000000L);
            }
        });
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", this.testListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", this.secondListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        Assert.assertEquals((String)"request-network-time", (double)0.2, (double)ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testListener().value(), this.secondListener().value()})), ThreadUsageMetrics$.MODULE$.networkThreadsUsage$default$3()), (double)0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", this.testListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", this.secondListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        Assert.assertEquals((String)"request-non-exempt-network-time", (double)0.2, (double)ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testListener().value(), this.secondListener().value()})), (Option)new Some((Object)NonExemptRequest$.MODULE$)), (double)0.01);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().updateBrokerQuotaLimit();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
    }

    @Test
    public void testRemoveListenerMetrics() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 10L);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request);
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(1000L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.networkThreadpoolSize()).foreach$mVc$sp((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$5;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.request$5.recordNetworkThreadTimeCallback().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Function1<Object, BoxedUnit> record) {
                        record.apply$mcVJ$sp(1000000000L);
                    }
                });
            }
            {
                this.request$5 = request$5;
            }
        });
        double expectedNetworkThreadpoolUsage = (double)this.networkThreadpoolSize() * 100.0;
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedNetworkThreadpoolUsage)), 1.0);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedNetworkThreadpoolUsage)), 1.0);
        this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().removeListenerMetrics(this.testListener().value());
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 1.0);
        this.assertNetworkThreadUsageMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request-non-exempt-network-time"})).s((Seq)Nil$.MODULE$), (Option<Object>)None$.MODULE$, 1.0);
    }

    private void simulateTimeOnRequestHandlerThread(RequestChannel.Request request, long ms) {
        request.requestDequeueTimeNanos_$eq(this.kafka$server$ClientRequestQuotaManagerTest$$time().nanoseconds());
        this.kafka$server$ClientRequestQuotaManagerTest$$time().sleep(ms);
        request.apiLocalCompleteTimeNanos_$eq(this.kafka$server$ClientRequestQuotaManagerTest$$time().nanoseconds());
    }

    private void assertBackpressureMetricValue(String metricName, Option<Object> expectedValueOpt, double delta) {
        this.assertMetricValue(metricName, "backpressure-metrics", (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), expectedValueOpt, delta);
    }

    private double brokerRequestLimit() {
        KafkaMetric metric = this.metrics().metric(BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics()));
        return BoxesRunTime.unboxToDouble((Object)metric.metricValue());
    }

    private void assertIoThreadUsageMetricValue(String metricName, Option<Object> expectedValueOpt, double delta) {
        this.assertMetricValue(metricName, ThreadUsageMetrics$.MODULE$.MetricGroup(), (scala.collection.immutable.Map<String, String>)ThreadUsageMetrics$.MODULE$.ioThreadUsageMetricTags(), expectedValueOpt, delta);
    }

    private void assertNetworkThreadUsageMetricValue(String metricName, Option<Object> expectedValueOpt, double delta) {
        this.assertNetworkThreadUsageMetricValue(metricName, this.testListener().value(), expectedValueOpt, delta);
    }

    private void assertNetworkThreadUsageMetricValue(String metricName, String listener, Option<Object> expectedValueOpt, double delta) {
        this.assertMetricValue(metricName, ThreadUsageMetrics$.MODULE$.MetricGroup(), (scala.collection.immutable.Map<String, String>)ThreadUsageMetrics$.MODULE$.listenerNetworkThreadUsageMetricTags(listener), expectedValueOpt, delta);
    }

    private void assertMetricValue(String metricName, String group, scala.collection.immutable.Map<String, String> metricTags, Option<Object> expectedValueOpt, double delta) {
        KafkaMetric metric = this.metrics().metric(this.metrics().metricName(metricName, group, "", (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(metricTags).asJava()));
        Option<Object> option = expectedValueOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            double expectedValue = BoxesRunTime.unboxToDouble((Object)some.x());
            Assert.assertEquals((String)metricName, (double)expectedValue, (double)BoxesRunTime.unboxToDouble((Object)metric.metricValue()), (double)delta);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Assert.assertNull((Object)metric);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private RequestChannel.Request buildRequest() {
        return this.buildRequest(this.testListener());
    }

    private RequestChannel.Request buildRequest(ListenerName listenerName) {
        OffsetFetchRequest.Builder builder = new OffsetFetchRequest.Builder("test-group", true, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.testTopicPartition()}))).asJava());
        OffsetFetchRequest request = (OffsetFetchRequest)builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), this.testClient(), 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), this.testPrincipal(), listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY);
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics);
    }

    public int kafka$server$ClientRequestQuotaManagerTest$$maybeRecord(String user, String clientId, double value) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        RequestChannel.Session session = new RequestChannel.Session(principal, null);
        return this.kafka$server$ClientRequestQuotaManagerTest$$requestQuotaManager().maybeRecordAndGetThrottleTimeMs(session, clientId, value, this.kafka$server$ClientRequestQuotaManagerTest$$time().milliseconds());
    }

    public double millisToPercent(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public ClientRequestQuotaManagerTest() {
        this.ioThreadpoolSize = 8;
        this.networkThreadpoolSize = 4;
        this.maxQueueSize = 500;
        this.testUser = "ANONYMOUS";
        this.testClient = "Client1";
        long x$1 = 500L;
        BrokerBackpressureConfig x$2 = new BrokerBackpressureConfig(true, 10L * TimeUnit.HOURS.toMillis(1L), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testListener().value()})), (double)this.maxQueueSize());
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        int x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        this.kafka$server$ClientRequestQuotaManagerTest$$config = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$2);
        long x$5 = 500L;
        BrokerBackpressureConfig x$6 = new BrokerBackpressureConfig(true, 10L * TimeUnit.HOURS.toMillis(1L), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testListener().value(), this.secondListener().value()})), BrokerBackpressureConfig$.MODULE$.apply$default$4());
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        int x$8 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        this.twoTenantEndpointsConfig = new ClientQuotaManagerConfig(x$5, x$7, x$8, x$6);
        long x$9 = 500L;
        BrokerBackpressureConfig x$10 = new BrokerBackpressureConfig(false, 10L * TimeUnit.SECONDS.toMillis(1L), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testListener().value()})), BrokerBackpressureConfig$.MODULE$.apply$default$4());
        int x$11 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        int x$12 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        this.noBackpressureConfig = new ClientQuotaManagerConfig(x$9, x$11, x$12, x$10);
        long x$13 = 500L;
        BrokerBackpressureConfig x$14 = new BrokerBackpressureConfig(true, 10L * TimeUnit.SECONDS.toMillis(1L), BrokerBackpressureConfig$.MODULE$.apply$default$3(), BrokerBackpressureConfig$.MODULE$.apply$default$4());
        int x$15 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        int x$16 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        this.noTenantListenerConfig = new ClientQuotaManagerConfig(x$13, x$15, x$16, x$14);
        this.noQuotasConfig = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4());
    }
}

