/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicBrokerConfigTest;
import kafka.server.DynamicListenerConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.TestDynamicThreadPool;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u000f\t9B)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b\u0001\t\u0003)\u0012\u0001\u0005;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f)\u00051\u0002CA\u0005\u0018\u0013\tA\"B\u0001\u0003V]&$\bFA\n\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$A\u0003kk:LGOC\u0001 \u0003\ry'oZ\u0005\u0003Cq\u0011A\u0001V3ti\")1\u0005\u0001C\u0001+\u00051C/Z:u\u0007>tg-[4Va\u0012\fG/Z,ji\"\u001cv.\\3J]Z\fG.\u001b3D_:4\u0017nZ:)\u0005\tR\u0002\"\u0002\u0014\u0001\t\u0003)\u0012a\r;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\bNU3d_:4\u0017nZ;sC\ndWMV1mS\u0012\fG/[8o\r\u0006LG.\u001e:fQ\t)#\u0004C\u0003*\u0001\u0011\u0005Q#\u0001\u000fuKN$(+Z2p]\u001aLw-\u001e:bE2,g+\u00197jI\u0006$\u0018n\u001c8)\u0005!R\u0002\"\u0002\u0017\u0001\t\u0003)\u0012a\u0005;fgR\u001cVmY;sSRL8i\u001c8gS\u001e\u001c\bFA\u0016\u001b\u0011\u0015y\u0003\u0001\"\u0001\u0016\u0003M!Xm\u001d;D_:tWm\u0019;j_:\fVo\u001c;bQ\tq#\u0004C\u00033\u0001\u0011\u0005Q#\u0001\u000buKN$Hj\\4NC:\fw-\u001a:D_:4\u0017n\u001a\u0015\u0003ciAQ!\u000e\u0001\u0005\nY\n!C^3sS\u001aL8i\u001c8gS\u001e,\u0006\u000fZ1uKR)ac\u000e!K\u001f\")\u0001\b\u000ea\u0001s\u0005!a.Y7f!\tQTH\u0004\u0002\nw%\u0011AHC\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=\u0015!)\u0011\t\u000ea\u0001\u0005\u0006)a/\u00197vKB\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0005Y\u0006twMC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%#%AB(cU\u0016\u001cG\u000fC\u0003Li\u0001\u0007A*A\bqKJ\u0014%o\\6fe\u000e{gNZ5h!\tIQ*\u0003\u0002O\u0015\t9!i\\8mK\u0006t\u0007\"\u0002)5\u0001\u0004a\u0015!D3ya\u0016\u001cGOR1jYV\u0014X\rC\u0003S\u0001\u0011%1+A\u0012wKJLg-_\"p]\u001aLw-\u00169eCR,w+\u001b;i\u0013:4\u0018\r\\5e\u0007>tg-[4\u0015\u000bY!\u0016,\u00194\t\u000bU\u000b\u0006\u0019\u0001,\u0002\r\r|gNZ5h!\t\u0011r+\u0003\u0002Y\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011\u0015Q\u0016\u000b1\u0001\\\u0003%y'/[4Qe>\u00048\u000f\u0005\u0002]?6\tQL\u0003\u0002_\r\u0006!Q\u000f^5m\u0013\t\u0001WL\u0001\u0006Qe>\u0004XM\u001d;jKNDQAY)A\u0002\r\f!B^1mS\u0012\u0004&o\u001c9t!\u0011QD-O\u001d\n\u0005\u0015|$aA'ba\")q-\u0015a\u0001G\u0006a\u0011N\u001c<bY&$\u0007K]8qg\")\u0011\u000e\u0001C\u0001+\u0005aB/Z:u!\u0006\u001c8o^8sI\u000e{gNZ5h\u000b:\u001c'/\u001f9uS>t\u0007F\u00015\u001b\u0011\u0015a\u0007\u0001\"\u0001\u0016\u0003\u0015\"Xm\u001d;QCN\u001cxo\u001c:e\u0007>tg-[4F]\u000e|G-\u001a:TK\u000e\u0014X\r^\"iC:<W\r\u000b\u0002l5!)q\u000e\u0001C\u0001+\u0005IB/Z:u\tft\u0017-\\5d\u0019&\u001cH/\u001a8fe\u000e{gNZ5hQ\tq'\u0004C\u0003s\u0001\u0011\u0005Q#\u0001\u000buKN$\u0018)\u001e;i_JL'0\u001a:D_:4\u0017n\u001a\u0015\u0003cjAQ!\u001e\u0001\u0005\u0002U\tA\u0002^3tiNKhn\u001c8z[ND#\u0001\u001e\u000e\t\u000ba\u0004A\u0011A\u000b\u0002cQ,7\u000f\u001e#z]\u0006l\u0017nY\"p]\u001aLw-\u00138ji&\fG.\u001b>bi&|gnV5uQ>,HoQ8oM&<7/\u00138[\u0017\"\u0012qO\u0007")
public class DynamicBrokerConfigTest {
    @Test
    public void testConfigUpdate() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        Assert.assertSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assert.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)new Serializable(this, oldKeystore, config, dynamicConfig){
            public static final long serialVersionUID = 0L;
            private final String oldKeystore$1;
            private final KafkaConfig config$1;
            private final DynamicBrokerConfig dynamicConfig$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Properties props1 = new Properties();
                String newKeystore = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ks", ".jks"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
                props1.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ssl.keystore.location"})), newKeystore);
                this.dynamicConfig$1.updateBrokerConfig(0, props1);
                Assert.assertNotSame((Object)this.config$1, (Object)this.dynamicConfig$1.currentKafkaConfig());
                Assert.assertEquals((Object)newKeystore, this.config$1.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
                Assert.assertEquals((Object)newKeystore, this.config$1.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
                Assert.assertEquals((Object)newKeystore, this.config$1.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
                Assert.assertEquals((Object)newKeystore, this.config$1.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, (Object)this.config$1.getString(KafkaConfig$.MODULE$.SslKeystoreLocationProp()));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.originals().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.values().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.originalsStrings().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.originalsFromThisConfig().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.valuesFromThisConfig().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.originalsFromThisConfig().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.valuesFromThisConfig().get("ssl.keystore.location"));
            }
            {
                this.oldKeystore$1 = oldKeystore$1;
                this.config$1 = config$1;
                this.dynamicConfig$1 = dynamicConfig$1;
            }
        });
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        int x$21 = 0;
        String x$22 = TestUtils$.MODULE$.MockZkConnect();
        int x$23 = 8181;
        boolean x$24 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$26 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$27 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$28 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$31 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$32 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$33 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$34 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$35 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$36 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$37 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$38 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$39 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$40 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$21, x$22, x$24, x$25, x$23, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40);
        origProps.put("ssl.keystore.type", "JKS");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps);
        scala.collection.immutable.Map validProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ssl.keystore.location"}))), (Object)"ks.p12")}));
        scala.collection.immutable.Map securityPropsWithoutListenerPrefix = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)securityPropsWithoutListenerPrefix);
        scala.collection.immutable.Map nonDynamicProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkConnectProp()), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)nonDynamicProps);
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        int x$41 = 0;
        String x$42 = TestUtils$.MODULE$.MockZkConnect();
        int x$43 = 8181;
        boolean x$44 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$45 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$46 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$47 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$48 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$49 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$50 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$51 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$52 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$53 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$54 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$55 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$56 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$57 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$58 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$59 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$60 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$41, x$42, x$44, x$45, x$43, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
        origProps.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "100000000");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps);
        scala.collection.immutable.Map validProps = Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                this.$outer.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                this.$outer.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        int x$61 = 0;
        String x$62 = TestUtils$.MODULE$.MockZkConnect();
        int x$63 = 8181;
        boolean x$64 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$65 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$66 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$67 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$68 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$69 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$70 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$71 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$72 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$73 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$74 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$75 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$76 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$77 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$78 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$79 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$80 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$61, x$62, x$64, x$65, x$63, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps);
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.BrokerIdProp(), "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "some.prop"}));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, config, invalidReconfigurableProps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicBrokerConfigTest $outer;
            private final KafkaConfig config$3;
            private final Set invalidReconfigurableProps$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.config$3.dynamicConfig().addReconfigurable(this.$outer.kafka$server$DynamicBrokerConfigTest$$createReconfigurable$1(this.invalidReconfigurableProps$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$3 = config$3;
                this.invalidReconfigurableProps$1 = invalidReconfigurableProps$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DynamicBrokerConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        config.dynamicConfig().addReconfigurable(this.kafka$server$DynamicBrokerConfigTest$$createReconfigurable$1(validReconfigurableProps));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, config, invalidReconfigurableProps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicBrokerConfigTest $outer;
            private final KafkaConfig config$3;
            private final Set invalidReconfigurableProps$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.config$3.dynamicConfig().addBrokerReconfigurable(this.$outer.kafka$server$DynamicBrokerConfigTest$$createBrokerReconfigurable$1(this.invalidReconfigurableProps$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$3 = config$3;
                this.invalidReconfigurableProps$1 = invalidReconfigurableProps$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DynamicBrokerConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        config.dynamicConfig().addBrokerReconfigurable(this.kafka$server$DynamicBrokerConfigTest$$createBrokerReconfigurable$1(validReconfigurableProps));
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName#:100", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", false, false);
        String listenerMaxConnectionsProp = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaConfig$.MODULE$.MaxConnectionsProp()}));
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testLogManagerConfig() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "-1", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "-1", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "100", true, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        int x$81 = 0;
        String x$82 = TestUtils$.MODULE$.MockZkConnect();
        int x$83 = 8181;
        boolean x$84 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$85 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$86 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$87 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$88 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$89 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$90 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$91 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$92 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$93 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$94 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$95 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$96 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$97 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$98 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$99 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$100 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(x$81, x$82, x$84, x$85, x$83, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100);
        configProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "broker.secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)configProps);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            this.updateConfig$1(perBrokerConfig, config, props);
            Assert.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        try {
            config.dynamicConfig().validate(props, perBrokerConfig);
            Assert.fail((String)"Invalid config did not fail validation");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateConfig$1(perBrokerConfig, config, props);
        Assert.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, scala.collection.immutable.Map<String, String> validProps, scala.collection.immutable.Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$2;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.props$2.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$2 = props$2;
            }
        });
        invalidProps.foreach((Function1)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$2;

            public final Object apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.props$2.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$2 = props$2;
            }
        });
        try {
            config.dynamicConfig().validate(props, true);
            Assert.fail((String)"Invalid config did not fail validation");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        config.dynamicConfig().updateBrokerConfig(0, props);
        validProps.foreach((Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig config$2;

            public final void apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Assert.assertEquals((Object)value, this.config$2.originals().get(name));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.config$2 = config$2;
            }
        });
        invalidProps.keySet().foreach((Function1)new Serializable(this, config, origProps){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig config$2;
            private final Properties origProps$1;

            public final void apply(String name) {
                Assert.assertEquals((Object)this.origProps$1.get(name), this.config$2.originals().get(name));
            }
            {
                this.config$2 = config$2;
                this.origProps$1 = origProps$1;
            }
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        Object object;
        int x$101 = 0;
        String x$102 = TestUtils$.MODULE$.MockZkConnect();
        int x$103 = 8181;
        boolean x$104 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$105 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$106 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$107 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$108 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$109 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$110 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$111 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$112 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$113 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$114 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$115 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$116 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$117 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$118 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$119 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$120 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$101, x$102, x$104, x$105, x$103, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120);
        KafkaConfig configWithoutSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig configWithSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "myLoginModule required;");
        try {
            object = configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {
            object = BoxedUnit.UNIT;
        }
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assert.assertFalse((String)"Password not encoded", (boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("myLoginModule"));
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assert.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        int x$121 = 0;
        String x$122 = TestUtils$.MODULE$.MockZkConnect();
        int x$123 = 8181;
        boolean x$124 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$125 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$126 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$127 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$128 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$129 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$130 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$131 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$132 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$133 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$134 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$135 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$136 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$137 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$138 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$139 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$140 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$121, x$122, x$124, x$125, x$123, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140);
        props.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "staticLoginModule required;");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assert.assertFalse((String)"Password not encoded", (boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("LoginModule"));
        config.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        KafkaConfig newConfigWithSameSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "new-encoder-secret");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "config-encoder-secret");
        KafkaConfig newConfigWithNewAndOldSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "another-new-encoder-secret");
        KafkaConfig newConfigWithNewSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        int x$141 = 0;
        String x$142 = TestUtils$.MODULE$.MockZkConnect();
        int x$143 = 9092;
        boolean x$144 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$145 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$146 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$147 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$148 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$149 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$150 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$151 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$152 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$153 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$154 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$155 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$156 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$157 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$158 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$159 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$160 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$141, x$142, x$144, x$145, x$143, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)EasyMock.createMock(KafkaServer.class);
        EasyMock.expect((Object)kafkaServer.config()).andReturn((Object)oldConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaServer});
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        KafkaConfig newConfig = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig(kafkaServer);
        dynamicListenerConfig.validateReconfiguration(newConfig);
    }

    @Test
    public void testAuthorizerConfig() {
        int x$161 = 0;
        String x$162 = TestUtils$.MODULE$.MockZkConnect();
        int x$163 = 9092;
        boolean x$164 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$165 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$166 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$167 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$168 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$169 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$170 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$171 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$172 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$173 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$174 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$175 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$176 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$177 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$178 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$179 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$180 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$161, x$162, x$164, x$165, x$163, x$166, x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)EasyMock.createMock(KafkaServer.class);
        public class Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1
        implements Authorizer,
        Reconfigurable {
            private volatile String superUsers;
            public final /* synthetic */ DynamicBrokerConfigTest $outer;

            public String superUsers() {
                return this.superUsers;
            }

            public void superUsers_$eq(String x$1) {
                this.superUsers = x$1;
            }

            public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
            }

            public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
                return null;
            }

            public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
                return null;
            }

            public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
                return null;
            }

            public Iterable<AclBinding> acls(AclBindingFilter filter) {
                return null;
            }

            public void close() {
            }

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
                this.superUsers_$eq(configs.get("super.users").toString());
            }

            public /* synthetic */ DynamicBrokerConfigTest kafka$server$DynamicBrokerConfigTest$TestAuthorizer$$$outer() {
                return this.$outer;
            }

            public Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(DynamicBrokerConfigTest $outer) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.superUsers = "";
            }
        }
        Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1 authorizer = new Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(this);
        EasyMock.expect((Object)kafkaServer.config()).andReturn((Object)oldConfig).anyTimes();
        EasyMock.expect((Object)kafkaServer.authorizer()).andReturn((Object)new Some((Object)authorizer)).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaServer});
        try {
            kafkaServer.config().dynamicConfig().addReconfigurables(kafkaServer);
        }
        catch (Throwable throwable) {}
        props.put("super.users", "User:admin");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props);
        Assert.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testSynonyms() {
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.secure.ssl.keystore.type", "ssl.keystore.type"})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.sasl_ssl.plain.sasl.jaas.config", "sasl.jaas.config"})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"some.config"})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogRollTimeMillisProp(), KafkaConfig$.MODULE$.LogRollTimeHoursProp()})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        EasyMock.expect((Object)zkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{zkClient});
        int x$181 = 0;
        String x$182 = TestUtils$.MODULE$.MockZkConnect();
        int x$183 = 9092;
        boolean x$184 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$185 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$186 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$187 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$188 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$189 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$190 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$191 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$192 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$193 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$194 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$195 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$196 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$197 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$198 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$199 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$200 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(x$181, x$182, x$184, x$185, x$183, x$186, x$187, x$188, x$189, x$190, x$191, x$192, x$193, x$194, x$195, x$196, x$197, x$198, x$199, x$200));
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize(zkClient);
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "10");
        newprops.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops);
    }

    public final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads2 = new StringOps(Predef$.MODULE$.augmentString(configs.get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).toString())).toInt();
        if (cleanerThreads2 <= 0 || cleanerThreads2 >= 5) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid cleaner threads ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)cleanerThreads2)})));
        }
    }

    public final Reconfigurable kafka$server$DynamicBrokerConfigTest$$createReconfigurable$1(Set configs) {
        return new Reconfigurable(this, configs){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        };
    }

    public final BrokerReconfigurable kafka$server$DynamicBrokerConfigTest$$createBrokerReconfigurable$1(Set configs) {
        return new BrokerReconfigurable(this, configs){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        };
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), value, false, true);
    }

    private final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$4, Properties props$1) {
        if (perBrokerConfig$1) {
            config$4.dynamicConfig().updateBrokerConfig(0, config$4.dynamicConfig().toPersistentProps(props$1, perBrokerConfig$1));
        } else {
            config$4.dynamicConfig().updateDefaultConfig(props$1);
        }
    }
}

