/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.log.LogConfig$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.ProducerCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CR3uG\"\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u001d\t\u0002\u00011A\u0005\nI\t\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0002'A!A#H\u0010 \u001b\u0005)\"BA\t\u0017\u0015\t9\u0002$A\u0004dY&,g\u000e^:\u000b\u0005\u0015I\"B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001eL!AH\u000b\u0003\u001b-\u000bgm[1Qe>$WoY3s!\t\u0001cE\u0004\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#%\u0001\u0004Qe\u0016$WMZ\u0005\u0003O!\u0012aa\u0015;sS:<'BA\u0013#\u0011\u001dQ\u0003\u00011A\u0005\n-\nA\u0002\u001d:pIV\u001cWM]0%KF$\"\u0001L\u0018\u0011\u0005\u0005j\u0013B\u0001\u0018#\u0005\u0011)f.\u001b;\t\u000fAJ\u0013\u0011!a\u0001'\u0005\u0019\u0001\u0010J\u0019\t\rI\u0002\u0001\u0015)\u0003\u0014\u0003%\u0001(o\u001c3vG\u0016\u0014\b\u0005C\u00035\u0001\u0011\u0005S'A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011AF\u000e\u0005\u0006oM\u0002\r\u0001O\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bCA\u001d?\u001b\u0005Q$BA\u001e=\u0003\u0011)H/\u001b7\u000b\u0003u\nAA[1wC&\u0011qH\u000f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"B!\u0001\t\u0003\u0012\u0015\u0001\u0003;fCJ$un\u001e8\u0015\u00031BQ\u0001\u0012\u0001\u0005\n\u0015\u000b!c\u0019:fCR,g)\u001a;dQJ+\u0017/^3tiR)aIT*VCB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\te\u0016\fX/Z:ug*\u00111\nG\u0001\u0007G>lWn\u001c8\n\u00055C%\u0001\u0004$fi\u000eD'+Z9vKN$\b\"B(D\u0001\u0004\u0001\u0016\u0001E7bqJ+7\u000f]8og\u0016\u0014\u0015\u0010^3t!\t\t\u0013+\u0003\u0002SE\t\u0019\u0011J\u001c;\t\u000bQ\u001b\u0005\u0019\u0001)\u0002#5\f\u0007\u0010U1si&$\u0018n\u001c8CsR,7\u000fC\u0003W\u0007\u0002\u0007q+A\bu_BL7\rU1si&$\u0018n\u001c8t!\rA6,X\u0007\u00023*\u0011!LI\u0001\u000bG>dG.Z2uS>t\u0017B\u0001/Z\u0005\r\u0019V-\u001d\t\u0003=~k\u0011AS\u0005\u0003A*\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003c\u0007\u0002\u00071-A\u0005pM\u001a\u001cX\r^'baB!\u0001\u0005Z/g\u0013\t)\u0007FA\u0002NCB\u0004\"!I4\n\u0005!\u0014#\u0001\u0002'p]\u001eDQA\u001b\u0001\u0005\n-\f!c\u0019:fCR,\u0007+\u0019:uSRLwN\\'baR!AN^<y!\u0011IT.X8\n\u00059T$!\u0004'j].,G\rS1tQ6\u000b\u0007\u000f\u0005\u0002qg:\u0011q)]\u0005\u0003e\"\u000bABR3uG\"\u0014V-];fgRL!\u0001^;\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\t\u0011\b\nC\u0003US\u0002\u0007\u0001\u000bC\u0003WS\u0002\u0007q\u000bC\u0004cSB\u0005\t\u0019A2\t\u000bi\u0004A\u0011B>\u0002!M,g\u000e\u001a$fi\u000eD'+Z9vKN$H#\u0002?\u0002\f\u0005=\u0001cA$~\u007f&\u0011a\u0010\u0013\u0002\u000e\r\u0016$8\r\u001b*fgB|gn]3\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002K\u0003\u0019\u0011XmY8sI&!\u0011\u0011BA\u0002\u00055iU-\\8ssJ+7m\u001c:eg\"1\u0011QB=A\u0002A\u000b\u0001\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0005\u0007\u0003#I\b\u0019\u0001$\u0002\u000fI,\u0017/^3ti\"1\u0011Q\u0003\u0001\u0005\n\t\u000bA\"\u001b8jiB\u0013x\u000eZ;dKJDa!!\u0007\u0001\t\u0003\u0011\u0015A\f;fgR\u0014%o\\6feJ+7\u000f]3diN\u0004\u0016M\u001d;ji&|gn](sI\u0016\u0014\u0018I\u001c3TSj,G*[7jiNDC!a\u0006\u0002\u001eA!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$m\tQA[;oSRLA!a\n\u0002\"\t!A+Z:u\u0011\u0019\tY\u0003\u0001C\u0001\u0005\u00061C/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e,3/&$\bn\u0014<feNL'0\u001a3NKN\u001c\u0018mZ3)\t\u0005%\u0012Q\u0004\u0005\u0007\u0003c\u0001A\u0011\u0001\"\u0002GQ,7\u000f\u001e$fi\u000eD'+Z9vKN$h\u000bN,ji\"\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\"\"\u0011qFA\u000f\u0011\u0019\t9\u0004\u0001C\u0001\u0005\u0006aB/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e+p\u001d>t'+\u001a9mS\u000e\f\u0007\u0006BA\u001b\u0003;Aa!!\u0010\u0001\t\u0003\u0011\u0015A\u0007;fgR\u001cUO\u001d:f]R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>t\u0007\u0006BA\u001e\u0003;Aa!a\u0011\u0001\t\u0003\u0011\u0015!\n;fgR,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tw+\u001b;iS:4U\r^2i'\u0016\u001c8/[8oQ\u0011\t\t%!\b\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L\u0005Ab/\u001a:jMf4U\r^2i'\u0016\u001c8/[8o\u000bJ\u0014xN]:\u0015\u000f1\ni%!\u0015\u0002V!9\u0011qJA$\u0001\u0004i\u0016A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003'\n9\u00051\u0001Q\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\u000f\u0005]\u0013q\ta\u0001!\u0006\u0019B-Z:uS:\fG/[8o\u0005J|7.\u001a:JI\"1\u00111\f\u0001\u0005\u0002\t\u000bq\u0005^3ti\u0012{wO\\\"p]Z,'o]5p]^KG\u000f[\"p]:,7\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\"\u0011\u0011LA\u000f\u0011\u0019\t\t\u0007\u0001C\u0001\u0005\u00061D/Z:u\t><hnQ8om\u0016\u00148/[8o\rJ|WNQ1uG\",G\rV8V]\n\fGo\u00195fIJ+7\u000f]3diN|eMZ:fi\"\"\u0011qLA\u000f\u0011\u0019\t9\u0007\u0001C\u0001\u0005\u0006yC/Z:u\u0007J,\u0017\r^3J]\u000e\u0014X-\\3oi\u0006dg)\u001a;dQ^KG\u000f\u001b)beRLG/[8og&sWI\u001d:pe\"\"\u0011QMA\u000f\u0011\u0019\ti\u0007\u0001C\u0001\u0005\u00069B/Z:u5N#HmQ8naJ,7o]3e)>\u0004\u0018n\u0019\u0015\u0005\u0003W\ni\u0002\u0003\u0004\u0002t\u0001!\tAQ\u0001\u001ai\u0016\u001cHOW*uI\u000e{W\u000e\u001d:fgN,GMU3d_J$7\u000f\u000b\u0003\u0002r\u0005u\u0001bBA=\u0001\u0011%\u00111P\u0001\be\u0016\u001cwN\u001d3t)\u0011\ti(!\"\u0011\ta[\u0016q\u0010\t\u0005\u0003\u0003\t\t)\u0003\u0003\u0002\u0004\u0006\r!A\u0002*fG>\u0014H\r\u0003\u0005\u0002\b\u0006]\u0004\u0019AAE\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB)\u00111RAI\u007f:\u0019q)!$\n\u0007\u0005=\u0005*A\u0007GKR\u001c\u0007NU3ta>t7/Z\u0005\u0004i\u0006M%bAAH\u0011\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0015AE2iK\u000e\\g)\u001a;dQJ+7\u000f]8og\u0016$2\u0002LAN\u0003?\u000b\u0019+!*\u0002(\"9\u0011QTAK\u0001\u00049\u0016AE3ya\u0016\u001cG/\u001a3QCJ$\u0018\u000e^5p]NDq!!)\u0002\u0016\u0002\u0007A0A\u0007gKR\u001c\u0007NU3ta>t7/\u001a\u0005\u0007)\u0006U\u0005\u0019\u0001)\t\r=\u000b)\n1\u0001Q\u0011\u001d\tI+!&A\u0002A\u000bqC\\;n\u001b\u0016\u001c8/Y4fgB+'\u000fU1si&$\u0018n\u001c8\t\u000f\u00055\u0006\u0001\"\u0003\u00020\u0006a1M]3bi\u0016$v\u000e]5dgRA\u0011\u0011WAZ\u0003o\u000bY\f\u0005\u0003!Iv\u0003\u0006bBA[\u0003W\u0003\r\u0001U\u0001\n]VlGk\u001c9jGNDq!!/\u0002,\u0002\u0007\u0001+A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u000b\u0003{\u000bY\u000b%AA\u0002\u0005}\u0016aB2p]\u001aLwm\u001d\t\u0005A\u0011|r\u0004C\u0004\u0002D\u0002!I!!2\u0002\u0017A\u0014x\u000eZ;dK\u0012\u000bG/\u0019\u000b\u0007\u0003\u000f\fy-!;\u0011\ta[\u0016\u0011\u001a\t\u0006)\u0005-wdH\u0005\u0004\u0003\u001b,\"A\u0004)s_\u0012,8-\u001a:SK\u000e|'\u000f\u001a\u0005\b-\u0006\u0005\u0007\u0019AAi!\u0015\t\u0019.a9^\u001d\u0011\t).a8\u000f\t\u0005]\u0017Q\\\u0007\u0003\u00033T1!a7\u0007\u0003\u0019a$o\\8u}%\t1%C\u0002\u0002b\n\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002f\u0006\u001d(\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005\u0005(\u0005C\u0004\u0002*\u0006\u0005\u0007\u0019\u0001)\t\u0013\u00055\b!%A\u0005\n\u0005=\u0018\u0001H2sK\u0006$X\rU1si&$\u0018n\u001c8NCB$C-\u001a4bk2$HeM\u000b\u0003\u0003cT3aYAzW\t\t)\u0010\u0005\u0003\u0002x\n\u0005QBAA}\u0015\u0011\tY0!@\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0000E\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r\u0011\u0011 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B\u0004\u0001E\u0005I\u0011\u0002B\u0005\u0003Y\u0019'/Z1uKR{\u0007/[2tI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0006U\u0011\ty,a=")
public class FetchRequestTest
extends BaseRequestTest {
    private KafkaProducer<String, String> kafka$server$FetchRequestTest$$producer = null;

    public KafkaProducer<String, String> kafka$server$FetchRequestTest$$producer() {
        return this.kafka$server$FetchRequestTest$$producer;
    }

    private void kafka$server$FetchRequestTest$$producer_$eq(KafkaProducer<String, String> x$1) {
        this.kafka$server$FetchRequestTest$$producer = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.FetchMaxBytes(), ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
    }

    @Override
    public void tearDown() {
        if (this.kafka$server$FetchRequestTest$$producer() != null) {
            this.kafka$server$FetchRequestTest$$producer().close();
        }
        super.tearDown();
    }

    private FetchRequest createFetchRequest(int maxResponseBytes, int maxPartitionBytes, Seq<TopicPartition> topicPartitions2, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, topicPartitions2, offsetMap)).setMaxBytes(maxResponseBytes).build();
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions2, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions2.foreach((Function1)new Serializable(this, maxPartitionBytes, offsetMap, partitionMap){
            public static final long serialVersionUID = 0L;
            private final int maxPartitionBytes$1;
            private final scala.collection.immutable.Map offsetMap$1;
            private final LinkedHashMap partitionMap$1;

            public final FetchRequest.PartitionData apply(TopicPartition tp) {
                return this.partitionMap$1.put(tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)this.offsetMap$1.getOrElse((Object)tp, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })), 0L, this.maxPartitionBytes$1, Optional.<T>empty()));
            }
            {
                this.maxPartitionBytes$1 = maxPartitionBytes$1;
                this.offsetMap$1 = offsetMap$1;
                this.partitionMap$1 = partitionMap$1;
            }
        });
        return partitionMap;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createPartitionMap$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(int leaderId, FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private void initProducer() {
        String x$21 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$22 = new StringSerializer();
        StringSerializer x$23 = new StringSerializer();
        int x$24 = TestUtils$.MODULE$.createProducer$default$2();
        long x$25 = TestUtils$.MODULE$.createProducer$default$3();
        long x$26 = TestUtils$.MODULE$.createProducer$default$4();
        int x$27 = TestUtils$.MODULE$.createProducer$default$5();
        int x$28 = TestUtils$.MODULE$.createProducer$default$6();
        int x$29 = TestUtils$.MODULE$.createProducer$default$7();
        int x$30 = TestUtils$.MODULE$.createProducer$default$8();
        String x$31 = TestUtils$.MODULE$.createProducer$default$9();
        int x$32 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$33 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$34 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$35 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$36 = TestUtils$.MODULE$.createProducer$default$16();
        this.kafka$server$FetchRequestTest$$producer_$eq(TestUtils$.MODULE$.createProducer(x$21, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$22, x$23, x$36));
    }

    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions2 = topicPartitionToLeader.keySet();
        this.produceData((Iterable<TopicPartition>)topicPartitions2, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    int partitionLeaderId = A1._2$mcI$sp();
                    if (partitionLeaderId == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                int partitionLeaderId;
                Tuple2<TopicPartition, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (partitionLeaderId = tuple2._2$mcI$sp()) == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1)new Serializable(this, partitionsWithLargeMessages){
            public static final long serialVersionUID = 0L;
            private final Vector partitionsWithLargeMessages$1;

            public final boolean apply(Object elem) {
                return this.partitionsWithLargeMessages$1.contains(elem);
            }
            {
                this.partitionsWithLargeMessages$1 = partitionsWithLargeMessages$1;
            }
        });
        Vector shuffledTopicPartitions1 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest1 = this.createFetchRequest$1((Seq)shuffledTopicPartitions1, this.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Vector shuffledTopicPartitions2 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest2 = this.createFetchRequest$1((Seq)shuffledTopicPartitions2, this.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Seq shuffledTopicPartitions3 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage1, partitionWithLargeMessage2}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest3 = this.createFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        Assert.assertEquals((Object)shuffledTopicPartitions3, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse3.responseData().keySet()).asScala()).toSeq());
        int responseSize3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse3.responseData()).asScala()).values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            public final int apply(FetchResponse.PartitionData<MemoryRecords> partitionData) {
                return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records(partitionData).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Record x$1) {
                        return x$1.sizeInBytes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((responseSize3 <= maxResponseBytes ? 1 : 0) != 0);
        FetchResponse.PartitionData partitionData3 = (FetchResponse.PartitionData)fetchResponse3.responseData().get(partitionWithLargeMessage1);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData3.error);
        Assert.assertTrue((partitionData3.highWatermark > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Record x$2) {
                return x$2.sizeInBytes();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be smaller than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size3 <= maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxPartitionBytes)})), (size3 > maxPartitionBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxPartitionBytes < ((MemoryRecords)partitionData3.records).sizeInBytes() ? 1 : 0) != 0);
        Seq shuffledTopicPartitions4 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2, partitionWithLargeMessage1}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest4 = this.createFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        Assert.assertEquals((Object)shuffledTopicPartitions4, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse4.responseData().keySet()).asScala()).toSeq());
        Seq nonEmptyPartitions4 = (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse4.responseData()).asScala()).toSeq().collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)A1._2();
                    if (BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Record x$3) {
                            return x$3.sizeInBytes();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> x2) {
                FetchResponse.PartitionData partitionData;
                Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> tuple2 = x2;
                boolean bl = tuple2 != null && BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)(partitionData = (FetchResponse.PartitionData)tuple2._2())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Record x$3) {
                        return x$3.sizeInBytes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2})), (Object)nonEmptyPartitions4);
        FetchResponse.PartitionData partitionData4 = (FetchResponse.PartitionData)fetchResponse4.responseData().get(partitionWithLargeMessage2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData4.error);
        Assert.assertTrue((partitionData4.highWatermark > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Record x$4) {
                return x$4.sizeInBytes();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size4), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size4 > maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxResponseBytes < ((MemoryRecords)partitionData4.records).sizeInBytes() ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestV2WithOversizedMessage() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).build((short)2);
            FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)maxPartitionBytes, (long)((MemoryRecords)partitionData.records).sizeInBytes());
            Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Record x$6) {
                    return x$6.sizeInBytes();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testFetchRequestV4WithReadCommitted() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)4);
            FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.lastStableOffset > 0L ? 1 : 0) != 0);
            Assert.assertTrue((BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Record x$8) {
                    return x$8.sizeInBytes();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0 ? 1 : 0) != 0);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testFetchRequestToNonReplica() {
        String topic = "topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int leader2 = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1)new Serializable(this, leader2){
            public static final long serialVersionUID = 0L;
            private final int leader$1;

            public final boolean apply(KafkaServer x$9) {
                return x$9.config().brokerId() != this.leader$1;
            }
            {
                this.leader$1 = leader$1;
            }
        });
        Assert.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), this.createPartitionMap$default$3())).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(nonReplicaId, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionData.error);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    @Test
    public void testEpochValidationWithinFetchSession() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, secondLeaderId);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, followerId);
    }

    private void verifyFetchSessionErrors(TopicPartition topicPartition, int leaderEpoch, int destinationBrokerId) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(0L, 0L, 1024, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch))));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).metadata(FetchMetadata.INITIAL).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(destinationBrokerId, fetchRequest);
        int sessionId = fetchResponse.sessionId();
        this.assertResponseErrorForEpoch$2(Errors.FENCED_LEADER_EPOCH, 1, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), topicPartition, destinationBrokerId, sessionId);
        this.assertResponseErrorForEpoch$2(Errors.UNKNOWN_LEADER_EPOCH, 2, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), topicPartition, destinationBrokerId, sessionId);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testDownConversionWithConnectionFailure() {
        IndexedSeq indexedSeq;
        Tuple2 tuple22;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        int msgValueLen = 100000;
        int batchSize = 4 * msgValueLen;
        String x$37 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$38 = Integer.MAX_VALUE;
        int x$39 = Integer.MAX_VALUE;
        int x$40 = batchSize;
        StringSerializer x$41 = new StringSerializer();
        ByteArraySerializer x$42 = new ByteArraySerializer();
        int x$43 = TestUtils$.MODULE$.createProducer$default$2();
        long x$44 = TestUtils$.MODULE$.createProducer$default$3();
        long x$45 = TestUtils$.MODULE$.createProducer$default$4();
        int x$46 = TestUtils$.MODULE$.createProducer$default$5();
        String x$47 = TestUtils$.MODULE$.createProducer$default$9();
        int x$48 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$49 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$50 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$51 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$52 = TestUtils$.MODULE$.createProducer$default$16();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$37, x$43, x$44, x$45, x$46, x$39, x$38, x$40, x$47, x$48, x$49, x$50, x$51, x$41, x$42, x$52);
        byte[] bytes = new byte[msgValueLen];
        try {
            indexedSeq = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)new Serializable(this, topicPartition2, producer, bytes){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$3;
                private final KafkaProducer producer$1;
                private final byte[] bytes$1;

                public final Future<RecordMetadata> apply(int x$11) {
                    return this.producer$1.send(new ProducerRecord(this.topicPartition$3.topic(), Predef$.MODULE$.int2Integer(this.topicPartition$3.partition()), (Object)"key", (Object)this.bytes$1));
                }
                {
                    this.topicPartition$3 = topicPartition$3;
                    this.producer$1 = producer$1;
                    this.bytes$1 = bytes$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        catch (Throwable throwable) {
            void var10_26;
            var10_26.close();
            throw throwable;
        }
        producer.close();
        IndexedSeq futures = indexedSeq;
        futures.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$12) {
                return x$12.get();
            }
        });
        short version = (short)1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1)new Serializable(this, topicPartition2, leaderId2, msgValueLen, batchSize, version){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;
            private final TopicPartition topicPartition$3;
            private final int leaderId$2;
            private final int msgValueLen$1;
            private final int batchSize$1;
            private final short version$1;

            public final Option<FetchResponse<MemoryRecords>> apply(int x$13) {
                return this.$outer.kafka$server$FetchRequestTest$$fetch$1(this.version$1, this.msgValueLen$1 * 1000, true, this.topicPartition$3, this.leaderId$2, this.batchSize$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$3 = topicPartition$3;
                this.leaderId$2 = leaderId$2;
                this.msgValueLen$1 = msgValueLen$1;
                this.batchSize$1 = batchSize$1;
                this.version$1 = version$1;
            }
        });
        Option response = this.kafka$server$FetchRequestTest$$fetch$1(version, batchSize, false, topicPartition2, leaderId2, batchSize);
        FetchResponse fetchResponse = (FetchResponse)response.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No fetch response");
            }
        });
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Buffer batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records).batches()).asScala()).toBuffer();
        Assert.assertEquals((long)3L, (long)batches.size());
    }

    @Test
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset() {
        String x$53 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$54 = 5;
        StringSerializer x$55 = new StringSerializer();
        StringSerializer x$56 = new StringSerializer();
        int x$57 = 30000;
        int x$58 = 60000;
        int x$59 = TestUtils$.MODULE$.createProducer$default$2();
        long x$60 = TestUtils$.MODULE$.createProducer$default$3();
        long x$61 = TestUtils$.MODULE$.createProducer$default$4();
        int x$62 = TestUtils$.MODULE$.createProducer$default$8();
        String x$63 = TestUtils$.MODULE$.createProducer$default$9();
        int x$64 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$65 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$66 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$67 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$68 = TestUtils$.MODULE$.createProducer$default$16();
        this.kafka$server$FetchRequestTest$$producer_$eq(TestUtils$.MODULE$.createProducer(x$53, x$59, x$60, x$61, x$54, x$58, x$57, x$62, x$63, x$64, x$65, x$66, x$67, x$55, x$56, x$68));
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_11_0_IV2$.MODULE$.version())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            String topic = topicPartition2.topic();
            IndexedSeq firstBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FetchRequestTest $outer;
                private final String topic$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.$outer.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(this.topic$1, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            this.kafka$server$FetchRequestTest$$producer().flush();
            IndexedSeq secondBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 25).map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FetchRequestTest $outer;
                private final String topic$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.$outer.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(this.topic$1, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            this.kafka$server$FetchRequestTest$$producer().flush();
            firstBatchFutures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$15) {
                    return x$15.get();
                }
            });
            secondBatchFutures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$16) {
                    return x$16.get();
                }
            });
            long x$69 = 3L;
            long x$70 = 3L;
            short x$71 = 1;
            int x$72 = 22;
            byte x$73 = 0;
            this.check$1(x$69, x$71, x$70, x$72, x$73, topicPartition2, leaderId2);
            long x$74 = 15L;
            long x$75 = 15L;
            short x$76 = 1;
            int x$77 = 10;
            byte x$78 = 0;
            this.check$1(x$74, x$76, x$75, x$77, x$78, topicPartition2, leaderId2);
            long x$79 = 3L;
            long x$80 = 3L;
            short x$81 = 3;
            int x$82 = 22;
            byte x$83 = 1;
            this.check$1(x$79, x$81, x$80, x$82, x$83, topicPartition2, leaderId2);
            long x$84 = 15L;
            long x$85 = 15L;
            short x$86 = 3;
            int x$87 = 10;
            byte x$88 = 1;
            this.check$1(x$84, x$86, x$85, x$87, x$88, topicPartition2, leaderId2);
            long x$89 = 3L;
            long x$90 = 0L;
            short x$91 = 4;
            int x$92 = 2;
            byte x$93 = 2;
            this.check$1(x$89, x$91, x$90, x$92, x$93, topicPartition2, leaderId2);
            long x$94 = 15L;
            long x$95 = 10L;
            short x$96 = 4;
            int x$97 = 1;
            byte x$98 = 2;
            this.check$1(x$94, x$96, x$95, x$97, x$98, topicPartition2, leaderId2);
            long x$99 = 10L;
            long x$100 = 10L;
            short x$101 = 4;
            int x$102 = 1;
            byte x$103 = 2;
            this.check$1(x$99, x$101, x$100, x$102, x$103, topicPartition2, leaderId2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testCreateIncrementalFetchWithPartitionsInError() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        this.createTopic("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})))}))));
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = this.createFetchRequest$2((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0, foo1, bar0})), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp1 = this.sendFetchRequest(0, req1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((String)"Expected the broker to create a new incremental fetch session", (resp1.sessionId() > 0 ? 1 : 0) != 0);
        this.debug((Function0<String>)new Serializable(this, resp1){
            public static final long serialVersionUID = 0L;
            private final FetchResponse resp1$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test created an incremental fetch session ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.resp1$1.sessionId())}));
            }
            {
                this.resp1$1 = resp1$1;
            }
        });
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo0));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)foo0)).error);
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)foo1)).error);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)bar0)).error);
        FetchRequest req2 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 1), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp2 = this.sendFetchRequest(0, req2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertEquals((String)"Expected the broker to continue the incremental fetch session", (long)resp1.sessionId(), (long)resp2.sessionId());
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp2.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp2.responseData().get((Object)bar0)).error);
        this.createTopic("bar", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))));
        FetchRequest req3 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 2), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp3 = this.sendFetchRequest(0, req3);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp3.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp3.responseData().get((Object)bar0)).error);
        FetchRequest req4 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 3), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp4 = this.sendFetchRequest(0, req4);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo1));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(bar0));
    }

    @Test
    public void testZStdCompressedTopic() {
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ZStdCompressionCodec$.MODULE$.name())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            String x$104 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
            StringSerializer x$105 = new StringSerializer();
            StringSerializer x$106 = new StringSerializer();
            int x$107 = TestUtils$.MODULE$.createProducer$default$2();
            long x$108 = TestUtils$.MODULE$.createProducer$default$3();
            long x$109 = TestUtils$.MODULE$.createProducer$default$4();
            int x$110 = TestUtils$.MODULE$.createProducer$default$5();
            int x$111 = TestUtils$.MODULE$.createProducer$default$6();
            int x$112 = TestUtils$.MODULE$.createProducer$default$7();
            int x$113 = TestUtils$.MODULE$.createProducer$default$8();
            String x$114 = TestUtils$.MODULE$.createProducer$default$9();
            int x$115 = TestUtils$.MODULE$.createProducer$default$10();
            SecurityProtocol x$116 = TestUtils$.MODULE$.createProducer$default$11();
            Option<File> x$117 = TestUtils$.MODULE$.createProducer$default$12();
            Option<Properties> x$118 = TestUtils$.MODULE$.createProducer$default$13();
            boolean x$119 = TestUtils$.MODULE$.createProducer$default$16();
            this.kafka$server$FetchRequestTest$$producer_$eq(TestUtils$.MODULE$.createProducer(x$104, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$105, x$106, x$119));
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key1", (Object)"value1")).get();
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key2", (Object)"value2")).get();
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key3", (Object)"value3")).get();
            this.kafka$server$FetchRequestTest$$producer().close();
            FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 9, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res0 = this.sendFetchRequest(leaderId2, req0);
            FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)res0.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data0.error);
            FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res1 = this.sendFetchRequest(leaderId2, req1);
            FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)res1.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)data1.error);
            Assert.assertEquals((long)3L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data1).size());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testZStdCompressedRecords() {
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ProducerCompressionCodec$.MODULE$.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)"2.0.0")}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            String x$120 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
            String x$121 = GZIPCompressionCodec$.MODULE$.name();
            StringSerializer x$122 = new StringSerializer();
            StringSerializer x$123 = new StringSerializer();
            int x$124 = TestUtils$.MODULE$.createProducer$default$2();
            long x$125 = TestUtils$.MODULE$.createProducer$default$3();
            long x$126 = TestUtils$.MODULE$.createProducer$default$4();
            int x$127 = TestUtils$.MODULE$.createProducer$default$5();
            int x$128 = TestUtils$.MODULE$.createProducer$default$6();
            int x$129 = TestUtils$.MODULE$.createProducer$default$7();
            int x$130 = TestUtils$.MODULE$.createProducer$default$8();
            int x$131 = TestUtils$.MODULE$.createProducer$default$10();
            SecurityProtocol x$132 = TestUtils$.MODULE$.createProducer$default$11();
            Option<File> x$133 = TestUtils$.MODULE$.createProducer$default$12();
            Option<Properties> x$134 = TestUtils$.MODULE$.createProducer$default$13();
            boolean x$135 = TestUtils$.MODULE$.createProducer$default$16();
            KafkaProducer producer1 = TestUtils$.MODULE$.createProducer(x$120, x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$121, x$131, x$132, x$133, x$134, x$122, x$123, x$135);
            producer1.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key1", (Object)"value1")).get();
            producer1.close();
            String x$136 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
            String x$137 = ZStdCompressionCodec$.MODULE$.name();
            StringSerializer x$138 = new StringSerializer();
            StringSerializer x$139 = new StringSerializer();
            int x$140 = TestUtils$.MODULE$.createProducer$default$2();
            long x$141 = TestUtils$.MODULE$.createProducer$default$3();
            long x$142 = TestUtils$.MODULE$.createProducer$default$4();
            int x$143 = TestUtils$.MODULE$.createProducer$default$5();
            int x$144 = TestUtils$.MODULE$.createProducer$default$6();
            int x$145 = TestUtils$.MODULE$.createProducer$default$7();
            int x$146 = TestUtils$.MODULE$.createProducer$default$8();
            int x$147 = TestUtils$.MODULE$.createProducer$default$10();
            SecurityProtocol x$148 = TestUtils$.MODULE$.createProducer$default$11();
            Option<File> x$149 = TestUtils$.MODULE$.createProducer$default$12();
            Option<Properties> x$150 = TestUtils$.MODULE$.createProducer$default$13();
            boolean x$151 = TestUtils$.MODULE$.createProducer$default$16();
            KafkaProducer producer2 = TestUtils$.MODULE$.createProducer(x$136, x$140, x$141, x$142, x$143, x$144, x$145, x$146, x$137, x$147, x$148, x$149, x$150, x$138, x$139, x$151);
            producer2.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key2", (Object)"value2")).get();
            producer2.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key3", (Object)"value3")).get();
            producer2.close();
            FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res0 = this.sendFetchRequest(leaderId2, req0);
            FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)res0.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)data0.error);
            Assert.assertEquals((long)1L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data0).size());
            FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res1 = this.sendFetchRequest(leaderId2, req1);
            FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)res1.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data1.error);
            FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(2, 3, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res2 = this.sendFetchRequest(leaderId2, req2);
            FetchResponse.PartitionData data2 = (FetchResponse.PartitionData)res2.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)data2.error);
            Assert.assertEquals((long)1L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data2).size());
            FetchRequest req3 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res3 = this.sendFetchRequest(leaderId2, req3);
            FetchResponse.PartitionData data3 = (FetchResponse.PartitionData)res3.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data3.error);
            FetchRequest req4 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res4 = this.sendFetchRequest(leaderId2, req4);
            FetchResponse.PartitionData data4 = (FetchResponse.PartitionData)res4.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)data4.error);
            Assert.assertEquals((long)3L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data4).size());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<Record> kafka$server$FetchRequestTest$$records(FetchResponse.PartitionData<MemoryRecords> partitionData) {
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)partitionData.records).records()).asScala()).toBuffer();
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse<MemoryRecords> fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition) {
        Assert.assertEquals(expectedPartitions, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse.responseData().keySet()).asScala()).toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1)new Serializable(this, fetchResponse, maxPartitionBytes, numMessagesPerPartition, emptyResponseSeen, responseSize, responseBufferSize){
            public static final long serialVersionUID = 0L;
            private final FetchResponse fetchResponse$1;
            private final int maxPartitionBytes$3;
            private final int numMessagesPerPartition$2;
            private final BooleanRef emptyResponseSeen$1;
            private final IntRef responseSize$1;
            private final IntRef responseBufferSize$1;

            public final void apply(TopicPartition tp) {
                FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.fetchResponse$1.responseData().get(tp);
                Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
                Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
                MemoryRecords records2 = (MemoryRecords)partitionData.records;
                this.responseBufferSize$1.elem += records2.sizeInBytes();
                Buffer batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.batches()).asScala()).toBuffer();
                Assert.assertTrue((batches.size() < this.numMessagesPerPartition$2 ? 1 : 0) != 0);
                int batchesSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batches.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MutableRecordBatch x$19) {
                        return x$19.sizeInBytes();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                this.responseSize$1.elem += batchesSize;
                if (batchesSize == 0 && !this.emptyResponseSeen$1.elem) {
                    Assert.assertEquals((long)0L, (long)records2.sizeInBytes());
                    this.emptyResponseSeen$1.elem = true;
                } else if (batchesSize != 0 && !this.emptyResponseSeen$1.elem) {
                    Assert.assertTrue((batchesSize <= this.maxPartitionBytes$3 ? 1 : 0) != 0);
                    Assert.assertEquals((long)this.maxPartitionBytes$3, (long)records2.sizeInBytes());
                } else if (batchesSize != 0 && this.emptyResponseSeen$1.elem) {
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)batchesSize)})));
                } else if (records2.sizeInBytes() != 0 && this.emptyResponseSeen$1.elem) {
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition buffer with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)records2.sizeInBytes())})));
                }
            }
            {
                this.fetchResponse$1 = fetchResponse$1;
                this.maxPartitionBytes$3 = maxPartitionBytes$3;
                this.numMessagesPerPartition$2 = numMessagesPerPartition$2;
                this.emptyResponseSeen$1 = emptyResponseSeen$1;
                this.responseSize$1 = responseSize$1;
                this.responseBufferSize$1 = responseBufferSize$1;
            }
        });
        Assert.assertEquals((long)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (long)responseBufferSize.elem);
        Assert.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, scala.collection.immutable.Map<String, String> configs) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int t) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        configs.foreach((Function1)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final Properties topicConfig$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.topicConfig$1.setProperty(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topicConfig$1 = topicConfig$1;
            }
        });
        return ((TraversableOnce)topics.flatMap((Function1)new Serializable(this, numPartitions, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;
            private final int numPartitions$1;
            private final Properties topicConfig$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply(String topic) {
                scala.collection.immutable.Map<Object, Object> partitionToLeader = this.$outer.createTopic(topic, this.numPartitions$1, 2, this.topicConfig$1);
                return (scala.collection.immutable.Map)partitionToLeader.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$2;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            int partition = tuple2._1$mcI$sp();
                            int leader2 = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic$2, partition)), (Object)BoxesRunTime.boxToInteger((int)leader2));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.topic$2 = topic$2;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numPartitions$1 = numPartitions$1;
                this.topicConfig$1 = topicConfig$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> createTopics$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ProducerRecord<String, String>> produceData(Iterable<TopicPartition> topicPartitions2, int numMessagesPerPartition) {
        void var3_3;
        Seq records2 = (Seq)topicPartitions2.toSeq().flatMap((Function1)new Serializable(this, numMessagesPerPartition){
            public static final long serialVersionUID = 0L;
            private final int numMessagesPerPartition$1;

            public final IndexedSeq<ProducerRecord<String, String>> apply(TopicPartition tp) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numMessagesPerPartition$1).map((Function1)new Serializable(this, tp){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition tp$1;

                    public final ProducerRecord<String, String> apply(int messageIndex) {
                        String suffix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToInteger((int)messageIndex)}));
                        return new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})));
                    }
                    {
                        this.tp$1 = tp$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numMessagesPerPartition$1 = numMessagesPerPartition$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            public final RecordMetadata apply(ProducerRecord<String, String> x$20) {
                return (RecordMetadata)this.$outer.kafka$server$FetchRequestTest$$producer().send(x$20).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return var3_3;
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions2, scala.collection.immutable.Map offsetMap, int maxResponseBytes$1, int maxPartitionBytes$2) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$2, (Seq<TopicPartition>)topicPartitions2, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap);
    }

    private final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional leaderEpoch, TopicPartition topicPartition$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$1, new FetchRequest.PartitionData(0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(brokerId, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$1);
        Assert.assertEquals((Object)error, (Object)partitionData.error);
    }

    private final void assertResponseErrorForEpoch$2(Errors expectedError, int sessionFetchEpoch, Optional leaderEpoch, TopicPartition topicPartition$2, int destinationBrokerId$1, int sessionId$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$2, new FetchRequest.PartitionData(0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).metadata(new FetchMetadata(sessionId$1, sessionFetchEpoch)).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(destinationBrokerId$1, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$2);
        Assert.assertEquals((Object)expectedError, (Object)partitionData.error);
    }

    /*
     * WARNING - void declaration
     */
    public final Option kafka$server$FetchRequestTest$$fetch$1(short version, int maxPartitionBytes, boolean closeAfterPartialResponse, TopicPartition topicPartition$3, int leaderId$2, int batchSize$1) {
        Some some;
        Socket socket;
        block3: {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$3}))), this.createPartitionMap$default$3())).build(version);
            socket = this.connect(this.brokerSocketServer(leaderId$2), this.connect$default$2());
            try {
                this.send((AbstractRequest)fetchRequest, socket, this.send$default$3(), this.send$default$4());
                if (closeAfterPartialResponse) {
                    int size2 = new DataInputStream(socket.getInputStream()).readInt();
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetch size too small ", ", broker may have run out of memory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size2)})), (size2 > maxPartitionBytes - batchSize$1 ? 1 : 0) != 0);
                    some = None$.MODULE$;
                    break block3;
                }
                some = new Some(this.receive(socket, ApiKeys.FETCH, version, ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals())));
            }
            catch (Throwable throwable) {
                void var8_8;
                var8_8.close();
                throw throwable;
            }
        }
        socket.close();
        return some;
    }

    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$4, int leaderId$3) {
        int batchesReceived;
        Buffer batches;
        long currentFetchOffset = fetchOffset;
        long currentExpectedOffset = expectedOffset;
        for (batchesReceived = 0; batchesReceived < expectedNumBatches; batchesReceived += batches.size()) {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$4}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$4), (Object)BoxesRunTime.boxToLong((long)currentFetchOffset))}))))).build(requestVersion);
            FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId$3, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$4);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
            batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records).batches()).asScala()).toBuffer();
            MutableRecordBatch batch = (MutableRecordBatch)batches.head();
            Assert.assertEquals((long)expectedMagic, (long)batch.magic());
            Assert.assertEquals((long)currentExpectedOffset, (long)batch.baseOffset());
            currentFetchOffset = ((RecordBatch)batches.last()).lastOffset() + 1L;
            currentExpectedOffset += ((RecordBatch)batches.last()).lastOffset() - ((RecordBatch)batches.head()).baseOffset() + 1L;
        }
        Assert.assertEquals((long)expectedNumBatches, (long)batchesReceived);
    }

    private final FetchRequest createFetchRequest$2(Seq topicPartitions2, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)topicPartitions2, (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).toForget((List)JavaConverters$.MODULE$.seqAsJavaListConverter(toForget).asJava()).metadata(metadata).build();
    }
}

