/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.TierReplicaComponents$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#S:s\u000bb\u0004\u0018N]1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0001\r\u0011\"\u0001\u0016\u0003E!x\u000e]5d!\u0006\u0014H/\u001b;j_:L5O]\u000b\u0002-A!q\u0003\b\u0010,\u001b\u0005A\"BA\r\u001b\u0003\u001diW\u000f^1cY\u0016T!a\u0007\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u001e1\t\u0019Q*\u00199\u0011\t%y\u0012\u0005K\u0005\u0003A)\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u0012&\u001d\tI1%\u0003\u0002%\u0015\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!#\u0002\u0005\u0002\nS%\u0011!F\u0003\u0002\u0004\u0013:$\bc\u0001\u0017.Q5\t!$\u0003\u0002/5\t\u00191+Z9\t\u000fA\u0002\u0001\u0019!C\u0001c\u0005)Bo\u001c9jGB\u000b'\u000f^5uS>t\u0017j\u001d:`I\u0015\fHC\u0001\u001a6!\tI1'\u0003\u00025\u0015\t!QK\\5u\u0011\u001d1t&!AA\u0002Y\t1\u0001\u001f\u00132\u0011\u0019A\u0004\u0001)Q\u0005-\u0005\u0011Bo\u001c9jGB\u000b'\u000f^5uS>t\u0017j\u001d:!\u0011\u001dQ\u0004A1A\u0005\u0002m\n1C]3qY&\u001c\u0017\rT1h)&lW-T1y\u001bN,\u0012\u0001\u0010\t\u0003\u0013uJ!A\u0010\u0006\u0003\t1{gn\u001a\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u001f\u0002)I,\u0007\u000f\\5dC2\u000bw\rV5nK6\u000b\u00070T:!\u0011\u001d\u0011\u0005A1A\u0005\u0002\r\u000bQC]3qY&\u001c\u0017MR3uG\"<\u0016-\u001b;NCbl5/F\u0001)\u0011\u0019)\u0005\u0001)A\u0005Q\u00051\"/\u001a9mS\u000e\fg)\u001a;dQ^\u000b\u0017\u000e^'bq6\u001b\b\u0005C\u0004H\u0001\t\u0007I\u0011A\"\u0002%1,\u0017\rZ3s\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002\u0015\u0002'1,\u0017\rZ3s\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u0011\t\u000f-\u0003!\u0019!C\u0001w\u00051B.Z1eKJdun\u001a%jO\"<\u0016\r^3s[\u0006\u00148\u000e\u0003\u0004N\u0001\u0001\u0006I\u0001P\u0001\u0018Y\u0016\fG-\u001a:M_\u001eD\u0015n\u001a5XCR,'/\\1sW\u0002Bqa\u0014\u0001C\u0002\u0013\u0005\u0001+A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0011)H/\u001b7\u000b\u0003Y\u000bAA[1wC&\u0011\u0001l\u0015\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u0002.\u0001A\u0003%\u0011+\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA!9A\f\u0001b\u0001\n\u0003i\u0016aB2p]\u001aLwm]\u000b\u0002=B\u0019A&L0\u0011\u0005I\u0001\u0017BA1\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\r\r\u0004\u0001\u0015!\u0003_\u0003!\u0019wN\u001c4jON\u0004\u0003bB3\u0001\u0005\u0004%\tAZ\u0001\u0006i>\u0004\u0018nY\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!.V\u0001\u0005Y\u0006tw-\u0003\u0002'S\"1Q\u000e\u0001Q\u0001\n\u001d\fa\u0001^8qS\u000e\u0004\u0003bB8\u0001\u0005\u0004%\t\u0001]\u0001\u0005i&lW-F\u0001r!\t\u0011X/D\u0001t\u0015\t!H!A\u0003vi&d7/\u0003\u0002wg\nAQj\\2l)&lW\r\u0003\u0004y\u0001\u0001\u0006I!]\u0001\u0006i&lW\r\t\u0005\bu\u0002\u0011\r\u0011\"\u0001|\u0003\u001diW\r\u001e:jGN,\u0012\u0001 \t\u0004{\u00065Q\"\u0001@\u000b\u0005i|(\u0002BA\u0001\u0003\u0007\taaY8n[>t'bA\u0003\u0002\u0006)!\u0011qAA\u0005\u0003\u0019\t\u0007/Y2iK*\u0011\u00111B\u0001\u0004_J<\u0017bAA\b}\n9Q*\u001a;sS\u000e\u001c\bbBA\n\u0001\u0001\u0006I\u0001`\u0001\t[\u0016$(/[2tA!I\u0011q\u0003\u0001A\u0002\u0013\u0005\u0011\u0011D\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\tY\u0002E\u0002\u0013\u0003;I1!a\b\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0011\"a\t\u0001\u0001\u0004%\t!!\n\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0004e\u0005\u001d\u0002\"\u0003\u001c\u0002\"\u0005\u0005\t\u0019AA\u000e\u0011!\tY\u0003\u0001Q!\n\u0005m\u0011a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u0005)1/\u001a;VaR\t!\u0007\u000b\u0003\u0002.\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\t\u0005m\u0012\u0011B\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u007f\tID\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003\u0007\u0002A\u0011AA\u0019\u0003!!X-\u0019:E_^t\u0007\u0006BA!\u0003\u000f\u0002B!a\u000e\u0002J%!\u00111JA\u001d\u0005\u0015\te\r^3s\u0011\u001d\ty\u0005\u0001C\u0001\u0003c\t!\u0005^3ti&\u001b(/\u0012=qSJ\fG/[8o\r>\u00148\u000b^;dW\u001a{G\u000e\\8xKJ\u001c\b\u0006BA'\u0003'\u0002B!a\u000e\u0002V%!\u0011qKA\u001d\u0005\u0011!Vm\u001d;\t\u000f\u0005m\u0003\u0001\"\u0001\u00022\u0005)C/Z:u\u0013N\u0014X\t\u001f9je\u0006$\u0018n\u001c8JM:{g)\u001a;dQJ+\u0017/^3ti6\u000bG-\u001a\u0015\u0005\u00033\n\u0019\u0006C\u0004\u0002b\u0001!\t!!\r\u0002CQ,7\u000f^%te\u0016C\b/\u001b:bi&|gNR8s'2|wOR8mY><XM]:)\t\u0005}\u00131\u000b\u0005\b\u0003O\u0002A\u0011AA\u0019\u0003\u0015\"Xm\u001d;JgJ,\u0005\u0010]5sCRLwN\u001c$pe\u000e\u000bWo\u001a5u+B4u\u000e\u001c7po\u0016\u00148\u000f\u000b\u0003\u0002f\u0005M\u0003bBA7\u0001\u0011%\u0011qN\u0001!O\u0016$\b+\u0019:uSRLwN\\,ji\"\fE\u000e\u001c*fa2L7-Y:J]&\u001b(\u000f\u0006\u0007\u0002r\u0005u\u0014qPAB\u0003\u001f\u000b\u0019\n\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9\bB\u0001\bG2,8\u000f^3s\u0013\u0011\tY(!\u001e\u0003\u0013A\u000b'\u000f^5uS>t\u0007BB3\u0002l\u0001\u0007\u0011\u0005C\u0004\u0002\u0002\u0006-\u0004\u0019\u0001\u0015\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b_\u0006-\u0004\u0019AAC!\u0011\t9)a#\u000e\u0005\u0005%%B\u0001;\u0000\u0013\u0011\ti)!#\u0003\tQKW.\u001a\u0005\b\u0003#\u000bY\u00071\u0001`\u0003\u0019\u0019wN\u001c4jO\"A\u0011QSA6\u0001\u0004\t9*\u0001\u0005m_\u000e\fG\u000eT8h!\u0011\tI*a(\u000e\u0005\u0005m%bAAO\t\u0005\u0019An\\4\n\t\u0005\u0005\u00161\u0014\u0002\f\u0003\n\u001cHO]1di2{w\rC\u0004\u0002&\u0002!I!a*\u0002\u000f1|w-T8dWV\u0011\u0011q\u0013")
public class IsrExpirationTest {
    private Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final int leaderLogEndOffset;
    private final long leaderLogHighWatermark;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private ReplicaManager replicaManager;

    public Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int leaderLogEndOffset() {
        return this.leaderLogEndOffset;
    }

    public long leaderLogHighWatermark() {
        return this.leaderLogHighWatermark;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Before
    public void setUp() {
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        Seq aliveBrokers = (Seq)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$2) {
                return x$2.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom());
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn(aliveBrokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int id) {
                return TestUtils$.MODULE$.createBroker(id, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})), id, TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom())).anyTimes();
        aliveBrokers.foreach((Function1)new Serializable(this, metadataCache){
            public static final long serialVersionUID = 0L;
            private final MetadataCache metadataCache$1;

            public final IExpectationSetters<Option<Broker>> apply(int id) {
                return EasyMock.expect((Object)this.metadataCache$1.getAliveBroker(id)).andReturn((Object)Option$.MODULE$.apply((Object)TestUtils$.MODULE$.createBroker(id, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})), id, TestUtils$.MODULE$.createBroker$default$4()))).anyTimes();
            }
            {
                this.metadataCache$1 = metadataCache$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{metadataCache});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), TierReplicaComponents$.MODULE$.EMPTY(), ReplicaManager$.MODULE$.$lessinit$greater$default$13()));
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        AbstractLog log2 = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log2);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$3) {
                return x$3.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicaIds());
        partition0.remoteReplicas().foreach((Function1)new Serializable(this, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;
            private final Partition partition0$1;

            public final void apply(Replica replica) {
                replica.updateFetchState(new LogOffsetMetadata((long)(this.$outer.leaderLogEndOffset() - 1), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.$outer.time().milliseconds(), (long)this.$outer.leaderLogEndOffset(), this.partition0$1.localLogOrException().highWatermark());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition0$1 = partition0$1;
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log2});
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        AbstractLog log2 = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log2);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$4) {
                return x$4.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicaIds());
        this.time().sleep(150L);
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log2});
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        AbstractLog log2 = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log2);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$5) {
                return x$5.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicaIds());
        partition0.remoteReplicas().foreach((Function1)new Serializable(this, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;
            private final Partition partition0$2;

            public final void apply(Replica replica) {
                replica.updateFetchState(new LogOffsetMetadata((long)(this.$outer.leaderLogEndOffset() - 2), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.$outer.time().milliseconds(), (long)this.$outer.leaderLogEndOffset(), this.partition0$2.localLogOrException().highWatermark());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition0$2 = partition0$2;
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        this.time().sleep(75L);
        partition0.remoteReplicas().foreach((Function1)new Serializable(this, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;
            private final Partition partition0$2;

            public final void apply(Replica r) {
                r.updateFetchState(new LogOffsetMetadata((long)(this.$outer.leaderLogEndOffset() - 1), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.$outer.time().milliseconds(), (long)this.$outer.leaderLogEndOffset(), this.partition0$2.localLogOrException().highWatermark());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition0$2 = partition0$2;
            }
        });
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        this.time().sleep(75L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR);
        partition0.remoteReplicas().foreach((Function1)new Serializable(this, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;
            private final Partition partition0$2;

            public final void apply(Replica r) {
                r.updateFetchState(new LogOffsetMetadata((long)this.$outer.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.$outer.time().milliseconds(), (long)this.$outer.leaderLogEndOffset(), this.partition0$2.localLogOrException().highWatermark());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition0$2 = partition0$2;
            }
        });
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log2});
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        AbstractLog log2 = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log2);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$6) {
                return x$6.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicaIds());
        partition0.remoteReplicas().foreach((Function1)new Serializable(this, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;
            private final Partition partition0$3;

            public final void apply(Replica replica) {
                replica.updateFetchState(new LogOffsetMetadata((long)this.$outer.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.$outer.time().milliseconds(), (long)this.$outer.leaderLogEndOffset(), this.partition0$3.localLogOrException().highWatermark());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition0$3 = partition0$3;
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log2});
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, Time time, KafkaConfig config, AbstractLog localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().createPartition(tp);
        partition.setLog(localLog, false);
        partition.updateAssignmentAndIsr((Seq)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$7) {
                return x$7.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom()), ((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$8) {
                return x$8.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Set().empty());
        partition.remoteReplicas().foreach((Function1)new Serializable(this, time, partition){
            public static final long serialVersionUID = 0L;
            private final Time time$1;
            private final Partition partition$1;

            public final void apply(Replica replica) {
                replica.updateFetchState(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time$1.milliseconds(), 0L, this.partition$1.localLogOrException().highWatermark());
            }
            {
                this.time$1 = time$1;
                this.partition$1 = partition$1;
            }
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog logMock() {
        void var1_1;
        AbstractLog log2 = (AbstractLog)EasyMock.createMock(AbstractLog.class);
        EasyMock.expect((Object)log2.dir()).andReturn((Object)TestUtils$.MODULE$.tempDir()).anyTimes();
        EasyMock.expect((Object)log2.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata((long)this.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)this.leaderLogEndOffset())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log2.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)this.leaderLogHighWatermark())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log2});
        return var1_1;
    }

    public IsrExpirationTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.leaderLogEndOffset = 20;
        this.leaderLogHighWatermark = 20L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.replicaManager = null;
    }
}

