/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.zookeeper.common.ZKConfig;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0001\u0002\u0001\u000f\ty1*\u00194lCN+'O^3s)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0011!p[\u0005\u0003\u001b)\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u0015!\u0002\u0001\"\u0001\u0016\u0003!\"Xm\u001d;BYJ,\u0017\rZ=SK\u001eL7\u000f^3sK\u0012\fEM^3si&\u001cX\r\u001a'jgR,g.\u001a:t)\u00051\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"\u0001B+oSRD#aE\u000f\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013!\u00026v]&$(\"\u0001\u0012\u0002\u0007=\u0014x-\u0003\u0002%?\t!A+Z:u\u0011\u00151\u0003\u0001\"\u0001\u0016\u0003!\"Xm\u001d;De\u0016\fG/Z:Qe>\u0004XM\u001d.l)2\u001c8i\u001c8gS\u001e<\u0006.\u001a8ESN\f'\r\\3eQ\t)S\u0004C\u0003*\u0001\u0011\u0005Q#\u0001\u0016uKN$8I]3bi\u0016\u001c\bK]8qKJT6\u000e\u00167t\u0007>tg-[4XSRDGK];f-\u0006dW/Z:)\u0005!j\u0002\"\u0002\u0017\u0001\t\u0003)\u0012A\r;fgR\u001c%/Z1uKN\u0004&o\u001c9fej[G\u000b\\:D_:4\u0017nZ,ji\"4\u0015\r\\:f\u0003:$G*[:u-\u0006dW/Z:)\u0005-j\u0002\"B\u0018\u0001\t\u0003\u0001\u0014\u0001D2sK\u0006$XmU3sm\u0016\u0014H\u0003B\u00195s\t\u0003\"A\u0005\u001a\n\u0005M\u0012!aC&bM.\f7+\u001a:wKJDQ!\u000e\u0018A\u0002Y\naA\\8eK&#\u0007CA\f8\u0013\tA\u0004DA\u0002J]RDQA\u000f\u0018A\u0002m\n\u0001\u0002[8ti:\u000bW.\u001a\t\u0003y}r!aF\u001f\n\u0005yB\u0012A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!A\u0010\r\t\u000b\rs\u0003\u0019\u0001\u001c\u0002\tA|'\u000f\u001e")
public class KafkaServerTest
extends ZooKeeperTestHarness {
    @Test
    public void testAlreadyRegisteredAdvertisedListeners() {
        KafkaServer server1 = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, server1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServerTest $outer;
            private final KafkaServer server1$1;

            public final KafkaServer apply() {
                return this.$outer.createServer(2, "myhost", TestUtils$.MODULE$.boundPort(this.server1$1, TestUtils$.MODULE$.boundPort$default$2()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.server1$1 = server1$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        KafkaServer server2 = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2}))));
    }

    @Test
    public void testCreatesProperZkTlsConfigWhenDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        props.put(KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "false");
        Assert.assertEquals((Object)None$.MODULE$, (Object)KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2()));
    }

    @Test
    public void testCreatesProperZkTlsConfigWithTrueValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1)new Serializable(this, props, someValue){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServerTest $outer;
            private final Properties props$1;
            private final String someValue$1;

            public final Object apply(String kafkaProp) {
                return this.props$1.put(kafkaProp, this.$outer.kafka$server$KafkaServerTest$$kafkaConfigValueToSet$1(kafkaProp, this.someValue$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.props$1 = props$1;
                this.someValue$1 = someValue$1;
            }
        });
        Option zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1)new Serializable(this, someValue, zkClientConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServerTest $outer;
            private final String someValue$1;
            private final Option zkClientConfig$1;

            public final void apply(String kafkaProp) {
                Assert.assertEquals((Object)this.$outer.kafka$server$KafkaServerTest$$zkClientValueToExpect$1(kafkaProp, this.someValue$1), (Object)((ZKConfig)this.zkClientConfig$1.get()).getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.someValue$1 = someValue$1;
                this.zkClientConfig$1 = zkClientConfig$1;
            }
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithFalseAndListValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1)new Serializable(this, props, someValue){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServerTest $outer;
            private final Properties props$2;
            private final String someValue$2;

            public final Object apply(String kafkaProp) {
                return this.props$2.put(kafkaProp, this.$outer.kafka$server$KafkaServerTest$$kafkaConfigValueToSet$2(kafkaProp, this.someValue$2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.props$2 = props$2;
                this.someValue$2 = someValue$2;
            }
        });
        Option zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1)new Serializable(this, someValue, zkClientConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServerTest $outer;
            private final String someValue$2;
            private final Option zkClientConfig$2;

            public final void apply(String kafkaProp) {
                Assert.assertEquals((Object)this.$outer.kafka$server$KafkaServerTest$$zkClientValueToExpect$2(kafkaProp, this.someValue$2), (Object)((ZKConfig)this.zkClientConfig$2.get()).getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.someValue$2 = someValue$2;
                this.zkClientConfig$2 = zkClientConfig$2;
            }
        });
    }

    public KafkaServer createServer(int nodeId, String hostName, int port) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PLAINTEXT://", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostName, BoxesRunTime.boxToInteger((int)port)})));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        return TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
    }

    public final String kafka$server$KafkaServerTest$$kafkaConfigValueToSet$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = kafkaProp;
        String string3 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            bl = true;
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                bl = true;
            } else {
                String string7 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                String string8 = string2;
                bl = !(string7 != null ? !string7.equals(string8) : string8 != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string9 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            String string10 = string2;
            string = !(string9 != null ? !string9.equals(string10) : string10 != null) ? "HTTPS" : someValue$1;
        }
        return string;
    }

    public final String kafka$server$KafkaServerTest$$zkClientValueToExpect$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = kafkaProp;
        String string3 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            bl = true;
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                bl = true;
            } else {
                String string7 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                String string8 = string2;
                bl = !(string7 != null ? !string7.equals(string8) : string8 != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string9 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            String string10 = string2;
            string = !(string9 != null ? !string9.equals(string10) : string10 != null) ? "true" : someValue$1;
        }
        return string;
    }

    public final String kafka$server$KafkaServerTest$$kafkaConfigValueToSet$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = kafkaProp;
        String string3 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            string = "true";
        } else {
            boolean bl;
            String string5 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                bl = true;
            } else {
                String string7 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                String string8 = string2;
                bl = !(string7 != null ? !string7.equals(string8) : string8 != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string9 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                String string10 = string2;
                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                    string = "";
                } else {
                    boolean bl2;
                    String string11 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    String string12 = string2;
                    if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                        bl2 = true;
                    } else {
                        String string13 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        String string14 = string2;
                        bl2 = !(string13 != null ? !string13.equals(string14) : string14 != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }

    public final String kafka$server$KafkaServerTest$$zkClientValueToExpect$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = kafkaProp;
        String string3 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            string = "true";
        } else {
            boolean bl;
            String string5 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                bl = true;
            } else {
                String string7 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                String string8 = string2;
                bl = !(string7 != null ? !string7.equals(string8) : string8 != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string9 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                String string10 = string2;
                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                    string = "false";
                } else {
                    boolean bl2;
                    String string11 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    String string12 = string2;
                    if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                        bl2 = true;
                    } else {
                        String string13 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        String string14 = string2;
                        bl2 = !(string13 != null ? !string13.equals(string14) : string14 != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }
}

