/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=2A!\u0001\u0002\u0001\u000f\t)C*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)&,'/\u001a3QCJ$\u0018\u000e^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000bE\u0001A\u0011\t\n\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHCA\n\u001a!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0011)f.\u001b;\t\u000bi\u0001\u0002\u0019A\u000e\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u0005!Q\u000f^5m\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0003%\u0001\u0011\u0005Q%\u0001\u0015uKN$H*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u\r>\u0014H+[3sK\u0012\u0004\u0016M\u001d;ji&|g\u000eF\u0001\u0014Q\t\u0019s\u0005\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005)!.\u001e8ji*\tA&A\u0002pe\u001eL!AL\u0015\u0003\tQ+7\u000f\u001e")
public class ListOffsetsRequestTieredPartitionTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.serverConfig().stringPropertyNames()).asScala()).foreach((Function1)new Serializable(this, properties){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ListOffsetsRequestTieredPartitionTest $outer;
            private final Properties properties$1;

            public final Object apply(String key) {
                return this.properties$1.put(key, this.$outer.serverConfig().get(key));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.properties$1 = properties$1;
            }
        });
    }

    @Test
    public void testListOffsetsRequestForTieredPartition() {
        String topicName = "tiered-topic";
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "16384");
        props.put("confluent.tier.local.hotset.bytes", "16384");
        props.put("confluent.tier.local.hotset.ms", "-1");
        props.put("retention.bytes", "-1");
        Map<Object, Object> partitionToLeaderMap = this.createTopic(topicName, 1, 1, props);
        int numMessages = 3000;
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers().toSeq(), topicName, numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        int leaderId = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        KafkaServer server = (KafkaServer)this.serverForId(leaderId).get();
        LogManager qual$1 = server.logManager();
        TopicPartition x$1 = topicPartition;
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log2 = (AbstractLog)qual$1.getLog(x$1, x$2).get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages, log2){
            public static final long serialVersionUID = 0L;
            private final int numMessages$1;
            private final AbstractLog log$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.log$1.logEndOffset() == (long)this.numMessages$1 && this.log$1.tieredLogSegments().nonEmpty() && this.log$1.localLogSegments().size() < this.log$1.numberOfSegments();
            }
            {
                this.numMessages$1 = numMessages$1;
                this.log$1 = log$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timeout waiting for some segments to tier and be deleted from local disk";
            }
        }, 180000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log2, (short)0);
        log2.maybeIncrementHighWatermark(new LogOffsetMetadata(log2.logStartOffset() + 100L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        log2.maybeIncrementLogStartOffset(log2.logStartOffset() + 100L);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log2, (short)0);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -2L, leaderId, log2, (short)0);
    }

    public ListOffsetsRequestTieredPartitionTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
    }
}

